/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* List.h,v 1.6 1994/10/27 23:25:29 pgw Exp */

#if !defined(_LIST_H_)
#define _LIST_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>

class ListClass : public PrimitiveClass {
 protected:
   ListClass() {} 
 public:
   /* callbacks */
   void browseSelectionCallback(XtCallbackProc, XtPointer);
   void defaultActionCallback(XtCallbackProc, XtPointer);
   void extendedSelectionCallback(XtCallbackProc, XtPointer);
   void multipleSelectionCallback(XtCallbackProc, XtPointer);
   void singleSelectionCallback(XtCallbackProc, XtPointer);

   /* convenience routines */

   /* resources */
   void automaticSelection(Boolean);
   Boolean automaticSelection();
   void doubleClickInterval(int);
   int doubleClickInterval();
   void fontList(XmFontList);
   XmFontList fontList();
   void itemCount(int);
   int itemCount();
   void items(XmStringTable);
   XmStringTable items();
   void listMarginHeight(Dimension);
   Dimension listMarginHeight();
   void listMarginWidth(Dimension);
   Dimension listMarginWidth();
   unsigned char listSizePolicy();
   void listSpacing(Dimension);
   Dimension listSpacing();
   void scrollBarDisplayPolicy(unsigned char);
   unsigned char scrollBarDisplayPolicy();
   void selectedItemCount(int);
   int selectedItemCount(); 
   void selectedItems(XmStringTable);
   XmStringTable selectedItems();
   void selectionPolicy(unsigned char);
   unsigned char selectionPolicy();
   void stringDirection(XmStringDirection);
   XmStringDirection stringDirection();
   void topItemPosition(int);
   int topItemPosition();
   void visibleItemCount(int);
   int visibleItemCount();

   /* extra functionality */
   void add(char *);  /* adds an item to the list box */
   void add(char ** l, int c); /* [][]= { "foo","yo" }; */
   void clear();     /* clears out the list box */
   int count();      /* returns the count of the items in the list */
   void del(int);     /* deletes an item at position p */
   void del(int n,int p); /* deletes n items starting at position p */
   void del(char *);
   void del(char **, int); /* [][]= { "foo","yo" }; */
   void deselect(const char *);
   void deselect(int);
   int exists(const char *); /* does the item exists in the list */
   void insert(char * s, int p);  /* inserts an item at a location */
   void insert(char ** l, int c, int p); /* [][]= {"foo","yo" }; */
   int item(const char *s); /* returns the position of s */
   void horizontal(int); /* position of the scroll bar */
   int match(char *item, int *&p, int &c); 
   void replace(char **n, int c, int p);
   void replace(char **o, int c, char **n); /* replace old items w/ new */
   Boolean selected(int *&, int &);  /* returns the selected items, delete array */
   void select(const char *s, int notify); /* selects the item in the list */
   void select(int p, int notify); /* selects the item at that position */
   void set(char *); /* sets the item to be the first visible item if posible */
   void set(int); /* sets the item to be the first visible item if posible */
   void setBottom(char *);
   void setBottom(int);
   
};

class List : public ListClass {
 public:
   List(Widget parent, ArgList arglist = NULL, Cardinal = 0);
};

#endif
