/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* FileSB.h,v 1.6 1994/10/27 23:25:22 pgw Exp */

#if !defined(_FILESB_H_)
#define _FILESB_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/SelectioB.h>

class FileSelectionBoxClass : public SelectionBoxClass {
 protected:
   FileSelectionBoxClass() {}
 public:
   /* convenience routines */
   virtual Widget getChild(unsigned char);
   void doSearch(char *str); 

   /* resources */
   void directory(char *);
   char *directory();
   void directoryValid(Boolean);
   Boolean directoryValid();
   void dirListItems(XmStringTable);
   XmStringTable dirListItems();
   void dirListItemCount(int);
   int dirListItemCount();
   void dirListLabelString(char *);
   char *dirListLabelString();
   void dirMask(char *);
   char *dirMask();
   void dirSearchProc(XmSearchProc);
   XmSearchProc dirSearchProc();
   void dirSpec(char *);
   char *dirSpec();
   void fileListItems(XmStringTable);
   XmStringTable fileListItems();
   void fileListItemCount(int);
   int fileListItemCount();
   void fileListLabelString(char *);
   char *fileListLabelString();
   void fileSearchProc(XmSearchProc);
   XmSearchProc fileSearchProc();
   void fileTypeMask(unsigned char);
   unsigned char fileTypeMask();
   void filterLabelString(char *);
   char *filterLabelString();
   void listUpdated(Boolean);
   Boolean listUpdated();
   void noMatchString(char *);
   char *noMatchString();
   void pattern(char *);
   char * pattern();
   void qualifySearchDataProc(XmQualifyProc);
   XmQualifyProc qualifySearchDataProc();
   
 
};

class FileSelectionBox : public FileSelectionBoxClass {
 public:
   FileSelectionBox(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};

class FileSelectionDialog : public FileSelectionBoxClass {
 public:
   FileSelectionDialog(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};

#endif
