/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* Command.h,v 1.6 1994/10/27 23:25:13 pgw Exp */

#if !defined(_COMMAND_H_)
#define _COMMAND_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/SelectioB.h>

class CommandBoxClass : public SelectionBoxClass {
 protected:
   CommandBoxClass() {}
 public:
   /* Callacks */
   void changedCallback(XtCallbackProc fp, XtPointer udata);
   void enteredCallback(XtCallbackProc fp, XtPointer udata);

   /* resources */
   void command(char *str);
   char *command();
   void historyItems(XmStringTable);
   XmStringTable historyItems();
   void historyItemCount(int);
   int historyItemCount();
   void historyMaxItems(int);
   int historyMaxItems();
   void historyVisibleItemCount(int);
   int historyVisibleItemCount();
   void promptString(char *);
   char *promptString();
};

class CommandBox : public CommandBoxClass {
 public:
   CommandBox(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};

#endif
