/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* Base.h,v 1.7 1994/10/29 18:33:36 pgw Exp */

#if !defined(_BASE_H_)
#define _BASE_H_

/* ======================================================================= */
/* Include(s): */
#include <X11/X.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/XmP.h>
#include <Xm/MainW.h>
#include <Xm/MenuShell.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/SeparatoG.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/PushB.h>
#include <Xm/TextF.h>
#include <Xm/Text.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/Frame.h>
#include <Xm/List.h>
#include <Xm/DrawingA.h>
#include <Xm/Scale.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/FileSB.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/Protocols.h>
#include <Xm/ProtocolsP.h>
#include <Xm/AtomMgr.h>
#include <Xm/Command.h>
#include <Xm/DragIcon.h>
#include <Xm/DragDrop.h>
#include <Xm/ArrowB.h>
#include <Xm/ArrowBG.h>
#include <Xm/DrawnB.h>
#include <Xm/PanedW.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>

#if !defined(DELETE_ON_CLOSE)
/*
*  If DELETE_ON_CLOSE is defined to be TRUE then the object will clean up 
*  allocated memory and the object is associated with the widget.  This 
*  assumes that new was used to create the object.
*  Otherwise the programmer must handle the memory management and
*  object association.
*
*  Delete if going out of scope and/or delete operator is used.
*  This should always be true unless you know what you're doing.
*/
#define DELETE_ON_CLOSE TRUE
#endif

/*
*  typedef's for the conversion routines. As you can see I did not like
*  the idea of using XmString.  Hence, I provided a nice utility
*  for doing the conversions to and from XmString. 
*/
typedef char * (*XmStringToStringFunc)(XmString);
typedef XmString (*StringToXmStringFunc)(char *);

/* Define the Window Object type */
class BaseClass;
typedef BaseClass *WObject;

/* 
*  This routine returns the WObject only if the widget is associated with one,
*  otherwise NULL is returned.
*/
WObject WidgetToWObject(Widget);

class BaseClass {
 private:
   friend WObject WidgetToWObject(Widget w);
   Widget wid;
   static void destructor(Widget w,XtPointer data,XtPointer cdata);
   int isDelete;
   XmStringToStringFunc cvtXmStringToStringfp;
   StringToXmStringFunc cvtStringToXmStringfp;
 protected:
   /* ATTENTION, default settings for cvt functions... */
   BaseClass():wid(NULL),isDelete(FALSE),
               cvtXmStringToStringfp((XmStringToStringFunc)XmCvtXmStringToCT),
               cvtStringToXmStringfp((StringToXmStringFunc)XmCvtCTToXmString) {}
   void widget(Widget w) {
      if(wid) deleteOnClose(FALSE); 
      wid = w; 
      deleteOnClose(); /* set to whatever is the desired default */
   }
 public:
   /* ATTENTION, default behavior is (TRUE) user defined, TRUE = delete this 
      pointer when widget is destroyed. */
   void deleteOnClose(int option = DELETE_ON_CLOSE); 

   virtual ~BaseClass() { 
      if(widget()->core.being_destroyed == FALSE) {
         removeDestructor(); XtDestroyWidget(*this);
      }
   }
   operator Widget(); // auto cast self to widget 
   operator Display*(); // auto cast self to Display *
   Display *display() { return XtDisplay(widget()); }

   Widget widget() { return wid; }

   Widget parent() { return XtParent(widget()); }

   void addCallback(char *type, XtCallbackProc funcp, XtPointer data = NULL) {
      XtAddCallback(widget(),type,funcp,data);
   }
   void removeCallback(char *type,XtCallbackProc funcp,XtPointer data = NULL) {
      XtRemoveCallback(widget(),type,funcp,data);
   }

   void destroyCallback(XtCallbackProc funcp, XtPointer data = NULL);  

   void addDestructor() { 
      addCallback(XmNdestroyCallback,(XtCallbackProc) destructor,this); 
   }
   void removeDestructor() { 
      removeCallback(XmNdestroyCallback, (XtCallbackProc) destructor, 
      (XtPointer)this); 
   }
   void manage() { XtManageChild(*this); }
   void unmanage() { XtUnmanageChild(*this); }

   /* Most functions that denote a parameter of char * use the cvt functions */
   /* Be careful when changing the cvt function! */
   
   /* Portability functions for different locales */
   void cvtXmStringToStringFunc(XmStringToStringFunc fp) { 
      cvtXmStringToStringfp = fp;
   }
   void cvtStringToXmStringFunc(StringToXmStringFunc fp) { 
      cvtStringToXmStringfp = fp;
   }
   /* All functions that use this cvt routine will clean up the allocated 
      memory.  Hence, don't worry about it.  Look at the source. */
   XmString cvtStringToXmString(char *str) {
      return (*cvtStringToXmStringfp)(str);
   }
   /* Clean up allocated memory pointed to by the return value when done. */
   char * cvtXmStringToString(XmString str) {
      return (*cvtXmStringToStringfp)(str);
   }
};

#endif
