#include <malloc.h>

#include "xvhelp.h"
#include "graph.h"
#include "ourpanel.h"
#include "visual.h"
#include "code.h"
#include "page.h"
#include "topic.h"
#include "hotarea.h"
#include "vector.h"

#define TEXTLENGTH	50
#define LINELENGTH	80
 
FILE *hdf=NULL;
vector pagev=NULL,topicv=NULL;
int currpage,nofile;
Window canvas_win=NULL;


static int history[HISTORY],currhist;
static int curr_area=-1;

extern int tslist_items;
extern Panel_item tslist;
extern vector hotvector;

static void incr_hist()
	{
	int i;
	
	if(currhist+1==HISTORY)
		{
		for(i=1;i<HISTORY;i++)
			history[i-1]=history[i];
		currhist--;
		}
	history[++currhist]=currpage;
	}

void tsnotify(item,op,event)
	Panel_item item;
	Panel_list_op op;
	Event *event;
	{
	char *pagename;
	int pos,i;
	page newp;

	for(i=0;(i<tslist_items)&&(!xv_get(tslist,PANEL_LIST_SELECTED,i));i++);
	if(i<0 || i==tslist_items) return;
  	pagename=topic_page(vector_read(topicv,i));
	newp=new_page(pagename,0);
	pos=vector_search(pagev,newp,page_cmp);
	if(pos>=0)
		{
		currpage=pos;
		incr_hist();
		discard_page();
		read_page();
		display_page();
		}
	page_free(newp);
	}	

void do_back(item,event)
	Panel_item item;
	Event *event;
	{
	if(nofile) return;
	if(currhist>0)
		{
		currpage=history[--currhist];
		discard_page();
		read_page();
		display_page();
		}
	}

void free_resources()
	{
	if(!nofile) fclose(hdf);
	discard_page();
	if(pagev!=NULL) vector_free(pagev,page_free);
	if(topicv!=NULL) vector_free(topicv,topic_free);
	if(hotvector!=NULL) vector_free(hotvector,hotarea_free);
	}

void do_quit(item,event)
	Panel_item item;
	Event *event;
	{
	int result;

	result=notice_prompt(frame,NULL,
		NOTICE_MESSAGE_STRINGS,"Are you sure you want to quit?",NULL,
		NOTICE_BUTTON_YES,"Yes",
		NOTICE_BUTTON_NO,"No",
		NOTICE_NO_BEEPING,TRUE,
		NULL);
	if(result==NOTICE_NO) return;
	free_resources();
 	xv_destroy_safe(frame);
	}

void do_index(item,event)
	Panel_item item;
	Event *event;
	{
	if(nofile) return;
	currpage=0;
	incr_hist();
	discard_page();
	read_page();
	display_page();
	}

void do_next(item,event)
	Panel_item item;
	Event *event;
	{
	if(nofile) return;
	if(currpage+1>=vector_num(pagev))
		return;
	currpage++;
	incr_hist();
	discard_page();
	read_page();
	display_page();
	}

void do_previous(item,event)
	Panel_item item;
	Event *event;
	{
	if(nofile) return;
	if(currpage==0)
		return;
	currpage--;
	incr_hist();
	discard_page();
	read_page();
	display_page();
	}

void xverror(str)
	char *str;
	{
	notice_prompt(frame,NULL,
		NOTICE_MESSAGE_STRINGS,"XVHelp error:",str,"Now I try to exit...",NULL,
		NOTICE_BUTTON_YES,"Exit program",
		NULL);
	xv_destroy_safe(frame);
	exit(-1);
	}

void xvwarning(str)
	char *str;
	{
	notice_prompt(frame,NULL,
		NOTICE_MESSAGE_STRINGS,"XVHelp warning:",str,NULL,
		NOTICE_BUTTON_YES,"Continue",
		NULL);
	}


int file_open(name)
	char *name;
	{
	char *hdfname,*hrfname;
	FILE *hrf,*hdfprev;
	char buffer[250];

	/* The program puts in memory the previous file. */

	hdfprev=hdf;

	/* The program opens the file .hdf */

	hdfname=(char*)malloc(strlen(name)+strlen(DESDEF)+1);
	if(hdfname==NULL) xverror("Allocation error");
	strcpy(hdfname,name);
	strcat(hdfname,DESDEF);
	hdf=fopen(hdfname,"r");
	if(hdf==NULL)
		{
		free(hdfname);
		hdfname=(char*)malloc(strlen(HELP_PATH)+strlen(name)+
					strlen(DESDEF)+1);
		if(hdfname==NULL) xverror("Allocation error");
		strcpy(hdfname,HELP_PATH);
		strcat(hdfname,name);
		strcat(hdfname,DESDEF);
		hdf=fopen(hdfname,"r");	
		if(hdf==NULL)
			{	
			sprintf(buffer,"Can't open file %s.hdf",name);
			xvwarning(buffer);
			hdf=hdfprev;
			free(hdfname);
			return(-1);
			}
		}
	free(hdfname);
	
	/* The program opens file .hrf */

	hrfname=(char*)malloc(strlen(name)+strlen(DESREF)+1);
	if(hrfname==NULL) xverror("Allocation error");
	strcpy(hrfname,name);
	strcat(hrfname,DESREF);
	hrf=fopen(hrfname,"r");
	if(hrf==NULL)
		{
                free(hrfname);
                hrfname=(char*)malloc(strlen(HELP_PATH)+strlen(name)+
                                        strlen(DESREF)+1);
                if(hrfname==NULL) xverror("Allocation error");
                strcpy(hrfname,HELP_PATH);
                strcat(hrfname,name);
                strcat(hrfname,DESREF);
                hrf=fopen(hrfname,"r");
                if(hrf==NULL)
                        {
			sprintf(buffer,"Can't open file %s.hrf",name);
			xvwarning(buffer);
			hdf=hdfprev;
			free(hrfname);
			return(-1);
			}
		}
	free(hrfname);
	nofile=0;
	/* The program frees the vectors. */
	
	if(pagev!=NULL)
		vector_free(pagev,page_free);
	if(topicv!=NULL)
		vector_free(topicv,topic_free);
	pagev=NULL;
	topicv=NULL;

	/* The program loads the vectors from the file .hrf */

	pagev=vector_get(hrf,page_get);
	topicv=vector_get(hrf,topic_get);
	fclose(hrf);

	/* it shows the topic list into the tsframe */
	
	set_topic_list(topicv); 

	/* Initialization and reading of the pages. */

	currpage=0;
	currhist=0;
	read_page();  
	if(hdfprev!=NULL) fclose(hdfprev);
	return(0);
	}

void do_file_open(item,event)
	Panel_item item;
	Event *event;
	{
	xv_set(loadframe,XV_SHOW,TRUE,NULL);
	}

Panel_setting loadnotify(item,event)
	Panel_item item;
	Event *event;
	{

 	if(file_open((char*)xv_get(item,PANEL_VALUE))!=-1)
		{
		xv_set(loadframe,XV_SHOW,FALSE,NULL);
		display_page();
		}
	return(panel_text_notify(item,event));
	}

void proc_help(menu,menu_item)
	Menu menu;
	Menu_item menu_item;
	{
	char *choice=(char*)xv_get(menu_item,MENU_STRING);

 	if(strcmp(choice,"Help on help")==0)
		{
		file_open("help");
		display_page();
		}
	else if(strcmp(choice,"Index")==0) do_index(/* Nil instead of item,event... */);
	else if(strcmp(choice,"Back")==0) do_back(/* Nil instead of item,event... */);
	else if(strcmp(choice,"Previous")==0) do_previous(/* Nil instead of item,event... */);
	else if(strcmp(choice,"Next")==0) do_next(/* Nil instead of item,event... */);
	else if(strcmp(choice,"Search")==0) do_search(/* Nil instead of item,event... */);
	}

/* PLEASE: do not modify or delete the following function */

void about(item,event)
	Panel_item item;
	Event * event;
	{
	notice_prompt(panel,NULL,
		NOTICE_MESSAGE_STRINGS,"XVHELP: An Help For Xview",
					"","version 1.00",
					" 1993 by SURLINELLI R., MARANZANO L., CARDINO G.",
					"","CALAMAROSOFT - ITALY","",
					"calamaro@dist.dist.unige.it",
					NULL,
		NOTICE_BUTTON_YES,"Continue",
		NOTICE_NO_BEEPING,TRUE,
		NULL);
	}

void canvas_repaint(canvas,paint_window,dpy,xwin,xrects)
	Canvas canvas;
	Xv_Window paint_window;
	Display *dpy;
	Window xwin;
	Xv_xrectlist *xrects;
	{
	canvas_win=xwin;
	display_page();
 	}

 static char **split(s)
	char *s;
	{
	char word[LINELENGTH];
	char *temp[TEXTLENGTH];
	int i,j,curr;
	
	temp[0]=(char*)malloc(LINELENGTH+1);
	if(temp[0]==NULL) xverror("Allocation error");
	strcpy(temp[0],"\0");
	for(i=0,curr=0;i<strlen(s) && curr<TEXTLENGTH;)
		{
		for(j=0;!isspace(s[i]) && i<strlen(s) && j<LINELENGTH;i++,j++)
			word[j]=s[i];
		while(isspace(s[i++]));
		i--;
		word[j]='\0';
		if(strlen(temp[curr])+strlen(word)<LINELENGTH)
			{
			strcat(temp[curr],word);
			strcat(temp[curr]," ");
			}
		else
			{
			curr++;
			temp[curr]=(char*)malloc(LINELENGTH+1);
			if(temp[curr]==NULL) xverror("Allocation error");
			strcpy(temp[curr],word);
			strcat(temp[curr]," ");
			}
		}
	temp[curr+1]=NULL;
	return(temp);
	}

static void freesplit(s)
	char **s;
	{
	int i;
	
	for(i=0;s[i]!=NULL;i++)
		free(s[i]);
	}

void event_handler(window,event)
	Xv_Window window;
	Event *event;
	{
	int result,x,y,found,i;
	page newp;
	hotarea area;
	int pos;
	char **def;

	if(nofile) return;
	switch(event_action(event))
		{
		case ACTION_SELECT:
		case MS_LEFT:
			if(curr_area<0) return;
			area=(hotarea)vector_read(hotvector,curr_area);
 			switch(hotarea_action(area))
				{
				case ACTDEF:
					def=split(hotarea_param(area));
					result=notice_prompt(canvas,NULL,
						NOTICE_MESSAGE_STRINGS_ARRAY_PTR,def,
						NOTICE_BUTTON_YES,"Continue",
						NOTICE_NO_BEEPING,TRUE,
						NULL);
					freesplit(def);
					break;
				case ACTGOTO:
					newp=new_page(hotarea_param(area),0);
					pos=vector_search(pagev,newp,page_cmp);
					if(pos>=0)
						{
						currpage=pos;
						incr_hist();
						discard_page();
						read_page();
						display_page();
						}
					page_free(newp);
					break;
				case ACTLINK:
					file_open(hotarea_param(area));
					if(vector_num(topicv)==0) xv_set(tsframe,XV_SHOW,FALSE,NULL);	
					display_page();
					break;
				}
			curr_area=-1;
			break;
					
		case LOC_MOVE:
			x=event_x(event);
			y=event_y(event);
			for(i=0,found=0;i<vector_num(hotvector) && !found;i++)
				if(is_in_area(vector_read(hotvector,i),x,y))
					{
					/*xv_set(xv_get(canvas,CANVAS_NTH_PAINT_WINDOW,0),
						WIN_CURSOR,hotcursor,NULL);*/
					switch(hotarea_action(vector_read(hotvector,i)))
						{
						case ACTGOTO:
						XDefineCursor(dpy,xv_get(xv_get(canvas,CANVAS_NTH_PAINT_WINDOW,0),XV_XID),gotocursor);
						break;
						case ACTDEF:
						XDefineCursor(dpy,xv_get(xv_get(canvas,CANVAS_NTH_PAINT_WINDOW,0),XV_XID),defcursor);
						break;
						case ACTLINK:
						XDefineCursor(dpy,xv_get(xv_get(canvas,CANVAS_NTH_PAINT_WINDOW,0),XV_XID),linkcursor);
						break;
						}
					found=1;
					curr_area=i;
					}
			if(!found)
				{
				/*xv_set(xv_get(canvas,CANVAS_NTH_PAINT_WINDOW,0),
					WIN_CURSOR,normcursor,NULL);*/
				XDefineCursor(dpy,xv_get(xv_get(canvas,CANVAS_NTH_PAINT_WINDOW,0),XV_XID),normcursor);
				curr_area=-1;
				}		 	
			break;
		}
	}

void do_search(item,event)
	Panel_item item;
	Event * event;
	{
	if(nofile || vector_num(topicv)==0) return;
 	xv_set(tsframe,XV_SHOW,TRUE,NULL);
	}

int main(argc,argv)
	int argc;
	char* argv[];
	{
 	xv_init(XV_INIT_ARGC_PTR_ARGV,&argc,argv,NULL);
	interface(); 
 
	nofile=0;
	if(argc==2)
		{
		if(file_open(argv[1])==-1)
			nofile=1;
		}
	else if(file_open("help")==-1) nofile=1;

	/* It sets the handler of the data structure. */

	vector_error(xverror);
	page_error(xverror);
	topic_error(xverror);
	hotarea_error(xverror);

	xv_main_loop(frame); 
	exit(0);
	}
