#include "viewer.h"

#define TABSTEP		8
#define MAXLUNGH	200
#define DELTAY		3
#define LEFTMARGIN	10
#define RIGHTMARGIN	10
#define UPPERMARGIN	10
#define HOTVECTOR	256

static int column;
static char buffer[MAXLUNGH];
static int bufpos;
static fontdef currentfont;
static int xcoor,ycoor;
static Window xwin;
static char *curr_param;
static int curr_action,curr_sx,curr_sy,curr_command,page_too_long;

vector hotvector=NULL;

extern fontdef text_font,source_font,title_font,sub_font;
extern fontdef hgo_font,hdef_font,hlink_font;

static int wordinline(s)
	char *s;
	{
	Font_string_dims dims;
	int pagewidth;
	
	xv_get(currentfont.font,FONT_STRING_DIMS,s,&dims);
	pagewidth=xv_get((Xv_Window)xv_get(canvas,OPENWIN_NTH_VIEW,0),
		XV_WIDTH);	
  	return(xcoor+dims.width<(pagewidth-RIGHTMARGIN));
	}

static void newline()
	{
	int height;
	
	if(curr_command==COMHOT)
		vector_insert(hotvector,new_hotarea(curr_sx,curr_sy,xcoor,ycoor,curr_action,curr_param));
	height=xv_get(currentfont.font,FONT_DEFAULT_CHAR_HEIGHT);
	ycoor+=height+DELTAY;
	if(ycoor>CANVASHEIGHT && page_too_long!=1)
		{
		fprintf(stderr,"XVhelp warning:Page too long to be displayed\n");
		page_too_long=1;
		}
	xcoor=LEFTMARGIN;
	column=TABSTEP;
	if(curr_command==COMHOT)
		{
		curr_sx=xcoor;
		curr_sy=ycoor-height;
		}
	}

static void flushbuf()
	{
	Font_string_dims dims;
	
	buffer[bufpos]='\0';
	if(strlen(buffer)==0) return;
	xv_get(currentfont.font,FONT_STRING_DIMS,buffer,&dims);
	if(!wordinline(buffer)) newline();
	XDrawString(dpy,xwin,currentfont.gc,xcoor,ycoor,buffer,strlen(buffer));
	bufpos=0;
	xcoor+=dims.width;
	}

void writechar(c)
	char c;
	{
 	int i;
	
 	switch(c)
		{
		case '\t':
			flushbuf(); 
			for(i=0;i<column;i++)
				buffer[bufpos++]=' ';
			column=TABSTEP;
			flushbuf();
			break;
		case ' ':
			column--;
			if(column<0) column=TABSTEP;
			buffer[bufpos++]=' ';
			flushbuf();
			break;
		case '\n':
			/*buffer[bufpos++]=' ';*/
			flushbuf();
			newline();
			break;
		default:
			column--;
			if(column<0) column=TABSTEP;
			buffer[bufpos++]=c;
			break;
		}
 	}

void start_viewer(w)
	Window w;
	{
	int height;

	if(hotvector!=NULL)
		vector_free(hotvector,hotarea_free);
	hotvector=new_vector(HOTVECTOR);
	page_too_long=0;
	currentfont=title_font;
	xwin=w;
	xcoor=LEFTMARGIN;
	bufpos=0;
	height=xv_get(currentfont.font,FONT_DEFAULT_CHAR_HEIGHT);
	ycoor=UPPERMARGIN+height;
	XClearWindow(dpy,xwin);
	column=0;
	}

void end_viewer()
	{
	flushbuf();
	}

void start(command,action,param)
	int command,action;
	char *param;
	{
	flushbuf();
	if(curr_command==COMHOT && command!=COMHOT)
		{
		vector_insert(hotvector,new_hotarea(curr_sx,curr_sy,xcoor,ycoor,curr_action,curr_param));
		free(curr_param);
		}
	curr_command=command;
	switch(command)
		{
		case COMTEXT:
		default:
			currentfont=text_font;
			break;
		case COMSOURCE:
			currentfont=source_font;
			break;
		case COMTITLE:
			currentfont=title_font;
			break;
		case COMSUB:
			currentfont=sub_font;
			break;
		case COMHOT:
			curr_action=action;
			curr_param=(char*)malloc(strlen(param)+1);
			strcpy(curr_param,param);
					switch(action)
				{
				case ACTGOTO:
					currentfont=hgo_font;
					break;
				case ACTDEF:
					currentfont=hdef_font;
					break;
				case ACTLINK:
					currentfont=hlink_font;
					break;
				default:
					currentfont=text_font;
					break;
				}
			curr_sx=xcoor;
			curr_sy=ycoor-xv_get(currentfont.font,FONT_DEFAULT_CHAR_HEIGHT);
			break;
		}
	}
