#include "tree.h"

static void default_error(s)
	char *s;
	{
	fprintf(stderr,"Tree error: %s",s);
	exit(-1);
	}

static void (*error)()=default_error;

void tree_error(fn)
	void  (*fn)();
	{
	error=fn;
	}

void tree_default()
	{
	error=default_error;
	}


tree new_tree()
	{
	tree t;

	t=(tree)malloc(sizeof(struct TREE_HEADER));
	if(t==NULL) error("Allocation error");
	t->num=0;
	t->tree=NULL;
	return(t);
	}

static node make_node(datum)
        char *datum;
        {
        node t;

        t=(node)malloc(sizeof(struct TREE));
        if(t==NULL)
                return(NULL);
        t->left=NULL;
        t->right=NULL;
        t->info=datum;
        return(t);
        }

static node connect_right(t,datum)
        node *t;
        char *datum;
        {
        return((*t)->right=make_node(datum));
        }

static node connect_left(t,datum)
        node *t;
        char *datum;
        {
        return((*t)->left=make_node(datum));
        }


static void insert(t,datum,cmp)
        node *t;
        char *datum;
        int (*cmp)();
        {
	int r;

        if(*t==NULL)
                {
                if((*t=make_node(datum))==NULL)
			error("Allocation error");
                else
			return;
                }
        else
                {
                r=cmp(datum,(*t)->info);
                switch(r)
                        {
			case -1:
                                if((*t)->left==NULL)
                                        {
                                        if(connect_left(t,datum)==NULL)
						error("Allocation error");
					else return;
                                        }
				else insert(&((*t)->left),datum,cmp);
                                break;
			case 1:
                                if((*t)->right==NULL)
                                        {
                                        if(connect_right(t,datum)==NULL)
						error("Allocation error");
					else return;
                                        }
				else insert(&((*t)->right),datum,cmp);
                                break;
			case 0:
				insert(&((*t)->right),datum,cmp);
                                break;
                        default:
				error("Bad compare function");
                                break;
                        }
                }
        }

void tree_insert(t,datum,cmp)
	tree t;
        char *datum;
        int (*cmp)();
	{
	t->num++;
	insert(&(t->tree),datum,cmp);
        }

static void delete(t,free_item)
        node *t;
        void (*free_item)();
        {
        if((*t)!=NULL)
                {
		delete(&((*t)->right),free_item);
		delete(&((*t)->left),free_item);
                free_item((*t)->info);
                free(*t);
                }
	}

void tree_free(t,free_item)
	tree t;
        void (*free_item)();
        {
	delete(&(t->tree),free_item);
        free(t);
        }

static void traverse(t,f)
        node t;
        void (*f)();
        {
        if(t!=NULL)
                {
		traverse(t->left,f);
                f(t->info);
		traverse(t->right,f);
                }
        }

void tree_traverse(t,f)
	tree t;
        void (*f)();
        {
	traverse(t->tree,f);
        }

static char *search(t,key,cmp)
        node t;
        char *key;
        int (*cmp)();
        {
	int r;

        if(t==NULL) return(NULL);
        else
                {
                r=cmp(key,t->info);
                switch(r)
                        {
			case -1: return(search(t->left,key,cmp));
                                        break;
			case 1: return(search(t->right,key,cmp));
                                        break;
			case 0: return(t->info);
					break;
			default:
				error("Bad compare function");
				break;
                        }
                }
        }

char *search_tree(t,key,cmp)
	tree t;
        char *key;
        int (*cmp)();
        {
	return(search(t->tree,key,cmp));
	}

static void put_node(t,f,put_elem)
	node t;
	FILE *f;
	void (*put_elem)();
	{
	if(t!=NULL)
		{
		put_node(t->left,f,put_elem);
		put_elem(t->info,f);
		put_node(t->right,f,put_elem);
		}
	}

void tree_put(t,f,put_elem)
	tree t;
	FILE *f;
	void (*put_elem)();
	{
	fprintf(f,"%08d\n",t->num);
	put_node(t->tree,f,put_elem);
	}
