#include "target.h"

static void default_error(s)
	char *s;
	{
	fprintf(stderr,"Target error: %s\n",s);
	exit(-1);
	}

static void (*error)()=default_error;

void target_error(fn)
	void  (*fn)();
	{
	error=fn;
	}

void target_default()
	{
	error=default_error;
	}

target new_target(name,line)
	char *name;
	long line;
	{
	target t;
	
 	t=(target)malloc(sizeof(struct TARGET));
	if(t==NULL)
		error("Allocation error");
  	t->pagename=(char*)malloc(strlen(name)+1);
	if(t->pagename==NULL)
		error("Allocation error"); 
	collapse(strupr(strcpy(t->pagename,name)));
	t->linecnt=line;
 	return(t);
	}

void target_free(t)
	target t;
	{
	free(t->pagename);
	free(t);
	}

long target_line(t)
	target t;
	{
	return(t->linecnt);
	}

char *target_name(t)
	target t;
	{
	return(t->pagename);
	}
