#include "page.h"

#define sign(x) ((x>=0)?((x==0)?0:1):-1)


static void default_error(s)
	char *s;
	{
	fprintf(stderr,"Page error: %s\n",s);
	exit(-1);
	}

static void (*error)()=default_error;

void page_error(fn)
	void  (*fn)();
	{
	error=fn;
	}

void page_default()
	{
	error=default_error;
	}

int page_cmp(left,right)
        page left,right;
        {
        int result;

        result=strcmp(left->name,right->name);
	return(sign(result));
        }

page new_page(name,pos)
	char *name;
	long pos;
	{
	page p;

	p=(page)malloc(sizeof(struct PAGE));
	if(p==NULL) error("Allocation error");
	p->name=(char*)malloc(strlen(name)+1);
	if(p->name==NULL) error("Allocation error");
	collapse(strupr(strcpy(p->name,name)));
	p->pos=pos;
	return(p);
	}

void page_free(p)
	page p;
        {
	free(p->name);
	free(p);
        }

long page_pos(p)
        page p;
        {
	return(p->pos);
	}

char *page_name(p)
	page p;
	{
	if(p!=NULL) return(p->name);
	else return(NULL);
	}

void page_put(p,f)
	page p;
	FILE *f;
	{
	fprintf(f,NUMFORMAT,(long)strlen(p->name));
	fprintf(f,"%s",p->name);
	fprintf(f,NUMFORMAT,(long)p->pos);
	fprintf(f,"\n");
	}

page page_get(f)
	FILE *f;
	{
	char *name;
	page p;
	long len;
	long pos;

	fscanf(f,NUMFORMAT,&len);
	name=(char*)malloc(len+1);
	if(name==NULL) error("Allocation error");
	fgets(name,len+1,f);
	fscanf(f,NUMFORMAT,&pos);
	p=new_page(name,pos);
	free(name);
	return(p);
	}
