#include "hotarea.h"

static void default_error(s)
	char *s;
	{
	fprintf(stderr,"Hotarea error: %s\n",s);
	exit(-1);
	}

static void (*error)()=default_error;

void hotarea_error(fn)
	void  (*fn)();
	{
	error=fn;
	}

void hotarea_default()
	{
	error=default_error;
	}


hotarea new_hotarea(sx,sy,ex,ey,action,param)
	int sx,sy,ex,ey,action;
	char *param;
	{
	hotarea ha;

	ha=(hotarea)malloc(sizeof(struct HOTAREA));
	if(ha==NULL) error("Allocation error");
	ha->param=(char*)malloc(strlen(param)+1);
	if(ha->param==NULL) error("Allocation error");
	ha->sx=sx;
	ha->sy=sy;
	ha->ex=ex;
	ha->ey=ey;
	ha->action=action;
	strcpy(ha->param,param);
	return(ha);
	}

void hotarea_free(ha)
	hotarea ha;
	{
	free(ha->param);
	free(ha);
	}

int is_in_area(ha,px,py)
	hotarea ha;
	int px,py;
	{
	return(px>ha->sx && px<ha->ex && py>ha->sy && py<ha->ey);
	}

int hotarea_action(ha)
	hotarea ha;
	{
	return(ha->action);
	}

char *hotarea_param(ha)
	hotarea ha;
	{
	return(ha->param);
	}
