#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <stdlib.h>

#include "tree.h"
#include "vector.h"
#include "page.h"
#include "hotword.h"
#include "topic.h"
#include "code.h"

extern void proc_inp();

FILE *hlpfile,*hdffile,*hrffile;
char *hlpname,*hdfname,*hrfname;
int warnings;

static void error(s)
	char *s;
	{
	fprintf(stderr,"Hcc error: %s\n",s);
	exit(-1);
	}

static void str_error(s,p)
	char *s,*p;
	{
	char buffer[80];

	sprintf(buffer,s,p);
	error(buffer);
	}

void main(argc,argv)
	int argc;
	char *argv[];
	{
	char *pos;
	int offset;
	
	/* PLEASE: do not modify or delete the following two lines */

	fprintf(stderr,"        **** hcc: an help compiler Ver 1.0 ****\n");
	fprintf(stderr,"by CalamaroSoft (calamaro@dist.dist.unige.it) - Nov. 1993\n\n");

	if(argc!=2) 
		error("Bad arguments, usage is: hcc <file name>");
	hlpname=(char*)malloc(strlen(argv[1])+strlen(DESSOURCE)+1);
	if(hlpname==NULL) error("Allocation error");
	hdfname=(char*)malloc(strlen(argv[1])+strlen(DESDEF)+1);
	if(hdfname==NULL) error("Allocation error");
	hrfname=(char*)malloc(strlen(argv[1])+strlen(DESREF)+1);
	if(hrfname==NULL) error("Allocation error");
	strcpy(hlpname,argv[1]);
	strcpy(hdfname,argv[1]);
	strcpy(hrfname,argv[1]);
	if((pos=strchr(hlpname,'.'))==NULL)
		{
		strcat(hlpname,DESSOURCE);
		strcat(hdfname,DESDEF);
		strcat(hrfname,DESREF);
		}
	else
		{
		offset=(pos-hlpname);
		strcpy(hdfname+offset,DESDEF);
		strcpy(hrfname+offset,DESREF);
		}
	if((hlpfile=fopen(hlpname,"r"))==NULL)
		str_error("Can't open %s for reading",hlpname);
	if((hdffile=fopen(hdfname,"w"))==NULL)
		str_error("Can'f open %s for writing",hdfname);
	if((hrffile=fopen(hrfname,"w"))==NULL)
		str_error("Can't open %s for writing",hrfname);
	fprintf(stderr,"%s -> %s, %s ...\n",hlpname,hrfname,hdfname);

	warnings=0;
	proc_inp();

	fclose(hrffile);
	fclose(hdffile);
	fclose(hlpfile);
	if(warnings>0) fprintf(stderr,"Detected %d warnings\n",warnings);
	else fprintf(stderr,"Ok\n");
	}
