#include "XCL.h"
#include "Calc_Controller.h"

void C_CalcController::Register(C_ClassRegister*inst)
     {
        if (!inst)
          inst=RegisterClass(C_CalcControllerClassName, Creator);
	DefineAction(inst, "NumberClick()", (ActionProc)NumberClick);
	DefineAction(inst, "DotClick()", (ActionProc)DotClick);
	DefineAction(inst, "OpClick()", (ActionProc)OpClick);
	DefineAction(inst, "FnClick()", (ActionProc)FnClick);
	DefineAction(inst, "About()", (ActionProc)About);
	DefineAction(inst, "Quit()", (ActionProc)Quit);
     }
	
C_CalcController::C_CalcController()
     {	
        SetType(C_CalcControllerClass);
        SetClassName(C_CalcControllerClassName);
	Number="0";
	LastNumber="0";
	LastOp='+';
     }

void C_CalcController::UpdateResult()
     {
     	(*this)["dlg_calculator.text_result"]->
     					SetStringValue("Caption", Number);
     }

void C_CalcController::NumberClick(C_SObject *O)
     {
	C_Button *Key=static_cast<C_Button*>(O);
	if (Number[0]=='0' && Number[1]=='\0') Number[0]='\0';
	if (strlen(Number)<20)
	  strcat(Number, Key->Title);
	UpdateResult();
     }

void C_CalcController::DotClick(C_SObject *O)
     {
	C_Button *Key=static_cast<C_Button*>(O);
	if (strchr(Number, '.')) return;
	strcat(Number, ".");
	UpdateResult();
     }

void C_CalcController::OpClick(C_SObject *O)
     {
	C_Button *Key=static_cast<C_Button*>(O);
	double n1, n2, r;
	n1=atof(LastNumber);
	n2=atof(Number);
	switch (LastOp) {
	 case '=':r=n2;
	   break;
	 case '+':r=n1+n2;
	   break;
	 case '-':r=n1-n2;
	   break;
	 case '*':r=n1*n2;
	   break;
	 case '/':if (n2!=0) r=n1/n2;
	   else r=0;
	   break;
	}
	LastOp=Key->Title[0];
	sprintf(LastNumber, "%0g", r);
	strcpy(Number, LastNumber);
	UpdateResult();
	Number="0";
     }

void C_CalcController::FnClick(C_SObject *O)
     {
	C_Button *Key=static_cast<C_Button*>(O);
	switch (Key->Title[0])  {
	 case 'A':LastNumber="0";
	   LastOp='+';
	 case 'C':Number="0";
	   break;
	 case '<':if (strlen(Number)>1) Number[strlen(Number)-1]='\0';
	   else Number="0";
	}
	UpdateResult();
     }
     
void C_CalcController::About(C_SObject*)
     {
        C_Dialog *D=static_cast<C_Dialog*>(
                        C_ResLoad::LoadObject(Application->MainWindow,
                                              "dlg_about"));
        D->Execute();
        delete D;
     }

void C_CalcController::Quit(C_SObject*)
     {
        Application->Gfx->Stop();
     }

