-------------------------------------------------------------------------
--
--      CoLibri V2.0 - SQL-Interface (Informix 4.0)
--
-------------------------------------------------------------------------
--
--      Copyright (C) Siemens Nixdorf Informationssysteme AG 1992
--      All rights reserved
--
-------------------------------------------------------------------------
--
-- Author        : A. Graffigna
-- Creation      : 01.10.1992
--
-------------------------------------------------------------------------
--
-- Last Modified By: Torsten Dumm
-- Last Modified On: Thu Feb 17 11:38:31 1994
-- Update Count    : 5
--
-------------------------------------------------------------------------
--
-- Module        : SqlInteger.cs
-- Purpose       : Module for supporting the SQL data types SQLSMALLINT,
--                 SQLINTEGER and SQLSERIAL.
-- Updates       : 
--                 Torsten Dumm 08.02.94
--                 module modified for the CooL Version 2.0
--
-- Exports       : FUNCTION IntToSqlSmallint       (..) ;
--                 FUNCTION isSqlSmallintEqualNull (..) ;
--                 FUNCTION setSqlSmallintToNull   (..) ;
--                 FUNCTION SqlSmallintToInt       (..) ;
--
--                 FUNCTION IntToSqlInteger        (..) ;
--                 FUNCTION isSqlIntegerEqualNull  (..) ;
--                 FUNCTION setSqlIntegerToNull    (..) ;
--                 FUNCTION SqlIntegerToInt        (..) ;
--
--                 FUNCTION IntToSqlSerial         (..) ;
--                 FUNCTION SqlSerialToInt         (..) ;
-------------------------------------------------------------------------

SPECIFICATION SqlInteger 

-------------------------------------------------------------------------
-- The data type SQLSMALLINT.
-------------------------------------------------------------------------

TYPE SQLSMALLINT = RECORD
                      value     : SHORT INT ;
		      indicator : INT ;
	           END RECORD;

PROCEDURE IntToSqlSmallint (IN integer : INT 
			    ) : SQLSMALLINT;
  ----------------------------------------------------------------------
  -- This function converts an INT to a SQLSMALLINT.
  -- Exceptions : ValueIsOutOfRange.
  ----------------------------------------------------------------------

PROCEDURE isSqlSmallintEqualNull (IN sql_smallint : SQLSMALLINT 
				  ) : BOOL; 
  ----------------------------------------------------------------------
  -- This function checks if the input variable sql_smallint contains
  -- the null value.
  -- Exceptions : None.
  ----------------------------------------------------------------------

PROCEDURE setSqlSmallintToNull : SQLSMALLINT;
  ----------------------------------------------------------------------
  -- This function sets a variable of type SQLSMALLINT to the null value.
  -- Exceptions : None.
  ----------------------------------------------------------------------

PROCEDURE SqlSmallintToInt (IN sql_smallint : SQLSMALLINT 
			    ) : INT;
  ----------------------------------------------------------------------
  -- This function converts SQLSMALLINT to an INT.
  -- Exceptions : ValueIsNull.
  ----------------------------------------------------------------------

-------------------------------------------------------------------------
-- The data type SQLINTEGER.
-------------------------------------------------------------------------

TYPE SQLINTEGER  = RECORD
                      value     : INT ;
		      indicator : INT ;
                   END RECORD;

PROCEDURE IntToSqlInteger (IN integer : INT 
			   ) : SQLINTEGER;
  ----------------------------------------------------------------------
  -- This function converts an INT to a SQLINTEGER.
  -- Exceptions : None.
  ----------------------------------------------------------------------

PROCEDURE isSqlIntegerEqualNull (IN sql_integer : SQLINTEGER 
				 ) : BOOL;
  ----------------------------------------------------------------------
  -- This function checks if the input variable sql_integer contains
  -- the null value.
  -- Exceptions : None.
  ----------------------------------------------------------------------

PROCEDURE setSqlIntegerToNull : SQLINTEGER;
  ----------------------------------------------------------------------
  -- This function sets a variable of type SQLINTEGER to the null value.
  -- Exceptions : None.
  ----------------------------------------------------------------------

PROCEDURE SqlIntegerToInt (IN sql_integer : SQLINTEGER 
			   ) : INT;
  ----------------------------------------------------------------------
  -- This function converts SQLINTEGER to an INT.
  -- Exceptions : ValueIsNull.
  ----------------------------------------------------------------------
  
-------------------------------------------------------------------------
-- The data type SQLSERIAL.
-------------------------------------------------------------------------

TYPE SQLSERIAL = SQLINTEGER;

PROCEDURE IntToSqlSerial (IN integer : INT 
			  ) : SQLSERIAL;
  ----------------------------------------------------------------------
  -- This function converts an INT to a SQLSERIAL.
  -- Exceptions : None.
  ----------------------------------------------------------------------

PROCEDURE SqlSerialToInt (IN sql_serial : SQLSERIAL 
			  ) : INT;
  ----------------------------------------------------------------------
  -- This function converts SQLSERIAL to an INT.
  -- Exceptions : None.
  ----------------------------------------------------------------------

END SPECIFICATION;
