-------------------------------------------------------------------------
--
--      CoLibri V2.0 - SQL-Interface (Informix 4.0)
--
-------------------------------------------------------------------------
--
--      Copyright (C) Siemens Nixdorf Informationssysteme AG 1992
--      All rights reserved
--
-------------------------------------------------------------------------
--
-- Author        : A. Graffigna
-- Creation      : 01.10.1992
--
-------------------------------------------------------------------------
--
-- Last Modified By: Torsten Dumm
-- Last Modified On: Wed Feb 16 14:49:09 1994
-- Update Count    : 5
--
-------------------------------------------------------------------------
--
-- Module        : SqlInf.cs
-- Purpose       : Internal module for the support of the
--                 root module for the SQL Object Interface.
-- Updates       : 
--                 Torsten Dumm 08.02.94
--                 module modified for the CooL Version 2.0
--
-- Exports       : EXCEPTION DatabaseError ;
--                 EXCEPTION DateComponentIsMissing ;
--                 EXCEPTION DateConversionFailed ;
--                 EXCEPTION DBObjectAlreadyExists ;
--                 EXCEPTION DecimalConversionFailed ;
--                 EXCEPTION DecimalRangeOverflow ;
--                 EXCEPTION DecimalRangeUnderflow ;
--                 EXCEPTION DivisionByZero ;
--                 EXCEPTION ErrorOccurred ;
--                 EXCEPTION FirstOperandIsNull ;
--                 EXCEPTION IllegalCombination ;
--                 EXCEPTION IllegalComponent ;
--                 EXCEPTION IllegalComponentCombination ;
--                 EXCEPTION IncompatibleConversion ;
--                 EXCEPTION IntegerRangeOverflow ;
--                 EXCEPTION InvalidComponent ;
--                 EXCEPTION InvalidDay ;
--                 EXCEPTION InvalidLength ;
--                 EXCEPTION InvalidMonth ;
--                 EXCEPTION InvalidYear ;
--                 EXCEPTION LengthForFractionsNotAllowed ;
--                 EXCEPTION LengthIsLargerThanNine ;
--                 EXCEPTION LengthIsLessThanZero ;
--                 EXCEPTION LengthOfStringIsZero  ;
--                 EXCEPTION LengthOfFormatIsZero  ;
--                 EXCEPTION MaxLengthIsSmallerThanMinLength ;
--                 EXCEPTION MaxSqlCharLengthExceeded ;
--                 EXCEPTION MaxSqlVarCharLengthExceeded ;
--                 EXCEPTION MinLengthIsLessThanZero ;
--                 EXCEPTION MemoryOverflow ;
--                 EXCEPTION NoConversionPossible ;
--                 EXCEPTION PositionIsNegative ;
--                 EXCEPTION RangeOverflow ;
--                 EXCEPTION ResultOverflow ;
--                 EXCEPTION SecondOperandIsNull ;
--                 EXCEPTION StringContainsCharacters ;
--                 EXCEPTION StringIsTooLarge ;
--                 EXCEPTION TooMuchValuesAtBeginning ;
--                 EXCEPTION TooMuchValuesAtEnd ;
--                 EXCEPTION ValueIsNull ;
--                 EXCEPTION ValueIsOutOfRange ;
--                 EXCEPTION ValueOverflow ;
--                 EXCEPTION WrongExponent ;
--                 EXCEPTION WrongOrderOfComponents ;
--
--                 CONST     NULL_VALUE ;
--                 CONST     NOT_NULL_VALUE ;
--
--                 VAR       Sql_Error ;
--
--                 PROCEDURE SqlBreak ;
--                 PROCEDURE SqlExit  ;
--                 PROCEDURE SqlStart ;
--                 
-------------------------------------------------------------------------

SPECIFICATION SqlInf

EXCEPTION DatabaseError ;               -- Used in: ???.t
EXCEPTION DateComponentIsMissing ;      -- Used in: SqlDate.t
EXCEPTION DateConversionFailed ;        -- Used in: SqlDate.t
EXCEPTION DBObjectAlreadyExists ;       -- Used in: ???.t
EXCEPTION DecimalConversionFailed ;     -- Used in: SqlDecimal.t
EXCEPTION DecimalRangeOverflow ;        -- Used in: SqlDecimal.t
EXCEPTION DecimalRangeUnderflow ;       -- Used in: SqlDecimal.t
EXCEPTION DivisionByZero ;              -- Used in: SqlDecimal.t
EXCEPTION ErrorOccurred ;               -- Used in: SqlInf.t
EXCEPTION FirstOperandIsNull ;          -- Used in: SqlDecimal.t
EXCEPTION IllegalCombination ;          -- Used in: SqlInterval.t
EXCEPTION IllegalComponent ;            -- Used in: SqlDatetime.t SqlInterval.t
EXCEPTION IllegalComponentCombination ; -- Used in: SqlInterval.t
EXCEPTION IncompatibleConversion ;      -- Used in: SqlDatetime.t SqlInterval.t
EXCEPTION IntegerRangeOverflow ;        -- Used in: SqlDecimal.t
EXCEPTION InvalidComponent ;            -- Used in: SqlDatetime.t SqlInterval.t
EXCEPTION InvalidDay ;                  -- Used in: SqlDate.t
EXCEPTION InvalidLength ;               -- Used in: SqlDate.t SqlDecimal.t
EXCEPTION InvalidMonth ;                -- Used in: SqlDate.t
EXCEPTION InvalidYear ;                 -- Used in: SqlDate.t
EXCEPTION LengthForFractionsNotAllowed ;-- Used in: SqlInterval.t
EXCEPTION LengthIsLargerThanNine ;      -- Used in: SqlInterval.t
EXCEPTION LengthIsLessThanZero ;        -- Used in: SqlInterval.t
EXCEPTION LengthOfStringIsZero ;        -- Used in: SqlDecimal.t SqlChar.t
                                        --          SqlDate.t
EXCEPTION LengthOfFormatIsZero ;        -- Used in: SqlDate.t
EXCEPTION MaxLengthIsSmallerThanMinLength ; -- Used in: SqlChar.t
EXCEPTION MaxSqlCharLengthExceeded ;    -- Used in: SqlChar.t
EXCEPTION MaxSqlVarCharLengthExceeded ; -- Used in: SqlChar.t
EXCEPTION MinLengthIsLessThanZero ;     -- Used in: SqlChar.t
EXCEPTION MemoryOverflow ;              -- Used in: SqlDate.t
EXCEPTION NoConversionPossible ;        -- Used in: SqlDatetime.t SqlInterval.t
EXCEPTION PositionIsNegative ;          -- Used in: SqlDecimal.t
EXCEPTION RangeOverflow ;               -- Used in: SqlDatetime.t SqlInterval.t
EXCEPTION ResultOverflow ;              -- Used in: SqlDatetime.t SqlInterval.t
EXCEPTION SecondOperandIsNull ;         -- Used in: SqlDecimal.t
EXCEPTION StringContainsCharacters ;    -- Used in: SqlDecimal.t SqlDatetime.t
                                        --          SqlInterval.t
EXCEPTION StringIsTooLarge ;            -- Used in: SqlChar.t
EXCEPTION TooMuchValuesAtBeginning ;    -- Used in: SqlDatetime.t SqlInterval.t
EXCEPTION TooMuchValuesAtEnd ;          -- Used in: SqlDatetime.t SqlInterval.t
EXCEPTION ValueIsNull ;                 -- Used in: All Modules.
EXCEPTION ValueIsOutOfRange ;           -- Used in: SqlInteger.t SqlFloat.t
EXCEPTION ValueOverflow ;               -- Used in: SqlDatetime.t SqlInterval.t
EXCEPTION WrongExponent ;               -- Used in: SqlDecimal.t
EXCEPTION WrongOrderOfComponents ;      -- Used in: SqlDatetime.t SqlInterval.t

-------------------------------------------------------------------------

CONST NULL_VALUE     : INT = -1 ;
CONST NOT_NULL_VALUE : INT =  1 ;

-------------------------------------------------------------------------

VAR Sql_Error : INT ;

-------------------------------------------------------------------------

PROCEDURE SqlStart ;
   ----------------------------------------------------------------------
   -- This procedure starts a database process.
   -- Exceptions : ErrorOccurred .
   ----------------------------------------------------------------------
PROCEDURE SqlExit ;
   ----------------------------------------------------------------------
   -- This procedure finishes a database process.
   -- The used memory space will be released.
   ----------------------------------------------------------------------
PROCEDURE SqlBreak ;
   ----------------------------------------------------------------------
   -- This procedure interrupts a database process.
   ----------------------------------------------------------------------

END SPECIFICATION;
