-------------------------------------------------------------------------
--
--      CoLibri V2.0 - SQL-Interface (Informix 4.0)
--
-------------------------------------------------------------------------
--
--      Copyright (C) Siemens Nixdorf Informationssysteme AG 1992
--      All rights reserved
--
-------------------------------------------------------------------------
--
-- Author        : A. Graffigna
-- Creation      : 01.10.1992
--
-------------------------------------------------------------------------
--
-- Last Modified By: Torsten Dumm
-- Last Modified On: Wed Feb 16 15:56:40 1994
-- Update Count    : 13
--
-------------------------------------------------------------------------
--
-- Module        : SqlDecimal.cs
-- Purpose       : Module for supporting the SQL data types SQLDECIMAL
--                 and SQLMONEY.
-- Updates       : 
--                 Torsten Dumm 08.02.94
--                 module modified for the CooL Version 2.0
--
-- Exports       : TYPE      SQLDECIMAL ;
--                 TYPE      SQLMONEY ;
--
--                 FUNCTION  addSqlDecimal         (..) ;
--                 FUNCTION  BcdToSqlDecimal       (..) ;
--                 FUNCTION  CharToSqlDecimal      (..) ;
--                 FUNCTION  compareSqlDecimal     (..) ;
--                 FUNCTION  divideSqlDecimal      (..) ;
--                 FUNCTION  DoubleToSqlDecimal    (..) ;
--                 FUNCTION  IntToSqlDecimal       (..) ;
--                 FUNCTION  isSqlDecimalEqualNull (..) ;
--                 FUNCTION  multiplySqlDecimal    (..) ;
--                 FUNCTION  roundSqlDecimal       (..) ;
--                 FUNCTION  setSqlDecimalToNull   (..) ;
--                 FUNCTION  SqlDecimal            (..) ;
--                 FUNCTION  SqlDecimalToBcd       (..) ;
--                 PROCEDURE SqlDecimalToChar      (..) ;
--                 FUNCTION  SqlDecimalToDouble    (..) ;
--                 FUNCTION  SqlDecimalToInt       (..) ;
--                 FUNCTION  substractSqlDecimal   (..) ;
--                 FUNCTION  truncateSqlDecimal    (..) ;
-------------------------------------------------------------------------

SPECIFICATION SqlDecimal

IMPORT BCD FROM Bcd;

-------------------------------------------------------------------------
-- The data types SQLDECIMAL and SQLMONEY.
-------------------------------------------------------------------------

CONST DECSIZE                   : INT = 16 ;

TYPE dec_t = RECORD
                dec_exp   : SHORT INT ;         -- exponent base 100
                dec_pos   : SHORT INT ;         -- sign: 1=pos, 0=neg, -1=null
                dec_ndgts : SHORT INT ;         -- number of significant digits
                dec_dgts  : ARRAY [DECSIZE] OF CHAR;-- actual digits base 100
             END RECORD; 

TYPE SQLDECIMAL = RECORD
                     value     : dec_t ;
	             indicator : INT ;
                  END RECORD;

TYPE SQLMONEY = SQLDECIMAL;

PROCEDURE addSqlDecimal (IN left_operand  : SQLDECIMAL,
			 IN right_operand : SQLDECIMAL 
			 ) : SQLDECIMAL;
  ----------------------------------------------------------------------
  -- This function adds two SQLDECIMALs.
  -- Exceptions : FirstOperandIsNull
  --              SecondOperandIsNull
  --              DecimalRangeOverflow
  --              DecimalRangeUnderflow .
  ----------------------------------------------------------------------

PROCEDURE BcdToSqlDecimal (IN bcd : BCD 
			   ) : SQLDECIMAL;
  ----------------------------------------------------------------------
  -- This function converts the BCD to a SQLDECIMAL.
  -- Exceptions : None .
  ----------------------------------------------------------------------

PROCEDURE compareSqlDecimal (IN left_operand  : SQLDECIMAL,
			     IN right_operand : SQLDECIMAL 
			     ) : INT;
  ----------------------------------------------------------------------
  -- This function compares the first SQLDECIMAL with the second one.
  -- The function result is "First_Operand_is_greater" or
  --                        "Both_Are_Equal" or
  --                        "Second_Operand_is_greater".
  -- Exceptions : FirstOperandIsNull
  --              SecondOperandIsNull .
  ----------------------------------------------------------------------

PROCEDURE divideSqlDecimal (IN dividend : SQLDECIMAL,
			    IN divisor  : SQLDECIMAL 
			    ) : SQLDECIMAL;
  ----------------------------------------------------------------------
  -- This function divides the first SQLDECIMAL by the second one.
  -- Exceptions : FirstOperandIsNull
  --              SecondOperandIsNull
  --              DecimalRangeOverflow
  --              DecimalRangeUnderflow
  --              DivisionByZero .
  ----------------------------------------------------------------------

PROCEDURE DoubleToSqlDecimal (IN double : DOUBLE 
			      ) : SQLDECIMAL;
  ----------------------------------------------------------------------
  -- This function converts the DOUBLE to a SQLDECIMAL.
  -- Exceptions : None .
  ----------------------------------------------------------------------

PROCEDURE IntToSqlDecimal (IN integer : INT
			   ) : SQLDECIMAL;
  ----------------------------------------------------------------------
  -- This function converts the INT to a SQLDECIMAL.
  -- Exceptions : None .
  ----------------------------------------------------------------------

PROCEDURE isSqlDecimalEqualNull (IN sql_decimal : SQLDECIMAL
				 ) : BOOL;
  ----------------------------------------------------------------------
  -- This function checks if the input variable sql_decimal contains
  -- the null value.
  -- Exceptions : None.
  ----------------------------------------------------------------------

PROCEDURE multiplySqlDecimal (IN left_operand  : SQLDECIMAL,
			      IN right_operand : SQLDECIMAL 
			      ) : SQLDECIMAL;
  ----------------------------------------------------------------------
  -- This function multiplies two SQLDECIMALs.
  -- Exceptions : FirstOperandIsNull
  --              SecondOperandIsNull
  --              DecimalRangeOverflow
  --              DecimalRangeUnderflow .
  ----------------------------------------------------------------------

PROCEDURE roundSqlDecimal (IN sql_decimal : SQLDECIMAL,
			   IN position    : INT 
			   ) : SQLDECIMAL;
  ----------------------------------------------------------------------
  -- This function rounds the SQLDECIMAL right-of-the decimal sign at
  -- the given position.
  -- Exceptions : ValueIsNull
  --              PositionIsNegative .
  ----------------------------------------------------------------------

PROCEDURE setSqlDecimalToNull : SQLDECIMAL;
  ----------------------------------------------------------------------
  -- This function sets a variable of type SQLDECIMAL to the null value.
  -- Exceptions : None.
  ----------------------------------------------------------------------

PROCEDURE SqlDecimal (IN string : STRING
		      ) : SQLDECIMAL;
  ----------------------------------------------------------------------
  -- This function initializes a variable of type SQLDECIMAL with a
  -- C-String which has to contain a valid representation of a decimal value.
  -- Exceptions : DecimalRangeOverflow
  --              DecimalRangeUnderflow
  --              StringContainsCharacters
  --              WrongExponent .
  ----------------------------------------------------------------------

PROCEDURE SqlDecimalToBcd (IN sql_decimal : SQLDECIMAL 
			   ) : BCD;
  ----------------------------------------------------------------------
  -- This function converts the SQLDECIMAL to a BCD.
  -- Exceptions : ValueIsNull
  --              DecimalConversionFailed
  --              BcdIsOutOfRange
  ----------------------------------------------------------------------

PROCEDURE SqlDecimalToDouble (IN sql_decimal : SQLDECIMAL 
			      ) : DOUBLE;
  ----------------------------------------------------------------------
  -- This function converts the SQLDECIMAL to a DOUBLE.
  -- Exceptions : ValueIsNull.
  ----------------------------------------------------------------------

PROCEDURE SqlDecimalToInt (IN sql_decimal : SQLDECIMAL 
			   ) : INT;
  ----------------------------------------------------------------------
  -- This function converts the SQLDECIMAL to a INT.
  -- Exceptions : ValueIsNull
  --              IntegerRangeOverflow .
  ----------------------------------------------------------------------

PROCEDURE SqlDecimalToString (IN sql_decimal     : SQLDECIMAL,
			      IN no_of_fractions : INT
			      ) : STRING;
  ----------------------------------------------------------------------
  -- This procedure converts the SQLDECIMAL to a C-String.
  -- no_of_fractions determines the number of fractions after the decimal
  -- point.
  -- The variable string has to contain enough memory space.
  -- The defined length of this variable has to be delivered also.
  -- The produced C-String will be terminated by a null-character.
  -- Exceptions : ValueIsNull
  --              DecimalConversionFailed .
  ----------------------------------------------------------------------

PROCEDURE StringToSqlDecimal (IN string : STRING
			      ) : SQLDECIMAL;
  ----------------------------------------------------------------------
  -- This function converts the first length characters of a C-String to
  -- a SQLDECIMAL.
  -- Exceptions : LengthOfStringIsZero
  --              DecimalRangeOverflow
  --              DecimalRangeUnderflow
  --              StringContainsCharacters
  --              WrongExponent .
  ----------------------------------------------------------------------

PROCEDURE substractSqlDecimal (IN left_operand  : SQLDECIMAL,
			       IN right_operand : SQLDECIMAL 
			       ) : SQLDECIMAL;
  ----------------------------------------------------------------------
  -- This function substracts the second SQLDECIMAL from the first one.
  -- Exceptions : FirstOperandIsNull
  --              SecondOperandIsNull
  --              DecimalRangeOverflow
  --              DecimalRangeUnderflow .
  ----------------------------------------------------------------------

PROCEDURE truncateSqlDecimal (IN sql_decimal : SQLDECIMAL,
			      IN position    : INT 
			      ) : SQLDECIMAL;
  ----------------------------------------------------------------------
  -- This function truncates the SQLDECIMAL right-of-the decimal sign
  -- after the given position.
  -- Exceptions : ValueIsNull
  --              PositionIsNegative .
  ----------------------------------------------------------------------

END SPECIFICATION;
