/***************************************************************************/
/*                 SQL_MEM.C - SQLGEN-memory management                    */
/*-------------------------------------------------------------------------*/
/*      Copyright (C) Siemens Nixdorf Informationssysteme AG 1992          */
/*      All rights reserved                                                */
/***************************************************************************/

# ifndef M_UNIX
# include <alloc.h>
# endif
# include "sql_defs.h"

static char sccsid[] = "@(#) sql_mem.c 1.0 1992-1203";

/*---- definitions for memory management ----------------------------------*/

# define ITEMS 32000 /* this value can be maked bigger if 'size_t'
                        is unsigned and an increase of performance
                        is necessarily */

static int free_Items = 0;
static char *Item_buffer = (char *)0;

static char *get_item();

void mem_space()
{
    printf( "Memory space not used: %d\n", free_Items );
}

/*---- GET_ITEM -----------------------------------------------------------*/

static char *get_item( Size )
int Size;
{
    char *New_Item;
# ifdef ALIGNMENT
    int align_factor;
# endif

    if ( free_Items < Size )
        {
        free_Items = ITEMS;
        if ( free_Items < Size )
            free_Items = Size;
        Item_buffer = (char *)calloc( 1, free_Items );
        if ( Item_buffer == (char *)0 )
        sql_fatal( "Out of memory" );
        }
    New_Item = Item_buffer;
    Item_buffer += Size;
    free_Items -= Size;
# ifdef ALIGNMENT
    align_factor = (ALIGN_FACTOR - Size % ALIGN_FACTOR) % ALIGN_FACTOR; 
    free_Items -= align_factor; 
    Item_buffer += align_factor;
# endif
    return ( New_Item );
}

/*---- GET_STRING_SPACE ---------------------------------------------------*/

char *Get_String_Space( Size )
int Size;
{
    return ( (char *)get_item( Size ) );
}

/*---- FREE_STRING_SPACE --------------------------------------------------*/

void Free_String_Space( Space )
char *Space;
{
  /* Now this function is only a dummy routine */
}

/*---- GET_HASH_TABLE -----------------------------------------------------*/

HASH_TABLE *Get_Hash_Table()
{
    return ( (HASH_TABLE *)get_item( sizeof( HASH_TABLE ) ) );
}

/*---- GET_HASHENTRIES ----------------------------------------------------*/

HASHENTRY *Get_Hashentries( Nitems )
int Nitems;
{
    return ( (HASHENTRY *)get_item( Nitems ) );
}

/*---- GET_INPUT_BUFFER ---------------------------------------------------*/

char *Get_Input_Buffer( Nitems )
int Nitems;
{
    return ( (char *)get_item( Nitems ) );
}

/*---- GET_STAB_ITEM ------------------------------------------------------*/

static int free_elements = 0;
static TSTAB *free_anker = STAB_NULL;
static TSTAB *next_free_stab = STAB_NULL;
static int free_list_count = 0;
static TSTAB *free_list_anker = STAB_NULL;

TSTAB *Get_Stab_Item()
{
    TSTAB *Pointer_to_Stab;

    if ( free_list_count != 0 )
      {
	free_list_count--;
	Pointer_to_Stab = free_list_anker;
	free_list_anker = free_list_anker->next_entry;
      }
    else
      {
	if ( free_elements == 0 )
	  Pointer_to_Stab = (TSTAB *)get_item( sizeof( TSTAB ) );
	else
	  {
	    Pointer_to_Stab = next_free_stab;
	    next_free_stab = next_free_stab->next_entry;
	    free_elements--;
	  }
      }
                        
    Pointer_to_Stab->Stab_Number = Stab_Entries++;
    Pointer_to_Stab->next_entry = Last_Entry;
    Last_Entry = Pointer_to_Stab;
    return ( Pointer_to_Stab );
}

/*---- FREE_STAB_ITEM -----------------------------------------------------*/

void Free_Stab_Item( Item )
TSTAB *Item;
{
  free_list_count++;
  Item->next_entry = free_list_anker;
  free_list_anker = Item;
}

/*---- GET_LIST -----------------------------------------------------------*/

static int free_list_elements;
static LIST *next_free_list;

LIST *Get_List()
{
    LIST *Pointer_to_list;

    if ( free_list_elements == 0 )
        Pointer_to_list = (LIST *)get_item( sizeof( LIST ) );
    else
        {
        Pointer_to_list = next_free_list;
        next_free_list = next_free_list->next;
        free_list_elements--;
        }

    Pointer_to_list->next = LIST_NULL;
    return ( Pointer_to_list );
}

/*---- GET_PAR_LIST --------------------------------------------------------*/

static int free_par_list_elements;
static PAR_LIST *next_free_par_list;

PAR_LIST *Get_Par_List()
{
    PAR_LIST *Pointer_to_par_list;

    if ( free_par_list_elements == 0 )
        Pointer_to_par_list = (PAR_LIST *)get_item( sizeof( PAR_LIST ) );
    else
        {
        Pointer_to_par_list = next_free_par_list;
        next_free_par_list = next_free_par_list->next;
    free_par_list_elements--;
        }

    Pointer_to_par_list->next = PAR_LIST_NULL;
    return ( Pointer_to_par_list );
}

/*---- GET_STATEMENT_LIST --------------------------------------------------*/

static int free_statement_list_elements;
static STATEMENT_LIST *next_free_statement_list;

STATEMENT_LIST *Get_Statement_List()
{
    STATEMENT_LIST *Pointer_to_Statement_list;

    if ( free_statement_list_elements == 0 )
	Pointer_to_Statement_list =
                        (STATEMENT_LIST *)get_item( sizeof( STATEMENT_LIST ) );
    else
        {
        Pointer_to_Statement_list = next_free_statement_list;
        next_free_statement_list = next_free_statement_list->next;
        free_statement_list_elements--;
        }

    Pointer_to_Statement_list->next = STATEMENT_LIST_NULL;
    return ( Pointer_to_Statement_list );
}
