/***************************************************************************/
/*               SQL_DEFS.H - SQLGEN-general definitions                   */
/*-------------------------------------------------------------------------*/
/*      Copyright (C) Siemens Nixdorf Informationssysteme AG 1992          */
/*      All rights reserved                                                */
/*	Last modified by Michael Watzek					   */
/***************************************************************************/

# include <stdio.h>
# include <string.h>
# include <ctype.h>
# include <stdlib.h>
/* # include "sql_gram.h" sql_gram is included after the definition
                          of YYSTYPE */

/*---- externe Variable ---------------------------------------------------*/

extern FILE *Specificationfile;
extern FILE *Implementationfile;
extern FILE *Languagefile;
extern FILE *Headerfile;
extern FILE *ESQLfile;
extern FILE *Protocolfile;

extern int SQL_TEXT_Flag;
extern int SELECT_Flag;
extern int more_SQL_possible;
extern char *Infile_Name;
extern char *Outfile_Name;
extern char  Modulename[255];
extern char *Database;
extern char *SpecificationfileName;
extern char *ImplementationfileName;
extern char *LanguagefileName;
extern char *HeaderfileName;
extern char *ESQLfileName;
extern int check_Flag;
extern int verbose_Flag;
extern int Line;
extern int Column;

# ifdef M_UNIX
extern int yyerrflag;
# else
extern short yyerrflag;
# endif
extern int Errors;

/*---- Namensdefinitionen -------------------------------------------------*/

# define COOL "CooL"
# define CPP  "C++"

enum language
    {
      L_COOL,
      L_CPP
    };

typedef enum language LANGUAGE;

extern LANGUAGE current_Language;

/*---- allgemeine Definitionen ---------------------------------------------*/

# define FALSE 0
# define TRUE  1

# ifdef ALIGNMENT

# ifdef RM400

# define ALIGN_FACTOR 4

# endif

# ifndef ALIGN_FACTOR

# define ALIGN_FACTOR 4

# endif

#endif

/*---- Definitionen fuer INFORMIX ------------------------------------------*/

# define MIN_CHAR_LENGTH 1
# define MAX_CHAR_LENGTH 32511

# define INFORMIX_NAME_LENGTH 18

# define INTERVAL_YEAR()      4
# define INTERVAL_MONTH()     2
# define INTERVAL_DAY()       2
# define INTERVAL_HOUR()      2 
# define INTERVAL_MINUTE()    2
# define INTERVAL_SECOND()    2
# define INTERVAL_FRACTION()  3
# define MAX_INTERVAL_FIRST() 9

enum komponents
    {
    TU_YEAR = 0,
    TU_MONTH = 2,
    TU_DAY = 4,
    TU_HOUR = 6,
    TU_MINUTE = 8,
    TU_SECOND = 10,
    TU_FRAC = 12,
    TU_F1 = 11,
    TU_F2 = 12,
    TU_F3 = 13,
    TU_F4 = 14,
    TU_F5 = 15
    };

typedef enum komponents KOMPONENTS;

# define TU_START(qual) ((qual>>4)&0xf)
# define TU_END(qual) (qual&0xf)
# define SET_INTVL_FIRST(qual, length) ((length<<8|qual)
# define GET_INTVL_FIRST(qual) (qual>>8)

struct sql_char
	{
	int typecode;
	int length;
	};

struct sql_varchar
	{
	int typecode;
	int maxlength;
	int minlength;
	};

struct sql_decimal
	{
	int typecode;
	int length;
	int precision;
	};

struct sql_interval
	{
	int typecode;
	KOMPONENTS komponent;
	};

union sql_type
	{
	struct sql_char Char;
	struct sql_varchar VarChar;
	struct sql_decimal Decimal;
	struct sql_interval Interval;
	int typecode;
	};

typedef union sql_type SQL_TYPE;

enum pmode
    {
    M_IN,
    M_OUT,
    M_INOUT
    };

typedef enum pmode PMODE;

/*---- Definition der Stabtypen --------------------------------------------*/

# define NO_ENTRY (TSTAB *)0
# define STAB_NULL (TSTAB *)0

enum kind_of_stab
    {
    S_HOSTVARIABLE = 1,
    S_CONSTANT,
    S_VIEW,
    S_STATEMENT,
    S_PARAMETER,
    S_UNKNOWN
    };

typedef enum kind_of_stab KIND_STAB;

struct stab
    {
    /* konstanter Teil */
    int Stab_Number;
    int Hashindex;
    struct stab *next_entry;
    struct stab *other;

    /* variabler Teil */
    int level;
    KIND_STAB Kind;
    int Value;
    SQL_TYPE Type;
    };

typedef struct stab TSTAB;

extern int Stab_Entries;
extern TSTAB *Last_Entry;
extern int Level;

/*---- Definition der Hashtabelle -------------------------------------------*/

struct hashentry
    {
    char *symbol;
    TSTAB *stab;
    };

typedef struct hashentry HASHENTRY;

struct hash_Table
    {
    HASHENTRY *hash_Table_low;
    HASHENTRY *hash_Table_high;
    int used_Entries;
    struct hash_Table *next;
    };

typedef struct hash_Table HASH_TABLE;

/*---- Typedefinitionen ----------------------------------------------------*/

struct hashindex
  {
    int hash;
    int Zeile;
  };

typedef struct hashindex HASHINDEX;

struct yy_ident
    {
    int Line;
    int Hash;
    };

typedef struct yy_ident YY_IDENT;

struct list
    {
    YY_IDENT ident;
    struct list *next;
    };

typedef struct list LIST;
# define LIST_NULL (LIST *)0

struct par_list
    {
    YY_IDENT ident;
    SQL_TYPE type;
    PMODE mode;
    struct par_list *next;
    };

typedef struct par_list PAR_LIST;
# define PAR_LIST_NULL (PAR_LIST *)0

extern PAR_LIST *Actual_View;

struct sql_text
    {
    char *Begin;
    int Length;
    };

typedef struct sql_text SQL_TEXT;

struct statement_list
    {
    SQL_TEXT statement;
    struct statement_list *next;
    };

typedef struct statement_list STATEMENT_LIST;
# define STATEMENT_LIST_NULL (STATEMENT_LIST *)0

enum cursor_type
    {
    C_SELECT,
    C_UPDATE,
    C_INSERT,
    };

typedef enum cursor_type CURSOR_TYPE;

struct select
    {
    CURSOR_TYPE type;
    SQL_TEXT text;
    };

struct insert
    {
    CURSOR_TYPE type;
    LIST *columns;
    YY_IDENT table;
    };    

union sql_cursor
    {
    struct select Select;
    struct insert Insert;
    };

typedef union sql_cursor SQL_CURSOR;

typedef union
    {
    YY_IDENT ident;
    int number;
    LIST *list;
    SQL_TEXT sql;
    SQL_CURSOR cursor;
    SQL_TYPE type;
    PAR_LIST *par_list;
    STATEMENT_LIST *statement_list;
    } YYSTYPE;

extern YYSTYPE yylval;
#include "sql_gram.h"

/*---- macro definitions --------------------------------------------------*/

# define SQL_WHITESPACE(C) ((C) == ' ' || (C) == '\t' || (C) == '\n')
# define FIRST_CHARACTER_OF_IDENTIFIER(C) (isalpha((C)) || (C) == '_' )
# define CHARACTER_OF_IDENTIFIER(C) (isalpha((C))||isdigit((C))||(C) == '_' )

/*---- function specification ---------------------------------------------*/

extern void sql_fatal();
extern void sql_error();
extern void sql_warning();
extern void sql_information();
extern int yylex();
extern void close_Files();
extern void remove_Files();
extern char *save_string();     
extern int hash();
extern char *get_symbol();
extern TSTAB *get_stab();
extern void insert_stab();
extern TSTAB *lookup_Entry();
extern TSTAB *insert_Entry();
extern void delete_Level();
extern void print_stab();
extern void sql_exit();

/*---- function specification for memory management -----------------------*/

extern char *Get_Input_Buffer();
extern char *Get_String_Space();
extern void Free_String_Space();
extern HASH_TABLE *Get_Hash_Table();
extern HASHENTRY *Get_Hashentries();
extern TSTAB *Get_Stab_Item();
extern void Free_Stab_Item();
extern LIST *Get_List();
extern PAR_LIST *Get_Par_List();
extern STATEMENT_LIST *Get_Statement_List();
extern void mem_space();

/*---- functions especially for sqlgen ------------------------------------*/

extern void read_Input_File();
extern char *get_init_parameter();
extern char *get_Language_type();
extern char *get_CLanguage_type();
extern void print_CooL_paramter_list();
extern void print_object_parameter_list();
extern void generate_Language_statement();
extern void generate_Language_record();
extern void generate_ESQL_record();
extern void generate_init_procedure();
extern void print_cursor_method();
extern void generate_object_type();
extern void generate_system_specification();
extern void generate_const_specification();
extern void generate_cursor_functions();
extern void generate_ESQL_statement();
extern void generate_Hostvariables();
static int sql_strncmp();

# ifdef DATABASE_PRESENT

extern void connect_Database();

# endif /* DATABASE_PRESENT */


