#
# RMS Makefile for CooL RTS
#
# $Header: Makefile[1.7] Wed May 11 11:45:34 1994 kalle@gianna accessed $
#

# --------------------------------------------------------------------
#		system specification 
# --------------------------------------------------------------------

# Path to this node system relative to the root of the
# repository area defined above (e.g. src/vc/save).

NODEPATH = rts/src

# A short name for this node system

NODENAME = RTS

# --------------------------------------------------------------------
#		the system's components
# --------------------------------------------------------------------

#
# The system (program, library, etc.) to be built. If you want to
# manage multiple programs, you should introduce multiple targets
# (like BIN1TARGET BIN2TARGET or any better names). In this case you 
# have to adjust the system building actions accordingly.

BINTARGET =
LIBTARGET = libcool.lib
SHAREDLIBTARGET = libcool.so

# The release number generator. The version number of this file will
# be used as release identifier for the whole system.

VERSIONFILE   = Release.c	   # source
VERSIONOBJECT =	Release.$(OBJSUFF) # derived (if source contains program code)

# The regular source and header files.
#
# PUBLIC headers (of a library) would be delivered (INCLUDEPATH) to the user.
# GLOBAL and LOCAL headers wouldn't be installed.

# CPP CooL Sources

PUBLIC_P_COOL_SPECS =
GLOBAL_P_COOL_SPECS =
LOCAL_P_COOL_SPECS  =
P_COOL_IMPLS =
P_COOL_MODS  =

# CooL Sources

PUBLIC_COOL_SPECS = CooL.cs
GLOBAL_COOL_SPECS =
LOCAL_COOL_SPECS  =
COOL_IMPLS = CooL.ci
COOL_MODS  =

# C Sources

PUBLIC_C_HDR = C3Irts.h
GLOBAL_C_HDR =
LOCAL_C_HDR  =
C_SRC = rtsmem.c rtsmtp.c rtsalloc.c rtstsl.c rtsstr.c rtsexc.c

# Templates

PUBLIC_TMPL =
GLOBAL_TMPL =
LOCAL_TMPL  =

# All sources

HEADERS = $(PUBLIC_P_COOL_SPECS) $(GLOBAL_P_COOL_SPECS) $(LOCAL_P_COOL_SPECS) \
          $(PUBLIC_COOL_SPECS) $(GLOBAL_COOL_SPECS) $(LOCAL_COOL_SPECS) \
          $(PUBLIC_C_HDR) $(GLOBAL_C_HDR) $(LOCAL_C_HDR) \
          $(PUBLIC_TMPL) $(GLOBAL_TMPL) $(LOCAL_TMPL)
SOURCES = $(P_COOL_IMPLS) $(P_COOL_MODS) $(COOL_IMPLS) $(COOL_MODS) $(C_SRC) 

# The manuals

MANUALS = $(MAN1) $(MAN3) $(MAN4) $(MAN5) $(MAN7)
MAN1 =
MAN3 =
MAN4 =
MAN5 =
MAN7 =

# All source components of the system (should not be changed)

COMPONENTS = $(MANUALS) $(HEADERS) $(SOURCES) Shapefile Makefile Dependencies

# The derived files. All files, that are automatically produced during
# a build process should be listed here.

OBJSUFF = obj
OBJECTS = $(VERSIONOBJECT) \
          $(P_COOL_MODS:.cmp=.obj) \
          $(P_COOL_IMPLS:.cip=.obj) \
          $(COOL_MODS:.cm=.obj) \
          $(COOL_IMPLS:.ci=.obj) \
          $(C_SRC:.c=.obj)

PUBLIC_HEADERS = \
          $(PUBLIC_P_COOL_SPECS:.csp=.cs) $(PUBLIC_P_COOL_SPECS:.csp=.h) \
          $(PUBLIC_COOL_SPECS) $(PUBLIC_COOL_SPECS:.cs=.h) \
          $(PUBLIC_C_HDR) \
          $(PUBLIC_TMPL)
GLOBAL_HEADERS = \
          $(GLOBAL_P_COOL_SPECS:.csp=.cs) $(GLOBAL_P_COOL_SPECS:.csp=.h) \
          $(GLOBAL_COOL_SPECS) $(GLOBAL_COOL_SPEC:.cs=.h) \
          $(GLOBAL_C_HDR) \
          $(GLOBAL_TMPL)

TMPS    = $(PUBLIC_P_COOL_SPECS:.csp=.cs) $(PUBLIC_P_COOL_SPECS:.csp=.h) \
          $(GLOBAL_P_COOL_SPECS:.csp=.cs) $(GLOBAL_P_COOL_SPECS:.csp=.h) \
          $(LOCAL_P_COOL_SPECS:.csp=.cs) $(LOCAL_P_COOL_SPECS:.csp=.h) \
          $(P_COOL_MODS:.cmp=.cm) $(P_COOL_MODS:.cmp=.h) \
            $(P_COOL_MODS:.cmp=.c) $(P_COOL_MODS:.cmp=.c2m) \
          $(P_COOL_IMPLS:.cip=.ci) $(P_COOL_IMPLS:.cip=.c) \
            $(P_COOL_IMPLS:.cip=.c2m) \
          $(PUBLIC_COOL_SPECS:.cs=.h) \
          $(GLOBAL_COOL_SPECS:.cs=.h) \
          $(LOCAL_COOL_SPECS:.cs=.h) \
          $(COOL_MODS:.cm=.h) $(COOL_MODS:.cm=.c) $(COOL_MODS:.cm=.c2m) \
          $(COOL_IMPLS:.ci=.c) $(COOL_IMPLS:.ci=.c2m)

# --------------------------------------------------------------------
#		environment specifications and locations
# --------------------------------------------------------------------

# The operating system, $(_TARGET) shall be built for.

SYSTEM = s_win_nt

# The processor type.

MACHINE = m_i386

# The object file format

OFILEFMT = 

# The C Compiler

#CCOMP = ms
CCOMP = gcc

# Locations and modes for the installation of executables, header
# files, libraries and manuals.

INSTALLBASE    = h:/$(CCOMP)
INSTALLBINPATH = $(INSTALLBASE)/bin
INSTALLINCPATH = $(INSTALLBASE)/include
INSTALLLIBPATH = $(INSTALLBASE)/lib
INSTALLMANPATH = $(INSTALLBASE)/man

# --------------------------------------------------------------------
#		tools, flags, libraries etc.
# --------------------------------------------------------------------

# The following macros will be overwritten by the system root makefile

MAKE  = make
SHELL = cmd.exe

COOL  = $(INSTALLBINPATH)/cool

#CC = cl
CC = gcc
CPP = $(CC) -E

MAKECPPFLAGS  = -P
MAKECOOLFLAGS =
#MAKECFLAGS    = -nologo -W0 -Ox
MAKECFLAGS    = -fno-builtin -O -D_M_IX86 -D__stdcall= -D__cdecl=
MAKELDFLAGS   = 

SYSLIBS  =

RANLIB   = /usr/bin/touch

# The following macros will NOT be overwritten by the system root makefile

SWITCHES  = -DNDEBUG -D_X86_ -D_CONSOLE -D$(MACHINE) -D$(SYSTEM)

COOLINC   = -d $(INSTALLINCPATH)

INCLUDES  = -I$(INSTALLINCPATH)

LOCALLIBS = 

PCOOLFLAGS = $(MAKECPPFLAGS) -D$(MACHINE) -D$(SYSTEM)
COOLFLAGS  = $(COOLINC) $(MAKECOOLFLAGS) 
CFLAGS     = $(INCLUDES) $(MAKECFLAGS) $(SWITCHES)
LDFLAGS    = -L$(INSTALLLIBPATH) $(MAKELDFLAGS)

# --------------------------------------------------------------------
#			default targets
# --------------------------------------------------------------------

# The default action (do not change)

all: build

# --------------------------------------------------------------------
#		Dependencies
# --------------------------------------------------------------------

include Dependencies

# --------------------------------------------------------------------
#		implicit rules 
# --------------------------------------------------------------------

include $(INSTALLINCPATH)/default_build_rules

# --------------------------------------------------------------------
#		other targets
# --------------------------------------------------------------------

# The final system building action.

targets: $(LIBTARGET)

# Construction of an archive library would look like:
$(LIBTARGET): $(OBJECTS)
	LIB32 -out:$(LIBTARGET) $(OBJECTS)

# Construction of a shared library would look like:
$(SHAREDLIBTARGET): $(OBJECTS)
	$(CC) $(SHLIBGENFLAGS) -o $(SHAREDLIBTARGET) $(OBJECTS)
	
# The cleanup action. Removes all automatically rederivable files.

doclean:
	rm -f $(BINTARGET) $(ALIASES) $(LIBTARGET) $(SHAREDLIBTARGET) \
	      $(OBJECTS) $(TMPS)

build : targets

clean : doclean

# The install actions. 

install : installlib installheaders

installlib : $(LIBTARGET)
	cp $(LIBTARGET) $(INSTALLLIBPATH)

installheaders : $(PUBLIC_HEADERS) $(GLOBAL_HEADERS)
	cp $(PUBLIC_HEADERS) $(GLOBAL_HEADERS) $(INSTALLINCPATH)
	

