--                             -*- Mode: Cool2 -*- 
-- variable.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: variable.cs[1.0] Tue Feb 22 10:02:48 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 10:09:00 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Wed Mar 16 11:39:02 1994
-- Update Count    : 3
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION variable

IMPORT String FROM mystring;
IMPORT FixedString FROM globals;
IMPORT Type FROM type;

-- -----------------------------------------------------------------
-- Constants for the scope of a variable
-- -----------------------------------------------------------------
CONST LOCAL    : INT = 0;
CONST PARAM    : INT = 1;
CONST STATIC   : INT = 2;
CONST GLOBAL   : INT = 3;
CONST REGISTER : INT = 4;

TYPE Variable = OBJECT (IN varname   : ARRAY OF CHAR,
			IN location  : INT,
			IN inReg     : BOOL,
			IN scopeinfo : INT,
			IN vartype   : Type)

PUBLIC
  
  METHOD GetName : String;
    -- -----------------------------------------------------------------
    -- This method returns the name of the variable
    -- -----------------------------------------------------------------
  
  METHOD GetAddr : Address;
    -- -----------------------------------------------------------------
    -- This method returns the address of the variable
    -- -----------------------------------------------------------------

  METHOD ComputeAddress (IN base : Address) : Address;
    -- -----------------------------------------------------------------
    -- This routine is similar to that one above. We only add the
    -- offset of this variable to the incomming address.
    -- -----------------------------------------------------------------

  METHOD GetType : Type;
    -- -----------------------------------------------------------------
    -- This method returns the base type of the variable
    -- -----------------------------------------------------------------

  METHOD PrintVariable (IN  base           : Address,
			IN  resolve        : BOOL,
			IN  leading_space  : FixedString,
			IN  trailing_space : INT,
			IN  line_end       : FixedString);
    -- -----------------------------------------------------------------
    -- This method shows the contents, name and type of this variable.
    -- Resolve means, show the structure components of structured
    -- types. The base gives the baseaddress, where the variable's
    -- offset is added to. The printed string looks like this:
    -- <leading_space>name<X> : TYPE = VALUE<line_end>
    -- where X = trailing_space blanks
    -- -----------------------------------------------------------------

  METHOD ShowVarContents (IN  base    : Address,
			  IN  resolve : BOOL);
    -- -----------------------------------------------------------------
    -- This method shows the contents of this variable. Resolve means,
    -- show the structure components of structured types. The base
    -- gives the baseaddress, where the variable's offset is added to.
    -- -----------------------------------------------------------------

  METHOD IsGlobal : BOOL;
    -- -----------------------------------------------------------------
    -- This method returns true, if the variable is in that scope
    -- -----------------------------------------------------------------

  METHOD IsStatic : BOOL;
    -- -----------------------------------------------------------------
    -- This method returns true, if the variable is in that scope
    -- -----------------------------------------------------------------

  METHOD IsLocal : BOOL;
    -- -----------------------------------------------------------------
    -- This method returns true, if the variable is in that scope
    -- -----------------------------------------------------------------

  METHOD IsParam : BOOL;
    -- -----------------------------------------------------------------
    -- This method returns true, if the variable is in that scope
    -- -----------------------------------------------------------------

  METHOD IsRegister : BOOL;
    -- -----------------------------------------------------------------
    -- This method returns true, if this varaible is located in a
    -- register 
    -- -----------------------------------------------------------------
  
PROTECTED
  
STATE
  name		 : String;		 -- name of the variable
  address	 : INT;			 -- address of the variable,
					 -- or offset to something
  scope		 : INT;			 -- storage_class of the variable.
  type		 : Type;		 -- Type of -the variable
  is_in_register : BOOL;		 -- Are we, or not?
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE GenericVariable = Variable OBJECT (IN varname   : ARRAY OF CHAR,
					IN location  : INT,
					IN inReg     : BOOL,
					IN scopeinfo : INT,
					IN vartype   : Type)
  -- -----------------------------------------------------------------
  -- This objecttype handles the generic variables as instance vars,
  -- parameters or local vars of generic objecttypes. 
  -- -----------------------------------------------------------------

PUBLIC
  
PROTECTED
  
STATE
  formalTypeName : FixedString;		 -- This is the name of the
					 -- formal type given in the
					 -- cool source. It's
					 -- extracted from the name.
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE FormalTypeVariable = Variable OBJECT (IN varname   : ARRAY OF CHAR,
					   IN location  : INT,
					   IN inReg     : BOOL,
					   IN scopeinfo : INT,
					   IN vartype   : Type)
  -- -----------------------------------------------------------------
  -- This objecttype handles the variables of instance varariable records,
  -- which are holding the actual value of the formal type.
  -- -----------------------------------------------------------------

PUBLIC
  
PROTECTED
  
STATE
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE Address = OBJECT (IN val : INT)
  
PUBLIC
  
  METHOD GetValue : INT;
    -- -----------------------------------------------------------------
    -- Get the address of this Address
    -- -----------------------------------------------------------------
    
  METHOD Copy : Address;
    -- -----------------------------------------------------------------
    -- Get a copy of this Address
    -- -----------------------------------------------------------------
    
  METHOD AddOffset (IN offset : INT);
    -- -----------------------------------------------------------------
    -- Add offset to the address of this Address
    -- -----------------------------------------------------------------
  
  METHOD ReadINT              : INT;
  METHOD ReadSHORTINT         : SHORT INT;
  METHOD ReadLONG             : INT;
  METHOD ReadUNSIGNEDINT      : UNSIGNED INT;
  METHOD ReadUNSIGNEDSHORTINT : UNSIGNED SHORT INT;
  METHOD ReadUNSIGNEDLONG     : UNSIGNED INT;
  METHOD ReadCHAR             : CHAR;
  METHOD ReadUNSIGNEDCHAR     : CHAR;
  METHOD ReadFLOAT            : FLOAT;
  METHOD ReadDOUBLE           : DOUBLE;
  METHOD ReadADDRESS          : Address;
  METHOD ReadARRAY            : ARRAY [4] OF CHAR;
    -- -----------------------------------------------------------------
    -- Deliver the memory contents at this Address by the specific
    -- values 
    -- -----------------------------------------------------------------

PROTECTED
  
STATE
  value : INT;				 -- address of this Address
  
END OBJECT;

-- -----------------------------------------------------------------
-- Subtype for addresses which are registers
-- -----------------------------------------------------------------

TYPE RegisterAddress = Address OBJECT (IN val : INT)
  
PUBLIC
  
PROTECTED
  
STATE
  
END OBJECT;

-- -----------------------------------------------------------------
-- Subtype for addresses if the process is not running. Any Action
-- simply returns an UnreadableAddress.
-- -----------------------------------------------------------------

TYPE UnreadableAddress = Address OBJECT (IN val : INT)
  
PUBLIC
  
PROTECTED
  
STATE
  
END OBJECT;

END SPECIFICATION;
