--                             -*- Mode: Cool2 -*- 
-- type.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: type.cs[1.0] Tue Feb 22 10:02:24 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 10:06:35 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Thu Feb 10 16:43:45 1994
-- Update Count    : 6
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION type

IMPORT Variable, Address
  FROM variable;
IMPORT FixedString
  FROM globals;
IMPORT MySet
  FROM Bayer;
IMPORT String
  FROM mystring;

TYPE Type = ABSTRACT OBJECT (IN typesize : INT)
  -- -----------------------------------------------------------------
  -- This type should never be instantiated! It's only the overall
  -- interface to the specific types!
  -- -----------------------------------------------------------------
  
PUBLIC
  
  ABSTRACT METHOD PrintValue (IN address    : Address,
			      IN resolve    : BOOL,
			      IN show_value : BOOL,
			      IN varname    : FixedString);
    -- -----------------------------------------------------------------
    -- This Method is the overall interface to a type. every subtype
    -- redefines this method to its adequate needs (if needed).
    -- address is the adress,where the values of a variable of this
    -- type can be found. resolve means, should a structured type
    -- resolved to its components or not. show_value is given, if the
    -- address shold be referenced. 
    -- -----------------------------------------------------------------
    
  ABSTRACT METHOD GetName () : FixedString;
    -- -----------------------------------------------------------------
    -- Deliver the name of this type.
    -- -----------------------------------------------------------------
    
  METHOD GetCompleteName () : FixedString;
    -- -----------------------------------------------------------------
    -- Deliver the name eventually prefixed by a structure tag or
    -- postfixed by a following type name.
    -- -----------------------------------------------------------------
    
  METHOD GetSize () : INT;
    -- -----------------------------------------------------------------
    -- What size do we have? Interesting only for array compnent sizes.
    -- -----------------------------------------------------------------
    
  METHOD IsInvisible () : BOOL;
    -- -----------------------------------------------------------------
    -- Is this type visible to the user (C3I internal types aren't)
    -- -----------------------------------------------------------------
    
  ABSTRACT METHOD PutRangeOffset (IN offset : INT);
    -- -----------------------------------------------------------------
    -- Correct the array ranges by offset.
    -- -----------------------------------------------------------------
    
PROTECTED
  
STATE
  size         : INT;			 -- Size of this type
  is_invisible : BOOL;			 -- some types don't need to
					 -- be seen.
END OBJECT;
  
-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE NamedType = Type OBJECT (IN typesize : INT,
			      IN newname  : FixedString,
			      IN oldtype  : Type)
  
PUBLIC
  
  METHOD PrintValue (IN address    : Address,
		     IN resolve    : BOOL,
		     IN show_value : BOOL,
		     IN varname    : FixedString);
    
  METHOD PutRangeOffset (IN offset : INT);

  METHOD GetName () : FixedString;

PROTECTED
  
STATE
  name : FixedString;
  type : Type;
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE SimpleType = Type ABSTRACT OBJECT (IN typesize : INT)
  -- -----------------------------------------------------------------
  -- This type should never be instantiated! It's only the overall
  -- interface to the simple types!
  -- -----------------------------------------------------------------
  
PUBLIC
  
  METHOD PrintValue (IN address    : Address,
		     IN resolve    : BOOL,
		     IN show_value : BOOL,
		     IN varname    : FixedString);
    
  METHOD PutRangeOffset (IN offset : INT);

  ABSTRACT METHOD GetValue    (IN address : Address)   : FixedString;
    -- -----------------------------------------------------------------
    -- Furthermore, we want to see the value of an simple type,
    -- returned as a string for printing.
    -- -----------------------------------------------------------------

PROTECTED
  
STATE
					 -- nothing new
END OBJECT;
	
-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE IntegerType = SimpleType ABSTRACT OBJECT (IN typesize : INT)
  -- -----------------------------------------------------------------
  -- Type representing global type for all kinds of integers
  -- -----------------------------------------------------------------
  
PUBLIC
  
PROTECTED
  
STATE

END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE INTCONSTType = IntegerType OBJECT (IN typesize : INT,
					IN val : INT)
  -- -----------------------------------------------------------------
  -- Type representing Integer Constants
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName () : FixedString;

  METHOD GetValue    (IN address : Address)   : FixedString;
    
PROTECTED

STATE
  value : INT;
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE INTType = IntegerType OBJECT (IN typesize : INT)
  -- -----------------------------------------------------------------
  -- Type representing INTs
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName () : FixedString;

  METHOD GetValue    (IN address : Address)   : FixedString;
    
PROTECTED
  
STATE
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE SHORTType = IntegerType OBJECT (IN typesize : INT)
  -- -----------------------------------------------------------------
  -- Type representing SHORTs
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName () : FixedString;

  METHOD GetValue    (IN address : Address)   : FixedString;
    
PROTECTED
  
STATE
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE LONGType = IntegerType OBJECT (IN typesize : INT)
  -- -----------------------------------------------------------------
  -- Type representing LONGs
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName () : FixedString;

  METHOD GetValue    (IN address : Address)   : FixedString;
    
PROTECTED
  
STATE
    					 -- nothing new
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE UNSIGNEDINTType = IntegerType OBJECT (IN typesize : INT)
  -- -----------------------------------------------------------------
  -- Type representing UNSIGNED INTs
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName () : FixedString;

  METHOD GetValue    (IN address : Address)   : FixedString;
    
PROTECTED
  
STATE
    					 -- nothing new
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE UNSIGNEDSHORTType = IntegerType OBJECT (IN typesize : INT)
  -- -----------------------------------------------------------------
  -- Type representing UNSIGNED SHORTs
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName () : FixedString;

  METHOD GetValue    (IN address : Address)   : FixedString;
    
PROTECTED
  
STATE
    					 -- nothing new
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE UNSIGNEDLONGType = IntegerType OBJECT (IN typesize : INT)
  -- -----------------------------------------------------------------
  -- Type representing UNSIGNED LONGs
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName () : FixedString;

  METHOD GetValue    (IN address : Address)   : FixedString;
    
PROTECTED
  
STATE
    					 -- nothing new
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE CHARType = SimpleType OBJECT (IN typesize : INT)
  -- -----------------------------------------------------------------
  -- Type representing CHARs
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName () : FixedString;

  METHOD GetValue    (IN address : Address)   : FixedString;
    
PROTECTED
  
STATE
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE UNSIGNEDCHARType = SimpleType OBJECT (IN typesize : INT)
  -- -----------------------------------------------------------------
  -- Type representing UNSIGNED CHARs
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName () : FixedString;

  METHOD GetValue    (IN address : Address)   : FixedString;
    
PROTECTED
  
STATE
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE FLOATType = SimpleType OBJECT (IN typesize : INT)
  -- -----------------------------------------------------------------
  -- Type representing FLOATs
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName () : FixedString;

  METHOD GetValue    (IN address : Address)   : FixedString;
    
PROTECTED
  
STATE
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE DOUBLEType = SimpleType OBJECT (IN typesize : INT)
  -- -----------------------------------------------------------------
  -- Type representing DOUBLEs
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName () : FixedString;

  METHOD GetValue    (IN address : Address)   : FixedString;
    
PROTECTED
  
STATE
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE STRINGType = SimpleType OBJECT (IN typesize : INT)
  -- -----------------------------------------------------------------
  -- Type representing ADDRESSes
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName () : FixedString;

  METHOD GetValue    (IN address : Address)   : FixedString;
    
PROTECTED
  
STATE
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE ADDRESSType = SimpleType OBJECT (IN typesize : INT)
  -- -----------------------------------------------------------------
  -- Type representing ADDRESSes
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName () : FixedString;

  METHOD GetValue    (IN address : Address)   : FixedString;
    
PROTECTED
  
STATE
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE ENUMType = SimpleType OBJECT (IN typesize : INT,
				   IN name     : FixedString,
				   IN values   : MySet)
  -- -----------------------------------------------------------------
  -- Type representing ENUMERATIONs
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName () : FixedString;

  METHOD GetValue    (IN address : Address)   : FixedString;
    
PROTECTED
  
STATE
  
  enumname : FixedString;		 -- They have a name, usually
  valueset : MySet;			 -- and they have a set of
					 -- values (name and int)
  
END OBJECT;

TYPE EnumerationValue = OBJECT (IN name  : FixedString,
				IN value : INT)
  -- -----------------------------------------------------------------
  -- Type representing enumeration values, a pair of a name and a
  -- interger. There is nothing exiting about this type, it's only a
  -- container.
  -- -----------------------------------------------------------------
  
PUBLIC
  
  METHOD GetTagValue : INT;
    -- -----------------------------------------------------------------
    -- Get the integer value for this tag
    -- -----------------------------------------------------------------
  
  METHOD GetTagName  : FixedString;
    -- -----------------------------------------------------------------
    -- Get the name of this tag
    -- -----------------------------------------------------------------
  
  METHOD ChangeName (IN modulename : FixedString);
    -- -----------------------------------------------------------------
    -- Change the name of this tag and extract the qualified
    -- enumration typename according to the cool coding conventions.
    -- -----------------------------------------------------------------
  
PROTECTED
  
STATE
  tag : FixedString;			 -- tag is a string
  val : INT;				 -- the value for this tag
  
END OBJECT;


-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE BOOLType = ENUMType OBJECT (IN typesize : INT,
				 IN name     : FixedString,
				 IN values   : MySet)
  -- -----------------------------------------------------------------
  -- BOOLs are enumerations in CooL, so we are a subtype of
  -- ENUMType. Simply redefine the name printing, because we
  -- want to see BOOL instead of ENUMERATION BOOL.
  -- -----------------------------------------------------------------
  
PUBLIC
  
PROTECTED
  
STATE
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE PROCEDUREType = SimpleType OBJECT (IN typesize  : INT,
					IN parameter : MySet,
					IN result    : Type)
  -- -----------------------------------------------------------------
  -- Type representing procedure types. Additionally we have the
  -- result type of the procedures signature.
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName () : FixedString;

  METHOD GetValue    (IN address : Address)   : FixedString;
    
PROTECTED
  
STATE
  params     : MySet;			 -- Set of formal parameter
  resulttype : Type;			 -- Resulttype of this
					 -- procedure type
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE METHODType = SimpleType OBJECT (IN typesize : INT)
  -- -----------------------------------------------------------------
  -- Type representing method types.
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName () : FixedString;

  METHOD GetValue    (IN address : Address)   : FixedString;
    
PROTECTED
  
STATE
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE VOIDType = SimpleType OBJECT (IN typesize : INT)
  -- -----------------------------------------------------------------
  -- Type representing VOIDs. This is not used for cool variables, but
  -- for procedure types.
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName () : FixedString;

  METHOD GetValue    (IN address : Address)   : FixedString;
    
PROTECTED
  
STATE
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE StructuredType = Type ABSTRACT OBJECT (IN typesize : INT,
					    IN name     : FixedString,
					    IN tag_ndx  : UNSIGNED INT,
					    IN ende     : UNSIGNED INT)
  -- -----------------------------------------------------------------
  -- Type representing Structures like RECORDs adn UNIONs (see the
  -- subtypes, but most word is done here). We should instantiate
  -- objects only of the subtypes of this type!
  -- -----------------------------------------------------------------
  
PUBLIC
  
  ABSTRACT METHOD GetStructureTag () : FixedString;
    -- -----------------------------------------------------------------
    -- Return the kind of the structure as string (f.e. "RECORD")
    -- -----------------------------------------------------------------
  
  METHOD PrintValue (IN address    : Address,
		     IN resolve    : BOOL,
		     IN show_value : BOOL,
		     IN varname    : FixedString);
    
  METHOD GetName () : FixedString;

  METHOD PutRangeOffset (IN offset : INT);

  METHOD GetComponents () : MySet;
    -- -----------------------------------------------------------------
    -- Deliver the set of components
    -- -----------------------------------------------------------------
  
  METHOD PutComponents (IN comps : MySet);
    -- -----------------------------------------------------------------
    -- Assign a new set of components. Used for late reading
    -- -----------------------------------------------------------------
  
  METHOD GetEndIndex () : UNSIGNED INT;
    -- -----------------------------------------------------------------
    -- The end of this structure in the object file is given. Used for
    -- late reading 
    -- -----------------------------------------------------------------
  
  METHOD GetTagIndex () : UNSIGNED INT;
    -- -----------------------------------------------------------------
    -- The start of this structure in the object file is given. Used for
    -- late reading
    -- -----------------------------------------------------------------
  
  METHOD GetLongestVarName () : INT;
    -- -----------------------------------------------------------------
    -- Determin the length of the longest component. For fine
    -- printing... Called only in my subtypes, therefor export it.
    -- -----------------------------------------------------------------
  
  METHOD PrintComponentValues (IN address    : Address,
			       IN resolve    : BOOL);
    -- -----------------------------------------------------------------
    -- Print all components of this type. Similar to PrintValue of the
    -- SimpleType 
    -- -----------------------------------------------------------------
  
  METHOD SearchComponent (IN name : FixedString) : Variable;
    -- -----------------------------------------------------------------
    -- Deliver the component with this name 
    -- -----------------------------------------------------------------
  
PROTECTED
  
STATE
  typename   : String;			 -- tag name of the structured type
  tag_index  : UNSIGNED INT;		 -- index of the first symbol
					 -- table entry of this
					 -- structured type.
  end_index  : UNSIGNED INT;		 -- index of the last symbol
					 -- table entry of this
					 -- structured type.
  components : MySet;			 -- Set of components. This
					 -- again are variables

END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE RECORDType = StructuredType OBJECT (IN typesize : INT,
					 IN name     : FixedString,
					 IN tag_ndx  : UNSIGNED INT,
					 IN ende     : UNSIGNED INT)
  -- -----------------------------------------------------------------
  -- Records are structured types...
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetStructureTag () : FixedString;
    
PROTECTED
  
STATE
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE UNIONType = StructuredType OBJECT (IN typesize : INT,
					IN name	    : FixedString,
					IN tag_ndx  : UNSIGNED INT,
					IN ende	    : UNSIGNED INT)
  -- -----------------------------------------------------------------
  -- Unions are structured types...
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetStructureTag () : FixedString;
    
PROTECTED
  
STATE
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE REFType = Type OBJECT (IN typesize : INT,
			    IN refs     : INT,
			    IN target   : Type)
  -- -----------------------------------------------------------------
  -- Type representing REF types
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD PrintValue (IN address    : Address,
		     IN resolve    : BOOL,
		     IN show_value : BOOL,
		     IN varname    : FixedString);
    
  METHOD GetName () : FixedString;
    -- -----------------------------------------------------------------
    -- Deliver the name of this type.
    -- -----------------------------------------------------------------
    
  METHOD GetReferredType () : Type;
    -- -----------------------------------------------------------------
    -- Return the referred type.
    -- -----------------------------------------------------------------
  
  METHOD PutRangeOffset (IN offset : INT);

PROTECTED
  
STATE
  refers : Type;			 -- and what type has the
					 -- reference 
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE ARRAYType = Type OBJECT (IN typesize : INT,
			      IN lower    : INT,
			      IN upper    : INT,
			      IN elemtype : Type)
  -- -----------------------------------------------------------------
  -- Type representing ARRAYs
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD PrintValue (IN address    : Address,
		     IN resolve    : BOOL,
		     IN show_value : BOOL,
		     IN varname    : FixedString);
    
  METHOD GetName () : FixedString;
    -- -----------------------------------------------------------------
    -- Deliver the name of this type.
    -- -----------------------------------------------------------------
    
  METHOD PrintArray (IN address    : Address,
		     IN varname    : FixedString);
    -- -----------------------------------------------------------------
    -- Print the ARRAY corresponding to varname.
    -- -----------------------------------------------------------------
  
  METHOD CheckIndex (IN index : INT) : BOOL;
    -- -----------------------------------------------------------------
    -- Checks the indexes against this array type
    -- -----------------------------------------------------------------

  METHOD GetElementType () : Type;
    -- -----------------------------------------------------------------
    -- Return the type of the elements of this array.
    -- -----------------------------------------------------------------
  
  METHOD ComputeArrayOffset (IN index : INT) : INT;
    -- -----------------------------------------------------------------
    -- Deliver the offset to the index of this array
    -- -----------------------------------------------------------------
    
  METHOD GetDimensions () : FixedString;
    -- -----------------------------------------------------------------
    -- Deliveres the info for dimensions as a string.
    -- -----------------------------------------------------------------

  METHOD PutRangeOffset (IN offset : INT);
    
PROTECTED
  
STATE
  
  lower_index : INT;
  upper_index : INT;			 -- Dimensions of this array
  entries     : INT;			 -- Number of elements in the array
  cool_offset : INT;			 -- offset to real C arrays
  corrected   : BOOL;			 -- is the offset correct?
  elementtype : Type;			 -- Type of elements

END OBJECT;

END SPECIFICATION;
