--                             -*- Mode: Cool2 -*- 
-- runstack.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: runstack.cs[1.0] Tue Feb 22 10:01:50 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 10:03:47 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Thu Jan 27 10:03:54 1994
-- Update Count    : 1
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION runstack

IMPORT Function FROM function;
IMPORT Variable FROM variable;

--------------------------------------------------------------------------
-- -----------------------------------------------------------------
-- The following type just represents a unique frame pointer type.
-- -----------------------------------------------------------------

TYPE STACK_ADDRESS_T = UNSIGNED INT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE ActiveFunction = OBJECT (IN nxt  : ActiveFunction,
                              IN prv  : ActiveFunction,
                              IN func : Function,
                              IN fp   : STACK_ADDRESS_T)
  
PUBLIC

  METHOD GetFunction : Function;
    -- -----------------------------------------------------------------
    -- This method returns the functiondescriptor contained in this node.
    -- -----------------------------------------------------------------

  METHOD GetFp       : STACK_ADDRESS_T;
    -- -----------------------------------------------------------------
    -- This method returns the frame pointer value of this node.
    -- -----------------------------------------------------------------

  METHOD PutNext     (IN nxt : ActiveFunction);
    -- -----------------------------------------------------------------
    -- This method links this node as a predecessor node of nxt.
    -- -----------------------------------------------------------------

  METHOD GetNext     : ActiveFunction;
    -- -----------------------------------------------------------------
    -- This method returns the node following this node.
    -- -----------------------------------------------------------------

  METHOD PutPrev     (IN prv : ActiveFunction);  
    -- -----------------------------------------------------------------
    -- This method links this node as a successor node of prv.
    -- -----------------------------------------------------------------

  METHOD GetPrev     : ActiveFunction;
    -- -----------------------------------------------------------------
    -- This method returns the node before this node.
    -- -----------------------------------------------------------------

  METHOD UserVisible     : BOOL;
    -- -----------------------------------------------------------------
    -- This method answers the question for user visibility
    -- -----------------------------------------------------------------
    
  METHOD IsInactive      : BOOL;
    -- -----------------------------------------------------------------
    -- This method answers the question, whether this function is
    -- active, say currently running.
    -- -----------------------------------------------------------------
    
PROTECTED
    
STATE
  next         : ActiveFunction;	 -- link to next list element
  prev         : ActiveFunction;	 -- link to the previous list
					 -- element 
  function     : Function;		 -- function descriptor
  framepointer : STACK_ADDRESS_T;	 -- framepointer value for the
					 -- active function
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE ActiveFunctionStack = OBJECT

PUBLIC
  
  METHOD ReadActiveStack (IN    fp : STACK_ADDRESS_T, 
			  IN    pc : INT);    
    -- -----------------------------------------------------------------
    -- This method reads the actual stack of the now stopped process
    -- -----------------------------------------------------------------
  
  METHOD Finalize;
    -- -----------------------------------------------------------------
    -- Remove the whole stack.
    -- -----------------------------------------------------------------
  
  METHOD Push (IN func : Function, IN fp : STACK_ADDRESS_T);
    -- -----------------------------------------------------------------
    -- Push the function func on the function stack.
    -- -----------------------------------------------------------------
  
  METHOD Pop;
    -- -----------------------------------------------------------------
    -- Remove the top function from the stack.
    -- -----------------------------------------------------------------
  
  METHOD Top                 : ActiveFunction;    
    -- -----------------------------------------------------------------
    -- This method returns the top function from the routine stack
    -- -----------------------------------------------------------------

  METHOD SearchFunction      (IN func : Function) : ActiveFunction;
    -- -----------------------------------------------------------------
    -- This method searches the function func in the active
    -- function stack. If it is found, the node containing the
    -- function  is returned, NIL otherwise.
    -- -----------------------------------------------------------------

  METHOD PatchActiveRoutines;
    -- -----------------------------------------------------------------
    -- This method patches all functions on the stack before
    -- singlestepping. 
    -- -----------------------------------------------------------------

  METHOD UnpatchActiveRoutines;
    -- -----------------------------------------------------------------
    -- This method unpatches all functions on the stack after
    -- singlestepping. 
    -- -----------------------------------------------------------------

  METHOD PatchCallerRoutines;
    -- -----------------------------------------------------------------
    -- This method patches all functions but the top function on the
    -- stack for the return command. 
    -- -----------------------------------------------------------------

  METHOD UnpatchCallerRoutines;
    -- -----------------------------------------------------------------
    -- This method unpatches all functions but the top function on the
    -- stack after the return command. 
    -- -----------------------------------------------------------------
  
  METHOD ShowStackTrace;
    -- -----------------------------------------------------------------
    -- This method lists the actual stack of active functions on the
    -- screen. 
    -- -----------------------------------------------------------------

  METHOD SearchVariable     (IN  var_name : ARRAY OF CHAR,
			     OUT function : Function) : Variable;
    -- -----------------------------------------------------------------
    -- This method searches a variable specified by name in all
    -- routines of the routine stack.
    -- -----------------------------------------------------------------

PROTECTED
    
STATE
  stackTop  : ActiveFunction;		 -- top of stack

END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE CallChain = ActiveFunctionStack OBJECT
  
PUBLIC
  
  METHOD HandleRoutineCall  (IN function : Function);
    -- -----------------------------------------------------------------
    -- This method cleans the stack in case of a routine call.
    -- -----------------------------------------------------------------
 
PROTECTED
  
STATE
  callChain : ActiveFunction;		 -- function call chain
  callLevel : STACK_ADDRESS_T;		 -- depth of calls, relativ to main

END OBJECT;

END SPECIFICATION;
