/*                               -*- Mode: C -*- 
 * cofflowlev.c -- contains those routines not realizable in CooL for coff
 * 
 *   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
 *   All rights reserved
 * 
 * AtFSID          : $Header: cofflowlev.c[1.0] Wed Jan  5 10:23:53 1994 lutz@hawaii proposed $
 * Author          : Lutz Hilken
 *
 * Created On      : Fri Mar  5 09:54:03 1993
 * Last Modified By: unknown full name
 * Last Modified On: Tue Jun 14 12:14:18 1994
 * Update Count    : 14
 * 
 * HISTORY
 * 28-Oct-1993		Lutz Hilken	
 *    Last Modified: Thu Jul 22 17:27:26 1993 #10 (Lutz Hilken)
 *    Version after Champs error
 * 5-Mar-1993		Lutz Hilken	
 *    Last Modified: Fri Mar  5 09:54:55 1993 #1 (Lutz Hilken)
 *    First version, adapded from lowlevel.c
 * PURPOSE
 * 	|>Description of modules purpose<|
 * TABLE OF CONTENTS
 * 
 */

/* #include <unistd.h> */
#include <stdio.h>
/* #include <syms.h> */
#include <sys/types.h>
/* #include <sys/signal.h> */
#include <sys/stat.h>
#include <stdarg.h>

/* **************************************************************/

enum BOOL {FALSE, TRUE};

/* **************************************************************/

#define DT_NON 0
#define DT_PTR 1
#define DT_FCN 2
#define DT_ARY 3 

typedef struct _SYMENT {
  union {
    unsigned char _n_name[8];
    struct {
      unsigned long int _n_zeros;
      unsigned long int _n_offset;
    } _n_n;
    unsigned char *_n_nptr[2];
  } _n;
  unsigned long int n_value;
  unsigned short n_scnum;
  unsigned short n_type;
  unsigned char n_sclass;
  unsigned char n_numaux;
} SYMENT;

/* **************************************************************/

/* Type (fundamental) values. */

#define IMAGE_SYM_TYPE_NULL                  0     /* no type. */
#define IMAGE_SYM_TYPE_VOID                  1        
#define IMAGE_SYM_TYPE_CHAR                  2     /* type character. */
#define IMAGE_SYM_TYPE_SHORT                 3     /* type short integer. */
#define IMAGE_SYM_TYPE_INT                   4           
#define IMAGE_SYM_TYPE_LONG                  5           
#define IMAGE_SYM_TYPE_FLOAT                 6           
#define IMAGE_SYM_TYPE_DOUBLE                7           
#define IMAGE_SYM_TYPE_STRUCT                8           
#define IMAGE_SYM_TYPE_UNION                 9           
#define IMAGE_SYM_TYPE_ENUM                  10    /* enumeration. */
#define IMAGE_SYM_TYPE_MOE                   11    /* member of enumeration. */
#define IMAGE_SYM_TYPE_BYTE                  12          
#define IMAGE_SYM_TYPE_WORD                  13          
#define IMAGE_SYM_TYPE_UINT                  14          
#define IMAGE_SYM_TYPE_DWORD                 15          

/* Type (Derived) Values. */

#define IMAGE_SYM_DTYPE_NULL                 0     /* no derived type. */
#define IMAGE_SYM_DTYPE_POINTER              1     /* pointer. */
#define IMAGE_SYM_DTYPE_FUNCTION             2     /* function. */
#define IMAGE_SYM_DTYPE_ARRAY                3     /* array. */

/* Storage Classes. */

#define IMAGE_SYM_CLASS_END_OF_FUNCTION      (BYTE )-1
#define IMAGE_SYM_CLASS_NULL                 0
#define IMAGE_SYM_CLASS_AUTOMATIC            1
#define IMAGE_SYM_CLASS_EXTERNAL             2
#define IMAGE_SYM_CLASS_STATIC               3
#define IMAGE_SYM_CLASS_REGISTER             4
#define IMAGE_SYM_CLASS_EXTERNAL_DEF         5
#define IMAGE_SYM_CLASS_LABEL                6
#define IMAGE_SYM_CLASS_UNDEFINED_LABEL      7
#define IMAGE_SYM_CLASS_MEMBER_OF_STRUCT     8
#define IMAGE_SYM_CLASS_ARGUMENT             9
#define IMAGE_SYM_CLASS_STRUCT_TAG           10
#define IMAGE_SYM_CLASS_MEMBER_OF_UNION      11
#define IMAGE_SYM_CLASS_UNION_TAG            12
#define IMAGE_SYM_CLASS_TYPE_DEFINITION      13
#define IMAGE_SYM_CLASS_UNDEFINED_STATIC     14
#define IMAGE_SYM_CLASS_ENUM_TAG             15
#define IMAGE_SYM_CLASS_MEMBER_OF_ENUM       16
#define IMAGE_SYM_CLASS_REGISTER_PARAM       17
#define IMAGE_SYM_CLASS_BIT_FIELD            18
#define IMAGE_SYM_CLASS_BLOCK                100
#define IMAGE_SYM_CLASS_FUNCTION             101
#define IMAGE_SYM_CLASS_END_OF_STRUCT        102
#define IMAGE_SYM_CLASS_FILE                 103
/* new */
#define IMAGE_SYM_CLASS_SECTION              104
#define IMAGE_SYM_CLASS_WEAK_EXTERNAL        105

/* type packing constants */

#define N_BTMASK                            017
#define N_TMASK                             060
#define N_TMASK1                            0300
#define N_TMASK2                            0360
#define N_BTSHFT                            4
#define N_TSHIFT                            2

/* MACROS */

/* Basic Type of  x */

#define BTYPE(x) ((x) & N_BTMASK)

/* Is x a pointer? */
#ifndef ISPTR
#define ISPTR(x) (((x) & N_TMASK) == (IMAGE_SYM_DTYPE_POINTER << N_BTSHFT))
#endif

/* Is x a function? */
#ifndef ISFCN
#define ISFCN(x) (((x) & N_TMASK) == (IMAGE_SYM_DTYPE_FUNCTION << N_BTSHFT))
#endif

/* Is x an array? */

#ifndef ISARY
#define ISARY(x) (((x) & N_TMASK) == (IMAGE_SYM_DTYPE_ARRAY << N_BTSHFT))
#endif

/* Is x a structure, union, or enumeration TAG? */
#ifndef ISTAG
#define ISTAG(x) ((x)==IMAGE_SYM_CLASS_STRUCT_TAG || (x)==IMAGE_SYM_CLASS_UNION_TAG || (x)==IMAGE_SYM_CLASS_ENUM_TAG)
#endif

#ifndef INCREF
#define INCREF(x) ((((x)&~N_BTMASK)<<N_TSHIFT)|(IMAGE_SYM_DTYPE_POINTER<<N_BTSHFT)|((x)&N_BTMASK))
#endif
#ifndef DECREF
#define DECREF(x) ((((x)>>N_TSHIFT)&~N_BTMASK)|((x)&N_BTMASK))
#endif

/* **************************************************************/

int check_dn (n_type, shift_value, check)
     /* **************************************************************
      * This procedure works on the damned derived type entry of the
      * coff symbol table. I hate it. The derived type information is
      * stored in the upper 12 bits of a 16 bit word. 
      * But not enough: A derived type info is stored in a 2 Bit
      * field. It's really cruel. Awful. 
      * ************************************************************** */

     unsigned short n_type;
     int            shift_value;
     int            check;

{
  n_type <<= shift_value;	/* shift to left */
  n_type >>= 14;		/* shift to right. */
  n_type &= 3;			/* Now just the first 2 Bits are */
				/* important. */
  switch (check)		/* Now check it: which derived do we have? */
    {
    case DT_NON:		/* It shall not be derived. */
      if (check == n_type)
	{
	  return (TRUE);	/* IT IS NOT DERIVED. Yeah. */
	} /*ENDIF*/
      break;
    case DT_PTR:		/* It shall be a pointer */
      if (check == n_type)
	{
	  return (TRUE);	/* It is a pointer. */
	} /*ENDIF*/
      break;
    case DT_FCN:		/* It shall be a function.  */
      if (check == n_type)
	{
	  return (TRUE);	/* It is a function. */
	} /*ENDIF*/
      break;
    case DT_ARY:		/* It shall be an array. */
      if (check == n_type)
	{
	  return (TRUE);	/* It is an array. */
	} /*ENDIF*/
      break;
    }
  return (FALSE);		/* It is something else. */
}

/* **************************************************************/

enum BOOL isary (sym)
     SYMENT * sym;
     /* **************************************************************
      * This procedure checks, whether the symbol describes an array.
      * ************************************************************** */
{
  int i;

  for (i=0;i<=10;i+=2)		/* check all derived type infos. */
    {
      if (check_dn (sym->n_type, i, DT_ARY) == TRUE)
        {			/* If one of them is an array entry, */
				/* we'v got it. */
          return (TRUE);
        }
    } /*ENDFOR*/
  return (FALSE);		/* Sad but true. It's not an array. */
}

/* **************************************************************/

enum BOOL is_func_returning_func (sym)
     SYMENT * sym;
     /* **************************************************************
      * This procedure checks whether the symbol sym describes a
      * procedure type.
      * ************************************************************** */
{
  int i;

  for (i=8;i>=0;i-=2)		/* NOTE: Because we're checking a */
				/* function, we can skip the first 2 */
				/* bits.  */
    {
      if (check_dn (sym->n_type, i, DT_FCN) == TRUE)
        {			/* If one of the following entries is */
				/* a function entry, we've got it. */
          return (TRUE);
        }
    } /*ENDFOR*/
  return (FALSE);		/* Sad but true. It's not a function. */
}

/* **************************************************************/

enum BOOL isfcn (sym)
     SYMENT * sym;
     /* **************************************************************
      * This function checks, whether the symbol sym describes a
      * function. It simply "calls" a predefined COFF macro.
      * ************************************************************** */
{
  if (ISFCN (sym->n_type))
    {
      return (TRUE);		/* It is a function. */
    }
  return (FALSE);		/* It's not. */
}

/* **************************************************************/

enum BOOL IsTag (sym)
     SYMENT * sym;
     /* **************************************************************
      * This procedure checks, whether the symbol sym describes a
      * tag symbol. It simply "calls" a predefined COFF macro.
      * ************************************************************** */
{
  if (ISTAG (sym->n_sclass))
    {
      return (TRUE);		/* It is. */
    }
  return (FALSE);		/* It is not. */
}

/* **************************************************************/

enum BOOL is_ptr (sym, depth)
     SYMENT * sym;
     int            *depth;
     /* **************************************************************
      * This procedure checks whether the symbol sym describes a
      * pointer to something, and returns also the number of
      * references. 
      * ************************************************************** */
{
  int i;
  enum BOOL it_is;

  *depth = 0;
  it_is = FALSE;
  for (i=0;i<=10;i+=2)		/* check all entries */
    {
      if (check_dn (sym->n_type, i, DT_PTR) == TRUE)
        {			/* Got a pointer entry. Increment the */
				/* total amount. */
          *depth += 1;
          it_is = TRUE;
        }
    } /*ENDFOR*/
  return (it_is);
}

/* **************************************************************/
/* **************************************************************
 * 

                  HANDS UP!     REMOVE YOUR GLASSES!


     
   This is one of the uggliest, difficultest, error-prone procedures
   I've ever hacked.
   The problem I detected is, that the C compilers generare the
   derived type information in a very complicated, not orthogonal way
   (At least, *I* can't see something like that.)
   The statements you find below are the result of about 10 days.
   Really. I'm not sure, whether all cases possible are handled. My
   test programs work.

 * ************************************************************** */

#define TYPE_FIELD_SIZE 10

get_pointer_depth (sym, depth1, depth2, is_func)
     SYMENT    * sym;
     int       * depth1;
     int       * depth2;
     enum BOOL * is_func;
{
  int i;
  int array_count = 0;
  enum BOOL it_is;
  enum BOOL array_detected = FALSE;
  /*
  int  type[TYPE_FIELD_SIZE] = {DT_NON, DT_NON, DT_NON, DT_NON, DT_NON, 
		   DT_NON, DT_NON, DT_NON, DT_NON, DT_NON };
  */
  static int  type[TYPE_FIELD_SIZE];

  for (i=0;i<TYPE_FIELD_SIZE;i++)
    {
      type [i] = DT_NON;
    }
  *depth1 = 0;
  *depth2 = 0;
  *is_func = FALSE;
  array_count = 0;
  for (i=0;i<=10;i+=2)
    {
      if (check_dn (sym->n_type, i, DT_FCN) == TRUE)
        {
          type [array_count++] = DT_FCN;
	  *is_func = TRUE;
        }
      else
	{
	  if (check_dn (sym->n_type, i, DT_ARY) == TRUE)
	    {
	      type [array_count++] = DT_ARY;
	    }
	  else
	    {
	      if (check_dn (sym->n_type, i, DT_PTR) == TRUE)
		{
		  type [array_count++] = DT_PTR;
		}
	    }
	}
    }
  *depth1 = 0;
  *depth2 = 0;
  if (type [0] == DT_PTR)
    {
      int flag = 0;

      for (i=0; type [i] == DT_PTR && i < TYPE_FIELD_SIZE; )
	{
	  *depth2 += 1;
	  i++;
	}
      for (; type [i] == DT_ARY && i < TYPE_FIELD_SIZE;)
	{
	  i++;
	  flag++;
	}
      for (;type [i] == DT_PTR && i < TYPE_FIELD_SIZE;)
	{
	  *depth1 += 1;
	  flag++;
	  i++;
	}
      if (flag == 0)
	{
	  *depth1 = *depth2;
	  *depth2 = 0;
	}
    }
  else
    {
      int flag = 0;

      if (type [0] == DT_ARY)
	{
	  *depth2 = 0;
	}
      for (i=0; type [i] == DT_ARY && i < TYPE_FIELD_SIZE;)
	{
	  i++;
	}
      for (;type [i] == DT_PTR && i < TYPE_FIELD_SIZE; i++)
	{
	  *depth1 += 1;
	}
      for (; type [i] == DT_ARY && i < TYPE_FIELD_SIZE;)
	{
	  i++;
	  if (*depth1 > 0)
	    {
	      *depth2 = *depth1;
	      *depth1 = 0;
	    }
	}
      for (;type [i] == DT_PTR && i < TYPE_FIELD_SIZE; i++)
	{
	  *depth1 += 1;
	}

    }
}

/* **************************************************************/

enum BOOL is_ptr_to_array (sym, depth1, depth2)
     /* **************************************************************
      * Never used. Delete it if you want.
      * ************************************************************** */

     SYMENT *sym;
     int    *depth1;
     int    *depth2;
{
  int i;
  enum BOOL it_is;
  enum BOOL it_is1;

  *depth1 = 0;
  *depth2 = 0;
  it_is   = FALSE;
  it_is1  = FALSE;
  for (i=0;i<=10;i+=2)
    {
      if ((check_dn (sym->n_type, i, DT_ARY) == TRUE) &&
	 (i > 0) && (*depth1 > 0) && (it_is == FALSE))
        {
	  it_is = TRUE;
        }
      if (check_dn (sym->n_type, i, DT_PTR) == TRUE)
        {
	  if (it_is == FALSE)
	    {
	      *depth1 += 1;
	    }
	  else
	    {
	      *depth2 += 1;
	    }
        }
    }
  return it_is;
}

/* **************************************************************/

enum BOOL is_array_of_ptr (sym, depth)
     /* **************************************************************
      * Never used. Delete it if you want.
      * ************************************************************** */

     SYMENT *sym;
     int    *depth;
{
  int i;
  enum BOOL it_is;
  enum BOOL it_is1;

  *depth  = 0;
  it_is   = FALSE;
  it_is1  = FALSE;
  for (i=0;i<=10;i+=2)
    {
      if (check_dn (sym->n_type, i, DT_ARY) == TRUE)
        {
	  it_is1 = TRUE;
        }
      if ((check_dn (sym->n_type, i, DT_PTR) == TRUE) &&
	  (it_is1 == TRUE) && (i>0))
        {
	  *depth += 1;
	  it_is = TRUE;
        }
    }
  return it_is;
}


/* **************************************************************/

int basetype (uis)
     unsigned short int uis;
     /* **************************************************************
      * This procedure returns the base type info from the derived
      * type entry. See COFF doc for ore info.
      * It simply calls a predefined macro.
      * ************************************************************** */
{
  return BTYPE (uis);
}

/* **************************************************************/

int usi_to_int (usi)
     unsigned short int usi;
     /* **************************************************************
      * Just a converter. Damned loved CooL type checking.
      * ************************************************************** */
{
  return (int) usi;
}

/* **************************************************************/

int myftell (fil)
     FILE *fil;
     /* **************************************************************
      * Used in the good ol' CoLibri-free days. Sigh.
      * ************************************************************** */
{
  return ftell (fil);
}

/* **************************************************************/

void myfree (p)
  char *p;
     /* **************************************************************
      * Used in the good ol' CoLibri-free days. Sigh.
      * ************************************************************** */
{
  free (p);
}

/* **************************************************************

enum BOOL file_is_readable (fn)
     char *fn;
     * **************************************************************
     * Used in the good ol' CoLibri-free days. Sigh.
     * ************************************************************** *
{
  if (access (fn, F_OK) == 0)
    {
      if (access (fn, R_OK) == 0)
	{
	  return TRUE;
	}
    }
  return FALSE;
}

/* **************************************************************/

int shift_byte_right (b, count)
     char b;
     int  count;
     /* **************************************************************
      * Used for bit hacking. Not possible in CooL. At least in a
      * simple way.
      * ************************************************************** */
{
  return (int) b>>count;
}

/* **************************************************************/

int shift_byte_left (b, count)
     char b;
     int  count;
     /* **************************************************************
      * Used for bit hacking. Not possible in CooL. At least in a
      * simple way.
      * ************************************************************** */
{
  return (int) b<<count;
}

/* **************************************************************/

int ByteAnD (a1, a2)
     char a1;
     char a2;
     /* **************************************************************
      * Used for bit hacking. Not possible in CooL. At least in a
      * simple way.
      * ************************************************************** */
{
  return (int) a1 & a2;
}

/* **************************************************************/

int ByteOr (a1, a2)
     long a1;
     long a2;
     /* **************************************************************
      * Used for bit hacking. Not possible in CooL. At least in a
      * simple way.
      * ************************************************************** */
{
  return (long) a1 | a2;
}

/* **************************************************************/

int getFileDate (fil)
     int fil;
     /* **************************************************************
      * Used in the good ol' CoLibri-free days. Sigh.
      * LIE! NOT TRUE! Damned Colibri! Still need this one! Doesn't
      * work correct on MX 300i!
      * ************************************************************** */
{
  struct _stat buf;

  fstat (fil, &buf);
  return buf.st_mtime;
}

/* **************************************************************/

extern FILE *errorC3IGetOutputFile ();

void Trace (char *msg, ... )
     /* va_dcl */
{
  va_list ap;

  va_start (ap, msg);
  fprintf (errorC3IGetOutputFile (), "  ->  ");
  vfprintf (errorC3IGetOutputFile (), msg, ap);
  va_end (ap);
  fflush (errorC3IGetOutputFile ());
}

/* **************************************************************/

void Message (char *msg, ... )
    /* va_dcl */
{
  va_list ap;

  va_start (ap, msg);
  vfprintf (errorC3IGetOutputFile (), msg, ap);
  /* signal (SIGPIPE, SIG_IGN); */
  va_end (ap);
  fflush (errorC3IGetOutputFile ());
}
