--                             -*- Mode: Cool2 -*- 
-- maxfile.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: file.cs[1.0] Tue Feb 22 10:00:03 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 09:52:45 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Fri Jun 10 15:16:25 1994
-- Update Count    : 7
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION maxfile

IMPORT String FROM mystring;
IMPORT MySet FROM Bayer;
IMPORT Variable FROM variable;
IMPORT Function FROM function;
IMPORT StopPoint, BreakTracePoint FROM break;
IMPORT FixedString FROM globals;
IMPORT FILE FROM Basics;

VAR actual_file : File;			 -- The actual file is the
					 -- file containing the actual
					 -- source line
VAR windowSize  : INT;			 -- specifies the number of
					 -- line printed in the window
					 -- command.

---------------------------------------------------------------------

-- -----------------------------------------------------------------
-- The following type is used as a container description for the link
-- between CooL source code and C source code. 
-- c_line is the line number of a C code line, cool_line is the number
-- of the corresponding cool source line.
-- -----------------------------------------------------------------

CONST MAX_SOURCE_STRING : INT = 1000;

TYPE Line_t = RECORD
  c_line    : UNSIGNED SHORT INT;
  cool_line : UNSIGNED SHORT INT;
  filename  : String;
END RECORD;

TYPE File = OBJECT (IN filnam : String,	 -- name of the file e.g. file.t
                    IN smbtaboffset : UNSIGNED INT,
					 -- position in the symbol
					 -- table of the object file
                    IN nxt_fil      : UNSIGNED INT)
					 -- poistion of the next
					 -- description of a file
  -- -----------------------------------------------------------------
  -- This Type describes a file. 
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetName  : String;
    -- -----------------------------------------------------------------
    -- This method returns the name of the file for displaying. 
    -- -----------------------------------------------------------------

  METHOD GetFileName : String;
    -- -----------------------------------------------------------------
    -- This method returns the *real* name of the file for filesystem.
    -- -----------------------------------------------------------------

  METHOD IsCooLFile   : BOOL;
    -- -----------------------------------------------------------------
    -- No comment.
    -- -----------------------------------------------------------------

  METHOD CheckCooLFile : BOOL;
    -- -----------------------------------------------------------------
    -- This method determines, whether the file is a CooL source file
    -- or a C source file. It returns FALSE, if the file is not
    -- accessible 
    -- -----------------------------------------------------------------


  METHOD GetOffset : UNSIGNED INT;
    -- -----------------------------------------------------------------
    -- This method returns the position of the first symbol table
    -- entry in the symbol table of the debugged process regarding
    -- this file.
    -- -----------------------------------------------------------------

  METHOD GetOffsetNextFile    : UNSIGNED INT;
    -- -----------------------------------------------------------------
    -- This method returns the position of the first symbol table
    -- entry in the symbol table of the debugged process regarding
    -- the next file.
    -- -----------------------------------------------------------------

  METHOD PutOffsetNextFile (i  : UNSIGNED INT);
    -- -----------------------------------------------------------------
    -- This method writes the position of the first symbol table
    -- entry in the symbol table of the debugged process regarding
    -- the next file.
    -- -----------------------------------------------------------------

  METHOD GetStatics : MySet;
    -- -----------------------------------------------------------------
    -- This method returns the set of static variables declared in
    -- this file.
    -- -----------------------------------------------------------------

  METHOD AddStatic              (IN var  : Variable);
    -- -----------------------------------------------------------------
    -- This method adds a variable description to the set of static
    -- variables. 
    -- -----------------------------------------------------------------
    
  METHOD PutStatics              (INOUT set : MySet);
    -- -----------------------------------------------------------------
    -- This methods fills the instance variables statics with a set of
    -- variable definitions.
    -- -----------------------------------------------------------------

  METHOD PrintStatics;
    -- -----------------------------------------------------------------
    -- This methods list all static variables of this file. For each
    -- variable name, type and value is presented.
    -- -----------------------------------------------------------------

  METHOD WhereisVariable         (IN name : ARRAY OF CHAR) : BOOL; 
    -- -----------------------------------------------------------------
    -- This method searches all definitions of the variable specified
    -- by name in the file. All occurances are listed together with a
    -- type information.
    -- For this purpose, all functions in this fileare searched.
    -- The static variables are searched from somewhere else; see execut.t. 
    -- If no variable with this name is found, FALSE is returned;
    -- otherwise TRUE.
    -- -----------------------------------------------------------------

  METHOD SearchStaticVariable   (IN varname : ARRAY OF CHAR) : Variable;
    -- -----------------------------------------------------------------
    -- This method searches a variable specified by varname in the set of
    -- static variables.
    -- If no variable with this name is found, NIL is returned;
    -- otherwise the object describing this variable..
    -- -----------------------------------------------------------------

  METHOD SearchLocalVariable    (IN  varname  : ARRAY OF CHAR,
                                 OUT function : Function) : Variable;
    -- -----------------------------------------------------------------
    -- This method searches the variable specified by varname in all
    -- functions declared in this file.
    -- If no variable with this name is found, NIL is returned;
    -- otherwise the object describing this variable..
    -- -----------------------------------------------------------------

  METHOD GetFunctions           : MySet;
    -- -----------------------------------------------------------------
    -- This method returns the set of routines defined in this file.
    -- -----------------------------------------------------------------

  METHOD AddFunction            (IN func : Function);
    -- -----------------------------------------------------------------
    -- This method adds a function description to the set of functions
    -- declared in this file.
    -- -----------------------------------------------------------------

  METHOD MarkFunctionEntries;
    -- -----------------------------------------------------------------
    -- This method marks all function entries declared in this file
    -- with an invisible breakpoint. See break.t.
    -- -----------------------------------------------------------------

  METHOD UnmarkFunctionEntries;
    -- -----------------------------------------------------------------
    -- This method removes the invisible breakpoints from all function
    -- entries declared in this file. See break.t.
    -- -----------------------------------------------------------------

  METHOD Print;
    -- -----------------------------------------------------------------
    -- This method lists all infos of this file.
    -- -----------------------------------------------------------------

  METHOD PrintFunctionList;
    -- -----------------------------------------------------------------
    -- This method lists all function definitions of this file.
    -- -----------------------------------------------------------------

  METHOD PrintProcedureList;
    -- -----------------------------------------------------------------
    -- This method lists all CooL procedures defined in this file.
    -- -----------------------------------------------------------------

  METHOD CreateFunctionList;
    -- -----------------------------------------------------------------
    -- This method initiates the creation of set of function declared
    -- in this file. 
    -- -----------------------------------------------------------------

  METHOD GetFunctionCount        : INT;
    -- -----------------------------------------------------------------
    -- This method returns the number of routines declared in this file.
    -- -----------------------------------------------------------------

  METHOD SearchFunctionByAddress (IN address : INT) : Function;
    -- -----------------------------------------------------------------
    -- This method searches a function specified by the address of its
    -- call entry in the set of functions declared in this file.
    -- If no function with this entry point is found, NIL is returned.
    -- -----------------------------------------------------------------

  METHOD SearchFunctionByIndex (IN index : INT) : Function;
    -- -----------------------------------------------------------------
    -- This method searches a function specified by its position
    -- (== index) in the symbol table of the executable object file.
    -- If no function with this index is found, NIL is returned.
    -- -----------------------------------------------------------------

  METHOD SearchFunction (IN function_name : ARRAY OF CHAR) : Function;
    -- -----------------------------------------------------------------
    -- This method searches a function specified by function_name.
    -- If no function with this name is found, NIL is returned.
    -- -----------------------------------------------------------------

  METHOD List;
    -- -----------------------------------------------------------------
    -- This method lists the source of this file.
    -- -----------------------------------------------------------------

  METHOD Window                  (IN text_address : INT,
			          IN show_arrow   : BOOL);
    -- -----------------------------------------------------------------
    -- This method lists some source lines before the actual line and
    -- some source lines after the actual line.
    -- line specifies the actual line; show_arrow specifies whether
    -- this line shall be marked with an "===>".
    -- -----------------------------------------------------------------

  METHOD XPrintSource            (IN text_address : INT);
    -- -----------------------------------------------------------------
    -- This line prints the source line  specified by text_address.
    -- -----------------------------------------------------------------
  
  METHOD SearchLine   (IN line : INT) : BreakTracePoint;
    -- -----------------------------------------------------------------
    -- This method searches a source line specified by line and
    -- returns the break point information for this line.
    -- NIL is returned, if the source line cannot be found.
    -- -----------------------------------------------------------------

  METHOD SearchLines  (IN line : INT) : MySet;
    -- -----------------------------------------------------------------
    -- This method searches all source lines with the number line and
    -- returns the set of break points for this lines.
    -- -----------------------------------------------------------------

  METHOD SearchBreakpoint   (IN line : INT) : StopPoint;
    -- -----------------------------------------------------------------
    -- This method searches a breakpoint specified by txt_addr in the
    -- set of breakpoints.
    -- -----------------------------------------------------------------

  METHOD TraceAll;
    -- -----------------------------------------------------------------
    -- This method marks the source lines of each function declared in
    -- this file as traced.
    -- -----------------------------------------------------------------

  METHOD UntraceAll;
    -- -----------------------------------------------------------------
    -- This method marks the source lines of each function declared in
    -- this file as not traced.
    -- -----------------------------------------------------------------

  METHOD UnbreakAll;
    -- -----------------------------------------------------------------
    -- This method marks the source lines of each function declared in
    -- this file as not marked with a breakpoint.
    -- -----------------------------------------------------------------

  METHOD ListBreaksAndTraces;
    -- -----------------------------------------------------------------
    -- This method lists all break and trace points in this file.
    -- -----------------------------------------------------------------

  METHOD PutBreakpointsOffset    (IN off : INT);
    -- -----------------------------------------------------------------
    -- This method stores the position of the first possible
    -- breakpoint of this file in the instance variable
    -- breakpointsOffset.
    -- This method is used for debugging ELF files only. See elfbib.t
    -- -----------------------------------------------------------------

  METHOD GetBreakpointsOffset    : INT;
    -- -----------------------------------------------------------------
    -- This method retrieves the position of the first possible
    -- breakpoint of this file from the instance variable
    -- breakpointsOffset.
    -- This method is used for debugging ELF files only. See elfbib.t
    -- -----------------------------------------------------------------

  METHOD GetCooLCLines           : MySet;
    -- -----------------------------------------------------------------
    -- This method returns the set of links between CooL source lines
    -- and C source lines.
    -- -----------------------------------------------------------------
   
  METHOD PrintPrologueSizes () : INT;
    -- -----------------------------------------------------------------
    -- This method is for debugging needs
    -- -----------------------------------------------------------------

  METHOD PrintBlocks ();
    -- -----------------------------------------------------------------
    -- This method is for debugging needs
    -- -----------------------------------------------------------------

  METHOD SearchPragmaFile (IN name : FixedString) : File;
    -- -----------------------------------------------------------------
    -- This method searches the name in pragma files.
    -- -----------------------------------------------------------------
    
PROTECTED
  
STATE

  filename          : String;		 -- name of the file
  displayname       : String;		 -- name of the file for display
  functions         : MySet;		 -- SET OF Function
  statics           : MySet;		 -- SET OF Variable
  c_lines           : MySet;		 -- SET OF Line_t needed for
					 -- retrieving the right
					 -- C-C00L connection;
  cool              : BOOL;		 -- is this file a CooL file?
  offset            : UNSIGNED INT;	 -- offset of the first symbol
					 -- table entry  describing
					 -- this file.
  next_file         : UNSIGNED INT;	 -- offset of the first symbol
					 -- table entry of the next file.
  src_files         : MySet;		 -- Set of files to display.
  breakpointsOffset : INT;		 -- offset of the first
					 -- breakpoint of this file
					 -- (used for ELF only)
  statics_loaded    : BOOL;		 -- optimizer: are the static
					 -- variables loaded already ?
					 -- important for files
					 -- without static variables!

END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE SourceFile = OBJECT (IN name : String)
  
PUBLIC

  METHOD Window (IN line : INT,
		 IN function : Function,
		 IN show_arrow : BOOL);
    -- -----------------------------------------------------------------
    -- Draw window around line for function.
    -- -----------------------------------------------------------------
  
  METHOD Line   (IN line : INT);
    -- -----------------------------------------------------------------
    -- Print line.
    -- -----------------------------------------------------------------
  
  METHOD List   (IN file : File);
    -- -----------------------------------------------------------------
    -- List the complete source.
    -- -----------------------------------------------------------------
  
  METHOD GetNumberOfSourceLines  : INT;
    -- -----------------------------------------------------------------
    -- This method returns the number of lines in the source file of
    -- this file description.
    -- -----------------------------------------------------------------

  METHOD Print ();
    -- -----------------------------------------------------------------
    -- This method prints the source file info
    -- -----------------------------------------------------------------
    
PROTECTED
  
STATE
  fileptr   : REF FILE;
  open      : BOOL;
  filename  : String;
  source    : MySet;			 -- SET OF SourceLine
  number_of_lines   : INT;		 -- number of lines in the
					 -- source file of this file
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

END SPECIFICATION;

