--                             -*- Mode: Cool2 -*- 
-- function.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: function.cs[1.0] Tue Feb 22 10:00:14 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 09:54:02 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Fri Jun 10 15:16:44 1994
-- Update Count    : 3
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION function

IMPORT Type FROM type;
IMPORT File FROM maxfile;
IMPORT Variable, Address FROM variable;
IMPORT String FROM mystring;
IMPORT StopPoint, BreakTracePoint FROM break;
IMPORT MySet FROM Bayer;

TYPE Function = OBJECT (INOUT funcname  : ARRAY OF CHAR, -- name of
							 -- the function
                        IN address      : UNSIGNED INT,	-- entry point
							-- of the function
                        IN smbtaboffset : UNSIGNED INT,	-- offset in
							-- the symbol table
                        IN nxt_block    : UNSIGNED INT,	-- end of
							-- description
							-- of this
							-- function in
							-- the symbol table
                        IN frst_line    : INT, -- number of the first
					       -- source line of this function
                        IN lst_line     : INT, -- number of the last
					       -- source line of this function
                        IN type         : Type, -- type of this function
                        IN file         : File)	-- the file this
						-- function is
						-- declared in
PUBLIC

  METHOD GetName         : String;
    -- -----------------------------------------------------------------
    -- This method returns the original name of the function. Original
    -- names are those names taken directly from the symbol table of
    -- the debugged process.
    -- -----------------------------------------------------------------

  METHOD GetCooLName     : String;
    -- -----------------------------------------------------------------
    -- This method returns the modified name of the function.
    -- Example: original name: TestC3IINITIALLY
    --          CooL name    : Test.INITIALLY
    -- -----------------------------------------------------------------

  METHOD GetFile         : File;
    -- -----------------------------------------------------------------
    -- This method returns the file, where this function is declared
    -- in. 
    -- -----------------------------------------------------------------

  METHOD GetCompiler     : CCOMPILER;
    -- -----------------------------------------------------------------
    -- This method returns the C compiler, the function is compiled with
    -- -----------------------------------------------------------------

  METHOD GetEndSmbtabOffset      : UNSIGNED INT;
    -- -----------------------------------------------------------------
    -- This Method returns the offset of the first symbol table entry
    -- NOT belonging to this function. See coffbib.t.
    -- -----------------------------------------------------------------

  METHOD GetSmbTabOffset         : UNSIGNED INT;
    -- -----------------------------------------------------------------
    -- This Method returns the offset of the first symbol table entry
    -- belonging to this function. See coffbib.t.
    -- -----------------------------------------------------------------

  METHOD GetFirstCLine   : INT;
    -- -----------------------------------------------------------------
    -- This method returns the number of the first source line of this
    -- function in c. 
    -- -----------------------------------------------------------------

  METHOD GetFirstLine    : INT;
    -- -----------------------------------------------------------------
    -- This method returns the number of the first source line of this
    -- function. 
    -- -----------------------------------------------------------------

  METHOD GetLastLine     : INT;
    -- -----------------------------------------------------------------
    -- This method returns the number of the last source line of this
    -- function. 
    -- -----------------------------------------------------------------

  METHOD PutFirstLine    (IN line : INT);
    -- -----------------------------------------------------------------
    -- This method writes the number of the first source line of this
    -- function. 
    -- -----------------------------------------------------------------

  METHOD PutLastLine     (IN line : INT);
    -- -----------------------------------------------------------------
    -- This method writes the number of the last source line of this
    -- function. 
    -- -----------------------------------------------------------------

  METHOD GetStartAddress : INT;
    -- -----------------------------------------------------------------
    -- This method returns the entry point of this function.
    -- -----------------------------------------------------------------

  METHOD IsInvisible             : BOOL;
    -- -----------------------------------------------------------------
    -- This method indicates, whether the function is visible.
    -- -----------------------------------------------------------------

  METHOD IsEmpty             : BOOL;
    -- -----------------------------------------------------------------
    -- This method indicates, whether the function has breaklines.
    -- -----------------------------------------------------------------

  METHOD GetFirstPc              : BreakTracePoint;
    -- -----------------------------------------------------------------
    -- This method returns the address of the first statement of the
    -- first executable source line of this function.
    -- -----------------------------------------------------------------

  METHOD GetLastPc               : BreakTracePoint;
    -- -----------------------------------------------------------------
    -- This method returns the address of the last statement of the
    -- first executable source line of this function.
    -- -----------------------------------------------------------------

  METHOD GetEntry                : BreakTracePoint;
    -- -----------------------------------------------------------------
    -- This method returns the address of the first statement of the
    -- first executable source line of this function. No matter, if the
    -- first line is visible or not.
    -- -----------------------------------------------------------------

  METHOD GetBreakpoints  : MySet;
    -- -----------------------------------------------------------------
    -- This method returns the set of all possible breakpoints of this
    -- function. 
    -- -----------------------------------------------------------------

  METHOD GetActiveBlock  : Block;
    -- -----------------------------------------------------------------
    -- This method returns a block, if the one is active. NIL otherwise.
    -- -----------------------------------------------------------------

  METHOD AddBreakpoint   (IN brkpt : StopPoint);
    -- -----------------------------------------------------------------
    -- This method adds a breakpoint to the set of possible
    -- C breakpoints of this function.
    -- -----------------------------------------------------------------

  METHOD BreakEntry;
    -- -----------------------------------------------------------------
    -- This method marks the first source line of this function with a
    -- break point. 
    -- -----------------------------------------------------------------

  METHOD UnbreakEntry;
    -- -----------------------------------------------------------------
    -- This method unmarks the first source line of this function with a
    -- break point. 
    -- -----------------------------------------------------------------

  METHOD TraceAll;
    -- -----------------------------------------------------------------
    -- This method marks this function as being traced.
    -- -----------------------------------------------------------------

  METHOD UntraceAll;
    -- -----------------------------------------------------------------
    -- This method marks this function as not being traced.
    -- -----------------------------------------------------------------

  METHOD UnbreakAll;
    -- -----------------------------------------------------------------
    -- This method deletes all breakpoints defined in this function.
    -- -----------------------------------------------------------------

  METHOD BreakLine                  (IN line_no : INT);
    -- -----------------------------------------------------------------
    -- This method marks the specified line with a break point.
    -- -----------------------------------------------------------------

  METHOD TraceLine               (IN line_no : INT);
    -- -----------------------------------------------------------------
    -- This method marks the specified line with a trace point.
    -- -----------------------------------------------------------------

  METHOD MarkFunctionEntry;
    -- -----------------------------------------------------------------
    -- This method marks the entry point of this function with an
    -- invisible breakpoint. see break.t 
    -- -----------------------------------------------------------------

  METHOD UnmarkFunctionEntry;
    -- -----------------------------------------------------------------
    -- This method removes the invisible breakpoint from the entry
    -- point of this function. see break.t. 
    -- -----------------------------------------------------------------

  METHOD PatchForSingleStep;
    -- -----------------------------------------------------------------
    -- This methods marks all breakpoints of this function with an
    -- invisible breakpoint. see Technical description.
    -- -----------------------------------------------------------------

  METHOD UnpatchForSingleStep;
    -- -----------------------------------------------------------------
    -- This methods removes all invisible breakpoint within this
    -- function.see Technical description.
    -- -----------------------------------------------------------------

  METHOD SearchLine              (IN line : INT) : BreakTracePoint;
    -- -----------------------------------------------------------------
    -- This method searches the specified source line number in the
    -- set of breakpoints of this function. If it is found, the break
    -- point information of this line is returned; NIL otherwise.
    -- -----------------------------------------------------------------

  METHOD SearchBreakpoint        (IN pc : INT) : StopPoint;
    -- -----------------------------------------------------------------
    -- This method searched the specified text address in the set of
    -- breakpoints of this function.
    -- NIL is returned, if the pc can't be found.
    -- -----------------------------------------------------------------

  METHOD ListBreaksAndTraces;
    -- -----------------------------------------------------------------
    -- This method lists all break- and tracepoints marked in this
    -- function. 
    -- -----------------------------------------------------------------

  METHOD SearchVariable          (IN varname : ARRAY OF CHAR) : Variable;
    -- -----------------------------------------------------------------
    -- This method searches the variable specified by varname in the
    -- sets of parameterss andd local variables of this function.
    -- If the variable can't be found, NIL is returned.
    -- -----------------------------------------------------------------

  METHOD PrintName ();
    -- -----------------------------------------------------------------
    -- This method prints the name of this function.
    -- -----------------------------------------------------------------
  
  METHOD PrintParameter (IN fp          : Address,
			 IN indentation : INT);
    -- -----------------------------------------------------------------
    -- This method prints the parameter of this function. 
    -- -----------------------------------------------------------------

  METHOD PrintParamsAndLocals;
    -- -----------------------------------------------------------------
    -- This method prints both parameter and local variables of this
    -- function. 
    -- -----------------------------------------------------------------

  METHOD PrintResultType;
    -- -----------------------------------------------------------------
    -- This method prints the result type of this function.
    -- -----------------------------------------------------------------

  METHOD PutParameter            (IN set : MySet);
    -- -----------------------------------------------------------------
    -- This methods defines the set of parameters of this function.
    -- -----------------------------------------------------------------

  METHOD PutLocals               (IN set : MySet);
    -- -----------------------------------------------------------------
    -- This methods defines the set of local variables of this function.
    -- -----------------------------------------------------------------

  METHOD PutBlocks               (IN set : MySet);
    -- -----------------------------------------------------------------
    -- This method defines the set of block local variables of this
    -- function. 
    -- -----------------------------------------------------------------

  METHOD PutCompiler             (IN compiler : CCOMPILER);
    -- -----------------------------------------------------------------
    -- This method defines the type of compiler, the C source is compiled
    -- with.
    -- -----------------------------------------------------------------

  METHOD InitCallCount;
    -- -----------------------------------------------------------------
    -- This method inits the counter for the number of calls.
    -- -----------------------------------------------------------------

  METHOD CallCount;
    -- -----------------------------------------------------------------
    -- This method increments the counter for the number of calls.
    -- -----------------------------------------------------------------

  METHOD PrintCallCount;
    -- -----------------------------------------------------------------
    -- This method prints the name and the counter for the number of calls.
    -- -----------------------------------------------------------------

  METHOD FinitCallCount;
    -- -----------------------------------------------------------------
    -- This method finits the counter for the number of calls.
    -- -----------------------------------------------------------------

  METHOD PrintBlockInfo ();
    -- -----------------------------------------------------------------
    -- This method is for debugging needs
    -- -----------------------------------------------------------------
    
PROTECTED
  
STATE

  name              : String;		 -- original name of this funtion
  cool_name         : String;		 -- modified name of this function
  smb_tab_offset    : UNSIGNED INT;	 -- offset of the first symbol
					 -- table entry of this function
  next_smbtab_block : UNSIGNED INT;	 -- offset of the first symbol
					 -- table entry not belonging
					 -- to this function
  start_address     : INT;		 -- entry point of this function
  first_c_line      : INT;		 -- number of first source
					 -- line of this function in c
  first_line        : INT;		 -- number of first source
					 -- line of this function
  last_line         : INT;		 -- number of last source
					 -- line of this function
  base_type         : Type;		 -- base type of this function
					 -- case of being a structured type.
  source_file       : File;		 -- file this function is
					 -- declared in.
  parameter         : MySet;		 -- OF Variable
  locals            : MySet;		 -- OF Variable
  blockVariables    : MySet;		 -- SET OF Block;
  c_compiler        : CCOMPILER;	 -- which C compiler
  breakpoints       : MySet;		 -- OF Breakpoint
  visible_breakpoints : MySet;		 -- OF Breakpoint
  locals_loaded     : BOOL;		 -- flag. no comment
  coolConnected     : BOOL;		 -- Are the cool and c
					 -- breakpoints connected
  is_invisible      : BOOL;

  callCounter       : INT;		 -- How often are we called

END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE Block = OBJECT (IN first : INT,
                     IN last  : INT,
		     IN func  : Function)
  -- -----------------------------------------------------------------
  -- This object type describes nested blocks.
  -- Nested blocks are declared implicite by the CooL compiler, for
  -- FOR-LOOPS, EXCEPTION handling, TYPESELECT and other toys.
  -- -----------------------------------------------------------------

PUBLIC
 

  METHOD AddVariable (IN var   : Variable);
    -- -----------------------------------------------------------------
    -- This method adds a variable to this block.
    -- -----------------------------------------------------------------

  METHOD PutBlocks   (IN blcks : MySet);
    -- -----------------------------------------------------------------
    -- Nested blocks may contain nested blocks. 
    -- This method puts a set of nested blocks to this block.
    -- -----------------------------------------------------------------

  METHOD GetLastLine : INT;
    -- -----------------------------------------------------------------
    -- No comment.
    -- -----------------------------------------------------------------

  METHOD GetVariableCount : INT;
    -- -----------------------------------------------------------------
    -- No comment.
    -- -----------------------------------------------------------------

  METHOD IsBlockActive : BOOL;
    -- -----------------------------------------------------------------
    -- No comment.
    -- -----------------------------------------------------------------

  METHOD GetActiveBlock : Block;
    -- -----------------------------------------------------------------
    -- No comment.
    -- -----------------------------------------------------------------

  METHOD PrintBlockInfo (IN fp : Address);
    -- -----------------------------------------------------------------
    -- This method prints all variables within this block and the
    -- blocks nested in this block.
    -- -----------------------------------------------------------------

  METHOD SearchVariable (IN varname  : ARRAY OF CHAR) : Variable;
    -- -----------------------------------------------------------------
    -- This method searches a variables within this block and the
    -- blocks nested in this block
    -- -----------------------------------------------------------------
  
  METHOD PrintBlock ();
    -- -----------------------------------------------------------------
    -- Needed for debigging.
    -- -----------------------------------------------------------------

PROTECTED
  
STATE

  firstLine : INT;			 -- first line of the block range.
  lastLine  : INT;			 -- last line of the block range
  function  : Function;			 -- The function this block
					 -- belongs to.
  variables : MySet;			 -- SET OF Variable
  blocks    : MySet;			 -- SET OF Block; nested
					 -- blocks in this block.
  visited   : BOOL;			 -- Blockranges are defined in
					 -- C line numbers. Sad. 
					 -- To connect C-Blocks to
					 -- CooL-blocks, some
					 -- computation must be done.
					 -- this flag shows us,
					 -- whether this computation
					 -- is already done or not.
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE CCOMPILER = INT;

CONST CES : INT = 1;
CONST ATT : INT = 2;

END SPECIFICATION;

