--                             -*- Mode: Cool2 -*- 
-- expression.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: expression.cs[1.0] Tue Feb 22 09:59:54 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 09:51:37 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Fri Jun 10 15:16:46 1994
-- Update Count    : 7
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION expression

IMPORT File 
  FROM maxfile;
IMPORT Function 
  FROM function;
IMPORT Type 
  FROM type;
IMPORT Variable, Address 
  FROM variable;
IMPORT FixedString 
  FROM globals;

TYPE Expression = ABSTRACT OBJECT
  -- -----------------------------------------------------------------
  -- This type is the general Supertype for expressions. It's a
  -- deffered type. The hirachy looks like this:
  -- Expression
  --   |-- Identifier
  --   |-- IntegerConst
  --   |-- Selection
  --   |-- Subscription
  --   |-- Dereference
  -- Every expression has a type and can deliver a variable, which is
  -- the named equivalent to the given string. With this variable, the
  -- address of an expression can be computed.
  -- -----------------------------------------------------------------
  
PUBLIC
  
  ABSTRACT METHOD Print;
    --- -----------------------------------------------------------------
    --- Print the string of this expression
    --- -----------------------------------------------------------------
  
  ABSTRACT METHOD PrintValue ();
    --- -----------------------------------------------------------------
    --- Print the value of this expression. 
    --- -----------------------------------------------------------------
  
  ABSTRACT METHOD Check (IN global : BOOL,
		IN file   : File,
		IN func   : Function) : BOOL;
    --- -----------------------------------------------------------------
    --- Check the semantic correctness.
    --- -----------------------------------------------------------------

  METHOD GetType () : Type;
    --- -----------------------------------------------------------------
    --- Return the type of an Expression
    --- -----------------------------------------------------------------

  METHOD GetVariable () : Variable;
    --- -----------------------------------------------------------------
    --- Return the Variable of an Expression
    --- -----------------------------------------------------------------

  METHOD GetAddress () : Address;
    --- -----------------------------------------------------------------
    --- Return the address belonging the variable of this Expression
    --- -----------------------------------------------------------------

  ABSTRACT METHOD Delete ();
    --- -----------------------------------------------------------------
    --- Delete this expression's subexpressions.
    --- -----------------------------------------------------------------

PROTECTED
  
STATE
  type     : Type;
  variable : Variable;
  
END OBJECT;
  
PROCEDURE Parse () : Expression;
  -- -----------------------------------------------------------------
  -- Deliver an expression while parsing the input stream (global
  -- variable) The grammar ist this:
  --
  --   Expr -> Ident Expr2
  --
  --   Expr2 -> "." Ident Expr2
  --   Expr2 -> "[" ArraySubsription "]" Expr2
  --   Expr2 -> "^" Expr2
  --   Expr2 -> LAMBDA
  --
  --   ArraySubsription -> IdentOrIntConst Expr2 "," ArraySubsription
  --   ArraySubsription -> IdentOrIntConst Expr2 "][" ArraySubsription
  --   ArraySubsription -> IdentOrIntConst Expr2
  -- -----------------------------------------------------------------

TYPE QualifiedIdent = ABSTRACT OBJECT
  
PUBLIC
  
  ABSTRACT METHOD Print;
    --- -----------------------------------------------------------------
    --- Print the string of this expression
    --- -----------------------------------------------------------------
  
  ABSTRACT METHOD GetId () : FixedString;
    --- -----------------------------------------------------------------
    --- Get the string of this expression
    --- -----------------------------------------------------------------
  
  ABSTRACT METHOD Delete ();
    --- -----------------------------------------------------------------
    --- Delete this expression's subexpressions.
    --- -----------------------------------------------------------------

  ABSTRACT METHOD Check (IN check_file : File) : BOOL;
    --- -----------------------------------------------------------------
    --- Check this expression's correctness.
    --- -----------------------------------------------------------------

  ABSTRACT METHOD Break (IN impl : BOOL);
    --- -----------------------------------------------------------------
    --- Set breakpoint for this identifier
    --- -----------------------------------------------------------------
    
  ABSTRACT METHOD Unbreak ();
    --- -----------------------------------------------------------------
    --- Delete breakpoint for this identifier
    --- -----------------------------------------------------------------
    
  ABSTRACT METHOD Trace (IN impl : BOOL);
    --- -----------------------------------------------------------------
    --- Set tracepoint for this identifier
    --- -----------------------------------------------------------------
    
  ABSTRACT METHOD Untrace ();
    --- -----------------------------------------------------------------
    --- Delete tracepoint for this identifier
    --- -----------------------------------------------------------------
    
PROTECTED
  
STATE
  
END OBJECT;

PROCEDURE ParseQualifiedIdent () : QualifiedIdent;
  
EXCEPTION WRONG_SYNTAX;

VAR Stream  : FixedString;		 -- Here we have the input stream
VAR Actpos  : INT;			 -- The next character to be read

END SPECIFICATION;

