.OH "'CooL Language Reference Manual''Syntax'"
.EH "'Syntax''CooL Language Reference Manual'"
.bp
.NX 1 "Syntax"
.LP
.\"===========================================================================
.NX 2 "Syntax Notation"
.LP
An Extended Backus Naur Form is used for syntactical definitions.
.LP
A rule has the form
.Ss
Sym = Expr .
.Se
where the syntax expression 
.Si Expr
describes a class of phrases named by the nonterminal symbol
.Si Sym.
.LP
For syntax expressions the following notions are used:
.IP \(bu
.Si N 
(where 
.Si N
is a nonterminal symbol) represents an arbitrary phrase from the class
.Si N.
.IP \(bu
\fC"T"\fP
represents the terminal symbol
.Si T.
.IP \(bu
.Si "X Y"
represents
.Si X
followed by
.Si Y.
.IP \(bu
.Si "X|Y"
and
.Si "(X|Y)"
represent
.Si X
or
.Si Y.
.IP \(bu
.Si "[X]"
represents
.Si X
or empty.
.IP \(bu
.Si "{X}"
represents a possibly empty sequence of
.Si X
\&'s.
.\"===========================================================================
.NX 2 "Comments"
.LP
Comments may be written in two forms.
.Ss
-- Comment
.Se
The characters 
.Si --
and the characters following them up to the end of the line are equal
to white space.
.Ss
(* Comment *)
.Se
The characters
.Si "(*"
and 
.Si "*)"
and the characters enclosed by them are equal to white space.
Comments of this form may be nested.
.bp
.\"===========================================================================
.NX 2 "Tokens"
.LP
.Ss
Ident =
   (Letter | "_") {Letter | Digit | "_"} .

IntConst =
   Digit {Digit} .

FloatConst =
   Digit {Digit} "." Digit {Digit} 
   [("E"|"e") ["+" | "-"] Digit {Digit}] .

CharConst =
   "'" (Char) "'" .

StringConst =
   DoubleQuote {Char} DoubleQuote .

Char =
   Letter | Digit | Escape | OtherChar .

Letter = 
   "A" | "B" | ... | "Z" |
   "a" | "b" | ... | "z" .

Digit = 
   "0" | "1" | ... | "9" .

Escape =
   "\\\\" "n" | "\\\\" "t" | "\\\\" "v" | "\\\\" "b" | "\\\\" "r" | 
   "\\\\" "f" | "\\\\" "\\\\" | "\\\\" DoubleQuote | "\\\\" "'" | 
   "\\\\" "a" | "\\\\" "?" |
   "\\\\" OctalDigit [OctalDigit [OctalDigit]] .

OctalDigit = 
   "0" | "1" | ... | "7" .
.Se
.bp
.\"===========================================================================
.NX 2 "Declarations"
.LP
.Ss
Module =
   Specification |
   Implementation

Specification =
   "SPECIFICATION" Ident
   {Import ";"}
   {[ExportForeinPrefix] SpecDecl ";"}
   "END" "SPECIFICATION" ";" .

Implementation =
   "IMPLEMENTATION" Ident
   {Import ";"}
   {ImplDecl ";"}
   "END" "IMPLEMENTATION" ";" .

Import =
   "IMPORT" IdentList ["FROM" Ident] |
   "IMPORT" "FOREIGN" StringConst .

ForeignExportPrefix =
   "EXPORT" "FOREIGN" ["PASCAL"].

SpecDecl =
   TypeDecl | ObjTypeSpecDecl | ConstDecl | VarDecl | 
   ExceptionDecl | ProcSpecDecl | ForeignDecl | Root .

ImplDecl =
   TypeDecl | ObjTypeImplDecl | ConstDecl | VarDecl |  
   ExceptionDecl | ProcImplDecl | ForeignDecl .

TypeDecl = 
   "TYPE" Ident "=" Type .

ObjTypeSpecDecl =
   "TYPE" Ident ["[" FGenParamList "]"] "=" ObjTypeSpec .

ObjTypeImplDecl =
   "TYPE" Ident ["[" FGenParamList "]"] "=" ObjType |
   "TYPE" Ident "=" ObjTypeImpl .

FGenParamList =
   [FGenParam ["," FGenParamList]] .

FGenParam =
   Ident |
   Ident "->" QualifiedIdent .

ConstDecl =
   "CONST" IdentList ":" Type "=" Expr .

VarDecl =
   "VAR" IdentList ":" Type [":=" Expr] .

ExceptionDecl =
   "EXCEPTION" IdentList FParamSpec .
.Se
.Ss
ProcSpecDecl =
   "PROCEDURE" Ident Signature .

ProcImplDecl =
   ProcSpecDecl
   {VarDecl}
   "DO" Stmts "END" "DO" .

Signature =
   FParamSpec [":" Type] .

FParamSpec =
   ["(" FParamList ")"] 

FParamList =
   [FParam ["," FParamList]| ".." ] .

FParam =
   Mode IdentList ":" Type .

Mode =
   ["IN" | "OUT" | "INOUT"] .

ForeignDecl =
   "FOREIGN" "VAR" IdentList ":" Type | 
   "FOREIGN" ["PASCAL"] ProcSpecDecl |
   "FOREIGN" "TYPE" Ident "=" Type .

Root =
   "ROOT" ["PASCAL"] ProcSpecDecl .
.Se
.bp
.\"===========================================================================
.NX 2 "Types"
.LP
.Ss
Type =
   NamedType | "BOOL" | ["UNSIGNED"] ["SHORT" | "LONG" ] "INT" |
   "FLOAT" | "DOUBLE" | "CHAR" | "STRING" | EnumType | 
   RecordType | UnionType | ArrayType | RefType | "ADDRESS" | ProcType .

NamedType =
   QualifiedIdent [ "[" Type {"," Type} "]" ] .

EnumType =
   "ENUM" IdentList "END" "ENUM" .

RefType =
   "REF" Type .

ArrayType =
   "ARRAY" {"[" Expr [".." Expr] "]"} "OF" Type .

RecordType =
   "RECORD" Field {Field} "END" "RECORD" .

UnionType =
   "UNION" Field {Field} "END" "UNION" .

Field =
   IdentList ":" Type ";" .

ProcType =
   "PROCEDURE" ["("[Mode Type {"," Mode Type}] ")"] [":" Type] .

ObjType =
   NamedType ["ABSTRACT"] "OBJECT" FParamSpec
   "PUBLIC" {MethodSpec ";"} "PROTECTED" {MethodSpec ";"} 
   "STATE" {Field} 
   "BODY" {MethodImpl} 
   "END" "OBJECT" .

ObjTypeSpec =
   NamedType ["ABSTRACT"] "OBJECT" FParamSpec
   "PUBLIC" {MethodSpec ";"} "PROTECTED" {MethodSpec ";"} 
   "STATE" {Field} 
   "END" "OBJECT" .

ObjTypeImpl =
   "OBJECT" 
   "BODY" {MethodImpl ";"} 
   "END" "OBJECT" .

MethodSpec =
   ["ABSTRACT"] "METHOD" Ident Signature .

MethodImpl =
   (["REDEFINED"] "METHOD" Ident Signature | 
    "INITIALLY" Signature | "FINALLY") 
   {VarDecl}
   "DO" Stmts "END" "DO" .
.Se
.bp
.\"===========================================================================
.NX 2 "Statements"
.LP
.Ss
Stmts =
   {Stmt ";"} .

Stmt =
   AssignmentStmt | CallStmt |  ReturnStmt | IfStmt | SelectStmt | 
   TypeSelectStmt | LoopStmt | WhileStmt | ForStmt | ExitStmt |
   RaiseStmt | TryStmt | RetryStmt | ReraiseStmt | DeleteStmt | NullStmt .

AssignmentStmt =
   Expr ":=" Expr .

CallStmt =
   Expr ["(" [Expr {"," Expr}] ")"] .

ReturnStmt =
   "RETURN" [Expr] .

IfStmt =
   "IF" Expr "THEN" Stmts
   {"ELSIF" Expr "THEN" Stmts}
   ["ELSE" Stmts]
   "END" "IF" . 

SelectStmt =
   "SELECT" Expr "OF"
   {"CASE" Expr [".." Expr] {"," Expr [".." Expr]} ":" Stmts}
   ["OTHERWISE" Stmts]
   "END" "SELECT" .

TypeSelectStmt =
   "TYPESELECT" Ident ":=" Expr "OF"
   {"CASE" NamedType ":" Stmts} 
   ["OTHERWISE" Stmts]
   "END" "TYPESELECT" .

LoopStmt =
   "LOOP" Stmts "END" "LOOP" .

WhileStmt =
   "WHILE" Expr LoopStmt .

ForStmt =
   "FOR" Ident "IN" Domain LoopStmt .

Domain =
   Expr ".." Expr [("INCR" | "DECR") Expr] .

ExitStmt =
   "EXIT" .

RaiseStmt =
   "RAISE" QualifiedIdent ["(" [Expr {"," Expr}] ")"] .
.Se
.Ss
TryStmt =
   "TRY" Stmts "EXCEPT"
   {"CASE" HandlerLabel ":" Stmts}
   ["OTHERWISE" Stmts]
   "END" "TRY" .

HandlerLabel =
   QualifiedIdent {"," QualifiedIdent} FParamSpec .

RetryStmt =
   "RETRY" .

ReraiseStmt =
   "RERAISE" .

DeleteStmt = 
   "DELETE" Expr .

NullStmt =
   .
.Se
.bp
.\"===========================================================================
.NX 2 "Expressions"
.LP
.Ss
Expr =
   OrExpr .

OrExpr =
   AndExpr | 
   OrExpr "OR" AndExpr .

AndExpr =
   RelationalExpr | 
   AndExpr "AND" RelationalExpr .

RelationalExpr =
   AddExpr | 
   RelationalExpr ("=" | "<>" | ">" | ">=" | "<" | "<=" ) AddExpr .

AddExpr =
   MulExpr | 
   AddExpr ("+" | "-") MulExpr .

MulExpr =
   UnaryExpr | 
   MulExpr ("*" | "/" | "DIV" | "MOD") UnaryExpr .

UnaryExpr =
   PrimaryExpr | 
   ("-" | "+" | "NOT" | "ADR") PrimaryExpr  .

PrimaryExpr =
   QualifiedIdent |
   PrimaryExpr "." Ident |
   PrimaryExpr "[" Expr {"," Expr} "]" |
   PrimaryExpr "[" Expr ".." Expr "]" |
   PrimaryExpr "^" |
   PrimaryExpr "(" [Expr {"," Expr}] ")"  |
   "(" Expr ")" |
   "NEW" NamedType ["(" [Expr {"," Expr}] ")"] |
   "SIZEOF" "(" Type ")" |
   "SUPER" | "CURRENT" | "NIL" |
   "FALSE" | "TRUE" |
   IntConst | FloatConst | CharConst | StringConst .
.Se
.\"===========================================================================
.NX 2 "Miscellaneous"
.LP
.Ss
QualifiedIdent =
   [Ident "::"] Ident

IdentList =
   Ident {"," Ident}
.Se
.LP
