.OH "'CooL Language Reference Manual''Identifiers and Literals'"
.EH "'Identifiers and Literals''CooL Language Reference Manual'"
.bp
.NX 1 "Identifiers and Literals"
.LP
.\"===========================================================================
.NX 2 "Identifiers"
.LP
An identifier is a case-significant sequence of letters, digits, and
underscores, that begins with a letter.
.LP
Keywords are not permitted as identifier.
.\"===========================================================================
.NX 2 "Literals"
.LP
.SH
Integer Literals
.LP
An integer is a sequence of digits. An integer
.Si I
can be considered as a literal of an integer type
.Si T,
if
.Si I
is element of the integer subrange describing 
.Si T.
.SH
Floating Point Literals 
.LP
A sequence of digits followed by a dot followed by a sequence of digits
can be considered as a literal either of type 
.Si FLOAT 
or
.Si DOUBLE
in the case of a single-precision floating point number or of type 
.Si DOUBLE
in the case of a double-precision floating point number.
It may be followed by an exponent which is denoted by
the character
.Si E
followed by an optional sign, followed by a sequence of digits.
.SH 
Character Literals
.LP
A character inclosed in single quotes (\fC'\fP) denotes a literal of
type
.Si CHAR.
.LP
The following characters are represented by the given escape
sequences:
.in +.5i
.TS
tab(#);
l l
l lfC .
Character#Escape Sequence
_
Newline#\\n
Tab#\\t
Vertical Tab#\\v
Alarm#\\a
Backspace#\\b
Carriage Return#\\r
Formfeed#\\f
Double Quote#\\"
Single Quote#\\'
Backslash#\\\\\&
Question Mark#\\?
Null Character#\\0
.TE
.in -.5i
.LP
A backslash followed by a character not included in the table
represents the character itself.
.LP
A backslash followed by three octal digits represents the
character with the given code.
.SH
String Literals
.LP
A sequence of zero or more characters inclosed in
double quotes
(\fC"\fP)
denotes a literal of type
.Si STRING.
