.OH "'CooL Language Reference Manual''Expressions'"
.EH "'Expressions''CooL Language Reference Manual'"
.bp
.NX 1 "Expressions"
.LP
An expression describes a computation that yields a value.
.LP
An expression is an application of an operator to operands, an object
constructor or denoter, a function call, a designator, a literal, the
nil expression, the sizeof expression or an expression enclosed in
parentheses.
.\"=========================================================================== 
.NX 2 "Constant Expressions"
.LP
Constant expressions are expressions which may be evaluated
statically.
.LP
A constant expression is an application of an operator to constant
operands, a constant designator, a literal, the nil expression, or a
constant expression enclosed in parentheses.
Possible operators are arithmetic, boolean and string operators, and
the relational operators for the types
.Si BOOL,
integer types, floating point types,
.Si CHAR,
.Si STRING
and enumeration types.
.\"=========================================================================== 
.NX 2 "Operators"
.LP
An expression may have the form 
.Ss
Op X
.Se
where 
.Si Op
is a monadic operator and
.Si X
is an expression,
or
.Ss
X1 Op X2
.Se
where Op is a dyadic operator and 
.Si X1
and 
.Si X2
are expressions.
.SH
Arithmetic Operators
.LP
The monadic operators 
.Si +
and
.Si -
denote positive and negative sign.  Their signature is
.Ss
+  (x: Int) : Int
-  (x: Int) : Int

+  (x: Float) : Float
-  (x: Float) : Float
.Se
The dyadic operators
.Si +
,
.Si -
,
.Si *
,
.Si MOD
,
.Si DIV
and 
.Si /
denote addition, subtraction, multiplication, modulo and division.
Their signature is
.Ss
+  (x: Int, y: Int) : Int
-  (x: Int, y: Int) : Int
*  (x: Int, y: Int) : Int
/  (x: Int, y: Int) : FLOAT
MOD  (x: Int, y: Int) : Int
DIV  (x: Int, y: Int) : Int

+  (x: Float, y: Float) : Float
-  (x: Float, y: Float) : Float
*  (x: Float, y: Float) : Float
/  (x: Float, y: Float) : Float
.Se
.LP
Here
.Si Int
is used for the integer types  and
.Si Float
is used for the floating point types.  Two operands of different
numeric types are converted into values of a common type.
.SH
Relational Operators
.LP
The dyadic operators 
.Si =
and
.Si <>
denote the relation 
.Ii "equal"
and 
.Ii "unequal."
Their signature is
.Ss
=   (x: T, y: T) : BOOL
<>  (x: T, y: T) : BOOL
.Se
where 
.Si T 
is type.
.LP
The dyadic operators
.Si <,
.Si <=,
.Si >,
.Si >=
denote the relations 
.Ii "less,"
.Ii "less or equal,"
.Ii "greater,"
and 
.Ii "greater or equal."
Their signature is
.Ss
<   (x: T, y: T) : BOOL
<=  (x: T, y: T) : BOOL
>   (x: T, y: T) : BOOL
>=  (x: T, y: T) : BOOL
.Se
where 
.Si T
is an integer or floating point type,
.Si CHAR,
.Si STRING,
or an enumeration type.
.SH
Boolean Operators
.LP
The monadic operator
.Si NOT
and the dyadic operators
.Si AND
and
.Si OR
denote 
.Ii "negation,"
.Ii "conjunction,"
and 
.Ii "disjunction."
Their signatures are
.Ss
NOT  (x: BOOL) : BOOL
AND  (x: BOOL, y: BOOL) : BOOL
OR   (x: BOOL, y: BOOL) : BOOL
.Se
.Si "NOT TRUE"
yields
.Si "FALSE"
,
.Si "NOT FALSE"
yields
.Si TRUE.
.LP
.Si "x AND y"
yields 
the value of
.Si y
if
.Si x
yields
.Si TRUE.
It yields
.Si FALSE
if 
.Si x
yields 
.Si FALSE
; in this case
.Si y
is not evaluated.
.LP
.Si "x OR y"
yields 
the value of
.Si y
if
.Si x
yields
.Si FALSE.
It yields
.Si TRUE
if 
.Si x
yields 
.Si TRUE
; in this case
.Si y
is not evaluated.
.SH
Address Operators
.LP
The monadic operator
.Si ADR
applied to a variable or parameter yields the address of that
variable, which is of type
.Si ADDRESS.
The operator cannot be applied to (a component of) an
instance variable of an object.
.LP
The dyadic operators
.Si +
and
.Si -
are also defined for address arithmetic.
.Ss
+ (x: Int, y: ADDRESS) : ADDRESS
+ (x: ADDRESS, y: Int) : ADDRESS

- (x: ADDRESS, y: Int) : ADDRESS
- (x: ADDRESS, y: ADDRESS) : INT
.Se
.LP
Here
.Si Int
is used for the integer types.
.SH
String Operators
.LP
The dyadic operator
.Si +
also denotes string concatenation. The signature is
.Ss
+ (x: STRING, y: STRING) : STRING
+ (x: STRING, y: CHAR) : STRING
+ (x: CHAR, y: STRING) : STRING
+ (x: CHAR, y: CHAR) : STRING
.Se
.Si "x + y"
yields the concatenation of the strings 
.Si x
and
.Si y.
A character argument is treated as a string containing only this
character.
.SH
Operator Precedence
.LP
The following table lists the operators in order of
decreasing precedence.
.in +.5i
.TS
tab(#);
lfC l .
+ - NOT ADR#(monadic operators)
/ * DIV MOD#(multiplicative operators)
+ -#(additive operators)
= <> < > <= >=#(relations)
AND#(conjunction)
OR#(disjunction)
.TE
.in -.5i
.\"=========================================================================== 
.NX 2 "Object Constructor and Denoter"
.LP
An object constructor
.Ss
NEW T (A1, ... , An)
.Se
may be used as an expression of type
.Si T.
This expression is described in section 
.Ii "3.13. Object Types."
.LP
Inside a method of an object type
.Si T
the expression
.Ss
CURRENT
.Se
is an expression of type
.Si T
and yields a handle to the current object.
.\"=========================================================================== 
.NX 2 "Method Expression"
.LP
An method expression
.Ss
X . M
.Se
is an expression of a method type. This expression is described in section 
.Ii "3.13. Object Types."
.\"=========================================================================== 
.NX 2 "Function Calls"
.LP
A call of a function or method returning a value of type
.Si T
may be used as an expression of type
.Si T
(see section 
.Ii "2.5. Procedure Declaration"
and
.Ii "3.13. Object Types)."
The value of the expression is the value returned by the function or
method.
.\"=========================================================================== 
.NX 2 "Designators"
.LP
A designator may be used as an expression.  The type of the expression
is the type of the designator.  The value of the expression is the value
stored in the designator.
.LP
A designator is an identifier (introduced as constant, as global,
local or instance variable, as formal parameter, or as implicitly
declared in a For or Typeselect statement).  If
.Si D
is a designator, then
.Si "D [I],"
.Si "D [E1 .. E2],"
.Si D.F
and
.Si D^
are also designators. They are described in chapter 
.Ii "3. Types."
.\"=========================================================================== 
.NX 2 "Literals"
.LP
Literals (integer constants, floating point constants, character
constants and string constants) as described in section 
.Ii "1.2. Literals"
may be used as an expression.
.\"=========================================================================== 
.NX 2 "Nil"
.LP
The symbol
.Si NIL
may be used as a constant of a reference type or of the type
.Si ADDRESS,
or as value of an object type.  It does not refer to any variable, or
to any object.
.\"=========================================================================== 
.NX 2 "Sizeof"
.LP
The notation
.Ss
SIZEOF (T)
.Se
is a constant of type
.Si "UNSIGNED INT,"
where
.Si T
is a type.
Its value is the number of bytes required to store a value of type
.Si T.
.\"================================================================ The End ==
