.so manmac.ms
.OH "''''"
.EH "''''"
.fp 1 H
.fp 2 HO
.fp 3 HB
.nr PS 12
.nr VS 14
.LP
\&
.sp 20
.ps 18
.vs 20p
\f(HBSINIX / WINDOWS NT\fP
.LP
.sp 2
.ps 30
.vs 34p
\f(HBCooL V2.1\fP
.LP
.sp
.ps 18
.vs 20p
\f(HBCoLibri\fP
.sp 11
\f(HBReference Manual\fP
.LP
.bp 
\&
.bp
\&
.sp 10
.ps 30
.vs 34p
\f(HBCooL (SINIX / WINDOWS NT)\fP
.LP
.sp 2
.ps 18
.vs 20p
\f(HBCoLibri\fP
.sp 3
\f(HBReference Manual\fP
.LP
.sp 23
.ps 12
.vs 14p
Edition January 1994 (CooL V2.1)
.LP
.bp
\&
.sp 34
.ps 9
.vs 11p
.TS
tab($);
l.
CooL
Copyright \(co Siemens Nixdorf Informationssysteme AG 1994
All rights reserved
.sp 0.5
The reproduction, transmission or use of this document or its contents
is not permitted without express written authority.
.sp 0.5
Offenders will be liable for damages. All rights, including rights created
by patent grant or registration of a utility model of design, are reserved.
.sp 0.5
Delivery subject to availability;
right of technical modifications reserved.
.sp 0.5
Published by
Siemens Nixdorf Informationssysteme AG
.TE
.LP
.bp
.OH "'CoLibri Reference Manual''Preface'"
.EH "'Preface''CoLibri Reference Manual'"
.OF "'''\\\\n(PN'"
.EF "'\\\\n(PN'''"
.NX 0 "Preface"
.sp
CoLibri is the library of the CooL Programming Environment.
This library provides interfaces to other libraries and classes, 
additional operations for CooL data types, abstract data types and a set
of fundamental non-generic and generic object types.
.sp
Most parts of CoLibri were implemented with CooL whereby different 
standards were taken into account (e.g. X/Open Portability Guide, AT&T 
Class Library).
.sp 1.5
\f(HBAudience\fP
.sp
This manual contains all the information you require in order to work 
with CoLibri.
You should, however, be familiar with CooL and the concepts of 
object-oriented programming.
.sp 1.5
\f(HBContents\fP
.sp
The CoLibri Reference Manual is divided up into five chapters with the
following contents:
.IP Preface
In addition to a brief description of CoLibri and a summary of contents,
you will also find an explanation of the typographical conventions used 
in the manual.
.IP "1. How to Use CoLibri"
This chapter provides an explanation of the usage of CoLibri.
.IP "2. CooL Support"
This chapter describes additional procedures which are provided by CooL
(e.g. for data types, conversions, access on the environment).
.IP "3. Abstract Data Types"
This chapter describes the abstract data types provided by CoLibri.
.IP "4. Object Types"
This chapter describes the object types provided by CoLibri.
.LP
.sp
\f(HBTypographical Conventions\fP
.sp
The following typographical conventions are used:
.sp 0.5
.IP \f(HBbold\fP 11
\f(HBBoldfaced\fP strings in syntax descriptions represent literals and 
must be typed in the manner in which they appear.
.IP \f(HOitalic\fP 11
\f(HOItalicized\fP strings represent substitutable arguments and the 
names of entries found elsewhere.
.IP \fCcourier\fP 11
\fCCourier\fP is used for program examples, user input, system output
and (error) messages.
.IP \f(HOname()\fP 11
The notation \f(HOname()\fP indicates C functions and CooL procedures 
and methods.
.IP \f(HB<file>\fP 11
The notation \f(HB<file>\fP indicates C header files (\f(HB<file.h>\fP) 
and CooL library files (\f(HB<file.cs>\fP).
.IP "{ }" 11
Braces { } around names represent constants.
.LP
.OH "''''"
.EH "''''"
.bp
.OH "'CoLibri Reference Manual''How to Use CoLibri'"
.EH "'How to Use CoLibri''CoLibri Reference Manual'"
.NX 1 "How to Use CoLibri"
.sp
The procedures \f(HOPrelude\fP and \f(HOPostlude\fP are provided
for initializating and finalizating CoLibri, 
These procedures should be called at the beginning and at the end of 
procedure \f(HOmain()\fP.
.sp 0.5
.KS
.IP EXAMPLES
.CS L
PROCEDURE main
DO
  Colibri::Prelude ();
\&...
  Colibri::Postlude ();
END DO;
.CE
.KE
.LP
The procedures \f(HOPrelude\fP and \f(HOPostlude\fP are
declared in the module \f(HOColibri\fP.
Therefore, the module implementation containing procedure
\f(HOmain()\fP must import these procedures from the module \f(HOColibri\fP.
.sp 0.5
.KS
.IP EXAMPLES
.CS L
IMPORT ..., Colibri, ...;
.CE
.KE
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'CoLibri Reference Manual''CooL Support'"
.EH "'CooL Support''CoLibri Reference Manual'"
.NX 1 "CooL Support"
.sp
This chapter describes additional procedures which are provided by CooL
(e.g. for data types, conversions, access on the environment).
.LP
.OH "'CoLibri Reference Manual''Char'"
.EH "'Char''CoLibri Reference Manual'"
.bp
.NX 2 "Char"
.sp
.NX 3 "Type Description"
.sp
\f(HOChar\fP provides a set of procedures for the simple data type 
\f(HOCHAR\fP of CooL.
.IP NOTE
Remember the machine depended representation of characters.
.LP
.sp 0.5
.NX 3 "List of Procedures"
.sp
The following procedures are available in <Char.cs>:
.TS
tab(#);
l.
Procedure name
_
IsControl
IsDigit
IsLetter
IsLowerCase
IsPrintable
IsUpperCase
ToLowerCase
ToUpperCase
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For the procedures described below no exceptions are raised.
.sp
.NX 3 "How to use CooL Support"
.sp
Each CooL module which uses a procedure of \f(HOChar\fP must import the
module \f(HOChar\fP:
.CS L
IMPORT ..., Char, ...;
.CE
.sp 0.5
.NX 3 "Procedure Description"
.sp
The following sections contain the syntactical and semantical description of
all procedures provided by \f(HOChar\fP.
They are listed in alphabetical order.
.LP
.OH "'CoLibri Reference Manual''Char::IsControl'"
.EH "'Char::IsControl''CoLibri Reference Manual'"
.bp
.NX 4 "IsControl"
.sp
.IP MODULE
\f(HBChar\fP
.IP SYNOPSIS
\f(HBPROCEDURE IsControl ( IN value : CHAR ) : BOOL;\fP
.IP DESCRIPTION
The procedure \f(HOIsControl\fP tests whether \f(HOvalue\fP contains a
control character or not.
.IP "RETURN VALUE"
This procedure returns TRUE, if \f(HOvalue\fP contains a control character.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR character : CHAR;
\&...
character := '\\\\n'; 
IF Char::IsControl (character)
THEN
   -- \f(HOexecution continues here\fP
ELSE  
   ...
END IF;
.CE
.KE
Then the result has the value TRUE, because character contains
a new-line control character.
.IP "SEE ALSO"
\f(HOIsDigit\fP,
\f(HOIsLetter\fP
.LP
.OH "'CoLibri Reference Manual''Char::IsDigit'"
.EH "'Char::IsDigit''CoLibri Reference Manual'"
.bp
.NX 4 "IsDigit"
.sp
.IP MODULE
\f(HBChar\fP
.IP SYNOPSIS
\f(HBPROCEDURE IsDigit ( IN value : CHAR ) : BOOL;\fP
.IP DESCRIPTION
The procedure \f(HOIsDigit\fP tests whether \f(HOvalue\fP contains a
digit, i.e. '0' - '9', or not.
.IP "RETURN VALUE"
The procedure returns TRUE, if \f(HO value\fP contains a digit.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR character : CHAR;
\&...
character := '4';
IF Char::IsDigit (character)
THEN
   -- \f(HOexecution continues here\fP
ELSE  
   ...
END IF;
.CE
.KE
Then the result has the value TRUE, because character contains a digit.
.IP "SEE ALSO"
\f(HOIsControl\fP,
\f(HOIsLetter\fP
.LP
.OH "'CoLibri Reference Manual''Char::IsLetter'"
.EH "'Char::IsLetter''CoLibri Reference Manual'"
.bp
.NX 4 "IsLetter"
.sp
.IP MODULE
\f(HBChar\fP
.IP SYNOPSIS
\f(HBPROCEDURE IsLetter ( IN value : CHAR ) : BOOL;\fP
.IP DESCRIPTION
The procedure \f(HOIsLetter\fP tests whether \f(HOvalue\fP contains a
letter, i.e. 'a' - 'z', 'A' - 'Z', or not.
.IP "RETURN VALUE"
The procedure returns TRUE, if \f(HOvalue\fP contains a letter. 
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR character : CHAR;
\&...
character := 'A';
IF Char::IsLetter (character)
THEN
   -- \f(HOexecution continues here\fP
ELSE  
   ...
END IF;
.CE
.KE
Then the result has the value TRUE, because character contains a letter.
.IP "SEE ALSO"
\f(HOIsControl\fP,
\f(HOIsDigit\fP
.LP
.OH "'CoLibri Reference Manual''Char::IsLowerCase'"
.EH "'Char::IsLowerCase''CoLibri Reference Manual'"
.bp
.NX 4 "IsLowerCase"
.sp
.IP MODULE
\f(HBChar\fP
.IP SYNOPSIS
\f(HBPROCEDURE IsLowerCase ( IN value : CHAR ) : BOOL;\fP
.IP DESCRIPTION
The procedure \f(HOIsLowerCase\fP tests whether \f(HOvalue\fP contains a
lower case letter, i.e. 'a' - 'z', or not.
.IP "RETURN VALUE"
The procedure returns TRUE, if \f(HOvalue\fP contains a lower case
letter. Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR character : CHAR;
\&...
character := 'b';
IF Char::IsLowerCase (character)
THEN
   -- \f(HOexecution continues here\fP
ELSE  
   ...
END IF;
.CE
.KE
Then the result has the value TRUE, because character contains a small 
letter.
.IP "SEE ALSO"
\f(HOIsUpperCase\fP,
\f(HOToUpperCase\fP
.LP
.OH "'CoLibri Reference Manual''Char::IsPrintable'"
.EH "'Char::IsPrintable''CoLibri Reference Manual'"
.bp
.NX 4 "IsPrintable"
.sp
.IP MODULE
\f(HBChar\fP
.IP SYNOPSIS
\f(HBPROCEDURE IsPrintable ( IN value : CHAR ) : BOOL;\fP
.IP DESCRIPTION
The procedure \f(HOIsPrintable\fP tests whether \f(HOvalue\fP contains 
a printable character or not.
.IP "RETURN VALUE"
The procedure returns TRUE, if \f(HOvalue\fP contains a printable 
character.  Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR character : CHAR;
\&...
character := 'C';
IF Char::IsPrintable (character)
THEN
   -- \f(HOexecution continues here\fP
ELSE  
   ...
END IF;
.CE
.KE
Then the result has the value TRUE, because character contains
a printable letter.
.LP
.OH "'CoLibri Reference Manual''Char::IsUpperCase'"
.EH "'Char::IsUpperCase''CoLibri Reference Manual'"
.bp
.NX 4 "IsUpperCase"
.sp
.IP MODULE
\f(HBChar\fP
.IP SYNOPSIS
\f(HBPROCEDURE IsUpperCase ( IN value : CHAR ) : BOOL;\fP
.IP DESCRIPTION
The procedure \f(HOIsUpperCase\fP tests whether \f(HOvalue\fP contains a
upper case letter, i.e. 'A' - 'Z', or not.
.IP "RETURN VALUE"
The procedure returns TRUE, if \f(HOvalue\fP contains a upper case
letter. Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR character : CHAR;
\&...
character := 'D';
IF Char::IsUpperCase (character)
THEN
   -- \f(HOexecution continues here\fP
ELSE  
   ...
END IF;
.CE
.KE
Then the result has the value TRUE, because character contains
a capital letter.
.IP "SEE ALSO"
\f(HOIsLowerCase\fP,
\f(HOToLowerCase\fP
.LP
.OH "'CoLibri Reference Manual''Char::ToLowerCase'"
.EH "'Char::ToLowerCase''CoLibri Reference Manual'"
.bp
.NX 4 "ToLowerCase"
.sp
.IP MODULE
\f(HBChar\fP
.IP SYNOPSIS
\f(HBPROCEDURE ToLowerCase ( IN value : CHAR ) : CHAR;\fP
.IP DESCRIPTION
The procedure \f(HOToLowerCase\fP converts a capital letter of
\f(HOvalue\fP to a small letter.
.IP "RETURN VALUE"
The procedure returns the corresponding small letter if \f(HOvalue\fP
contains a capital letter.
Otherwise it returns a copy of \f(HOvalue\fP.
.KS
.IP EXAMPLES
.CS L
VAR character    : CHAR;
VAR small_letter : CHAR;
\&...
character    := 'E';
small_letter := Char::ToLowerCase (character);
.CE
.KE
Then small_letter contains 'e'.
.IP "SEE ALSO"
\f(HOIsUpperCase\fP,
\f(HOToUpperCase\fP
.LP
.OH "'CoLibri Reference Manual''Char::ToUpperCase'"
.EH "'Char::ToUpperCase''CoLibri Reference Manual'"
.bp
.NX 4 "ToUpperCase"
.sp
.IP MODULE
\f(HBChar\fP
.IP SYNOPSIS
\f(HBPROCEDURE ToUpperCase ( IN value : CHAR ) : CHAR;\fP
.IP DESCRIPTION
The procedure \f(HOToUpperCase\fP converts a small letter of
\f(HOvalue\fP to a capital letter.
.IP "RETURN VALUE"
The procedure returns the corresponding capital letter if \f(HOvalue\fP
contains a smalll letter.
Otherwise it returns a copy of \f(HOvalue\fP.
.KS
.IP EXAMPLES
.CS L
VAR character      : CHAR;
VAR capital_letter : CHAR;
\&...
character      := 'f';
capital_letter := Char::ToUpperCase (character);
.CE
.KE
Then capital_letter contains 'F'.
.IP "SEE ALSO"
\f(HOIsLowerCase\fP,
\f(HOToLowerCase\fP
.LP
.OH "'CoLibri Reference Manual''Char'"
.EH "'Char''CoLibri Reference Manual'"
.bp
.NX 4 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOChar\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
IsControl$IN$value$CHAR$
$result$$BOOL$
_
IsDigit$IN$value$CHAR$
$result$$BOOL$
_
IsLetter$IN$value$CHAR$
$result$$BOOL$
_
IsLowerCase$IN$value$CHAR$
$result$$BOOL$
_
IsPrintable$IN$value$CHAR$
$result$$BOOL$
_
IsUpperCase$IN$value$CHAR$
$result$$BOOL$
_
ToLowerCase$IN$value$CHAR$
$result$$CHAR$
_
ToUpperCase$IN$value$CHAR$
$result$$CHAR$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''Double'"
.EH "'Double''CoLibri Reference Manual'"
.bp
.NX 2 "Double"
.sp
.NX 3 "Type Description"
.sp
\f(HODouble\fP provides a set of procedures for the simple data type 
\f(HODOUBLE\fP of CooL.
.sp
.NX 3 "List of Procedures"
.sp
The following procedures are available in <Double.cs>:
.TS
tab(#);
l.
Procedure name
_
Abs
GetExponent
GetFractionalPart
GetIntegralPart
IsInteger
Round
Trunc
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For the procedures described below no exceptions are raised.
.sp
.NX 3 "How to use CooL Support"
.sp
Each CooL module which uses a procedure of \f(HODouble\fP must import the
module \f(HODouble\fP:
.CS L
IMPORT ..., Double, ...;
.CE
.sp 0.5
.NX 3 "Procedure Description"
.sp
The following sections contain the syntactical and semantical description of
all procedures provided by \f(HODouble\fP.
They are listed in alphabetical order.
.sp
The constants {min} and {max} represent the machine dependend minimum
and maximum values for DOUBLE values.
They are also defined in the module \f(HODouble\fP.
.LP
.OH "'CoLibri Reference Manual''Double::Abs'"
.EH "'Double::Abs''CoLibri Reference Manual'"
.bp
.NX 4 "Abs"
.sp
.IP MODULE
\f(HBDouble\fP
.IP SYNOPSIS
\f(HBPROCEDURE Abs ( IN value : DOUBLE ) : DOUBLE;\fP
.IP DESCRIPTION
The procedure \f(HOAbs\fP computes the absolute value of \f(HOvalue\fP.
.IP "RETURN VALUE"
This procedure returns \f(HOvalue\fP, if \f(HOvalue\fP is greater than 
or equal to zero.
Otherwise it returns \f(HO-value\fP.
.KS
.IP EXAMPLES
.CS L
VAR double : DOUBLE;
VAR result : DOUBLE;
\&...
double := -0.5;
result := Double::Abs (double);
.CE
.KE
Then result has the value 0.5.
.LP
.OH "'CoLibri Reference Manual''Double::GetExponent'"
.EH "'Double::GetExponent''CoLibri Reference Manual'"
.bp
.NX 4 "GetExponent"
.sp
.IP MODULE
\f(HBDouble\fP
.IP SYNOPSIS
\f(HBPROCEDURE GetExponent ( IN value : DOUBLE ) : INT;\fP
.IP DESCRIPTION
The procedure \f(HOGetExponent\fP delivers the exponent of 
\f(HOvalue\fP.
.IP "RETURN VALUE"
This procedure returns the exponent of \f(HOvalue\fP.
.KS
.IP EXAMPLES
.CS L
VAR double : DOUBLE;
VAR result : INT;
\&...
double := -5.1;
result := Double::GetExponent (double);
.CE
.KE
Then result has the value 0.
.IP "SEE ALSO"
\f(HOGetFractionalPart\fP,
\f(HOGetIntegralPart\fP
.LP
.OH "'CoLibri Reference Manual''Double::GetFractionalPart'"
.EH "'Double::GetFractionalPart''CoLibri Reference Manual'"
.bp
.NX 4 "GetFractionalPart"
.sp
.IP MODULE
\f(HBDouble\fP
.IP SYNOPSIS
\f(HBPROCEDURE GetFractionalPart ( IN value : DOUBLE ) : DOUBLE;\fP
.IP DESCRIPTION
The procedure \f(HOGetFractionalPart\fP extracts the fractional part of
\f(HOvalue\fP.
.IP "RETURN VALUE"
This procedure returns the fractional part of \f(HOvalue\fP.
.KS
.IP EXAMPLES
.CS L
VAR double : DOUBLE;
VAR result : DOUBLE;
\&...
double := -5.1;
result := Double::GetFractionalPart (double);
.CE
.KE
Then result has the value -0.1.
.IP "SEE ALSO"
\f(HOGetExponen\fP,
\f(HOGetIntegralPart\fP
.LP
.OH "'CoLibri Reference Manual''Double::GetIntegralPart'"
.EH "'Double::GetIntegralPart''CoLibri Reference Manual'"
.bp
.NX 4 "GetIntegralPart"
.sp
.IP MODULE
\f(HBDouble\fP
.IP SYNOPSIS
\f(HBPROCEDURE GetIntegralPart ( IN value : DOUBLE ) : DOUBLE;\fP
.IP DESCRIPTION
The procedure \f(HOGetIntegralPart\fP extracts the integral part of
\f(HOvalue\fP.
.IP "RETURN VALUE"
This procedure returns the integral part of \f(HOvalue\fP.
.KS
.IP EXAMPLES
.CS L
VAR double : DOUBLE;
VAR result : DOUBLE;
\&...
double := -5.1;
result := Double::GetIntegralPart (double);
.CE
.KE
Then result has the value -5.0.
.IP "SEE ALSO"
\f(HOGetExponent\fP,
\f(HOGetFractionalPart\fP
.LP
.OH "'CoLibri Reference Manual''Double::IsInteger'"
.EH "'Double::IsInteger''CoLibri Reference Manual'"
.bp
.NX 4 "IsInteger"
.sp
.IP MODULE
\f(HBDouble\fP
.IP SYNOPSIS
\f(HBPROCEDURE IsInteger ( IN value : DOUBLE ) : BOOL;\fP
.IP DESCRIPTION
The procedure \f(HOIsInteger\fP tests whether \f(HOvalue\fP is a whole
number.
.IP "RETURN VALUE"
This procedure returns TRUE, if \f(HOvalue\fP is a whole number.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR double : DOUBLE;
VAR result : BOOL;
\&...
double := 5.0;
result := Double::IsInteger (double);
.CE
.KE
Then result has the valueTRUE.
.LP
.OH "'CoLibri Reference Manual''Double::Round'"
.EH "'Double::Round''CoLibri Reference Manual'"
.bp
.NX 4 "Round"
.sp
.IP MODULE
\f(HBDouble\fP
.IP SYNOPSIS
\f(HBPROCEDURE Round ( IN value : DOUBLE ) : DOUBLE;
.IP DESCRIPTION
The procedure \f(HORound\fP rounds \f(HOvalue\fP (in a commercial
manner) into a whole number.
.IP "RETURN VALUE"
This procedure returns the result of the rounding.
.KS
.IP EXAMPLES
.CS L
VAR double : DOUBLE;
VAR result : DOUBLE;
\&...
double := -5.4351;
result := Double::Round (double);
.CE
.KE
Then result has the value -5.0.
.KS
.CS L
double := 12345.06;
result := Double::Round (double);
.CE
.KE
Then result has the value 12345.0.
.KS
.CS L
double := 12345.67;
result := Double::Round (double);
.CE
.KE
Then result has the value 12346.0.
.IP "SEE ALSO"
\f(HOTrunc\fP
.LP
.OH "'CoLibri Reference Manual''Double::Trunc'"
.EH "'Double::Trunc''CoLibri Reference Manual'"
.bp
.NX 4 "Trunc"
.sp
.IP MODULE
\f(HBDouble\fP
.IP SYNOPSIS
\f(HBPROCEDURE Trunc ( IN value : DOUBLE ) : DOUBLE;\fP
.TE
.IP DESCRIPTION
The procedure \f(HOTrunc\fP truncates the fractional digits of
\f(HOvalue\fP .
.IP "RETURN VALUE"
This procedure returns \f(HOvalue\fP.
All fractional digits are replaced by zero.
.KS
.IP EXAMPLES
.CS L
VAR double : DOUBLE;
VAR result : DOUBLE;
\&...
double := -54321.4321;
result := Double::Trunc (double);
.CE
.KE
Then result has the value -54321.0.
.IP "SEE ALSO"
\f(HORound\fP
.LP
.OH "'CoLibri Reference Manual''Double'"
.EH "'Double''CoLibri Reference Manual'"
.bp
.NX 4 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HODouble\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
Abs$IN$value$DOUBLE$
$result$$DOUBLE$
_
GetExponent$IN$value$DOUBLE$
$result$$INT$
_
GetFractionalPart$IN$value$DOUBLE$
$result$$DOUBLE$
_
GetIntegralPart$IN$value$DOUBLE$
$result$$DOUBLE$
_
IsInteger$IN$value$DOUBLE$
$result$$BOOL$
_
Round$IN$value$DOUBLE$
$result$$DOUBLE$
_
Trunc$IN$value$DOUBLE$
$result$$DOUBLE$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''Int'"
.EH "'Int''CoLibri Reference Manual'"
.bp
.NX 2 "Int"
.sp
.NX 3 "Type Description"
.sp
\f(HOInt\fP provides a set of procedures for the simple data type 
\f(HOINT\fP of CooL.
.sp
.NX 3 "List of Procedures"
.sp
The following procedures are available in <Int.cs>:
.TS
tab(#);
l.
Procedure name
_
Abs
GetExponent
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For the procedures described below no exceptions are raised.
.sp
.NX 3 "How to use CooL Support"
.sp
Each CooL module which uses a procedure of \f(HOInt\fP must import the
module \f(HOInt\fP:
.CS L
IMPORT ..., Int, ...;
.CE
.sp 0.5
.NX 3 "Procedure Description"
.sp
The following sections contain the syntactical and semantical 
description of all procedures provided by \f(HOInt\fP.
They are listed in alphabetical order.
.sp                                                                     
The constants {min} and {max} represent the machine dependend minimum
and maximum values for INT values.
They are also defined in the module \f(HOInt\fP.
.LP
.OH "'CoLibri Reference Manual''Int::Abs'"
.EH "'Int::Abs''CoLibri Reference Manual'"
.bp
.NX 4 "Abs"
.sp
.IP MODULE
\f(HBInt\fP
.IP SYNOPSIS
\f(HBPROCEDURE Abs ( IN value : INT ) : INT;\fP
.IP DESCRIPTION
The procedure \f(HOAbs\fP computes the absolute value of \f(HOvalue\fP.
.IP "RETURN VALUE"
This procedure returns \f(HOvalue\fP, if \f(HOvalue\fP is greater than 
or equal to zero.
Otherwise it returns \f(HO-value\fP.
.KS
.IP EXAMPLES
.CS L
VAR integer : INT;
VAR result  : INT;
\&...
integer := -5;
result  := Int::Abs (integer);
.CE
.KE
Then result has the value 5.
.LP
.OH "'CoLibri Reference Manual''Int::GetExponent'"
.EH "'Int::GetExponent''CoLibri Reference Manual'"
.bp
.NX 4 "GetExponent"
.sp
.IP MODULE
\f(HBInt\fP
.IP SYNOPSIS
\f(HBPROCEDURE GetExponent ( IN value : INT ) : INT;\fP
.IP DESCRIPTION
The procedure \f(HOGetExponent\fP delivers the exponent of 
\f(HOvalue\fP.
.IP "RETURN VALUE"
This procedure returns the exponent of \f(HOvalue\fP.
.KS
.IP EXAMPLES
.CS L
VAR integer : INT;
VAR result  : INT;
\&...
integer := -5;
result  := Int::GetExponent (integer);
.CE
.KE
Then result has the value 0.
.LP
.OH "'CoLibri Reference Manual''Int'"
.EH "'Int''CoLibri Reference Manual'"
.bp
.NX 4 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOInt\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
Abs$IN$value$INT$
$result$$INT$
_
GetExponent$IN$value$INT$
$result$$INT$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''String'"
.EH "'String''CoLibri Reference Manual'"
.bp
.NX 2 "String"
.sp
.NX 3 "Type Description"
.sp
\f(HOString\fP provides a set of procedures for the simple data type 
\f(HOSTRING\fP of CooL.
They do not do any interpretation of the contents of strings.
.sp
.NX 3 "List of Procedures"
.sp
The following procedures are available in <String.cs>:
.TS
tab(#);
l.
Procedure name
_
AppendPattern
CutLeadingBlanks
CutTrailingBlanks
FirstDifference
GetLength 
GetPosOfChar
GetPosOfSubString
InsertChar
InsertString
RemoveAllPattern
RemoveChar
RemoveSubString
ToLower
ToUpper
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each procedure described below the exceptions which will be raised in case
of an error are listed.
.sp
The following exceptions can be raised using module \f(HOString\fP :
.TS
tab($);
l.
exception name
_
PositionIsOutOfRange
SubStringIsOutOfRange
.TE
.sp
.NX 3 "How to use CooL Support"
.sp
Each CooL module which uses a procedure of \f(HOString\fP must import the
module \f(HOString\fP:
.CS L
IMPORT ..., String, ...;
.CE
.sp 0.5
.NX 3 "Procedure Description"
.sp
The following sections contain the syntactical and semantical description of
all procedures provided by \f(HOString\fP.
They are listed in alphabetical order.
.LP
.OH "'CoLibri Reference Manual''String::AppendPattern'"
.EH "'String::AppendPattern''CoLibri Reference Manual'"
.bp
.NX 4 "AppendPattern"
.sp
.IP MODULE
\f(HBString\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBPROCEDURE AppendPattern ($ IN string $ : STRING,
$ IN new_length $ : INT,
$ IN pattern $ : CHAR )
$: STRING;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOAppendPattern\fP appends \f(HOpattern\fP to
\f(HOstring\fP until \f(HOnew_length\fP is reached.
.IP "RETURN VALUE"
This procedure returns a string containing \f(HOstring\fP followed by
\f(HOpattern\fP.
The actual length of this string is \f(HOnew_length\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOPositionIsOutOfRange\fP"
is raised, if \f(HOnew_length\fP is less than the actual length of 
\f(HOstring\fP.
.KS
.IP EXAMPLES
.CS L
VAR string1    : STRING;
VAR string2    : STRING;
VAR new_length : INT;
VAR pattern    : CHAR;
\&...
string1    := "CoLibri";
new_length := 17;
pattern    := 'x';
string2    := String::AppendPattern (string1, new_length, pattern);
.CE
.KE
Then string2 has the value "CoLibrixxxxxxxxxx".
.LP
.OH "'CoLibri Reference Manual''String::CutLeadingBlanks'"
.EH "'String::CutLeadingBlanks''CoLibri Reference Manual'"
.bp
.NX 4 "CutLeadingBlanks"
.sp
.IP MODULE
\f(HBString\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE CutLeadingBlanks ($ IN string : STRING )
$: STRING;\fP
.TE
.IP DESCRIPTION
The procedure \f(HOCutLeadingBlanks\fP removes all leading blanks
of \f(HOstring\fP.
.IP "RETURN VALUE"
This procedure returns a string containing \f(HOstring\fP without leading
blanks.
The actual length of this string is the actual length of \f(HOstring\fP
decreased by the number of leading blanks.
.KS
.IP EXAMPLES
.CS L
VAR string1 : STRING;
VAR string2 : STRING;
\&...
string1 := "       CoLibri";
string2 := String::CutLeadingBlanks (string1);
.CE
.KE
Then string2 has the value "CoLibri".
.IP "SEE ALSO"
\f(HOCutTrailingBlanks\fP
.LP
.OH "'CoLibri Reference Manual''String::CutTrailingBlanks'"
.EH "'String::CutTrailingBlanks''CoLibri Reference Manual'"
.bp
.NX 4 "CutTrailingBlanks"
.sp
.IP MODULE
\f(HBString\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE CutTrailingBlanks ($ IN string : STRING )
$: STRING;\fP
.TE
.IP DESCRIPTION
The procedure \f(HOCutTrailingBlanks\fP removes all trailing blanks
of \f(HOstring\fP.
.IP "RETURN VALUE"
This procedure returns a string containing \f(HOstring\fP without trailing
blanks.
The actual length of this string is the actual length of \f(HOstring\fP
decreased by the number of trailing blanks.
.KS
.IP EXAMPLES
.CS L
VAR string1 : STRING;
VAR string2 : STRING;
\&...
string1 := "   CoLibri       ";
string2 := String::CutTrailingBlanks (string1);
.CE
.KE
Then string2 has the value "   CoLibri".
.IP "SEE ALSO"
\f(HOCutLeadingBlanks\fP
.LP
.OH "'CoLibri Reference Manual''String::FirstDifference'"
.EH "'String::FirstDifference''CoLibri Reference Manual'"
.bp
.NX 4 "FirstDifference"
.sp
.IP MODULE
\f(HBString\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBPROCEDURE FirstDifference ($ IN first_string $ : STRING,
$ IN second_string $ : STRING )
$: INT;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOFirstDifference\fP returns the position of the first
difference between \f(HOfirst_string\fP and \f(HOsecond_string\fP.
.IP "RETURN VALUE"
This procedure returns the position of the first difference between
\f(HOfirst_string\fP and \f(HOsecond_string\fP.
If there is no difference between \f(HOfirst_string\fP and
\f(HOsecond_string\fP, zero is returned.
.KS
.IP EXAMPLES
.CS L
VAR string1  : STRING;
VAR string2  : STRING;
VAR position : INT;
\&...
string1  := "CoLibri";
string2  := "Colibri";
position := String::FirstDifference (string1, string2);
.CE
.KE
Then position has the value 3.
.LP
.OH "'CoLibri Reference Manual''String::GetLength'"
.EH "'String::GetLength''CoLibri Reference Manual'"
.bp
.NX 4 "GetLength"
.sp
.IP MODULE
\f(HBString\fP
.IP SYNOPSIS
\f(HBPROCEDURE GetLength ( IN string : STRING ) : INT;\fP
.IP DESCRIPTION
The procedure \f(HOGetLength\fP returns the actual length of
\f(HOstring\fP.
.IP "RETURN VALUE"
This procedure returns the actual length of \f(HOstring\fP.
.KS
.IP EXAMPLES
.CS L
VAR string : STRING;
VAR length : INT;
\&...
string := "CoLibri";
length := String::GetLength (string);
.CE
.KE
Then length has the value 7.
.LP
.OH "'CoLibri Reference Manual''String::GetPosOfChar'"
.EH "'String::GetPosOfChar''CoLibri Reference Manual'"
.bp
.NX 4 "GetPosOfChar"
.sp
.IP MODULE
\f(HBString\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBPROCEDURE GetPosOfChar ($ IN string $ : STRING,
$ IN pattern $ : CHAR,
$ IN after_position $ : INT )
$: INT;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOGetPosOfChar\fP returns the position of the first
occurrence of \f(HOpattern\fP within \f(HOstring\fP starting at
\f(HOafter_position\fP.
.IP "RETURN VALUE"
This procedure returns the position of the first occurrence of \f(HOpattern\fP
within \f(HOstring\fP starting at \f(HOafter_position\fP.
If \f(HOpattern\fP does not exist, zero is returned.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOPositionIsOutOfRange\fP"
is raised, if \f(HOafter_position\fP is less than zero or greater than 
the actual length of \f(HOstring\fP.
.KS
.IP EXAMPLES
.CS L
VAR string         : STRING;
VAR pattern        : CHAR;
VAR after_position : INT;
VAR found_at       : INT;
\&...
string         := "CoLibri";
pattern        := 'i';
after_position := 4;
found_at       := String::GetPosOfChar (string, pattern, after_position);
.CE
.KE
Then found_at has the value 7.
.IP "SEE ALSO"
\f(HOGetPosOfSubString\fP
.LP
.OH "'CoLibri Reference Manual''String::GetPosOfSubString'"
.EH "'String::GetPosOfSubString''CoLibri Reference Manual'"
.bp
.NX 4 "GetPosOfSubString"
.sp
.IP MODULE
\f(HBString\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBPROCEDURE GetPosOfSubString ($ IN string $ : STRING,
$ IN sub_string $ : STRING,
$ IN after_position $ : INT)
$: INT;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOGetPosOfSubString\fP returns the position of the first
occurrence of \f(HOsub_string\fP within \f(HOstring\fP starting
\f(HOafter_position\fP.
.IP "RETURN VALUE"
This procedure returns the position of the first occurrence of
\f(HOsub_string\fP within \f(HOstring\fP.
Searching is started in \f(HOstring\fP \f(HOafter_position\fP.
If \f(HOsub_string\fP is not a complete sub\f(HOString\fP, zero is returned.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOPositionIsOutOfRange\fP"
is raised, if \f(HOafter_position\fP is less than zero or greater than 
the actual length of \f(HOstring\fP.
.KS
.IP EXAMPLES
.CS L
VAR string1        : STRING;
VAR string2        : STRING;
VAR after_position : INT;
VAR found_at       : INT;
\&...
string1        := "CoLibri";
string2        := "Libri";
after_position := 2;
found_at       := String::GetPosOfSubString (string1, string2, after_position);
.CE
.KE
Then found_at has the value 3.
.IP "SEE ALSO"
\f(HOGetPosOfChar\fP
.LP
.OH "'CoLibri Reference Manual''String::InsertChar'"
.EH "'String::InsertChar''CoLibri Reference Manual'"
.bp
.NX 4 "InsertChar"
.sp
.IP MODULE
\f(HBString\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBPROCEDURE InsertChar ($ IN string $ : STRING,
$ IN position $ : INT,
$ IN char_to_be_inserted $ : CHAR )
$: STRING;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOInsertChar\fP inserts \f(HOchar_to_be_inserted\fP at
\f(HOposition\fP in \f(HOstring\fP.
.IP "RETURN VALUE"
This procedure returns an enlarged copy of \f(HOstring\fP containing
\f(HOchar_to_be_inserted\fP at \f(HOposition\fP.
The actual length of this string is the actual length of \f(HOstring\fP
increased by one.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOPositionIsOutOfRange\fP"
is raised, if \f(HOposition\fP is less than one or greater than the 
actual length of \f(HOstring\fP.
.KS
.IP EXAMPLES
.CS L
VAR string1   : STRING;
VAR string2   : STRING;
VAR position  : INT;
VAR character : CHAR;
\&...
string1   := "CoLibri";
position  := 3;
character := 'o';
string2   := String::InsertChar (string1, position, character);
.CE
.KE
Then string2 has the value "CooLibri".
.IP "SEE ALSO"
\f(HOInsertString\fP,
\f(HORemoveChar\fP
.LP
.OH "'CoLibri Reference Manual''String::InsertString'"
.EH "'String::InsertString''CoLibri Reference Manual'"
.bp
.NX 4 "InsertString"
.sp
.IP MODULE
\f(HBString\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBPROCEDURE InsertString ($ IN string $ : STRING,
$ IN position $ : INT,
$ IN string_to_be_inserted $ : STRING )
$: STRING;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOInsertString\fP inserts \f(HOstring_to_be_inserted\fP at
\f(HOposition\fP in \f(HOstring\fP.
.IP "RETURN VALUE"
This procedure returns an enlarged copy of \f(HOstring\fP containing
\f(HOstring_to_be_inserted\fP at \f(HOposition\fP.
The actual length of this string is the sum of the actual length of
\f(HOstring\fP and \f(HOstring_to_be_inserted\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOPositionIsOutOfRange\fP"
is raised, if \f(HOposition\fP is less than one or greater than the 
actual length of \f(HOstring\fP.
.KS
.IP EXAMPLES
.CS L
VAR string1  : STRING;
VAR string2  : STRING;
VAR string3  : STRING;
VAR position : INT;
\&...
string1  := "CoLibri";
string2  := "123";
position := 3;
string3  := String::InsertString (string1, position, string2);
.CE
.KE
Then string3 has the value "Co123Libri".
.IP "SEE ALSO"
\f(HOInsertChar\fP,
\f(HORemoveSubString\fP
.LP
.OH "'CoLibri Reference Manual''String::RemoveAllPattern'"
.EH "'String::RemoveAllPattern''CoLibri Reference Manual'"
.bp
.NX 4 "RemoveAllPattern"
.sp
.IP MODULE
\f(HBString\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBPROCEDURE RemoveAllPattern ($ IN string $ : STRING,
$ IN pattern $ : CHAR )
$: STRING;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HORemoveAllPattern\fP removes all occurrences of
\f(HOpattern\fP in \f(HOstring\fP.
.IP "RETURN VALUE"
This procedure returns a string containing \f(HOstring\fP reduced by
the occurrences of \f(HOpattern\fP.
The actual length of this string is the actual length of \f(HOstring\fP
decreased by the number of characters equal to \f(HOpattern\fP.
.KS
.IP EXAMPLES
.CS L
VAR string1   : STRING;
VAR string2   : STRING;
VAR character : CHAR;
\&...
string1   := "CoLibri";
character := 'i';
string2   := String::RemoveAllPattern (string1, character);
.CE
.KE
Then string2 has the value "CoLbr".
.IP "SEE ALSO"
\f(HORemoveChar\fP,
\f(HORemoveSubString\fP
.LP
.OH "'CoLibri Reference Manual''String::RemoveChar'"
.EH "'String::RemoveChar''CoLibri Reference Manual'"
.bp
.NX 4 "RemoveChar"
.sp
.IP MODULE
\f(HBString\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBPROCEDURE RemoveChar ($ IN string $ : STRING,
$ IN position $ : INT )
$: STRING;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HORemoveChar\fP removes the character at
\f(HOposition\fP in \f(HOstring\fP.
.IP "RETURN VALUE"
This procedure returns a string containing \f(HOstring\fP reduced by the
charater at \f(HOposition\fP.
The actual length of this string is the actual length of \f(HOstring\fP
decreased by one.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOPositionIsOutOfRange\fP"
is raised, if \f(HOposition\fP is less than one or greater than the 
actual length of \f(HOstring\fP.
.KS
.IP EXAMPLES
.CS L
VAR string  : STRING;
VAR position : INT;
\&...
string   := "CoLibri";
position := 3;
string   := String::RemoveChar (string, position);
.CE
.KE
Then string has the value "Coibri".
.IP "SEE ALSO"
\f(HOInsertChar\fP,
\f(HORemoveAllPattern\fP,
\f(HORemoveSubString\fP
.LP
.OH "'CoLibri Reference Manual''String::RemoveSubString'"
.EH "'String::RemoveSubString''CoLibri Reference Manual'"
.bp
.NX 4 "RemoveSubString"
.sp
.IP MODULE
\f(HBString\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBPROCEDURE RemoveSubString ($ IN string $ : STRING,
$ IN position $ : INT,
$ IN length $ : INT )
$: STRING;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HORemoveSubString\fP removes the substring with the length
\f(HOlength\fP of \f(HOstring\fP starting at \f(HOposition\fP.
.IP "RETURN VALUE"
This procedure returns a string containing \f(HOstring\fP reduced by the
substring with the length \f(HOlength\fP of \f(HOstring\fP starting at
\f(HOposition\fP.
The actual length of this string is the actual length of \f(HOstring\fP
decreased by \f(HOlength\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOPositionIsOutOfRange\fP"
is raised, if \f(HOposition\fP is less than one or greater than the 
actual length of \f(HOstring\fP.
.IP "\(bu \f(HOSubStringIsOutOfRange\fP"
is raised, if the area which was wanted to be removed does not lie 
completely within \f(HOstring\fP.
.KS
.IP EXAMPLES
.CS L
VAR string1  : STRING;
VAR string2  : STRING;
VAR position : INT;
VAR length   : INT;
\&...
string1  := "CoLibri";
position := 5;
length   := 2;
string2  := String::RemoveSubString (string1, position, length);
.CE
.KE
Then string2 has the value "CoLii".
.IP "SEE ALSO"
\f(HOInsertString\fP,
\f(HORemoveAllPattern\fP,
\f(HORemoveChar\fP
.LP
.OH "'CoLibri Reference Manual''String::ToLower'"
.EH "'String::ToLower''CoLibri Reference Manual'"
.bp
.NX 4 "ToLower"
.sp
.IP MODULE
\f(HBString\fP
.IP SYNOPSIS
\f(HBPROCEDURE ToLower ( IN string : STRING ) : STRING;\fP
.IP DESCRIPTION
The procedure \f(HOToLower\fP converts all capital letters of
\f(HOstring\fP to small letters.
.IP "RETURN VALUE"
This procedure returns a copy of \f(HOstring\fP containing only small
letters.
.KS
.IP EXAMPLES
.CS L
VAR string : STRING;
\&...
string := "123CoLibri";
string := String::ToLower (string);
.CE
.KE
Then string has the value "123colibri".
.IP "SEE ALSO"
\f(HOToUpper\fP
.LP
.OH "'CoLibri Reference Manual''String::ToUpper'"
.EH "'String::ToUpper''CoLibri Reference Manual'"
.bp
.NX 4 "ToUpper"
.sp
.IP MODULE
\f(HBString\fP
.IP SYNOPSIS
\f(HBPROCEDURE ToUpper ( IN string : STRING ) : STRING;\fP
.IP DESCRIPTION
The procedure \f(HOToUpper\fP converts all small letters of
\f(HOstring\fP to capital letters.
.IP "RETURN VALUE"
This procedure returns a copy of \f(HOstring\fP containing only capital
letters.
.KS
.IP EXAMPLES
.CS L
VAR string : STRING;
\&...
string := "123CoLibri";
string := String::ToUpper (string);
.CE
.KE
Then string has the value "123COLIBRI".
.IP "SEE ALSO"
\f(HOToLower\fP
.LP
.OH "'CoLibri Reference Manual''String'"
.EH "'String''CoLibri Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOString\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
AppendPattern$IN$string$STRING$PositionIsOutOfRange
$IN$new_length$INT$
$IN$pattern$CHAR$
$result$$STRING$
_
CutLeadingBlanks$IN$string$STRING$
$result$$STRING$
_
CutTrailingBlanks$IN$string$STRING$
$result$$STRING$
_
FirstDifference$IN$first_string$STRING$
$IN$second_string$STRING$
$result$$INT$
_
GetLength$IN$string$STRING$
$result$$INT$
_
GetPosOfChar$IN$string$STRING$PositionIsOutOfRange
$IN$pattern$CHAR$
$IN$after_position$INT$
$result$$INT$
_
GetPosOfSubString$IN$string$STRING$PositionIsOutOfRange
$IN$sub_string$STRING$
$IN$after_position$INT$
$result$$INT$
_
InsertChar$IN$string$STRING$PositionIsOutOfRange
$IN$position$INT$
$IN$char_to_be_inserted$CHAR$
$result$$STRING$
_
InsertString$IN$string$STRING$PositionIsOutOfRange
$IN$position$INT$
$IN$string_to_be_inserted$STRING$
$result$$STRING$
_
RemoveAllPattern$IN$string$STRING$
$IN$pattern$CHAR$
$result$$STRING$
_
RemoveChar$IN$string$STRING$PositionIsOutOfRange
$IN$position$INT$
$result$$STRING$
.TE
.NL
.nr PS 12
.KE
.LP
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
RemoveSubString$IN$string$STRING$PositionIsOutOfRange
$IN$position$INT$SubStringIsOutOfRange
$IN$length$INT$
$result$$STRING$
_
ToLower$IN$string$STRING$
$result$$STRING$
_
ToUpper$IN$string$STRING$
$result$$STRING$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''Conversions'"
.EH "'Conversions''CoLibri Reference Manual'"
.bp
.NX 2 "Conversions"
.sp
.NX 3 "Type Description"
.sp
\f(HOConversions\fP provides a set of type conversion procedures for the
simple data types of CooL.
.sp
.NX 3 "List of Procedures"
.sp
The following procedures are available in <Conversions.cs>:
.TS
tab(#);
l.
Procedure name
_
BcdToDouble 
BcdToInt 
BcdToString 
CharToInt 
CStringToString
CStringFixedToString
DoubleToBcd 
DoubleToInt
DoubleToString 
IntToBcd 
IntToChar 
IntToDouble
IntToString 
StringToBcd 
StringToCString
StringToCStringFixed
StringToDouble 
StringToInt 
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each method described below the exceptions which will be raised in case
of an error are listed.
.sp
The following exceptions can be raised using module \f(HOConversions\fP :
.TS
tab($);
l.
exception name
_
BcdIsOutOfRange
DoubleIsOutOfRange
IntegerIsOutOfRange
PositionIsOutOfRange
StringContainsNoBcd
StringContainsNoDigits
.TE
.sp
.NX 3 "How to use CooL Support"
.sp
Each CooL module which uses a conversion procedure of \f(HOConversions\fP
must import the module \f(HOConversions\fP:
.CS L
IMPORT ..., Conversions, ...;
.CE
.sp 0.5
.NX 3 "Procedure Description"
.sp
The following sections contain the syntactical and semantical description of
all procedures provided by \f(HOConversions\fP.
They are listed in alphabetical order.
.sp
.OH "'CoLibri Reference Manual''Conversions::BcdToDouble'"
.EH "'Conversions::BcdToDouble''CoLibri Reference Manual'"
.bp
.NX 4 "BcdToDouble"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
\f(HBPROCEDURE BcdToDouble ( IN value : BCD ) : DOUBLE;\fP
.IP DESCRIPTION
The procedure \f(HOBcdToDouble\fP converts \f(HOvalue\fP into a double.
.IP "RETURN VALUE"
This procedure returns a double which represents \f(HOvalue\fP.
.KS
.IP EXAMPLES
.CS L
VAR bcd    : Bcd::BCD;                                                 
VAR double : DOUBLE;                                                   
\&...
bcd    := Conversions::StringToBcd ("1.7");
double := Conversions::BcdToDouble (bcd);
.CE
.KE
Then double has the value 1.7.
.IP "SEE ALSO"
\f(HOBcdToInt\fP,
\f(HOBcdToString\fP,
\f(HODoubleToBcd\fP
.LP
.OH "'CoLibri Reference Manual''Conversions::BcdToInt'"
.EH "'Conversions::BcdToInt''CoLibri Reference Manual'"
.bp
.NX 4 "BcdToInt"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
\f(HBPROCEDURE BcdToInt ( IN value : BCD ) : INT;\fP
.IP DESCRIPTION
The procedure \f(HOBcdToInt\fP converts \f(HOvalue\fP into an integer.
If \f(HOvalue\fP is not a whole number, the fractional part is truncated.
.IP "RETURN VALUE"
This procedure returns an integer which represents the integral part of
\f(HOvalue\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOBcdIsOutOfRange\fP"
is raised, if \f(HOvalue\fP is less than {INT_MIN} or greater than {INT_MAX}.
.IP EXAMPLES
.CS L
VAR bcd     : Bcd::BCD;
VAR integer : INT;
\&...
bcd     := Conversions::StringToBcd ("1.7");
integer := Conversions::BcdToInt (bcd);
.CE
.KE
Then integer has the value 1.
.IP "SEE ALSO"
\f(HOBcdToDouble\fP,
\f(HOBcdToString\fP,
\f(HOIntToBcd\fP
.LP
.OH "'CoLibri Reference Manual''Conversions::BcdToString'"
.EH "'Conversions::BcdToString''CoLibri Reference Manual'"
.bp
.NX 4 "BcdToString"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
\f(HBPROCEDURE BcdToString ( IN value : BCD ) : STRING;\fP
.IP DESCRIPTION
The procedure \f(HOBcdToString\fP converts \f(HOvalue\fP into a string.
.IP "RETURN VALUE"
This procedure returns a string which represents \f(HOvalue\fP.
.IP EXAMPLES
.CS L
VAR bcd    : Bcd::BCD;
VAR string : STRING;
\&...
bcd    := Conversions::StringToBcd ("1.7");
string := Conversions::BcdToString (bcd);
.CE
.KE
Then string has the value "1.7".
.IP "SEE ALSO"
\f(HOBcdToDouble\fP,
\f(HOBcdToInt\fP,
\f(HOStringToBcd\fP
.LP
.OH "'CoLibri Reference Manual''Conversions::CharToInt'"
.EH "'Conversions::CharToInt''CoLibri Reference Manual'"
.bp
.NX 4 "CharToInt"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
\f(HBPROCEDURE CharToInt ( IN value : CHAR ) : INT;\fP
.IP DESCRIPTION
The procedure \f(HOCharToInt\fP converts the character \f(HOvalue\fP into an
integer.
.IP "RETURN VALUE"
This procedure returns the ordinal number of \f(HOvalue\fP.
.KS
.IP EXAMPLES
.CS L
VAR integer   : INT;
VAR character : CHAR;
\&...
character := 'Y';
integer   := Conversions::CharToInt (character);
.CE
.KE
The result is machine dependent.
It is 89, if the ascii character code is used.
.IP "SEE ALSO"
\f(HOIntToChar\fP
.LP
.OH "'CoLibri Reference Manual''Conversions::CStringFixedToString'"
.EH "'Conversions::CStringFixedToString''CoLibri Reference Manual'"
.bp
.NX 4 "CStringFixedToString"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE CStringFixedToString $($ IN value $ : REF ARRAY OF CHAR,
$$ IN length $ : INT)
$:$ STRING;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOCStringFixedToString\fP converts the C-String \f(HOvalue\fP 
into a \f(HOSTRING\fP value.
The conversion is stopped when the string has the length specified by 
\f(HOlength\fP or if the null character is reached. 
The null character will not be converted.
.IP "RETURN VALUE"
This procedure returns a string which represents the first \f(HOlength\fP 
characters of \f(HOvalue\fP.
The actual length of this string is \f(HOlength\fP or (if the length of 
\f(HOvalue\fP is less than \f(HOlength\fP) the length of \f(HOvalue\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOPositionIsOutOfRange\fP"
is raised, if \f(HOlength\fP is less than zero.
.KS
.IP EXAMPLES
.CS L
CONST LENGTH   : INT    = 2;
CONST SIZE     : size_t = 8;
\&...
VAR string       : STRING;
VAR c_string_adr : REF ARRAY OF CHAR;
\&...
c_string_adr := "CoLibri";
string       := Conversions::CStringFixedToString (c_string_adr, LENGTH);
.CE
.KE
The string has the value "Co".
.IP "SEE ALSO"
\f(HOCStringToString\fP,
\f(HOStringToCStringFixed\fP,
\f(HOStringToCString\fP
.LP
.OH "'CoLibri Reference Manual''Conversions::CStringToString'"
.EH "'Conversions::CStringToString''CoLibri Reference Manual'"
.bp
.NX 4 "CStringToString"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE CStringToString ($ IN value : REF ARRAY OF CHAR )
$: STRING ;\fP
.TE
.IP DESCRIPTION
The procedure \f(HOCStringToString\fP converts the C-String \f(HOvalue\fP into 
a \f(HOSTRING\fP value.
All characters of \f(HOvalue\fP are converted except the null character.
.IP "RETURN VALUE"
This procedure returns a string which represents \f(HOvalue\fP.
the actual length of this string is the length of \f(HOvalue\fP except the null
character.
.IP EXAMPLES
.CS L
VAR string       : STRING;
VAR c_string_adr : REF ARRAY OF CHAR;
\&...
c_string_adr := stdlib::malloc (8); -- space for null character!
DeliverLibraryname (c_string_adr);  -- Procedure which delivers
                                  -- the C-String "CoLibri";
string := Conversions::CStringToString (c_string_adr);
\&...
stdlib::free (c_string_adr);
.CE
The string has the value "CoLibri".
.KE
.IP "SEE ALSO"
\f(HOCStringFixedToString\fP,
\f(HOStringToCString\fP,
\f(HOStringToCStringFixed\fP
.LP
.OH "'CoLibri Reference Manual''Conversions::DoubleToBcd'"
.EH "'Conversions::DoubleToBcd''CoLibri Reference Manual'"
.bp
.NX 4 "DoubleToBcd"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
\f(HBPROCEDURE DoubleToBcd ( IN value : DOUBLE ) : BCD;\fP
.IP DESCRIPTION
The procedure \f(HODoubleToBcd\fP converts \f(HOvalue\fP into a \f(HOBCD\fP
value.
.IP "RETURN VALUE"
This procedure returns a \f(HOBCD\fP value which represents 
\f(HOvalue\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODoubleIsOutOfRange\fP" 
is raised, if \f(HOvalue\fP is less than {DBL_MIN} or greater 
than {DBL_MAX}.
.IP EXAMPLES
.CS L
VAR double : DOUBLE;
VAR bcd    : Bcd::BCD;
\&...
double := 1.7;
bcd    := Conversions::DoubleToBcd (double);
.CE
.KE
.IP "SEE ALSO"
\f(HOBcdToDouble\fP,
\f(HODoubleToInt\fP,
\f(HODoubleToString\fP
.LP
.OH "'CoLibri Reference Manual''Conversions::DoubleToInt'"
.EH "'Conversions::DoubleToInt''CoLibri Reference Manual'"
.bp
.NX 4 "DoubleToInt"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
\f(HBPROCEDURE DoubleToInt ( IN value : DOUBLE ) : INT;\fP
.IP DESCRIPTION
The procedure \f(HODoubleToInt\fP converts \f(HOvalue\fP into an integer.
If \f(HOvalue\fP is not a whole number, the fractional part is truncated.
.IP "RETURN VALUE"
This procedure returns an integer which represents the integral part of
\f(HOvalue\fP.
.KS
.IP EXAMPLES
.CS L
VAR double  : DOUBLE;
VAR integer : INT;
\&...
double  := 1.7;
integer := Conversions::DoubleToInt (double);
.CE
.KE
Then integer has the value 1.
.IP "SEE ALSO"
\f(HODoubleToBcd\fP,
\f(HODoubleToString\fP,
\f(HOIntToDouble\fP
.LP
.OH "'CoLibri Reference Manual''Conversions::DoubleToString'"
.EH "'Conversions::DoubleToString''CoLibri Reference Manual'"
.bp
.NX 4 "DoubleToString"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
\f(HBPROCEDURE DoubleToString ( IN value : DOUBLE ) : STRING;\fP
.IP DESCRIPTION
The procedure \f(HODoubleToString\fP converts \f(HOvalue\fP into a 
\f(HOstring\fP value.
.IP "RETURN VALUE"
This procedure returns a string which represents \f(HOvalue\fP.
The actual length of this string is the number of positions of the 
standardized representation of \f(HOvalue\fP.
.IP EXAMPLES
.CS L
VAR double : DOUBLE;
VAR string : STRING;
\&...
double := 17.17;
string := Conversions::DoubleToString (double);
.CE
.KE
Then string has the value "1.7170000000000000E+01".
.IP "SEE ALSO"
\f(HODoubleToBcd\fP,
\f(HODoubleToInt\fP,
\f(HOStringToDouble\fP
.LP
.OH "'CoLibri Reference Manual''Conversions::IntToBcd'"
.EH "'Conversions::IntToBcd''CoLibri Reference Manual'"
.bp
.NX 4 "IntToBcd"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
\f(HBPROCEDURE IntToBcd ( IN value : INT ) : BCD;\fP
.IP DESCRIPTION
The procedure \f(HOIntToBcd\fP converts \f(HOvalue\fP into a \f(HOBCD\fP
value.
.IP "RETURN VALUE"
This procedure returns a \f(HOBCD\fP value which represents \f(HOvalue\fP.
.KS
.IP EXAMPLES
.CS L
VAR integer : INT;
VAR bcd     : Bcd::BCD;
\&...
integer := 17;
bcd     := Conversions::IntToBcd (integer);
.CE
.KE
.IP "SEE ALSO"
\f(HOBcdToInt\fP,
\f(HOIntToChar\fP,
\f(HOIntToDouble\fP,
\f(HOIntToString\fP
.LP
.OH "'CoLibri Reference Manual''Conversions::IntToChar'"
.EH "'Conversions::IntToChar''CoLibri Reference Manual'"
.bp
.NX 4 "IntToChar"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
\f(HBPROCEDURE IntToChar ( IN value : INT ) : CHAR;\fP
.IP DESCRIPTION
The procedure \f(HOIntToChar\fP converts the integer \f(HOvalue\fP into a
character.
.IP "RETURN VALUE"
This procedure returns the character with the ordinal number \f(HOvalue\fP.
If \f(HOvalue\fP is greater than 256, \f(HOvalue\fP modulo 256 is used instead 
of \f(HOvalue\fP.
If \f(HOvalue\fP is greater than 128 and less than 256, the result is machine
dependent.
.KS
.IP EXAMPLES
.CS L
VAR integer   : INT;
VAR character : CHAR;
\&...
integer   := 89;
character := Conversions::IntToChar (integer);
.CE
.KE
The result is machine dependent.
It is "Y", if the ascii character code is used.
.IP "SEE ALSO"
\f(HOCharToInt\fP,
\f(HOIntToBcd\fP,
\f(HOIntToDouble\fP,
\f(HOIntToString\fP
.LP
.OH "'CoLibri Reference Manual''Conversions::IntToDouble'"
.EH "'Conversions::IntToDouble''CoLibri Reference Manual'"
.bp
.NX 4 "IntToDouble"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
\f(HBPROCEDURE IntToDouble ( IN value : INT ) : DOUBLE;\fP
.IP DESCRIPTION
The procedure \f(HOIntToDouble\fP converts \f(HOvalue\fP into a double.
.IP "RETURN VALUE"
This procedure returns a double which represents \f(HOvalue\fP.
.KS
.IP EXAMPLES
.CS L
VAR integer : INT;
VAR double  : DOUBLE;                                                   
\&...
integer := 17;
double  := Conversions::IntToDouble (integer);
.CE
.KE
Then double has the value 1.7E+01.
.IP "SEE ALSO"
\f(HODoubleToInt\fP,
\f(HOIntToBcd\fP,
\f(HOIntToChar\fP,
\f(HOIntToString\fP
.LP
.OH "'CoLibri Reference Manual''Conversions::IntToString'"
.EH "'Conversions::IntToString''CoLibri Reference Manual'"
.bp
.NX 4 "IntToString"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
\f(HBPROCEDURE IntToString ( IN value : INT ) : STRING;\fP
.IP DESCRIPTION
The procedure \f(HOIntToString\fP converts the integer \f(HOvalue\fP into a
\f(HOSTRING\fP value.
.IP "RETURN VALUE"
This procedure returns a string which represents \f(HOvalue\fP.
The actual length is the number of digits of \f(HOvalue\fP plus one for
the minus sign if \f(HOvalue\fP is negative.
.KS
.IP EXAMPLES
.CS L
VAR integer : INT;
VAR string  : STRING;
\&...
integer := 17;
string  := Conversions::IntToString (integer);
.CE
.KE
Then string has the value "17".
.IP "SEE ALSO"
\f(HOIntToBcd\fP,
\f(HOIntToChar\fP,
\f(HOIntToDouble\fP,
\f(HOStringToInt\fP
.LP
.OH "'CoLibri Reference Manual''Conversions::StringToBcd'"
.EH "'Conversions::StringToBcd''CoLibri Reference Manual'"
.bp
.NX 4 "StringToBcd"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
\f(HBPROCEDURE StringToBcd ( IN value : STRING ) : BCD;\fP
.IP DESCRIPTION
The procedure \f(HOStringToBcd\fP converts \f(HOvalue\fP into a \f(HOBCD\fP
value.
.IP "RETURN VALUE"
This procedure returns a \f(HOBCD\fP value which represents \f(HOvalue\fP.
.IP NOTE
A dot must be used as decimal point.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOBcdIsOutOfRange\fP"
is raised, if the exponent of the converted string is invalid, i.e. 
underflow or overflow.
.IP "\(bu \f(HOStringContainsNoBcd\fP"
is raised, if \f(HOvalue\fP contains an invalid character string for 
conversion into a BCD type.
.IP EXAMPLES
.CS L
VAR string : STRING;
VAR bcd    : Bcd::BCD;
\&...
string := "1.7";
bcd    := Conversions::StringToBcd (string);
.CE
.KE
.IP "SEE ALSO"
\f(HOBcdToString\fP,
\f(HOStringToCString\fP,
\f(HOStringToCStringFixed\fP,
\f(HOStringToDouble\fP,
\f(HOStringToInt\fP
.LP
.OH "'CoLibri Reference Manual''Conversions::StringToCString'"
.EH "'Conversions::StringToCString''CoLibri Reference Manual'"
.bp
.NX 4 "StringToCString"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE $$StringToCString$ 
$($ IN c_string_adr $ : REF ARRAY OF CHAR,
$$ IN value $ : STRING ) 
$:$ REF ARRAY OF CHAR;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOStringToCString\fP converts \f(HOvalue\fP into a C-String
which is terminated by a null character.
If \f(HOvalue\fP contains null characters, the conversion is stopped at the
first one.
.IP "RETURN VALUE"
This procedure returns a C-String which represents \f(HOvalue\fP.
.IP NOTE
The user of this function has to deliver a pointer to enough memory space using 
the variable \f(HOc_string_adr\fP.
If there is not enough space for the C-String, the result of this procedure
may produce undefined effects.
.KS
.IP EXAMPLES
.CS L
VAR string       : STRING;
VAR string_size  : stdlib::size_t;
VAR c_string_adr : REF ARRAY OF CHAR;
\&...
string       := "CoLibri";
string_size  := String::GetLength (string) + 1; -- space for null character!
c_string_adr := stdlib::malloc (string_size);
c_string_adr := Conversions::StringToCString (c_string_adr, string);
\&...
stdlib::free (c_string_adr);
.CE
.KE
The cStringAdr points to "CoLibri" (before the memory space is set free).
.IP "SEE ALSO"
\f(HOCStringToString\fP,
\f(HOStringToBcd\fP,
\f(HOStringToCStringFixed\fP,
\f(HOStringToDouble\fP,
\f(HOStringToInt\fP
.LP
.OH "'CoLibri Reference Manual''Conversions::StringToCStringFixed'"
.EH "'Conversions::StringToCStringFixed''CoLibri Reference Manual'"
.bp
.NX 4 "StringToCStringFixed"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE $$StringToCStringFixed$ 
$( $ IN c_string_adr $ : REF ARRAY OF CHAR,
$$ IN value $ : STRING,
$$ IN length $ : INT )
$:$ REF ARRAY OF CHAR;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOStringToCStringFixed\fP converts \f(HOvalue\fP into a C-String
which is terminated by a null character. 
The conversion is stopped when the C-String has the length specified by
\f(HOlength\fP or if the actual length of \f(HOvalue\fP is reached.
If \f(HOvalue\fP contains null characters, the conversion is stopped at the 
first one.
.IP "RETURN VALUE"
This procedure returns a C-String which represents the first \f(HOlength\fP
characters of \f(HOvalue\fP.
The actual length of this C-String is \f(HOlength\fP or (if the length of
\f(HOvalue\fP is less than \f(HOlength\fP) the length of \f(HOvalue\fP.
.IP NOTE
The user of this function has to deliver a pointer to enough memory space
using the variable \f(HOc_string_adr\fP. 
If there is not enough space for the C-String, the result of this procedure is
undefined.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOPositionIsOutOfRange\fP"
is raised, if \f(HOlength\fP is less than zero.
.KS
.IP EXAMPLES
.CS L
CONST STRING_COLIBRI : STRING = "CoLibri";
CONST LENGTH : INT = 5;
CONST SIZE : size_t = LENGTH + 1; -- space for null character!
\&...
VAR c_string_adr : REF ARRAY OF CHAR;
\&...
c_string_adr := stdlib::malloc (SIZE);
c_string_adr := 
   Conversions::StringToCStringFixed (c_string_adr, STRING_COLIBRI, LENGTH);
\&...
stdlib::free (c_string_adr);
.CE
.KE
Then c_string_adr points to "CoLib" (before the memory space is set free).
.IP "SEE ALSO"
\f(HOCStringFixedToString\fP,
\f(HOStringToBcd\fP,
\f(HOStringToCString\fP,
\f(HOStringToDouble\fP,
\f(HOStringToInt\fP
.LP
.OH "'CoLibri Reference Manual''Conversions::StringToDouble'"
.EH "'Conversions::StringToDouble''CoLibri Reference Manual'"
.bp
.NX 4 "StringToDouble"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
\f(HBPROCEDURE StringToDouble ( IN value : STRING ) : DOUBLE;\fP
.IP DESCRIPTION
The procedure \f(HOStringToDouble\fP converts \f(HOvalue\fP into a double.
If \f(HOvalue\fP contains characters which do not represent a double, the 
conversion is stopped at the first one.
.IP "RETURN VALUE"
This procedure returns a double which represents \f(HOvalue\fP.
.IP NOTE
This procedure recognizes a \f(HOSTRING\fP of the form :
.in +2
.br
[("+"|"-")]digit(s)["."digit(s)][("e"|"E"|" ")[("+"|"-")]digit(s)]
.br
.in -2
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODoubleIsOutOfRange\fP"
is raised, if the conversion of \f(HOvalue\fP causes an overflow.
The maximum und minimum values of a double are implementation depending!
.IP "\(bu \f(HOStringContainsNoDigits\fP"
is raised, if \f(HOvalue\fP does not start with a character representing
a double.
.KS
.IP EXAMPLES
.CS L
VAR string : STRING;
VAR double  : DOUBLE;
\&...
string := "123.456abc";
double := Conversions::StringToDouble (string);
.CE
.KE
Then double has the value 1.23456E+02.
.IP "SEE ALSO"
\f(HODoubleToString\fP,
\f(HOStringToBcd\fP,
\f(HOStringToCString\fP,
\f(HOStringToCStringFixed\fP,
\f(HOStringToInt\fP
.LP
.OH "'CoLibri Reference Manual''Conversions::StringToInt'"
.EH "'Conversions::StringToInt''CoLibri Reference Manual'"
.bp
.NX 4 "StringToInt"
.sp
.IP MODULE
\f(HBConversions\fP
.IP SYNOPSIS
\f(HBPROCEDURE StringToInt ( IN value : STRING ) : INT;\fP
.IP DESCRIPTION
The procedure \f(HOStringToInt\fP converts \f(HOvalue\fP into an integer.
If \f(HOvalue\fP contains characters which do not represent an integer, the 
conversion is stopped at the first one.
.IP "RETURN VALUE"
This procedure returns an integer which represents \f(HOvalue\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOIntegerIsOutOfRange\fP"
is raised, if the conversion of \f(HOvalue\fP causes an overflow.
The maximum and minimum values of an integer are implementation depending.
.IP "\(bu \f(HOStringContainsNoDigits\fP"
is raised, if \f(HOvalue\fP does not start with a character representing
an integer.
.KS
.IP EXAMPLES
.CS L
VAR string : STRING;
VAR integer : INT;
\&...
string := "123CoLibri";
integer := Conversions::StringToInt (string);
.CE
.KE
Then integer has the value 123.
.IP "SEE ALSO"
\f(HOIntToString\fP,
\f(HOStringToBcd\fP,
\f(HOStringToCString\fP,
\f(HOStringToCStringFixed\fP,
\f(HOStringToDouble\fP
.LP
.OH "'CoLibri Reference Manual''Conversions'"
.EH "'Conversions''CoLibri Reference Manual'"
.NX 3 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOConversions\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
BcdToDouble$IN$value$BCD$
$result$$DOUBLE$
_
BcdToInt$IN$value$BCD$BcdIsOutOfRange
$result$$INT$
_
BcdToString$IN$value$BCD$
$result$$STRING$
_
CharToInt$IN$value$CHAR$
$result$$INT$
_
CStringFixedToString$IN$value$REF ARRAY OF CHAR$PositionIsOutOfRange
$IN$length$INT$
$result$$STRING$
_
CStringToString$IN$value$REF ARRAY OF CHAR$
$result$$STRING$
_
DoubleToBcd$IN$value$DOUBLE$DoubleIsOutOfRange
$result$$BCD$
_
DoubleToInt$IN$value$DOUBLE$
$result$$INT$
_
DoubleToString$IN$value$DOUBLE$
$result$$STRING$
_
IntToBcd$IN$value$INT$
$result$$BCD$
_
IntToChar$IN$value$INT$
$result$$CHAR$
_
IntToDouble$IN$value$INT$
$result$$DOUBLE$
_
IntToString$IN$value$INT$
$result$$STRING$
_
StringToBcd$IN$value$STRING$BcdIsOutOfRange
$result$$BCD$StringContainsNoBcd
.TE
.NL
.nr PS 12
.KE
.LP
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
StringToCString$IN$c_string_adr$REF ARRAY OF CHAR$
$IN$value$STRING$
$result$$REF ARRAY OF CHAR$
_
StringToCStringFixed$IN$c_string_adr$REF ARRAY OF CHAR$PositionIsOutOfRange
$IN$value$STRING$$
$IN$length$INT$$
$result$$REF ARRAY OF CHAR$
_
StringToDouble$IN$value$STRING$DoubleIsOutOfRange
$result$$DOUBLE$StringContainsNoDigits
_
StringToInt$IN$value$STRING$IntegerIsOutOfRange
$result$$INT$StringContainsNoDigits
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''Environ'"
.EH "'Environ''CoLibri Reference Manual'"
.bp
.NX 2 "Environ"
.sp
.NX 3 "Type Description"
.sp
\f(HOEnviron\fP provides a set of procedures for the access on several
process oriented environment information.
.sp
.NX 3 "List of Procedures"
.sp
The following procedures are available in <Environ.cs>:
.TS
tab(#);
l.
Procedure name
_
GetEnvironVar
GetGroupId
GetProcessId
GetUserId
GetUserName
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For the procedures described below no exceptions are raised.
.sp
.NX 3 "How to use CooL Support"
.sp
Each CooL module which uses a procedure of \f(HOEnviron\fP must import 
the module \f(HOEnviron\fP:
.CS L
IMPORT ..., Environ, ...;
.CE
.sp 0.5
.NX 3 "Procedure Description"
.sp
The following sections contain the syntactical and semantical 
description of all procedures provided by \f(HOEnviron\fP.
They are listed in alphabetical order.
.sp
The procedures use the types 
.br
- \f(HOUID\fP for user id,
.br
- \f(HOGID\fP for group id
.br
and
.br
- \f(HOPID\fP for process id
.br
which are all declared in the module \f(HOInt\fP, too.
.LP
.OH "'CoLibri Reference Manual''Environ::GetEnvironVar'"
.EH "'Environ::GetEnvironVar''CoLibri Reference Manual'"
.bp
.NX 4 "GetEnvironVar"
.sp
.IP MODULE
\f(HBEnviron\fP
.IP SYNOPSIS
\f(HBPROCEDURE GetEnvironVar ( IN name : STRING ) : STRING;\fP 
.IP DESCRIPTION
The procedure \f(HOGetEnvironVar\fP returns the contents of the 
environment variable \f(HOname\fP as STRING.
.IP "RETURN VALUE"
The procedure returns the contents of the environment variable 
\f(HOname\fP.
If the environment variable \f(HOname\fP is unknown it returns an empty
string.
.KS
.IP EXAMPLES
.CS L
VAR name         : STRING;
VAR env_variable : STRING;
\&...
name         := "LANG";
env_variable := Environ::GetEnvironVar (name);
.CE
.KE
\f(HOenv_variable\fP contains now the actual contents of the environment
variable ${LANG}, e.g. En_GB.88591.
.LP
.OH "'CoLibri Reference Manual''Environ::GetGroupId'"
.EH "'Environ::GetGroupId''CoLibri Reference Manual'"
.bp
.NX 4 "GetGroupId"
.sp
.IP MODULE
\f(HBEnviron\fP
.IP SYNOPSIS
\f(HBPROCEDURE GetGroupId () : GID;\fP 
.IP DESCRIPTION
The procedure \f(HOGetGroupId\fP returns the group id of the current
process.
.IP "RETURN VALUE"
The procedure returns the group id of the current process.
.KS
.IP EXAMPLES
.CS L
VAR group_id : Environ::GID;
\&...
group_id := Environ::GetGroupId ();
.CE
.KE
Now \f(HOgroup_id\fP contains the group id of the current process, e.g.
1300.
.IP "SEE ALSO"
\f(HOGetProcessId\fP,
\f(HOGetUserId\fP,
\f(HOGetUserName\fP
.LP
.OH "'CoLibri Reference Manual''Environ::GetProcessId'"
.EH "'Environ::GetProcessId''CoLibri Reference Manual'"
.bp
.NX 4 "GetProcessId"
.sp
.IP MODULE
\f(HBEnviron\fP
.IP SYNOPSIS
\f(HBPROCEDURE GetProcessId () : PID;\fP
.IP DESCRIPTION
The procedure \f(HOGetProcessId\fP returns the process id of the current
process.
.IP "RETURN VALUE"
The procedure returns the process id of the current process.
.KS
.IP EXAMPLES
.CS L
VAR process_id : Environ::PID;
\&...
process_id := Environ::GetProcessId ();
.CE
.KE
Now \f(HOprocess_id\fP contains the process id of the current process,
e.g. 5624.
.IP "SEE ALSO"
\f(HOGetGroupId\fP,
\f(HOGetUserId\fP,
\f(HOGetUserName\fP
.LP
.OH "'CoLibri Reference Manual''Environ::GetUserId'"
.EH "'Environ::GetUserId''CoLibri Reference Manual'"
.bp
.NX 4 "GetUserId"
.sp
.IP MODULE
\f(HBEnviron\fP
.IP SYNOPSIS
\f(HBPROCEDURE GetUserId () : UID;\fP 
.IP DESCRIPTION
The procedure \f(HOGetUserId\fP the user id of the current process.
.IP "RETURN VALUE"
The procedure returns the user id of the current process.
.KS
.IP EXAMPLES
.CS L
VAR user_id : Environ::UID;
\&...
user_id := Environ::GetUserId ();
.CE
.KE
Now \f(HOuser_id\fP contains the user id of the current process, e.g.
1317.
.IP "SEE ALSO"
\f(HOGetGroupId\fP,
\f(HOGetProcessId\fP,
\f(HOGetUserName\fP
.LP
.OH "'CoLibri Reference Manual''Environ::GetUserName'"
.EH "'Environ::GetUserName''CoLibri Reference Manual'"
.bp
.NX 4 "GetUserName"
.sp
.IP MODULE
\f(HBEnviron\fP
.IP SYNOPSIS
\f(HBPROCEDURE GetUserName () : STRING;\fP 
.IP DESCRIPTION
The procedure \f(HOGetUserName\fP returns the name of the user of the
current process.
.IP "RETURN VALUE"
The procedure returns the name of the user of the current process.
.KS
.IP EXAMPLES
.CS L
VAR user_name : STRING;
\&...
user_name := Environ::GetUserName ();
.CE
.KE
Now \f(HOuser_name\fP contains the name of the user of the current 
process, e.g. hugo.
.IP "SEE ALSO"
\f(HOGetGroupId\fP,
\f(HOGetProcessId\fP,
\f(HOGetUserId\fP
.LP
.OH "'CoLibri Reference Manual''Environ'"
.EH "'Environ''CoLibri Reference Manual'"
.bp
.NX 4 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOEnviron\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
GetEnvironVar$IN$name$STRING$
$result$$STRING$
_
GetGroupId$result$$GID$
_
GetProcessId$result$$PID$
_
GetUserId$result$$UID$
_
GetUserName$result$$STRING$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'CoLibri Reference Manual''Abstract Data Types'"
.EH "'Abstract Data Types''CoLibri Reference Manual'"
.NX 1 "Abstract Data Types"
.sp
This chapter describes the abstract data types provided by CoLibri.
.sp
.OH "'CoLibri Reference Manual''Bcd'"
.EH "'Bcd''CoLibri Reference Manual'"
.bp
.NX 2 "Bcd"
.sp
.NX 3 "Type Description"
.sp
\f(HOBCD\fP is an abstract data type which provides a binary coded decimal
floating point arithmetic.
A precision of 18 digits (without decimal point) is guaranteed in the range
-65 <= exponent <= +62.
The type \f(HOBCD\fP can be used like any other CooL data type in a
declaration statement.
.sp
.NX 3 "List of Procedures"
.sp
The following procedures are available in <Bcd.cs>:
.TS
tab(#);
l l.
Procedure name
_
Abs
Add
Div
GetExponent
GetFractionalPart
GetIntegralPart
IsEqual
IsGreater
IsGreaterEqual
IsInteger
IsLess
IsLessEqual
IsNegative
IsNotEqual
Mod
Mul
Negate
Round
Sub
Trunc
.TE
.bp
.NX 3 "Predefined Values"
.sp
The following values are predefined:
.sp
Common values:
.TS
tab(#);
l l.
Name#Value
_
{min}#-9.99999999999999999 E +62
{max}#9.99999999999999999 E +62
{one}#one in \f(HOBCD\fP format
{smallest}#1.00000000000000000 E -65
{zero}#zero in \f(HOBCD\fP format
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each procedure described below the exceptions which will be raised in case
of an error are listed.
.sp
The following exceptions can be raised using module \f(HOBcd\fP :
.TS
tab($);
l.
exception name
_
ResultIsOutOfRange
ZeroDivision
.TE
.sp
.NX 3 "How to use Bcd"
.sp
A variable of type \f(HOBCD\fP is declared as follows:
.CS L
VAR bcd : Bcd::BCD;
.CE
.sp 0.5
A variable of type \f(HOBCD\fP can be initialized using the procedures
\f(HODoubleToBcd\fP, \f(HOIntToBcd\fP or \f(HOStringToBcd\fP.
.sp
Each CooL module which uses the type \f(HOBCD\fP must import the module 
\f(HOBcd\fP:
.CS L
IMPORT ..., Bcd, ...;
.CE
.sp 0.5
.NX 3 "Procedure Description"
.sp
The following sections contain the syntactical and semantical description of
all procedures provided by \f(HOBcd\fP.
They are listed in alphabetical order.
.LP
.OH "'CoLibri Reference Manual''Bcd::Abs'"
.EH "'Bcd::Abs''CoLibri Reference Manual'"
.bp
.NX 4 "Abs"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
\f(HBPROCEDURE Abs ( IN value : BCD ) : BCD;\fP
.IP DESCRIPTION
The procedure \f(HOAbs\fP computes the absolute value of \f(HOvalue\fP.
.IP "RETURN VALUE"
This procedure returns \f(HOvalue\fP, if \f(HOvalue\fP is greater than or
equal to zero.
Otherwise it returns \f(HO-value\fP.
.KS
.IP EXAMPLES
.CS L
VAR bcd    : Bcd::BCD;
VAR result : Bcd::BCD;
\&...
bcd    := Conversions::StringToBcd ("-.5");
result := Bcd::Abs (bcd);
.CE
.KE
Then result has the value 0.5.
.IP "SEE ALSO"
\f(HONegate\fP
.LP
.OH "'CoLibri Reference Manual''Bcd::Add'"
.EH "'Bcd::Add''CoLibri Reference Manual'"
.bp
.NX 4 "Add"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE Add $($ IN left_operand $ : BCD,
$$ IN right_operand $ : BCD )
$:$ BCD;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOAdd\fP adds the values of \f(HOleft_operand\fP and
\f(HOright_operand\fP.
.IP "RETURN VALUE"
This procedure returns the sum of \f(HOright_operand\fP and
\f(HOleft_operand\fP.
The position number of the lowest significant digit of the result value is the
maximum of the position numbers of \f(HOright_operand\fP and
\f(HOleft_operand\fP.
If the result value contains more digits than positions are available, digits
are truncated.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOResultIsOutOfRange\fP"
is raised, if the result of the computation is less then {min} or 
greater than {max}.
.IP EXAMPLES
.CS L
VAR bcd1   : Bcd::BCD;
VAR bcd2   : Bcd::BCD;
VAR result : Bcd::BCD;
\&...
bcd1   := Conversions::StringToBcd ("1.7");
bcd2   := Conversions::StringToBcd ("-0.7");
result := Bcd::Add (bcd1, bcd2);
.CE
.KE
.IP "SEE ALSO"
\f(HOSub\fP
.LP
.OH "'CoLibri Reference Manual''Bcd::Div'"
.EH "'Bcd::Div''CoLibri Reference Manual'"
.bp
.NX 4 "Div"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE Div $($ IN dividend $ : BCD,
$$ IN divisor $ : BCD )
$:$ BCD;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HODiv\fP divides the \f(HOdividend\fP by
\f(HOdivisor\fP.
.IP "RETURN VALUE"
This procedure returns the quotient of \f(HOdividend\fP and \f(HOdivisor\fP.
The number of positions of the result value is as high as possible.
If the result value contains more digits than positions are available, digits
are truncated.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOResultIsOutOfRange\fP"
is raised, if the result of the computation is less then {min} or 
greater than {max}.
.IP "\(bu \f(HOZeroDivision\fP"
is raised, if \f(HOdivisor\fP is equal zero.
.IP EXAMPLES
.CS L
VAR bcd1   : Bcd::BCD;
VAR bcd2   : Bcd::BCD;
VAR result : Bcd::BCD;
\&...
bcd1   := Conversions::StringToBcd ("1.7");
bcd2   := Conversions::StringToBcd ("-0.7");
result := Bcd::Div (bcd1, bcd2);
.CE
.KE
.IP "SEE ALSO"
\f(HOMod\fP,
\f(HOMul\fP
.LP
.OH "'CoLibri Reference Manual''Bcd::GetExponent'"
.EH "'Bcd::GetExponent''CoLibri Reference Manual'"
.bp
.NX 4 "GetExponent"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
\f(HBPROCEDURE GetExponent ( IN value : BCD ) : INT;\fP
.IP DESCRIPTION
The procedure \f(HOGetExponent\fP delivers the exponent of 
\f(HOvalue\fP.
.IP "RETURN VALUE"
This procedure returns the exponent of \f(HOvalue\fP.
.KS
.IP EXAMPLES
.CS L
VAR bcd    : Bcd::BCD;
VAR result : INT;
\&...
bcd    := Conversions::StringToBcd ("-5.1");
result := Bcd::GetExponent (bcd);
.CE
.KE
Then result has the value 0.
.IP "SEE ALSO"
\f(HOGetFractionalPart\fP,
\f(HOGetIntegralPart\fP
.LP
.OH "'CoLibri Reference Manual''Bcd::GetFractionalPart'"
.EH "'Bcd::GetFractionalPart''CoLibri Reference Manual'"
.bp
.NX 4 "GetFractionalPart"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
\f(HBPROCEDURE GetFractionalPart ( IN value : BCD ) : BCD;\fP
.IP DESCRIPTION
The procedure \f(HOGetFractionalPart\fP extracts the fractional part of
\f(HOvalue\fP.
.IP "RETURN VALUE"
This procedure returns the fractional part of \f(HOvalue\fP.
.KS
.IP EXAMPLES
.CS L
VAR bcd    : Bcd::BCD;
VAR result : Bcd::BCD;
\&...
bcd    := Conversions::StringToBcd ("-5.1");
result := Bcd::GetFractionalPart (bcd);
.CE
.KE
Then result has the value -0.1.
.IP "SEE ALSO"
\f(HOGetExponent\fP,
\f(HOGetIntegralPart\fP
.LP
.OH "'CoLibri Reference Manual''Bcd::GetIntegralPart'"
.EH "'Bcd::GetIntegralPart''CoLibri Reference Manual'"
.bp
.NX 4 "GetIntegralPart"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
\f(HBPROCEDURE GetIntegralPart ( IN value : BCD ) : BCD;\fP
.IP DESCRIPTION
The procedure \f(HOGetIntegralPart\fP extracts the integral part of
\f(HOvalue\fP.
.IP "RETURN VALUE"
This procedure returns the integral part of \f(HOvalue\fP.
.KS
.IP EXAMPLES
.CS L
VAR bcd    : Bcd::BCD;
VAR result : Bcd::BCD;
\&...
bcd    := Conversions::StringToBcd ("-5.1");
result := Bcd::GetIntegralPart (bcd);
.CE
.KE
Then result has the value -5.
.IP "SEE ALSO"
\f(HOGetExponent\fP,
\f(HOGetFractionalPart\fP
.LP
.OH "'CoLibri Reference Manual''Bcd::IsEqual'"
.EH "'Bcd::IsEqual''CoLibri Reference Manual'"
.bp
.NX 4 "IsEqual"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE IsEqual $($ IN left_operand $ : BCD,
$$ IN right_operand $ : BCD )
$:$ BOOL;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOIsEqual\fP tests whether \f(HOleft_operand\fP is equal to
\f(HOright_operand\fP.
.IP "RETURN VALUE"
This procedure returns TRUE, if \f(HOleft_operand\fP is equal to
\f(HOright_operand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR bcd1   : Bcd::BCD;
VAR bcd2   : Bcd::BCD;
VAR result : BOOL;
\&...
bcd1   := Conversions::StringToBcd ("5.0");
bcd2   := Conversions::StringToBcd ("2.0");
result := Bcd::IsEqual (bcd1, bcd2);
.CE
.KE
Then result has the value FALSE.
.IP "SEE ALSO"
\f(HOIsNotEqual\fP
.LP
.OH "'CoLibri Reference Manual''Bcd::IsGreater'"
.EH "'Bcd::IsGreater''CoLibri Reference Manual'"
.bp
.NX 4 "IsGreater"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE IsGreater $($ IN left_operand $ : BCD,
$$ IN right_operand $ : BCD )
$:$ BOOL;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOIsGreater\fP tests whether \f(HOleft_operand\fP is
greater than \f(HOright_operand\fP.
.IP "RETURN VALUE"
This procedure returns TRUE, if \f(HOleft_operand\fP is greater than
\f(HOright_operand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR bcd1   : Bcd::BCD;
VAR bcd2   : Bcd::BCD;
VAR result : BOOL;
\&...
bcd1   := Conversions::StringToBcd ("5.0");
bcd2   := Conversions::StringToBcd ("2.0");
result := Bcd::IsGreater (bcd1, bcd2);
.CE
.KE
The result has the value TRUE.
.IP "SEE ALSO"
\f(HOIsGreaterEqual\fP,
\f(HOIsLess\fP,
\f(HOIsLessEqual\fP,
.LP
.OH "'CoLibri Reference Manual''Bcd::IsGreaterEqual'"
.EH "'Bcd::IsGreaterEqual''CoLibri Reference Manual'"
.bp
.NX 4 "IsGreaterEqual"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE IsGreaterEqual $($ IN left_operand $ : BCD,
$$ IN right_operand $ : BCD )
$:$ BOOL;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOIsGreaterEqual\fP tests whether \f(HOleft_operand\fP is
greater than or equal to \f(HOright_operand\fP.
.IP "RETURN VALUE"
This procedure returns TRUE, if \f(HOleft_operand\fP is greater than or equal
to \f(HOright_operand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR bcd1   : Bcd::BCD;
VAR bcd2   : Bcd::BCD;
VAR result : BOOL;
\&...
bcd1   := Conversions::StringToBcd ("5.0");
bcd2   := Conversions::StringToBcd ("2.0");
result := Bcd::IsGreaterEqual (bcd1, bcd2);
.CE
.KE
The result has the value TRUE.
.IP "SEE ALSO"
\f(HOIsGreater\fP,
\f(HOIsLess\fP,
\f(HOIsLessEqual\fP,
.LP
.OH "'CoLibri Reference Manual''Bcd::IsInteger'"
.EH "'Bcd::IsInteger''CoLibri Reference Manual'"
.bp
.NX 4 "IsInteger"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
\f(HBPROCEDURE IsInteger ( IN value : BCD ) : BOOL;\fP
.IP DESCRIPTION
The procedure \f(HOIsInteger\fP tests whether \f(HOvalue\fP is a whole
number.
.IP "RETURN VALUE"
This procedure returns TRUE, if \f(HOvalue\fP is a whole number.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR bcd    : Bcd::BCD;
VAR result : BOOL;
\&...
bcd    := Conversions::StringToBcd ("5.0");
result := Bcd::IsInteger (bcd);
.CE
.KE
Then result has the valueTRUE.
.IP "SEE ALSO"
\f(HOIsNegative\fP
.LP
.OH "'CoLibri Reference Manual''Bcd::IsLess'"
.EH "'Bcd::IsLess''CoLibri Reference Manual'"
.bp
.NX 4 "IsLess"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE IsLess $($ IN left_operand $ : BCD,
$$ IN right_operand $ : BCD )
$:$ BOOL;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOIsLess\fP tests whether \f(HOleft_operand\fP is less than
\f(HOright_operand\fP.
.IP "RETURN VALUE"
This procedure returns TRUE, if \f(HOleft_operand\fP is less than
\f(HOright_operand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR bcd1   : Bcd::BCD;
VAR bcd2   : Bcd::BCD;
VAR result : BOOL;
\&...
bcd1   := Conversions::StringToBcd ("5.0");
bcd2   := Conversions::StringToBcd ("2.0");
result := Bcd::IsLess (bcd1, bcd2);
.CE
.KE
The result has the value FALSE.
.IP "SEE ALSO"
\f(HOIsGreater\fP,
\f(HOIsGreaterEqual\fP,
\f(HOIsLessEqual\fP,
.LP
.OH "'CoLibri Reference Manual''Bcd::IsLessEqual'"
.EH "'Bcd::IsLessEqual''CoLibri Reference Manual'"
.bp
.NX 4 "IsLessEqual"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE IsLessEqual $($ IN left_operand $ : BCD,
$$ IN right_operand $ : BCD )
$:$ BOOL;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOIsLessEqual\fP test whether \f(HOleft_operand\fP is less
than or equal to \f(HOright_operand\fP.
.IP "RETURN VALUE"
This procedure returns TRUE, if \f(HOleft_operand\fP is less than or equal to
\f(HOright_operand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR bcd1   : Bcd::BCD;
VAR bcd2   : Bcd::BCD;
VAR result : BOOL;
\&...
bcd1   := Conversions::StringToBcd ("5.0");
bcd2   := Conversions::StringToBcd ("2.0");
result := Bcd::IsLessEqual (bcd1, bcd2);
.CE
.KE
Then result has the value FALSE.
.IP "SEE ALSO"
\f(HOIsGreater\fP,
\f(HOIsGreaterEqual\fP,
\f(HOIsLess\fP
.LP
.OH "'CoLibri Reference Manual''Bcd::IsNegative'"
.EH "'Bcd::IsNegative''CoLibri Reference Manual'"
.bp
.NX 4 "IsNegative"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
\f(HBPROCEDURE IsNegative ( IN value : BCD ) : BOOL;\fP
.IP DESCRIPTION
The procedure \f(HOIsNegative\fP tests whether \f(HOvalue\fP is less than
zero.
.IP "RETURN VALUE"
This procedure returns TRUE, if \f(HOvalue\fP is less than zero.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR bcd    : Bcd::BCD;
VAR result : BOOL;
\&...
bcd    := Conversions::StringToBcd ("5.0");
result := Bcd::IsNegative (bcd);
.CE
.KE
Then result has the value FALSE.
.IP "SEE ALSO"
\f(HOIsInteger\fP
.LP
.OH "'CoLibri Reference Manual''Bcd::IsNotEqual'"
.EH "'Bcd::IsNotEqual''CoLibri Reference Manual'"
.bp
.NX 4 "IsNotEqual"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE IsNotEqual $($ IN left_operand $ : BCD,
$$ IN right_operand $ : BCD )
$:$ BOOL;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOIsNotEqual\fP tests whether \f(HOleft_operand\fP is not
equal to \f(HOright_operand\fP.
.IP "RETURN VALUE"
This procedure returns TRUE, if \f(HOleft_operand\fP is not equal to
\f(HOright_operand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR bcd1   : Bcd::BCD;
VAR bcd2   : Bcd::BCD;
VAR result : BOOL;
\&...
bcd1   := Conversions::StringToBcd ("5.0");
bcd2   := Conversions::StringToBcd ("2.0");
result := Bcd::IsNotEqual (bcd1, bcd2);
.CE
.KE
Then result has the value TRUE.
.IP "SEE ALSO"
\f(HOIsEqual\fP
.LP
.OH "'CoLibri Reference Manual''Bcd::Mod'"
.EH "'Bcd::Mod''CoLibri Reference Manual'"
.bp
.NX 4 "Mod"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE Mod $($ IN dividend $ : BCD,
$$ IN divisor $ : BCD )
$:$ BCD;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOMod\fP divides \f(HOdividend\fP by \f(HOdivisor\fP.
Both operands must be whole numbers.
.IP "RETURN VALUE"
This procedure returns the remainder of the whole number division of
\f(HOdividend\fP by \f(HOdivisor\fP.
The number of positions of the result is less than or equal to the number
of positions of \f(HOdividend\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOZeroDivision\fP"
is raised, if \f(HOdivisor\fP is equal zero.
.IP EXAMPLES
.CS L
VAR bcd1   : Bcd::BCD;
VAR bcd2   : Bcd::BCD;
VAR result : Bcd::BCD;
\&...
bcd1   := Conversions::StringToBcd ("5");
bcd2   := Conversions::StringToBcd ("2");
result := Bcd::Mod (bcd1, bcd2);
.CE
.KE
Then result has the value 1.0.
.IP "SEE ALSO"
\f(HODiv\fP
.LP
.OH "'CoLibri Reference Manual''Bcd::Mul'"
.EH "'Bcd::Mul''CoLibri Reference Manual'"
.bp
.NX 4 "Mul"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE Mul $($ IN left_operand $ : BCD,
$$ IN right_operand $ : BCD )
$:$ BCD;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOMul\fP multiplies \f(HOleft_operand\fP by
\f(HOright_operand\fP.
.IP "RETURN VALUE"
This procedure returns the product of \f(HOleft_operand\fP and
\f(HOright_operand\fP.
The position number of the lowest significant digit of the result value is the
product of the position numbers of \f(HOleft_operand\fP and
\f(HOright_operand\fP.
If the result value contains more digits than positions are available, digits
are truncated.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOResultIsOutOfRange\fP"
is raised, if the result of the computation is less then {min} or 
greater than {max}.
.IP EXAMPLES
.CS L
VAR bcd1   : Bcd::BCD;
VAR bcd2   : Bcd::BCD;
VAR result : Bcd::BCD;
\&...
bcd1   := Conversions::StringToBcd ("1.7");
bcd2   := Conversions::StringToBcd ("-0.7");
result := Bcd::Mul (bcd1, bcd2);
.CE
.KE
.IP "SEE ALSO"
\f(HODiv\fP,
\f(HOMod\fP
.LP
.OH "'CoLibri Reference Manual''Bcd::Negate'"
.EH "'Bcd::Negate''CoLibri Reference Manual'"
.bp
.NX 4 "Negate"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
\f(HBPROCEDURE Negate ( IN value : BCD ) : BCD;\fP
.IP DESCRIPTION
The procedure \f(HONegate\fP inverts the sign of \f(HOvalue\fP.
.IP "RETURN VALUE"
This procedure returns \f(HO-value\fP, if \f(HOvalue\fP is greater than zero
and \f(HOvalue\fP, if \f(HOvalue\fP is less than zero.
Otherwise it returns zero.
.KS
.IP EXAMPLES
.CS L
VAR bcd    : Bcd::BCD;
VAR result : Bcd::BCD;
\&...
bcd    := Conversions::StringToBcd ("5.0");
result := Bcd::Negate (bcd);
.CE
.KE
Then result has the value -5.0.
.IP "SEE ALSO"
\f(HOAbs\fP
.LP
.OH "'CoLibri Reference Manual''Bcd::Round'"
.EH "'Bcd::Round''CoLibri Reference Manual'"
.bp
.NX 4 "Round"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE Round $($ IN value $ : BCD,
$$ IN position $ : INT )
$:$ BCD;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HORound\fP rounds \f(HOvalue\fP (in a commercial
manner).
The last significant position of the result value is specified by
\f(HOposition\fP.
.IP "RETURN VALUE"
This procedure returns the result of the following expressions:
.RS
.IP \(bu 2
trunc (\f(HOvalue\fP + 0.5 \(** 1 E-(\f(HOposition\fP), if \f(HOvalue\fP
is greater than zero
.IP \(bu 2
trunc (\f(HOvalue\fP - 0.5 \(** 1 E-(\f(HOposition\fP), if \f(HOvalue\fP
is less than zero
.IP \(bu 2
zero, if \f(HOvalue\fP is zero.
.RE
.IP EXAMPLES
.CS L
VAR bcd1 : Bcd::BCD;
VAR bcd2 : Bcd::BCD;
\&...
bcd1 := Conversions::StringToBcd ("-5.4351");
bcd2 := Bcd::Round (bcd1, -2);
.CE
.KE
Then bcd2 has the value -5.44.
.KS
.CS L
bcd1 := Conversions::StringToBcd ("12345");
bcd2 := Bcd::Round (bcd1, 2);
.CE
.KE
Then bcd2 has the value 12300.
.KS
.CS L
bcd1 := Conversions::StringToBcd ("12345.67");
bcd2 := Bcd::Round (bcd1, 0);
.CE
.KE
Then bcd2 has the value 12346.
.IP "SEE ALSO"
\f(HOTrunc\fP
.LP
.OH "'CoLibri Reference Manual''Bcd::Sub'"
.EH "'Bcd::Sub''CoLibri Reference Manual'"
.bp
.NX 4 "Sub"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE Sub $($ IN left_operand $ : BCD,
$$ IN right_operand $ : BCD )
$:$ BCD;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOSub\fP subtracts \f(HOright_operand\fP from
\f(HOleft_operand\fP.
.IP "RETURN VALUE"
This procedure returns the difference of \f(HOleft_operand\fP and
\f(HOright_operand\fP.
The position number of the lowest significant digit of the result value is the
maximum of the position numbers of \f(HOleft_operand\fP and
\f(HOright_operand\fP.
If the result value contains more digits than positions are available, digits
are truncated.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOResultIsOutOfRange\fP"
is raised, if the result of the computation is less then {min} or 
greater than {max}.
.IP EXAMPLES
.CS L
VAR bcd1   : Bcd::BCD;
VAR bcd2   : Bcd::BCD;
VAR result : Bcd::BCD;
\&...
bcd1   := Conversions::StringToBcd ("1.7");
bcd2   := Conversions::StringToBcd ("-0.7");
result := Bcd::Sub (bcd1, bcd2);
.CE
.KE
.IP "SEE ALSO"
\f(HOAdd\fP
.LP
.OH "'CoLibri Reference Manual''Bcd::Trunc'"
.EH "'Bcd::Trunc''CoLibri Reference Manual'"
.bp
.NX 4 "Trunc"
.sp
.IP MODULE
\f(HBBcd\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE Trunc $($ IN value $ : BCD,
$$ IN position $ : INT )
$:$ BCD;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOTrunc\fP truncates the digits of \f(HOvalue\fP after
\f(HOposition\fP.
The positions of a \f(HOBCD\fP value are: ...3210.-1-2-3...
.IP "RETURN VALUE"
This procedure returns \f(HOvalue\fP.
All digits after \f(HOposition\fP are replaced by zero.
.KS
.IP EXAMPLES
.CS L
VAR bcd1 : Bcd::BCD;
VAR bcd2 : Bcd::BCD;
\&...
bcd1 := Conversions::StringToBcd ("-54321.4321");
bcd2 := Bcd::Trunc (bcd1, 1);
.CE
.KE
Then bcd2 has the value -54320.0.
.IP "SEE ALSO"
\f(HORound\fP
.LP
.OH "'CoLibri Reference Manual''Bcd'"
.EH "'Bcd''CoLibri Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOBcd\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
Abs$IN$value$BCD$
$result$$BCD$
_
Add$IN$left_operand$BCD$ResultIsOutOfRange
$IN$right_operand$BCD$
$result$$BCD$
_
Div$IN$dividend$BCD$ResultIsOutOfRange
$IN$divisor$BCD$ZeroDivision
$result$$BCD$
_
GetExponent$IN$value$BCD$
$result$$INT$
_
GetFractionalPart$IN$value$BCD$
$result$$BCD$
_
GetIntegralPart$IN$value$BCD$
$result$$BCD$
_
IsEqual$IN$left_operand$BCD$
$IN$right_operand$BCD$
$result$$BOOL$
_
IsGreater$IN$left_operand$BCD$
$IN$right_operand$BCD$
$result$$BOOL$
_
IsGreaterEqual$IN$left_operand$BCD$
$IN$right_operand$BCD$
$result$$BOOL$
_
IsInteger$IN$value$BCD$
$result$$BOOL$
_
IsLess$IN$left_operand$BCD$
$IN$right_operand$BCD$
$result$$BOOL$
_
IsLessEqual$IN$left_operand$BCD$
$IN$right_operand$BCD$
$result$$BOOL$
_
IsNegative$IN$value$BCD$
$result$$BOOL$
.TE
.NL
.nr PS 12
.KE
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
IsNotEqual$IN$left_operand$BCD$
$IN$right_operand$BCD$
$result$$BOOL$
_
Mod$IN$dividend$BCD$ZeroDivision
$IN$divisor$BCD$
$result$$BCD$
_
Mul$IN$left_operand$BCD$ResultIsOutOfRange
$IN$right_operand$BCD$
$result$$BCD$
_
Negate$IN$value$BCD$
$result$$BCD$
_
Round$IN$value$BCD$
$IN$position$INT$
$result$$BCD$
_
Sub$IN$left_operand$BCD$ResultIsOutOfRange
$IN$right_operand$BCD$
$result$$BCD$
_
Trunc$IN$value$BCD$
$IN$position$INT$
$result$$BCD$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'CoLibri Reference Manual''Object Types'"
.EH "'Object Types''CoLibri Reference Manual'"
.NX 1 "Object Types"
.sp
This chapter describes the object types provided by CoLibri.
.sp
.OH "'CoLibri Reference Manual''Date'"
.EH "'Date''CoLibri Reference Manual'"
.bp
.NX 2 "Date"
.NX 3 "Type Description"
.sp
\f(HODate\fP is an object type representing a calendar entry consisting of
year, month and day.
This object type offers methods to construct, modify and actualize an object
and to get information about an object.
Further methods deal with arithmetic operations and predicates.
.sp
.NX 3 "List of Methods"
.sp
The following methods are available in <Date.cs>:
.TS
tab($);
l.
Method name
_
Add
Copy
Distance
GetDay
GetDayOfWeek
GetDayOfYear
GetMonth
GetWeekOfYear
GetYear
IsActual
IsEarlier
IsEqual
IsInFuture
IsLater
IsPassed
SetDate
SetToActualDate
Subtract
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each method described below the exceptions which will be raised in case
of an error are listed.
.sp
The following exceptions can be raised using module \f(HODate\fP :
.TS
tab($);
l.
exception name
_
InvalidDate
NegativeDuration
.TE
.sp
.NX 3 "How to use Date"
.sp
A variable of type \f(HODate\fP is declared as follows:
.CS L
VAR date : Date;
.CE
.sp 0.5
A variable of type \f(HODate\fP can be initialized using the CooL constructor
NEW.
.sp
A sub type of type \f(HODate\fP is declared as follows:
.CS L
TYPE MyDate = Date OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL module which uses the type \f(HODate\fP must import the module
\f(HODate\fP:
.CS L
IMPORT ..., Date, ...;
.CE
.sp 0.5
.NX 3 "Method Description"
.sp
The following sections contain the syntactical and semantical description of
all methods provided by \f(HODate\fP.
They are listed in alphabetical order.
.sp
.OH "'CoLibri Reference Manual''Date::INITIALLY'"
.EH "'Date::INITIALLY''CoLibri Reference Manual'"
.bp
.NX 4 "INITIALLY"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBINITIALLY $($ IN year $ : INT,
$$ IN month $ : INT,
$$ IN day $ : INT )
$:$ Date;$\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW.
The parameters \f(HOyear\fP, \f(HOmonth\fP and \f(HOday\fP specify the date
of the current object.
.IP "RETURN VALUE"
This method returns a new object of this type containing \f(HOyear\fP,
\f(HOmonth\fP and \f(HOday\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidDate\fP"
is raised, if \f(HOyear\fP, \f(HOmonth\fP and \f(HOday\fP do not 
represent a valid date.
.KS
.IP EXAMPLES
.CS L
VAR year  : INT;
VAR month : INT;
VAR day   : INT;
VAR date  : Date::Date;
\&...
year  := 1992;
month := 1;
day   := 1;
date  := NEW Date::Date (year, month, day);
.CE
.KE
Then date contains the date 01.01.1992.
.IP "SEE ALSO"
\f(HOSetDate\fP,
\f(HOSetToActualDate\fP
.LP
.OH "'CoLibri Reference Manual''Date::Add'"
.EH "'Date::Add''CoLibri Reference Manual'"
.bp
.NX 4 "Add"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD Add ( IN extent : Duration );\fP
.IP DESCRIPTION
The method \f(HOAdd\fP adds the days of \f(HOextent\fP to the current date.
.KS
.IP EXAMPLES
.CS L
VAR date     : Date::Date;
VAR duration : Duration::Duration;
\&...
date     := NEW Date::Date (1992, 1, 1);
duration := NEW Duration::Duration (10, 0, 0, 0);
date.Add (duration);
.CE
.KE
Then date contains the date 11.01.1992.
.IP "SEE ALSO"
\f(HODuration\fP,
\f(HOINITIALLY\fP,
\f(HOSubtract\fP
.LP
.OH "'CoLibri Reference Manual''Date::Copy'"
.EH "'Date::Copy''CoLibri Reference Manual'"
.bp
.NX 4 "Copy"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD Copy () : Date;\fP
.IP DESCRIPTION
The method \f(HOCopy\fP creates a new object of this type containing the
state of the current object.
.IP "RETURN VALUE"
This method returns a new object of this type containing the state of the
current object.
.KS
.IP EXAMPLES
.CS L
VAR date      : Date::Date;
VAR next_date : Date::Date;
\&...
date      := NEW Date::Date (1992, 1, 1);
next_date := date.Copy ();
.CE
.KE
Then next_date contains the date 01.01.1992.
.IP "SEE ALSO"
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''Date::Distance'"
.EH "'Date::Distance''CoLibri Reference Manual'"
.bp
.NX 4 "Distance"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD Distance ( IN end_date : Date ) : Duration;\fP
.IP DESCRIPTION
The method \f(HODistance\fP returns the difference between the current
date and \f(HOend_date\fP.
.IP "RETURN VALUE"
This method returns the difference between the current date and
\f(HOend_date\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeDuration\fP"
is raised, if the current date is later than \f(HOend_date\fP.
.KS
.IP EXAMPLES
.CS L
VAR date     : Date::Date;
VAR end_date : Date::Date;
VAR distance : Duration::Duration;
\&...
date     := NEW Date::Date (1992, 1, 1);
end_date := NEW Date::Date (1992, 2, 1);
distance := date.Distance (end_date);
.CE
.KE
Then distance contains 31 days, 0 hours, 0 minutes and 0 seconds.
.IP "SEE ALSO"
\f(HODuration\fP,
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''Date::GetDay'"
.EH "'Date::GetDay''CoLibri Reference Manual'"
.bp
.NX 4 "GetDay"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD GetDay () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetDay\fP returns the day of the current date.
.IP "RETURN VALUE"
This method returns the day of the current date.
.KS
.IP EXAMPLES
.CS L
VAR date : Date::Date;
VAR day  : INT;
\&...
date := NEW Date::Date (1992, 1, 1);
day  := date.GetDay ();
.CE
.KE
Then day has the value 1.
.IP "SEE ALSO"
\f(HOGetMonth\fP,
\f(HOGetYear\fP,
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''Date::GetDayOfWeek'"
.EH "'Date::GetDayOfWeek''CoLibri Reference Manual'"
.bp
.NX 4 "GetDayOfWeek"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD GetDayOfWeek () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetDayOfWeek\fP returns the number of day of the week of
the current date.
.IP "RETURN VALUE"
This method returns the number of the day of the week of the current date.
The number is in the range 0..6 (0=sunday, 1=monday, ...).
.KS
.IP EXAMPLES
.CS L
VAR date     : Date::Date;
VAR week_day : INT;
\&...
date     := NEW Date::Date (1992, 1, 1);
week_day := date.GetDayOfWeek ();
.CE
.KE
Then week_day has the value 3.
.IP "SEE ALSO"
\f(HOGetDayOfYear\fP,
\f(HOGetWeekOfYear\fP,
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''Date::GetDayOfYear'"
.EH "'Date::GetDayOfYear''CoLibri Reference Manual'"
.bp
.NX 4 "GetDayOfYear"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD GetDayOfYear () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetDayOfYear\fP returns the number of the day of the year of
the current date.
.IP "RETURN VALUE"
This method returns the number of the day of the year of the current date.
The number is in the range 1..366.
.KS
.IP EXAMPLES
.CS L
VAR date     : Date::Date;
VAR year_day : INT;
\&...
date     := NEW Date::Date (1992, 1, 1);
year_day := date.GetDayOfYear ();
.CE
.KE
Then year_day has the value 1.
.IP "SEE ALSO"
\f(HOGetDayOfWeek\fP,
\f(HOGetWeekOfYear\fP,
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''Date::GetMonth'"
.EH "'Date::GetMonth''CoLibri Reference Manual'"
.bp
.NX 4 "GetMonth"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD GetMonth () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetMonth\fP returns the month of the current date.
.IP "RETURN VALUE"
This method returns the month of the current date.
.KS
.IP EXAMPLES
.CS L
VAR date  : Date::Date;
VAR month : INT;
\&...
date  := NEW Date::Date (1992, 1, 1);
month := date.GetMonth ();
.CE
.KE
Then month has the value 1.
.IP "SEE ALSO"
\f(HOGetDay\fP,
\f(HOGetYear\fP,
\f(HOINITIALLY
.LP
.OH "'CoLibri Reference Manual''Date::GetWeekOfYear'"
.EH "'Date::GetWeekOfYear''CoLibri Reference Manual'"
.bp
.NX 4 "GetWeekOfYear"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD GetWeekOfYear () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetWeekOfYear\fP returns the number of the week of the year
of the current date.
.IP "RETURN VALUE"
This method returns the number of the week of the year of the current date.
The number is in the range 1..53.
.KS
.IP EXAMPLES
.CS L
VAR date : Date::Date;
VAR week : INT;
\&...
date := NEW Date::Date (1992, 1, 1);
week := date.GetWeekOfYear ();
.CE
.KE
Then week has the value 1.
.IP "SEE ALSO"
\f(HOGetDayOfWeeK\fP,
\f(HOGetDayOfYear\fP,
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''Date::GetYear'"
.EH "'Date::GetYear''CoLibri Reference Manual'"
.bp
.NX 4 "GetYear"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD GetYear () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetYear\fP returns the year of the current date.
.IP "RETURN VALUE"
This method returns the year of the current date.
.KS
.IP EXAMPLES
.CS L
VAR date : Date::Date;
VAR year : INT;
\&...
date := NEW Date::Date (1992, 1, 1);
year := date.GetYear ();
.CE
.KE
Then year has the value 1992.
.IP "SEE ALSO"
\f(HOGetDay\fP,
\f(HOGetMonth\fP,
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''Date::IsActual'"
.EH "'Date::IsActual''CoLibri Reference Manual'"
.bp
.NX 4 "IsActual"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD IsActual () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsActual\fP tests whether the current date is the actual date.
.IP "RETURN VALUE"
This method returns TRUE, if the current date is the actual date.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR date      : Date::Date;
VAR is_actual : BOOL;
\&...
date      := NEW Date::Date (1992, 1, 1);
is_actual := date.IsActual ();
.CE
.KE
Then is_actual has the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibri Reference Manual''Date::IsEarlier'"
.EH "'Date::IsEarlier''CoLibri Reference Manual'"
.bp
.NX 4 "IsEarlier"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD IsEarlier ( IN operand : Date ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEarlier\fP tests the whether the current date is earlier
than \f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the current date is earlier than \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR date       : Date::Date;
VAR other_date : Date::Date;
VAR is_earlier : BOOL;
\&...
date       := NEW Date::Date (1992, 1, 1);
other_date := NEW Date::Date (1992, 2, 1);
is_earlier := date.IsEarlier (other_date);
.CE
.KE
Then is_earlier has the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibri Reference Manual''Date::IsEqual'"
.EH "'Date::IsEqual''CoLibri Reference Manual'"
.bp
.NX 4 "IsEqual"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD IsEqual ( IN operand : Date ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEqual\fP tests whether the current date is equal to
\f(HOoperand\fP.
Two dates are equal, if their single components are equal.
.IP "RETURN VALUE"
This method returns TRUE, if the current date is equal to \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR date       : Date::Date;
VAR other_date : Date::Date;
VAR is_equal   : BOOL;
\&...
date       := NEW Date::Date (1992, 1, 1);
other_date := NEW Date::Date (1992, 2, 1);
is_equal   := date.IsEqual (other_date);
.CE
.KE
Then is_equal has the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibri Reference Manual''Date::IsInFuture'"
.EH "'Date::IsInFuture''CoLibri Reference Manual'"
.bp
.NX 4 "IsInFuture"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD IsInFuture () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsInFuture\fP tests whether the current date is in future.
.IP "RETURN VALUE"
This method returns TRUE, if the current date is in future.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR date         : Date::Date;
VAR is_in_future : BOOL;
\&...
date         := NEW Date::Date (1992, 1, 1);
is_in_future := date.IsInFuture ();
.CE
.KE
Then is_in_future has the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibri Reference Manual''Date::IsLater'"
.EH "'Date::IsLater''CoLibri Reference Manual'"
.bp
.NX 4 "IsLater"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD IsLater ( IN operand : Date ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsLater\fP tests whether the current date is later than
\f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the current date is later than \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR date       : Date::Date;
VAR other_date : Date::Date;
VAR is_later   : BOOL;
\&...
date       := NEW Date::Date (1992, 1, 1);
other_date := NEW Date::Date (1992, 2, 1);
is_later   := date.IsLater (other_date);
.CE
.KE
Then is_later has the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibri Reference Manual''Date::IsPassed'"
.EH "'Date::IsPassed''CoLibri Reference Manual'"
.bp
.NX 4 "IsPassed"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD IsPassed () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsPassed\fP tests whether the current date is passed.
.IP "RETURN VALUE"
This method returns TRUE, if the current date is passed.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR date      : Date::Date;
VAR is_passed : BOOL;
\&...
date      := NEW Date::Date (1992, 1, 1);
is_passed := date.IsPassed ();
.CE
.KE
Then is_passed has the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP\fP
.LP
.OH "'CoLibri Reference Manual''Date::SetDate'"
.EH "'Date::SetDate''CoLibri Reference Manual'"
.bp
.NX 4 "SetDate"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBMETHOD SetDate ($ IN year $ : INT,
$ IN month $ : INT,
$ IN day $ : INT );\fP
.TE
.IP DESCRIPTION
The method \f(HOSetDate\fP assigns the values of the parameters \f(HOyear\fP,
\f(HOmonth\fP and \f(HOday\fP to the current date.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidDate\fP"
is raised, if \f(HOyear\fP, \f(HOmonth\fP and \f(HOday\fP do not 
represent a valid date.
.KS
.IP EXAMPLES
.CS L
VAR date : Date::Date;
\&...
date := NEW Date::Date (1992, 1, 1);
date.SetDate (1992, 13, 1);
.CE
.KE
Then the exception \f(HOInvalidDate\fP is raised.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOSetToActualDate\fP
.LP
.OH "'CoLibri Reference Manual''Date::SetToActualDate'"
.EH "'Date::SetToActualDate''CoLibri Reference Manual'"
.bp
.NX 4 "SetToActualDate"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD SetToActualDate;\fP
.IP DESCRIPTION
The method \f(HOSetToActualDate\fP assigns the actual date (machine date) to
the current object.
.KS
.IP EXAMPLES
.CS L
VAR date : Date::Date;
\&...
date := NEW Date::Date (1992, 1, 1);
date.SetToActualDate ();
.CE
.KE
Then date contains the actual date (machine date).
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOSetDate\fP
.LP
.OH "'CoLibri Reference Manual''Date::Subtract'"
.EH "'Date::Subtract''CoLibri Reference Manual'"
.bp
.NX 4 "Subtract"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD Subtract ( IN extent : Duration );\fP
.IP DESCRIPTION
The method \f(HOSubtract\fP subtracts the days of \f(HOextent\fP from the
current date.
.KS
.IP EXAMPLES
.CS L
VAR date     : Date::Date;
VAR duration : Duration::Duration;
\&...
date     := NEW Date::Date (1900, 1, 21);
duration := NEW Duration::Duration (10, 0, 0, 0);
date.Subtract (duration);
.CE
.KE
Then date contains the date 11.01.1900.
.IP "SEE ALSO"
\f(HOAdd\fP,
\f(HODuration\fP,
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''Date'"
.EH "'Date''CoLibri Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HODate\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
INITIALLY$IN$year$INT$InvalidDate
$IN$month$INT$
$IN$day$INT$
$result$$Date$
_
Add$IN$extent$Duration$$
_
Copy$result$$Date$
_
Distance$IN$end_date$Date$NegativeDuration
$result$$Duration$
_
GetDay$result$$INT$
_
GetDayOfWeek$result$$INT$
_
GetDayOfYear$result$$INT$
_
GetMonth$result$$INT$
_
GetWeekOfYear$result$$INT$
_
GetYear$result$$INT$
_
IsActual$result$$BOOL$
_
IsEarlier$IN$operand$Date$
$result$$BOOL$
_
IsEqual$IN$operand$Date$
$result$$BOOL$
_
IsInFuture$result$$BOOL$
_
IsLater$IN$operand$Date$
$result$$BOOL$
_
IsPassed$result$$BOOL$
_
SetDate$IN$year$INT$InvalidDate
$IN$month$INT$
$IN$day$INT$
_
SetToActualDate$$$$
_
Subtract$IN$extent$Duration$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''DateRepr'"
.EH "'DateRepr''CoLibri Reference Manual'"
.bp
.NX 2 "DateRepr"
.sp
.NX 3 "Type Description"
.sp
\f(HODateRepr\fP is a sub type of object type \f(HODate\fP representing
a calendar entry consisting of year, month and day together with a format
string containing the presentation description according to the C library
function \f(HOstrftime()\fP.
In addition to the methods offered by \f(HODate\fP, this object type offers
methods to construct an object together with a presentation description, to
change the presentation and to get information about the presentation.
.sp
.NX 3 "List of Methods"
.sp
The following methods are available in <DateRepr.cs>:
.TS
tab($);
l l.
Method name$R(edefined)/N(ew)
_
Add
Copy$R
Distance
GetDay
GetDayOfWeek
GetDayOfYear
GetFormat$N
GetMonth
GetWeekOfYear
GetYear
IsActual
IsEarlier
IsEqual
IsInFuture
IsLater
IsPassed
Present$N
SetDate
SetFormat$N
SetToActualDate
Subtract
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each method described below the exceptions which will be raised in case
of an error are listed.
.sp
.KS
The following exceptions can be raised using module \f(HODateRepr\fP :
.TS
tab($);
l.
exception name
_
Date::InvalidDate
Date::NegativeDuration
.TE
.KE
.sp
.NX 3 "How to use DateRepr"
.sp
A variable of type \f(HODateRepr\fP is declared as follows:
.CS L
VAR date_repr : DateRepr;
.CE
.sp 0.5
A variable of type \f(HODateRepr\fP can be initialized using the CooL
constructor NEW.
.sp
A sub type of type \f(HODateRepr\fP is declared as follows:
.CS L
TYPE MyDateRepr = DateRepr OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL module which uses the type \f(HODateRepr\fP must import the module
\f(HODateRepr\fP:
.CS L
IMPORT ..., DateRepr, ...;
.CE
.sp 0.5
.NX 3 "Method Description"
.sp
The following sections contain the syntactical and semantical description of
all (redefined and new) methods provided by \f(HODateRepr\fP.
They are listed in alphabetical order.
.SP
.OH "'CoLibri Reference Manual''DateRepr::INITIALLY'"
.EH "'DateRepr::INITIALLY''CoLibri Reference Manual'"
.bp
.NX 4 "INITIALLY"
.sp
.IP MODULE
\f(HBDateRepr\fP
.IP TYPE
\f(HBDateRepr = Date\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBINITIALLY $($IN year $ : INT,
$$IN month $ : INT,
$$IN day $ : INT,
$$IN format $ : STRING )
$:$ DateRepr;$\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW.
The parameters \f(HOyear\fP, \f(HOmonth\fP and \f(HOday\fP specify the date
of the current object.
The parameter \f(HOformat\fP specifies the presentation of the current object
according to the C library function \f(HOstrftime()\fP.
.IP "RETURN VALUE"
This method returns a new object of this type containing \f(HOyear\fP,
\f(HOmonth\fP, \f(HOday\fP and \f(HOformat\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidDate\fP"
is raised, if \f(HOyear\fP, \f(HOmonth\fP, and \f(HOday\fP do not 
represent a valid date.
.KS
.IP EXAMPLES
.CS L
VAR year      : INT;
VAR month     : INT;
VAR day       : INT;
VAR format    : STRING;
VAR date_repr : DateRepr::DateRepr;
\&...
year      := 1992;
month     := 1;
day       := 1;
format    := "%d/%m/%Y";
date_repr := NEW DateRepr::DateRepr (year, month, day, format);
.CE
.KE
Then date_repr contains the date 01.01.1992 and the format string "%d/%m/%Y".
.IP "SEE ALSO"
\f(HODate::SetDate\fP,
\f(HODate::SetToActualDate\fP,
\f(HOSetFormat\fP,
\f(HOstrftime()\fP
.LP
.OH "'CoLibri Reference Manual''DateRepr::Copy'"
.EH "'DateRepr::Copy''CoLibri Reference Manual'"
.bp
.NX 4 "Copy"
.sp
.IP MODULE
\f(HBDateRepr\fP
.IP TYPE
\f(HBDateRepr = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Copy () : Date;\fP
.IP DESCRIPTION
The method \f(HOCopy\fP creates a new object of this type containing the
state of the current object.
.IP "RETURN VALUE"
This method returns a new object of this type containing the state of the
current object.
.KS
.IP EXAMPLES
.CS L
VAR date_repr      : DateRepr::DateRepr;
VAR next_date_repr : DateRepr::DateRepr;
\&...
date_repr := NEW DateRepr::DateRepr (1992, 1, 1, "%d/%m/%Y");
TYPESELECT select_date_repr := date_repr.Copy () OF
   CASE DateRepr::DateRepr :
      next_date_repr := select_date_repr;
\&...
END TYPESELECT;
.CE
.KE
Then next_date_repr contains the date 01.01.1992 and the format string
"%d/%m/%Y".
.IP "SEE ALSO"
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''DateRepr::GetFormat'"
.EH "'DateRepr::GetFormat''CoLibri Reference Manual'"
.bp
.NX 4 "GetFormat"
.sp
.IP MODULE
\f(HBDateRepr\fP
.IP TYPE
\f(HBDateRepr = Date\fP
.IP SYNOPSIS
\f(HBMETHOD GetFormat () : STRING;\fP
.IP DESCRIPTION
The method \f(HOGetFormat\fP returns the presentation format string of the
current date.
.IP "RETURN VALUE"
This method returns the presentation format string of the current date.
.KS
.IP EXAMPLES
.CS L
VAR date_repr : DateRepr::DateRepr;
VAR string    : STRING;
\&...
date_repr := NEW DateRepr::DateRepr (1992, 1, 1, "%d/%m/%Y");
string    := date_repr.GetFormat ();
.CE
.KE
Then string has the value "%d/%m/%Y".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODate::GetDay\fP,
\f(HODate::GetMonth\fP,
\f(HODate::GetYear\fP,
\f(HOSetFormat\fP
.LP
.OH "'CoLibri Reference Manual''DateRepr::Present'"
.EH "'DateRepr::Present''CoLibri Reference Manual'"
.bp
.NX 4 "Present"
.sp
.IP MODULE
\f(HBDateRepr\fP
.IP TYPE
\f(HBDateRepr = Date\fP
.IP SYNOPSIS
\f(HBMETHOD Present () : STRING;
.IP DESCRIPTION
The method \f(HOPresent\fP returns a string which contains the presentation of
the current date using the presentation format string.
.IP "RETURN VALUE"
This method returns a string which contains the presentation of the current
date using the presentation format string.
.KS
.IP EXAMPLES
.CS L
VAR date_repr : DateRepr::DateRepr;
VAR string    : STRING;
\&...
date_repr := NEW DateRepr::DateRepr (1992, 1, 1, "%d/%m/%Y");
string    := date_repr.Present ();
.CE
.KE
Then string has the value "01/01/1900".
.IP "SEE ALSO"
\f(HOGetFormat\fP,
\f(HOINITIALLY\fP,
\f(HOSetFormat\fP
.LP
.OH "'CoLibri Reference Manual''DateRepr::SetFormat'"
.EH "'DateRepr::SetFormat''CoLibri Reference Manual'"
.bp
.NX 4 "SetFormat"
.sp
.IP MODULE
\f(HBDateRepr\fP
.IP TYPE
\f(HBDateRepr = Date\fP
.IP SYNOPSIS
\f(HBMETHOD SetFormat ( IN format : STRING );\fP
.IP DESCRIPTION
The method \f(HOSetFormat\fP assigns the value of the parameter \f(HOformat\fP
to the current date.
.KS
.IP EXAMPLES
.CS L
VAR date_repr  : DateRepr::DateRepr;
VAR new_format : STRING;
\&...
date_repr  := NEW DateRepr::DateRepr (1992, 1, 1, "%d.%m.%Y");
new_format := "%y.%m.%d";
date_repr.SetFormat (new_format);
.CE
.KE
Then date_repr contains the date 01.01.1992 and the format string "%y.%m.%d",
i.e. the formatted date will be 92.01.01.
.IP "SEE ALSO"
\f(HODate::SetDate\fP,
\f(HODate::SetToActualDate\fP,
\f(HOGetFormat\fP,
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''DateRepr'"
.EH "'DateRepr''CoLibri Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HODateRepr\fP.
.br
The column R/N shows whether the method is
.IP \(bu 3
redefined (R),
.IP \(bu 3
a new method (N),
.IP \(bu 3
an inherited method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
$INITIALLY$IN$year$INT$InvalidDate
$$IN$month$INT$
$$IN$day$INT$
$$result$$DateRepr$
_
$Add$IN$extent$Duration$$
_
R$Copy$result$$Date$
_
$Distance$IN$end_date$Date$NegativeDuration
$$result$$Duration$
_
$GetDay$result$$INT$
_
$GetDayOfWeek$result$$INT$
_
$GetDayOfYear$result$$INT$
_
N$GetFormat$result$$STRING$
_
$GetMonth$result$$INT$
_
$GetWeekOfYear$result$$INT$
_
$GetYear$result$$INT$
_
$IsActual$result$$BOOL$
_
$IsEarlier$IN$operand$Date$
$$result$$BOOL$
_
$IsEqual$IN$operand$Date$
$$result$$BOOL$
_
$IsInFuture$result$$BOOL$
_
$IsLater$IN$operand$Date$
$$result$$BOOL$
_
$IsPassed$result$$BOOL$
_
N$Present$result$$STRING$
.TE
.NL
.nr PS 12
.KE
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
$SetDate$IN$year$INT$InvalidDate
$$IN$month$INT$
$$IN$day$INT$
_
N$SetFormat$IN$format$STRING$
_
$SetToActualDate$$$$
_
$Subtract$IN$extent$Duration$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''Time'"
.EH "'Time''CoLibri Reference Manual'"
.bp
.NX 2 "Time"
.sp
.NX 3 "Type Description"
.sp
\f(HOTime\fP is an object type representing a time value consisting of hours,
minutes and seconds.
This object type offers methods to construct, modify and actualize an object
and to get information about an object.
Further methods deal with arithmetic operations and predicates.
.sp
.NX 3 "List of Methods"
.sp
The following methods are available in <Time.cs>:
.TS
tab($);
l.
Method name
_
Add
Copy
Distance
GetHours
GetMinutes
GetSeconds
IsActual
IsEarlier
IsEqual
IsInFuture
IsLater
IsPassed
SetTime
SetToActualTime
Subtract
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each method described below the exceptions which will be raised in case
of an error are listed.
.sp
The following exceptions can be raised using module \f(HOTime\fP :
.TS
tab($);
l.
exception name
_
InvalidTime
Duration::NegativeDuration
.TE
.sp
.NX 3 "How to use Time"
.sp
A variable of type \f(HOTime\fP is declared as follows:
.CS L
VAR time : Time;
.CE
.sp 0.5
A variable of type \f(HOTime\fP can be initialized using the CooL constructor
NEW.
.sp
A sub type of type \f(HOTime\fP is declared as follows:
.CS L
TYPE MyTime = Time OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL module which uses the type \f(HOTime\fP must import the module
\f(HOTime\fP:
.CS L
IMPORT ..., Time, ...;
.CE
.sp 0.5
.NX 3 "Method Description"
.sp
The following sections contain the syntactical and semantical description of
all methods provided by \f(HOTime\fP.
They are listed in alphabetical order.
.sp
.OH "'CoLibri Reference Manual''Time::INITIALLY'"
.EH "'Time::INITIALLY''CoLibri Reference Manual'"
.bp
.NX 4 "INITIALLY"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBINITIALLY $($ IN hours $ : INT,
$$ IN minutes $ : INT,
$$ IN seconds $ : INT )
$:$ Time;$\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW.
The parameters \f(HOhours\fP, \f(HOminutes\fP and \f(HOseconds\fP specify
the time of the current object.
.IP "RETURN VALUE"
This method returns a new object of this type containing \f(HOhours\fP,
\f(HOminutes\fP and \f(HOseconds\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidTime\fP"
is raised, if \f(HOhours\fP, \f(HOminutes\fP and \f(HOseconds\fP do not
represent a valid time.
.KS
.IP EXAMPLES
.CS L
VAR hours   : INT;
VAR minutes : INT;
VAR seconds : INT;
VAR time    : Time::Time;
\&...
hours   := 18;
minutes := 40;
seconds := 0;
time    := NEW Time::Time (hours, minutes, seconds);
.CE
.KE
Then time contains the time 18:40:00.
.IP "SEE ALSO"
\f(HOSetTime\fP,
\f(HOSetToActualTime\fP
.LP
.OH "'CoLibri Reference Manual''Time::Add'"
.EH "'Time::Add''CoLibri Reference Manual'"
.bp
.NX 4 "Add"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
\f(HBMETHOD Add ( IN extent : Duration );\fP
.IP DESCRIPTION
The method \f(HOAdd\fP adds \f(HOextent\fP to the current time.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidTime\fP"
is raised, if the calculated hours, minutes or seconds do not represent
a valid time.
.KS
.IP EXAMPLES
.CS L
VAR time     : Time::Time;
VAR duration : Duration::Duration;
\&...
time     := NEW Time::Time (18, 40, 0);
duration := NEW Duration::Duration (10, 2, 3, 17);
time.Add (duration);
.CE
.KE
Then time contains the time 20:43:17.
.IP "SEE ALSO"
\f(HODuration\fP,
\f(HOINITIALLY\fP,
\f(HOSubtract\fP
.LP
.OH "'CoLibri Reference Manual''Time::Copy'"
.EH "'Time::Copy''CoLibri Reference Manual'"
.bp
.NX 4 "Copy"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
\f(HBMETHOD Copy () : Time;\fP
.IP DESCRIPTION
The method \f(HOCopy\fP creates a new object of this type containing the
state of the current object.
.IP "RETURN VALUE"
This method returns a new object of this type containing the state of the
current object.
.KS
.IP EXAMPLES
.CS L
VAR time      : Time::Time;
VAR next_time : Time::Time;
\&...
time      := NEW Time::Time (18, 40, 0);
next_time := time.Copy ();
.CE
.KE
Then next_time contains the time 18:40:00.
.IP "SEE ALSO"
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''Time::Distance'"
.EH "'Time::Distance''CoLibri Reference Manual'"
.bp
.NX 4 "Distance"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
\f(HBMETHOD Distance ( IN end_time : Time ) : Duration;\fP
.IP DESCRIPTION
The method \f(HODistance\fP returns the difference between the current time
 and \f(HOend_time\fP.
.IP "RETURN VALUE"
This method returns the difference between the current time and
\f(HOend_time\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeDuration\fP"
is raised, if the current time is later than \f(HOend_time\fP.
.KS
.IP EXAMPLES
.CS L
VAR time   : Time::Time;
VAR end_time  : Time::Time;
VAR distance : Duration::Duration;
\&...
time   := NEW Time::Time (18, 40, 0);
end_time  := NEW Time::Time (19, 2, 0);
distance := time.Distance (end_time);
.CE
.KE
Then distance contains 0 days, 0 hours, 22 minutes and 0 seconds.
.IP "SEE ALSO"
\f(HODuration\fP,
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''Time::GetHours'"
.EH "'Time::GetHours''CoLibri Reference Manual'"
.bp
.NX 4 "GetHours"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
\f(HBMETHOD GetHours () : INT;
.IP DESCRIPTION
The method \f(HOGetHours\fP returns the hours of the current time.
.IP "RETURN VALUE"
This method returns the hours of the current time.
.KS
.IP EXAMPLES
.CS L
VAR time  : Time::Time;
VAR hours : INT;
\&...
time  := NEW Time::Time (18, 40, 0);
hours := time.GetHours ();
.CE
.KE
Then hours has the value 18.
.IP "SEE ALSO"
\f(HOGetMinutes\fP,
\f(HOGetSeconds\fP,
\f(HOINITIALLY\fP,
\f(HOSetTime\fP
.LP
.OH "'CoLibri Reference Manual''Time::GetMinutes'"
.EH "'Time::GetMinutes''CoLibri Reference Manual'"
.bp
.NX 4 "GetMinutes"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
\f(HBMETHOD GetMinutes () : INT;
.IP DESCRIPTION
The method \f(HOGetMinutes\fP returns the minutes of the current time.
.IP "RETURN VALUE"
This method returns the minutes of the current time.
.KS
.IP EXAMPLES
.CS L
VAR time    : Time::Time;
VAR minutes : INT;
\&...
time    := NEW Time::Time (18, 40, 0);
minutes := time.GetMinutes ();
.CE
.KE
Then minutes has the value 40.
.IP "SEE ALSO"
\f(HOGetHours\fP,
\f(HOGetSeconds\fP,
\f(HOINITIALLY\fP,
\f(HOSetTime\fP
.LP
.OH "'CoLibri Reference Manual''Time::GetSeconds'"
.EH "'Time::GetSeconds''CoLibri Reference Manual'"
.bp
.NX 4 "GetSeconds"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
\f(HBMETHOD GetSeconds () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetSeconds\fP returns the seconds of the current time.
.IP "RETURN VALUE"
This method returns the seconds of the current time.
.KS
.IP EXAMPLES
.CS L
VAR time    : Time::Time;
VAR seconds : INT;
\&...
time    := NEW Time::Time (18, 40, 0);
seconds := time.GetSeconds ();
.CE
.KE
Then seconds has the value 0.
.IP "SEE ALSO"
\f(HOGetHours\fP,
\f(HOGetMinutes\fP,
\f(HOINITIALLY\fP,
\f(HOSetTime\fP
.LP
.OH "'CoLibri Reference Manual''Time::IsActual'"
.EH "'Time::IsActual''CoLibri Reference Manual'"
.bp
.NX 4 "IsActual"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
\f(HBMETHOD IsActual () : BOOL;
.IP DESCRIPTION
The method \f(HOIsActual\fP tests whether the current time is the actual time.
.IP "RETURN VALUE"
This method returns TRUE, if the current time is the actual time.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR time      : Time::Time;
VAR is_actual : BOOL;
\&...
time      := NEW Time::Time (18, 40, 0);
is_actual := time.IsActual ();
.CE
.KE
Then is_actual has the value FALSE (this method was called at 17:45).
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP,
\f(HOSetToActualTime\fP
.LP
.OH "'CoLibri Reference Manual''Time::IsEarlier'"
.EH "'Time::IsEarlier''CoLibri Reference Manual'"
.bp
.NX 4 "IsEarlier"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
\f(HBMETHOD IsEarlier ( IN operand : Time ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEarlier\fP tests the whether the current time is earlier
than \f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the current time is earlier than \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR time       : Time::Time;
VAR other_time : Time::Time;
VAR is_earlier : BOOL;
\&...
time       := NEW Time::Time (18, 40, 0);
other_time := NEW Time::Time (19, 2, 1);
is_earlier := time.IsEarlier (other_time);
.CE
.KE
Then is_earlier has the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibri Reference Manual''Time::IsEqual'"
.EH "'Time::IsEqual''CoLibri Reference Manual'"
.bp
.NX 4 "IsEqual"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
\f(HBMETHOD IsEqual ( IN operand : Time ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEqual\fP tests whether the current time is equal to
\f(HOoperand\fP.
Two times are equal, if their single components are equal.
.IP "RETURN VALUE"
This method returns TRUE, if the current time is equal to \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR time       : Time::Time;
VAR other_time : Time::Time;
VAR is_equal   : BOOL;
\&...
time       := NEW Time::Time (18, 40, 0);
other_time := NEW Time::Time (19, 2, 1);
is_equal   := time.IsEqual (other_time);
.CE
.KE
Then is_equal has the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibri Reference Manual''Time::IsInFuture'"
.EH "'Time::IsInFuture''CoLibri Reference Manual'"
.bp
.NX 4 "IsInFuture"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
\f(HBMETHOD IsInFuture () : BOOL;
.IP DESCRIPTION
The method \f(HOIsInFuture\fP tests whether the current time is in future.
.IP "RETURN VALUE"
This method returns TRUE, if the current time is in future.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR time      : Time::Time;
VAR is_future : BOOL;
\&...
time      := NEW Time::Time (18, 40, 0);
is_future := time.IsInFuture ();
.CE
.KE
Then is_future has the value TRUE (this method was called at 17:45).
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibri Reference Manual''Time::IsLater'"
.EH "'Time::IsLater''CoLibri Reference Manual'"
.bp
.NX 4 "IsLater"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
\f(HBMETHOD IsLater ( IN operand : Time ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsLater\fP tests whether the current time is later than
\f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the current time is later than \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR time       : Time::Time;
VAR other_time : Time::Time;
VAR is_later   : BOOL;
\&...
time       := NEW Time::Time (18, 40, 0);
other_time := NEW Time::Time (19, 2, 1);
is_later   := time.IsLater (other_time);
.CE
.KE
Then is_later has the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibri Reference Manual''Time::IsPassed'"
.EH "'Time::IsPassed''CoLibri Reference Manual'"
.bp
.NX 4 "IsPassed"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
\f(HBMETHOD IsPassed () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsPassed\fP tests whether the current time is passed.
.IP "RETURN VALUE"
This method returns TRUE, if the current time is passed.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR time      : Time::Time;
VAR is_passed : BOOL;
\&...
time      := NEW Time::Time (18, 40, 0);
is_passed := time.IsPassed ();
.CE
.KE
Then is_passed has the value FALSE (this method was called at 17:45).
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP\fP
.LP
.OH "'CoLibri Reference Manual''Time::SetTime'"
.EH "'Time::SetTime''CoLibri Reference Manual'"
.bp
.NX 4 "SetTime"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBMETHOD SetTime ($ IN hours $ : INT,
$ IN minutes $ : INT,
$ IN seconds $ : INT );\fP
.TE
.IP DESCRIPTION
The method \f(HOSetTime\fP assigns the values of the parameters \f(HOhours\fP,
\f(HOminutes\fP and \f(HOseconds\fP to the current object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidTime\fP"
is raised, if \f(HOhours\fP, \f(HOminutes\fP and \f(HOseconds\fP do not
represent a valid time.
.KS
.IP EXAMPLES
.CS L
VAR time : Time::Time;
\&...
time := NEW Time::Time (18, 40, 0);
time.SetTime (24, 13, 1);
.CE
.KE
Then the exception \f(HOInvalidTime\fP is raised.
.IP "SEE ALSO"
\f(HOGetHours\fP,
\f(HOGetMinutes\fP,
\f(HOGetSeconds\fP,
\f(HOINITIALLY\fP,
\f(HOSetToActualTime\fP
.LP
.OH "'CoLibri Reference Manual''Time::SetToActualTime'"
.EH "'Time::SetToActualTime''CoLibri Reference Manual'"
.bp
.NX 4 "SetToActualTime"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
\f(HBMETHOD SetToActualTime;\fP
.IP DESCRIPTION
The method \f(HOSetToActualTime\fP assigns the actual time (machine time) to
the current object.
.KS
.IP EXAMPLES
.CS L
VAR time : Time::Time;
\&...
time := NEW Time::Time (18, 40, 0);
time.SetToActualTime ();
.CE
.KE
Then time contains the actual time (machine time).
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOSetTime\fP
.LP
.OH "'CoLibri Reference Manual''Time::Subtract'"
.EH "'Time::Subtract''CoLibri Reference Manual'"
.bp
.NX 4 "Subtract"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
\f(HBMETHOD Subtract ( IN extent : Duration );\fP
.IP DESCRIPTION
The method \f(HOSubtract\fP subtracts \f(HOextent\fP from the current time.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidTime\fP"
is raised, if the calculated hours, minutes or seconds are out of range.
.KS
.IP EXAMPLES
.CS L
VAR time     : Time::Time;
VAR duration : Duration::Duration;
\&...
time     := NEW Time::Time (18, 40, 0);
duration := NEW Duration::Duration (10, 4, 30, 0);
time.Subtract (duration);
.CE
.KE
Then time contains the time 14:10:00.
.IP "SEE ALSO"
\f(HOAdd\fP,
\f(HODuration\fP,
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''Time'"
.EH "'Time''CoLibri Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HOTime\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
INITIALLY$IN$hours$INT$InvalidTime
$IN$minutes$INT$
$IN$seconds$INT$
$result$$Time$
_
Add$IN$extent$Duration$InvalidTime
_
Copy$result$$Time$
_
Distance$IN$end_time$Time$NegativeDuration
$result$$Duration$
_
GetHours$result$$INT$
_
GetMinutes$result$$INT$
_
GetSeconds$result$$INT$
_
IsActual$result$$BOOL$
_
IsEarlier$IN$operand$Time$
$result$$BOOL$
_
IsEqual$IN$operand$Time$
$result$$BOOL$
_
IsInFuture$result$$BOOL$
_
IsLater$IN$operand$Time$
$result$$BOOL$
_
IsPassed$result$$BOOL$
_
SetTime$IN$hours$INT$InvalidTime
$IN$minutes$INT$
$IN$seconds$INT$
_
SetToActualTime$$$$
_
Subtract$IN$extent$Duration$InvalidTime
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''TimeRepr'"
.EH "'TimeRepr''CoLibri Reference Manual'"
.bp
.NX 2 "TimeRepr"
.sp
.NX 3 "Type Description"
.sp
\f(HOTimeRepr\fP is a sub type of object type \f(HOTime\fP representing
a non-negative time value consisting of hours, minutes and seconds together
with a format string containing the presentation description according to the
C library function \f(HOstrftime()\fP.
In addition to the methods offered by \f(HOTime\fP, this object type offers
methods to construct an object together with a presentation description, to
change the presentation and to get information about the presentation.
.sp
.NX 3 "List of Methods"
.sp
The following methods are available in <TimeRepr.cs>:
.TS
tab($);
l l.
Method name$R(edefined)/N(ew)
_
Add
Copy$R
Distance
GetFormat$N
GetHours
GetMinutes
GetSeconds
IsActual
IsEarlier
IsEqual
IsInFuture
IsLater
IsPassed
Present$N
SetFormat$N
SetTime
SetToActualTime
Subtract
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each method described below the exceptions which will be raised in case
of an error are listed.
.sp
.KS
The following exceptions can be raised using module \f(HOTimeRepr\fP :
.TS
tab($);
l.
exception name
_
Time::InvalidTime
Duration::NegativeDuration
.TE
.KE
.sp
.NX 3 "How to use TimeRepr"
.sp
A variable of type \f(HOTimeRepr\fP is declared as follows:
.CS L
VAR time_repr : TimeRepr;
.CE
.sp 0.5
A variable of type \f(HOTimeRepr\fP can be initialized using the CooL
constructor NEW.
.sp
A sub type of type \f(HOTimeRepr\fP is declared as follows:
.CS L
TYPE MyTimeRepr = TimeRepr OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL module which uses the type \f(HOTimeRepr\fP must import the module
\f(HOTimeRepr\fP:
.CS L
IMPORT ..., TimeRepr, ...;
.CE
.sp 0.5
.NX 3 "Method Description"
.sp
The following sections contain the syntactical and semantical description of
all (redefined and new) methods provided by \f(HOTimeRepr\fP.
They are listed in alphabetical order.
.sp
.OH "'CoLibri Reference Manual''TimeRepr::INITIALLY'"
.EH "'TimeRepr::INITIALLY''CoLibri Reference Manual'"
.bp
.NX 4 "INITIALLY"
.sp
.IP MODULE
\f(HBTimeRepr\fP
.IP TYPE
\f(HBTimeRepr = Time\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBINITIALLY $($ IN hours $ : INT,
$$ IN minutes $ : INT,
$$ IN seconds $ : INT,
$$ IN format  $ : STRING )
$:$ TimeRepr;$\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW.
The parameters \f(HOhours\fP, \f(HOminutes\fP and \f(HOseconds\fP specify the
time of the current object.
The parameter \f(HOformat\fP specifies the presentation of the current object
according to the C library function \f(HOstrftime()\fP.
.IP "RETURN VALUE"
This method returns a new object of this type containing \f(HOhours\fP,
\f(HOminutes\fP, \f(HOseconds\fP and \f(HOformat\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidTime\fP"
is raised, if \f(HOhours\fP, \f(HOminutes\fP and \f(HOseconds\fP do not
represent a valid time.
.KS
.IP EXAMPLES
.CS L
VAR hours     : INT;
VAR minutes   : INT;
VAR seconds   : INT;
VAR format    : STRING;
VAR time_repr : TimeRepr::TimeRepr;
\&...
hours     := 18;
minutes   := 40;
seconds   := 0;
format    := "%H/%M/%S";
time_repr := NEW TimeRepr::TimeRepr (hours, minutes, seconds, format);
.CE
.KE
Then time_repr contains the time 18:40:00 and the format string "%H/%M/%S".
.IP "SEE ALSO"
\f(HOSetFormat\fP,
\f(HOstrftime()\fP,
\f(HOTime::SetTime\fP,
\f(HOTime::SetToActualTime\fP
.LP
.OH "'CoLibri Reference Manual''TimeRepr::Copy'"
.EH "'TimeRepr::Copy''CoLibri Reference Manual'"
.bp
.NX 4 "Copy"
.sp
.IP MODULE
\f(HBTimeRepr\fP
.IP TYPE
\f(HBTimeRepr = Time\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Copy () : Time;\fP
.IP DESCRIPTION
The method \f(HOCopy\fP creates a new object of this type containing the
state of the current object.
.IP "RETURN VALUE"
This method returns a new object of this type containing the state of the
current object.
.KS
.IP EXAMPLES
.CS L
VAR time_repr      : TimeRepr::TimeRepr;
VAR next_time_repr : TimeRepr::TimeRepr;
\&...
time_repr      := NEW TimeRepr::TimeRepr (18, 40, 0, "%H/%M/%S");
TYPESELECT select_time_repr := time_repr.Copy () OF
   CASE TimeRepr::TimeRepr : 
      next_time_repr := select_time_repr;
\&...
END TYPESELECT;
.CE
.KE
Then next_time_repr contains the time 18:40:00 and the format string "%H/%M/%S".
.IP "SEE ALSO"
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''TimeRepr::GetFormat'"
.EH "'TimeRepr::GetFormat''CoLibri Reference Manual'"
.bp
.NX 4 "GetFormat"
.sp
.IP MODULE
\f(HBTimeRepr\fP
.IP TYPE
\f(HBTimeRepr = Time\fP
.IP SYNOPSIS
\f(HBMETHOD GetFormat () : STRING;\fP
.IP DESCRIPTION
The method \f(HOGetFormat\fP returns the presentation format string of the
current time.
.IP "RETURN VALUE"
This method returns the presentation format string of the current time.
.KS
.IP EXAMPLES
.CS L
VAR time_repr : TimeRepr::TimeRepr;
VAR string    : STRING;
\&...
time_repr := NEW TimeRepr::TimeRepr (18, 40, 0, "%H/%M/%S");
string    := time_repr.GetFormat ();
.CE
.KE
Then string has the value "%H/%M/%S".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOSetFormat\fP,
\f(HOTime::GetHours\fP,
\f(HOTime::GetMinutes\fP,
\f(HOTime::GetSeconds\fP
.LP
.OH "'CoLibri Reference Manual''TimeRepr::Present'"
.EH "'TimeRepr::Present''CoLibri Reference Manual'"
.bp
.NX 4 "Present"
.sp
.IP MODULE
\f(HBTimeRepr\fP
.IP TYPE
\f(HBTimeRepr = Time\fP
.IP SYNOPSIS
\f(HBMETHOD Present () : STRING;\fP
.IP DESCRIPTION
The method \f(HOPresent\fP returns a string which contains the presentation of
the current time using the presentation format string.
.IP "RETURN VALUE"
This method returns a string which contains the presentation of the current
time using the presentation format string.
.KS
.IP EXAMPLES
.CS L
VAR time_repr : TimeRepr::TimeRepr;
VAR string    : STRING;
\&...
time_repr := NEW TimeRepr::TimeRepr (18, 40, 0, "%H/%M/%S");
string    := time_repr.Present ();
.CE
.KE
Then string has the value "18/40/00".
.IP "SEE ALSO"
\f(HOGetFormat\fP,
\f(HOINITIALLY\fP,
\f(HOSetFormat\fP
.LP
.OH "'CoLibri Reference Manual''TimeRepr::SetFormat'"
.EH "'TimeRepr::SetFormat''CoLibri Reference Manual'"
.bp
.NX 4 "SetFormat"
.sp
.IP MODULE
\f(HBTimeRepr\fP
.IP TYPE
\f(HBTimeRepr = Time\fP
.IP SYNOPSIS
\f(HBMETHOD SetFormat ( IN format : STRING );\fP
.IP DESCRIPTION
The method \f(HOSetFormat\fP assigns the value of the parameter \f(HOformat\fP
to the current time.
.KS
.IP EXAMPLES
.CS L
VAR time_repr  : TimeRepr::TimeRepr;
VAR new_format : STRING;
\&...
time_repr  := NEW TimeRepr::TimeRepr (18, 40, 0, "%H/%M/%S");
new_format := "%H.%M.%S";
time_repr.SetFormat (new_format);
.CE
.KE
Then time_repr contains the time 18:40:00 and the format string "%H.%M.%S".
.IP "SEE ALSO"
\f(HOGetFormat\fP,
\f(HOINITIALLY\fP,
\f(HOTime::SetTime\fP,
\f(HOTime::SetToActualTime\fP
.LP
.OH "'CoLibri Reference Manual''TimeRepr'"
.EH "'TimeRepr''CoLibri Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HOTimeRepr\fP.
.br
The column R/N shows whether the method is
.IP \(bu 3
redefined (R),
.IP \(bu 3
a new method (N),
.IP \(bu 3
an inherited method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
$INITIALLY$IN$hours$INT$InvalidTime
$$IN$minutes$INT$
$$IN$seconds$INT$
$$IN$format$STRING$
$$result$$TimeRepr$
_
$Add$IN$extent$Duration$InvalidTime
_
R$Copy$result$$Time$
_
$Distance$IN$end_time$Time$NegativeDuration
$$result$$Duration$
_
N$GetFormat$result$$STRING$
_
$GetHours$result$$INT$
_
$GetMinutes$result$$INT$
_
$GetSeconds$result$$INT$
_
$IsActual$result$$BOOL$
_
$IsEarlier$IN$operand$Time$
$$result$$BOOL$
_
$IsEqual$IN$operand$Time$
$$result$$BOOL$
_
$IsInFuture$result$$BOOL$
_
$IsLater$IN$operand$Time$
$$result$$BOOL$
_
$IsPassed$result$$BOOL$
_
N$Present$result$$STRING$
_
N$SetFormat$IN$format$STRING$
_
$SetTime$IN$hours$INT$InvalidTime
$$IN$minutes$INT$
$$IN$seconds$INT$
_
$SetToActualTime$$$$
_
$Subtract$IN$extent$Duration$InvalidTime
.TE
.NL
.nr PS 12
.KE
.OH "'CoLibri Reference Manual''TimeStamp'"
.EH "'TimeStamp''CoLibri Reference Manual'"
.LP
.bp
.NX 2 "TimeStamp"
.sp
.NX 3 "Type Description"
.sp
\f(HOTimeStamp\fP is a sub type of object type \f(HODate\fP representing
a calendar entry consisting of year, month and day together with a time value
consisting of hours, minutes and seconds.
In addition to the methods offered by \f(HODate\fP, this object type offers
methods to construct an object together with a time value, to change the time
and to get information about the time.
.sp
.NX 3 "List of Methods"
.sp
The following methods are available in <TimeSt.cs>:
.TS
tab($);
l l.
Method name$R(edefined)/N(ew)
_
Add$R
Copy$R
Distance$R
GetDay
GetDayOfWeek
GetDayOfYear
GetMonth
GetTime$N
GetWeekOfYear
GetYear
IsActual$R
IsEarlier$R
IsEqual$R
IsInFuture$R
IsLater$R
IsPassed$R
SetDate
SetTime$N
SetToActualDate$R
Subtract$R
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each method described below the exceptions which will be raised in case
of an error are listed.
.KS
.sp
The following exceptions can be raised using module \f(HOTimeStamp\fP :
.TS
tab($);
l.
exception name
_
Date::InvalidDate
Time::InvalidTime
Date::NegativeDuration
.TE
.KE
.sp
.NX 3 "How to use TimeStamp"
.sp
A variable of type \f(HOTimeStamp\fP is declared as follows:
.CS L
VAR time_stamp : TimeSt::TimeStamp;
.CE
.sp 0.5
A variable of type \f(HOTimeStamp\fP can be initialized using the CooL
constructor NEW.
.sp
A sub type of type \f(HOTimeStamp\fP is declared as follows:
.CS L
TYPE MyTimeStamp = TimeStamp OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL module which uses the type \f(HOTimeStamp\fP must import the module
\f(HOTimeSt\fP:
.CS L
IMPORT ..., TimeSt, ...;
.CE
.sp 0.5
.NX 3 "Method Description"
.sp
The following sections contain the syntactical and semantical description of
all (redefined and new) methods provided by \f(HOTimeStamp\fP.
They are listed in alphabetical order.
.sp
.OH "'CoLibri Reference Manual''TimeStamp::INITIALLY'"
.EH "'TimeStamp::INITIALLY''CoLibri Reference Manual'"
.bp
.NX 4 "INITIALLY"
.sp
.IP MODULE
\f(HBTimeSt\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBINITIALLY $($ IN year $ : INT,
$$ IN month $ : INT,
$$ IN day $ : INT,
$$ IN stamp $ : Time )
$:$ TimeStamp;$\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW.
The parameters \f(HOyear\fP, \f(HOmonth\fP and \f(HOday\fP specify the date
of the current object.
The parameter \f(HOstamp\fP specifies the time of the current object.
.IP "RETURN VALUE"
This method returns a new object of this type containing \f(HOyear\fP,
\f(HOmonth\fP, \f(HOday\fP and \f(HOstamp\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOInvalidDate\fP"
is raised, if \f(HOyear\fP, \f(HOmonth\fP and \f(HOday\fP do not 
represent a valid date.
.IP "\(bu \f(HOInvalidTime\fP"
 is raised, if \f(HOstamp\fP do not represent a valid time.
.KS
.IP EXAMPLES
.CS L
VAR year       : INT;           VAR hour       : INT;
VAR month      : INT;           VAR minute     : INT;
VAR day        : INT;           VAR second     : INT;
VAR time       : Time::Time;
VAR time_stamp : TimeSt::TimeStamp;
\&...
year       := 1992;
month      := 1;
day        := 1;
hour       := 18;
minute     := 40;
second     := 0;
time       := NEW Time::Time (hour, minute, second);
time_stamp := NEW TimeSt::TimeStamp (year, month, day, time);
.CE
.KE
Then time_stamp contains the date 01.01.1992 and the time 18:40:00.
.IP "SEE ALSO"
\f(HODate::SetDate\fP,
\f(HOSetTime\fP,
\f(HOSetToActualDate\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''TimeStamp::Add'"
.EH "'TimeStamp::Add''CoLibri Reference Manual'"
.bp
.NX 4 "Add"
.sp
.IP MODULE
\f(HBTimeSt\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Add ( IN extent : Duration );\fP
.IP DESCRIPTION
The method \f(HOAdd\fP adds \f(HOextent\fP to the current time stamp.
.KS
.IP EXAMPLES
.CS L
VAR time       : Time::Time;
VAR time_stamp : TimeSt::TimeStamp;
VAR duration   : Duration::Duration;
\&...
time       := NEW Time::Time (18, 40, 00);
time_stamp := NEW TimeSt::TimeStamp (1992, 1, 1, time);
duration   := NEW Duration::Duration (10, 2, 30, 15);
time_stamp.Add (duration);
.CE
.KE
Then time_stamp contains the date 11.01.1992 and the time 21:10:15.
.IP "SEE ALSO"
\f(HODuration\fP,
\f(HOINITIALLY\fP,
\f(HOSubtract\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''TimeStamp::Copy'"
.EH "'TimeStamp::Copy''CoLibri Reference Manual'"
.bp
.NX 4 "Copy"
.sp
.IP MODULE
\f(HBTimeSt\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Copy () : Date;\fP
.IP DESCRIPTION
The method \f(HOCopy\fP creates a new object of this type containing the
state of the current object.
.IP "RETURN VALUE"
This method returns a new object of this type containing the state of the
current object.
.KS
.IP EXAMPLES
.CS L
VAR time            : Time::Time;
VAR time_stamp      : TimeSt::TimeStamp;
VAR next_time_stamp : TimeSt::TimeStamp;
\&...
time            := NEW Time::Time (18, 40, 00);
time_stamp      := NEW TimeSt::TimeStamp (1992, 1, 1, time);
TYPESELECT select_time_stamp := time_stamp.Copy () OF
   CASE TimeSt::TimeStamp :
      next_time_stamp := select_time_stamp;
\&...
END TYPESELECT;
.CE
.KE
Then next_time_stamp contains the date 01.01.1992 and the time 18:40:00.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''TimeStamp::Distance'"
.EH "'TimeStamp::Distance''CoLibri Reference Manual'"
.bp
.NX 4 "Distance"
.sp
.IP MODULE
\f(HBTimeSt\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Distance ( IN end_date : Date ) : Duration;\fP
.IP DESCRIPTION
The method \f(HODistance\fP returns the difference between the current time
stamp and \f(HOend_date\fP.
.IP "RETURN VALUE"
This method returns the difference between the current time stamp and
\f(HOend_date\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeDuration\fP"
is raised, if the current time stamp is later than \f(HOend_date\fP.
.KS
.IP EXAMPLES
.CS L
VAR time           : Time::Time;
VAR time_stamp     : TimeSt::TimeStamp;
VAR end_time       : Time::Time;
VAR end_time_stamp : TimeSt::TimeStamp;
VAR distance       : Duration::Duration;
\&...
time           := NEW Time::Time (18, 40, 00);
time_stamp     := NEW TimeSt::TimeStamp (1992, 1, 1, time);
end_time       := NEW Time::Time (20, 50, 05);
end_time_stamp := NEW TimeSt::TimeStamp (1992, 1, 2, end_time);
distance       := time_stamp.Distance (end_time_stamp);
.CE
.KE
Then distance contains 1 day, 2 hours, 10 minutes and 5 seconds.
.IP "SEE ALSO"
\f(HODuration\fP,
\f(HOINITIALLY\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''TimeStamp::GetTime'"
.EH "'TimeStamp::GetTime''CoLibri Reference Manual'"
.bp
.NX 4 "GetTime"
.sp
.IP MODULE
\f(HBTimeSt\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBMETHOD GetTime () : Time;\fP
.IP DESCRIPTION
The method \f(HOGetDay\fP returns the time of the current time stamp.
.IP "RETURN VALUE"
This method returns the time of the current time stamp.
.KS
.IP EXAMPLES
.CS L
VAR time       : Time::Time;
VAR time_stamp : TimeSt::TimeStamp;
VAR is_time    : Time::Time;
\&...
time       := NEW Time::Time (18, 40, 00);
time_stamp := NEW TimeSt::TimeStamp (1992, 1, 1, time);
is_time    := time_stamp.GetTime ();
.CE
.KE
Then is_time contains the time 18:40:00.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODate::GetDay\fP,
\f(HODate::GetMonth\fP,
\f(HODate::GetYear\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''TimeStamp::IsActual'"
.EH "'TimeStamp::IsActual''CoLibri Reference Manual'"
.bp
.NX 4 "IsActual"
.sp
.IP MODULE
\f(HBTimeSt\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD IsActual () : BOOL;
.IP DESCRIPTION
The method \f(HOIsActual\fP tests whether the current time stamp is the actual
time stamp.
.IP "RETURN VALUE"
This method returns TRUE, if the current time stamp is the actual time stamp.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR time       : Time::Time;
VAR time_stamp : TimeSt::TimeStamp;
VAR is_actual  : BOOL;
\&...
time       := NEW Time::Time (18, 40, 00);
time_stamp := NEW TimeSt::TimeStamp (1992, 1, 1, time);
is_actual  := time_stamp.IsActual ();
.CE
.KE
Then is_actual has the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''TimeStamp::IsEarlier'"
.EH "'TimeStamp::IsEarlier''CoLibri Reference Manual'"
.bp
.NX 4 "IsEarlier"
.sp
.IP MODULE
\f(HBTimeSt\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD IsEarlier ( IN operand : Date ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEarlier\fP tests the whether the current time stamp is
earlier than \f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the current time stamp is earlier than
\f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR time             : Time::Time;
VAR time_stamp       : TimeSt::TimeStamp;
VAR other_time       : Time::Time;
VAR other_time_stamp : TimeSt::TimeStamp;
VAR is_earlier       : BOOL;
\&...
time             := NEW Time::Time (18, 40, 00);
time_stamp       := NEW TimeSt::TimeStamp (1992, 1, 1, time);
other_time       := NEW Time::Time (17, 20, 00);
other_time_stamp := NEW TimeSt::TimeStamp (1992, 2, 1, other_time);
is_earlier       := time_stamp.IsEarlier (other_time_stamp);
.CE
.KE
Then is_earlier has the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''TimeStamp::IsEqual'"
.EH "'TimeStamp::IsEqual''CoLibri Reference Manual'"
.bp
.NX 4 "IsEqual"
.sp
.IP MODULE
\f(HBTimeSt\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD IsEqual ( IN operand : Date ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEqual\fP tests whether the current time stamp is equal to
\f(HOoperand\fP.
Two time stamps are equal, if their single components are equal.
.IP "RETURN VALUE"
This method returns TRUE, if the current time stamp is equal to
\f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR time             : Time::Time;
VAR time_stamp       : TimeSt::TimeStamp;
VAR other_time       : Time::Time;
VAR other_time_stamp : TimeSt::TimeStamp;
VAR is_equal         : BOOL;
\&...
time             := NEW Time::Time (18, 40, 00);
time_stamp       := NEW TimeSt::TimeStamp (1992, 1, 1, time);
other_time       := NEW Time::Time (17, 20, 00);
other_time_stamp := NEW TimeSt::TimeStamp (1992, 2, 1, other_time);
is_equal         := time_stamp.IsEqual (other_time_stamp);
.CE
.KE
Then is_equal has the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''TimeStamp::IsInFuture'"
.EH "'TimeStamp::IsInFuture''CoLibri Reference Manual'"
.bp
.NX 4 "IsInFuture"
.sp
.IP MODULE
\f(HBTimeSt\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD IsInFuture () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsInFuture\fP tests whether the current time stamp is in
future.
.IP "RETURN VALUE"
This method returns TRUE, if the current time stamp is in future.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR time       : Time::Time;
VAR time_stamp : TimeSt::TimeStamp;
VAR is_future  : BOOL;
\&...
time       := NEW Time::Time (18, 40, 00);
time_stamp := NEW TimeSt::TimeStamp (1992, 1, 1, time);
is_future  := time_stamp.IsInFuture ();
.CE
.KE
Then is_future has the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''TimeStamp::IsLater'"
.EH "'TimeStamp::IsLater''CoLibri Reference Manual'"
.bp
.NX 4 "IsLater"
.sp
.IP MODULE
\f(HBTimeSt\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD IsLater ( IN operand : Date ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsLater\fP tests whether the current time stamp is later than
\f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the current time stamp is later than
\f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR time             : Time::Time;
VAR time_stamp       : TimeSt::TimeStamp;
VAR other_time       : Time::Time;
VAR other_time_stamp : TimeSt::TimeStamp;
VAR is_later         : BOOL;
\&...
time             := NEW Time::Time (18, 40, 00);
time_stamp       := NEW TimeSt::TimeStamp (1992, 1, 1, time);
other_time       := NEW Time::Time (17, 20, 00);
other_time_stamp := NEW TimeSt::TimeStamp (1992, 2, 1, other_time);
is_later         := time_stamp.IsLater (other_time_stamp);
.CE
.KE
Then is_later has the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsPassed\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''TimeStamp::IsPassed'"
.EH "'TimeStamp::IsPassed''CoLibri Reference Manual'"
.bp
.NX 4 "IsPassed"
.sp
.IP MODULE
\f(HBTimeSt\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD IsPassed () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsPassed\fP tests whether the current time stamp is passed.
.IP "RETURN VALUE"
This method returns TRUE, if the current time stamp is passed.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR time       : Time::Time;
VAR time_stamp : TimeSt::TimeStamp;
VAR is_passed  : BOOL;
\&...
time       := NEW Time::Time (18, 40, 00);
time_stamp := NEW TimeSt::TimeStamp (1992, 1, 1, time);
is_passed  := time_stamp.IsPassed ();
.CE
.KE
Then is_passed has the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''TimeStamp::SetTime'"
.EH "'TimeStamp::SetTime''CoLibri Reference Manual'"
.bp
.NX 4 "SetTime"
.sp
.IP MODULE
\f(HBTimeSt\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBMETHOD SetTime ( IN stamp : Time );\fP
.IP DESCRIPTION
The method \f(HOSetTime\fP assigns the value of the parameter \f(HOstamp\fP
to the current object.
.KS
.IP EXAMPLES
.CS L
VAR time       : Time::Time;
VAR time_stamp : TimeSt::TimeStamp;
VAR new_time   : Time::Time;
\&...
time       := NEW Time::Time (18, 40, 00);
time_stamp := NEW TimeSt::TimeStamp (1992, 1, 1, time);
new_time   := NEW Time::Time (19, 41, 01);
time_stamp.SetTime (new_time);
.CE
.KE
Then time_stamp contains the date 01.01.1992 and the time 19:41:01.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODate::SetDate\fP,
\f(HOSetToActualDate\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''TimeStamp::SetToActualDate'"
.EH "'TimeStamp::SetToActualDate''CoLibri Reference Manual'"
.bp
.NX 4 "SetToActualDate"
.sp
.IP MODULE
\f(HBTimeSt\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD SetToActualDate;
.IP DESCRIPTION
The method \f(HOSetToActualDate\fP assigns the actual date (machine date)
and the actual time (machine time) to the current object.
.KS
.IP EXAMPLES
.CS L
VAR time       : Time::Time;
VAR time_stamp : TimeSt::TimeStamp;
\&...
time       := NEW Time::Time (18, 40, 00);
time_stamp := NEW TimeSt::TimeStamp (1992, 1, 1, time);
time_stamp.SetToActualDate ();
.CE
.KE
Then time_stamp contains the actual date (machine date) and the actual time
(machine time).
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODate::SetDate\fP,
\f(HOSetTime\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''TimeStamp::Subtract'"
.EH "'TimeStamp::Subtract''CoLibri Reference Manual'"
.bp
.NX 4 "Subtract"
.sp
.IP MODULE
\f(HBTimeSt\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Subtract ( IN extent : Duration );\fP
.IP DESCRIPTION
The method \f(HOSubtract\fP subtracts \f(HOextent\fP from the current time
stamp.
.KS
.IP EXAMPLES
.CS L
VAR time       : Time::Time;
VAR time_stamp : TimeSt::TimeStamp;
VAR duration   : Duration::Duration;
\&...
time       := NEW Time::Time (18, 40, 00);
time_stamp := NEW TimeSt::TimeStamp (1992, 1, 21, time);
duration   := NEW Duration::Duration (11, 10, 20, 40);
time_stamp.Subtract (duration);
.CE
.KE
Then time_stamp contains the date 10.01.1900 and the time 08:19:20.
.IP "SEE ALSO"
\f(HOAdd\fP,
\f(HODuration\fP,
\f(HOINITIALLY\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''TimeStamp'"
.EH "'TimeStamp''CoLibri Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HOTimeStamp\fP.
.br
The column R/N shows whether the method is
.IP \(bu 3
redefined (R),
.IP \(bu 3
a new method (N),
.IP \(bu 3
an inherited method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
$INITIALLY$IN$year$INT$InvalidDate
$$IN$month$INT$InvalidTime
$$IN$day$INT$
$$IN$stamp$Time$
$$result$$TimeStamp$
_
R$Add$IN$extent$Duration$$
_
R$Copy$result$$Date$
_
R$Distance$IN$end_date$Date$NegativeDuration
$$result$$Duration$
_
$GetDay$result$$INT$
_
$GetDayOfWeek$result$$INT$
_
$GetDayOfYear$result$$INT$
_
$GetMonth$result$$INT$
_
N$GetTime$result$$Time$
_
$GetWeekOfYear$result$$INT$
_
$GetYear$result$$INT$
_
R$IsActual$result$$BOOL$
_
R$IsEarlier$IN$operand$Date$
$$result$$BOOL$
_
R$IsEqual$IN$operand$Date$
$$result$$BOOL$
_
R$IsInFuture$result$$BOOL$
_
R$IsLater$IN$operand$Date$
$$result$$BOOL$
_
R$IsPassed$result$$BOOL$
.TE
.NL
.nr PS 12
.KE
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
$SetDate$IN$year$INT$InvalidDate
$$IN$month$INT$
$$IN$day$INT$
_
N$SetTime$IN$stamp$Time$
_
R$SetToActualDate$$$$
_
R$Subtract$IN$extent$Duration$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''TimeStampRepr'"
.EH "'TimeStampRepr''CoLibri Reference Manual'"
.bp
.NX 2 "TimeStampRepr"
.sp
.NX 3 "Type Description"
.sp
\f(HOTimeStampRepr\fP is a sub type of object type \f(HOTimeStamp\fP
representing a calendar entry consisting of year, month and day and a 
time value consisting of hours, minutes and seconds together with a 
format string containing the presentation description according to the C
library function \f(HOstrftime()\fP.
In addition to the methods offered by \f(HOTimeStamp\fP, this object 
type offers methods to construct an object together with a presentation
description, to change the presentation and to get information about the
presentation.
.sp
.NX 3 "List of Methods"
.sp
The following methods are available in <TimeStRepr.cs>:
.TS
tab($);
l l.
Method name$R(edefined)/N(ew)
_
Add
Copy$R
Distance
GetDay
GetDayOfWeek
GetDayOfYear
GetFormat$N
GetMonth
GetTime
GetWeekOfYear
GetYear
IsActual
IsEarlier
IsEqual
IsInFuture
IsLater
IsPassed
Present$N
SetDate
SetFormat$N
SetTime
SetToActualDate
Subtract
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each method described below the exceptions which will be raised in case
of an error are listed.
.sp
The following exceptions can be raised using module \f(HOTimeStRepr\fP :
.TS
tab($);
l.
exception name
_
Date::InvalidDate
Time::InvalidTime
Date::NegativeDuration
.TE
.sp
.NX 3 "How to use TimeStampRepr"
.sp
A variable of type \f(HOTimeStampRepr\fP is declared as follows:
.CS L
VAR time_stamp_repr : TimeStRepr::TimeStampRepr;
.CE
.sp 0.5
A variable of type \f(HOTimeStampRepr\fP can be initialized using the CooL
constructor NEW.
.sp
A sub type of type \f(HOTimeStampRepr\fP is declared as follows:
.CS L
TYPE MyTimeStampRepr = TimeStampRepr OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL module which uses the type \f(HOTimeStampRepr\fP must
import the module \f(HOTimeStRepr\fP:
.CS L
IMPORT ..., TimeStRepr, ...;
.CE
.sp 0.5
.NX 3 "Method Description"
.sp
The following sections contain the syntactical and semantical description of
all (redefined and new) methods provided by \f(HOTimeStampRepr\fP.
They are listed in alphabetical order.
.sp
.OH "'CoLibri Reference Manual''TimeStampRepr::INITIALLY'"
.EH "'TimeStampRepr::INITIALLY''CoLibri Reference Manual'"
.bp
.NX 4 "INITIALLY"
.sp
.IP MODULE
\f(HBTimeStRepr\fP
.IP TYPE
\f(HBTimeStampRepr = TimeStamp\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBINITIALLY $($ IN year $ : INT,
$$ IN month $ : INT,
$$ IN day $ : INT,
$$ IN stamp $ : Time,
$$ IN format $ : STRING )
$:$ TimeStampRepr;$\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW.
The parameters \f(HOyear\fP, \f(HOmonth\fP and \f(HOday\fP specify the date
of the current object.
The parameter \f(HOstamp\fP specifies the time of the current object.
The parameter \f(HOformat\fP specifies the presentation of the current object
according to the C library function \f(HOstrftime()\fP.
.IP "RETURN VALUE"
This method returns a new object of this type containing \f(HOyear\fP,
\f(HOmonth\fP, \f(HOday\fP, \f(HOstamp\fP and \f(HOformat\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOInvalidDate\fP"
is raised, if \f(HOyear\fP, \f(HOmonth\fP and \f(HOday\fP do not 
represent a valid date.
.IP "\(bu \f(HOInvalidTime\fP"
is raised, if \f(HOstamp\fP do not represent a valid time.
.KS
.IP EXAMPLES
.CS L
VAR year            : INT;
VAR month           : INT;
VAR day             : INT;
VAR hour            : INT;
VAR minute          : INT;
VAR second          : INT;
VAR time            : Time::Time;
VAR format          : STRING;
VAR time_stamp_repr : TimeStRepr::TimeStampRepr;
\&...
year            := 1992;
month           := 1;
day             := 1;
hour            := 18;
minute          := 40;
second          := 0;
time            := NEW Time::Time (hour, minute, second);
format          := "%d/%m/%Y,%H:%M:%S";
time_stamp_repr := NEW TimeStRepr::TimeStampRepr
.in +12
(year, month, day, time, format);
.in -12
.CE
.KE
Then time_stamp_repr contains the date 01.01.1992, the time 18:40:00 and the
format string "%d/%m/%Y,%H:%M:%S".
.IP "SEE ALSO"
\f(HODate::SetDate\fP,
\f(HOSetFormat\fP,
\f(HOstrftime()\fP,
\f(HOTime::INITIALLY\fP,
\f(HOTimeSt::SetTime\fP,
\f(HOTimeSt::SetToActualDate\fP
.LP
.OH "'CoLibri Reference Manual''TimeStampRepr::Copy'"
.EH "'TimeStampRepr::Copy''CoLibri Reference Manual'"
.bp
.NX 4 "Copy"
.sp
.IP MODULE
\f(HBTimeStRepr\fP
.IP TYPE
\f(HBTimeStampRepr = TimeStamp\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Copy () : Date;\fP
.IP DESCRIPTION
The method \f(HOCopy\fP creates a new object of this type containing the
state of the current object.
.IP "RETURN VALUE"
This method returns a new object of this type containing the state of the
current object.
.KS
.IP EXAMPLES
.CS L
VAR time                 : Time::Time;
VAR time_stamp_repr      : TimeStRepr::TimeStampRepr;
VAR next_time_stamp_repr : TimeStRepr::TimeStampRepr;
\&...
time            := NEW Time::Time (18, 40, 00);
time_stamp_repr := NEW TimeStRepr::TimeStampRepr
.in +13
(1992, 1, 1, time,"%d/%m/%Y,%H:%M:%S");
.in -13
TYPESELECT select_time_stamp_repr := time_stamp_repr.Copy () OF
   CASE TimeStRepr::TimeStampRepr :
next_time_stamp_repr := select_time_stamp_repr;
\&...
END TYPESELECT;
.CE
.KE
Then next_time_stamp_repr contains the date 01.01.1992, the time 18:40:00 and the
format string "%d/%m/%Y,%H:%M:%S".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''TimeStampRepr::GetFormat'"
.EH "'TimeStampRepr::GetFormat''CoLibri Reference Manual'"
.bp
.NX 4 "GetFormat"
.sp
.IP MODULE
\f(HBTimeStRepr\fP
.IP TYPE
\f(HBTimeStampRepr = TimeStamp\fP
.IP SYNOPSIS
\f(HBMETHOD GetFormat () : STRING;\fP
.IP DESCRIPTION
The method \f(HOGetFormat\fP returns presentation format string of the current
time stamp.
.IP "RETURN VALUE"
This method returns the presentation format string of the current time stamp.
.KS
.IP EXAMPLES
.CS L
VAR time            : Time::Time;
VAR time_stamp_repr : TimeStRepr::TimeStampRepr;
VAR string          : STRING;
\&...
time            := NEW Time::Time (18, 40, 00);
time_stamp_repr := NEW TimeStRepr::TimeStampRepr
.in +12
(1992, 1, 1, time, "%d/%m/%Y,%H:%M:%S");
.in -12
string          := time_stamp_repr.GetFormat ();
.CE
.KE
Then string has the value "%d/%m/%Y,%H/%M/%S".
.IP "SEE ALSO"
\f(HODate::GetDay\fP,
\f(HODate::GetMonth\fP,
\f(HODate::GetYear\fP,
\f(HOINITIALLY\fP,
\f(HOSetFormat\fP,
\f(HOTime::INITIALLY\fP,
\f(HOTimeSt::GetTime\fP
.LP
.OH "'CoLibri Reference Manual''TimeStampRepr::Present'"
.EH "'TimeStampRepr::Present''CoLibri Reference Manual'"
.bp
.NX 4 "Present"
.sp
.IP MODULE
\f(HBTimeStRepr\fP
.IP TYPE
\f(HBTimeStampRepr = TimeStamp\fP
.IP SYNOPSIS
\f(HBMETHOD Present () : STRING;\fP
.IP DESCRIPTION
The method \f(HOPresent\fP returns a string which contains the presentation
of the current time stamp using the presentation format string.
.IP "RETURN VALUE"
This method returns a string which contains the presentation of the current
time stamp using the presentation format string.
.KS
.IP EXAMPLES
.CS L
VAR time            : Time::Time;
VAR time_stamp_repr : TimeStRepr::TimeStampRepr;
VAR string          : STRING;
\&...
time          := NEW Time::Time (18, 40, 00);
time_stamp_repr := NEW TimeStRepr::TimeStampRepr
.in +12
(1992, 1, 1, time, "%d/%m/%Y,%H:%M:%S");
.in -12
string        := time_stamp_repr.Present ();
.CE
.KE
Then string has the value "01.01.1992,18:40:00".
.IP "SEE ALSO"
\f(HOGetFormat\fP,
\f(HOINITIALLY\fP,
\f(HOSetFormat\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''TimeStampRepr::SetFormat'"
.EH "'TimeStampRepr::SetFormat''CoLibri Reference Manual'"
.bp
.NX 4 "SetFormat"
.sp
.IP MODULE
\f(HBTimeStRepr\fP
.IP TYPE
\f(HBTimeStampRepr = TimeStamp\fP
.IP SYNOPSIS
\f(HBMETHOD SetFormat ( IN format : STRING );\fP
.IP DESCRIPTION
The method \f(HOSetFormat\fP assigns the value of the parameter
\f(HOformat\fP to the current object.
.KS
.IP EXAMPLES
.CS L
VAR time            : Time::Time;
VAR time_stamp_repr : TimeStRepr::TimeStampRepr;
VAR new_format      : STRING;
\&...
time            := NEW Time::Time (18, 40, 00);
time_stamp_repr := NEW TimeStRepr::TimeStampRepr
.in +12
(1992, 1, 1, time, "%d/%m/%Y,%H:%M:%S");
.in -12
new_format      := "%H.%M.%S-%Y-%m-%d";
time_stamp_repr.SetFormat (new_format);
.CE
.KE
Then time_stamp_repr contains the date 01.01.1992, the time 18:40:00 and the
format string "%H.%M.%S-%Y-%m-%d".
.IP "SEE ALSO"
\f(HODate::SetDate\fP,
\f(HOGetFormat\fP,
\f(HOINITIALLY\fP,
\f(HOTime::INITIALLY\fP
\f(HOTimeSt::SetTime\fP,
\f(HOTimeSt::SetToActualDate\fP
.LP
.OH "'CoLibri Reference Manual''TimeStampRepr'"
.EH "'TimeStampRepr''CoLibri Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HOTimeStampRepr\fP.
.br
The column R/N shows whether the method is
.IP \(bu 3
redefined (R),
.IP \(bu 3
a new method (N),
.IP \(bu 3
an inherited method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
$INITIALLY$IN$year$INT$InvalidDate
$$IN$month$INT$InvalidTime
$$IN$day$INT$
$$IN$stamp$Time$
$$IN$format$STRING$
$$result$$TimeStampRepr$
_
$Add$IN$extent$Duration$$
_
R$Copy$result$$Date$
_
$Distance$IN$end_date$Date$NegativeDuration
$$result$$Duration$
_
$GetDay$result$$INT$
_
$GetDayOfWeek$result$$INT$
_
$GetDayOfYear$result$$INT$
_
N$GetFormat$result$$STRING$
_
$GetMonth$result$$INT$
_
$GetTime$result$$Time$
_
$GetWeekOfYear$result$$INT$
_
$GetYear$result$$INT$
_
$IsActual$result$$BOOL$
_
$IsEarlier$IN$operand$Date$
$$result$$BOOL$
_
$IsEqual$IN$operand$Date$
$$result$$BOOL$
_
$IsInFuture$result$$BOOL$
_
$IsLater$IN$operand$Date$
$$result$$BOOL$
_
$IsPassed$result$$BOOL$
_
N$Present$result$$STRING$
.TE
.NL
.nr PS 12
.KE
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
$SetDate$IN$year$INT$InvalidDate
$$IN$month$INT$
$$IN$day$INT$
_
N$SetFormat$IN$format$STRING$
_
$SetTime$IN$stamp$Time$
_
$SetToActualDate$$$$
_
$Subtract$IN$extent$Duration$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''Duration'"
.EH "'Duration''CoLibri Reference Manual'"
.bp
.NX 2 "Duration"
.sp
.NX 3 "Type Description"
.sp
\f(HODuration\fP is an object type representing a duration consisting of
days, hours, minutes and seconds.
The values of days, hours, minutes and seconds are automatically 
converted, if they are out of range (hours with a value greater than 24
are converted into days, negative seconds are subtracted from minutes 
etc.).
This object type offers methods to construct, modify and actualize an object
and to get information about an object.
Further methods deal with arithmetic operations and predicates.
.sp
.NX 3 "List of Methods"
.sp
The following methods are available in <Duration.cs>:
.TS
tab($);
l.
Method name
_
Add
Copy
Divide
GetDayPart
GetDays
GetHourPart
GetHours
GetMinutePart
GetMinutes
GetSecondPart
GetSeconds
GetWeeks
IsEqual
IsLonger
IsShorter
Multiply
SetDuration
Subtract
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each method described below the exceptions which will be raised in case
of an error are listed.
.sp
.KS
The following exceptions can be raised using module \f(HODuration\fP :
.TS
tab($);
l.
exception name
_
NegativeDuration
.TE
.KE
.sp
.NX 3 "How to use Duration"
.sp
A variable of type \f(HODuration\fP is declared as follows:
.CS L
VAR duration : Duration;
.CE
.sp 0.5
A variable of type \f(HODuration\fP can be initialized using the CooL
constructor NEW.
.sp
A sub type of type \f(HODuration\fP is declared as follows:
.CS L
TYPE MyDuration = Duration OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL module which uses the type \f(HODuration\fP must import the module
\f(HODuration\fP:
.CS L
IMPORT ..., Duration, ...;
.CE
.sp 0.5
.NX 3 "Method Description"
.sp
The following sections contain the syntactical and semantical description of
all methods provided by \f(HODuration\fP.
They are listed in alphabetical order.
.sp
.OH "'CoLibri Reference Manual''Duration::INITIALLY'"
.EH "'Duration::INITIALLY''CoLibri Reference Manual'"
.bp
.NX 4 "INITIALLY"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBINITIALLY $($ IN days $ : INT,
$$ IN hours $ : INT,
$$ IN minutes $ : INT,
$$ IN seconds $ : INT )
$:$ Duration;$\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW.
The parameters \f(HOdays\fP, \f(HOhours\fP, \f(HOminutes\fP and
\f(HOseconds\fP specify the duration of the current object.
.IP "RETURN VALUE"
This method returns a new object of this type containing \f(HOdays\fP,
\f(HOhours\fP, \f(HOminutes\fP and \f(HOseconds\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeDuration\fP"
is raised, if \f(HOdays\fP, \f(HOhours\fP, \f(HOminutes\fP and 
\f(HOseconds\fP represent a negative duration.
.KS
.IP EXAMPLES
.CS L
VAR days     : INT;
VAR hours    : INT;
VAR minutes  : INT;
VAR seconds  : INT;
VAR duration : Duration::Duration;
\&...
days     := 17;
hours    := 13;
minutes  := 7;
seconds  := 3;
duration := NEW Duration::Duration (days, hours, minutes, seconds);
.CE
.KE
Then duration contains the duration 17 days, 13 hours, 7 minutes and 3
seconds.
.IP "SEE ALSO"
\f(HOSetDuration\fP
.LP
.OH "'CoLibri Reference Manual''Duration::Add'"
.EH "'Duration::Add''CoLibri Reference Manual'"
.bp
.NX 4 "Add"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD Add ( IN extent : Duration );\fP
.IP DESCRIPTION
The method \f(HOAdd\fP adds \f(HOextent\fP to the current duration.
.KS
.IP EXAMPLES
.CS L
VAR duration       : Duration::Duration;
VAR other_duration : Duration::Duration;
\&...
duration       := NEW Duration::Duration (17, 13, 7, 3);
other_duration := NEW Duration::Duration (10, 5, 2, 0);
duration.Add (other_duration);
.CE
.KE
Then duration contains the duration 27 days, 18 hours, 9 minutes and 3
seconds.
.IP "SEE ALSO"
\f(HOSubtract\fP
.LP
.OH "'CoLibri Reference Manual''Duration::Copy'"
.EH "'Duration::Copy''CoLibri Reference Manual'"
.bp
.NX 4 "Copy"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD Copy () : Duration;\fP
.IP DESCRIPTION
The method \f(HOCopy\fP creates a new object of this type containing the
state of the current object.
.IP "RETURN VALUE"
This method returns a new object of this type containing the state of the
current object.
.KS
.IP EXAMPLES
.CS L
VAR duration      : Duration::Duration;
VAR next_duration : Duration::Duration;
\&...
duration      := NEW Duration::Duration (17, 13, 7, 3);
next_duration := duration.Copy ();
.CE
.KE
Then next_duration contains the duration 17 days, 13 hours, 7 minutes and 3
seconds.
.IP "SEE ALSO"
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''Duration::Divide'"
.EH "'Duration::Divide''CoLibri Reference Manual'"
.bp
.NX 4 "Divide"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD Divide ( IN divisor : INT );\fP
.IP DESCRIPTION
The method \f(HODivide\fP divides the current duration by \f(HOdivisor\fP
using the operator DIV.
.KS
.IP EXAMPLES
.CS L
VAR duration : Duration::Duration;
VAR divisor  : INT;
\&...
duration := NEW Duration::Duration (17, 13, 7, 3);
divisor  := 3;
duration.Divide (divisor);
.CE
.KE
Then duration contains the duration 5 days, 4 hours, 2 minutes and 1 second.
.IP "SEE ALSO"
\f(HOMultiply\fP
.LP
.OH "'CoLibri Reference Manual''Duration::GetDayPart'"
.EH "'Duration::GetDayPart''CoLibri Reference Manual'"
.bp
.NX 4 "GetDayPart"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD GetDayPart () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetDayPart\fP returns the days of the current duration.
.IP "RETURN VALUE"
This method returns the days of the current duration.
.KS
.IP EXAMPLES
.CS L
VAR duration : Duration::Duration;
VAR days     : INT;
\&...
duration := NEW Duration::Duration (2, 5, 7, 3);
days     := duration.GetDayPart ();
.CE
.KE
Then days has the value 2.
.IP "SEE ALSO"
\f(HOGetHourPart\fP,
\f(HOGetMinutePart\fP,
\f(HOGetSecondPart\fP
.LP
.OH "'CoLibri Reference Manual''Duration::GetDays'"
.EH "'Duration::GetDays''CoLibri Reference Manual'"
.bp
.NX 4 "GetDays"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD GetDays () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetDays\fP returns the days of the current duration.
.IP "RETURN VALUE"
This method returns the days of the current duration.
.KS
.IP EXAMPLES
.CS L
VAR duration : Duration::Duration;
VAR days     : INT;
\&...
duration := NEW Duration::Duration (2, 5, 7, 3);
days     := duration.GetDays ();
.CE
.KE
Then days has the value 2.
.IP "SEE ALSO"
\f(HOGetHours\fP,
\f(HOGetMinutes\fP,
\f(HOGetSeconds\fP,
\f(HOGetWeeks\fP
.LP
.OH "'CoLibri Reference Manual''Duration::GetHourPart'"
.EH "'Duration::GetHourPart''CoLibri Reference Manual'"
.bp
.NX 4 "GetHourPart"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD GetHourPart () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetHourPart\fP returns the hours of the current duration.
.IP "RETURN VALUE"
This method returns the hours of the current duration.
.KS
.IP EXAMPLES
.CS L
VAR duration : Duration::Duration;
VAR hours    : INT;
\&...
duration := NEW Duration::Duration (2, 5, 7, 3);
hours    := duration.GetHourPart ();
.CE
.KE
Then hours has the value 5.
.IP "SEE ALSO"
\f(HOGetDayPart\fP,
\f(HOGetMinutePart\fP,
\f(HOGetSecondPart\fP
.LP
.OH "'CoLibri Reference Manual''Duration::GetHours'"
.EH "'Duration::GetHours''CoLibri Reference Manual'"
.bp
.NX 4 "GetHours"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD GetHours () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetHours\fP returns the current duration in hours.
The days are converted into hours.
.IP "RETURN VALUE"
This method returns the current duration in hours.
.KS
.IP EXAMPLES
.CS L
VAR duration : Duration::Duration;
VAR hours    : INT;
\&...
duration := NEW Duration::Duration (2, 5, 7, 3);
hours    := duration.GetHours ();
.CE
.KE
Then hours has the value 53.
.IP "SEE ALSO"
\f(HOGetDays\fP,
\f(HOGetMinutes\fP,
\f(HOGetSeconds\fP,
\f(HOGetWeeks\fP
.LP
.OH "'CoLibri Reference Manual''Duration::GetMinutePart'"
.EH "'Duration::GetMinutePart''CoLibri Reference Manual'"
.bp
.NX 4 "GetMinutePart"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD GetMinutePart () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetMinutePart\fP returns the minutes of the current duration.
.IP "RETURN VALUE"
This method returns the minutes of the current duration.
.KS
.IP EXAMPLES
.CS L
VAR duration : Duration::Duration;
VAR minutes  : INT;
\&...
duration := NEW Duration::Duration (2, 5, 7, 3);
minutes  := duration.GetMinutePart ();
.CE
.KE
Then minutes has the value 7.
.IP "SEE ALSO"
\f(HOGetDayPart\fP,
\f(HOGetHourPart\fP,
\f(HOGetSecondPart\fP
.LP
.OH "'CoLibri Reference Manual''Duration::GetMinutes'"
.EH "'Duration::GetMinutes''CoLibri Reference Manual'"
.bp
.NX 4 "GetMinutes"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD GetMinutes () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetMinutes\fP returns the current duration in minutes.
The days and hours are converted into minutes.
.IP "RETURN VALUE"
This method returns the current duration in minutes.
.KS
.IP EXAMPLES
.CS L
VAR duration : Duration::Duration;
VAR minutes  : INT;
\&...
duration := NEW Duration::Duration (2, 5, 7, 3);
minutes  := duration.GetMinutes ();
.CE
.KE
Then minutes has the value 3187.
.IP "SEE ALSO"
\f(HOGetDays\fP,
\f(HOGetHours\fP,
\f(HOGetSeconds\fP,
\f(HOGetWeeks\fP
.LP
.OH "'CoLibri Reference Manual''Duration::GetSecondPart'"
.EH "'Duration::GetSecondPart''CoLibri Reference Manual'"
.bp
.NX 4 "GetSecondPart"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD GetSecondPart () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetSecondPart\fP returns the seconds of the current duration.
.IP "RETURN VALUE"
This method returns the seconds of the current duration.
.KS
.IP EXAMPLES
.CS L
VAR duration : Duration::Duration;
VAR seconds  : INT;
\&...
duration := NEW Duration::Duration (2, 5, 7, 3);
seconds  := duration.GetSecondPart ();
.CE
.KE
Then seconds has the value 3.
.IP "SEE ALSO"
\f(HOGetDayPart\fP,
\f(HOGetHourPart\fP,
\f(HOGetMinutePart\fP
.LP
.OH "'CoLibri Reference Manual''Duration::GetSeconds'"
.EH "'Duration::GetSeconds''CoLibri Reference Manual'"
.bp
.NX 4 "GetSeconds"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD GetSeconds () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetSeconds\fP returns the current duration in seconds.
The days, hours and minutes are converted into seconds.
.IP "RETURN VALUE"
This method returns the current duration in seconds.
.KS
.IP EXAMPLES
.CS L
VAR duration : Duration::Duration;
VAR seconds  : INT;
\&...
duration := NEW Duration::Duration (2, 5, 7, 3);
seconds  := duration.GetSeconds ();
.CE
.KE
Then seconds has the value 191223.
.IP "SEE ALSO"
\f(HOGetDays\fP,
\f(HOGetHours\fP,
\f(HOGetMinutes\fP,
\f(HOGetWeeks\fP
.LP
.OH "'CoLibri Reference Manual''Duration::GetWeeks'"
.EH "'Duration::GetWeeks''CoLibri Reference Manual'"
.bp
.NX 4 "GetWeeks"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD GetWeeks () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetWeeks\fP returns the current duration in weeks.
.IP "RETURN VALUE"
This method returns the current duration in weeks.
.KS
.IP EXAMPLES
.CS L
VAR duration : Duration::Duration;
VAR weeks    : INT;
\&...
duration := NEW Duration::Duration (17, 13, 7, 3);
weeks    := duration.GetWeeks ();
.CE
.KE
Then weeks has the value 2.
.IP "SEE ALSO"
\f(HOGetDays\fP,
\f(HOGetHours\fP,
\f(HOGetMinutes\fP,
\f(HOGetSeconds\fP
.LP
.OH "'CoLibri Reference Manual''Duration::IsEqual'"
.EH "'Duration::IsEqual''CoLibri Reference Manual'"
.bp
.NX 4 "IsEqual"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD IsEqual ( IN operand : Duration ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEqual\fP tests whether the current duration is equal to
\f(HOoperand\fP.
Two durations dates are equal, if their single components are equal.
.IP "RETURN VALUE"
This method returns TRUE, if the current duration is equal to \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR duration       : Duration::Duration;
VAR other_duration : Duration::Duration;
VAR is_equal       : BOOL;
\&...
duration       := NEW Duration::Duration (17, 13, 7, 3);
other_duration := NEW Duration::Duration (17, 13, 3, 7);
is_equal       := duration.IsEqual (other_duration);
.CE
.KE
Then is_equal has the value FALSE.
.IP "SEE ALSO"
\f(HOIsLonger\fP,
\f(HOIsShorter\fP
.LP
.OH "'CoLibri Reference Manual''Duration::IsLonger'"
.EH "'Duration::IsLonger''CoLibri Reference Manual'"
.bp
.NX 4 "IsLonger"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD IsLonger ( IN operand : Duration ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsLonger\fP tests whether the current duration is longer than
\f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the current duration is longer than
\f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR duration       : Duration::Duration;
VAR other_duration : Duration::Duration;
VAR is_longer      : BOOL;
\&...
duration       := NEW Duration::Duration (17, 13, 7, 3);
other_duration := NEW Duration::Duration (17, 13, 3, 7);
is_longer      := duration.IsLonger (other_duration);
.CE
.KE
Then is_longer has the value TRUE.
.IP "SEE ALSO"
\f(HOIsEqual\fP,
\f(HOIsShorter\fP
.LP
.OH "'CoLibri Reference Manual''Duration::IsShorter'"
.EH "'Duration::IsShorter''CoLibri Reference Manual'"
.bp
.NX 4 "IsShorter"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD IsShorter ( IN operand : Duration ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsShorter\fP tests whether the current duration is shorter
than \f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the current duration is shorter than
\f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR duration       : Duration::Duration;
VAR other_duration : Duration::Duration;
VAR is_shorter     : BOOL;
\&...
duration       := NEW Duration::Duration (17, 13, 7, 3);
other_duration := NEW Duration::Duration (17, 13, 3, 7);
is_shorter     := duration.IsShorter (other_duration);
.CE
.KE
Then is_shorter has the value FALSE.
.IP "SEE ALSO"
\f(HOIsEqual\fP,
\f(HOIsLonger\fP
.LP
.OH "'CoLibri Reference Manual''Duration::Multiply'"
.EH "'Duration::Multiply''CoLibri Reference Manual'"
.bp
.NX 4 "Multiply"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD Multiply ( IN factor : INT );\fP
.IP DESCRIPTION
The method \f(HOMultiply\fP multiplies the current duration by \f(HOfactor\fP.
.KS
.IP EXAMPLES
.CS L
VAR duration : Duration::Duration;
VAR factor   : INT;
\&...
duration := NEW Duration::Duration (17, 13, 7, 3);
factor   := 5;
duration.Multiply (factor);
.CE
.KE
Then duration contains the duration 87 days, 17 hours, 35 minutes and 15
seconds.
.IP "SEE ALSO"
\f(HODivide\fP
.LP
.OH "'CoLibri Reference Manual''Duration::SetDuration'"
.EH "'Duration::SetDuration''CoLibri Reference Manual'"
.bp
.NX 4 "SetDuration"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBMETHOD SetDuration ($ IN days $ : INT,
$ IN hours $ : INT,
$ IN minutes $ : INT,
$ IN seconds $ : INT );\fP
.TE
.IP DESCRIPTION
The method \f(HOSetDuration\fP assigns the values of the parameters
\f(HOdays\fP, \f(HOhours\fP, \f(HOminutes\fP and \f(HOseconds\fP to the
current object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeDuration\fP"
is raised, if \f(HOdays\fP, \f(HOhours\fP, \f(HOminutes\fP and 
\f(HOseconds\fP represent a negative duration.
.KS
.IP EXAMPLES
.CS L
VAR duration : Duration::Duration;
\&...
duration := NEW Duration::Duration (17, 13, 7, 3);
duration.SetDuration (-19, 13, 17, 1);
.CE
.KE
Then the exception \f(HONegativeDuration\fP is raised.
.IP "SEE ALSO"
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''Duration::Subtract'"
.EH "'Duration::Subtract''CoLibri Reference Manual'"
.bp
.NX 4 "Subtract"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD Subtract ( IN extent : Duration );\fP
.IP DESCRIPTION
The method \f(HOSubtract\fP subtracts \f(HOextent\fP from the current
duration.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeDuration\fP"
is raised, if \f(HOextent\fP is longer than the current duration.
.KS
.IP EXAMPLES
.CS L
VAR duration : Duration::Duration;
VAR extend   : Duration::Duration;
\&...
duration := NEW Duration::Duration (17, 13, 7, 3);
extend   := NEW Duration::Duration (10, 2, 0, 0);
duration.Subtract (extend);
.CE
.KE
Then duration contains the duration 7 days, 11 hours, 7 minutes and 3
seconds.
.IP "SEE ALSO"
\f(HOAdd\fP
.LP
.OH "'CoLibri Reference Manual''Duration'"
.EH "'Duration''CoLibri Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HODuration\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
INITIALLY$IN$days$INT$NegativeDuration
$IN$hours$INT$
$IN$minutes$INT$
$IN$seconds$INT$
$result$$Duration$
_
Add$IN$extent$Duration$
_
Copy$result$$Duration$
_
Divide$IN$divisor$INT$
_
GetDayPart$result$$INT$
_
GetDays$result$$INT$
_
GetHourPart$result$$INT$
_
GetHours$result$$INT$
_
GetMinutePart$result$$INT$
_
GetMinutes$result$$INT$
_
GetSecondPart$result$$INT$
_
GetSeconds$result$$INT$
_
GetWeeks$result$$INT$
_
IsEqual$IN$operand$Duration$
$result$$BOOL$
_
IsLonger$IN$operand$Duration$
$result$$BOOL$
_
IsShorter$IN$operand$Duration$
$result$$BOOL$
_
Multiply$IN$factor$INT$
_
SetDuration$IN$days$INT$NegativeDuration
$IN$hours$INT$
$IN$minutes$INT$
$IN$seconds$INT$
_
Subtract$IN$extent$Duration$NegativeDuration
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''Interval'"
.EH "'Interval''CoLibri Reference Manual'"
.bp
.NX 2 "Interval"
.sp
.NX 3 "Type Description"
.sp
\f(HOInterval\fP is an object type representing a time interval consisting of
a start and end date.
This object type offers methods to construct, modify and actualize an object
and to get information about an object.
Further methods deal with arithmetic operations and predicates.
.sp
.NX 3 "List of Methods"
.sp
The following methods are available in <Interval.cs>:
.TS
tab($);
l.
Method name
_
Add
AddToEnd
AddToStart
Contains
ContainsDate
Copy
GetEnd
GetLength
GetStart
Intersect
IsActual
IsEarlier
IsEndInSameDay
IsEndInSameMonth
IsEndInSameWeek
IsEndInSameYear
IsEqual
IsInFuture
IsLater
IsLonger
IsOverlapping
IsPassed
IsShorter
IsStartInSameDay
IsStartInSameMonth
IsStartInSameWeek
IsStartInSameYear
SetEnd
SetStart
Subtract
SubtractFromEnd
SubtractFromStart
Unite
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each method described below the exceptions which will be raised in case
of an error are listed.
.sp
The following exceptions can be raised using module \f(HOInterval\fP :
.TS
tab($);
l.
exception name
_
NegativeInterval
NoOverlap
.TE
.sp
.NX 3 "How to use Interval"
.sp
A variable of type \f(HOInterval\fP is declared as follows:
.CS L
VAR interval : Interval;
.CE
.sp 0.5
A variable of type \f(HOInterval\fP can be initialized using the CooL
constructor NEW.
.sp
A sub type of type \f(HOInterval\fP is declared as follows:
.CS L
TYPE MyInterval = Interval OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL module which uses the type \f(HOInterval\fP must
import the module \f(HOInterval\fP:
.CS L
IMPORT ..., Interval, ...;
.CE
.sp 0.5
.NX 3 "Method Description"
.sp
The following sections contain the syntactical and semantical description of
all methods provided by \f(HOInterval\fP.
They are listed in alphabetical order.
.sp
.OH "'CoLibri Reference Manual''Interval::INITIALLY'"
.EH "'Interval::INITIALLY''CoLibri Reference Manual'"
.bp
.NX 4 "INITIALLY"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBINITIALLY $($ IN start $ : Date,
$$ IN end $ : Date )
$:$ Interval;\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW.
The parameters \f(HOstart and \f(HOend\fP specify the interval of the current
object.
.IP "RETURN VALUE"
This method returns a new object of this type containing \f(HOstart\fP and
\f(HOend\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeInterval\fP"
is raised, if \f(HOstart\fP is later than \f(HOend\fP.
.KS
.IP EXAMPLES
.CS L
VAR start_year  : INT;
VAR start_month : INT;
VAR start_day   : INT;
VAR start_date  : Date::Date;
VAR end_year    : INT;
VAR end_month   : INT;
VAR end_day     : INT;
VAR end_date    : Date::Date;
VAR interval    : Interval::Interval;
\&...
start_year  := 1992;
start_month := 1;
start_day   := 1;
start_date  := NEW Date::Date (start_year, start_month, start_day);
end_year    := 1992;
end_month   := 2;
end_day     := 1;
end_date    := NEW Date::Date (end_year, end_month, end_day);
interval    := NEW Interval::Interval (start_date, end_date);
.CE
.KE
Then interval contains the interval from 01.01.1992 to 01.02.1992.
.IP "SEE ALSO"
\f(HODate::INITIALLY \fP
.LP
.OH "'CoLibri Reference Manual''Interval::Add'"
.EH "'Interval::Add''CoLibri Reference Manual'"
.bp
.NX 4 "Add"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD Add ( IN extent : Duration );\fP
.IP DESCRIPTION
The method \f(HOAdd\fP adds \f(HOextent\fP to the start and end date of the
current interval.
.KS
.IP EXAMPLES
.CS L
VAR start_date  : Date::Date;
VAR end_date    : Date::Date;
VAR interval    : Interval::Interval;
VAR duration    : Duration::Duration;
\&...
start_date  := NEW Date::Date (1992, 1, 1);
end_date    := NEW Date::Date (1992, 2, 1);
interval    := NEW Interval::Interval (start_date, end_date);
duration    := NEW Duration::Duration (10, 0, 0, 0);
interval.Add (duration);
.CE
.KE
Then interval contains the interval from 11.01.1992 to 11.02.1992.
.IP "SEE ALSO"
\f(HOAddToEnd\fP,
\f(HOAddToStart\fP,
\f(HODuration\fP,
\f(HOSubtract\fP,
\f(HOSubtractFromEnd\fP,
\f(HOSubtractFromStart\fP
.LP
.OH "'CoLibri Reference Manual''Interval::AddToEnd'"
.EH "'Interval::AddToEnd''CoLibri Reference Manual'"
.bp
.NX 4 "AddToEnd"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD AddToEnd ( IN extent : Duration );\fP
.IP DESCRIPTION
The method \f(HOAddToEnd\fP adds \f(HOextent\fP to the end date of the
current interval.
.KS
.IP EXAMPLES
.CS L
VAR start_date  : Date::Date;
VAR end_date    : Date::Date;
VAR interval    : Interval::Interval;
VAR duration    : Duration::Duration;
\&...
start_date := NEW Date::Date (1992, 1, 1);
end_date   := NEW Date::Date (1992, 2, 1);
interval   := NEW Interval::Interval (start_date, end_date);
duration   := NEW Duration::Duration (10, 0, 0, 0);
interval.AddToEnd (duration);
.CE
.KE
Then interval contains the interval from 01.01.1992 to 11.02.1992.
.IP "SEE ALSO"
\f(HOAdd\fP,
\f(HOAddToStart\fP,
\f(HODuration\fP,
\f(HOSubtract\fP,
\f(HOSubtractFromEnd\fP,
\f(HOSubtractFromStart\fP
.LP
.OH "'CoLibri Reference Manual''Interval::AddToStart'"
.EH "'Interval::AddToStart''CoLibri Reference Manual'"
.bp
.NX 4 "AddToStart"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD AddToStart ( IN extent : Duration );\fP
.IP DESCRIPTION
The method \f(HOAddToStart\fP adds \f(HOextent\fP to the start date of the
current interval.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeInterval\fP"
is raised, if the calculated start date is later than the end date.
.KS
.IP EXAMPLES
.CS L
VAR start_date : Date::Date;
VAR end_date   : Date::Date;
VAR interval   : Interval::Interval;
VAR duration   : Duration::Duration;
\&...
start_date := NEW Date::Date (1992, 1, 1);
end_date   := NEW Date::Date (1992, 2, 1);
interval   := NEW Interval::Interval (start_date, end_date);
duration   := NEW Duration::Duration (10, 0, 0, 0);
interval.AddToStart (duration);
.CE
.KE
Then interval contains the interval from 11.01.1992 to 01.02.1992.
.IP "SEE ALSO"
\f(HOAdd\fP,
\f(HOAddToEnd\fP,
\f(HODuration\fP,
\f(HOSubtract\fP,
\f(HOSubtractFromEnd\fP,
\f(HOSubtractFromStart\fP
.LP
.OH "'CoLibri Reference Manual''Interval::Contains'"
.EH "'Interval::Contains''CoLibri Reference Manual'"
.bp
.NX 4 "Contains"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD Contains ( IN operand : Interval ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOContains\fP tests whether the current interval contains
\f(HOoperand\fP.
The current interval contains \f(HOoperand\fP, if the start and end date of
\f(HOoperand\fP is between the start and end date of the current interval.
If two intervals are equal, they contain each other.
.IP "RETURN VALUE"
This method returns TRUE, if the current interval contains \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date       : Date::Date;
VAR end_date         : Date::Date;
VAR other_start_date : Date::Date;
VAR other_end_date   : Date::Date;
VAR interval         : Interval::Interval;
VAR other_interval   : Interval::Interval;
VAR contains         : BOOL;
\&...
start_date       := NEW Date::Date (1992, 1, 1);
end_date         := NEW Date::Date (1992, 2, 1);
interval         := NEW Interval::Interval (start_date, end_date);
other_start_date := NEW Date::Date (1992, 1, 10);
other_end_date   := NEW Date::Date (1992, 1, 15);
other_interval   := NEW Interval::Interval 
.in +12
(other_start_date, other_end_date);
.in -12
contains         := interval.Contains (other_interval);
.CE
.KE
Then contains has the value TRUE.
.IP "SEE ALSO"
\f(HOContainsDate\fP
.LP
.OH "'CoLibri Reference Manual''Interval::ContainsDate'"
.EH "'Interval::ContainsDate''CoLibri Reference Manual'"
.bp
.NX 4 "ContainsDate"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD ContainsDate ( IN operand : Date ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOContainsDate\fP tests whether the current interval contains
\f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the current interval contains \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
\&...
VAR start_date    : Date::Date;
VAR end_date      : Date::Date;
VAR interval      : Interval::Interval;
VAR other_date    : Date::Date;
VAR contains_date : BOOL;
\&...
start_date    := NEW Date::Date (1992, 1, 1);
end_date      := NEW Date::Date (1992, 2, 1);
interval      := NEW Interval::Interval (start_date, end_date);
other_date    := NEW Date::Date (1992, 1, 10);
contains_date := interval.ContainsDate (other_date);
.CE
.KE
Then contains_date has the value TRUE.
.IP "SEE ALSO"
\f(HOContains\fP
.LP
.OH "'CoLibri Reference Manual''Interval::Copy'"
.EH "'Interval::Copy''CoLibri Reference Manual'"
.bp
.NX 4 "Copy"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD Copy () : Interval;\fP
.IP DESCRIPTION
The method \f(HOCopy\fP creates a new object of this type containing the
state of the current object.
.IP "RETURN VALUE"
This method returns a new object of this type containing the state of the
current object.
.KS
.IP EXAMPLES
.CS L
VAR start_date    : Date::Date;
VAR end_date      : Date::Date;
VAR interval      : Interval::Interval;
VAR next_interval : Interval::Interval;
\&...
start_date    := NEW Date::Date (1992, 1, 1);
end_date      := NEW Date::Date (1992, 2, 1);
interval      := NEW Interval::Interval (start_date, end_date);
next_interval := interval.Copy ();
.CE
.KE
Then next_interval contains the interval from 01.01.1992 to 01.02.1992.
.IP "SEE ALSO"
\f(HODate::INITIALLY\fP,
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''Interval::GetEnd'"
.EH "'Interval::GetEnd''CoLibri Reference Manual'"
.bp
.NX 4 "GetEnd"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD GetEnd () : Date;\fP
.IP DESCRIPTION
The method \f(HOGetEnd\fP returns the end date the current interval.
.IP "RETURN VALUE"
This method returns the end date the current interval.
.KS
.IP EXAMPLES
.CS L
VAR start_date : Date::Date;
VAR end_date   : Date::Date;
VAR interval   : Interval::Interval;
VAR date       : Date::Date;
\&...
start_date := NEW Date::Date (1992, 1, 1);
end_date   := NEW Date::Date (1992, 2, 1);
interval   := NEW Interval::Interval (start_date, end_date);
date       := interval.GetEnd ();
.CE
.KE
Then date contains the date 01.02.1992.
.IP "SEE ALSO"
\f(HODate::INITIALLY\fP,
\f(HOGetLength\fP,
\f(HOGetStart\fP
.LP
.OH "'CoLibri Reference Manual''Interval::GetLength'"
.EH "'Interval::GetLength''CoLibri Reference Manual'"
.bp
.NX 4 "GetLength"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD GetLength () : Duration;\fP
.IP DESCRIPTION
The method \f(HOGetLength\fP returns the difference between the start and
end date of the current interval.
.IP "RETURN VALUE"
This method returns the difference between the start and end date of the
current interval.
.KS
.IP EXAMPLES
.CS L
VAR start_date : Date::Date;
VAR end_date   : Date::Date;
VAR interval   : Interval::Interval;
VAR length     : Duration::Duration;
\&...
start_date := NEW Date::Date (1992, 1, 1);
end_date   := NEW Date::Date (1992, 2, 1);
interval   := NEW Interval::Interval (start_date, end_date);
length     := interval.GetLength ();
.CE
.KE
Then length contains 31 days, 0 hours, 0 minutes and 0 seconds.
.IP "SEE ALSO"
\f(HODuration\fP,
\f(HOGetEnd\fP,
\f(HOGetStart\fP
.LP
.OH "'CoLibri Reference Manual''Interval::GetStart'"
.EH "'Interval::GetStart''CoLibri Reference Manual'"
.bp
.NX 4 "GetStart"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD GetStart () : Date;\fP
.IP DESCRIPTION
The method \f(HOGetStart\fP returns the start date the current interval.
.IP "RETURN VALUE"
This method returns the start date the current interval.
.KS
.IP EXAMPLES
.CS L
VAR start_date : Date::Date;
VAR end_date   : Date::Date;
VAR interval   : Interval::Interval;
VAR date       : Date::Date;
\&...
start_date := NEW Date::Date (1992, 1, 1);
end_date   := NEW Date::Date (1992, 2, 1);
interval   := NEW Interval::Interval (start_date, end_date);
date       := interval.GetStart ();
.CE
.KE
Then date contains the date 01.01.1992.
.IP "SEE ALSO"
\f(HODate::INITIALLY\fP,
\f(HOGetEnd\fP,
\f(HOGetLength\fP
.LP
.OH "'CoLibri Reference Manual''Interval::Intersect'"
.EH "'Interval::Intersect''CoLibri Reference Manual'"
.bp
.NX 4 "Intersect"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD Intersect ( IN operand : Interval );\fP
.IP DESCRIPTION
The method \f(HOIntersect\fP intersects the current interval with
\f(HOoperand\fP.
The new start date of the current interval is the latest start date of both
intervals, the new end date of the current interval is the earliest end date
of both intervals.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONoOverlap\fP"
is raised, if the current interval and \f(HOoperand\fP do not overlap 
each other.
.KS
.IP EXAMPLES
.CS L
VAR start_date       : Date::Date;
VAR end_date         : Date::Date;
VAR interval         : Interval::Interval;
VAR other_start_date : Date::Date;
VAR other_end_date   : Date::Date;
VAR other_interval   : Interval::Interval;
\&...
start_date       := NEW Date::Date (1992, 1, 1);
end_date         := NEW Date::Date (1992, 2, 1);
interval         := NEW Interval::Interval (start_date, end_date);
other_start_date := NEW Date::Date (1992, 1, 10);
other_end_date   := NEW Date::Date (1992, 2, 15);
other_interval   := NEW Interval::Interval (other_start_date, other_end_date);
interval.Intersect (other_interval);
.CE
.KE
Then interval contains the interval from 10.01.1992 to 01.02.1992.
.IP "SEE ALSO"
\f(HOUnite\fP
.LP
.OH "'CoLibri Reference Manual''Interval::IsActual'"
.EH "'Interval::IsActual''CoLibri Reference Manual'"
.bp
.NX 4 "IsActual"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsActual () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsActual\fP tests whether the actual date is between the
start and end date of the current interval.
.IP "RETURN VALUE"
This method returns TRUE, if the actual date is between the start and end date
of the current interval.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date : Date::Date;
VAR end_date   : Date::Date;
VAR interval   : Interval::Interval;
VAR is_actual  : BOOL;
\&...
start_date := NEW Date::Date (1992, 1, 1);
end_date   := NEW Date::Date (1992, 2, 1);
interval   := NEW Interval::Interval (start_date, end_date);
is_actual  := interval.IsActual ();
.CE
.KE
Then is_actual has the value FALSE.
.IP "SEE ALSO"
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibri Reference Manual''Interval::IsEarlier'"
.EH "'Interval::IsEarlier''CoLibri Reference Manual'"
.bp
.NX 4 "IsEarlier"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsEarlier ( IN operand : Date ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEarlier\fP tests whether the end date of the current
interval is earlier than \f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the end date of the current interval is earlier
than \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date : Date::Date;
VAR end_date   : Date::Date;
VAR interval   : Interval::Interval;
VAR other_date : Date::Date;
VAR is_earlier : BOOL;
\&...
start_date := NEW Date::Date (1992, 1, 1);
end_date   := NEW Date::Date (1992, 2, 1);
interval   := NEW Interval::Interval (start_date, end_date);
other_date := NEW Date::Date (1992, 2, 1);
is_earlier := interval.IsEarlier (other_date);
.CE
.KE
Then is_earlier has the value FALSE.
.IP "SEE ALSO"
\f(HOIsActual\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibri Reference Manual''Interval::IsEndInSameDay'"
.EH "'Interval::IsEndInSameDay''CoLibri Reference Manual'"
.bp
.NX 4 "IsEndInSameDay"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsEndInSameDay ( IN operand : Interval ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEndInSameDay\fP tests whether the day (and month and year)
of the end date of the current interval is equal to the day (and month and
year) of the end date of \f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the day (and month and year) of the end date of
the current interval is equal to the day (and month and year) of the end date
of \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date         : Date::Date;
VAR end_date           : Date::Date;
VAR interval           : Interval::Interval;
VAR other_start_date   : Date::Date;
VAR other_end_date     : Date::Date;
VAR other_interval     : Interval::Interval;
VAR is_end_in_same_day : BOOL;
\&...
start_date         := NEW Date::Date (1992, 1, 1);
end_date           := NEW Date::Date (1992, 2, 1);
interval           := NEW Interval::Interval (start_date, end_date);
other_start_date   := NEW Date::Date (1992, 1, 10);
other_end_date     := NEW Date::Date (1992, 2, 2);
other_interval     := NEW Interval::Interval 
.in +12
(other_start_date, other_end_date);
.in -12
is_end_in_same_day := interval.IsEndInSameDay (other_interval);
.CE
.KE
Then is_end_in_same_day has the value FALSE.
.IP "SEE ALSO"
\f(HOIsEndInSameMonth\fP,
\f(HOIsEndInSameWeek\fP,
\f(HOIsEndInSameYear\fP
.LP
.OH "'CoLibri Reference Manual''Interval::IsEndInSameMonth'"
.EH "'Interval::IsEndInSameMonth''CoLibri Reference Manual'"
.bp
.NX 4 "IsEndInSameMonth"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsEndInSameMonth ( IN operand : Interval ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEndInSameMonth\fP tests whether the month (and year) of
the end date of the current interval is equal to the month (and year) of the
end date of \f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the month (and year) of the end date of the
current interval is equal to the month (and year) of the end date of
\f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date           : Date::Date;
VAR end_date             : Date::Date;
VAR interval             : Interval::Interval;
VAR other_start_date     : Date::Date;
VAR other_end_date       : Date::Date;
VAR other_interval       : Interval::Interval;
VAR is_end_in_same_month : BOOL;
\&...
start_date           := NEW Date::Date (1992, 1, 1);
end_date             := NEW Date::Date (1992, 2, 1);
interval             := NEW Interval::Interval (start_date, end_date);
other_start_date     := NEW Date::Date (1992, 1, 10);
other_end_date       := NEW Date::Date (1992, 2, 2);
other_interval       := NEW Interval::Interval 
.in +12
(other_start_date, other_end_date);
.in -12
is_end_in_same_month := interval.IsEndInSameMonth (other_interval);
.CE
.KE
Then is_end_in_same_month has the value TRUE.
.IP "SEE ALSO"
\f(HOIsEndInSameDay\fP,
\f(HOIsEndInSameWeek\fP,
\f(HOIsEndInSameYear\fP
.LP
.OH "'CoLibri Reference Manual''Interval::IsEndInSameWeek'"
.EH "'Interval::IsEndInSameWeek''CoLibri Reference Manual'"
.bp
.NX 4 "IsEndInSameWeek"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsEndInSameWeek ( IN operand : Interval ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEndInSameWeek\fP tests whether the end date of the current
interval is in the same week (and year) as the end date of \f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the end date of the current interval is in the
same week (and year) as the end date of \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date          : Date::Date;
VAR end_date            : Date::Date;
VAR interval            : Interval::Interval;
VAR other_start_date    : Date::Date;
VAR other_end_date      : Date::Date;
VAR other_interval      : Interval::Interval;
VAR is_end_in_same_week : BOOL;
\&...
start_date          := NEW Date::Date (1992, 1, 1);
end_date            := NEW Date::Date (1992, 2, 1);
interval            := NEW Interval::Interval (start_date, end_date);
other_start_date    := NEW Date::Date (1992, 1, 10);
other_end_date      := NEW Date::Date (1992, 2, 2);
other_interval      := NEW Interval::Interval 
.in +12
(other_start_date, other_end_date);
.in -12
is_end_in_same_week := interval.IsEndInSameWeek (other_interval);
.CE
.KE
Then IsEndInSameWeek has the value FALSE.
.IP "SEE ALSO"
\f(HOIsEndInSameDay\fP,
\f(HOIsEndInSameMonth\fP,
\f(HOIsEndInSameYear\fP
.LP
.OH "'CoLibri Reference Manual''Interval::IsEndInSameYear'"
.EH "'Interval::IsEndInSameYear''CoLibri Reference Manual'"
.bp
.NX 4 "IsEndInSameYear"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsEndInSameYear ( IN operand : Interval ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEndInSameYear\fP tests whether the year of the end date of
the current interval is equal to the year of the end date of \f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the year of the end date of the current interval
is equal to the year of the end date of \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date          : Date::Date;
VAR end_date            : Date::Date;
VAR interval            : Interval::Interval;
VAR other_start_date    : Date::Date;
VAR other_end_date      : Date::Date;
VAR other_interval      : Interval::Interval;
VAR is_end_in_same_year : BOOL;
\&...
start_date          := NEW Date::Date (1992, 1, 1);
end_date            := NEW Date::Date (1992, 2, 1);
interval            := NEW Interval::Interval (start_date, end_date);
other_start_date    := NEW Date::Date (1992, 1, 10);
other_end_date      := NEW Date::Date (1992, 2, 2);
other_interval      := NEW Interval::Interval 
.in +12
(other_start_date, other_end_date);
.in -12
is_end_in_same_year := interval.IsEndInSameYear (other_interval);
.CE
.KE
Then is_end_in_same_year has the value TRUE.
.IP "SEE ALSO"
\f(HOIsEndInSameDay\fP,
\f(HOIsEndInSameMonth\fP,
\f(HOIsEndInSameWeek\fP
.LP
.OH "'CoLibri Reference Manual''Interval::IsEqual'"
.EH "'Interval::IsEqual''CoLibri Reference Manual'"
.bp
.NX 4 "IsEqual"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsEqual ( IN operand : Interval ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEqual\fP tests whether the current interval is equal to
\f(HOoperand\fP.
Two intervals are equal, if their single components are equal.
.IP "RETURN VALUE"
This method returns TRUE, if the current interval is equal to \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date       : Date::Date;
VAR end_date         : Date::Date;
VAR interval         : Interval::Interval;
VAR other_start_date : Date::Date;
VAR other_end_date   : Date::Date;
VAR other_interval   : Interval::Interval;
VAR is_equal         : BOOL;
\&...
start_date       := NEW Date::Date (1992, 1, 1);
end_date         := NEW Date::Date (1992, 2, 1);
interval         := NEW Interval::Interval (start_date, end_date);
other_start_date := NEW Date::Date (1992, 1, 10);
other_end_date   := NEW Date::Date (1992, 2, 2);
other_interval   := NEW Interval::Interval 
.in +12
(other_start_date, other_end_date);
.in -12
is_equal         := interval.IsEqual (other_interval);
.CE
.KE
Then is_equal has the value FALSE.
.IP "SEE ALSO"
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibri Reference Manual''Interval::IsInFuture'"
.EH "'Interval::IsInFuture''CoLibri Reference Manual'"
.bp
.NX 4 "IsInFuture"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsInFuture () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsInFuture\fP tests whether the current interval is in future.
.IP "RETURN VALUE"
This method returns TRUE, if the current interval is in future.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date   : Date::Date;
VAR end_date     : Date::Date;
VAR interval     : Interval::Interval;
VAR is_in_future : BOOL;
\&...
start_date   := NEW Date::Date (1992, 1, 1);
end_date     := NEW Date::Date (1992, 2, 1);
interval     := NEW Interval::Interval (start_date, end_date);
is_in_future := interval.IsInFuture ();
.CE
.KE
Then is_in_future has the value FALSE.
.IP "SEE ALSO"
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibri Reference Manual''Interval::IsLater'"
.EH "'Interval::IsLater''CoLibri Reference Manual'"
.bp
.NX 4 "IsLater"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsLater ( IN operand : Date ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsLater\fP tests whether the start date of the current
interval is later than \f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the start date of the current interval is later
than \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date : Date::Date;
VAR end_date   : Date::Date;
VAR interval   : Interval::Interval;
VAR other_date : Date::Date;
VAR is_later   : BOOL;
\&...
start_date := NEW Date::Date (1992, 1, 1);
end_date   := NEW Date::Date (1992, 2, 1);
interval   := NEW Interval::Interval (start_date, end_date);
other_date := NEW Date::Date (1992, 1, 10);
is_later   := interval.IsLater (other_date);
.CE
.KE
Then is_later has the value FALSE.
.IP "SEE ALSO"
\f(HODate::INITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibri Reference Manual''Interval::IsLonger'"
.EH "'Interval::IsLonger''CoLibri Reference Manual'"
.bp
.NX 4 "IsLonger"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsLonger ( IN operand : Interval ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsLonger\fP tests whether the current interval is longer than
\f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the current interval is longer than
\f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date       : Date::Date;
VAR end_date         : Date::Date;
VAR interval         : Interval::Interval;
VAR other_start_date : Date::Date;
VAR other_end_date   : Date::Date;
VAR other_interval   : Interval::Interval;
VAR is_longer        : BOOL;
\&...
start_date       := NEW Date::Date (1992, 1, 1);
end_date         := NEW Date::Date (1992, 2, 1);
interval         := NEW Interval::Interval (start_date, end_date);
other_start_date := NEW Date::Date (1992, 1, 10);
other_end_date   := NEW Date::Date (1992, 1, 20);
other_interval   := NEW Interval::Interval (other_start_date, other_end_date);
is_longer        := interval.IsLonger (other_interval);
.CE
.KE
Then is_longer has the value TRUE.
.IP "SEE ALSO"
\f(HOIsOverlapping\fP,
\f(HOIsShorter\fP
.LP
.OH "'CoLibri Reference Manual''Interval::IsOverlapping'"
.EH "'Interval::IsOverlapping''CoLibri Reference Manual'"
.bp
.NX 4 "IsOverlapping"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsOverlapping ( IN operand : Interval ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsOverlapping\fP tests whether the start date
or the end date of the current interval is between start and end date 
of \f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the start date of the current interval is
earlier than or equal to the end date of \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date       : Date::Date;
VAR end_date         : Date::Date;
VAR interval         : Interval::Interval;
VAR other_start_date : Date::Date;
VAR other_end_date   : Date::Date;
VAR other_interval   : Interval::Interval;
VAR is_overlapping   : BOOL;
\&...
start_date       := NEW Date::Date (1992, 1, 1);
end_date         := NEW Date::Date (1992, 2, 1);
interval         := NEW Interval::Interval (start_date, end_date);
other_start_date := NEW Date::Date (1992, 1, 10);
other_end_date   := NEW Date::Date (1992, 1, 20);
other_interval   := NEW Interval::Interval (other_start_date, other_end_date);
is_overlapping   := interval.IsOverlapping (other_interval);
.CE
.KE
Then is_overlapping has the value TRUE.
.IP "SEE ALSO"
\f(HOIsLonger\fP,
\f(HOIsShorter\fP
.LP
.OH "'CoLibri Reference Manual''Interval::IsPassed'"
.EH "'Interval::IsPassed''CoLibri Reference Manual'"
.bp
.NX 4 "IsPassed"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsPassed () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsPassed\fP tests whether the current interval is passed.
.IP "RETURN VALUE"
This method returns TRUE, if the current interval is passed.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date : Date::Date;
VAR end_date   : Date::Date;
VAR interval   : Interval::Interval;
VAR is_passed  : BOOL;
\&...
start_date := NEW Date::Date (1992, 1, 1);
end_date   := NEW Date::Date (1992, 2, 1);
interval   := NEW Interval::Interval (start_date, end_date);
is_passed  := interval.IsPassed ();
.CE
.KE
Then is_passed has the value TRUE.
.IP "SEE ALSO"
\f(HOIsActual\fP
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP
.LP
.OH "'CoLibri Reference Manual''Interval::IsShorter'"
.EH "'Interval::IsShorter''CoLibri Reference Manual'"
.bp
.NX 4 "IsShorter"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsShorter ( IN operand : Interval ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsShorter\fP tests whether the current interval is shorter
than \f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the current interval is shorter than
\f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date       : Date::Date;
VAR end_date         : Date::Date;
VAR interval         : Interval::Interval;
VAR other_start_date : Date::Date;
VAR other_end_date   : Date::Date;
VAR other_interval   : Interval::Interval;
VAR is_shorter       : BOOL;
\&...
start_date       := NEW Date::Date (1992, 1, 1);
end_date         := NEW Date::Date (1992, 2, 1);
interval         := NEW Interval::Interval (start_date, end_date);
other_start_date := NEW Date::Date (1992, 1, 10);
other_end_date   := NEW Date::Date (1992, 1, 20);
other_interval   := NEW Interval::Interval 
.in +12
(other_start_date, other_end_date);
.in -12
is_shorter       := interval.IsShorter (other_interval);
.CE
.KE
Then is_shorter has the value FALSE.
.IP "SEE ALSO"
\f(HOIsLonger\fP
\f(HOIsOverlapping\fP
.LP
.OH "'CoLibri Reference Manual''Interval::IsStartInSameDay'"
.EH "'Interval::IsStartInSameDay''CoLibri Reference Manual'"
.bp
.NX 4 "IsStartInSameDay"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsStartInSameDay ( IN operand : Interval ) : BOOL;\fP
.sp
.IP DESCRIPTION
The method \f(HOIsStartInSameDay\fP tests whether the day (and month and year)
of the start date of the current interval is equal to the day (and month and
year) of the start date of \f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the day (and month and year) of the start date of
the current interval is equal to the day (and month and year) of the start
date of \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date           : Date::Date;
VAR end_date             : Date::Date;
VAR interval             : Interval::Interval;
VAR other_start_date     : Date::Date;
VAR other_end_date       : Date::Date;
VAR other_interval       : Interval::Interval;
VAR is_start_is_same_day : BOOL;
\&...
start_date           := NEW Date::Date (1992, 1, 1);
end_date             := NEW Date::Date (1992, 2, 1);
interval             := NEW Interval::Interval (start_date, end_date);
other_start_date     := NEW Date::Date (1992, 1, 10);
other_end_date       := NEW Date::Date (1992, 2, 2);
other_interval       := NEW Interval::Interval 
.in +12
(other_start_date, other_end_date);
.in -12
is_start_is_same_day := interval.IsStartInSameDay (other_interval);
.CE
.KE
Then is_start_is_same_day has the value FALSE.
.IP "SEE ALSO"
\f(HOIsStartInSameMonth\fP,
\f(HOIsStartInSameWeek\fP,
\f(HOIsStartInSameYear\fP
.LP
.OH "'CoLibri Reference Manual''Interval::IsStartInSameMonth'"
.EH "'Interval::IsStartInSameMonth''CoLibri Reference Manual'"
.bp
.NX 4 "IsStartInSameMonth"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsStartInSameMonth ( IN operand : Interval ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsStartInSameMonth\fP tests whether the month (and year) of
the start date of the current interval is equal to the month (and year) of the
start date of \f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the month (and year) of the start date of the
current interval is equal to the month (and year) of the start date of
\f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date             : Date::Date;
VAR end_date               : Date::Date;
VAR interval               : Interval::Interval;
VAR other_start_date       : Date::Date;
VAR other_end_date         : Date::Date;
VAR other_interval         : Interval::Interval;
VAR is_start_in_same_month : BOOL;
\&...
start_date             := NEW Date::Date (1992, 1, 1);
end_date               := NEW Date::Date (1992, 2, 1);
interval               := NEW Interval::Interval (start_date, end_date);
other_start_date       := NEW Date::Date (1992, 1, 10);
other_end_date         := NEW Date::Date (1992, 2, 2);
other_interval         := NEW Interval::Interval 
.in +12
(other_start_date, other_end_date);
.in -12
is_start_in_same_month := interval.IsStartInSameMonth (other_interval);
.CE
.KE
Then is_start_in_same_month has the value TRUE.
.IP "SEE ALSO"
\f(HOIsStartInSameDay\fP,
\f(HOIsStartInSameWeek\fP,
\f(HOIsStartInSameYear\fP
.LP
.OH "'CoLibri Reference Manual''Interval::IsStartInSameWeek'"
.EH "'Interval::IsStartInSameWeek''CoLibri Reference Manual'"
.bp
.NX 4 "IsStartInSameWeek"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsStartInSameWeek ( IN operand : Interval ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsStartInSameWeek\fP tests whether the start date of the
current interval is in the same week (and year) as the start date of
\f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the start date of the current interval is in the
same week (and year) as the start date of \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date            : Date::Date;
VAR end_date              : Date::Date;
VAR interval              : Interval::Interval;
VAR other_start_date      : Date::Date;
VAR other_end_date        : Date::Date;
VAR other_interval        : Interval::Interval;
VAR in_start_in_same_week : BOOL;
\&...
start_date            := NEW Date::Date (1992, 1, 1);
end_date              := NEW Date::Date (1992, 2, 1);
interval              := NEW Interval::Interval (start_date, end_date);
other_start_date      := NEW Date::Date (1992, 1, 10);
other_end_date        := NEW Date::Date (1992, 2, 2);
other_interval        := NEW Interval::Interval 
.in +12
(other_start_date, other_end_date);
.in -12
in_start_in_same_week := interval.IsStartInSameWeek (other_interval);
.CE
.KE
Then in_start_in_same_week has the value FALSE.
.IP "SEE ALSO"
\f(HOIsStartInSameDay\fP,
\f(HOIsStartInSameMonth\fP,
\f(HOIsStartInSameYear\fP
.LP
.OH "'CoLibri Reference Manual''Interval::IsStartInSameYear'"
.EH "'Interval::IsStartInSameYear''CoLibri Reference Manual'"
.bp
.NX 4 "IsStartInSameYear"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsStartInSameYear ( IN operand : Interval ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsStartInSameYear\fP tests whether the year of the start date
of the current interval is equal to the year of the start date of
\f(HOoperand\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the year of the start date of the current
interval is equal to the year of the start date of \f(HOoperand\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR start_date            : Date::Date;
VAR end_date              : Date::Date;
VAR interval              : Interval::Interval;
VAR other_start_date      : Date::Date;
VAR other_end_date        : Date::Date;
VAR other_interval        : Interval::Interval;
VAR is_start_in_same_year : BOOL;
\&...
start_date            := NEW Date::Date (1992, 1, 1);
end_date              := NEW Date::Date (1992, 2, 1);
interval              := NEW Interval::Interval (start_date, end_date);
other_start_date      := NEW Date::Date (1992, 1, 10);
other_end_date        := NEW Date::Date (1992, 2, 2);
other_interval        := NEW Interval::Interval 
.in +12
(other_start_date, other_end_date);
.in -12
is_start_in_same_year := interval.IsStartInSameYear (other_interval);
.CE
.KE
Then is_start_in_same_year has the value TRUE.
.IP "SEE ALSO"
\f(HOIsStartInSameDay\fP,
\f(HOIsStartInSameMonth\fP,
\f(HOIsStartInSameWeek\fP
.LP
.OH "'CoLibri Reference Manual''Interval::SetEnd'"
.EH "'Interval::SetEnd''CoLibri Reference Manual'"
.bp
.NX 4 "SetEnd"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD SetEnd ( IN end : Date );\fP
.IP DESCRIPTION
The method \f(HOSetEnd\fP assigns the value of the parameter \f(HOend\fP to
the current object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeInterval\fP"
is raised, if \f(HOend\fP is earlier than the start date.
.KS
.IP EXAMPLES
.CS L
VAR start_date   : Date::Date;
VAR end_date     : Date::Date;
VAR interval     : Interval::Interval;
VAR new_end_date : Date::Date;
\&...
start_date   := NEW Date::Date (1992, 1, 1);
end_date     := NEW Date::Date (1992, 2, 1);
interval     := NEW Interval::Interval (start_date, end_date);
new_end_date := NEW Date::Date (1992, 2, 10);
interval.SetEnd (new_end_date);
.CE
.KE
Then interval contains the interval from 01.01.1992 to 10.02.1992.
.IP "SEE ALSO"
\f(HODate::INITIALLY\fP,
\f(HOSetStart\fP
.LP
.OH "'CoLibri Reference Manual''Interval::SetStart'"
.EH "'Interval::SetStart''CoLibri Reference Manual'"
.bp
.NX 4 "SetStart"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD SetStart ( IN start : Date );\fP
.IP DESCRIPTION
The method \f(HOSetStart\fP assigns the value of the parameter \f(HOstart\fP
to the current object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeInterval\fP"
is raised, if \f(HOstart\fP is later than the end date.
.KS
.IP EXAMPLES
.CS L
VAR start_date     : Date::Date;
VAR end_date       : Date::Date;
VAR interval       : Interval::Interval;
VAR new_start_date : Date::Date;
\&...
start_date     := NEW Date::Date (1992, 1, 1);
end_date       := NEW Date::Date (1992, 2, 1);
interval       := NEW Interval::Interval (start_date, end_date);
new_start_date := NEW Date::Date (1992, 1, 10);
interval.SetStart (new_start_date);
.CE
.KE
Then interval contains the interval from 10.01.1992 to 01.02.1992.
.IP "SEE ALSO"
\f(HODate::INITIALLY\fP,
\f(HOSetEnd\fP
.LP
.OH "'CoLibri Reference Manual''Interval::Subtract'"
.EH "'Interval::Subtract''CoLibri Reference Manual'"
.bp
.NX 4 "Subtract"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD Subtract ( IN extent : Duration );\fP
.IP DESCRIPTION
The method \f(HOSubtract\fP subtracts \f(HOextent\fP from the start and end
date of the current interval.
.KS
.IP EXAMPLES
.CS L
VAR start_date : Date::Date;
VAR end_date   : Date::Date;
VAR interval   : Interval::Interval;
VAR duration   : Duration::Duration;
\&...
start_date := NEW Date::Date (1992, 1, 1);
end_date   := NEW Date::Date (1992, 2, 1);
interval   := NEW Interval::Interval (start_date, end_date);
duration   := NEW Duration::Duration (10, 0, 0, 0);
interval.Subtract (duration);
.CE
.KE
Then interval contains the interval from 22.12.1991 to 22.01.1992.
.IP "SEE ALSO"
\f(HOAdd\fP,
\f(HOAddToEnd\fP,
\f(HOAddToStart\fP,
\f(HODuration\fP,
\f(HOSubtractFromEnd\fP,
\f(HOSubtractFromStart\fP
.LP
.OH "'CoLibri Reference Manual''Interval::SubtractFromEnd'"
.EH "'Interval::SubtractFromEnd''CoLibri Reference Manual'"
.bp
.NX 4 "SubtractFromEnd"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD SubtractFromEnd ( IN extent : Duration );\fP
.IP DESCRIPTION
The method \f(HOSubtractFromEnd\fP subtracts \f(HOextent\fP from the end date
of the current interval.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeInterval\fP"
is raised, if the calculated end date is earlier than the start date.
.KS
.IP EXAMPLES
.CS L
VAR start_date : Date::Date;
VAR end_date   : Date::Date;
VAR interval   : Interval::Interval;
VAR duration   : Duration::Duration;
\&...
start_date := NEW Date::Date (1992, 1, 1);
end_date   := NEW Date::Date (1992, 2, 1);
interval   := NEW Interval::Interval (start_date, end_date);
duration   := NEW Duration::Duration (10, 0, 0, 0);
interval.SubtractFromEnd (duration);
.CE
.KE
Then interval contains the interval from 01.01.1992 to 22.01.1992.
.IP "SEE ALSO"
\f(HOAdd\fP,
\f(HOAddToEnd\fP,
\f(HOAddToStart\fP,
\f(HODuration\fP,
\f(HOSubtract\fP,
\f(HOSubtractFromStart\fP
.LP
.OH "'CoLibri Reference Manual''Interval::SubtractFromStart'"
.EH "'Interval::SubtractFromStart''CoLibri Reference Manual'"
.bp
.NX 4 "SubtractFromStart"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD SubtractFromStart ( IN extent : Duration );\fP
.IP DESCRIPTION
The method \f(HOSubtractFromStart\fP subtracts \f(HOextent\fP from the start
date of the current interval.
.KS
.IP EXAMPLES
.CS L
VAR start_date : Date::Date;
VAR end_date   : Date::Date;
VAR interval   : Interval::Interval;
VAR duration   : Duration::Duration;
\&...
start_date := NEW Date::Date (1992, 1, 1);
end_date   := NEW Date::Date (1992, 2, 1);
interval   := NEW Interval::Interval (start_date, end_date);
duration   := NEW Duration::Duration (10, 0, 0, 0);
interval.SubtractFromStart (duration);
.CE
.KE
Then interval contains the interval from 22.12.1991 to 01.02.1992.
.IP "SEE ALSO"
\f(HOAdd\fP,
\f(HOAddToEnd\fP,
\f(HOAddToStart\fP,
\f(HODuration\fP,
\f(HOSubtract\fP,
\f(HOSubtractFromEnd\fP
.LP
.OH "'CoLibri Reference Manual''Interval::Unite'"
.EH "'Interval::Unite''CoLibri Reference Manual'"
.bp
.NX 4 "Unite"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD Unite ( IN operand : Interval );\fP
.IP DESCRIPTION
The method \f(HOUnite\fP unites the current interval with \f(HOoperand\fP.
The new start date of the current interval is the earliest start date of both
intervals, the new end date of the current interval is the latest end date of
both intervals.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONoOverlap\fP"
is raised, if the current interval and \f(HOoperand\fP do not overlap 
each other.
.KS
.IP EXAMPLES
.CS L
VAR start_date       : Date::Date;
VAR end_date         : Date::Date;
VAR interval         : Interval::Interval;
VAR other_start_date : Date::Date;
VAR other_end_date   : Date::Date;
VAR other_interval   : Interval::Interval;
\&...
start_date       := NEW Date::Date (1992, 1, 1);
end_date         := NEW Date::Date (1992, 2, 1);
interval         := NEW Interval::Interval (start_date, end_date);
other_start_date := NEW Date::Date (1992, 1, 10);
other_end_date   := NEW Date::Date (1992, 2, 15);
other_interval   := NEW Interval::Interval 
.in +12
(other_start_date, other_end_date);
.in -12
interval.Unite (other_interval);
.CE
.KE
Then interval contains the interval from 01.01.1992 to 15.02.1992.
.IP "SEE ALSO"
\f(HOIntersect\fP
.LP
.OH "'CoLibri Reference Manual''Interval'"
.EH "'Interval''CoLibri Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HOInterval\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
INITIALLY$IN$start$Date$NegativeInterval
$IN$end$Date$
$result$$Interval$
_
Add$IN$extent$Duration$
_
AddToEnd$IN$extent$Duration$
_
AddToStart$IN$extent$Duration$NegativeInterval
_
Contains$IN$operand$Interval$
$result$$BOOL$
_
ContainsDate$IN$operand$Date$
$result$$BOOL$
_
Copy$result$$Interval$
_
GetEnd$result$$Date$
_
GetLength$result$$Duration$
_
GetStart$result$$Date$
_
Intersect$IN$operand$Interval$NoOverlap
_
IsActual$result$$BOOL$
_
IsEarlier$IN$operand$Date$
$result$$BOOL$
_
IsEndInSameDay$IN$operand$Interval$
$result$$BOOL$
_
IsEndInSameMonth$IN$operand$Interval$
$result$$BOOL$
_
IsEndInSameWeek$IN$operand$Interval$
$result$$BOOL$
_
IsEndInSameYear$IN$operand$Interval$
$result$$BOOL$
_
IsEqual$IN$operand$Interval$
$result$$BOOL$
_
IsInFuture$result$$BOOL$
_
IsLater$IN$operand$Date$
$result$$BOOL$
.TE
.NL
.nr PS 12
.KE
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
IsLonger$IN$operand$Interval$
$result$$BOOL
_
IsOverlapping$IN$operand$Interval$
$result$$BOOL$
_
IsPassed$result$$BOOL$
_
IsShorter$IN$operand$Interval$
$result$$BOOL$
_
IsStartInSameDay$IN$operand$Interval$
$result$$BOOL$
_
IsStartInSameMonth$IN$operand$Interval$
$result$$BOOL$
_
IsStartInSameWeek$IN$operand$Interval$
$result$$BOOL$
_
IsStartInSameYear$IN$operand$Interval$
$result$$BOOL$
_
SetEnd$IN$end$Date$NegativeInterval
_
SetStart$IN$start$Date$NegativeInterval
_
Subtract$IN$extent$Duration$
_
SubtractFromEnd$IN$extent$Duration$NegativeInterval
_
SubtractFromStart$IN$extent$Duration$
_
Unite$IN$operand$Interval$NoOverlap
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''Map'"
.EH "'Map''CoLibri Reference Manual'"
.bp
.NX 2 "Map"
.sp
.NX 3 "Type Description"
.sp
\f(HOMap\fP is a generic object type representing a container consisting of an
arbitrary number of elements.
Each element consists of a unique key value and a related entry value.
The key values are unique within a map.
A strong order must be defined for the key values.
This object type offers methods to insert, delete, retrieve or replace
elements and to split or merge maps.
Moreover this type provides a cursor which allows to navigate through the
elements of a map and to retrieve the contents of the elements.
.sp
The types of the key and entry values must be specified by the application
programmer to get a special \f(HOMap\fP type if a variable of type
\f(HOMap\fP must be declared.
.sp 0.5
.IP NOTE
If the key type is an object type, the key values which
are used to keep the order may not be changed.
.LP
.sp 0.5
The general features of any \f(HOMap\fP type are described using the
following syntax:
.TS
tab($);
l l l.
String$Description$Example
_
Map$name of the special \f(HOMap\fP type$ClientMap
KeyType$type of the key values$PersonalNumber
EntryType$type of the entry values$PersonalName
.TE
.sp
.NX 3 "List of Methods"
.sp
The following methods are available in \f(HO<Map.cs>\fP:
.TS
tab($);
l.
Method name
_
Apply
Contains
GetEntry
GetEntryAtCursor
GetKeyAtCursor
GetNumberOfElements
GetNumberOfMatches
InsertElement
IsEmpty
IsEqual
IsFirst
IsLast
Merge
RemoveElement
ReplaceEntry
SetCursorToElement
SetCursorToFirst
SetCursorToLast
SetCursorToNext
SetCursorToPrevious
SetEntryAtCursor
Split
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each method described below the exceptions which will be raised in case
of an error are listed.
.sp
The following exceptions can be raised using module \f(HOMap\fP :
.TS
tab($);
l.
exception name
_
ContainerEmpty
CursorUndefined
BTree::KeyAlreadyExists
BTree::KeyNotFound
BTree::NoNextElement
BTree::NoPreviousElement
.TE
.sp
.NX 3 "How to use Map"
.sp
A variable of type \f(HOMap\fP is declared as follows:
.CS L
VAR person_map : Map [PersonMapKeyType, PersonMapEntryType];
.CE
.sp 0.5
A variable of type \f(HOMap\fP can be initialized using the CooL constructor
NEW.
.sp
A sub type of type \f(HOMap\fP is declared as follows:
.CS L
TYPE PersonMap [KeyType, EntryType, ...] = Map OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL module which uses the type \f(HOMap\fP must import the module
\f(HOMap\fP:
.CS L
IMPORT ..., Map, ...;
.CE
.sp 0.5
.NX 3 "Method Description"
.sp
The following sections contain the syntactical and semantical description of
all methods provided by \f(HOMap\fP.
They are listed in alphabetical order.
.sp
.KS
The examples are based on a generic object type of type \f(HOMap\fP:
.CS L
TYPE IntObject = OBJECT( IN number : INT )
PUBLIC
  METHOD Get : INT;
  METHOD Put( IN number : INT );
PROTECTED
STATE
  integer : INT;
BODY
  INITIALLY( IN number : INT )
  DO
    integer := number;
  END DO;

  METHOD Get : INT
  DO 
    RETURN integer;
  END DO;

  METHOD Put( IN number : INT )
  DO
    integer := number;
  END DO;
END OBJECT;

TYPE StringObject = OBJECT( IN str : STRING )
PUBLIC
  METHOD Get : STRING;
  METHOD Put( IN str : STRING );
PROTECTED
STATE
  string : STRING;
BODY
  INITIALLY( IN str : STRING )
  DO
    string := str;
  END DO;

  METHOD Get : STRING
  DO 
    RETURN string;
  END DO;

  METHOD Put( IN str : STRING )
  DO
    string := str;
  END DO;
END OBJECT;

\&...

VAR person_map : Map::Map [IntObject, StringObject];
.CE
.KE
.sp 0.5
It is assumed that this special \f(HOMap\fP type contains the following
elements as objects:
.TS
tab($);
l l.
Key value$Entry value
_
13$John Wayne
17$Marilyn Monroe
99$peter stuyvesant
.TE
.LP
.OH "'CoLibri Reference Manual''Map::INITIALLY'"
.EH "'Map::INITIALLY''CoLibri Reference Manual'"
`.bp
.NX 4 "INITIALLY"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l0 l.
\f(HBINITIALLY $:$ Map $$[KeyType, EntryType];\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW.
The parameters \f(HOless\fP and \f(HOequal\fP specify the order and equality
of the key values of the current object.
The procedure \f(HOless\fP is used for the correct placement of an element in
a map, the procedure \f(HOequal\fP is used for the correct access to an
element in a map.
The cursor is not defined after a new map is created.
.IP "RETURN VALUE"
This method returns a new object of this type.
.KS
.IP EXAMPLES
.CS L
\&...
VAR person_map : Map::Map [IntObject, StringObject];
\&...
person_map := NEW Map::Map [IntObject, StringObject];
.CE
.KE
.IP "SEE ALSO"
\f(HOMerge\fP
.LP
.OH "'CoLibri Reference Manual''Map::Apply'"
.EH "'Map::Apply''CoLibri Reference Manual'"
.bp
.NX 4 "Apply"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD Apply ( IN routine : PROCEDURE ( INOUT EntryType ) );\fP
.IP DESCRIPTION
The method \f(HOApply\fP applies \f(HOroutine\fP to the entry values of all
elements of the current map.
The entry values can be modified by \f(HOroutine\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current map is empty.
.KS
.IP EXAMPLES
.CS L
PROCEDURE ToUpper ( INOUT string : StringObject )
DO
   -- This procedure converts small letters to
   -- capital letters.
END DO;
\&...
VAR person_map : Map::Map [IntObject, StringObject];
\&...
person_map.Apply (ToUpper);
.CE
.KE
Then the entry values of all elements of person_map are converted to capital
letters.
.LP
.OH "'CoLibri Reference Manual''Map::Contains'"
.EH "'Map::Contains''CoLibri Reference Manual'"
.bp
.NX 4 "Contains"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD Contains ( IN key : KeyType ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOContains\fP tests whether the current map contains an element
with the key value \f(HOkey\fP.
The procedures \f(HOequal\fP and \f(HOless\fP are used to find the element.
.IP "RETURN VALUE"
This method returns TRUE, if the current map contains an element with the key
value \f(HOkey\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR person_map : Map::Map [IntObject, StringObject];
VAR key_value  : IntObject;
VAR contains   : BOOL;
\&...
key_value.Put( 17 );
contains  := person_map.Contains (key_value);
.CE
.KE
Then contains has the value TRUE.
.LP
.OH "'CoLibri Reference Manual''Map::GetEntry'"
.EH "'Map::GetEntry''CoLibri Reference Manual'"
.bp
.NX 4 "GetEntry"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD GetEntry ( IN key : KeyType ) : EntryType;\fP
.IP DESCRIPTION
The method \f(HOGetEntry\fP returns the entry value related to the key value
\f(HOkey\fP of the current map.
The procedure \f(HOequal\fP is used to find the element.
.IP "RETURN VALUE"
This method returns the entry value related to the key value \f(HOkey\fP of
the current map.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current map is empty.
.IP "\(bu \f(HOKeyNotFound\fP"
is raised, if the current map does not contain an element with the key 
value \f(HOkey\fP.
.KS
.IP EXAMPLES
.CS L
VAR person_map  : Map::Map [IntObject, StringObject];
VAR key_value   : IntObject;
VAR entry_value : StringObject;
\&...
key_value.Put( 17 );
entry_value := person_map.GetEntry (key_value);
.CE
.KE
Then entry_value has the value "Marilyn Monroe".
.IP "SEE ALSO"
\f(HOGetEntryAtCursor\fP,
\f(HOGetKeyAtCursor\fP
.LP
.OH "'CoLibri Reference Manual''Map::GetEntryAtCursor'"
.EH "'Map::GetEntryAtCursor''CoLibri Reference Manual'"
.bp
.NX 4 "GetEntryAtCursor"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD GetEntryAtCursor () : EntryType;\fP
.IP DESCRIPTION
The method \f(HOGetEntryAtCursor\fP returns the entry value of the element of
the current map at the actual cursor position.
.IP "RETURN VALUE"
This method returns the entry value of the element of the current map at the
actual cursor position.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOCursorUndefined\fP"
is raised, if the cursor is not defined.
.KS
.IP EXAMPLES
.CS L
VAR person_map  : Map::Map [IntObject, StringObject];
VAR entry_value : StringObject;
\&...
person_map.SetCursorToFirst ();
entry_value := person_map.GetEntryAtCursor ();
.CE
.KE
Then entry_value has the value "John Wayne".
.IP "SEE ALSO"
\f(HOGetEntry\fP,
\f(HOGetKeyAtCursor\fP
.LP
.OH "'CoLibri Reference Manual''Map::GetKeyAtCursor'"
.EH "'Map::GetKeyAtCursor''CoLibri Reference Manual'"
.bp
.NX 4 "GetKeyAtCursor"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD GetKeyAtCursor () : KeyType;\fP
.IP DESCRIPTION
The method \f(HOGetKeyAtCursor\fP returns the key value of the element of
the current map at the actual cursor position.
.IP "RETURN VALUE"
This method returns the key value of the element of the current map at the
actual cursor position.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOCursorUndefined\fP"
is raised, if the cursor is not defined.
.KS
.IP EXAMPLES
.CS L
VAR person_map  : Map::Map [IntObject, StringObject];
VAR key_value   : IntObject;
\&...
person_map.SetCursorToFirst ();
key_value := person_map.GetKeyAtCursor ();
.CE
.KE
Then key_value has the value 13.
.IP "SEE ALSO"
\f(HOGetEntry\fP,
\f(HOGetEntryAtCursor\fP
.LP
.OH "'CoLibri Reference Manual''Map::GetNumberOfElements'"
.EH "'Map::GetNumberOfElements''CoLibri Reference Manual'"
.bp
.NX 4 "GetNumberOfElements"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD GetNumberOfElements () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetNumberOfElements\fP returns the number of elements of the
current map.
.IP "RETURN VALUE"
This method returns the number of elements of the current map.
.KS
.IP EXAMPLES
.CS L
VAR person_map         : Map::Map [IntObject, StringObject];
VAR number_of_elements : INT;
\&...
number_of_elements := person_map.GetNumberOfElements ();
.CE
.KE
Then number_of_elements has the value 3.
.IP "SEE ALSO"
\f(HOGetNumberOfMatches\fP
.LP
.OH "'CoLibri Reference Manual''Map::GetNumberOfMatches'"
.EH "'Map::GetNumberOfMatches''CoLibri Reference Manual'"
.bp
.NX 4 "GetNumberOfMatches"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBMETHOD GetNumberOfMatches ($ IN $ predicate : PROCEDURE
$$( IN EntryType ) : BOOL )
$:$ INT;\fP
.TE
.IP DESCRIPTION
The method \f(HOGetNumberOfMatches\fP returns the number of elements of the
current map which satisfy \f(HOpredicate\fP.
.IP "RETURN VALUE"
This method returns the number of elements of the current map which satisfy
\f(HOpredicate\fP.
.KS
.IP EXAMPLES
.CS L
PROCEDURE checkFirstChar ( IN string : StringObject ) : BOOL
DO
   -- This procedure returns TRUE, if Name starts with a
   -- capital letter. Otherwise it returns FALSE.
END DO;
\&...
VAR person_map        : Map::Map [IntObject, StringObject];
VAR number_of_matches : INT;
\&...
number_of_matches := person_map.GetNumberOfMatches (checkFirstChar);
.CE
.KE
Then number_of_matches has the value 2.
.IP "SEE ALSO"
\f(HOGetNumberOfElements\fP
.LP
.OH "'CoLibri Reference Manual''Map::InsertElement'"
.EH "'Map::InsertElement''CoLibri Reference Manual'"
.bp
.NX 4 "InsertElement"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBMETHOD InsertElement ($ IN key $ : KeyType,
$ IN entry $ : EntryType );\fP
.TE
.IP DESCRIPTION
The method \f(HOInsertElement\fP inserts the element with the key value
\f(HOkey\fP and the entry value \f(HOentry\fP into the current map.
The procedure \f(HOless\fP is used to find the position of the new element.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOKeyAlreadyExists\fP"
is raised, if the current map contains an element with a key value equal
to \f(HOkey\fP.
.KS
.IP EXAMPLES
.CS L
VAR person_map : Map::Map [IntObject, StringObject];
VAR new_key    : IntObject;
VAR new_entry  : StringObject;
\&...
new_key.Put( 100 );
new_entry.Put( "Tarzan" );
person_map.InsertElement (new_key, new_entry);
.CE
.KE
Then the element with the key value 100 and the entry value "Tarzan" is
inserted into person_map.
.IP "SEE ALSO"
\f(HOMerge\fP,
\f(HORemoveElement\fP,
\f(HOReplaceEntry\fP
.LP
.OH "'CoLibri Reference Manual''Map::IsEmpty'"
.EH "'Map::IsEmpty''CoLibri Reference Manual'"
.bp
.NX 4 "IsEmpty"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD IsEmpty () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEmpty\fP tests whether the current map is empty.
.IP "RETURN VALUE"
This method returns TRUE, if the current map is empty.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR person_map : Map::Map [IntObject, StringObject];
VAR is_empty   : BOOL;
\&...
is_empty := person_map.IsEmpty ();
.CE
.KE
Then is_empty has the value FALSE.
.LP
.OH "'CoLibri Reference Manual''Map::IsEqual'"
.EH "'Map::IsEqual''CoLibri Reference Manual'"
.bp
.NX 4 "IsEqual"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l0 l.
\f(HBMETHOD IsEqual $($ IN second_map $ : $ Map [KeyType, EntryType],
$$ IN equal_entry $ : $ PROCEDURE
$$$ ( $ IN EntryType,
$$$$ IN EntryType ) : BOOL ) 
$:$ BOOL;$$\fP
.TE
.IP DESCRIPTION
The method \f(HOIsEqual\fP tests whether the current map is equal to
\f(HOsecond_map\fP.
Two maps are equal, if they contain the same number of elements and if the
key and entry values of the elements are equal.
The procedure \f(HOequal\fP is used to compare the key values of the elements.
The procedure \f(HOequal_entry\fP is used to compare the entry values of the
elements.
.IP "RETURN VALUE"
This method returns TRUE, if the current map is equal to \f(HOsecond_map\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
PROCEDURE entriesAreEqual ( IN entry1 : StringObject, IN entry2 : StringObject ) : BOOL
DO
   -- This procedure returns TRUE, if entry1 is equal to entry2.
   -- Otherwise it returns FALSE.
END DO;
\&...
VAR person_map : Map::Map [IntObject, StringObject];
VAR other_map  : Map::Map [IntObject, StringObject];
VAR is_equal   : BOOL;
\&...
other_map := NEW Map::Map [IntObject, StringObject] (lessPersonMap, equalPersonMap);
is_equal  := person_map.IsEqual (other_map, entriesAreEqual);
.CE
.KE
Then is_equal has the value FALSE since other_map contains no elements.
.LP
.OH "'CoLibri Reference Manual''Map::IsFirst'"
.EH "'Map::IsFirst''CoLibri Reference Manual'"
.bp
.NX 4 "IsFirst"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD IsFirst () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsFirst\fP tests whether the cursor points to the first
element of current map.
.IP "RETURN VALUE"
This method returns TRUE, if the cursor points to the first element of the
current map.
Otherwise it returns FALSE.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOCursorUndefined\fP"
is raised, if the cursor is not defined.
.KS
.IP EXAMPLES
.CS L
VAR person_map : Map::Map [IntObject, StringObject];
VAR is_first   : BOOL;
\&...
person_map := NEW Map::Map [IntObject, StringObject] (lessPersonMap, equalPersonMap);
is_first := person_map.IsFirst ();
.CE
.KE
Then the exception \f(HOCursorUndefined\fP is raised, since the cursor is not 
defined.
.IP "SEE ALSO"
\f(HOIsLast\fP
.LP
.OH "'CoLibri Reference Manual''Map::IsLast'"
.EH "'Map::IsLast''CoLibri Reference Manual'"
.bp
.NX 4 "IsLast"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD IsLast () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsLast\fP tests whether the cursor points to the last
element of current map.
.IP "RETURN VALUE"
This method returns TRUE, if the cursor points to the last element of the
current map.
Otherwise it returns FALSE.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOCursorUndefined\fP'
is raised, if the cursor is not defined.
.KS
.IP EXAMPLES
.CS L
VAR person_map : Map::Map [IntObject, StringObject];
VAR isLast     : BOOL;
\&...
person_map := NEW Map::Map [IntObject, StringObject] (lessPersonMap, equalPersonMap);
isLast := person_map.IsLast ();
.CE
.KE
Then the exception \f(HOCursorUndefined\fP is raised, since the cursor is not 
defined.
.IP "SEE ALSO"
\f(HOIsFirst\fP
.LP
.OH "'CoLibri Reference Manual''Map::Merge'"
.EH "'Map::Merge''CoLibri Reference Manual'"
.bp
.NX 4 "Merge"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD Merge ( IN second_map : Map [KeyType, EntryType] );\fP
.IP DESCRIPTION
The method \f(HOMerge\fP inserts all elements of \f(HOsecond_map\fP into the
current map.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOKeyAlreadyExists\fP"
is raised, if the current map contains an element with a key value equal
to the key value of an element of \f(HOsecond_map\fP.
.KS
.IP EXAMPLES
.CS L
VAR person_map : Map::Map [IntObject, StringObject];
VAR other_map  : Map::Map [IntObject, StringObject];
VAR new_key    : IntObject;
VAR new_entry  : StringObject;
\&...
other_map := NEW Map::Map [IntObject, StringObject] 
.in +12
(lessPersonMap, equalPersonMap);
.in -12
new_key.Put( 100 );
new_entry.Put( "Tarzan" );
other_map.InsertElement (new_key, new_entry);
person_map.Merge (other_map);
.CE
.KE
After the merge of the other_map with the person_map, the person_map also
contains the element with the key value 100 and the entry value "Tarzan".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOInsertElement\fP,
\f(HOSplit\fP
.LP
.OH "'CoLibri Reference Manual''Map::RemoveElement'"
.EH "'Map::RemoveElement''CoLibri Reference Manual'"
.bp
.NX 4 "RemoveElement"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD RemoveElement ( IN key : KeyType );\fP
.IP DESCRIPTION
The method \f(HORemoveElement\fP removes the element with the key value
\f(HOkey\fP from the current map.
The procedure \f(HOequal\fP is used to find the element.
The cursor may not point to the element with the key value \f(HOkey\fP since
it would be undefined after the element is removed.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current map is empty.
.IP "\(bu \f(HOKeyNotFound\fP"
is raised, if the current map does not contain an element with the key 
value \f(HOkey\fP.
.KS
.IP EXAMPLES
.CS L
VAR person_map : Map::Map [IntObject, StringObject];
VAR key_value  : IntObject;
\&...
key_value.Put( 99 );
person_map.RemoveElement (key_value);
.CE
.KE
Then the element with the key value 99 is removed from person_map.
.IP "SEE ALSO"
\f(HOInsertElement\fP,
\f(HOReplaceEntry\fP
.LP
.OH "'CoLibri Reference Manual''Map::ReplaceEntry'"
.EH "'Map::ReplaceEntry''CoLibri Reference Manual'"
.bp
.NX 4 "ReplaceEntry"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBMETHOD ReplaceEntry ($ IN key $ : KeyType,
$ IN entry $ : EntryType );
.TE
.IP DESCRIPTION
The method \f(HOReplaceEntry\fP replaces the entry value of the element with
the key value \f(HOkey\fP by \f(HOentry\fP in the current map.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current map is empty.
.IP "\(bu \f(HOKeyNotFound\fP"
is raised, if the current map does not contain an element with the key 
value \f(HOkey\fP.
.KS
.IP EXAMPLES
.CS L
VAR person_map : Map::Map [IntObject, StringObject];
VAR key_value  : IntObject;
VAR new_entry  : StringObject;
\&...
key_value.Put( 13 );
new_entry.Put( "Humphrey Bogart" );
person_map.ReplaceEntry (key_value, new_entry);
.CE
.KE
Then person_map contains "Humphrey Bogart" instead of "John Wayne".
.IP "SEE ALSO"
\f(HOInsertElement\fP,
\f(HORemoveElement\fP,
\f(HOSetEntryAtCursor\fP
.LP
.OH "'CoLibri Reference Manual''Map::SetCursorToElement'"
.EH "'Map::SetCursorToElement''CoLibri Reference Manual'"
.bp
.NX 4 "SetCursorToElement"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD SetCursorToElement ( IN key : KeyType );\fP
.IP DESCRIPTION
The method \f(HOSetCursorToElement\fP moves the cursor to the element with the
key value \f(HOkey\fP of the current map.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current map is empty.
.IP "\(bu \f(HOKeyNotFound\fP"
is raised, if the current map does not contain an element with the key 
value \f(HOkey\fP.
.KS
.IP EXAMPLES
.CS L
VAR person_map : Map::Map [IntObject, StringObject];
VAR key_value  : IntObject;
\&...
key_value.Put( 17 );
person_map.SetCursorToElement (key_value);
.CE
.KE
Then the cursor points to the element with the key value 17.
.IP "SEE ALSO"
\f(HOSetCursorToFirst\fP,
\f(HOSetCursorToLast\fP,
\f(HOSetCursorToNext\fP,
\f(HOSetCursorToPrevious\fP
.LP
.OH "'CoLibri Reference Manual''Map::SetCursorToFirst'"
.EH "'Map::SetCursorToFirst''CoLibri Reference Manual'"
.bp
.NX 4 "SetCursorToFirst"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD SetCursorToFirst;\fP
.IP DESCRIPTION
The method \f(HOSetCursorToFirst\fP moves the cursor to the first element of
the current map.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current map is empty.
.KS
.IP EXAMPLES
.CS L
VAR person_map : Map::Map [IntObject, StringObject];
\&...
person_map.SetCursorToFirst ();
.CE
.KE
Then the cursor points to the element with the key value 13.
.IP "SEE ALSO"
\f(HOSetCursorToElement\fP,
\f(HOSetCursorToLast\fP,
\f(HOSetCursorToNext\fP,
\f(HOSetCursorToPrevious\fP
.LP
.OH "'CoLibri Reference Manual''Map::SetCursorToLast'"
.EH "'Map::SetCursorToLast''CoLibri Reference Manual'"
.bp
.NX 4 "SetCursorToLast"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD SetCursorToLast;\fP
.IP DESCRIPTION
The method \f(HOSetCursorToLast\fP moves the cursor to the last element of the
current map.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current map is empty.
.KS
.IP EXAMPLES
.CS L
VAR person_map : Map::Map [IntObject, StringObject];
\&...
person_map.SetCursorToLast ();
.CE
.KE
Then the cursor points to the element with the key value 99.
.IP "SEE ALSO"
\f(HOSetCursorToElement\fP,
\f(HOSetCursorToFirst\fP,
\f(HOSetCursorToNext\fP,
\f(HOSetCursorToPrevious\fP
.LP
.OH "'CoLibri Reference Manual''Map::SetCursorToNext'"
.EH "'Map::SetCursorToNext''CoLibri Reference Manual'"
.bp
.NX 4 "SetCursorToNext"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD SetCursorToNext;\fP
.IP DESCRIPTION
The method \f(HOSetCursorToNext\fP moves the cursor to the element in the
current map which follows the element at the actual cursor position.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOCursorUndefined\fP"
is raised, if the cursor is not defined.
.IP "\(bu \f(HONoNextElement\fP"
is raised, if the cursor points to the last element of the current map.
.KS
.IP EXAMPLES
.CS L
VAR person_map : Map::Map [IntObject, StringObject];
\&...
person_map.SetCursorToFirst ();
person_map.SetCursorToNext ();
.CE
.KE
Then the cursor points to the element with the key value 17.
.IP "SEE ALSO"
\f(HOSetCursorToElement\fP,
\f(HOSetCursorToFirst\fP,
\f(HOSetCursorToLast\fP,
\f(HOSetCursorToPrevious\fP
.LP
.OH "'CoLibri Reference Manual''Map::SetCursorToPrevious'"
.EH "'Map::SetCursorToPrevious''CoLibri Reference Manual'"
.bp
.NX 4 "SetCursorToPrevious"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD SetCursorToPrevious;\fP
.IP DESCRIPTION
The method \f(HOSetCursorToPrevious\fP moves the cursor to the element in the
current map which precedes the element at the actual cursor position.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOCursorUndefined\fP"
is raised, if the cursor is not defined.
.IP "\(bu \f(HONoPreviousElement\fP"
is raised, if the cursor points to the first element of the current map.
.KS
.IP EXAMPLES
.CS L
VAR person_map : Map::Map [IntObject, StringObject];
\&...
person_map.SetCursorToLast ();
person_map.SetCursorToPrevious ();
.CE
.KE
Then the cursor points to the element with the key value 17.
.IP "SEE ALSO"
\f(HOSetCursorToElement\fP,
\f(HOSetCursorToFirst\fP,
\f(HOSetCursorToLast\fP,
\f(HOSetCursorToNext\fP
.LP
.OH "'CoLibri Reference Manual''Map::SetEntryAtCursor'"
.EH "'Map::SetEntryAtCursor''CoLibri Reference Manual'"
.bp
.NX 4 "SetEntryAtCursor"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD SetEntryAtCursor ( IN entry : EntryType );\fP
.IP DESCRIPTION
The method \f(HOSetEntryAtCursor\fP assigns the value of the parameter
\f(HOentry\fP to the entry value of the element of the current map at the
actual cursor position.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOCursorUndefined\fP"
is raised, if the cursor is not defined.
.KS
.IP EXAMPLES
.CS L
VAR person_map : Map::Map [IntObject, StringObject];
VAR new_entry  : StringObject;
\&...
new_entry.Put( "Humphrey Bogart" );
person_map.SetCursorToFirst ();
person_map.SetEntryAtCursor (new_entry);
.CE
.KE
Then person_map contains "Humphrey Bogart" instead of "John Wayne".
.IP "SEE ALSO"
\f(HOReplaceEntry\fP
.LP
.OH "'CoLibri Reference Manual''Map::Split'"
.EH "'Map::Split''CoLibri Reference Manual'"
.bp
.NX 4 "Split"
.sp
.IP MODULE
\f(HBMap\fP
.IP TYPE
\f(HBMap\fP
.IP SYNOPSIS
\f(HBMETHOD Split ( IN key : KeyType ) : Map [KeyType, EntryType];\fP
.IP DESCRIPTION
The method \f(HOSplit\fP splits the current map.
All elements with key values equal to or greater than \f(HOkey\fP are removed
from the current map and inserted into the resulting map.
The cursor may not point to elements with key values equal or greater than
\f(HOkey\fP since it would be undefined after the map is splitted.
.IP "RETURN VALUE"
This method returns a new map containing all elements with key values equal to
or greater than \f(HOkey\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current map is empty.
.KS
.IP EXAMPLES
.CS L
VAR person_map : Map::Map [IntObject, StringObject];
VAR new_map    : Map::Map [IntObject, StringObject];
VAR key_value  : IntObject;
\&...
key_value.Put( 17 );
new_map := person_map.Split (key_value);
.CE
.KE
Then person_map contains the element with the key value 13, new_map the elements
with the key values 17 and 99.
.IP "SEE ALSO"
\f(HOMerge\fP
.LP
.OH "'CoLibri Reference Manual''Map'"
.EH "'Map''CoLibri Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HOMap\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
INITIALLY$IN$less$PROCEDURE$
$IN$equal$PROCEDURE$
$result$$Map [KeyType, EntryType]$
_
Apply$IN$routine$PROCEDURE$ContainerEmpty
_
Contains$IN$key$KeyType$
$result$$BOOL$
_
GetEntry$IN$key$KeyType$ContainerEmpty
$result$$EntryType$KeyNotFound
_
GetEntryAtCursor$result$$EntryType$CursorUndefined
_
GetKeyAtCursor$result$$KeyType$CursorUndefined
_
GetNumberOfElements$result$$INT$
_
GetNumberOfMatches$IN$predicate$PROCEDURE$
$result$$INT$
_
InsertElement$IN$key$KeyType$KeyAlreadyExists
$IN$entry$EntryType$
_
IsEmpty$result$$BOOL$
_
IsEqual$IN$second_map$Map [KeyType, EntryType]$
$IN$equal_entry$PROCEDURE$
$result$$BOOL$
_
IsFirst$result$$BOOL$CursorUndefined
_
IsLast$result$$BOOL$CursorUndefined
_
Merge$IN$second_map$Map [KeyType, EntryType]$KeyAlreadyExists
_
RemoveElement$IN$key$KeyType$ContainerEmpty
$$$$KeyNotFound
_
ReplaceEntry$IN$key$KeyType$ContainerEmpty
$IN$entry$EntryType$KeyNotFound
_
SetCursorToElement$IN$key$KeyType$ContainerEmpty
$$$$KeyNotFound
_
SetCursorToFirst$$$$ContainerEmpty
_
SetCursorToLast$$$$ContainerEmpty
_
SetCursorToNext$$$$CursorUndefined
$$$$NoNextElement
.TE
.NL
.nr PS 12
.KE
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
SetCursorToPrevious$$$$CursorUndefined
$$$$NoPreviousElement
_
SetEntryAtCursor$IN$entry$EntryType$CursorUndefined
_
Split$IN$key$KeyType$ContainerEmpty
$result$$Map [KeyType, EntryType]$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''List'"
.EH "'List''CoLibri Reference Manual'"
.bp
.NX 2 "List"
.sp
.NX 3 "Type Description"
.sp
\f(HOList\fP is a generic object type representing a container consisting of 
an arbitrary number of entries.
This object type offers methods to insert, delete, retrieve or replace
entries and to split or merge lists.
Moreover this type provides a cursor which allows to navigate through the
entries of a list and to retrieve the contents of the entries.
.sp
The type of the entry values must be specified by the application programmer
to get a special \f(HOList\fP type, if a variable of type \f(HOList\fP must be
declared.
.sp
The general features of any \f(HOList\fP type are described using the
following syntax:
.TS
tab($);
l l l.
String$Description$Example
_
List$name of the special \f(HOList\fP type$ClientList
EntryType$type of the entry values$PersonalName
.TE
.sp
.NX 3 "List of Methods"
.sp
The following methods are available in \f(HO<List.cs>\fP:
.TS
tab($);
l.
Method name
_
Apply
Copy
GetEntryAtCursor
GetNumberOfEntries
GetNumberOfMatches
GetPositionOfCursor
Head
InsertEntry
IsBeginMargin
IsEmpty
IsEndMargin
IsEqual
Merge
RemoveDuplicateEntries
RemoveEntry
RemoveMatchingEntries
SetCursorToBeginMargin
SetCursorToEndMargin
SetCursorToFirst
SetCursorToLast
SetCursorToNext
SetCursorToPosition
SetCursorToPrevious
SetEntryAtCursor
Split
StepToNextMatch
StepToPreviousMatch
Substitute
Tail
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each method described below the exceptions which will be raised in case
of an error are listed.
.sp
The following exceptions can be raised using module \f(HOList\fP :
.TS
tab($);
l.
exception name
_
ContainerEmpty
Node::ImpossibleDelete
Node::ImpossibleInsert
Node::NoEntry
NoMatch
Node::NoNextEntry
Node::NoPreviousEntry
PositionOutOfBounds
.TE
.sp
.NX 3 "How to use List"
.sp
A variable of type \f(HOList\fP is declared as follows:
.CS L
VAR person_list : List [PersonListEntryType];
.CE
.sp 0.5
A variable of type \f(HOList\fP can be initialized using the CooL
constructor NEW.
.sp
A sub type of type \f(HOList\fP is declared as follows:
.CS L
TYPE PersonList [EntryType, ...] = List OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL module which uses the type \f(HOList\fP must import the module
\f(HOList\fP:
.CS L
IMPORT ..., List, ...;
.CE
.sp 0.5
.NX 3 "Method Description"
.sp
The following sections contain the syntactical and semantical description of
all methods provided by \f(HOList\fP.
They are listed in alphabetical order.
.sp
The examples are based on a generic object type of type \f(HOList\fP:
.KS
.CS L
TYPE StringObject = OBJECT( IN str : STRING )
PUBLIC
  METHOD Get : STRING;
  METHOD Put( IN str : STRING );
PROTECTED
STATE
  string : STRING;
BODY
  INITIALLY( IN str : STRING )
  DO
    string := str;
  END DO;

  METHOD Get : STRING
  DO 
    RETURN string;
  END DO;

  METHOD Put( IN str : STRING )
  DO
    string := str;
  END DO;
END OBJECT;

\&...

VAR person_list : List::List [StringObject];
.CE
.KE
.sp 0.5
It is assumed that this special \f(HOList\fP type contains the following
elements as objects:
.KS
.TS
tab($);
l l.
Cursor position$Entry value
_
BeginMargin$---
1$Marilyn Monroe
2$John Wayne
3$peter stuyvesant
EndMargin$---
.TE
.KE
.OH "'CoLibri Reference Manual''List::INITIALLY'"
.EH "'List::INITIALLY''CoLibri Reference Manual'"
.bp
.NX 4 "INITIALLY"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBINITIALLY () : List [EntryType];\fP
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW.
The current object contains the two margins \f(HOBeginMargin\fP and
\f(HOEndMargin\fP.
The cursor is moved to the \f(HOBeginMargin\fP.
.IP "RETURN VALUE"
This method returns a new object of this type.
.KS
.IP EXAMPLES
.CS L
VAR person_list : List::List [StringObject];
\&...
person_list := NEW List::List [StringObject];
.CE
.KE
.IP "SEE ALSO"
\f(HOCopy\fP,
\f(HOMerge\fP
.LP
.OH "'CoLibri Reference Manual''List::Apply'"
.EH "'List::Apply''CoLibri Reference Manual'"
.bp
.NX 4 "Apply"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD Apply ( IN routine : PROCEDURE ( INOUT EntryType ) );\fP
.IP DESCRIPTION
The method \f(HOApply\fP applies \f(HOroutine\fP to all entries of the current
list starting at the actual cursor position.
The entry values can be modified by \f(HOroutine\fP.
The cursor position is not changed.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current list is empty.
.KS
.IP EXAMPLES
.CS L
PROCEDURE ToUpper ( INOUT String : StringObject)
DO
   -- This procedure converts small letters to
   -- capital letters.
END DO;
\&...
VAR person_list : List::List [StringObject];
\&...
person_list.Apply (ToUpper);
.CE
.KE
Then all entries of person_list are converted to capital letters.
.LP
.OH "'CoLibri Reference Manual''List::Copy'"
.EH "'List::Copy''CoLibri Reference Manual'"
.bp
.NX 4 "Copy"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD Copy () : List [EntryType];\fP
.IP DESCRIPTION
The method \f(HOCopy\fP creates a new object of this type containing the
state of the current object.
.IP "RETURN VALUE"
This method returns a new object of this type containing the state of the
current object.
.KS
.IP EXAMPLES
.CS L
VAR person_list : List::List [StringObject];
VAR next_list   : List::List [StringObject];
\&...
next_list := person_list.Copy ();
.CE
.KE
Then next_list contains all entries of person_list.
.IP "SEE ALSO"
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''List::GetEntryAtCursor'"
.EH "'List::GetEntryAtCursor''CoLibri Reference Manual'"
.bp
.NX 4 "GetEntryAtCursor"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD GetEntryAtCursor () : EntryType;\fP
.IP DESCRIPTION
The method \f(HOGetEntryAtCursor\fP returns the entry of the current list at
the actual cursor position.
.IP "RETURN VALUE"
This method returns the entry of the current list at the actual cursor
position.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONoEntry\fP"
is raised, if the cursor points to \f(HOBeginMargin\fP or \f(HOEndMargin\fP.
.KS
.IP EXAMPLES
.CS L
VAR person_list : List::List [StringObject];
VAR entry_value : StringObject;
\&...
person_list.SetCursorToFirst ();
entry_value := person_list.GetEntryAtCursor ();
.CE
.KE
Then entry_value has the value "Marilyn Monroe".
.IP "SEE ALSO"
\f(HOGetNumberOfEntries\fP,
\f(HOGetNumberOfMatches\fP,
\f(HOGetPositionOfCursor\fP
.LP
.OH "'CoLibri Reference Manual''List::GetNumberOfEntries'"
.EH "'List::GetNumberOfEntries''CoLibri Reference Manual'"
.bp
.NX 4 "GetNumberOfEntries"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD GetNumberOfEntries () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetNumberOfEntries\fP returns the number of entries of the
current list.
.IP "RETURN VALUE"
This method returns the number of entries of the current list.
.KS
.IP EXAMPLES
.CS L
VAR person_list       : List::List [StringObject];
VAR number_of_entries : INT;
\&...
number_of_entries := person_list.GetNumberOfEntries ();
.CE
.KE
Then number_of_entries has the value 3.
.IP "SEE ALSO"
\f(HOGetEntryAtCursor\fP,
\f(HOGetNumberOfMatches\fP,
\f(HOGetPositionOfCursor\fP
.LP
.OH "'CoLibri Reference Manual''List::GetNumberOfMatches'"
.EH "'List::GetNumberOfMatches''CoLibri Reference Manual'"
.bp
.NX 4 "GetNumberOfMatches"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBMETHOD GetNumberOfMatches ($ IN $ predicate : PROCEDURE
$$( IN EntryType ) : BOOL )
$: INT;$\fP
.TE
.IP DESCRIPTION
The method \f(HOGetNumberOfMatches\fP returns the number of entries of the
current list which satisfy \f(HOpredicate\fP.
The search is started at the actual cursor position.
.IP "RETURN VALUE"
This method returns the number of entries of the current list which satisfy
\f(HOpredicate\fP.
.KS
.IP EXAMPLES
.CS L
PROCEDURE checkFirstChar ( IN string : StringObject ) : BOOL
DO
   -- This procedure returns TRUE, if Name starts with a
   -- capital letter. Otherwise it returns FALSE.
END DO;
\&...
VAR person_list       : List::List [StringObject];
VAR number_of_matches : INT;
\&...
number_of_matches := person_list.GetNumberOfMatches (checkFirstChar);
.CE
.KE
Then number_of_matches has the value 2.
.IP "SEE ALSO"
\f(HOGetEntryAtCursor\fP,
\f(HOGetNumberOfEntries\fP,
\f(HOGetPositionOfCursor\fP
.LP
.OH "'CoLibri Reference Manual''List::GetPositionOfCursor'"
.EH "'List::GetPositionOfCursor''CoLibri Reference Manual'"
.bp
.NX 4 "GetPositionOfCursor"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD GetPositionOfCursor () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetPositionOfCursor\fP returns the position of the cursor
of the current list.
The position is between 0 (\f(HOBeginMargin\fP) and NumberOfEntries+1
(\f(HOEndMargin\fP).
.IP "RETURN VALUE"
This method returns the position of the cursor of the current list.
.KS
.IP EXAMPLES
.CS L
VAR person_list        : List::List [StringObject];
VAR position_of_cursor : INT;
\&...
person_list.SetCursorToBeginMargin ();
position_of_cursor := person_list.GetPositionOfCursor ();
.CE
.KE
Then position_of_cursor has the value 0.
.IP "SEE ALSO"
\f(HOGetEntryAtCursor\fP,
\f(HOGetNumberOfEntries\fP,
\f(HOGetNumberOfMatches\fP
.LP
.OH "'CoLibri Reference Manual''List::Head'"
.EH "'List::Head''CoLibri Reference Manual'"
.bp
.NX 4 "Head"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD Head () : EntryType;\fP
.IP DESCRIPTION
The method \f(HOHead\fP returns the first entry of the current list.
.IP "RETURN VALUE"
This method returns the first entry of the current list.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current list is empty.
.KS
.IP EXAMPLES
.CS L
VAR person_list : List::List [StringObject];
VAR head        : StringObject;
\&...
head := person_list.Head ();
.CE
.KE
Then head has the value "Marilyn Monroe".
.IP "SEE ALSO"
\f(HOTail\fP
.LP
.OH "'CoLibri Reference Manual''List::InsertEntry'"
.EH "'List::InsertEntry''CoLibri Reference Manual'"
.bp
.NX 4 "InsertEntry"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD InsertEntry ( IN entry : EntryType );\fP
.IP DESCRIPTION
The method \f(HOInsertEntry\fP inserts \f(HOentry\fP after the actual cursor
position into the current list.
The cursor position is not changed.
If \f(HOentry\fP shall be the first entry of the current list, the cursor must
be moved to the \f(HOBeginMargin\fP before this method is called.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOImpossibleInsert\fP"
is raised, if the cursor points to the \f(HOEndMargin\fP of the current
list.
.KS
.IP EXAMPLES
.CS L
VAR person_list : List::List [StringObject];
VAR new_entry   : StringObject;
\&...
new_entry.Put( "Tarzan" );
person_list.SetCursorToFirst ();
person_list.InsertEntry (new_entry);
.CE
.KE
Then "Tarzan" is inserted after "Marilyn Monroe" into person_list.
.IP "SEE ALSO"
\f(HOMerge\fP,
\f(HORemoveEntry\fP
.LP
.OH "'CoLibri Reference Manual''List::IsBeginMargin'"
.EH "'List::IsBeginMargin''CoLibri Reference Manual'"
.bp
.NX 4 "IsBeginMargin"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD IsBeginMargin () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsBeginMargin\fP tests whether the cursor points to the
\f(HOBeginMargin\fP of the current list.
.IP "RETURN VALUE"
This method returns TRUE, if the cursor points to the \f(HOBeginMargin\fP of
the current list.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR person_list     : List::List [StringObject];
VAR is_begin_margin : BOOL;
\&...
person_list.SetCursorToFirst ();
is_begin_margin := person_list.IsBeginMargin ();
.CE
.KE
Then is_begin_margin has the value FALSE.
.IP "SEE ALSO"
\f(HOIsEndMargin\fP
.LP
.OH "'CoLibri Reference Manual''List::IsEmpty'"
.EH "'List::IsEmpty''CoLibri Reference Manual'"
.bp
.NX 4 "IsEmpty"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD IsEmpty () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEmpty\fP tests whether the current list is empty.
The current list is empty, if it contains only \f(HOBeginMargin\fP and
\f(HOEndMargin\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the current list is empty.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR person_list : List::List [StringObject];
VAR is_empty    : BOOL;
\&...
is_empty := person_list.IsEmpty ();
.CE
.KE
Then is_empty has the value FALSE.
.LP
.OH "'CoLibri Reference Manual''List::IsEndMargin'"
.EH "'List::IsEndMargin''CoLibri Reference Manual'"
.bp
.NX 4 "IsEndMargin"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD IsEndMargin () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEndMargin\fP tests whether the cursor points to the
\f(HOEndMargin\fP of the current list.
.IP "RETURN VALUE"
This method returns TRUE, if the cursor points to the \f(HOEndMargin\fP of the
current list.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
VAR person_list   : List::List [StringObject];
VAR is_end_margin : BOOL;
\&...
person_list.SetCursorToFirst ();
is_end_margin := person_list.IsEndMargin ();
.CE
.KE
Then is_end_margin has the value FALSE.
.IP "SEE ALSO"
\f(HOIsBeginMargin\fP
.LP
.OH "'CoLibri Reference Manual''List::IsEqual'"
.EH "'List::IsEqual''CoLibri Reference Manual'"
.bp
.NX 4 "IsEqual"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l0 l.
\f(HBMETHOD IsEqual $($ IN other_list $ : $ List [EntryType],
$$ IN equal_entry $ : $ PROCEDURE
$$$ ( $ IN EntryType,
$$$$ IN EntryType ) : BOOL ) 
$:$ BOOL;$$\fP
.TE
.IP DESCRIPTION
The method \f(HOIsEqual\fP tests whether the current list is equal to
\f(HOother_list\fP.
Two lists are equal, if the values of the entries are equal and if the 
entries are in the same sequence.
The procedure \f(HOequal_entry\fP is used to compare the values of the entries.
.IP "RETURN VALUE"
This method returns TRUE, if the current list is equal to \f(HOother_list\fP.
Otherwise it returns FALSE.
.KS
.IP EXAMPLES
.CS L
PROCEDURE entriesAreEqual ( IN entry1 : StringObject, IN entry2 : StringObject ) : BOOL
DO
   -- This procedure returns TRUE, if entry1 is equal to entry2.
   -- Otherwise it returns FALSE.
   RETURN (entry1.Get = entry2.Get);
END DO;
\&...
VAR person_list : List::List [StringObject];
VAR other_list  : List::List [StringObject];
VAR is_equal    : BOOL;
\&...
other_list := NEW List::List [StringObject];
is_equal   := person_list.IsEqual (other_list, entriesAreEqual);
.CE
.KE
Then is_equal has the value FALSE since other_list is empty.
.LP
.OH "'CoLibri Reference Manual''List::Merge'"
.EH "'List::Merge''CoLibri Reference Manual'"
.bp
.NX 4 "Merge"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD Merge ( IN list : List [EntryType] );\fP
.IP DESCRIPTION
The method \f(HOMerge\fP inserts all entries of \f(HOlist\fP after the actual
cursor position into the current list.
The cursor position is not changed.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOImpossibleInsert\fP"
is raised, if the cursor points to the \f(HOEndMargin\fP of the current
list.
.KS
.IP EXAMPLES
.CS L
VAR person_list : List::List [StringObject];
VAR other_list  : List::List [StringObject];
VAR new_entry   : StringObject;
\&...
other_list := NEW List::List [StringObject];
new_entry.Put( "Tarzan" );
other_list.InsertEntry (new_entry);
person_list.SetCursorToLast;
person_list.SetCursorToPrevious;
person_list.Merge (other_list);
.CE
.KE
Then "Tarzan" is inserted after "John Wayne" into person_list.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOInsertEntry\fP,
\f(HOSplit\fP
.LP
.OH "'CoLibri Reference Manual''List::RemoveDuplicateEntries'"
.EH "'List::RemoveDuplicateEntries''CoLibri Reference Manual'"
.bp
.NX 4 "RemoveDuplicateEntries
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBMETHOD RemoveDuplicateEntries $($ IN equal_entry : $ PROCEDURE
$$$( IN EntryType,
$$$  IN EntryType ) 
$:$ BOOL );$\fP
.TE
.IP DESCRIPTION
The method \f(HORemoveDuplicateEntries\fP removes all duplicate entries 
in the current list starting at the \f(HOBeginMargin\fP.
The procedure \f(HOequal_entry\fP is used to compare the values of the 
entries.
The cursor is moved to the \f(HOBeginMargin\fP of the current list.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current list is empty.
.KS
.IP EXAMPLES
.CS L
PROCEDURE entriesAreEqual ( IN entry1 : StringObject, IN entry2 : StringObject ) : BOOL
DO
   -- This procedure returns TRUE, if entry1 is equal to entry2.
   -- Otherwise it returns FALSE.
   RETURN (entry1.Get = entry2.Get);
END DO;
\&...
VAR person_list : List::List [StringObject];
\&...
person_list.RemoveDuplicateEntries (entriesAreEqual);
.CE
.KE
Then no entry is removed since there are no duplicate entries.
.IP "SEE ALSO"
\f(HORemoveEntry\fP,
\f(HORemoveMatchingEntries\fP
.LP
.OH "'CoLibri Reference Manual''List::RemoveEntry'"
.EH "'List::RemoveEntry''CoLibri Reference Manual'"
.bp
.NX 4 "RemoveEntry"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD RemoveEntry;\fP
.IP DESCRIPTION
The method \f(HORemoveEntry\fP removes the entry at the actual cursor
position from the current list.
The cursor is moved to the next entry.
\f(HOBeginMargin\fP and \f(HOEndMargin\fP cannot be removed.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOImpossibleDelete\fP"
is raised, if the cursor points to \f(HOBeginMargin\fP or \f(HOEndMargin\fP.
.KS
.IP EXAMPLES
.CS L
VAR person_list : List::List [StringObject];
\&...
person_list.SetCursorToLast;
person_list.RemoveEntry;
.CE
.KE
Then "peter stuyvesant" is removed from person_list.
.IP "SEE ALSO"
\f(HOInsertEntry\fP,
\f(HORemoveDuplicateEntries\fP,
\f(HORemoveMatchingEntries\fP
.LP
.OH "'CoLibri Reference Manual''List::RemoveMatchingEntries'"
.EH "'List::RemoveMatchingEntries''CoLibri Reference Manual'"
.bp
.NX 4 "RemoveMatchingEntries"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBMETHOD RemoveMatchingEntries $($ IN predicate : $ PROCEDURE
$$$ (IN EntryType ) 
$:$ BOOL );$\fP
.TE
.IP DESCRIPTION
The method \f(HORemoveMatchingEntries\fP removes all entries from the 
current list which satisfy \f(HOpredicate\fP.
The search is started at the actual cursor position.
The cursor is moved to the \f(HOBeginMargin\fP of the current list.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current list is empty.
.KS
.IP EXAMPLES
.CS L
PROCEDURE checkFirstChar ( IN string : StringObject ) : BOOL
DO
   -- This procedure returns TRUE, if Name starts with a
   -- capital letter. Otherwise it returns FALSE.
END DO;
\&...
VAR person_list : List::List [StringObject];
\&...
person_list.RemoveMatchingEntries (checkFirstChar);
.CE
.KE
Then "Marilyn Monroe" and "John Wayne" are removed from person_list.
.IP "SEE ALSO"
\f(HORemoveDuplicateEntries\fP,
\f(HORemoveEntry\fP
.LP
.OH "'CoLibri Reference Manual''List::SetCursorToBeginMargin'"
.EH "'List::SetCursorToBeginMargin''CoLibri Reference Manual'"
.bp
.NX 4 "SetCursorToBeginMargin"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD SetCursorToBeginMargin;\fP
.IP DESCRIPTION
The method \f(HOSetCursorToBeginMargin\fP moves the cursor to the
\f(HOBeginMargin\fP of the current list.
.KS
.IP EXAMPLES
.CS L
VAR person_list : List::List [StringObject];
\&...
person_list.SetCursorToBeginMargin;
.CE
.KE
Then the cursor points to the BeginMargin of person_list.
Now it is possible to start a forward processing of the elements of 
person_list after using \f(HOSetCursorToNext\fP.
.IP "SEE ALSO"
\f(HOSetCursorToEndMargin\fP,
\f(HOSetCursorToFirst\fP,
\f(HOSetCursorToLast\fP,
\f(HOSetCursorToNext\fP,
\f(HOSetCursorToPosition\fP,
\f(HOSetCursorToPrevious\fP
.LP
.OH "'CoLibri Reference Manual''List::SetCursorToEndMargin'"
.EH "'List::SetCursorToEndMargin''CoLibri Reference Manual'"
.bp
.NX 4 "SetCursorToEndMargin"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD SetCursorToEndMargin;\fP
.IP DESCRIPTION
The method \f(HOSetCursorToEndMargin\fP moves the cursor to the
\f(HOEndMargin\fP of the current list.
.KS
.IP EXAMPLES
.CS L
VAR person_list : List::List [StringObject];
\&...
person_list.SetCursorToEndMargin;
.CE
.KE
Then the cursor points to the EndMargin of person_list.
Now it is possible to start a backward processing of the elements of 
person_list after using \f(HOSetCursorToPrevious\fP.
.IP "SEE ALSO"
\f(HOSetCursorToBeginMargin\fP,
\f(HOSetCursorToFirst\fP,
\f(HOSetCursorToLast\fP,
\f(HOSetCursorToNext\fP,
\f(HOSetCursorToPosition\fP,
\f(HOSetCursorToPrevious\fP
.LP
.OH "'CoLibri Reference Manual''List::SetCursorToFirst'"
.EH "'List::SetCursorToFirst''CoLibri Reference Manual'"
.bp
.NX 4 "SetCursorToFirst"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD SetCursorToFirst;\fP
.IP DESCRIPTION
The method \f(HOSetCursorToFirst\fP moves the cursor to the first entry of the
current list.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current list is empty.
.KS
.IP EXAMPLES
.CS L
VAR person_list : List::List [StringObject];
\&...
person_list.SetCursorToFirst;
.CE
.KE
Then the cursor points to "Marilyn Monroe".
.IP "SEE ALSO"
\f(HOSetCursorToBeginMargin\fP,
\f(HOSetCursorToEndMargin\fP,
\f(HOSetCursorToLast\fP,
\f(HOSetCursorToNext\fP,
\f(HOSetCursorToPosition\fP,
\f(HOSetCursorToPrevious\fP
.LP
.OH "'CoLibri Reference Manual''List::SetCursorToLast'"
.EH "'List::SetCursorToLast''CoLibri Reference Manual'"
.bp
.NX 4 "SetCursorToLast"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD SetCursorToLast;\fP
.IP DESCRIPTION
The method \f(HOSetCursorToLast\fP moves the cursor to the last entry of the
current list.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current list is empty.
.KS
.IP EXAMPLES
.CS L
VAR person_list : List::List [StringObject];
\&...
person_list.SetCursorToLast;
.CE
.KE
Then the cursor points to "peter stuyvesant".
.IP "SEE ALSO"
\f(HOSetCursorToBeginMargin\fP,
\f(HOSetCursorToEndMargin\fP,
\f(HOSetCursorToFirst\fP,
\f(HOSetCursorToNext\fP,
\f(HOSetCursorToPosition\fP,
\f(HOSetCursorToPrevious\fP
.LP
.OH "'CoLibri Reference Manual''List::SetCursorToNext'"
.EH "'List::SetCursorToNext''CoLibri Reference Manual'"
.bp
.NX 4 "SetCursorToNext"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD SetCursorToNext;\fP
.IP DESCRIPTION
The method \f(HOSetCursorToNext\fP moves the cursor to the entry in the
current list which follows the entry at the actual cursor position.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONoNextEntry\fP"
is raised, if the cursor points to the \f(HOEndMargin\fP.
.KS
.IP EXAMPLES
.CS L
VAR person_list : List::List [StringObject];
\&...
person_list.SetCursorToFirst;
person_list.SetCursorToNext;
.CE
.KE
Then the cursor points to "John Wayne".
.IP "SEE ALSO"
\f(HOSetCursorToBeginMargin\fP,
\f(HOSetCursorToEndMargin\fP,
\f(HOSetCursorToFirst\fP,
\f(HOSetCursorToLast\fP,
\f(HOSetCursorToPosition\fP,
\f(HOSetCursorToPrevious\fP
.LP
.OH "'CoLibri Reference Manual''List::SetCursorToPosition'"
.EH "'List::SetCursorToPosition''CoLibri Reference Manual'"
.bp
.NX 4 "SetCursorToPosition"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD SetCursorToPosition ( IN position : INT );\fP
.IP DESCRIPTION
The method \f(HOSetCursorToPosition\fP moves the cursor to \f(HOposition\fP in
the current list.
\f(HOposition\fP must be between 0 (\f(HOBeginMargin\fP) and NumberOfEntries+1
(\f(HOEndMargin\fP).
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOPositionOutOfBounds\fP"
is raised, if \f(HOposition\fP is not between 0 and NumberOfEntries+1.
.KS
.IP EXAMPLES
.CS L
VAR person_list : List::List [StringObject];
VAR position    : INT;
\&...
position := 4;
person_list.SetCursorToPosition (position);
.CE
.KE
Then the cursor points to the EndMargin of person_list.
.IP "SEE ALSO"
\f(HOSetCursorToBeginMargin\fP,
\f(HOSetCursorToEndMargin\fP,
\f(HOSetCursorToFirst\fP,
\f(HOSetCursorToLast\fP,
\f(HOSetCursorToNext\fP,
\f(HOSetCursorToPrevious\fP
.LP
.OH "'CoLibri Reference Manual''List::SetCursorToPrevious'"
.EH "'List::SetCursorToPrevious''CoLibri Reference Manual'"
.bp
.NX 4 "SetCursorToPrevious"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD SetCursorToPrevious;\fP
.IP DESCRIPTION
The method \f(HOSetCursorToPrevious\fP moves the cursor to the entry in the
current list which precedes the entry at the actual cursor position.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONoPreviousEntry\fP"
is raised, if the cursor points to the \f(HOBeginMargin\fP.
.KS
.IP EXAMPLES
.CS L
VAR person_list : List::List [StringObject];
\&...
person_list.SetCursorToLast;
person_list.SetCursorToPrevious;
.CE
.KE
Then the cursor points to "John Wayne".
.IP "SEE ALSO"
\f(HOSetCursorToBeginMargin\fP,
\f(HOSetCursorToEndMargin\fP,
\f(HOSetCursorToFirst\fP,
\f(HOSetCursorToLast\fP,
\f(HOSetCursorToNext\fP,
\f(HOSetCursorToPosition\fP
.LP
.OH "'CoLibri Reference Manual''List::SetEntryAtCursor'"
.EH "'List::SetEntryAtCursor''CoLibri Reference Manual'"
.bp
.NX 4 "SetEntryAtCursor"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD SetEntryAtCursor ( IN entry : EntryType );\fP
.IP DESCRIPTION
The method \f(HOSetEntryAtCursor\fP assigns the value of the parameter
\f(HOentry\fP to the entry of the current list at the actual cursor position.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONoEntry\fP"
is raised, if the cursor points to \f(HOBeginMargin\fP or \f(HOEndMargin\fP.
.KS
.IP EXAMPLES
.CS L
VAR person_list : List::List [StringObject];
VAR new_entry   : StringObject;
\&...
new_entry.Put( "Tarzan" );
person_list.SetCursorToFirst;
person_list.SetEntryAtCursor (new_entry);
.CE
.KE
Then person_list contains "Tarzan" instead of "Marilyn Monroe".
.IP "SEE ALSO"
\f(HOSubstitute\fP
.LP
.OH "'CoLibri Reference Manual''List::Split'"
.EH "'List::Split''CoLibri Reference Manual'"
.bp
.NX 4 "Split"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD Split () : List [EntryType];\fP
.IP DESCRIPTION
The method \f(HOSplit\fP splits the current list.
All entries between (but including) the actual cursor position and 
\f(HOEndMargin\fP are
removed from the current list and inserted into the resulting list.
The cursor of the current list and the cursor of the resulting list is moved
to the \f(HOBeginMargin\fP.
.IP "RETURN VALUE"
This method returns a new list containing all entries between the actual
cursor position and \f(HOEndMargin\fP of the current list.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current list is empty.
.KS
.IP EXAMPLES
.CS L
VAR person_list : List::List [StringObject];
VAR new_list    : List::List [StringObject];
\&...
person_list.SetCursorToFirst;
person_list.SetCursorToNext;
new_list := person_list.Split ();
.CE
.KE
Then person_list contains "Marilyn Monroe", new_list contains "John Wayne" and
"peter stuyvesant".
.IP "SEE ALSO"
\f(HOMerge\fP
.LP
.OH "'CoLibri Reference Manual''List::StepToNextMatch'"
.EH "'List::StepToNextMatch''CoLibri Reference Manual'"
.bp
.NX 4 "StepToNextMatch"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBMETHOD StepToNextMatch ( IN predicate : $PROCEDURE
$( IN EntryType ) : BOOL );\fP
.TE
.IP DESCRIPTION
The method \f(HOStepToNextMatch\fP moves the cursor to the next entry
which satisfies \f(HOpredicate\fP.
The search is started after the actual cursor position.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONoMatch\fP"
is raised, if no entry satisfies \f(HOpredicate\fP.
.KS
.IP EXAMPLES
.CS L
PROCEDURE checkFirstChar ( IN string : StringObject ) : BOOL
DO
   -- This procedure returns TRUE, if Name starts with a
   -- capital letter. Otherwise it returns FALSE.
END DO;
\&...
VAR person_list : List::List [StringObject];
\&...
person_list.SetCursorToFirst;
person_list.StepToNextMatch (checkFirstChar);
.CE
.KE
Then the cursor points "John Wayne".
.IP "SEE ALSO"
\f(HOStepToPreviousMatch\fP
.LP
.OH "'CoLibri Reference Manual''List::StepToPreviousMatch'"
.EH "'List::StepToPreviousMatch''CoLibri Reference Manual'"
.bp
.NX 4 "StepToPreviousMatch"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBMETHOD StepToPreviousMatch ( IN predicate : $PROCEDURE
$( IN EntryType ) : BOOL );\fP
.TE
.IP DESCRIPTION
The method \f(HOStepToPreviousMatch\fP moves the cursor to the previous
entry of the current list which satisfies \f(HOpredicate\fP.
The search is started before the actual cursor position.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONoMatch\fP"
is raised, if no entry satisfies \f(HOpredicate\fP.
.KS
.IP EXAMPLES
.CS L
PROCEDURE checkFirstChar ( IN string : StringObject ) : BOOL
DO
   -- This procedure returns TRUE, if Name starts with a
   -- capital letter. Otherwise it returns FALSE.
END DO;
\&...
VAR person_list : List::List [StringObject];
\&...
person_list.SetCursorToLast;
person_list.StepToPreviousMatch (checkFirstChar);
.CE
.KE
Then the cursor points "John Wayne".
.IP "SEE ALSO"
\f(HOStepToNextMatch\fP
.LP
.OH "'CoLibri Reference Manual''List::Substitute'"
.EH "'List::Substitute''CoLibri Reference Manual'"
.bp
.NX 4 "Substitute"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBMETHOD Substitute ($ IN predicate $ : $PROCEDURE
$$$( IN EntryType ) : BOOL ),
$ IN entry $ : $EntryType );\fP
.TE
.IP DESCRIPTION
The method \f(HOSubsitute\fP replaces all entries of the current list which
satisfy \f(HOpredicate\fP by \f(HOentry\fP.
The search is started at the actual cursor position.
The cursor position is not changed.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current list is empty.
.KS
.IP EXAMPLES
.CS L
PROCEDURE checkFirstChar ( IN string : StringObject ) : BOOL
DO
   -- This procedure returns TRUE, if Name starts with a
   -- capital letter. Otherwise it returns FALSE.
END DO;
\&...
VAR person_list : List::List [StringObject];
VAR new_entry   : StringObject;
\&...
new_entry.Put( "Tarzan" );
person_list.Substitute (checkFirstChar, new_entry);
.CE
.KE
Then person_list contains "Tarzan", "Tarzan" and "peter stuyvesant".
.IP "SEE ALSO"
\f(HOSetEntryAtCursor\fP
.LP
.OH "'CoLibri Reference Manual''List::Tail'"
.EH "'List::Tail''CoLibri Reference Manual'"
.bp
.NX 4 "Tail"
.sp
.IP MODULE
\f(HBList\fP
.IP TYPE
\f(HBList\fP
.IP SYNOPSIS
\f(HBMETHOD Tail () : List [EntryType];\fP
.IP DESCRIPTION
The method \f(HOTail\fP inserts all entries except the first entry of the
current list into the resulting list.
The cursor of the current list and the cursor of the resulting list is moved
to the \f(HOBeginMargin\fP.
.IP "RETURN VALUE"
This method returns a new list containing all entries of the current list
except the first entry.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current list is empty.
.KS
.IP EXAMPLES
.CS L
VAR person_list  : List::List [StringObject];
VAR new_list     : List::List [StringObject];
\&...
new_list := person_list.Tail ();
.CE
.KE
Then new_list contains "John Wayne" and "peter stuyvesant".
.IP "SEE ALSO"
\f(HOHead\fP
.LP
.OH "'CoLibri Reference Manual''List'"
.EH "'List''CoLibri Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HOList\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
INITIALLY$result$$List [EntryType]$
_
Apply$IN$routine$PROCEDURE$ContainerEmpty
_
Copy$result$$List [EntryType]$
_
GetEntryAtCursor$result$$EntryType$NoEntry
_
GetNumberOfEntries$result$$INT$
_
GetNumberOfMatches$IN$predicate$PROCEDURE$
$result$$BOOL$
_
GetPositionOfCursor$result$$INT$
_
Head$result$$EntryType$ContainerEmpty
_
InsertEntry$IN$entry$EntryType$ImpossibleInsert
_
IsBeginMargin$result$$BOOL$
_
IsEmpty$result$$BOOL$
_
IsEndMargin$result$$BOOL$
_
IsEqual$IN$other_list$List [EntryType]$
$IN$equal_entry$PROCEDURE$
$result$$BOOL$
_
Merge$IN$list$List [EntryType]$ImpossibleInsert
_
RemoveDuplicateEntries$IN$equal_entry$PROCEDURE$ContainerEmpty
_
RemoveEntry$$$$ImpossibleDelete
_
RemoveMatchingEntries$IN$predicate$PROCEDURE$ContainerEmpty
_
SetCursorToBeginMargin$$$$
_
SetCursorToEndMargin$$$$
_
SetCursorToFirst$$$$ContainerEmpty
_
SetCursorToLast$$$$ContainerEmpty
_
SetCursorToNext$$$$NoNextEntry
_
SetCursorToPosition$IN$position$INT$PositionOutOfBounds
_
SetCursorToPrevious$$$$NoPreviousEntry
_
SetEntryAtCursor$IN$entry$EntryType$NoEntry
_
Split$result$$List [EntryType]$ContainerEmpty
_
StepToNextMatch$IN$predicate$PROCEDURE$NoMatch
_
StepToPreviousMatch$IN$predicate$PROCEDURE$NoMatch
.TE
.NL
.nr PS 12
.KE
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
Substitute$IN$predicate$PROCEDURE$ContainerEmpty
$IN$entry$EntryType$
_
Tail$result$$List [EntryType]$ContainerEmpty
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''SortedList'"
.EH "'SortedList''CoLibri Reference Manual'"
.bp
.NX 2 "SortedList"
.sp
.NX 3 "Type Description"
.sp
\f(HOSortedList\fP is a generic sub type of the generic object type 
\f(HOList\fP representing a container consisting of an arbitrary number of 
entries which are in a sorted relation.
A strong order must be defined for the entry values.
This object type offers methods to insert, delete, retrieve or replace
entries and to split or merge lists.
Moreover this type provides a cursor which allows to navigate through the
entries of a list and to retrieve the contents of the entries.
.sp
The type of the entry values must be specified by the application programmer
to get a special \f(HOSortedList\fP type if a variable of type 
\f(HOSortedList\fP must be declared.
.sp 0.5
.IP NOTE
If the entry type is an object type or a reference type, the entry values
which are used to keep the order may only be changed using the methods of
\f(HOSortedList\fP.
Otherwise the order of the entries cannot be guaranteed.
.LP
.sp 0.5
The general features of any \f(HOSortedList\fP type are described using the
following syntax:
.TS
tab($);
l l l.
String$Description$Example
_
SortedList$name of the special \f(HOSortedList\fP type$ClientSortedList
EntryType$type of the entry values$PersonalName
.TE
.sp
.NX 3 "List of Methods"
.sp
The following methods are available in \f(HO<SortedList.cs>\fP:
.TS
tab($);
l l.
Method name$R(edefined)/N(ew)
_
Apply$R
Copy$R
GetEntryAtCursor
GetNumberOfEntries
GetNumberOfMatches
GetPositionOfCursor
Head
InsertEntry$R
IsBeginMargin
IsEmpty
IsEndMargin
IsEqual
Merge$R
RemoveDuplicateEntries
RemoveEntry
RemoveMatchingEntries
SetCursorToBeginMargin
SetCursorToEndMargin
SetCursorToFirst
SetCursorToLast
SetCursorToNext
SetCursorToPosition
SetCursorToPrevious
SetEntryAtCursor$R
Split$R
StepToNextMatch
StepToPreviousMatch
Substitute$R
Tail$R
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each method described below the exceptions which will be raised in case
of an error are listed.
.sp
The following exceptions can be raised using module \f(HOSortedList\fP :
.TS
tab($);
l.
exception name
_
List::ContainerEmpty
Node::ImpossibleDelete
Node::ImpossibleInsert
Node::NoEntry
List::NoMatch
Node::NoNextEntry
Node::NoPreviousEntry
List::PositionOutOfBounds
.TE
.sp
.NX 3 "How to use SortedList"
.sp
A variable of type \f(HOSortedList\fP is declared as follows:
.CS L
VAR person_sorted_list : SortedList [PersonSortedListEntryType];
.CE
.sp 0.5
A variable of type \f(HOSortedList\fP can be initialized using the CooL
constructor NEW.
.sp
A sub type of type \f(HOSortedList\fP is declared as follows:
.CS L
TYPE PersonSortedList [EntryType,... ] = SortedList OBJECT ... END OBJECT;
.CE
.sp 0.5
.KS
Each CooL module which uses the type \f(HOSortedList\fP must
import the module \f(HOSortedList\fP:
.CS L
IMPORT ..., SortedList, ...;
.CE
.KE
.sp 0.5
.NX 3 "Method Description"
.sp
The following sections contain the syntactical and semantical description of
all methods provided by \f(HOSortedList\fP.
They are listed in alphabetical order.
.sp
.KS
The examples are based on a generic object type of type \f(HOSortedList\fP:
.CS L
TYPE StringObject = OBJECT( IN str : STRING )
PUBLIC
  METHOD Get : STRING;
  METHOD Put( IN str : STRING );
PROTECTED
STATE
  string : STRING;
BODY
  INITIALLY( IN str : STRING )
  DO
    string := str;
  END DO;

  METHOD Get : STRING
  DO 
    RETURN string;
  END DO;

  METHOD Put( IN str : STRING )
  DO
    string := str;
  END DO;
END OBJECT;

\&...

VAR person_sorted_list : SortedList::SortedList [StringObject];
.CE
.KE
.sp 0.5
It is assumed that this special \f(HOSortedList\fP type contains the
following elements as objects:
.KS
.TS
tab($);
l l.
Cursor position$Entry value
_
BeginMargin$---
1$John Wayne
2$Marilyn Monroe
3$peter stuyvesant
EndMargin$---
.TE
.KE
.OH "'CoLibri Reference Manual''SortedList::INITIALLY'"
.EH "'SortedList::INITIALLY''CoLibri Reference Manual'"
.bp
.NX 4 "INITIALLY"
.sp
.IP MODULE
\f(HBSortedList\fP
.IP TYPE
\f(HBSortedList = List\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBINITIALLY $($ IN less : $PROCEDURE
$$$( IN EntryType,
$$$  IN EntryType ) : BOOL ) 
$:$ SortedList $ [EntryType];\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW.
The parameter \f(HOless\fP specifies the order of the entries of the current
object.
The procedure \f(HOless\fP is used for the correct placement of an entry in
a sorted list.
The current object contains the two margins \f(HOBeginMargin\fP and
\f(HOEndMargin\fP.
The cursor is moved to the \f(HOBeginMargin\fP.
.IP "RETURN VALUE"
This method returns a new object of this type.
.KS
.IP EXAMPLES
.CS L
PROCEDURE lessPersonList ( IN entry1 : StringObject, IN entry2 : StringObject ) : BOOL
DO
   -- This procedure returns TRUE, if entry1 is less than entry2.
   -- Otherwise it returns FALSE.
   RETURN (entry1.Get < entry2.Get);
END DO;
\&...
VAR person_sorted_list : SortedList::SortedList [StringObject];
\&...
person_sorted_list := NEW SortedList::SortedList [StringObject]
.in +12
(lessPersonList);
.in -12
.CE
.KE
.IP "SEE ALSO"
\f(HOList::Copy\fP,
\f(HOList::INITIALLY\fP,
\f(HOList::Merge\fP
.LP
.OH "'CoLibri Reference Manual''SortedList::Apply'"
.EH "'SortedList::Apply''CoLibri Reference Manual'"
.bp
.NX 4 "Apply"
.sp
.IP MODULE
\f(HBSortedList\fP
.IP TYPE
\f(HBSortedList = List\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBREDEFINED METHOD Apply ( IN routine : $PROCEDURE
$( INOUT EntryType ) );\fP
.TE
.IP DESCRIPTION
The method \f(HOApply\fP applies \f(HOroutine\fP to all entries of the current
sorted list starting at the actual cursor position.
The entry values can be modified by \f(HOroutine\fP.
The procedure \f(HOless\fP is used to move each entry to its correct position.
The cursor position is not changed.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current sorted list is empty.
.KS
.IP EXAMPLES
.CS L
PROCEDURE ToUpper ( INOUT string : StringObject)
DO
   -- This procedure converts small letters to
   -- capital letters.
END DO;
\&...
VAR person_sorted_list : SortedList::SortedList [StringObject];
\&...
person_sorted_list.Apply (ToUpper);
.CE
.KE
Then all entries of person_sorted_list are converted to capital letters.
.LP
.OH "'CoLibri Reference Manual''SortedList::Copy'"
.EH "'SortedList::Copy''CoLibri Reference Manual'"
.bp
.NX 4 "Copy"
.sp
.IP MODULE
\f(HBSortedList\fP
.IP TYPE
\f(HBSortedList = List\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Copy () : List [EntryType];\fP
.IP DESCRIPTION
The method \f(HOCopy\fP creates a new object of this type containing the
state of the current object.
.IP "RETURN VALUE"
This method returns a new object of this type containing the state of the
current object.
.KS
.IP EXAMPLES
.CS L
VAR person_sorted_list : SortedList::SortedList [StringObject];
VAR next_sorted_list   : SortedList::SortedList [StringObject];
\&...
TYPESELECT select_sorted_list := person_sorted_list.Copy () OF
   CASE SortedList::SortedList :
      next_sorted_list := select_sorted_list;
\&...
END TYPESELECT;
.CE
.KE
Then next_sorted_list contains all entries of person_sorted_list.
.IP "SEE ALSO"                                                          
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''SortedList::InsertEntry'"
.EH "'SortedList::InsertEntry''CoLibri Reference Manual'"
.bp
.NX 4 "InsertEntry"
.sp
.IP MODULE
\f(HBSortedList\fP
.IP TYPE
\f(HBSortedList = List\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD InsertEntry ( IN entry : EntryType );\fP
.IP DESCRIPTION
The method \f(HOInsertEntry\fP inserts \f(HOentry\fP into the current sorted
list.
The procedure \f(HOless\fP is used to find the correct position of the new
entry.
The cursor position is not changed.
.KS
.IP EXAMPLES
.CS L
VAR person_sorted_list : SortedList::SortedList [StringObject];
VAR new_entry          : StringObject;
\&...
new_entry.Put( "Tarzan" );
person_sorted_list.InsertEntry (new_entry);
.CE
.KE
Then "Tarzan" is inserted before "peter stuyvesant" into person_sorted_list.
.IP "SEE ALSO"
\f(HOList::RemoveEntry\fP,
\f(HOMerge\fP
.LP
.OH "'CoLibri Reference Manual''SortedList::Merge'"
.EH "'SortedList::Merge''CoLibri Reference Manual'"
.bp
.NX 4 "Merge"
.sp
.IP MODULE
\f(HBSortedList\fP
.IP TYPE
\f(HBSortedList = List\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Merge ( IN list : List [EntryType] );\fP
.IP DESCRIPTION
The method \f(HOMerge\fP inserts all entries of \f(HOlist\fP into the current
sorted list.
The procedure \f(HOless\fP is used to move each entry to its correct position.
The cursor position is not changed.
.KS
.IP EXAMPLES
.CS L
VAR person_sorted_list : SortedList::SortedList [StringObject];
VAR other_sorted_list  : SortedList::SortedList [StringObject];
VAR new_entry          : StringObject;
\&...
other_sorted_list := NEW SortedList::SortedList [StringObject]
.in +12
(lessPersonList);
.in -12
new_entry.Put( "Tarzan" );
other_sorted_list.InsertEntry (new_entry);
person_sorted_list.Merge (other_sorted_list);
.CE
.KE
Then "Tarzan" is inserted before "peter stuyvesant" into person_sorted_list.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOInsertEntry\fP,
\f(HOSplit\fP
.LP
.OH "'CoLibri Reference Manual''SortedList::SetEntryAtCursor'"
.EH "'SortedList::SetEntryAtCursor''CoLibri Reference Manual'"
.bp
.NX 4 "SetEntryAtCursor"
.sp
.IP MODULE
\f(HBSortedList\fP
.IP TYPE
\f(HBSortedList = List\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD SetEntryAtCursor ( IN entry : EntryType );\fP
.IP DESCRIPTION
The method \f(HOSetEntryAtCursor\fP assigns the value of the parameter
\f(HOentry\fP to the entry of the current sorted list at the actual cursor
position.
The procedure \f(HOless\fP is used to move the entry to its correct position.
The cursor position is not changed.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONoEntry\fP"
is raised, if the cursor points to \f(HOBeginMargin\fP or \f(HOEndMargin\fP.
.KS
.IP EXAMPLES
.CS L
VAR person_sorted_list : SortedList::SortedList StringObject];
VAR new_entry          : StringObject;
\&...
new_entry.Put( "Tarzan" );
person_sorted_list.SetCursorToFirst;
person_sorted_list.SetEntryAtCursor (new_entry);
.CE
.KE
Then person_sorted_list contains "Tarzan" instead of "John Wayne".
"Tarzan" is inserted before "peter stuyvesant".
.IP "SEE ALSO"
\f(HOSubstitute\fP
.LP
.OH "'CoLibri Reference Manual''SortedList::Split'"
.EH "'SortedList::Split''CoLibri Reference Manual'"
.bp
.NX 4 "Split"
.sp
.IP MODULE
\f(HBSortedList\fP
.IP TYPE
\f(HBSortedList = List\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Split () : List [EntryType];\fP
.IP DESCRIPTION
The method \f(HOSplit\fP splits the current sorted list.
All entries between the actual cursor position and \f(HOEndMargin\fP are
removed from the current sorted list and inserted into the resulting list.
The cursor of the current sorted list and the cursor of the resulting list is
moved to the \f(HOBeginMargin\fP.
.IP "RETURN VALUE"
This method returns a new list containing all entries between the actual
cursor position and \f(HOEndMargin\fP of the current sorted list.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current sorted list is empty.
.KS
.IP EXAMPLES
.CS L
VAR person_sorted_list : SortedList::SortedList [StringObject];
VAR new_sorted_list    : SortedList::SortedList [StringObject];
\&...
person_sorted_list.SetCursorToFirst;
person_sorted_list.SetCursorToNext;
TYPESELECT select_sorted_list := person_sorted_list.Split () OF
   CASE SortedList::SortedList :
      new_sorted_list := select_sorted_list;
\&...
END TYPESELECT;
.CE
.KE
Then person_sorted_list contains "John Wayne", new_sorted_list contains "Marilyn
Monroe" and "peter stuyvesant".
.IP "SEE ALSO"
\f(HOMerge\fP
.LP
.OH "'CoLibri Reference Manual''SortedList::Substitute'"
.EH "'SortedList::Substitute''CoLibri Reference Manual'"
.bp
.NX 4 "Substitute"
.sp
.IP MODULE
\f(HBSortedList\fP
.IP TYPE
\f(HBSortedList = List\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBREDEFINED METHOD Substitute ($ IN $ predicate : PROCEDURE
$$( IN EntryType ) : BOOL ),
$ IN $ entry : EntryType );\fP
.TE
.IP DESCRIPTION
The method \f(HOSubsitute\fP replaces all entries of the current sorted list
which satisfy \f(HOpredicate\fP by \f(HOentry\fP.
The search is started at the actual cursor position.
The procedure \f(HOless\fP is used to move each entry to its correct position.
The cursor position is not changed.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current sorted list is empty.
.KS
.IP EXAMPLES
.CS L
PROCEDURE checkFirstChar ( IN string : StringObject ) : BOOL
DO
   -- This procedure returns TRUE, if Name starts with a
   -- capital letter. Otherwise it returns FALSE.
END DO;
\&...
VAR person_sorted_list : SortedList::SortedList [StringObject];
VAR new_entry          : StringObject;
\&...
new_entry.Put( "Tarzan" );
person_sorted_list.Substitute (checkFirstChar, new_entry);
.CE
.KE
Then person_list contains "Tarzan", "Tarzan" and "peter stuyvesant".
.IP "SEE ALSO"
\f(HOSetEntryAtCursor\fP
.LP
.OH "'CoLibri Reference Manual''SortedList::Tail'"
.EH "'SortedList::Tail''CoLibri Reference Manual'"
.bp
.NX 4 "Tail"
.sp
.IP MODULE
\f(HBSortedList\fP
.IP TYPE
\f(HBSortedList = List\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Tail () : List [EntryType];\fP
.IP DESCRIPTION
The method \f(HOTail\fP inserts all entries except the first entry of the
current sorted list into the resulting list.
The cursor of the current sorted list and the cursor of the resulting list is
moved to the \f(HOBeginMargin\fP.
.IP "RETURN VALUE"
This method returns a new list containing all entries of the current sorted
list except the first entry.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current sorted list is empty.
.KS
.IP EXAMPLES
.CS L
VAR person_sorted_list : SortedList::SortedList [StringObject];
VAR new_sorted_list    : SortedList::SortedList [StringObject];
\&...
TYPESELECT select_sorted_list := person_sorted_list.Tail () OF
   CASE SortedList::SortedList :
      new_sorted_list := select_sorted_list;
\&...
END TYPESELECT;
.CE
.KE
Then new_sorted_list contains "Marilyn Monroe" and "peter stuyvesant".
.IP "SEE ALSO"
\f(HOList::Head\fP
.LP
.OH "'CoLibri Reference Manual''SortedList'"
.EH "'SortedList''CoLibri Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HOSortedList\fP.
.br
The column R/N shows whether the method is
.IP \(bu 3
redefined (R),
.IP \(bu 3
a new method (N),
.IP \(bu 3
an inherited method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
$INITIALLY$IN$less$PROCEDURE$
$$result$$SortedList [EntryType]$
_
R$Apply$IN$routine$PROCEDURE$ContainerEmpty
_
R$Copy$result$$List [EntryType]$
_
$GetEntryAtCursor$result$$EntryType$NoEntry
_
$GetNumberOfEntries$result$$INT$
_
$GetNumberOfMatches$IN$predicate$PROCEDURE$
$$result$$BOOL$
_
$GetPositionOfCursor$result$$INT$
_
$Head$result$$EntryType$ContainerEmpty
_
R$InsertEntry$IN$entry$EntryType$
_
$IsBeginMargin$result$$BOOL$
_
$IsEmpty$result$$BOOL$
_
$IsEndMargin$result$$BOOL$
_
$IsEqual$IN$other_list$List$
$$IN$equal_entry$PROCEDURE$
$$result$$BOOL$
_
R$Merge$IN$list$List [EntryType]$
_
$RemoveDuplicateEntries$IN$equal_entry$PROCEDURE$ContainerEmpty
$$result$$BOOL$
_
$RemoveEntry$$$$ImpossibleDelete
_
$RemoveMatchingEntries$IN$predicate$PROCEDURE$ContainerEmpty
_
$SetCursorToBeginMargin$$$$
_
$SetCursorToEndMargin$$$$
_
$SetCursorToFirst$$$$ContainerEmpty
_
$SetCursorToLast$$$$ContainerEmpty
_
$SetCursorToNext$$$$NoNextEntry
.TE
.NL
.nr PS 12
.KE
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
$SetCursorToPosition$IN$position$INT$PositionOutOfBounds
_
$SetCursorToPrevious$$$$NoPreviousEntry
_
R$SetEntryAtCursor$IN$entry$EntryType$NoEntry
_
R$Split$result$$List [EntryType]$ContainerEmpty
_
$StepToNextMatch$IN$predicate$PROCEDURE$NoMatch
_
$StepToPreviousMatch$IN$predicate$PROCEDURE$NoMatch
_
R$Substitute$IN$predicate$PROCEDURE$ContainerEmpty
$$IN$entry$EntryType$
_
R$Tail$result$$List [EntryType]$ContainerEmpty
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''Set'"
.EH "'Set''CoLibri Reference Manual'"
.bp
.NX 2 "Set"
.sp
.NX 3 "Type Description"
.sp
\f(HOSet\fP is a generic object type 
representing a container consisting of an arbitrary number of 
entries as an unordered homogeneous collection of entries in which no
two entries are identical.
The range of types of these entries is defined by the range of types
allowed for actual generic parameters of generic object types.
The type \f(HOSet\fP offers methods to include and exclude entries.
Calling these methods twice with the same entries will have no consequences,
especially no exception will be raised.
The main functionality of \f(HOSet\fP concerns algebraical methods like
\f(HOUnion\fP und \f(HODifference\fP and methods for testing the relationships
between sets.
.sp 0.5
For the retrieval of entries two different ways are possible :
.IP \(bu 3
Calling the method \f(HOChooseEntry\fP one will always get an arbitrary
entry out of the \f(HOSet\fP. As a consequence of this it could happen that 
one will get the same entry again calling this method twice.
.IP \(bu 3
Additional the type \f(HOSet\fP will have an internal cursor to iterate on all
entries of an object of type \f(HOSet\fP. Calling the sequence 
\f(HOResetCursor\fP, \f(HOGetEntry\fP, \f(HOGetEntry\fP, ... one will get
all entries of the \f(HOSet\fP exactly once but in an arbitrary and accidental 
order. Calling this sequence again one will get the entries in another order.
.LP
.sp 0.5
The general features of any \f(HOSet\fP type are described using the
following syntax:
.TS
tab($);
l l l.
String$Description$Example
_
Set$name of the special \f(HOSet\fP type$ClientSet
EntryType$type of the entry values$ClientName
.TE
.sp
.NX 3 "List of Methods"
.sp
The following methods are available in \f(HO<Set.cs>\fP:
.TS
tab($);
l.
Method name
_
Apply 
ChooseEntry 
Contains 
Copy 
Difference 
GetEntry 
GetNumberOfEntries 
InsertEntry 
Intersection 
IsCursorEmpty 
IsEmpty 
IsEqual 
IsSubSet 
IsSuperSet 
RemoveEntry 
ResetCursor 
SymmetricDifference 
Union
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each method described below the exceptions which will be raised in case
of an error are listed.
.sp
The following exceptions can be raised using module \f(HOSet\fP :
.TS
tab($);
l.
exception name
_
ContainerEmpty
CursorUndefined
.TE
.sp
.NX 3 "How to use Set"
.sp
A variable of type \f(HOSet\fP is declared as follows:
.CS L
VAR actors_set : Set [ActorsSetEntryType];
.CE
.sp 0.5
A variable of type \f(HOSet\fP can be initialized using the CooL
constructor NEW.
.sp
A sub type of type \f(HOSet\fP is declared as follows:
.CS L
TYPE ActorsSet [EntryType, ...] = Set OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL module which uses the type \f(HOSet\fP must
import the module \f(HOSet\fP:
.CS L
IMPORT ..., Set, ...;
.CE
.sp 0.5
.NX 3 "Method Description"
.sp
The following sections contain the syntactical and semantical description of
all methods provided by \f(HOSet\fP.
They are listed in alphabetical order.
.sp
.KS
The examples are based on the following specialized \f(HOSet\fP types:
.CS L
TYPE StringObject = OBJECT( IN str : STRING )
PUBLIC
  METHOD Get : STRING;
  METHOD Put( IN str : STRING );
PROTECTED
STATE
  string : STRING;
BODY
  INITIALLY( IN str : STRING )
  DO
    string := str;
  END DO;

  METHOD Get : STRING
  DO 
    RETURN string;
  END DO;

  METHOD Put( IN str : STRING )
  DO
    string := str;
  END DO;
END OBJECT;

\&...

VAR actors_set  : Set [StringObject];
VAR authors_set : Set [StringObject];
.CE
.KE
.sp 0.5
It is assumed that these specialized \f(HOSet\fP types contain the
following entries as objects:
.KS
.TS
tab($);
l l.
actors_set$authors_set
_
John Wayne$Peter Ustinov
Marilyn Monroe$William Shakespeare
Peter Ustinov$Tom Sharpe
.TE
.KE
.OH "'CoLibri Reference Manual''Set::INITIALLY'"
.EH "'Set::INITIALLY''CoLibri Reference Manual'"
.bp
.NX 4 "INITIALLY"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBINITIALLY () : Set [EntryType];\fP
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW.
The internal cursor is not defined when a new \f(HOSet\fP is created.
.IP "RETURN VALUE"
This method returns a new object of this type which consists of no entries.
.KS
.IP EXAMPLES
.CS L
VAR actors_set : Set::Set [StringObject];
\&...
actors_set := NEW Set::Set [StringObject];
.CE
.KE
.IP "SEE ALSO"
\f(HOCopy\fP
.LP
.OH "'CoLibri Reference Manual''Set::Apply'"
.EH "'Set::Apply''CoLibri Reference Manual'"
.bp
.NX 4 "Apply"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD Apply ( IN routine : PROCEDURE ( INOUT EntryType ) );\fP
.IP DESCRIPTION
The method \f(HOApply\fP applies \f(HOroutine\fP to all entries of the current
\f(HOSet\fP.
The entry values can be modified by \f(HOroutine\fP.
.IP EXAMPLES
.CS L
PROCEDURE StringToUpper ( INOUT string : StringObject);
   -- This procedure converts all small letters to capital letters.
\&...
VAR actors_set : Set::Set [StringObject];
\&...
actors_set := NEW Set::Set [StringObject];
\&...
actors_set.Apply (StringToUpper);
.CE
Then the values of all entries of actors_set are converted to capital
letters.
.LP
.OH "'CoLibri Reference Manual''Set::ChooseEntry'"
.EH "'Set::ChooseEntry''CoLibri Reference Manual'"
.bp
.NX 4 "ChooseEntry"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD ChooseEntry () : EntryType;\fP
.IP DESCRIPTION
The method \f(HOChooseEntry\fP returns an arbitrary and accidental entry of
the current \f(HOSet\fP.
The delivered entry remains in the \f(HOSet\fP also.
.IP "RETURN VALUE"
This method returns an arbitrary and accidental entry of the current
\f(HOSet\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOContainerEmpty\fP"
is raised, if the current \f(HOSet\fP does not contain any entries.
.IP EXAMPLES
.CS L
VAR actors_set : Set::Set [StringObject];
VAR actor      : STRING;
\&...
actors_set := NEW Set::Set [StringObject];
\&...
TRY  actor := actors_set.ChooseEntry (); 
EXCEPT
   CASE ContainerEmpty :
      (* The current set does not contain any entries. *)
      ...
END TRY;
.CE
Actor has now an arbitrary entry out of the current \f(HOSet\fP.
.IP "SEE ALSO"
\f(HOGetEntry\fP
.LP
.OH "'CoLibri Reference Manual''Set::Contains'"
.EH "'Set::Contains''CoLibri Reference Manual'"
.bp
.NX 4 "Contains"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD Contains ( IN entry : EntryType ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOContains\fP tests whether the current \f(HOSet\fP contains
\f(HOentry\fP.
.IP "RETURN VALUE"
This method returns TRUE, if the current \f(HOSet\fP contains \f(HOentry\fP.
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR actors_set : Set::Set [StringObject];
VAR actor      : StringObject;
VAR contains   : BOOL;
\&...
actors_set := NEW Set::Set [StringObject];
\&...
actor.Put( "John Wayne" );
contains   := actors_set.Contains (actor);
.CE
Then contains has the value TRUE.
.LP
.OH "'CoLibri Reference Manual''Set::Copy'"
.EH "'Set::Copy''CoLibri Reference Manual'"
.bp
.NX 4 "Copy"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD Copy () : Set [EntryType];\fP
.IP DESCRIPTION
The method \f(HOCopy\fP creates a new object of this type containing the state
of the current \f(HOSet\fP.
.IP "NOTE   "
In case of objects as entries of the set this method only copies the handles
to the state of these objects, not their states themselves.
.IP "RETURN VALUE"
This method returns a new object of this type containing the state of the
current \f(HOSet\fP.
.IP EXAMPLES
.CS L
VAR actors_set      : Set::Set [StringObject];
VAR best_actors_set : Set::Set [StringObject];
\&...
actors_set      := NEW Set::Set [StringObject];
\&...
best_actors_set := actors_set.Copy ();
.CE
Then best_actors_set contains all entries of actors_set also.
.IP "SEE ALSO"
\f(HOINITIALLY\fP
.LP
.OH "'CoLibri Reference Manual''Set::Difference'"
.EH "'Set::Difference''CoLibri Reference Manual'"
.bp
.NX 4 "Difference"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD Difference ( IN second_set : Set [EntryType] );\fP
.IP DESCRIPTION
The method \f(HODifference\fP delivers all entries which are in the current
\f(HOSet\fP but not in the \f(HOsecond_set\fP.
.IP "RETURN VALUE"
This method delivers the difference of the current \f(HOSet\fP and the
\f(HOsecond_set\fP.
.IP EXAMPLES
.CS L
VAR actors_set  : Set::Set [StringObject];
VAR authors_set : Set::Set [StringObject];
\&...
actors_set  := NEW Set::Set [StringObject];
authors_set := NEW Set::Set [StringObject];
\&...
actors_set.Difference (authors_set);
.CE
Then actors_set contains "John Wayne" and "Marilyn Monroe".
.IP "SEE ALSO"
\f(HOIntersection\fP,
\f(HOSymmetricDifference\fP,
\f(HOUnion\fP
.LP
.OH "'CoLibri Reference Manual''Set::GetEntry'"
.EH "'Set::GetEntry''CoLibri Reference Manual'"
.bp
.NX 4 "GetEntry"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD GetEntry () : EntryType;\fP
.IP DESCRIPTION
The method \f(HOGetEntry\fP returns an arbitrary and accidental entry of
the current \f(HOSet\fP.
No entry will be delivered twice.
The delivered entry remains in the \f(HOSet\fP also.
.IP "NOTE   "
Calling this method is only possible after initializing the internal 
cursor of the current \f(HOSet\fP using the method \f(HOResetCursor\fP.
.br
After initialization of the internal cursor the method 
\f(HOInsertEntry\fP inserts all entries into this part of the 
\f(HOSet\fP which has to be still processed by the method 
\f(HOGetEntry\fP.
.br
If all entries of the current set are delivered, the internal cursor is
no longer initialized.
.IP "RETURN VALUE"
This method returns an arbitrary and accidental entry of the current
\f(HOSet\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOCursorUndefined\fP"
is raised, if the internal cursor of the current \f(HOSet\fP is not 
initialized.
.IP EXAMPLES
.CS L
VAR actors_set : Set::Set [StringObject];
VAR actor      : StringObject;
\&...
actors_set := NEW Set::Set [StringObject];
\&...
actors_set.ResetCursor ();
WHILE NOT actors_set.IsCursorEmpty ()
LOOP
   actor := actors_set.GetEntry ();
   -- Perfom processing with the fetched entry.
END LOOP;
.CE
Calling the above sequence one will get all entries of the current \f(HOSet\fP 
exactly once in an arbitrary and accidental order.
.IP "SEE ALSO"
\f(HOChooseEntry\fP,
\f(HOIsCursorEmpty\fP,
\f(HOResetCursor\fP
.LP
.OH "'CoLibri Reference Manual''Set::GetNumberOfEntries'"
.EH "'Set::GetNumberOfEntries''CoLibri Reference Manual'"
.bp
.NX 4 "GetNumberOfEntries"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD GetNumberOfEntries () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetNumberOfEntries\fP returns the number of entries of the
current \f(HOSet\fP.
.IP "RETURN VALUE"
This method returns the number of entries of the current \f(HOSet\fP.
.IP EXAMPLES
.CS L
VAR actors_set       : Set::Set [StringObject];
VAR number_of_actors : INT;
\&...
actors_set       := NEW Set::Set [StringObject];
\&...
number_of_actors := actors_set.GetNumberOfEntries ();
.CE
Then number_of_actors has the value 3.
.IP "SEE ALSO"
\f(HOIsEmpty\fP
.LP
.OH "'CoLibri Reference Manual''Set::InsertEntry'"
.EH "'Set::InsertEntry''CoLibri Reference Manual'"
.bp
.NX 4 "InsertEntry"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD InsertEntry ( IN entry : EntryType );\fP
.IP DESCRIPTION
The method \f(HOInsertEntry\fP inserts \f(HOentry\fP into the current
\f(HOSet\fP.
If \f(HOentry\fP is already existing in the \f(HOSet\fP, no action is done.
.IP EXAMPLES
.CS L
VAR actors_set : Set::Set [StringObject];
VAR actor      : StringObject;
\&...
actors_set := NEW Set::Set [StringObject];
\&...
actor.Put( "Tarzan" );
actors_set.InsertEntry (actor);
.CE
Then an entry with value "Tarzan" is inserted into actors_set.
.IP "SEE ALSO"
\f(HORemoveEntry\fP
.LP
.OH "'CoLibri Reference Manual''Set::Intersection'"
.EH "'Set::Intersection''CoLibri Reference Manual'"
.bp
.NX 4 "Intersection"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD Intersection ( IN second_set : Set [EntryType] );\fP
.IP DESCRIPTION
The method \f(HOIntersection\fP delivers all entries which are in both, in
the current \f(HOSet\fP and in the \f(HOsecond_set\fP.
.IP "RETURN VALUE"
This method delivers the intersection of the current \f(HOSet\fP and the
\f(HOsecond_set\fP.
.IP EXAMPLES
.CS L
VAR actors_set  : Set::Set [StringObject];
VAR authors_set : Set::Set [StringObject];
\&...
actors_set  := NEW Set::Set [StringObject];
authors_set := NEW Set::Set [StringObject];
\&...
actors_set.Intersection (authors_set);
.CE
Then actors_set contains "Peter Ustinov".
.IP "SEE ALSO"
\f(HODifference\fP,
\f(HOSymmetricDifference\fP,
\f(HOUnion\fP
.LP
.OH "'CoLibri Reference Manual''Set::IsCursorEmpty'"
.EH "'Set::IsCursorEmpty''CoLibri Reference Manual'"
.bp
.NX 4 "IsCursorEmpty"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD IsCursorEmpty () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsCursorEmpty\fP tests whether there are still entries 
which are not yet delivered by calling the method \f(HOGetEntry\fP.
.IP "RETURN VALUE"
This method returns TRUE, if there are no entries which have to be 
delivered.  Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR actors_set : Set::Set [StringObject];
VAR actor      : STRING;
\&...
actors_set := NEW Set::Set [StringObject];
\&...
actors_set.ResetCursor ();
WHILE NOT actors_set.IsCursorEmpty () 
LOOP
   actor := actors_set.GetEntry ();
   -- Perfom processing with the fetched entry.
END LOOP;
.CE
Calling the above sequence one will get all entries of the current 
\f(HOSet\fP exactly once in an arbitrary and accidental order.
.IP "SEE ALSO"
\f(HOGetEntry\fP,
\f(HOResetCursor\fP
.LP
.OH "'CoLibri Reference Manual''Set::IsEmpty'"
.EH "'Set::IsEmpty''CoLibri Reference Manual'"
.bp
.NX 4 "IsEmpty"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD IsEmpty () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEmpty\fP tests whether the current \f(HOSet\fP is empty.
.IP "RETURN VALUE"
This method returns TRUE, if the current \f(HOSet\fP is empty.
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR actors_set : Set::Set [StringObject];
VAR is_empty   : BOOL;
\&...
actors_set := NEW Set::Set [StringObject];
\&...
is_empty   := actors_set.IsEmpty ();
.CE
is_empty has the value FALSE.
.IP "SEE ALSO"
\f(HOGetNumberOfEntries\fP
.LP
.OH "'CoLibri Reference Manual''Set::IsEqual'"
.EH "'Set::IsEqual''CoLibri Reference Manual'"
.bp
.NX 4 "IsEqual"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD IsEqual ( IN second_set : Set [EntryType] ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEqual\fP tests whether the current \f(HOSet\fP is equal to
\f(HOsecond_set\fP.
Two \f(HOSets\fP are equal, if they contain exactly the same entries.
.IP "RETURN VALUE"
This method returns TRUE, if the current \f(HOSet\fP is equal to
\f(HOsecond_set\fP.
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR actors_set  : Set::Set [StringObject];
VAR authors_set : Set::Set [StringObject];
VAR is_equal    : BOOL;
\&...
actors_set  := NEW Set::Set [StringObject];
authors_set := NEW Set::Set [StringObject];
\&...
is_equal := actors_set.IsEqual (authors_set);
.CE
Then is_equal has the value FALSE.
.LP
.OH "'CoLibri Reference Manual''Set::IsSubSet'"
.EH "'Set::IsSubSet''CoLibri Reference Manual'"
.bp
.NX 4 "IsSubSet"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD IsSubSet ( IN second_set : Set [EntryType] ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsSubSet\fP tests whether the current \f(HOSet\fP is a real
subset of \f(HOsecond_set\fP.
The current \f(HOSet\fP is a real subset of \f(HOsecond_set\fP, if all entries
of the current \f(HOSet\fP are also contained in \f(HOsecond_set\fP and, in
addition, \f(HOsecond_set\fP has other entries.
.IP "RETURN VALUE"
This method returns TRUE, if the current \f(HOSet\fP is a real subset of
\f(HOsecond_set\fP.
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR actors_set  : Set::Set [StringObject];
VAR authors_set : Set::Set [StringObject];
VAR is_subset   : BOOL;
\&...
actors_set  := NEW Set::Set [StringObject];
authors_set := NEW Set::Set [StringObject];
\&...
is_subset   := actors_set.IsSubSet (authors_set);
.CE
Then is_subset has the value FALSE.
.IP "SEE ALSO"
\f(HOIsSuperSet\fP
.LP
.OH "'CoLibri Reference Manual''Set::IsSuperSet'"
.EH "'Set::IsSuperSet''CoLibri Reference Manual'"
.bp
.NX 4 "IsSuperSet"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD IsSuperSet ( IN second_set : Set [EntryType] ) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsSuperSet\fP tests whether the current \f(HOSet\fP is a real
superset of \f(HOsecond_set\fP.
The current \f(HOSet\fP is a real superset of \f(HOsecond_set\fP, if all
entries of \f(HOsecond_set\fP are also contained in the current \f(HOSet\fP
and, in addition, the current \f(HOSet\fP has other entries.
.IP "RETURN VALUE"
This method returns TRUE, if the current \f(HOSet\fP is a real superset of 
\f(HOsecond_set\fP.
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR actors_set  : Set::Set [StringObject];
VAR authors_set : Set::Set [StringObject];
VAR is_superset : BOOL;
\&...
actors_set  := NEW Set::Set [StringObject];
authors_set := NEW Set::Set [StringObject];
\&...
is_superset := actors_set.IsSuperSet (authors_set);
.CE
Then is_superset has the value FALSE.
.IP "SEE ALSO" 
\f(HOIsSubSet\fP
.LP
.OH "'CoLibri Reference Manual''Set::RemoveEntry'"
.EH "'Set::RemoveEntry''CoLibri Reference Manual'"
.bp
.NX 4 "RemoveEntry"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD RemoveEntry ( IN entry : EntryType );\fP
.IP DESCRIPTION
The method \f(HORemoveEntry\fP removes \f(HOentry\fP from the current
\f(HOSet\fP.
If \f(HOentry\fP is already removed from the \f(HOSet\fP, no action is done.
.IP EXAMPLES
.CS L
VAR actors_set : Set::Set [StringObject];
VAR actor      : StringObject;
\&...
actors_set := NEW Set::Set [StringObject];
\&...
actor.Put( "Marilyn Monroe" );
actors_set.RemoveEntry (actor);
.CE
Then the entry "Marilyn Monroe" is removed from actors_set.
.IP "SEE ALSO"
\f(HOInsertEntry\fP
.LP
.OH "'CoLibri Reference Manual''Set::ResetCursor'"
.EH "'Set::ResetCursor''CoLibri Reference Manual'"
.bp 
.NX 4 "ResetCursor"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD ResetCursor;\fP
.IP DESCRIPTION
The method \f(HOResetCursor\fP initializes the internal cursor of the 
current \f(HOSet\fP.
.br
If the set is empty, no action is done.
.IP "NOTE   "
Calling this method is always necessary before iterating on the entries of the
current \f(HOSet\fP.
.IP EXAMPLES
.CS L
VAR actors_set : Set::Set [StringObject];
VAR actor      : StringObject;
\&...
actors_set := NEW Set::Set [StringObject];
\&...
actors_set.ResetCursor;
WHILE NOT actors_set.IsCursorEmpty () 
LOOP
   actor := actors_set.GetEntry ();
   -- Perfom processing with the fetched entry.
END LOOP;
.CE
Calling the above sequence one will get all entries of the current \f(HOSet\fP 
exactly once in an arbitrary and accidental order.
.IP "SEE ALSO"
\f(HOGetEntry\fP,
\f(HOIsCursorEmpty\fP
.LP
.OH "'CoLibri Reference Manual''Set::SymmetricDifference'"
.EH "'Set::SymmetricDifference''CoLibri Reference Manual'"
.bp
.NX 4 "SymmetricDifference"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD SymmetricDifference ( IN second_set : Set [EntryType] );\fP
.IP DESCRIPTION
The method \f(HOSymmetricDifference\fP delivers all entries which are in
the current \f(HOSet\fP or in the \f(HOsecond_set\fP but not in both.
.IP "RETURN VALUE"
This method delivers the symmetric difference of the current \f(HOSet\fP and
the \f(HOsecond_set\fP.
.IP EXAMPLES
.CS L
VAR actors_set  : Set::Set [StringObject];
VAR authors_set : Set::Set [StringObject];
\&...
actors_set  := NEW Set::Set [StringObject];
authors_set := NEW Set::Set [StringObject];
\&...
actors_set.SymmetricDifference (authors_set);
.CE
Then actors_set contains "John Wayne", "Marilyn Monroe", "William Shakespeare"
and "Tom Sharpe".
.IP "SEE ALSO"
\f(HODifference\fP,
\f(HOIntersection\fP,
\f(HOUnion\fP
.LP
.OH "'CoLibri Reference Manual''Set::Union'"
.EH "'Set::Union''CoLibri Reference Manual'"
.bp
.NX 4 "Union"
.sp
.IP MODULE
\f(HBSet\fP
.IP TYPE
\f(HBSet\fP
.IP SYNOPSIS
\f(HBMETHOD Union ( IN second_set : Set [EntryType] );\fP
.IP DESCRIPTION
The method \f(HOUnion\fP delivers all entries which are in the current
\f(HOSet\fP or in the \f(HOsecond_set\fP.
.IP "RETURN VALUE"
This method delivers the union of the current \f(HOSet\fP and the
\f(HOsecond_set\fP.
.IP EXAMPLES
.CS L
VAR actors_set  : Set::Set [StringObject];
VAR authors_set : Set::Set [StringObject];
\&...
actors_set  := NEW Set::Set [StringObject];
authors_set := NEW Set::Set [StringObject];
\&...
actors_set.Union (authors_set);
.CE
Then actors_set contains "John Wayne", "Marilyn Monroe", "Peter Ustinov",
"William Shakespeare" and "Tom Sharpe".
.IP "SEE ALSO"
\f(HODifference\fP,
\f(HOIntersection\fP,
\f(HOSymmetricDifference\fP
.LP
.OH "'CoLibri Reference Manual''Set'"
.EH "'Set''CoLibri Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HOSet\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
INITIALLY$result$$Set [EntryType]$
_
Apply$IN$routine$PROCEDURE$
_
ChooseEntry$result$$EntryType$ContainerEmpty
_
Contains$IN$entry$EntryType$
$result$$BOOL$
_
Copy$result$$Set [EntryType]$
_
Difference$IN$second_set$Set [EntryType]$
_
GetEntry$result$$EntryType$CursorUndefined
$$$$NoMoreEntries
_
GetNumberOfEntries$result$$INT$
_
InsertEntry$IN$entry$EntryType$
_
Intersection$IN$second_set$Set [EntryType]$
_
IsCursorEmpty$result$$BOOL$CursorUndefined
_
IsEmpty$result$$BOOL$
_
IsEqual$IN$second_set$Set [EntryType])$
$result$$BOOL$
_
IsSubSet$IN$second_set$Set [EntryType])$
$result$$BOOL$
_
IsSuperSet$IN$second_set$Set [EntryType])$
$result$$BOOL$
_
RemoveEntry$IN$entry$EntryType$
_
ResetCursor$$$$
_
SymmetricDifference$IN$second_set$Set [EntryType]$
_
Union$IN$second_set$Set [EntryType]$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''File'"
.EH "'File''CoLibri Reference Manual'"
.bp
.NX 2 "File"
.sp
.NX 3 "Type Description"
.sp
\f(HOFile\fP is an abstract object type which provides a set of abstract
methods for read and write access on the contents of files.
\f(HOFile\fP is the supertype of the abstract object type 
\f(HOExternFile\fP which is itself the supertype of the (real) object
type \f(HOTextFile\fP.
.sp
.NX 3 "List of Methods"
.sp
The following abstract methods are available in <File.cs>:
.TS
tab($);
l l.
Method name$A(bstract)
_
ReadBcd$A
ReadChar$A
ReadDouble$A
ReadInt$A
ReadString$A
WriteBcd$A
WriteChar$A
WriteDouble$A
WriteInt$A
WriteString$A
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each method described below no exceptions are raised because they 
are abstract methods and have no implementation.
.sp
.NX 3 "How to use File"
.sp
The abstract object type \f(HOFile\fP can only be used as a supertype 
for inheritance aspects.
Objects of this type cannot be constructed.
.sp
.NX 3 "Method Description"
.sp
The following sections contain the syntactical and semantical 
description of all methods provided by \f(HOFile\fP.
They are listed in alphabetical order.
.LP
.OH "'CoLibri Reference Manual''File::ReadBcd'"
.EH "'File::ReadBcd''CoLibri Reference Manual'"
.bp
.NX 4 "ReadBcd"
.sp
.IP MODULE
\f(HBFile\fP
.IP TYPE
\f(HBFile\fP
.IP SYNOPSIS
\f(HBABSTRACT METHOD ReadBcd () : BCD;\fP
.IP DESCRIPTION
The abstract method \f(HOReadBcd\fP is a placeholder for the real
methods of the subtypes of \f(HOFile\fP in order to read a BCD variable
from a file.
.IP "RETURN VALUE"
The function must return a value of type BCD.
.IP "SEE ALSO"
\f(HOWriteBcd\fP
.LP
.OH "'CoLibri Reference Manual''File::ReadChar'"
.EH "'File::ReadChar''CoLibri Reference Manual'"
.bp
.NX 4 "ReadChar"
.sp
.IP MODULE
\f(HBFile\fP
.IP TYPE
\f(HBFile\fP
.IP SYNOPSIS
\f(HBABSTRACT METHOD ReadChar () : CHAR;\fP
.IP DESCRIPTION
The abstract method \f(HOReadChar\fP is a placeholder for the real
methods of the subtypes of \f(HOFile\fP in order to read a CHAR variable
from a file.
.IP "RETURN VALUE"
The function must return a value of type CHAR.
.IP "SEE ALSO"
\f(HOWriteChar\fP
.LP
.OH "'CoLibri Reference Manual''File::ReadDouble'"
.EH "'File::ReadDouble''CoLibri Reference Manual'"
.bp
.NX 4 "ReadDouble"
.sp
.IP MODULE
\f(HBFile\fP
.IP TYPE
\f(HBFile\fP
.IP SYNOPSIS
\f(HBABSTRACT METHOD ReadDouble () : DOUBLE;\fP
.IP DESCRIPTION
The abstract method \f(HOReadDouble\fP is a placeholder for the real
methods of the subtypes of \f(HOFile\fP in order to read a DOUBLE 
variable from a file.
.IP "RETURN VALUE"
The function must return a value of type DOUBLE.
.IP "SEE ALSO"
\f(HOWriteDouble\fP
.LP
.OH "'CoLibri Reference Manual''File::ReadInt'"
.EH "'File::ReadInt''CoLibri Reference Manual'"
.bp
.NX 4 "ReadInt"
.sp
.IP MODULE
\f(HBFile\fP
.IP TYPE
\f(HBFile\fP
.IP SYNOPSIS
\f(HBABSTRACT METHOD ReadInt () : INT;\fP
.IP DESCRIPTION
The abstract method \f(HOReadInt\fP is a placeholder for the real
methods of the subtypes of \f(HOFile\fP in order to read a INT variable
from a file.
.IP "RETURN VALUE"
The function must return a value of type INT.
.IP "SEE ALSO"
\f(HOWriteInt\fP
.LP
.OH "'CoLibri Reference Manual''File::ReadString'"
.EH "'File::ReadString''CoLibri Reference Manual'"
.bp
.NX 4 "ReadString"
.sp
.IP MODULE
\f(HBFile\fP
.IP TYPE
\f(HBFile\fP
.IP SYNOPSIS
\f(HBABSTRACT METHOD ReadString () : STRING;\fP
.IP DESCRIPTION
The abstract method \f(HOReadString\fP is a placeholder for the real
methods of the subtypes of \f(HOFile\fP in order to read a STRING 
variable from a file.
.IP "RETURN VALUE"
The function must return a value of type STRING.
.IP "SEE ALSO"
\f(HOWriteString\fP
.LP
.OH "'CoLibri Reference Manual''File::WriteBcd'"
.EH "'File::WriteBcd''CoLibri Reference Manual'"
.bp
.NX 4 "WriteBcd"
.sp
.IP MODULE
\f(HBFile\fP
.IP TYPE
\f(HBFile\fP
.IP SYNOPSIS
\f(HBABSTRACT METHOD WriteBcd ( IN value : BCD );\fP
.IP DESCRIPTION
The abstract method \f(HOWriteBcd\fP is a placeholder for the real
methods of the subtypes of \f(HOFile\fP in order to write the 
\f(HOvalue\fP of type BCD into a file.
.IP "SEE ALSO"
\f(HOReadBcd\fP
.LP
.OH "'CoLibri Reference Manual''File::WriteChar'"
.EH "'File::WriteChar''CoLibri Reference Manual'"
.bp
.NX 4 "WriteChar"
.sp
.IP MODULE
\f(HBFile\fP
.IP TYPE
\f(HBFile\fP
.IP SYNOPSIS
\f(HBABSTRACT METHOD WriteChar ( IN value : CHAR );\fP
.IP DESCRIPTION
The abstract method \f(HOWriteChar\fP is a placeholder for the real
methods of the subtypes of \f(HOFile\fP in order to write the
\f(HOvalue\fP of type CHAR into a file.
.IP "SEE ALSO"
\f(HOReadChar\fP
.LP
.OH "'CoLibri Reference Manual''File::WriteDouble'"
.EH "'File::WriteDouble''CoLibri Reference Manual'"
.bp
.NX 4 "WriteDouble"
.sp
.IP MODULE
\f(HBFile\fP
.IP TYPE
\f(HBFile\fP
.IP SYNOPSIS
\f(HBABSTRACT METHOD WriteDouble ( IN value : DOUBLE );\fP
.IP DESCRIPTION
The abstract method \f(HOWriteDouble\fP is a placeholder for the real
methods of the subtypes of \f(HOFile\fP in order to write the
\f(HOvalue\fP of type DOUBLE into a file.
.IP "SEE ALSO"
\f(HOReadDouble\fP
.LP
.OH "'CoLibri Reference Manual''File::WriteInt'"
.EH "'File::WriteInt''CoLibri Reference Manual'"
.bp
.NX 4 "WriteInt"
.sp
.IP MODULE
\f(HBFile\fP
.IP TYPE
\f(HBFile\fP
.IP SYNOPSIS
\f(HBABSTRACT METHOD WriteInt ( IN value : INT );\fP
.IP DESCRIPTION
The abstract method \f(HOWriteInt\fP is a placeholder for the real
methods of the subtypes of \f(HOFile\fP in order to write the
\f(HOvalue\fP of type INT into a file.
.IP "SEE ALSO"
\f(HOReadInt\fP
.LP
.OH "'CoLibri Reference Manual''File::WriteString'"
.EH "'File::WriteString''CoLibri Reference Manual'"
.bp
.NX 4 "WriteString"
.sp
.IP MODULE
\f(HBFile\fP
.IP TYPE
\f(HBFile\fP
.IP SYNOPSIS
\f(HBABSTRACT METHOD WriteString ( IN value : STRING );\fP
.IP DESCRIPTION
The abstract method \f(HOWriteString\fP is a placeholder for the real
methods of the subtypes of \f(HOFile\fP in order to write the
\f(HOvalue\fP of type STRING into a file.
.IP "SEE ALSO"
\f(HOReadString\fP
.LP
.OH "'CoLibri Reference Manual''File'"
.EH "'File''CoLibri Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the abstract methods provided by the object 
type \f(HOFile\fP.
.br
The column A/C/N shows whether the method is
.IP \(bu 3
an abstract method (A),
.IP \(bu 3
a concretion of an inheritead abstract method (C),
.IP \(bu 3
a new method (N),
.IP \(bu 3
an inherited method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
A/C/N$Name$Mode$Parameter$Type$Exceptions
=
A$ReadBcd$result$$BCD$                                               
_
A$ReadChar$result$$CHAR$                                             
_
A$ReadDouble$result$$DOUBLE$                                         
_
A$ReadInt$result$$INT$                                               
_
A$ReadString$result$$STRING$                                         
_
A$WriteBcd$IN$value$BCD$                                      
_
A$WriteChar$IN$value$CHAR$                                    
_
A$WriteDouble$IN$value$DOUBLE$                                
_
A$WriteInt$IN$value$INT$                                  
_
A$WriteString$IN$value$STRING$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''ExternFile'"
.EH "'ExternFile''CoLibri Reference Manual'"
.bp
.NX 2 "ExternFile"
.sp
.NX 3 "Type Description"
.sp
\f(HOExternFile\fP is an abstract subtype of \f(HOFile\fP which provides
a set of methods for file administration.
\f(HOExternFile\fP is the subtype of the abstract object type 
\f(HOFile\fP and supertype of the (real) object type \f(HOTextFile\fP.
.sp
.NX 3 "List of Methods"
.sp
The following methods are available in <ExternFile.cs>:
.TS
tab($);
l l.
Method name$A(bstract)/C(oncretion)/N(ew)
_
Close$N
Flush$N
GetMode$N
GetName$N
GetSize$N
IsOpen$N
Open$N
ReadBcd$A
ReadChar$A
ReadDouble$A
ReadInt$A
ReadString$A
WriteBcd$A
WriteChar$A
WriteDouble$A
WriteInt$A
WriteString$A
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
The following exceptions can be raised using module \f(HOExternFile\fP :
.TS
tab($);
l.
exception name
_
CannotOpenFile
FileIsAlreadyOpen
FileIsNotOpen
FileIsNotOpenedForWriting
.TE
.sp
.NX 3 "How to use ExternFile"
.sp
The abstract object type \f(HOExternFile\fP can only be used as a 
supertype for inheritance aspects.
Objects of this type cannot be constructed.
.sp
.NX 3 "Method Description"
.sp
The following sections contain the syntactical and semantical 
description of all methods provided by \f(HOExternFile\fP.
They are listed in alphabetical order.
.LP
.OH "'CoLibri Reference Manual''ExternFile::Close'"
.EH "'ExternFile::Close''CoLibri Reference Manual'"
.bp
.NX 4 "Close"
.sp
.IP MODULE
\f(HBExternFile\fP
.IP TYPE
\f(HBExternFile = File\fP
.IP SYNOPSIS
\f(HBMETHOD Close;\fP
.IP DESCRIPTION
The method \f(HOClose\fP closes the current file object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP EXAMPLES
.KS
.CS L
VAR file : TextFile::TextFile;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.write);
\&...
file.Close;
.CE
.KE
Now the current file is closed.
.IP "SEE ALSO"
\f(HOIsOpen\fP,
\f(HOOpen\fP
.LP
.OH "'CoLibri Reference Manual''ExternFile::Flush'"
.EH "'ExternFile::Flush''CoLibri Reference Manual'"
.bp
.NX 4 "Flush"
.sp
.IP MODULE
\f(HBExternFile\fP
.IP TYPE
\f(HBExternFile = File\fP
.IP SYNOPSIS
\f(HBMETHOD Flush;\fP
.IP DESCRIPTION
The method \f(HOFlush\fP writes the buffer of the current file object
into the file.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP "\(bu \f(HOFileIsNotOpenedForWriting\fP"
is raised, if the current file object was not opened for writing.
.IP EXAMPLES
.KS
.CS L
VAR file : TextFile::TextFile;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.write);
\&...
file.Flush;
.CE
.KE
Now the buffer of the file object was written into the file.
.LP
.OH "'CoLibri Reference Manual''ExternFile::GetMode'"
.EH "'ExternFile::GetMode''CoLibri Reference Manual'"
.bp
.NX 4 "GetMode"
.sp
.IP MODULE
\f(HBExternFile\fP
.IP TYPE
\f(HBExternFile = File\fP
.IP SYNOPSIS
\f(HBMETHOD GetMode () : DIRECTION;\fP
.IP DESCRIPTION
The method \f(HOGetMode\fP returns the access mode of the current file 
object.
.IP NOTE
DIRECTION is an enumeration type which knows the variants \f(HOread\fP,
\f(HOwrite\fP and \f(HOappend\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP EXAMPLES
.KS
.CS L
VAR file : TextFile::TextFile;
VAR mode : ExternFile::DIRECTION;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.write);
\&...
mode := file.GetMode ();
.CE
.KE
Now mode contains the \f(HOwrite\fP variant of the DIRECTION.
.IP "SEE ALSO"
\f(HOGetName\fP,
\f(HOGetSize\fP
.LP
.OH "'CoLibri Reference Manual''ExternFile::GetName'"
.EH "'ExternFile::GetName''CoLibri Reference Manual'"
.bp
.NX 4 "GetName"
.sp
.IP MODULE
\f(HBExternFile\fP
.IP TYPE
\f(HBExternFile = File\fP
.IP SYNOPSIS
\f(HBMETHOD GetName () : STRING;\fP
.IP DESCRIPTION
The method \f(HOGetName\fP returns the name of the current file object.
.IP EXAMPLES
.KS
.CS L
VAR file : TextFile::TextFile;
VAR name : STRING;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.write);
\&...
name := file.GetName ();
.CE
.KE
Now name contains the name of the current file object, i.e. "test.txt".
.IP "SEE ALSO"
\f(HOGetMode\fP,
\f(HOGetSize\fP
.LP
.OH "'CoLibri Reference Manual''ExternFile::GetSize'"
.EH "'ExternFile::GetSize''CoLibri Reference Manual'"
.bp
.NX 4 "GetSize"
.sp
.IP MODULE
\f(HBExternFile\fP
.IP TYPE
\f(HBExternFile = File\fP
.IP SYNOPSIS
\f(HBMETHOD GetSize () : FILEPOS;\fP
.IP DESCRIPTION
The method \f(HOGetSize\fP returns the size of the current file object.
.IP NOTE
FILEPOS is of type LONG INT and declared in the module \f(HOExternFile\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP EXAMPLES
.KS
.CS L
VAR file : TextFile::TextFile;
VAR size : ExternFile::FILEPOS;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.write);
\&...
size := file.GetSize ();
.CE
.KE
Now size contains the size of the current file object.
.IP "SEE ALSO"
\f(HOGetMode\fP,
\f(HOGetName\fP
.LP
.OH "'CoLibri Reference Manual''ExternFile::IsOpen'"
.EH "'ExternFile::IsOpen''CoLibri Reference Manual'"
.bp
.NX 4 "IsOpen"
.sp
.IP MODULE
\f(HBExternFile\fP
.IP TYPE
\f(HBExternFile = File\fP
.IP SYNOPSIS
\f(HBMETHOD IsOpen () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsOpen\fP tests whether the current file object is open.
The current file object is open, if the method \f(HOOpen\fP was called 
before.
.IP "RETURN VALUE"
This method returns TRUE, if the current file object is open. 
Otherwise it returns FALSE. 
.IP EXAMPLES
.KS
.CS L
VAR file   : TextFile::TextFile;
VAR result : BOOL;
\&...
file   := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.write);
\&...
result := file.IsOpen ();
.CE
.KE
Now result has the value TRUE.
.IP "SEE ALSO"
\f(HOClose\fP,
\f(HOOpen\fP
.LP
.OH "'CoLibri Reference Manual''ExternFile::Open'"
.EH "'ExternFile::Open''CoLibri Reference Manual'"
.bp
.NX 4 "Open"
.sp
.IP MODULE
\f(HBExternFile\fP
.IP TYPE
\f(HBExternFile = File\fP
.IP SYNOPSIS
\f(HBMETHOD Open ( IN mode : DIRECTION );\fP
.IP DESCRIPTION
The method \f(HOOpen\fP opens the current file object with the desired 
access \f(HOmode\fP.
.IP NOTE
DIRECTION is an enumeration type which knows the variants \f(HOread\fP,
\f(HOwrite\fP and \f(HOappend\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsAlreadyOpen\fP"
is raised, if the current file object was already opened before.
.IP "\(bu \f(HOCannotOpenFile\fP"
is raised, if the current file object is opened with a wrong mode, e.g. 
no write access for the current process of the user.
.IP EXAMPLES
.KS
.CS L
VAR file : TextFile::TextFile;
VAR mode : ExternFile::DIRECTION;
\&...
file := NEW TextFile::TextFile ("test.txt");
mode := ExternFile::DIRECTION.write;
file.Open (mode);
.CE
.KE
Now the file "test.txt" is open for write accesses.
.IP "SEE ALSO"
\f(HOClose\fP,
\f(HOIsOpen\fP
.LP
.OH "'CoLibri Reference Manual''ExternFile'"
.EH "'ExternFile''CoLibri Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the methods provided by the object 
type \f(HOExternFile\fP.
.br
The column A/C/N shows whether the method is
.IP \(bu 3
an abstract method (A),
.IP \(bu 3
a concretion of an inheritead abstract method (C),
.IP \(bu 3
a new method (N),
.IP \(bu 3
an inherited method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
A/C/N$Name$Mode$Parameter$Type$Exceptions
=
N$Close$$$$FileIsNotOpen
_
N$Flush$$$$FileIsNotOpen
$$$$$FileIsNotOpenedForWriting
_
N$GetMode$result$$DIRECTION$FileIsNotOpen
_
N$GetName$result$$STRING$FileIsNotOpen
_
N$GetSize$result$$FILEPOS$FileIsNotOpen
_
N$IsOpen$result$$BOOL$
_
N$Open$IN$mode$DIRECTION$CannotOpenFile
$$$$$FileIsAlreadyOpen
_
A$ReadBcd$result$$BCD$                                               
_
A$ReadChar$result$$CHAR$                                             
_
A$ReadDouble$result$$DOUBLE$                                         
_
A$ReadInt$result$$INT$                                               
_
A$ReadString$result$$STRING$                                         
_
A$WriteBcd$IN$value$BCD$                                      
_
A$WriteChar$IN$value$CHAR$                                    
_
A$WriteDouble$IN$value$DOUBLE$                                
_
A$WriteInt$IN$value$INT$                                  
_
A$WriteString$IN$value$STRING$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibri Reference Manual''TextFile'"
.EH "'TextFile''CoLibri Reference Manual'"
.bp
.NX 2 "TextFile"
.sp
.NX 3 "Type Description"
.sp
\f(HOTextFile\fP is an object type which provides a set of
methods for read and write access on the contents of files.
\f(HOTextFile\fP is the subtype of the abstract object type 
\f(HOExternFile\fP which is itself the subtype of the abstract object
type \f(HOFile\fP.
.sp
.NX 3 "List of Methods"
.sp
The following methods are available in <TextFile.cs>:
.TS
tab($);
l l.
Method name$C(oncretion)/N(ew)
_
Close$
Flush$
GetMode$
GetName$
GetSize$
IsEndOfFile$
IsOpen$
Open$
ReadBcd$C
ReadChar$C
ReadDouble$C
ReadInt$C
ReadLine$N
ReadString$C
SkipNewline$N
WriteBcd$C
WriteChar$C
WriteDouble$C
WriteInt$C
WriteLine$N
WriteNewline$N
WriteString$C
.TE
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
.KS
The following exceptions can be raised using module \f(HOTextFile\fP :
.TS
tab($);
l.
exception name
_
ExternFile::CannotOpenFile
ExternFile::FileIsAlreadyOpen
ExternFile::FileIsNotOpen
ExternFile::FileIsNotOpenedForWriting
FileIsNotOpenedForReading
ReadingFailed
WritingFailed
.TE
.KE
.sp
.NX 3 "How to use TextFile"
.sp
A variable of type \f(HOTextFile\fP is declared as follows:
.CS L
VAR text_file : TextFile::TextFile;
.CE
.sp 0.5
A variable of type \f(HOTextFile\fP can be initialized using the CooL
constructor NEW.
.sp
Each CooL module which uses the type \f(HOTextFile\fP must
import the module \f(HOTextFile\fP:
.CS L
IMPORT ..., TextFile, ...;
.CE
.LP
.sp 0.5
Three global object variables exist at runtime of an application which 
uses the module \f(HOTextFile\fP, to make it very simple to handle
input/output via the predefined standard devices:
.IP
std_in -- standard input device
.IP
std_out -- standard output device
.IP
std_err -- standard error output device
.IP NOTE
It is not allowed to modify these object variables at runtime, but to 
use all the exported methods listed above.
.KS
.IP EXAMPLES
.CS L
VAR text  : STRING;
VAR value : INT;
\&...
text    := "Enter a number (1..10)";
TextFile::std_out.WriteString (text); 
           -- the text is written on standard output

value   := TextFile::std_in.ReadInt (); 
           -- the value is read from standard input

IF (value < 1) OR (value > 10)
THEN
   TextFile::std_err.WriteLine ("value is out of range !");
           -- the text is written on standard error output
END IF;
.CE
.KE
.LP
.sp 0.5
.NX 3 "Method Description"
.sp
The following sections contain the syntactical and semantical 
description of all methods provided by \f(HOTextFile\fP.
They are listed in alphabetical order.
.LP
.OH "'CoLibri Reference Manual''ExternFile::IsEndOfFile'"
.EH "'ExternFile::IsEndOfFile''CoLibri Reference Manual'"
.bp
.NX 4 "IsEndOfFile"
.sp
.IP MODULE
\f(HBExternFile\fP
.IP TYPE
\f(HBExternFile = File\fP
.IP SYNOPSIS
\f(HBMETHOD IsEndOfFile () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEndOfFile\fP tests whether the cursor
has reached the end of current file object.
.IP "RETURN VALUE"
This method returns TRUE, if the cursor
has reached the end of current file object.
Otherwise it returns FALSE. 
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP "\(bu \f(HOFileIsNotOpenedForReading\fP"
is raised, if the current file object was not opened before for reading.
.KS
.IP EXAMPLES
.KS
.CS L
VAR file   : TextFile::TextFile;
VAR result : BOOL;
\&...
file   := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.write);
\&...
result := file.IsEndOfFile ();
.LP
.OH "'CoLibri Reference Manual''TextFile::ReadBcd'"
.EH "'TextFile::ReadBcd''CoLibri Reference Manual'"
.bp
.NX 4 "ReadBcd"
.sp
.IP MODULE
\f(HBTextFile\fP
.IP TYPE
\f(HBTextFile = ExternFile\fP
.IP SYNOPSIS
\f(HBMETHOD ReadBcd () : BCD;\fP
.IP DESCRIPTION
The method \f(HOReadBcd\fP reads a variable of type BCD from the 
current file object.
.IP "RETURN VALUE"
The function returns a value of type BCD.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP "\(bu \f(HOFileIsNotOpenedForReading\fP"
is raised, if the current file object was not opened before for reading.
.IP "\(bu \f(HOReadingFailed\fP"
is raised, if a reading error occured in the current file object.
.KS
.IP EXAMPLES
.CS L
VAR file   : TextFile::TextFile;
VAR result : Bcd::BCD;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.read);
\&...
result := file.ReadBcd ();
.CE
Now result contains the read BCD value.
.IP "SEE ALSO"
\f(HOWriteBcd\fP
.LP
.OH "'CoLibri Reference Manual''TextFile::ReadChar'"
.EH "'TextFile::ReadChar''CoLibri Reference Manual'"
.bp
.NX 4 "ReadChar"
.sp
.IP MODULE
\f(HBTextFile\fP
.IP TYPE
\f(HBTextFile = ExternFile\fP
.IP SYNOPSIS
\f(HBMETHOD ReadChar () : CHAR;\fP
.IP DESCRIPTION
The method \f(HOReadChar\fP reads a variable of type CHAR from the 
current file object.
.IP "RETURN VALUE"
The function returns a value of type CHAR.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP "\(bu \f(HOFileIsNotOpenedForReading\fP"
is raised, if the current file object was not opened before for reading.
.IP "\(bu \f(HOReadingFailed\fP"
is raised, if a reading error occured in the current file object.
.KS
.IP EXAMPLES
.CS L
VAR file   : TextFile::TextFile;
VAR result : CHAR;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.read);
\&...
result := file.ReadChar ();
.CE
Now result contains the read CHAR value.
.IP "SEE ALSO"
\f(HOWriteChar\fP
.LP
.OH "'CoLibri Reference Manual''TextFile::ReadDouble'"
.EH "'TextFile::ReadDouble''CoLibri Reference Manual'"
.bp
.NX 4 "ReadDouble"
.sp
.IP MODULE
\f(HBTextFile\fP
.IP TYPE
\f(HBTextFile = ExternFile\fP
.IP SYNOPSIS
\f(HBMETHOD ReadDouble () : DOUBLE;\fP
.IP DESCRIPTION
The method \f(HOReadDouble\fP reads a variable of type DOUBLE from the 
current file object.
.IP "RETURN VALUE"
The function returns a value of type DOUBLE.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP "\(bu \f(HOFileIsNotOpenedForReading\fP"
is raised, if the current file object was not opened before for reading.
.IP "\(bu \f(HOReadingFailed\fP"
is raised, if a reading error occured in the current file object.
.KS
.IP EXAMPLES
.CS L
VAR file   : TextFile::TextFile;
VAR result : DOUBLE;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.read);
\&...
result := file.ReadDouble ();
.CE
Now result contains the read DOUBLE value.
.IP "SEE ALSO"
\f(HOWriteDouble\fP
.LP
.OH "'CoLibri Reference Manual''TextFile::ReadInt'"
.EH "'TextFile::ReadInt''CoLibri Reference Manual'"
.bp
.NX 4 "ReadInt"
.sp
.IP MODULE
\f(HBTextFile\fP
.IP TYPE
\f(HBTextFile = ExternFile\fP
.IP SYNOPSIS
\f(HBMETHOD ReadInt () : INT;\fP
.IP DESCRIPTION
The method \f(HOReadInt\fP reads a variable of type INT from the 
current file object.
.IP "RETURN VALUE"
The function returns a value of type INT.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP "\(bu \f(HOFileIsNotOpenedForReading\fP"
is raised, if the current file object was not opened before for reading.
.IP "\(bu \f(HOReadingFailed\fP"
is raised, if a reading error occured in the current file object.
.KS
.IP EXAMPLES
.CS L
VAR file   : TextFile::TextFile;
VAR result : INT;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.read);
\&...
result := file.ReadInt ();
.CE
Now result contains the read INT value.
.IP "SEE ALSO"
\f(HOWriteInt\fP
.LP
.OH "'CoLibri Reference Manual''TextFile::ReadLine'"
.EH "'TextFile::ReadLine''CoLibri Reference Manual'"
.bp
.NX 4 "ReadLine"
.sp
.IP MODULE
\f(HBTextFile\fP
.IP TYPE
\f(HBTextFile = ExternFile\fP
.IP SYNOPSIS
\f(HBMETHOD ReadLine () : STRING;\fP
.IP DESCRIPTION
The method \f(HOReadLine\fP reads a STRING from the current file object
up to the next new-line control-character. 
The new-line control-character will be skipped.
.IP "RETURN VALUE"
The function returns a line of type STRING without the new-line 
control-character.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP "\(bu \f(HOFileIsNotOpenedForReading\fP"
is raised, if the current file object was not opened before for reading.
.IP "\(bu \f(HOReadingFailed\fP"
is raised, if a reading error occured in the current file object.
.KS
.IP EXAMPLES
.CS L
VAR file : TextFile::TextFile;
VAR line : STRING;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.read);
\&...
line := file.ReadLine ();
.CE
Now line contains the contents of the current line of the current file
object.
.IP "SEE ALSO"
\f(HOWriteLine\fP
.LP
.OH "'CoLibri Reference Manual''TextFile::ReadString'"
.EH "'TextFile::ReadString''CoLibri Reference Manual'"
.bp
.NX 4 "ReadString"
.sp
.IP MODULE
\f(HBTextFile\fP
.IP TYPE
\f(HBTextFile = ExternFile\fP
.IP SYNOPSIS
\f(HBMETHOD ReadString () : STRING;\fP
.IP DESCRIPTION
The method \f(HOReadString\fP reads a STRING from the current file 
object up to the next new-line control-character.
.IP "RETURN VALUE"
The function returns a result of type STRING without the new-line 
control-character.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP "\(bu \f(HOFileIsNotOpenedForReading\fP"
is raised, if the current file object was not opened before for reading.
.IP "\(bu \f(HOReadingFailed\fP"
is raised, if a reading error occured in the current file object.
.KS
.IP EXAMPLES
.CS L
VAR file   : TextFile::TextFile;
VAR result : STRING;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.read);
\&...
result := file.ReadString ();
.CE
Now result contains the read STRING value.
.IP "SEE ALSO"
\f(HOWriteString\fP
.LP
.OH "'CoLibri Reference Manual''TextFile::SkipNewline'"
.EH "'TextFile::SkipNewline''CoLibri Reference Manual'"
.bp
.NX 4 "SkipNewline"
.sp
.IP MODULE
\f(HBTextFile\fP
.IP TYPE
\f(HBTextFile = ExternFile\fP
.IP SYNOPSIS
\f(HBMETHOD SkipNewline;\fP
.IP DESCRIPTION
The method \f(HOSkipNewline\fP skips the next following new-line 
control-character of the current line of the current file object.
.IP NOTE
The new-line control-character must be the next character after the 
current cursor position.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP "\(bu \f(HOFileIsNotOpenedForReading\fP"
is raised, if the current file object was not opened before for reading.
.IP "\(bu \f(HOReadingFailed\fP"
is raised, if a reading error occured in the current file object.
.KS
.IP EXAMPLES
.CS L
VAR file   : TextFile::TextFile;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.read);
\&...
file.SkipNewline;
.CE
Now the new-line control-character was skipped over.
.LP
.OH "'CoLibri Reference Manual''TextFile::WriteBcd'"
.EH "'TextFile::WriteBcd''CoLibri Reference Manual'"
.bp
.NX 4 "WriteBcd"
.sp
.IP MODULE
\f(HBTextFile\fP
.IP TYPE
\f(HBTextFile = ExternFile\fP
.IP SYNOPSIS
\f(HBMETHOD WriteBcd ( IN value : BCD );\fP
.IP DESCRIPTION
The method \f(HOWriteBcd\fP writes a variable of type BCD into the 
current file object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP "\(bu \f(HOFileIsNotOpenedForWriting\fP"
is raised, if the current file object was not opened before for writing.
.IP "\(bu \f(HOWritingFailed\fP"
is raised, if a writing error occured in the current file object.
.KS
.IP EXAMPLES
.CS L
VAR bcd  : Bcd::BCD;
VAR file : TextFile::TextFile;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.write);
\&...
bcd := Conversions::StringToBcd ("-5.1");
file.WriteBcd (bcd);
.CE
Now the BCD value -5.1 is written into the current object file.
.IP "SEE ALSO"
\f(HOReadBcd\fP
.LP
.OH "'CoLibri Reference Manual''TextFile::WriteChar'"
.EH "'TextFile::WriteChar''CoLibri Reference Manual'"
.bp
.NX 4 "WriteChar"
.sp
.IP MODULE
\f(HBTextFile\fP
.IP TYPE
\f(HBTextFile = ExternFile\fP
.IP SYNOPSIS
\f(HBMETHOD WriteChar ( IN value : CHAR );\fP
.IP DESCRIPTION
The method \f(HOWriteChar\fP writes a variable of type CHAR into the 
current file object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP "\(bu \f(HOFileIsNotOpenedForWriting\fP"
is raised, if the current file object was not opened before for writing.
.IP "\(bu \f(HOWritingFailed\fP"
is raised, if a writing error occured in the current file object.
.KS
.IP EXAMPLES
.CS L
VAR char : CHAR;
VAR file : TextFile::TextFile;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.write);
\&...
char := 'x';
file.WriteChar (char);
.CE
Now an 'x' is written into the current object file.
.IP "SEE ALSO"
\f(HOReadChar\fP
.LP
.OH "'CoLibri Reference Manual''TextFile::WriteDouble'"
.EH "'TextFile::WriteDouble''CoLibri Reference Manual'"
.bp
.NX 4 "WriteDouble"
.sp
.IP MODULE
\f(HBTextFile\fP
.IP TYPE
\f(HBTextFile = ExternFile\fP
.IP SYNOPSIS
\f(HBMETHOD WriteDouble ( IN value : DOUBLE );\fP
.IP DESCRIPTION
The method \f(HOWriteDouble\fP writes a variable of type DOUBLE into the
current file object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP "\(bu \f(HOFileIsNotOpenedForWriting\fP"
is raised, if the current file object was not opened before for writing.
.IP "\(bu \f(HOWritingFailed\fP"
is raised, if a writing error occured in the current file object.
.KS
.IP EXAMPLES
.CS L
VAR double : DOUBLE;
VAR file   : TextFile::TextFile;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.write);
\&...
double := -5.1;
file.WriteDouble (double);
.CE
Now the DOUBLE value -5.1 is written into the current object file.
.IP "SEE ALSO"
\f(HOReadDouble\fP
.LP
.OH "'CoLibri Reference Manual''TextFile::WriteInt'"
.EH "'TextFile::WriteInt''CoLibri Reference Manual'"
.bp
.NX 4 "WriteInt"
.sp
.IP MODULE
\f(HBTextFile\fP
.IP TYPE
\f(HBTextFile = ExternFile\fP
.IP SYNOPSIS
\f(HBMETHOD WriteInt ( IN value : INT );\fP
.IP DESCRIPTION
The method \f(HOWriteInt\fP writes a variable of type INT into the 
current file object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP "\(bu \f(HOFileIsNotOpenedForWriting\fP"
is raised, if the current file object was not opened before for writing.
.IP "\(bu \f(HOWritingFailed\fP"
is raised, if a writing error occured in the current file object.
.KS
.IP EXAMPLES
.CS L
VAR file    : TextFile::TextFile;
VAR integer : INT;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.write);
\&...
integer := 5;
file.WriteInt (integer);
.CE
Now the INT value 5 is written into the current object file.
.IP "SEE ALSO"
\f(HOReadInt\fP
.LP
.OH "'CoLibri Reference Manual''TextFile::WriteLine'"
.EH "'TextFile::WriteLine''CoLibri Reference Manual'"
.bp
.NX 4 "WriteLine"
.sp
.IP MODULE
\f(HBTextFile\fP
.IP TYPE
\f(HBTextFile = ExternFile\fP
.IP SYNOPSIS
\f(HBMETHOD WriteLine ( IN line : STRING );\fP
.IP DESCRIPTION
The method \f(HOWriteLine\fP writes the \f(HOline\fP into the 
current file object and writes additionally a new-line control-character
after the \f(HOline\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP "\(bu \f(HOFileIsNotOpenedForWriting\fP"
is raised, if the current file object was not opened before for writing.
.IP "\(bu \f(HOWritingFailed\fP"
is raised, if a writing error occured in the current file object.
.KS
.IP EXAMPLES
.CS L
VAR file : TextFile::TextFile;
VAR line : STRING;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.write);
\&...
line := "Hello world!";
file.WriteLine (line);
.CE
Now "Hello world!" and a new-line control-character are written into the
current object file.
.IP "SEE ALSO"
\f(HOReadLine\fP
.LP
.OH "'CoLibri Reference Manual''TextFile::WriteNewline'"
.EH "'TextFile::WriteNewline''CoLibri Reference Manual'"
.bp
.NX 4 "WriteNewline"
.sp
.IP MODULE
\f(HBTextFile\fP
.IP TYPE
\f(HBTextFile = ExternFile\fP
.IP SYNOPSIS
\f(HBMETHOD WriteNewline;\fP
.IP DESCRIPTION
The method \f(HOWriteNewline\fP writes a new-line control-character into
the current file object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP "\(bu \f(HOFileIsNotOpenedForWriting\fP"
is raised, if the current file object was not opened before for writing.
.IP "\(bu \f(HOWritingFailed\fP"
is raised, if a writing error occured in the current file object.
.KS
.IP EXAMPLES
.CS L
VAR file : TextFile::TextFile;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.write);
\&...
file.WriteNewline;
.CE
Now a new-line control-character was written into the current object 
file.
.IP "SEE ALSO"
\f(HOReadLine\fP
.LP
.OH "'CoLibri Reference Manual''TextFile::WriteString'"
.EH "'TextFile::WriteString''CoLibri Reference Manual'"
.bp
.NX 4 "WriteString"
.sp
.IP MODULE
\f(HBTextFile\fP
.IP TYPE
\f(HBTextFile = ExternFile\fP
.IP SYNOPSIS
\f(HBMETHOD WriteString ( IN value : STRING );\fP
.IP DESCRIPTION
The method \f(HOWriteString\fP writes a variable of type STRING into the
current file object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOFileIsNotOpen\fP"
is raised, if the current file object was not opened before.
.IP "\(bu \f(HOFileIsNotOpenedForWriting\fP"
is raised, if the current file object was not opened before for writing.
.IP "\(bu \f(HOWritingFailed\fP"
is raised, if a writing error occured in the current file object.
.KS
.IP EXAMPLES
.CS L
VAR file   : TextFile::TextFile;
VAR string : STRING;
\&...
file := NEW TextFile::TextFile ("test.txt");
file.Open (ExternFile::DIRECTION.write);
\&...
string := "Hello world!";
file.WriteString (string);
.CE
Now the STRING "Hello world!" is written into the current object file.
.IP "SEE ALSO"
\f(HOReadString\fP
.LP
.OH "'CoLibri Reference Manual''TextFile'"
.EH "'TextFile''CoLibri Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the methods provided by the object 
type \f(HOTextFile\fP.
.br
The column A/C/N shows whether the method is
.IP \(bu 3
an abstract method (A),
.IP \(bu 3
a concretion of an inheritead abstract method (C),
.IP \(bu 3
a new method (N),
.IP \(bu 3
an inherited method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
A/C/N$Name$Mode$Parameter$Type$Exceptions
=
$Close$$$$FileIsNotOpen
_
$Flush$$$$FileIsNotOpen
_
$GetMode$result$$DIRECTION$FileIsNotOpen
_
$GetName$result$$STRING$FileIsNotOpen
_
$GetSize$result$$FILEPOS$FileIsNotOpen
_
N$IsEndOfFile$result$$BOOL$FileIsNotOpen
$$$$$FileIsNotOpenedForReading
_
$IsOpen$result$$BOOL$
_
$Open$IN$mode$DIRECTION$CannotOpenFile
$$$$$FileIsAlreadyOpen
_
C$ReadBcd$result$$BCD$FileIsNotOpen
$$$$$FileIsNotOpenedForReading                                               
$$$$$ReadingFailed
_
C$ReadChar$result$$CHAR$FileIsNotOpen
$$$$$FileIsNotOpenedForReading
$$$$$ReadingFailed
_
C$ReadDouble$result$$DOUBLE$FileIsNotOpen
$$$$$FileIsNotOpenedForReading
$$$$$ReadingFailed
_
C$ReadInt$result$$INT$FileIsNotOpen
$$$$$FileIsNotOpenedForReading
$$$$$ReadingFailed
_
N$ReadLine$result$$STRING$FileIsNotOpen
$$$$$FileIsNotOpenedForReading
$$$$$ReadingFailed
_
C$ReadString$result$$STRING$FileIsNotOpen
$$$$$FileIsNotOpenedForReading
$$$$$ReadingFailed
_
N$SkipNewline$$$$FileIsNotOpen
$$$$$FileIsNotOpenedForReading
$$$$$ReadingFailed
_
C$WriteBcd$IN$value$BCD$FileIsNotOpen
$$$$$FileIsNotOpenedForWriting
$$$$$WritingFailed
_
C$WriteChar$IN$value$CHAR$FileIsNotOpen
$$$$$FileIsNotOpenedForWriting
$$$$$WritingFailed
_
C$WriteDouble$IN$value$DOUBLE$FileIsNotOpen
$$$$$FileIsNotOpenedForWriting
$$$$$WritingFailed
_
C$WriteInt$IN$value$INT$FileIsNotOpen
$$$$$FileIsNotOpenedForWriting
$$$$$WritingFailed
_
N$WriteLine$IN$line$STRING$FileIsNotOpen
$$$$$FileIsNotOpenedForWriting
$$$$$WritingFailed
_
N$WriteNewline$$$$FileIsNotOpen
$$$$$FileIsNotOpenedForWriting
$$$$$WritingFailed
_
C$WriteString$IN$value$STRING$FileIsNotOpen
$$$$$FileIsNotOpenedForWriting
$$$$$WritingFailed
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'CoLibri Reference Manual''Contents'"
.EH "'Contents''CoLibri Reference Manual'"
.PX

