/*------------------------------------------------------------------
 *
 *              C - Interface for CooL - Doi
 *
 *  This module contains all DoiGet...
 *                       and DoiPut... functions of Doi
 *
 *------------------------------------------------------------------
 *------- external used functions ----------------------------------
 *------------------------------------------------------------------
 *    int  DoiGetDate           (Widget,XcDateStruct*,char*);
 *    int  DoiGetDateTable      (Widget,XcDateStruct*,int,int);
 *    int  DoiGetDouble         (Widget,double*,char*);
 *    int  DoiGetDoubleF        (Widget,double*,int*);
 *    int  DoiGetDoubleTable    (Widget,double*,int,int);
 *    int  DoiGetDoubleFTable   (Widget,double*,int*,int,int);
 *    int  DoiGetInt            (Widget,int*,char*);
 *    int  DoiGetIntF           (Widget,int*,int*);
 *    int  DoiGetIntTable       (Widget,int*,int,int);
 *    int  DoiGetIntFTable      (Widget,int*,int*,int,int);
 *    int  DoiGetString         (Widget,char*,int,char*);
 *    int  DoiGetStringTable    (Widget,char*,int,int,int);
 *    void DoiPutDate           (Widget,XcDateStruct,char*);
 *    void DoiPutDateTable      (Widget,XcDateStruct,int,int);
 *    void DoiPutDouble         (Widget,double,char*);
 *    void DoiPutDoubleTable    (Widget,double,int,int);
 *    void DoiPutInt            (Widget,int,char *);
 *    void DoiPutIntTable       (Widget,int,int,int);
 *    void DoiPutString         (Widget,char*,char*);
 *    void DoiPutStringTable    (Widget,char*,int,int);
 *    void DoiClearIntF         (Widget);
 *    void DoiClearDoubleF      (Widget);
 *    void DoiClearIntFTable    (Widget,int,int);
 *    void DoiClearDoubleFTable (Widget,int,int);
 *------------------------------------------------------------------*/

#ifndef FORMAT
      int  DoiGetDouble         (){return -1;}
      int  DoiGetDoubleF        (){return -1;}
      int  DoiGetDoubleTable    (){return -1;}
      int  DoiGetDoubleFTable   (){return -1;}
      int  DoiGetDate           (){return -1;}
      int  DoiGetDateTable      (){return -1;}
      void DoiPutDouble         (){return;}
      void DoiPutDoubleTable    (){return;}
      void DoiPutDate           (){return;}
      void DoiPutDateTable      (){return;}
      void DoiPutStringTable    (){return;}
      int  DoiGetStringTable    (){return -1;}
      void DoiPutIntTable       (){return;}
      int  DoiGetIntF           (){return -1;}
      int  DoiGetIntTable       (){return -1;}
      int  DoiGetIntFTable      (){return -1;}
      void DoiClearIntF         (){return;}
      void DoiClearIntFTable    (){return;}
      void DoiClearDoubleF      (){return;}
      void DoiClearDoubleFTable (){return;}
#endif

/*------------------------------------------------------------------*/

#include <stdio.h>
#include <sys/errno.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/MenuShell.h>
#include <Xm/ArrowB.h>
#include <Xm/ArrowBG.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/Command.h>
#include <Xm/FileSB.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/MessageB.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/SelectioB.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>

#ifdef FORMAT
#include <Xc/FormatAlph.h>
#include <Xc/FormatNum.h>
#include <Xc/Format.h>
#include <Xc/FormatDate.h>
#include <Xc/Table.h>
#endif

/*------------------------------------------------------------------*/
#define StringEnd '\0'


/*------------------------------------------------------------------*/
extern int DoiDebugFlag;

#ifdef FORMAT
/*------------------------------------------------------------------*/
static int formError;
static XtPointer userData;

/*------------------------------------------------------------------
 * The following functions _DoiClearError and _DoiErrorSet are
 * implemented for more convenient error reporting by the DoiGet...
 * routines when using format widgets and table widgets.
 * For detecting form errors and plausi errors using format widgets
 * whithin in a table widget, when fetching the value, first the
 * function _DoiClearError must be called. This function saves the
 * pointer to the XmNuserdata value and sets as new XmNuserdata
 * the address of an variable containing XcNO_ERROR. If the 
 * formErrorCallback or plausErrorCallback procedures are called,
 * the contents of the XmNuserdata must be set within in these
 * callback routines to a value not equal XcNO_ERROR.
 * The function _DoiErrorSet checks wether the contents of the
 * XmNuserdata are XcNO_ERROR or not. If NOT then we know that an error
 * occurred. Before the function is leaved the original XmNuserdata
 * pointer is restored.
 * When the user written callback routines formErrorCallback and
 * plausErrorCallback do not support this mechanism, no error can
 * be reported by the DoiGet... routines. Just the actual value of the
 * format widget is the returned.
 *------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
static void _DoiClearError (Widget PRwidget)
  /* saves the userdata into userData and
   * sets 0 into formError and
   * sets formError as  userdata of the given widget
   */
{
Arg args[2];
int n;
    n    = 0;
    XtSetArg(args[n],XmNuserData,&userData); n++;
    XtGetValues(PRwidget,args,n);
    formError = XcNO_ERROR;
    n    = 0;
    XtSetArg(args[n],XmNuserData,&formError); n++;
    XtSetValues(PRwidget,args,n);
  
}

/*------------------------------------------------------------------*/
static int _DoiErrorSet (Widget PRwidget)
  /* sets the saved user data again
   * and checks the formError
   * The formError is set in the callback routine
   * of the format widget, if an format or plausi error occurs
   */
{
Arg args[2];
int n;
    n    = 0;
    XtSetArg(args[n],XmNuserData,userData); n++;
    XtSetValues(PRwidget,args,n);

    if (formError != XcNO_ERROR)
      return -1;
    return 0;
}
#endif

/*------------------------------------------------------------------*/
static int getDefaultAttribute(
  /* read the default attribute of a widget and returns the type
     of the value */
  Widget PRwidget,
  char *PRattribute
  )
{
  WidgetClass wclass;
  if (DoiDebugFlag) printf("getDefaultAttribute\n");
  if (PRwidget == NULL) return -1;
  wclass = XtClass(PRwidget);
  if (wclass == xmTextWidgetClass){                  /* Text */
    strcpy(PRattribute,XmNvalue);
  }else if (wclass == xmTextFieldWidgetClass){       /* TextField */
    strcpy(PRattribute,XmNvalue);
#ifdef FORMAT
  }else if (wclass == xcFormatAlphanumWidgetClass){  /* FormatAlphanum */
    strcpy(PRattribute,XcNfValue);
  }else if (wclass == xcFormatNumericWidgetClass){   /* FormatNumeric */
    strcpy(PRattribute,XcNfValue);
  }else if (wclass == xcFormatDateWidgetClass){      /* FormatDate */
    strcpy(PRattribute,XcNfValue);
#endif
  }else if (wclass == xmPushButtonWidgetClass ||
            wclass == xmPushButtonGadgetClass){      /* PushButton */
    strcpy(PRattribute,XmNlabelString);
  }else if (wclass == xmToggleButtonWidgetClass ||
            wclass == xmToggleButtonGadgetClass){    /* ToggleButton */
    strcpy(PRattribute,XmNset);
  }else if (wclass == xmScaleWidgetClass){           /* Scale */
    strcpy(PRattribute,XmNvalue);
  }else if (wclass == xmScrollBarWidgetClass){       /* ScrollBar */
    strcpy(PRattribute,XmNvalue);
  }else if (wclass == xmArrowButtonWidgetClass ||
            wclass == xmArrowButtonGadgetClass){     /* ArrowButton */
    strcpy(PRattribute,XmNarrowDirection);
  }else if (wclass == xmBulletinBoardWidgetClass){   /* BulletinBoard */
    strcpy(PRattribute,XmNdialogTitle);
  }else if (wclass == xmCascadeButtonWidgetClass || wclass == xmCascadeButtonGadgetClass){   /* CascadeButton */
    strcpy(PRattribute,XmNlabelString);
  }else if (wclass == xmCommandWidgetClass){         /* Command */
    strcpy(PRattribute,XmNcommand);
  }else if (wclass == xmFileSelectionBoxWidgetClass){/* FileSelectionBox */
    strcpy(PRattribute,XmNdirSpec);
  }else if (wclass == xmLabelWidgetClass || wclass == xmLabelGadgetClass){           /* Label */
    strcpy(PRattribute,XmNlabelString);
  }else if (wclass == xmListWidgetClass){            /* List */
    strcpy(PRattribute,XmNitemCount);
  }else if (wclass == xmMessageBoxWidgetClass){      /* MessageBox */
    strcpy(PRattribute,XmNmessageString);
  }else if (wclass == xmSelectionBoxWidgetClass){    /* SelectionBox */
    strcpy(PRattribute,XmNtextString);
  }else return -1; /* all other widgets */
   if (DoiDebugFlag) printf("getDefaultAttribute: attr = %s\n",PRattribute);
   return 0;
}/* getDefaultAttribute */

/*------------------------------------------------------------------*/
#define GETINT(val) \
			XtVaGetValues (PRwidget,attr,&val,NULL);\
            *PRint = (int) val;\
  			XtFree ((char*)freeResList);\
  			if (DoiDebugFlag) printf ("   returns for %s %d\n",attr,*PRint);\
  			return 0;

/*------------------------------------------------------------------*/
int DoiGetInt(
  /* reads the Integer value of a widget */
  Widget PRwidget,
  int*   PRint,
  char*  PRattribute
  )
{
  extern int errno;
  char* string;
  int   i, numRes;
  XtResourceList resList, freeResList;
  char attribute[100];
  char *attr;
  int   intValue;
  short shortValue;
  char  charValue;
  unsigned char ucharValue;
  

  if (DoiDebugFlag) printf("DoiGetInt for widget %x attribute '%s'\n",PRwidget,PRattribute);

  if (PRwidget == NULL){
    if (DoiDebugFlag) printf ("   (1) returns -1\n");
    return -1;
  }

  if (*PRattribute == StringEnd){
    /* default attribute depends on the widget class */
    if (getDefaultAttribute(PRwidget,&attribute[0])){
      if (DoiDebugFlag) printf ("   (2) returns -1\n");
      return -1;
    }
  }else 
    strcpy(attribute,PRattribute);

  attr = attribute;
  /* strip 'X...N', e.g. XmNx -> x or XcNfValue -> fValue */
  if (strlen(attribute)>(size_t)3)
  if (attribute[0]=='X')
  if (attribute[2]=='N')
    attr = &attribute[2];
#ifdef FORMAT
  if (XtClass(PRwidget) == xcFormatNumericWidgetClass){
    /* first activate format and plausi checking */
    _DoiClearError (PRwidget);
    if (XcFormatActivateWidget (PRwidget,False) == XcNO_ERROR){
      /* fetch the value */
      *PRint = (int)XcFormatNumericGetLong (PRwidget);
      if (DoiDebugFlag) printf ("   returns value %d\n",*PRint);
      _DoiErrorSet (PRwidget);
      return 0;
    } else { /* format or plausi error */
      /* activate the error callbacks */
      XcFormatActivateWidget (PRwidget,True);
      _DoiErrorSet (PRwidget);
      if (DoiDebugFlag) printf ("   (3) returns -1\n");
      return -1;
    }
  }
#endif
  /* if the attribute is of type XmRString or XmRXmString
   * a conversion to int is done (or tried)
   */
  XtGetResourceList (XtClass(PRwidget),&resList,(Cardinal*)&numRes);
  freeResList = resList;
  for (i = 0; i < numRes; i++, resList++){
    if (!strcmp(resList->resource_name,attr)){
      if (DoiDebugFlag)printf ("   res_name '%s' is of type = '%s'\n",resList->resource_name,resList->resource_type);
      if (!strcmp(resList->resource_type,XmRXmString)){
        XmString xmString;
        XtFree ((char*)freeResList);
        XtVaGetValues (PRwidget,attr,&xmString,NULL);
        if (XmStringGetLtoR(xmString,XmSTRING_DEFAULT_CHARSET,&string))
          if (string && strlen(string) > (size_t)0){
            char *ptr = NULL;
            *PRint = (int) strtol(string, &ptr, 0);
            if (*PRint == 0 && ptr == string){
  			   if (DoiDebugFlag) printf ("   (4) returns -1\n");
			   return -1;    
            } else if (ptr != string+strlen(string)){
  			   if (DoiDebugFlag) printf ("   (6) returns -1\n");
			   return -1;    
            } else if (errno == ERANGE){
  			   if (DoiDebugFlag) printf ("   (7) returns -1\n");
               errno = 0;
			   return -1;    
            }
            if (DoiDebugFlag) printf ("   returns value %d\n",*PRint);
            return 0;
          }else{
            if (DoiDebugFlag) printf ("   (8) returns -1\n");
            return -1;
          }
        else{
          if (DoiDebugFlag) printf ("   (9) returns -1\n");
          return -1;
        }
      }else if (!strcmp(resList->resource_type,XmRString)){
        /* normal char* Typ */
        XtFree ((char*)freeResList);
        XtVaGetValues (PRwidget,attr,&string,NULL);
        if (string && strlen(string) > (size_t)0){
          char *ptr = NULL;
          *PRint = (int) strtol(string, &ptr, 0);
          if (*PRint == 0 && ptr == string){
  		    if (DoiDebugFlag) printf ("   (10) returns -1\n");
		    return -1;    
          } else if (ptr != string+strlen(string)){
  		    if (DoiDebugFlag) printf ("   (11) returns -1\n");
		    return -1;    
          } else if (errno == ERANGE){
  			 if (DoiDebugFlag) printf ("   (12) returns -1\n");
             errno = 0;
			 return -1;    
		  }
          if (DoiDebugFlag) printf ("   returns value %d\n",*PRint);
          return 0;
        }else{
          if (DoiDebugFlag) printf ("   (13) returns -1\n");
          return -1;  
        }
      }else if (!strcmp(resList->resource_type,XmRAlignment)){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,XmRArrowDirection)){
         GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,XmRBoolean)){
          GETINT (intValue);
      }else if (!strcmp(resList->resource_type,"BooleanDimension")){
          GETINT (shortValue);
      }else if (!strcmp(resList->resource_type,"Cardinal")){
          GETINT (intValue);
      }else if (!strcmp(resList->resource_type,XmRCommandWindowLocation)){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,"DefaultButtonType")){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,"DialogStyle")){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,"DialogType")){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,XmREditMode)){
          GETINT (intValue);
      }else if (!strcmp(resList->resource_type,"FileTypeMask")){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,XmRHorizontalDimension)){
          GETINT (shortValue);
      }else if (!strcmp(resList->resource_type,XmRHorizontalPosition)){
          GETINT (shortValue);
      }else if (!strcmp(resList->resource_type,XmRIndicatorType)){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,XmRInt)){
          GETINT (intValue);
      }else if (!strcmp(resList->resource_type,XmRKeySym)){
          GETINT (intValue);
      }else if (!strcmp(resList->resource_type,XmRLabelType)){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,"ListSizePolicy")){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,"MultiClick")){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,XmRNavigationType)){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,XmROrientation)){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,XmRPacking)){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,"ProcessingDirection")){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,"ResizePolicy")){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,XmRRowColumnType)){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,"ScrollBarDisplayPolicy")){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,"ScrollBarPlacement")){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,"ScrollingPolicy")){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,"SelectionPolicy")){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,"SeparatorType")){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,"ShadowType")){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,XmRShort)){
          GETINT (shortValue);
      }else if (!strcmp(resList->resource_type,XmRStringDirection)){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,XmRTextPosition)){
          GETINT (intValue);
      }else if (!strcmp(resList->resource_type,"UnitType")){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,XmRVerticalDimension)){
          GETINT (shortValue);
      }else if (!strcmp(resList->resource_type,XmRVerticalPosition)){
          GETINT (shortValue);
      }else if (!strcmp(resList->resource_type,"VisualPolicy")){
          GETINT (ucharValue);
      }else if (!strcmp(resList->resource_type,XmRWhichButton)){
          GETINT (intValue);
      }
    }
  }
  XtFree ((char*)freeResList);
  if (DoiDebugFlag) printf ("   (14) returns -1\n");
  return -1;
}/* DoiGetInt */


#ifdef FORMAT
/*------------------------------------------------------------------*/
int DoiGetIntF(
  /* reads the Integer value only of a XcNumericFormat widget */
  Widget PRwidget,
  int*   PRint,
  int*   PRvalid /*0: NULL value, 1: valid value in *PRint */
  )
{
  if (DoiDebugFlag) printf("DoiGetIntF for widget %x\n",PRwidget);

  if (PRwidget == NULL){
    if (DoiDebugFlag) printf ("   (1) returns -1\n");
    return -1;
  }

  if (XtClass(PRwidget) == xcFormatNumericWidgetClass){
    /* first activate format and plausi checking */
    _DoiClearError (PRwidget);
    if (XcFormatActivateWidget (PRwidget,False) == XcNO_ERROR){
      /* check whether there is a NULL string entered */
      if (XcFormatIsNullValue(PRwidget)){
        *PRvalid = 0; /* no valid value in *PRint !! */
        if (DoiDebugFlag) printf ("   returns NULL value\n");
        return 0;
      }
      /* fetch the value */
      *PRint = (int)XcFormatNumericGetLong (PRwidget);
      if (DoiDebugFlag) printf ("   returns value %d\n",*PRint);
      _DoiErrorSet (PRwidget);
      *PRvalid = 1;
      return 0;
    } else { /* format or plausi error */
      /* activate the error callbacks */
      XcFormatActivateWidget (PRwidget,True);
      _DoiErrorSet (PRwidget);
      if (DoiDebugFlag) printf ("   (3) returns -1\n");
      return -1;
    }
  }
  if (DoiDebugFlag) printf ("   (4) returns -1\n");
    return -1;
}/* DoiGetIntF */
#endif

/*------------------------------------------------------------------*/
int DoiGetString(
  /* reads the string attribute of a widget */
  Widget PRwidget,
  char*  PRstring,
  int    PRmaxLength,
  char*  PRattribute
  )
{
  XtResourceList resList, freeResList;
  char  attribute[100];
  char* attr;
  char* string;
  int   i, numRes;
  size_t len;

  if (DoiDebugFlag) printf("DoiGetString\n");

  if (PRwidget == NULL) return -1;

  if (*PRattribute == StringEnd){
    /* default attribute depends on the widget class */
    if (getDefaultAttribute(PRwidget,&attribute[0])) return -1;
  }else 
    strcpy(attribute,PRattribute);

  attr = attribute;
  /* strip 'X...N', e.g. XmNx -> x or XcNfValue -> fValue */
  if (strlen(attribute)>(size_t)3)
  if (attribute[0]=='X')
  if (attribute[2]=='N')
    attr = &attribute[2];

  /* get String */
#ifdef FORMAT
  if (XtClass(PRwidget) == xcFormatAlphanumWidgetClass){
    /* first activate format and plausi checking */
    _DoiClearError (PRwidget);
    if (XcFormatActivateWidget (PRwidget,False) == XcNO_ERROR){
      _DoiErrorSet (PRwidget);
      /* fetch the value */
      string = XcFormatAlphanumGetString(PRwidget);
      if (string == NULL)
        return -1;
      len = strlen (string);
      if (len < (size_t)PRmaxLength){
        strcpy (PRstring,string);
        XtFree (string);
        if (DoiDebugFlag) printf ("   returns string '%s' of length = %d\n",PRstring,len);
        return 0;
      }else{
        XtFree(string);
      _DoiErrorSet (PRwidget);
        return -1;
      }
    } else { /* format or plausi error */
      /* activate the error callbacks */
      XcFormatActivateWidget (PRwidget,True);
      _DoiErrorSet (PRwidget);
      return -1;
    }
  }
#endif
  /* if a XmString is returned the char* string is needed */
  XtGetResourceList (XtClass(PRwidget),&resList,(Cardinal*)&numRes);
  freeResList = resList;
  for (i = 0; i < numRes; i++, resList++){
    if (!strcmp(resList->resource_name,attr)){
      if (DoiDebugFlag)printf ("res_name '%s' is of type = '%s'\n",resList->resource_name,resList->resource_type);
      if (!strcmp(resList->resource_type,XmRXmString)){
        XmString xmString;
        XtFree ((char*)freeResList);
        XtVaGetValues (PRwidget,attr,&xmString,NULL);
        if (XmStringGetLtoR(xmString,XmSTRING_DEFAULT_CHARSET,&string))
          if (string && strlen(string) < (size_t)PRmaxLength){
            strcpy (PRstring,string);
            if (DoiDebugFlag) printf ("   returns %s\n",PRstring);
            return 0;
          }else
            return -1;
        else
          return -1;
      }else{ /* normal char* Typ */
        XtFree ((char*)freeResList);
        XtVaGetValues (PRwidget,attr,&string,NULL);
        if (string && strlen(string) < (size_t)PRmaxLength){
          strcpy (PRstring,string);
          if (DoiDebugFlag) printf ("   returns %s\n",PRstring);
          return 0;
        }else
          return -1;
      }
    }
  }
  XtFree ((char*)freeResList);
  return -1;
}/* DoiGetString */

#ifdef FORMAT
/*------------------------------------------------------------------*/
int DoiGetDouble(
  /* reads the double value of a 'XcFormatNumeric' widget */
  Widget  PRwidget,
  double* PRdouble,
  char*   PRattribute
  )
{
  char attribute[100];
  char *attr;
  if (DoiDebugFlag) printf("DoiGetDouble\n");

  if (PRwidget == NULL) return -1;

  if (XtClass(PRwidget) != xcFormatNumericWidgetClass) return -1;

  /* first activate format and plausi checking */
  _DoiClearError (PRwidget);
  if (XcFormatActivateWidget (PRwidget,False) == XcNO_ERROR){
    /* get Double */
    *PRdouble = XcFormatNumericGetDouble (PRwidget);
    if (DoiDebugFlag) printf ("   returns %lg\n",PRdouble);
    _DoiErrorSet (PRwidget);
    return 0;
  } else { /* format or plausi error */
    /* activate the error callbacks */
    XcFormatActivateWidget (PRwidget,True);
    _DoiErrorSet (PRwidget);
    return -1;
  }
}/* DoiGetDouble */

/*------------------------------------------------------------------*/
int DoiGetDoubleF(
  /* reads the double value of a 'XcFormatNumeric' widget */
  Widget  PRwidget,
  double* PRdouble,
  int*    PRvalid
  )
{
  char attribute[100];
  char *attr;
  if (DoiDebugFlag) printf("DoiGetDoubleF\n");

  if (PRwidget == NULL) return -1;

  if (XtClass(PRwidget) != xcFormatNumericWidgetClass) return -1;

  /* first activate format and plausi checking */
  _DoiClearError (PRwidget);

  if (XcFormatActivateWidget (PRwidget,False) == XcNO_ERROR){
    /* check whether there is a NULL string entered */
    if (XcFormatIsNullValue(PRwidget)){
      *PRvalid = 0; /* no valid value in *PRdouble !! */
      if (DoiDebugFlag) printf ("   returns NULL value\n");
      return 0;
    }
    /* get Double */
    *PRdouble = XcFormatNumericGetDouble (PRwidget);
    if (DoiDebugFlag) printf ("   returns %lg\n",PRdouble);
    _DoiErrorSet (PRwidget);
    *PRvalid = 1;
    return 0;
  } else { /* format or plausi error */
    /* activate the error callbacks */
    XcFormatActivateWidget (PRwidget,True);
    _DoiErrorSet (PRwidget);
    return -1;
  }
}/* DoiGetDoubleF */

/*------------------------------------------------------------------*/
int DoiGetDate(
  /* reads the Date of a widget */
  Widget        PRwidget,
  XcDateStruct* PRdate,
  char*         PRattribute
  )
{
  char attribute[100];
  char *attr;
  if (DoiDebugFlag) printf("DoiGetDate\n");

  if (PRwidget == NULL) return -1;
  if (XtClass(PRwidget) != xcFormatDateWidgetClass) return -1;

  if (*PRattribute == StringEnd){
    /* default attribute depends on the widget class */
    if (getDefaultAttribute(PRwidget,&attribute[0])) return -1;
  }else 
    strcpy(attribute,PRattribute);

  attr = attribute;
  /* strip 'X...N', e.g. XmNx -> x or XcNfValue -> fValue */
  if (strlen(attribute)>(size_t)3)
  if (attribute[0]=='X')
  if (attribute[2]=='N')
    attr = &attribute[2];

  /* first activate format and plausi checking */
  _DoiClearError (PRwidget);
  if (XcFormatActivateWidget (PRwidget,False) == XcNO_ERROR){
    _DoiErrorSet (PRwidget);
    /* get Date */
    *PRdate = XcFormatDateGetDate (PRwidget);

    /* check Date */
    if (PRdate->weekday      == -1 &&
        PRdate->day          == -1 &&
        PRdate->month        == -1 &&
        PRdate->year         == -1 &&
        PRdate->day_of_year  == -1 &&
        PRdate->week_of_year == -1)
      return -1;
    if (DoiDebugFlag){
      printf("returns\n");
      printf("   weekday=%d\n",PRdate->weekday);
      printf("   day=%d\n",PRdate->day);
      printf("   month=%d\n",PRdate->month);
      printf("   year=%d\n",PRdate->year);
      printf("   day_of_year=%d\n",PRdate->day_of_year);
      printf("   week_of_year=%d\n",PRdate->week_of_year);
    }
    return 0;
  } else { /* format or plausi error */
    /* activate the error callbacks */
    XcFormatActivateWidget (PRwidget,True);
    _DoiErrorSet (PRwidget);
    return -1;
  }
}/* DoiGetDate */
#endif

/*------------------------------------------------------------------*/
void DoiPutInt(
  /* sets the attribute of a widget */
  Widget PRwidget,
  int    PRint,
  char*  PRattribute
  )
{
  int   i, numRes;
  XtResourceList resList, freeResList;
  char attribute[100];
  char *attr;
  if (DoiDebugFlag) printf("DoiPutInt\n");

  if (PRwidget == NULL) return;

  if (*PRattribute == StringEnd){
    /* default attribute depends on the widget class */
    if (getDefaultAttribute(PRwidget,&attribute[0])) return;
  }else 
    strcpy(attribute,PRattribute);

  attr = attribute;
  /* strip 'X...N', e.g. XmNx -> x or XcNfValue -> fValue */
  if (strlen(attribute)>(size_t)3)
  if (attribute[0]=='X')
  if (attribute[2]=='N')
    attr = &attribute[2];

  /* sets the values and converts it from int */
#ifdef FORMAT
  if (XtClass(PRwidget) == xcFormatNumericWidgetClass){
    XcFormatNumericSetLong(PRwidget,PRint);
    return;
  }
#endif
  XtGetResourceList (XtClass(PRwidget),&resList,(Cardinal*)&numRes);
  freeResList = resList;
  for (i = 0; i < numRes; i++, resList++){
    if (!strcmp(resList->resource_name,attr)){
      if (DoiDebugFlag)printf ("   res_name '%s' is of type = '%s'\n",resList->resource_name,resList->resource_type);
      if (!strcmp(resList->resource_type,XmRXmString) ||
          !strcmp(resList->resource_type,XmRString)){
        char string[100];
        sprintf (string,"%d",PRint);
        XtVaSetValues (PRwidget,XtVaTypedArg,
                       attr,XmRString,string,strlen(string)+1,NULL);
      }else if (!strcmp(resList->resource_type,XmRAlignment) ||
                !strcmp(resList->resource_type,XmRArrowDirection) ||
                !strcmp(resList->resource_type,XmRBoolean) ||
                !strcmp(resList->resource_type,"BooleanDimension") ||
                !strcmp(resList->resource_type,"Cardinal") ||
                !strcmp(resList->resource_type,XmRCommandWindowLocation) ||
                !strcmp(resList->resource_type,"DefaultButtonType") ||
                !strcmp(resList->resource_type,"DialogStyle") ||
                !strcmp(resList->resource_type,"DialogType") ||
                !strcmp(resList->resource_type,XmREditMode) ||
                !strcmp(resList->resource_type,"FileTypeMask") ||
                !strcmp(resList->resource_type,XmRHorizontalDimension) ||
                !strcmp(resList->resource_type,XmRHorizontalPosition) ||
                !strcmp(resList->resource_type,XmRIndicatorType) ||
                !strcmp(resList->resource_type,XmRInt) ||
                !strcmp(resList->resource_type,XmRKeySym) ||
                !strcmp(resList->resource_type,XmRLabelType) ||
                !strcmp(resList->resource_type,"ListSizePolicy") ||
                !strcmp(resList->resource_type,"MultiClick") ||
                !strcmp(resList->resource_type,XmRNavigationType) ||
                !strcmp(resList->resource_type,XmROrientation) ||
                !strcmp(resList->resource_type,XmRPacking) ||
                !strcmp(resList->resource_type,"ProcessingDirection") ||
                !strcmp(resList->resource_type,"ResizePolicy") ||
                !strcmp(resList->resource_type,XmRRowColumnType) ||
                !strcmp(resList->resource_type,"ScrollBarDisplayPolicy") ||
                !strcmp(resList->resource_type,"ScrollBarPlacement") ||
                !strcmp(resList->resource_type,"ScrollingPolicy") ||
                !strcmp(resList->resource_type,"SelectionPolicy") ||
                !strcmp(resList->resource_type,"SeparatorType") ||
                !strcmp(resList->resource_type,"ShadowType") ||
                !strcmp(resList->resource_type,XmRShort) ||
                !strcmp(resList->resource_type,XmRStringDirection) |
                !strcmp(resList->resource_type,XmRTextPosition) ||
                !strcmp(resList->resource_type,"UnitType") ||
                !strcmp(resList->resource_type,XmRVerticalDimension) ||
                !strcmp(resList->resource_type,XmRVerticalPosition) ||
                !strcmp(resList->resource_type,"VisualPolicy") ||
                !strcmp(resList->resource_type,XmRWhichButton)
      )
         XtVaSetValues (PRwidget,attr,PRint,NULL);
    }
  }
  XtFree ((char*)freeResList);
}/* DoiPutInt */


/*------------------------------------------------------------------*/
void DoiPutString(
  /* sets the attribute of a widget
   * allowed for attributes of types which can be converted to the
   * proper value of the attribute. E.g. From 'String' to 'XmString'
   *                                          'String' to 'Color'
   */
  Widget PRwidget,
  char*  PRstring,
  char*  PRattribute
  )
{
  char attribute[100];
  char *attr;
  if (DoiDebugFlag) printf("DoiPutString\n");

  if (PRwidget == NULL) return;

  if (*PRattribute == StringEnd){
    /* default attribute depends on the widget class */
    if (getDefaultAttribute(PRwidget,&attribute[0])) return;
  }else 
    strcpy(attribute,PRattribute);

  attr = attribute;
  /* strip 'X...N', e.g. XmNx -> x or XcNfValue -> fValue */
  if (strlen(attribute)>(size_t)3)
  if (attribute[0]=='X')
  if (attribute[2]=='N')
    attr = &attribute[2];

  /*  sets the values and converts it from String */
#ifdef FORMAT
  if (XtClass(PRwidget) == xcFormatAlphanumWidgetClass){
    XcFormatAlphanumSetString(PRwidget,PRstring);
    return;
  }
#endif
  XtVaSetValues (PRwidget,XtVaTypedArg,
                 attr,XmRString,PRstring,strlen(PRstring)+1,NULL);
}/* DoiPutString */


#ifdef FORMAT
/*------------------------------------------------------------------*/
void DoiPutDouble(
  /* sets the attribute for widgetlasses xcFormatNumericWidgetClass */
  Widget PRwidget,
  double PRdouble,
  char*  PRattribute
  )
{
  char attribute[100];
  char *attr;
  if (DoiDebugFlag) printf("DoiPutDouble\n");

  if (PRwidget == NULL) return;

  if (XtClass(PRwidget) != xcFormatNumericWidgetClass) return;

  if (*PRattribute == StringEnd){
    /* default attribute depends on the widget class */
    getDefaultAttribute(PRwidget,&attribute[0]);
  }else 
    strcpy(attribute,PRattribute);

  attr = attribute;
  /* strip 'X...N', e.g. XmNx -> x or XcNfValue -> fValue */
  if (strlen(attribute)>(size_t)3)
  if (attribute[0]=='X')
  if (attribute[2]=='N')
    attr = &attribute[2];

  /* sets the double */
  XcFormatNumericSetDouble (PRwidget,PRdouble);
}/* DoiPutDouble */

/*------------------------------------------------------------------*/
void DoiPutDate(
  /* sets the Date for widgetlasses xcFormatDateWidgetClass */
  Widget       PRwidget,
  XcDateStruct PRdate,
  char*        PRattribute
  )
{
  char attribute[100];
  char *attr;
  if (DoiDebugFlag) printf("DoiPutDate\n");

  if (PRwidget == NULL) return;
  if (XtClass(PRwidget) != xcFormatDateWidgetClass) return;

  if (*PRattribute == StringEnd){
    /* default attribute depends on the widget class */
    getDefaultAttribute(PRwidget,&attribute[0]);
  }else 
    strcpy(attribute,PRattribute);

  attr = attribute;
  /* strip 'X...N', e.g. XmNx -> x or XcNfValue -> fValue */
  if (strlen(attribute)>(size_t)3)
  if (attribute[0]=='X')
  if (attribute[2]=='N')
    attr = &attribute[2];

  /* sets the date */
  XcFormatDateSetDate (PRwidget,PRdate);
}/* DoiPutDate */

/*------------------------------------------------------------------*/
/* macro for setting table values for all DoiPut...Table functions */
#define SET_TABLE_VALUE \
  {\
    int      i, rows;\
    if (XcTableSetFieldValue (PRtable,(XtArgVal)&fval,XcNfieldValue,PRrow,PRcol)){\
       if (DoiDebugFlag) printf ("XcTableSetFieldValue reported error\n");\
       XtVaGetValues (PRtable, XcNtableRowCount, &rows, NULL);\
       if (DoiDebugFlag) printf ("Table contains %d rows\n",rows);\
       while (PRrow > rows++)\
         /* a new row must be added */\
         if (XcTableAddRowValueArray (PRtable,NULL,0,-1))\
           return; /* cannot add a new row */\
       /* try again to set the value */\
       if (XcTableSetFieldValue (PRtable,(XtArgVal)&fval,XcNfieldValue,PRrow,PRcol))\
         if (DoiDebugFlag) printf ("XcTableSetFieldValue reported error again\n");\
    }\
  }

/*------------------------------------------------------------------*/
void DoiPutDateTable (
  /* sets the Date into a field of a table widget
   * of class 'xcFormatDateWidgetClass'
   */
Widget       PRtable,
XcDateStruct PRdate,
int          PRrow,
int          PRcol)
{
  XcFValue fval;

  if (DoiDebugFlag) printf("DoiPutDateTable(row=%d,col=%d)\n",PRrow,PRcol);

  if (PRtable == NULL) return;
  if (XtClass(PRtable) != xcTableWidgetClass) return;

  /* sets the date */
  fval.value.DateValue.day = PRdate.day;
  fval.value.DateValue.month = PRdate.month;
  fval.value.DateValue.year = PRdate.year;
  fval.value.DateValue.week_of_year = PRdate.week_of_year;
  fval.value.DateValue.day_of_year = PRdate.day_of_year;
  fval.value.DateValue.weekday = PRdate.weekday;
  fval.type = XcDATE;
  fval.isNullValue = False;
  SET_TABLE_VALUE
}/* DoiPutDateTable */

/*------------------------------------------------------------------*/
void DoiPutStringTable (
  /* sets the string into a field of a table widget
   * of class 'xcFormatAlphanumWidgetClass' or
   * sets the row or column header of the given row or column.
   */
Widget PRtable,
char * PRstring,
int    PRrow,
int    PRcol)
{
  XcFValue fval;

  if (DoiDebugFlag) printf("DoiPutStringTable(string=%s,row=%d,col=%d)\n",PRstring,PRrow,PRcol);

  if (PRtable == NULL) return;

  if (XtClass(PRtable) != xcTableWidgetClass) return;

  if (PRrow > 0 && PRcol == 0){
    /* set the rowHeaderValue */
    XmString header;
    Arg args[1];
    int ret;
    header = XmStringCreateSimple(PRstring);
    XtSetArg (args[0],XcNrowHeaderValue,header);
    ret = XcTableSetValues (PRtable,args,1,PRrow,0);
    XmStringFree (header);
    if (DoiDebugFlag)
      printf("DoiPutStringTable(set rowHeader):XcTableSetValues returned %d\n",ret);
    return;
  }

  if (PRcol > 0 && PRrow == 0){
    /* set the columnHeaderValue */
    XmString header;
    Arg args[1];
    int ret;
    header = XmStringCreateSimple(PRstring);
    XtSetArg (args[0],XcNcolumnHeaderValue,header);
    ret = XcTableSetValues (PRtable,args,1,0,PRcol);
    XmStringFree (header);
    if (DoiDebugFlag)
      printf("DoiPutStringTable(set columnHeader):XcTableSetValues returned %d\n",ret);
    return;
  }

  if (PRcol == 0 && PRrow == 0){
    /* set the upperLeftValue */
    XmString header;
    Arg args[1];
    int ret;
    header = XmStringCreateSimple(PRstring);
    XtSetArg (args[0],XcNupperLeftValue,header);
    ret = XcTableSetValues (PRtable,args,1,0,PRcol);
    XmStringFree (header);
    if (DoiDebugFlag)
      printf("DoiPutStringTable(set upperLeftValue):XcTableSetValues returned %d\n",ret);
    return;
  }

  if (PRrow > 0 && PRcol > 0){
    /* set the string into a table field */
    fval.value.StringValue = PRstring;
    fval.type = XcSTRING;
    fval.isNullValue = False;
    SET_TABLE_VALUE
  }
}/* DoiPutStringTable */

/*------------------------------------------------------------------*/
void DoiPutIntTable (
  /* sets the Integer into a field of a table widget
   * of class 'xcFormatNumericWidgetClass'
   */
Widget PRtable,
int    PRint,
int    PRrow,
int    PRcol)
{
  XcFValue fval;

  if (DoiDebugFlag) printf("DoiPutIntTable(int=%d,row=%d,col=%d)\n",PRint,PRrow,PRcol);

  if (PRtable == NULL) return;

  if (XtClass(PRtable) != xcTableWidgetClass) return;

  /* sets the Integer */
  fval.value.LongValue = PRint;
  fval.type = XcLONG;
  fval.isNullValue = False;
  SET_TABLE_VALUE
}/* DoiPutIntTable */

/*------------------------------------------------------------------*/
void DoiPutDoubleTable (
  /* sets the Double into a field of a table widget
   * of class 'xcFormatNumericWidgetClass'
   */
Widget PRtable,
double PRdouble,
int    PRrow,
int    PRcol)
{
  XcFValue fval;

  if (DoiDebugFlag) printf("DoiPutDoubleTable(double=%lg,row=%d,col=%d)\n",PRdouble,PRrow,PRcol);

  if (PRtable == NULL) return;

  if (XtClass(PRtable) != xcTableWidgetClass) return;

  /* sets the Double */
  fval.value.DoubleValue = PRdouble;
  fval.type = XcDOUBLE;
  fval.isNullValue = False;
  SET_TABLE_VALUE
}/* DoiPutDoubleTable */

/*------------------------------------------------------------------*/
int DoiGetDateTable (
  /* gets the Date of a field of a table widget
   * of class 'xcFormatDateWidgetClass'
   */
Widget        PRtable, 
XcDateStruct* PRdate,
int           PRrow,
int           PRcol)
{
  XcFValue *fval;
  Widget    w;

  if (DoiDebugFlag) printf("DoiGetDateTable\n");

  if (PRtable == NULL) return -1;
  if (XtClass(PRtable) != xcTableWidgetClass) return -1;

  /* gets the Date */
  _DoiClearError (PRtable);
  XcTableReadInputWidgetValue (PRtable);
  if (_DoiErrorSet (PRtable)) return -1;

  fval = (XcFValue*)XcTableGetFieldValue (PRtable,PRrow,PRcol);
  *PRdate = (fval->value.DateValue);

  /* check Date */
  if (PRdate->weekday      == -1 &&
      PRdate->day          == -1 &&
      PRdate->month        == -1 &&
      PRdate->year         == -1 &&
      PRdate->day_of_year  == -1 &&
      PRdate->week_of_year == -1)
    return -1;
  if (DoiDebugFlag){
    printf("returns\n");
    printf("   weekday=%d\n",PRdate->weekday);
    printf("   day=%d\n",PRdate->day);
    printf("   month=%d\n",PRdate->month);
    printf("   year=%d\n",PRdate->year);
    printf("   day_of_year=%d\n",PRdate->day_of_year);
    printf("   week_of_year=%d\n",PRdate->week_of_year);
  }
  return 0;
}/* DoiGetDateTable */

/*------------------------------------------------------------------*/
int DoiGetStringTable (
  /* gets the String of a field of a table widget
   * of class 'xcFormatAlphanumWidgetClass' or
   * sets the row or column header of the given row or column.
   */
Widget PRtable,
char*  PRstring,
int    PRmaxLength,
int    PRrow,
int    PRcol)
{
  XcFValue *fval;
  Widget    w;

  if (DoiDebugFlag) printf("DoiGetStringTable(row=%d,col=%d,buflength=%d\n",PRrow,PRcol,PRmaxLength);

  if (PRtable == NULL) return -1;

  if (XtClass(PRtable) != xcTableWidgetClass) return -1;

  if (PRrow > 0 && PRcol == 0){
    /* get the rowHeaderValue */
    XmString header;
    Arg args[1];
    String string;
    int ret;
    XtSetArg (args[0],XcNrowHeaderValue,&header);
    ret = XcTableGetValues (PRtable,args,1,PRrow,0);
    if (DoiDebugFlag)
      printf("DoiPutStringTable:XcTableGetValues returned %d\n",ret);
    if (ret) return -1;
    /* extract the string from compound string */
    if (XmStringGetLtoR (header,XmSTRING_DEFAULT_CHARSET,&string))
      if (string && strlen(string) < (size_t)PRmaxLength){
        strcpy (PRstring,string);
        if (DoiDebugFlag) printf("DoiGetStringTable returns %s\n",PRstring);
        return 0;
      }
    return -1;
  }

  if (PRcol > 0 && PRrow == 0){
    /* get the columnHeaderValue */
    XmString header;
    Arg args[1];
    String string;
    int ret;
    XtSetArg (args[0],XcNcolumnHeaderValue,&header);
    ret = XcTableGetValues (PRtable,args,1,0,PRcol);
    if (DoiDebugFlag)
      printf("DoiPutStringTable:XcTableSetValues returned %d\n",ret);
    if (ret) return -1;
    /* extract the string from compound string */
    if (XmStringGetLtoR (header,XmSTRING_DEFAULT_CHARSET,&string))
      if (string && strlen(string) < (size_t)PRmaxLength){
        strcpy (PRstring,string);
        if (DoiDebugFlag) printf("DoiGetStringTable returns %s\n",PRstring);
        return 0;
      }
    return -1;
  }

  if (PRrow > 0 &&PRcol > 0){
    /* gets the String */
    char *string;
    _DoiClearError (PRtable);
    XcTableReadInputWidgetValue (PRtable);
    if (_DoiErrorSet (PRtable)) return -1;

    fval = (XcFValue*)XcTableGetFieldValue (PRtable,PRrow,PRcol);
    if (fval == NULL){
      if (DoiDebugFlag) printf("DoiGetStringTable returns -1\n");
      return -1;
    }
    if (fval->type != XcSTRING){
      if (DoiDebugFlag) printf("DoiGetStringTable returns -1\n");
      return -1;
    }
    /* checks whether a null value is returned */
    if (fval->isNullValue){
      /* null value entered */
      if (DoiDebugFlag)
        printf("DoiGetStringTable returns NULL value\n");
      *PRstring = '\0';
      return 0;
    }

    string = fval->value.StringValue;
    if (string && strlen(string) < (size_t)PRmaxLength){
      strcpy (PRstring,string);
      if (DoiDebugFlag) printf("DoiGetStringTable returns %s\n",PRstring);
      return 0;
    }
  }
  return -1;
}/* DoiGetStringTable */

/*------------------------------------------------------------------*/
int DoiGetIntTable (
  /* gets the Integer of a field of a table widget
   * of class 'xcFormatNumericWidgetClass'
   */
Widget PRtable,
int*   PRint,
int    PRrow,
int    PRcol)
{
  XcFValue *fval;
  Widget    w;

  if (DoiDebugFlag) printf("DoiGetIntTable\n");

  if (PRtable == NULL) return -1;

  if (XtClass(PRtable) != xcTableWidgetClass) return -1;

  /* gets the Integer */
  _DoiClearError (PRtable);
  XcTableReadInputWidgetValue (PRtable);
  if (_DoiErrorSet (PRtable)) return -1;

  fval = (XcFValue*)XcTableGetFieldValue (PRtable,PRrow,PRcol);
  if (DoiDebugFlag)
    printf("DoiGetIntTable returns fval=%x\n",fval);
  *PRint = fval->value.LongValue;
  if (DoiDebugFlag)
    printf("DoiGetIntTable returns %d\n",*PRint);
  return 0;
}/* DoiGetIntTable */


/*------------------------------------------------------------------*/
int DoiGetIntFTable (
  /* gets the Integer of a field of a table widget
   * of class 'xcFormatNumericWidgetClass'
   * the value NIL is allowed
   */
Widget PRtable,
int*   PRint,
int*   PRvalid, /* 0: null string entered, 1: valid value in *PRdouble */
int    PRrow,
int    PRcol)
{
  XcFValue *fval;
  Widget    w;

  if (DoiDebugFlag) printf("DoiGetIntFTable\n");

  if (PRtable == NULL) return -1;

  if (XtClass(PRtable) != xcTableWidgetClass) return -1;

  /* gets the Integer */
  _DoiClearError (PRtable);
  XcTableReadInputWidgetValue (PRtable);
  if (_DoiErrorSet (PRtable)) return -1;

  fval = (XcFValue*)XcTableGetFieldValue (PRtable,PRrow,PRcol);

  /* checks whether a null value is returned */
  if (fval->isNullValue){
    /* null value entered */
    *PRvalid = 0;
    if (DoiDebugFlag)
      printf("DoiGetIntFTable returns NULL value\n");
    return 0;
  }

  if (DoiDebugFlag)
    printf("DoiGetIntTable returns fval=%x\n",fval);
  *PRint = fval->value.LongValue;
  if (DoiDebugFlag)
    printf("DoiGetIntFTable returns %d\n",*PRint);
  *PRvalid = 1;
  return 0;
}/* DoiGetIntFTable */

/*------------------------------------------------------------------*/
int DoiGetDoubleTable (
  /* gets the Double of a field of a table widget
   * of class 'xcFormatNumericWidgetClass'
   */
Widget  PRtable,
double* PRdouble,
int     PRrow,
int     PRcol)
{
  XcFValue *fval;
  Widget    w; /* representation widget */

  if (DoiDebugFlag) printf("DoiGetDoubleTable\n");

  if (PRtable == NULL) return -1;

  if (XtClass(PRtable) != xcTableWidgetClass) return -1;

  /* sets the Double */
  _DoiClearError (PRtable);
  XcTableReadInputWidgetValue (PRtable);
  if (_DoiErrorSet (PRtable)) return -1;

  fval = (XcFValue*)XcTableGetFieldValue (PRtable,PRrow,PRcol);
  if (fval->type == XcLONG)
    *PRdouble = (double) fval->value.LongValue;
  else if (fval->type == XcDOUBLE)
    *PRdouble = fval->value.DoubleValue;
  else
    return -1;
  if (DoiDebugFlag)
    printf("DoiGetDoubleTable returns %lg\n",*PRdouble);
  return 0;
}/* DoiGetDoubleTable */

/*------------------------------------------------------------------*/
int DoiGetDoubleFTable (
  /* gets the Double of a field of a table widget
   * of class 'xcFormatNumericWidgetClass'
   * value NIL is allowed
   */
Widget  PRtable,
double* PRdouble,
int*    PRvalid, /* 0: null string entered, 1: valid value in *PRdouble */
int     PRrow,
int     PRcol)
{
  XcFValue *fval;
  Widget    w; /* representation widget */

  if (DoiDebugFlag) printf("DoiGetDoubleTable\n");

  if (PRtable == NULL) return -1;

  if (XtClass(PRtable) != xcTableWidgetClass) return -1;


  /* gets the Double */
  _DoiClearError (PRtable);
  XcTableReadInputWidgetValue (PRtable);
  if (_DoiErrorSet (PRtable)) return -1;

  fval = (XcFValue*)XcTableGetFieldValue (PRtable,PRrow,PRcol);

  /* checks whether a null value is returned */
  if (fval->isNullValue){
    /* null value entered */
    if (DoiDebugFlag)
      printf("DoiGetDoubleFTable returns NULL value\n");
    *PRvalid = 0;
    return 0;
  }

  if (fval->type == XcLONG)
    *PRdouble = (double) fval->value.LongValue;
  else if (fval->type == XcDOUBLE)
    *PRdouble = fval->value.DoubleValue;
  else
    return -1;
  if (DoiDebugFlag)
    printf("DoiGetDoubleFTable returns %lg\n",*PRdouble);
  *PRvalid = 1;
  return 0;
}/* DoiGetDoubleFTable */

/*------------------------------------------------------------------*/
void DoiClearIntF(
  /* clears the contents of widget of class xcFormatNumericWidgetClass */
  Widget PRwidget
  )
{
  if (DoiDebugFlag) printf("DoiClearIntF\n");

  if (PRwidget == NULL) return;

  if (XtClass(PRwidget) != xcFormatNumericWidgetClass) return;

  /* clears the int */
  XcFormatSetNullValue (PRwidget);

}/* DoiClearIntF */

/*------------------------------------------------------------------*/
void DoiClearDoubleF(
  /* clears the contents of widget of class xcFormatNumericWidgetClass */
  Widget PRwidget
  )
{
  if (DoiDebugFlag) printf("DoiClearDoubleF\n");

  if (PRwidget == NULL) return;

  if (XtClass(PRwidget) != xcFormatNumericWidgetClass) return;

  /* clears the double */
  XcFormatSetNullValue (PRwidget);

}/* DoiClearDoubleF */

/*------------------------------------------------------------------*/
void DoiClearIntFTable (
  /* clears the integer field of a table widget
   * of class 'xcFormatNumericWidgetClass'
   */
  Widget PRtable,
  int    PRrow,
  int    PRcol
)
{
  XcFValue fval;

  if (DoiDebugFlag) printf("DoiClearIntFTable(row=%d,col=%d)\n",PRrow,PRcol);

  if (PRtable == NULL) return;

  if (XtClass(PRtable) != xcTableWidgetClass) return;

  /* clears the Integer */
  fval.isNullValue = True;
  SET_TABLE_VALUE
}/* DoiClearIntFTable */

/*------------------------------------------------------------------*/
void DoiClearDoubleFTable (
  /* clears the double field of a table widget
   * of class 'xcFormatNumericWidgetClass'
   */
  Widget PRtable,
  int    PRrow,
  int    PRcol
)
{
  XcFValue fval;

  if (DoiDebugFlag) printf("DoiClearDoubleFTable(row=%d,col=%d)\n",PRrow,PRcol);

  if (PRtable == NULL) return;

  if (XtClass(PRtable) != xcTableWidgetClass) return;

  /* clears the Integer */
  fval.isNullValue = True;
  SET_TABLE_VALUE
}/* DoiClearDoubleFTable */
#endif
