(*---------------------------------------------------------------------
-- Dialog Interface Objects
-----------------------------------------------------------------------
-- Copyright: (c) Sietec GmbH & Co oHG
--            All rights reserved 1993
-----------------------------------------------------------------------
-- Modul    : Textfield
-- Author   : Gold, Herbert
-- angelegt : 1993-12-02
---------------------------------------------------------------------*)
SPECIFICATION Textfield

IMPORT Control      FROM Control;
IMPORT WindowObject FROM WindowObj;

TYPE Textfield = Control 
     OBJECT( IN theOwner : WindowObject, IN name : STRING )

PUBLIC

  METHOD GetValue : REF ARRAY OF CHAR;
  METHOD PutValue( IN value : REF ARRAY OF CHAR );

  METHOD OnGetContent( IN action : METHOD() : REF ARRAY OF CHAR
                     ) : Textfield;
  METHOD OnPutContent( IN action : METHOD( IN REF ARRAY OF CHAR )
                     ) : Textfield;

(*
  METHOD SetPopupMenu( IN name : STRING, IN button : INT );
-- attach a PopupMenu with given name.
-- 'button' (see DOI) specifies the activation button.
-- the popup-menu items must be added to the WindowObject by AddPushButton.

  METHOD DelPopupMenu;
-- removes / deactivates the PopupMenu.
*)

  METHOD SetEditable( IN yesNo : BOOL );
-- set Textfield to editable ON or editable OFF.
PROTECTED

  METHOD get;
  METHOD put;
  METHOD getValue : STRING;  -- from Screen

STATE
  getAction : METHOD() : REF ARRAY OF CHAR;
  putAction : METHOD(IN REF ARRAY OF CHAR);
  Editable  : BOOL;

END OBJECT;

END SPECIFICATION;    (* Textfield *)

