(*---------------------------------------------------------------------
-- Dialog Interface Objects
-----------------------------------------------------------------------
-- Copyright: (c) Sietec GmbH & Co oHG
--            All rights reserved 1993
-----------------------------------------------------------------------
-- Modul    : SelectBox
-- Author   : Gold, Herbert
-- angelegt : 1993-12-06
---------------------------------------------------------------------*)
SPECIFICATION SelectBox

IMPORT Control      FROM Control;
IMPORT WindowObject FROM WindowObj;

TYPE ListBox = Control 
     OBJECT( IN theOwner : WindowObject, IN name : STRING )

-- represents the List- and ScrolledWindow-Widget in Motif.

PUBLIC

  METHOD ActivateEvent;
-- raised if an item is activated (by double click) in the ListBox.  

  METHOD AddItem( IN item : STRING );
-- adds an item to the end of the internal list.

  METHOD DeletePos( IN  position : INT );
-- deletes the item at position.

  METHOD DeselectAll;
-- deselects all selected items.
-- No events are activated.

  METHOD DeselectPos( IN  position : INT );
-- deselects the item at position.
-- No event is activated.

  METHOD GetSelectedItem : STRING;
-- returns the last selected item. 
-- If no selection took place, an empty string is returned.

  METHOD GetSelectedPos : INT;
-- returns the position of the last selected item.

  METHOD InsertAt( IN  position : INT, IN item : STRING );
-- inserts an item at position into the list.

  METHOD SelectPos( IN  position : INT );
-- selects the item at position.  
-- No event is activated.


  METHOD SelectEvent;
-- raised if an item is selected in the ListBox.  


  METHOD OnActivate( IN action : METHOD(IN INT) ) : ListBox;
-- sets the default action event (for double-click on an item).
-- The event executes an action method delivering
-- the position of the selected item in the list.

  METHOD OnActivateFrom( IN action : METHOD(IN INT, IN ListBox)
                       )  : ListBox;
-- is the same as METHOD OnActivate, but the action method delivers 
-- the position and the ListBox object.

  METHOD OnActivateItem( IN action : METHOD(IN STRING) ) : ListBox; 
-- is the same as METHOD OnActivate, but the action method delivers
-- the activated item.

 METHOD OnActivateItemFrom( IN action : METHOD(IN STRING, IN ListBox)
                           ) : ListBox;
-- is the same as METHOD OnActivateItem, but the action method delivers
-- the activated item and the ListBox object.


  METHOD OnSelect( IN action : METHOD(IN INT) ) : ListBox;
-- activates the select event (either single or multiple select, 
-- depending on the state of ListBox 
-- (see: SetSingleSelect, SetMultipleSelect). 
--
-- The select event executes an action method delivering
-- the position of the selected item in the list.

  METHOD OnSelectFrom( IN action : METHOD(IN INT, IN ListBox)
                     )  : ListBox;
-- is the same as METHOD OnSelect, but the action method delivers 
-- the position and the ListBox object.

  METHOD OnSelectItem( IN action : METHOD(IN STRING) ) : ListBox;
-- is the same as METHOD OnSelect, but the action method delivers
-- the selected item.

   METHOD OnSelectItemFrom( IN action : METHOD(IN STRING, IN ListBox)
                          ) : ListBox;
-- is the same as METHOD OnSelectItem, but the action method delivers
-- the selected item and the ListBox object.

(* NOT IMPLEMENTED ++++++++++++++++++++++++
  METHOD OnDeselect( IN action : METHOD(IN INT) ) : ListBox;
-- activates the deselect event (either for single or multiple deselect,
-- depending on the state of ListBox 
-- (see: SetSingleSelect, SetMultipleSelect). 
--
-- The select event executes an action method delivering
-- the position of the selected item in the list.

  METHOD OnDeselectFrom( IN action : METHOD(IN INT, IN ListBox)
                       )  : ListBox;
-- is the same as METHOD OnDeselect, but the action method delivers 
-- the position and the ListBox object.

  METHOD OnDeselectItem( IN action : METHOD(IN STRING) ) : ListBox;
-- is the same as METHOD OnDeselect, but the action method delivers
-- the deselected item.

  METHOD OnDeselectItemFrom( IN action : METHOD(IN STRING, IN ListBox)
                           ) : ListBox;
-- is the same as METHOD OnDeselectItem, but the action method delivers
-- the deselected item and the ListBox object.
 ++++++++++++++++++++++++ NOt implemented *)


  METHOD OnGetContent( IN action : METHOD( IN INT ) : STRING 
                     ) : ListBox;
-- provides the action to get an item from outside.

(* NOT IMPLEMENTED ++++++++++++++++++++++
  METHOD SetSingleSelect : ListBox;
-- activates singleSelect mode (default). 

  METHOD SetMultipleSelect : ListBox;
-- activates multipleSelect mode.
-- Select- and Deselect events react on multipleSelect (also existing
-- events).
 +++++++++++++++++++++++++ *)

  METHOD SetTop( IN position : INT ) : ListBox;
-- makes the item at position visible at the top of the box.


PROTECTED
(* -- missing !!!!!!!
  METHOD isSingleSelect : BOOL;
  METHOD isMultipleSelect : BOOL;
  METHOD itemCount : INT;
  METHOD visibleItemsCount : INT; 
*)
  METHOD get;
  METHOD put;
  METHOD getValue : STRING;     -- from Screen - What does it mean here?

STATE
  getAction : METHOD( IN INT ) : STRING;
  --
  activateAction : METHOD( IN INT );
  activateFromAction : METHOD( IN INT, IN ListBox );
  activateItemAction : METHOD( IN STRING );
  activateItemFromAction : METHOD( IN STRING, IN ListBox );
  --
  selectAction : METHOD( IN INT );
  selectFromAction : METHOD( IN INT, IN ListBox );
  selectItemAction : METHOD( IN STRING );
  selectItemFromAction : METHOD( IN STRING, IN ListBox );

END OBJECT;

END SPECIFICATION;                 (* SelectBox *)

