(*---------------------------------------------------------------------
-- Dialog Interface Objects
-----------------------------------------------------------------------
-- Copyright: (c) Sietec GmbH & Co oHG
--            All rights reserved 1993
-----------------------------------------------------------------------
-- Modul    : Radio
-- Author   : Gold, Herbert
-- angelegt : 1993-12-01
---------------------------------------------------------------------*)
SPECIFICATION Radio

IMPORT Button       FROM Button;
IMPORT WindowObject FROM WindowObj;

TYPE RadioButton = Button
     OBJECT( IN theOwner : WindowObject, IN name : STRING )

PUBLIC

  METHOD GetValue : BOOL;
  METHOD PutValue( IN value : BOOL );

  METHOD OnGetContent( IN action : METHOD() : BOOL ) : RadioButton;
  METHOD OnPutContent( IN action : METHOD( IN BOOL ) ) : RadioButton;

PROTECTED

  METHOD get;
  METHOD put;
  METHOD getValue : STRING;              -- from Screen

STATE
  getAction : METHOD() : BOOL;
  putAction : METHOD(IN BOOL);

END OBJECT;

END SPECIFICATION;        (* Radio *)

