-- ***************************************************************
-- DOI
-- ---------------------------------------------------------------
--
-- Doi.cs -- Dialog Object Interface
-- 
--   Copyright (C) sietec Systemtechnik GmbH & Co OHG 1994
--   All rights reserved
-- 
-- Author          : Hans Altmann
--
-- PURPOSE
--    DOI is an object oriented enhancement of the Dialog Builder 
--    runtime system. It's more comfortable, allows widget independent
--    data exchange between the application and the user interface.
--
--    "Doi" is the name of the class which implements the DOI.
--  
--    Every instance of the class Doi represents a dialog object of
--    a resource file (inclusive all its descendents).
--  
--    A dialog object can consist of an arbitrary number of dialog
--    elements like text input fields, buttons, labels, lists etc.
--    Each dialog element is identified by a name.
--    A legal name can be:
--     - a pathname, as used in the Dialog Builder run time system
--       e.g. "/bill/quitButton"
--     - names without path components, e.g. "quitButton"
--     - "." for identifying the dialog element of the current Doi instance
--     - for identifying child widgets in messageBox, selectionBox, etc.
--       the Motif name of the Xm...getChild function can be used,
--       The follwing table lists all possible child names depending
--       on the Motif Class:
--
--       Command DIALOG_COMMAND_TEXT
--       Command DIALOG_HISTORY_LIST
--       Command DIALOG_PROMPT_LABEL
--       FileSelectionBox DIALOG_APPLY_BUTTON
--       FileSelectionBox DIALOG_CANCEL_BUTTON
--       FileSelectionBox DIALOG_DEFAULT_BUTTON
--       FileSelectionBox DIALOG_DIR_LIST
--       FileSelectionBox DIALOG_DIR_LIST_LABEL
--       FileSelectionBox DIALOG_FILTER_LABEL
--       FileSelectionBox DIALOG_FILTER_TEXT
--       FileSelectionBox DIALOG_HELP_BUTTON
--       FileSelectionBox DIALOG_LIST
--       FileSelectionBox DIALOG_LIST_LABEL
--       FileSelectionBox DIALOG_OK_BUTTON
--       FileSelectionBox DIALOG_SELECTION_LABEL
--       FileSelectionBox DIALOG_SEPARATOR
--       FileSelectionBox DIALOG_TEXT
--       FileSelectionBox DIALOG_WORK_AREA
--       MessageBox DIALOG_CANCEL_BUTTON
--       MessageBox DIALOG_DEFAULT_BUTTON
--       MessageBox DIALOG_HELP_BUTTON
--       MessageBox DIALOG_MESSAGE_LABEL
--       MessageBox DIALOG_OK_BUTTON
--       MessageBox DIALOG_SEPARATOR
--       MessageBox DIALOG_SYMBOL_LABEL
--       SelectionBox DIALOG_APPLY_BUTTON
--       SelectionBox DIALOG_CANCEL_BUTTON
--       SelectionBox DIALOG_DEFAULT_BUTTON
--       SelectionBox DIALOG_HELP_BUTTON
--       SelectionBox DIALOG_LIST
--       SelectionBox DIALOG_LIST_LABEL
--       SelectionBox DIALOG_OK_BUTTON
--       SelectionBox DIALOG_SELECTION_LABEL
--       SelectionBox DIALOG_SEPARATOR
--       SelectionBox DIALOG_TEXT
--       SelectionBox DIALOG_WORK_AREA
--   If names are multiple used in the user interface the first fitting
--   name of a dialog element is used.
-- 
--   CONSTants can be found at the end of this file !!!
-- REFER
--      |>Documents with client documentation<|
--
-- ---------------------------------------------------------------
--
-- Created On      : Wed Feb 23 18:52:43 1994
-- Last Modified By: Karl-Heinz Koester
-- Last Modified On: Wed Feb 23 18:52:43 1994
-- Update Count    : 28
-- 
-- ***************************************************************

SPECIFICATION Doi

-----------------------------------------------------------------
--- TYPE declaration for use in Format Widget -- NOT SNI!!!!!!!!!
-----------------------------------------------------------------

TYPE XcDATE = RECORD
        weekday      : SHORT INT;
        day          : SHORT INT;
        month        : SHORT INT;
        year         : SHORT INT;
        day_of_year  : SHORT INT;
        week_of_year : SHORT INT;
END RECORD;

-----------------------------------------------------------------
--- TYPE declaration for X Windows
--- external used
-----------------------------------------------------------------
TYPE DISPLAY = ADDRESS;
TYPE WIDGET = ADDRESS;

-----------------------------------------------------------------
--- TYPE declaration for X Windows
--- internal used
-----------------------------------------------------------------
TYPE WINDOW = ADDRESS;

-----------------------------------------------------------------
--- TYPE declaration for use in RSHregisterNames -- DialogBuilder
-----------------------------------------------------------------
TYPE RSHELEMENT = RECORD
        name : REF ARRAY OF CHAR; 
        proc : PROCEDURE (IN WIDGET,IN ADDRESS,IN ADDRESS);
END RECORD;


-----------------------------------------------------------------
------ OBJECT Doi -----------------------------------------------
-----------------------------------------------------------------

TYPE Doi = OBJECT
 -- class for object oriented access to Dialog Builder resource files,
 -- and dialog objects, i.e. Motif widgets
 (
 ---------------------------------------------------------
 ------ INITIALLY parameter list -------------------------
 ---------------------------------------------------------
  PRresObjName : ARRAY OF CHAR,
   -- name of a dialog element within the resource file
   -- if = "", then first dialog element in the resource file
  PRdoiName : ARRAY OF CHAR,
   -- aliasname of the dialog object
   -- if = "", then name of PRresObjName
  PRresourceName : ARRAY OF CHAR
   -- name of the resource file from where the dialog object
   -- will be loaded
   -- if = "", then "<PRresObjName>.res"
 )

 PUBLIC 
 ---------------------------------------------------------
 ------ METHODS exported to the user ---------------------
 ---------------------------------------------------------
 ------------ 1. basic functionality ---------------------
 ---------------------------------------------------------
 METHOD setAppClass
                   (IN PRapplicationClass : ARRAY OF CHAR);
 ---------------------------------------------------------
 METHOD initialize
                   (IN    PRshellWidget  : WIDGET,
                    IN    PRregisterList : REF ARRAY OF RSHELEMENT,
                    INOUT PRargc         : INT,
                    INOUT PRargv         : ARRAY OF REF ARRAY OF CHAR
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD addElement
                   (IN PRresourceName : ARRAY OF CHAR,
                    IN PRresObjName   : ARRAY OF CHAR,
                    IN PRdoiName      : ARRAY OF CHAR,
                    IN PRparent       : ARRAY OF CHAR
                   );
 ---------------------------------------------------------
 METHOD delElement (IN PRelName : ARRAY OF CHAR);
 ---------------------------------------------------------
 METHOD show       (IN PRelName : ARRAY OF CHAR);
 ---------------------------------------------------------
 METHOD hide       (IN PRelName : ARRAY OF CHAR);
 ---------------------------------------------------------
 METHOD lock       (IN PRelName : ARRAY OF CHAR);
 ---------------------------------------------------------
 METHOD unlock     (IN PRelName : ARRAY OF CHAR);
 ---------------------------------------------------------
 METHOD getInt     (IN  PRelName   : ARRAY OF CHAR,
                    OUT PRdata     : INT,
                    IN  PRproperty : ARRAY OF CHAR
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD clearIntF  (IN PRelName : ARRAY OF CHAR);
 ---------------------------------------------------------
 METHOD getIntF    (IN  PRelName   : ARRAY OF CHAR,
                    OUT PRdata     : INT,
                    OUT PRvalid    : BOOL
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD getString  (IN  PRelName     : ARRAY OF CHAR,
                    OUT PRdata       : ARRAY OF CHAR,
                    IN  PRmaxLength : INT,
                    IN  PRproperty   : ARRAY OF CHAR
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD getDouble  (IN  PRelName   : ARRAY OF CHAR,
                    OUT PRdata     : DOUBLE,
                    IN  PRproperty : ARRAY OF CHAR
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD clearDoubleF (IN PRelName : ARRAY OF CHAR);
 ---------------------------------------------------------
 METHOD getDoubleF (IN  PRelName   : ARRAY OF CHAR,
                    OUT PRdata     : DOUBLE,
                    OUT PRvalid    : BOOL
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD getDate    (IN  PRelName   : ARRAY OF CHAR,
                    OUT PRdate     : XcDATE,
                    IN  PRproperty : ARRAY OF CHAR
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD putInt     (IN PRelName    : ARRAY OF CHAR,
                    IN PRdata      : INT,
                    IN PRproperty  : ARRAY OF CHAR
                   );
 ---------------------------------------------------------
 METHOD putString  (IN PRelName   : ARRAY OF CHAR,
                    IN PRdata     : ARRAY OF CHAR,
                    IN PRproperty : ARRAY OF CHAR
                   );
 ---------------------------------------------------------
 METHOD putDouble  (IN PRelName   : ARRAY OF CHAR,
                    IN PRdata     : DOUBLE,
                    IN PRproperty : ARRAY OF CHAR
                   );
 ---------------------------------------------------------
 METHOD putDate    (IN PRelName   : ARRAY OF CHAR,
                    IN PRdate     : XcDATE,
                    IN PRproperty : ARRAY OF CHAR
                   );
 ---------------------------------------------------------
 METHOD addCallback
                   (IN PRelName     : ARRAY OF CHAR,
                    IN PRcallback   : PROCEDURE (IN WIDGET,
                                                 IN ADDRESS,
                                                 IN ADDRESS),
                    IN PRreason     : ARRAY OF CHAR,
                    IN PRclientData : ADDRESS
                   );
 ---------------------------------------------------------
 METHOD addWMCloseCallback
                    (IN PRcallback   : PROCEDURE (IN WIDGET,
                                                 IN ADDRESS,
                                                 IN ADDRESS),
                    IN PRclientData : ADDRESS
                   );
 ---------------------------------------------------------
 METHOD removeCallback
                   (IN PRelName     : ARRAY OF CHAR,
                    IN PRcallback   : PROCEDURE (IN WIDGET,
                                                 IN ADDRESS,
                                                 IN ADDRESS),
                    IN PRreason     : ARRAY OF CHAR,
                    IN PRclientData : ADDRESS
                   );
 ---------------------------------------------------------
 METHOD updateDisplay;
 ---------------------------------------------------------
 METHOD removeInputEvents;
 ---------------------------------------------------------
 METHOD enterEventLoop;
 ---------------------------------------------------------
 METHOD doLocalEventLoop (IN PRblocking : BOOL);
 ---------------------------------------------------------
 METHOD startLocalEventLoop;
 ---------------------------------------------------------
 METHOD stopLocalEventLoop;
 ---------------------------------------------------------
 METHOD delete;
 ---------------------------------------------------------
 METHOD getWidget
                   (IN  PRelName : ARRAY OF CHAR,
                    OUT PRwidget : WIDGET
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD createLockWindow
                   (IN  PRshape : INT,
                    IN  PRforegroundColor : ARRAY OF CHAR,
                    IN  PRbackgroundColor : ARRAY OF CHAR
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD destroyLockWindow ();
 ---------------------------------------------------------
 METHOD setLockWindow ();
 ---------------------------------------------------------
 METHOD resetLockWindow ();
 ---------------------------------------------------------
 METHOD getAppShell
                   (OUT PRshell  : WIDGET
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD getDisplay
                   (OUT PRdisplay  : DISPLAY
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD setInputFocus
                   (IN PRelName  : ARRAY OF CHAR
                   );
 ---------------------------------------------------------
 ---------------------------------------------------------
 ------------ 2. PopupMenu enhancement -------------------
 ---------------------------------------------------------
(*
 METHOD setPopupMenu
                   (IN PRobject : ARRAY OF CHAR,
                    IN PRpopup  : ARRAY OF CHAR,
                    IN PRbutton : INT);
 ---------------------------------------------------------
 METHOD removePopupMenu
                   (IN PRpopup : ARRAY OF CHAR);
 ---------------------------------------------------------
 METHOD getPopupMenu
                   (IN  PRobject    : ARRAY OF CHAR,
                    OUT PRpopupName : ARRAY OF CHAR,
                    IN  PRmaxLength : INT
                   ) : BOOL;
*)
 ---------------------------------------------------------
 ------------ 3. Xt enhancement --------------------------
 ---------------------------------------------------------
 METHOD bell ();
 METHOD setCursor
                 (IN PRelem  : ARRAY OF CHAR,
                  IN PRshape : INT,
                  IN  PRforegroundColor : ARRAY OF CHAR,
                  IN  PRbackgroundColor : ARRAY OF CHAR
                 );
 METHOD resetCursor
                 (IN PRelem  : ARRAY OF CHAR);
 ---------------------------------------------------------
 ------------ 4. MOTIF enhancement -----------------------
 ---------------------------------------------------------
 ---------------------------------------------------------
 --- 4.1 special functions for list widgets
 ---------------------------------------------------------
 METHOD addListItem
                   (IN PRlist : ARRAY OF CHAR,
                    IN PRitem : ARRAY OF CHAR,
                    IN PRpos  : INT);
 ---------------------------------------------------------
 METHOD delListItem
                   (IN PRlist : ARRAY OF CHAR,
                    IN PRpos  : INT);
 ---------------------------------------------------------
 METHOD setListPos
                   (IN PRlist : ARRAY OF CHAR,
                    IN PRpos  : INT);
 ---------------------------------------------------------
 METHOD selectListPos
                   (IN PRlist : ARRAY OF CHAR,
                    IN PRpos  : INT);
 ---------------------------------------------------------
 METHOD deselectListPos
                   (IN PRlist : ARRAY OF CHAR,
                    IN PRpos  : INT);
 ---------------------------------------------------------
 METHOD deselectAllItems
                   (IN PRlist : ARRAY OF CHAR);
 ---------------------------------------------------------
 METHOD getSelectedItem
                   (IN  PRlist      : ARRAY OF CHAR,
                    OUT PRitem      : ARRAY OF CHAR,
                    IN  PRmaxLength : INT
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD getListCount
                   (IN  PRlist  : ARRAY OF CHAR,
                    OUT  PRcount : INT) : BOOL;
 ---------------------------------------------------------
 METHOD emptyList
                   ( PRlist : ARRAY OF CHAR);
 ----------------------------------------------------------
 ----------------------------------------------------------
 --- 4.2 special functions for tabulator groups
 ----------------------------------------------------------
 ---------------------------------------------------------
 METHOD addTabGroup
                   (IN PRelName : ARRAY OF CHAR);
 ---------------------------------------------------------
 METHOD removeTabGroup
                   (IN PRelName : ARRAY OF CHAR);
 ---------------------------------------------------------
 ---------------------------------------------------------
 --- 4.3 special functions for command widgets
 ---------------------------------------------------------
 ---------------------------------------------------------
 METHOD commandAppendValue
                   (IN PRelName : ARRAY OF CHAR,
                    IN PRvalue  : ARRAY OF CHAR);
 ---------------------------------------------------------
 METHOD commandError
                   (IN PRelName : ARRAY OF CHAR,
                    IN PRvalue  : ARRAY OF CHAR);
 ---------------------------------------------------------
 METHOD commandSetValue
                   (IN PRelName : ARRAY OF CHAR,
                    IN PRvalue : ARRAY OF CHAR);
 ---------------------------------------------------------
 ---------------------------------------------------------
 --- 4.4 special functions for CHAMPS table widgets
 ---------------------------------------------------------
 ---------------------------------------------------------
 METHOD getRows
                   (IN PRtable : ARRAY OF CHAR,
                    OUT PRrows  : INT) : BOOL;
 ---------------------------------------------------------
 METHOD getColumns
                   (IN PRtable    : ARRAY OF CHAR,
                    OUT PRcolumns : INT) : BOOL;
 ---------------------------------------------------------
 METHOD getVisibleRows
                   (IN PRtable : ARRAY OF CHAR,
                    OUT PRvisRows  : INT) : BOOL;
 ---------------------------------------------------------
 METHOD setTopRow
                   (IN PRtable : ARRAY OF CHAR,
                    IN PRrow   : INT);
 ---------------------------------------------------------
 METHOD getSelectedRow
                   (IN PRtable : ARRAY OF CHAR,
                    OUT PRrow  : INT) : BOOL;
 ---------------------------------------------------------
 METHOD emptyTable
                   (IN PRtable : ARRAY OF CHAR);
 ---------------------------------------------------------
 METHOD addRows
                   (IN PRtable : ARRAY OF CHAR,
                    IN PRrows  : INT,
                    IN PRpos   : INT);
 ---------------------------------------------------------
 METHOD deleteRow
                   (IN PRtable : ARRAY OF CHAR,
                    IN PRrow   : INT);
 ---------------------------------------------------------
 METHOD selectRow
                   (IN PRtable : ARRAY OF CHAR,
                    IN PRrow   : INT);
 ---------------------------------------------------------
 METHOD deselectRow
                   (IN PRtable : ARRAY OF CHAR,
                    IN PRrow   : INT);
 ---------------------------------------------------------
 METHOD deselectTable
                   (IN PRtable : ARRAY OF CHAR);
 ---------------------------------------------------------
 METHOD putDateTable
                   (IN PRtable : ARRAY OF CHAR,
                    IN PRdate  : XcDATE,
                    IN PRrow   : INT,
                    IN PRcol   : INT);
 ---------------------------------------------------------
 METHOD putStringTable
                   (IN PRtable : ARRAY OF CHAR,
                    IN PRstring: ARRAY OF CHAR,
                    IN PRrow   : INT,
                    IN PRcol   : INT);
 ---------------------------------------------------------
 METHOD putIntTable
                   (IN PRtable : ARRAY OF CHAR,
                    IN PRint   : INT,
                    IN PRrow   : INT,
                    IN PRcol   : INT);
 ---------------------------------------------------------
 METHOD putDoubleTable
                   (IN PRtable : ARRAY OF CHAR,
                    IN PRdouble: DOUBLE,
                    IN PRrow   : INT,
                    IN PRcol   : INT);
 ---------------------------------------------------------
 METHOD getDateTable
                   (IN  PRtable : ARRAY OF CHAR,
                    OUT PRdate  : XcDATE,
                    IN  PRrow   : INT,
                    IN  PRcol   : INT
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD getStringTable
                   (IN  PRtable     : ARRAY OF CHAR,
                    OUT PRstring    : ARRAY OF CHAR,
                    IN  PRmaxLength : INT,
                    IN  PRrow       : INT,
                    IN  PRcol       : INT
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD getIntTable
                   (IN PRtable : ARRAY OF CHAR,
                    OUT PRint  : INT,
                    IN PRrow   : INT,
                    IN PRcol   : INT
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD clearIntFTable
                   (IN PRtable : ARRAY OF CHAR,
                    IN PRrow   : INT,
                    IN PRcol   : INT
                   );
 ---------------------------------------------------------
 METHOD getIntFTable
                   (IN  PRtable  : ARRAY OF CHAR,
                    OUT PRint    : INT,
                    OUT PRvalid  : BOOL,
                    IN  PRrow    : INT,
                    IN  PRcol    : INT
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD getDoubleTable
                   (IN PRtable : ARRAY OF CHAR,
                    OUT PRdouble: DOUBLE,
                    IN PRrow   : INT,
                    IN PRcol   : INT
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD clearDoubleFTable
                   (IN PRtable : ARRAY OF CHAR,
                    IN PRrow   : INT,
                    IN PRcol   : INT
                   );
 ---------------------------------------------------------
 METHOD getDoubleFTable
                   (IN  PRtable  : ARRAY OF CHAR,
                    OUT PRdouble : DOUBLE,
                    OUT PRvalid  : BOOL,
                    IN  PRrow    : INT,
                    IN  PRcol    : INT
                   ) : BOOL;
 ---------------------------------------------------------
 METHOD setInputFocusTable
                   (IN PRtable  : ARRAY OF CHAR,
                    IN  PRrow    : INT,
                    IN  PRcol    : INT
                   );
 ---------------------------------------------------------
 PROTECTED
 ---------------------------------------------------------
 ------ instance variables (IV...) -----------------------
 ---------------------------------------------------------
 STATE
  IVdoiName : REF ARRAY OF CHAR;
   -- name of the Doi instance, by which the dialog object is 
   -- referenced as leaf or part of a tree
  IVresObjName : REF ARRAY OF CHAR;
   -- name of the Doi instance in the resource file
  IVresourceName : REF ARRAY OF CHAR;
   -- name of the resource file from where the dialog object
   -- will be loaded
  IVresourceId : INT;
   -- identifier of an opened resource file
  IVwidget : WIDGET; -- Widget
   -- widget id of the realized dialog object
  IVshell : WIDGET; -- application shell
  IVlockWindow : WINDOW; -- lock window
  IVlocked : BOOL; -- if TRUE lock window is mapped 
  IVmanaged : INT;
   -- 1: managed
  IVdestroyShell : BOOL; -- if TRUE application shell will be
                         -- destroyed in method delete
  IVisInitialized : BOOL; -- if FALSE no methods can
                          -- be invoked
  IVdoiLoop : BOOL; -- used by method 'startLocalEventLoop'
 ----------------------------------------------------------
END OBJECT;

-- Cursor shapes for "LockWindow"

CONST	XC_num_glyphs		:	INT	=	154;
CONST	XC_X_cursor		:	INT	=	0;
CONST	XC_arrow		:	INT	=	2;
CONST	XC_based_arrow_down	:	INT	=	4;
CONST	XC_based_arrow_up	:	INT	=	6;
CONST	XC_boat			:	INT	=	8;
CONST	XC_bogosity		:	INT	=	10;
CONST	XC_bottom_left_corner	:	INT	=	12;
CONST	XC_bottom_right_corner	:	INT	=	14;
CONST	XC_bottom_side		:	INT	=	16;
CONST	XC_bottom_tee		:	INT	=	18;
CONST	XC_box_spiral		:	INT	=	20;
CONST	XC_center_ptr		:	INT	=	22;
CONST	XC_circle		:	INT	=	24;
CONST	XC_clock		:	INT	=	26;
CONST	XC_coffee_mug		:	INT	=	28;
CONST	XC_cross		:	INT	=	30;
CONST	XC_cross_reverse	:	INT	=	32;
CONST	XC_crosshair		:	INT	=	34;
CONST	XC_diamond_cross	:	INT	=	36;
CONST	XC_dot			:	INT	=	38;
CONST	XC_dotbox		:	INT	=	40;
CONST	XC_double_arrow		:	INT	=	42;
CONST	XC_draft_large		:	INT	=	44;
CONST	XC_draft_small		:	INT	=	46;
CONST	XC_draped_box		:	INT	=	48;
CONST	XC_exchange		:	INT	=	50;
CONST	XC_fleur		:	INT	=	52;
CONST	XC_gobbler		:	INT	=	54;
CONST	XC_gumby		:	INT	=	56;
CONST	XC_hand1		:	INT	=	58;
CONST	XC_hand2		:	INT	=	60;
CONST	XC_heart		:	INT	=	62;
CONST	XC_icon			:	INT	=	64;
CONST	XC_iron_cross		:	INT	=	66;
CONST	XC_left_ptr		:	INT	=	68;
CONST	XC_left_side		:	INT	=	70;
CONST	XC_left_tee		:	INT	=	72;
CONST	XC_leftbutton		:	INT	=	74;
CONST	XC_ll_angle		:	INT	=	76;
CONST	XC_lr_angle		:	INT	=	78;
CONST	XC_man			:	INT	=	80;
CONST	XC_middlebutton		:	INT	=	82;
CONST	XC_mouse		:	INT	=	84;
CONST	XC_pencil		:	INT	=	86;
CONST	XC_pirate		:	INT	=	88;
CONST	XC_plus			:	INT	=	90;
CONST	XC_question_arrow	:	INT	=	92;
CONST	XC_right_ptr		:	INT	=	94;
CONST	XC_right_side		:	INT	=	96;
CONST	XC_right_tee		:	INT	=	98;
CONST	XC_rightbutton		:	INT	=	100;
CONST	XC_rtl_logo		:	INT	=	102;
CONST	XC_sailboat		:	INT	=	104;
CONST	XC_sb_down_arrow	:	INT	=	106;
CONST	XC_sb_h_double_arrow	:	INT	=	108;
CONST	XC_sb_left_arrow	:	INT	=	110;
CONST	XC_sb_right_arrow	:	INT	=	112;
CONST	XC_sb_up_arrow		:	INT	=	114;
CONST	XC_sb_v_double_arrow	:	INT	=	116;
CONST	XC_shuttle		:	INT	=	118;
CONST	XC_sizing		:	INT	=	120;
CONST	XC_spider		:	INT	=	122;
CONST	XC_spraycan		:	INT	=	124;
CONST	XC_star			:	INT	=	126;
CONST	XC_target		:	INT	=	128;
CONST	XC_tcross		:	INT	=	130;
CONST	XC_top_left_arrow	:	INT	=	132;
CONST	XC_top_left_corner	:	INT	=	134;
CONST	XC_top_right_corner	:	INT	=	136;
CONST	XC_top_side		:	INT	=	138;
CONST	XC_top_tee		:	INT	=	140;
CONST	XC_trek			:	INT	=	142;
CONST	XC_ul_angle		:	INT	=	144;
CONST	XC_umbrella		:	INT	=	146;
CONST	XC_ur_angle		:	INT	=	148;
CONST	XC_watch		:	INT	=	150;
CONST	XC_xterm		:	INT	=	152;

-- ***************************************************************
CONST spec_vid : STRING = 
   "@(#) $Header: Doi.cs[1.5] Wed Mar  9 17:01:16 1994 kalle@gianna accessed $" ;

END SPECIFICATION (* Doi *);

