(*---------------------------------------------------------------------
-- Dialog Interface Objects
-----------------------------------------------------------------------
-- Copyright: (c) Sietec GmbH & Co oHG
--            All rights reserved 1993
-----------------------------------------------------------------------
-- Modul    : Application
-- Author   : Gold, Herbert
-- angelegt : 1993-12-09
---------------------------------------------------------------------*)
SPECIFICATION Applic

IMPORT DialogInterface    FROM DialogIF;
IMPORT WindowObject       FROM WindowObj;
IMPORT MainWindow         FROM MainWin;
IMPORT DialogBox          FROM Dialog;

IMPORT DoiService, WIDGET FROM DoiServ;

EXCEPTION NoResourceInitialized;

CONST MAX_BOXES : INT = 7;    -- max. of defined dialog boxes 


TYPE Application = DialogInterface 
     OBJECT(IN argc : INT, IN argv : ARRAY OF REF ARRAY OF CHAR)

PUBLIC

  METHOD EnterEventLoop;
  METHOD SetResourcePath( IN path : STRING );
  METHOD SetDialogBoxResources( IN boxesRes : STRING );

  METHOD DangerBox( IN name  : STRING );  -- Name of DangerBox
  METHOD ErrorBox( IN name   : STRING );  -- Name of ErrorBox
  METHOD InfoBox( IN name    : STRING );  -- Name of InformationBox
  METHOD MessageBox( IN name : STRING );  -- Name of MessageBox
  METHOD WarningBox( IN name : STRING );  -- Name of WarningBox
  METHOD WaitBox( IN name    : STRING );  -- Name of WaitBox
  METHOD PromptBox( IN name  : STRING );  -- Name of PromptDialog

  METHOD WaitMsg( IN message : STRING );  -- Display a Wait-Box

  METHOD SetTrace( IN onOff : BOOL );
  -- switch trace mode on or off.
  METHOD SetDoiTrace( IN onOff : BOOL );
  -- switch trace mode for Doi on or off.

  METHOD GetContentEvent;     -- dummy

  METHOD addChild( IN aWindow : MainWindow );
  -- registers the only child.

  METHOD removeChild( IN aWindow : MainWindow );
  -- exits the application.

  METHOD initialize( IN shell : WIDGET,
                     IN element : STRING,
                     IN fileName : STRING,
                     OUT eleName : STRING,
                     OUT service : DoiService ) : WIDGET;

  METHOD shellWidget : WIDGET;

  METHOD showBox( IN parent : WindowObject,
                  IN nr:INT, IN msg:STRING, IN hlp:METHOD 
                ) : DialogBox;

  METHOD waitOff;

PROTECTED

STATE
  
  IVargc      : INT;
  IVargv      : REF ARRAY OF REF ARRAY OF CHAR;
  ResPath     : STRING;         -- Path for resource files
  DialogBoxes : STRING;         -- resource file for DialogBoxes
  BoxNames    : ARRAY [MAX_BOXES] OF STRING;

  TraceFlag   : BOOL;
  Child       : MainWindow;     
  doiCount    : INT;            -- counter for generated doiNames
  waitBox     : DialogBox;

END OBJECT;

END SPECIFICATION;            (* Applic *)

-- --------------------------------------------------------------------

