#include <stdio.h>
#include "pos.h"
#include "files.h"

/*--------------------------------------------------------------------*/

/* single chained List */
typedef struct PosInfoRec PosInfo; 
struct PosInfoRec
{
  /* line number in compilation         */
  /* concatenating all files            */
  long lineno;                 

  /* FileId of file containing lines    */
  /* up from lineno                     */
  FileId * file;                

  /* first line in file (interresting   */                              
  /* for linepragmat) normaly allways 1 */
  long startno;                
  
  PosInfo * next;
};

long yypos = 0;
long yyLineCount = 0;

/* Pointer to first and last Element in PosInfo List */
PosInfo * firstPosEntry = 0;    
PosInfo * lastPosEntry = 0;     

/*--------------------------------------------------------------------*/

void yyGetPos (long *ref_pos)
{
   *ref_pos = yypos-1;
}

/*--------------------------------------------------------------------*/

void yyPosToNextLine (void)
{
   yyLineCount++;
   yypos = yyLineCount*yyLCODE+1;
}

/*--------------------------------------------------------------------*/

void yyPosToFirstFile (FileId * file)
{
  yyLineCount = 1;
  yypos = yyLineCount*yyLCODE+1;
   
  firstPosEntry = (PosInfo *) malloc (sizeof (PosInfo));
  
  firstPosEntry->lineno = yyLineCount;
  firstPosEntry->file = file;
  firstPosEntry->startno = 1;
  firstPosEntry->next = 0;
  
  lastPosEntry = firstPosEntry;
}

/*--------------------------------------------------------------------*/

void yyPosToNextFile (FileId * file, long linenumber)
{
  yyLineCount++;
  yypos = yyLineCount*yyLCODE+1;
  
  lastPosEntry->next = (PosInfo *) malloc (sizeof (PosInfo));
  lastPosEntry = lastPosEntry->next;
  
  lastPosEntry->lineno = yyLineCount;
  lastPosEntry->file = file;
  lastPosEntry->startno = linenumber;
  lastPosEntry->next = 0;
}

/*--------------------------------------------------------------------*/

long yyLineAtPos (long pos)
{
   long l;
   l = pos / yyLCODE;
   return l;
}

/*--------------------------------------------------------------------*/

long yyColAtPos (long pos)
{
   long c;
   c = pos % yyLCODE;
   return c;
}

/*--------------------------------------------------------------------*/

void yyDecryptPos (long pos, long *line, long *column, FileId ** file)
{
  PosInfo * curr;
  long tmpline;
  
  tmpline = yyLineAtPos (pos);
  curr = firstPosEntry;
  if (curr->next != 0) {
    while (curr->next != 0 && curr->next->lineno <= tmpline) {
      curr = curr->next;
    }
  }
  *line   = tmpline - curr->lineno + curr->startno;
  *column = yyColAtPos (pos);
  *file   = curr->file;
}

/*--------------------------------------------------------------------*/

void DefaultPos (long *pos)
{
  *pos = DEFAULTPOS;
}

/*--------------------------------------------------------------------*/

void PrintPos (long pos)
{
  long line;
  long column;
  FileId *file;

  yyDecryptPos (pos, &line, &column, &file);  
  fprintf (stderr, "\"");
  fprintFileId (stderr, file);
  fprintf (stderr, "\", line %d, col %d: ", line, column);
}

/*--------------------------------------------------------------------*/
/* Debug routine */
/*--------------------------------------------------------------------*/

void DumpPosTab (void)
{
  PosInfo * curr;
  
  printf ("\n-------------------\n");
  printf ("pos table dump\n");
  printf ("-------------------\n");
  curr = firstPosEntry;
  while (curr != 0) {
    printf ("  lineno : % 5d, startno : % 5d, file : ", 
	    curr->lineno, curr->startno);
    fprintFileId (stdout, curr->file);
    printf ("\n");
    curr = curr->next;
  }
}

/*--------------------------------------------------------------------*/
