#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "errmsg.h"
#include "idents.h"
#include "files.h"
#include "pos.h"

/*--------------------------------------------------------------------*/

# define MAX_MESSAGES 100

int nosort = 0;
int errorOccured = 0;

/*--------------------------------------------------------------------*/

struct message
{
  long pos;
  char *text;
} messages [MAX_MESSAGES];

int nextMessageIndex = 0;

/*--------------------------------------------------------------------*/

NewMessage (char *text, long pos) 
{
  int i;
  int insertIndex;

  if (nosort) {
    PrintPos (pos);
    fprintf (stderr, "%s\n", text);
  }
  else {
    /* look for the first entry with an position greater or equal */
    /* than the position of the new message */
    i = 0;
    while ((i < nextMessageIndex) &&  (messages [i].pos < pos))
      i++;
    
    /* look if there is allready the same msg at the same position */
    while ((i < nextMessageIndex) && (messages [i].pos == pos)) {
      if (strcmp (text, messages [i].text) == 0)
	return;
      else
	i++;
    }
    insertIndex = i;
    
    /* shift the errorr messages with an position greater than the new */
    for (i = nextMessageIndex - 1; i >= insertIndex; i--) {
      messages [i + 1] = messages [i];
    }
    messages [insertIndex].pos = pos;
    messages [insertIndex].text = text;
    
    nextMessageIndex++;
    if (nextMessageIndex == MAX_MESSAGES) {
      FlushMessages ();
      fprintf (stderr, "too many errors\n");
      exit(1);
    }
  }
}

/*--------------------------------------------------------------------*/
/* exported routines                                                  */
/*--------------------------------------------------------------------*/

void Warning (char *text, long pos)
{
  char * buf;
  
  buf = (char *) malloc (strlen (text) + 10);
  if (buf == (char *) NULL) Fatal ("Out of memory");
  sprintf (buf, "warning: %s", text);
  NewMessage (buf, pos);
}

/*--------------------------------------------------------------------*/

void WarningI (char *str1, Ident id, char *str2, long pos)
{
  char * repr;
  char * buf;

  id_to_string (id, &repr);
  buf = (char *) malloc (strlen (str1) + strlen (repr) + strlen (str2) + 10);
  if (buf == (char *) NULL) Fatal ("Out of memory");
  sprintf (buf, "warning: %s%s%s", str1, repr, str2);
  NewMessage (buf, pos);
}

/*--------------------------------------------------------------------*/

void Error (char *text, long pos)
{
  char * buf;
  
  buf = (char *) malloc (strlen (text) + 1);
  if (buf == (char *) NULL) Fatal ("Out of memory");
  sprintf (buf, "%s", text);
  NewMessage (buf, pos);
  errorOccured = 1;
}

/*--------------------------------------------------------------------*/

void ErrorI (char *str1, Ident id, char *str2, long pos)
{
  char * repr;
  char * buf;

  id_to_string (id, &repr);
  buf = (char *) malloc (strlen (str1) + strlen (repr) + strlen (str2) + 1);
  if (buf == (char *) NULL) Fatal ("Out of memory");
  sprintf (buf, "%s%s%s", str1, repr, str2);
  NewMessage (buf, pos);
  errorOccured = 1;
}

/*--------------------------------------------------------------------*/

void FlushMessages (void)
{
  int i;
  long pos;

  for (i = 0; i < nextMessageIndex; i++) {
    PrintPos (messages [i].pos);
    fprintf (stderr, "%s\n", messages [i].text);
  }
}

/*--------------------------------------------------------------------*/

void CheckErrorMessages (void)
{
  if (errorOccured) {
    FlushMessages ();
    exit (1);
  }
}

/*--------------------------------------------------------------------*/

void yyerror (char *text)
{
   long pos;
   char *newmsg;

   yyGetPos (& pos);
   
   /* bison generated parser generates the error message : 
   /* parse error instead of syntax error */

   if (strncmp (text, "parse", 5) == 0) {
     newmsg = (char *) malloc (strlen (text) + 2);
     strcpy (newmsg, "syntax");
     strcat (newmsg, text + 5);
     Error (newmsg, pos);
     free (newmsg);
   }
   else {
     Error (text, pos);
   }
   CheckErrorMessages ();
}

/*--------------------------------------------------------------------*/

void yylexerror (char *text)
{
   long pos;

   yyGetPos (& pos);
   Error (text, pos);
   CheckErrorMessages ();
}

/*--------------------------------------------------------------------*/

void ErrorUsage (char *text)
{
   fprintf(stderr, "%s\n", text);
   exit (2);
}

/*--------------------------------------------------------------------*/

void Fatal (char *text)
{
   fprintf (stderr, "INTERNAL COMPILER ERROR : %s\n", text);
   exit (10);
}

/*--------------------------------------------------------------------*/

