-----------------------------------------------------------------------------
--                  CooL-V2.0 - destination code interface                 --
-----------------------------------------------------------------------------
--                 general declaration generation routines                 --
--                            Version 1.0, 1993                            --
-----------------------------------------------------------------------------

'module' codedecl

'export' 
     GenerateProcedureSpecification
     GenerateProcedureImplementation
     GenerateForeignProcSpecification
     GenerateClass
     GenerateClassImpl
     GenerateConstant
     GenerateGlobalVarSpecification
     GenerateGlobalVarImplementation
     GenerateForeignVarSpecification
     GenerateStaticGlobalVar
     GenerateExceptionSpecification
     GenerateExceptionSpecImpl
     GenerateStaticException
     TransformProcedureType
     Current
     UnchangedResultType

'use' ast
      extspecs
      misc
      types
      coder
      codetype
      codeexpr
      codestmt
      mapping

-----------------------------------------------------------------------------

'var' UnchangedResultType : TYPE
'var' Current : ID

-- GenerateClass ------------------------------------------------------------

'action' GenerateClass (DECL)

     'rule' GenerateClass (class (Pos, Id, GenParams, Interface, Methods))
	  GenerateClassSpecification (classspec (Pos, Id, GenParams, 
						 Interface))
	  GenerateClassImpl (classimpl (Pos, Id, Methods))

-- GenerateClassImpl --------------------------------------------------------

'action' GenerateClassImpl( DECL )

    'rule' GenerateClassImpl( classimpl( Pos, Id, Methods ) )
        GetDefiningId( Id -> Id2 )
	Current <- Id2
	FollowNameChain (composite (typename (Id2)) -> 
			 composite (classtype (_, _, Interface)))
	MapInterface (Interface)
        MapMethods( Methods )
        GenerateRedefMethodSpec( Id, Methods )
        GenerateMethodTable( Id, Methods )
        GenerateNEWInit( Id )
        GenerateNEWImpl( Id )
        GenerateLocalMethodSpec( Id, Methods )
        GenerateMethodImpl( Id, Methods )
        IfNoINITIALLYGenerateIt( Id, Methods )
        IfNoFINALLYGenerateIt( Id, Methods )
        GenerateDELETEImpl( Id )

-- GenerateRedefMethodSpec --------------------------------------------------

'action' GenerateRedefMethodSpec (ID, DECL)

     'rule' GenerateRedefMethodSpec (ClassName, seq( _, Left, Right))
	  GenerateRedefMethodSpec (ClassName, Left)
	  GenerateRedefMethodSpec (ClassName, Right)
 
     'rule' GenerateRedefMethodSpec (ClassName, methodimpl (_, Id, redef,
							    FParams, Result,
							    _, _ )) :
	  RecomputeMethodInterface (ClassName, FParams, Result ->
				    NewFParams, NewResult)
	  GenerateBaseType (NewResult)
	  GenerateQualifiedCooLName (ClassName)
	  GenerateCooLName (Id)
	  Write (" (")
	  GenerateParameterTypeList (NewFParams)
	  Write (")")
	  GenerateBaseTypeExtension (NewResult)
	  Writeln (";")
	  
    'rule' GenerateRedefMethodSpec( _, _ )

-- IfNoINITIALLYGenerateIt --------------------------------------------------

'action' IfNoINITIALLYGenerateIt (ID, DECL)

     'rule' IfNoINITIALLYGenerateIt (ClassName, Impls)
	  DefaultPos (-> P)
	  GetIdMeaning (ClassName -> type (TypeI))
	  TypeI'Type -> composite (classtype (_, _, interface (_, _, Params,
							       _, _ )))
	  let (initially (P, Params, nil (P), block (P, P, nil (P))) -> Init)
	  (|
	       IsImplemented (Init, Impls)
	  ||
	       GenerateMethodImpl (ClassName, Init)
	  |)
       
-- IfNoFINALLYGenerateIt -----------------------------------------------------

'action' IfNoFINALLYGenerateIt (ID, DECL)

    'rule' IfNoFINALLYGenerateIt (ClassName, Impls)
	 DefaultPos (-> P)
	 let (finally (P, nil (P), block (P, P, nil (P))) -> Finit)
	 (|
	      IsImplemented (Finit, Impls)
	 ||
	      GenerateMethodImpl (ClassName, Finit)
	 |)

-- IsImplemented ------------------------------------------------------------

'condition' IsImplemented (DECL, DECL)

     'rule' IsImplemented (Decl, seq( _, Left, Right))
	  IsImplemented (Decl, Left)
			 
     'rule' IsImplemented (Decl, seq( _, Left, Right))
	  IsImplemented (Decl, Right)
			 
     'rule' IsImplemented (initially (_, _, _, _), initially (_, _, _, _))

     'rule' IsImplemented (finally (_, _, _), finally (_, _, _))

-- GenerateLocalMethodSpec --------------------------------------------------

'action' GenerateLocalMethodSpec (ID, DECL)

     'rule' GenerateLocalMethodSpec (ClassName, ImplMethods)
	  GetIdMeaning (ClassName -> type (TypeIndex))
	  TypeIndex'Type -> 
	     composite (classtype (_, _, interface (_, _, _, 
						    ExportMethods, _)))
	  GenerateLocalsMethodSpecifications (ClassName, 
					      ImplMethods, ExportMethods)

-- GenerateLocalsMethodSpecifications ---------------------------------------

'action' GenerateLocalsMethodSpecifications (ID, DECL, DECL)

     'rule' GenerateLocalsMethodSpecifications (ClassName,
						seq (_, Left, Right), Specs)
	  GenerateLocalsMethodSpecifications (ClassName, Left, Specs)
	  GenerateLocalsMethodSpecifications (ClassName, Right, Specs)

     'rule' GenerateLocalsMethodSpecifications (ClassName,
						methodimpl (Pos, Id, Flag,
							    Params, Result,
							    _, _), Specs)
	  IsExportedMethod (Id, Specs)

     'rule' GenerateLocalsMethodSpecifications (ClassName,
						methodimpl (_, Name, _,
							    FParams, Result,
							    _, _ ), Specs)
	  RecomputeMethodInterface (ClassName, FParams, Result ->
				    NewFParams, NewResult)
	  GenerateBaseType (NewResult)
	  GenerateQualifiedCooLName (ClassName)
	  GenerateCooLName (Name)
	  Write (" (")
	  GenerateParameterTypeList (NewFParams)
	  Write (")")
	  GenerateBaseTypeExtension (NewResult)
	  Writeln (";")
	 
    'rule' GenerateLocalsMethodSpecifications( _, _ , _ )

-- IsExportedMethod ---------------------------------------------------------

'condition' IsExportedMethod( ID, DECL )

    'rule' IsExportedMethod( Name, seq( _, Left, Right ) )
        IsExportedMethod( Name, Left )

    'rule' IsExportedMethod( Name, seq( _, Left, Right ) )
        IsExportedMethod( Name, Right )

    'rule' IsExportedMethod( Name1, methodspec( _, Name2, _, _, _, _, _ ) )
        EqId( Name1, Name2 )

-- GenerateMethodTable ------------------------------------------------------

'action' GenerateMethodTable (ID, DECL)

     'rule' GenerateMethodTable (ClassName, Methods)
	  Write ("struct ")
	  GenerateMTabTypeName (ClassName)
	  Write (" ")
	  GenerateMTabVarName (ClassName)
	  Writeln (" = {")
	  MethodTableInits (ClassName, Methods)
	  Writeln ("")
	  Writeln ("};")

-- MethodTableInits ---------------------------------------------------------

'action' MethodTableInits (ID, DECL)

     'rule' MethodTableInits (ClassName, ImplMethods)
	  GetIdMeaning  (ClassName -> type (TypeIndex))
	  TypeIndex'Type -> 
	     composite (classtype (_, _, interface (Super, _, _, 
						    ExportMethods, _ )))
	  MethodTableInitSuper (Super)
	  Writeln (",")
	  Write ("  0")
	  GenerateExportMethodInit (ClassName, ExportMethods, ImplMethods)

-- MethodTableInitSuper -----------------------------------------------------

'action' MethodTableInitSuper (SUPERTYPE)

     'rule' MethodTableInitSuper (super (ClassName))
	  Write ("  &")
	  GenerateMTabVarName (ClassName)

     'rule' MethodTableInitSuper (none)
	  Write ("  (void *)0")

-- GenerateExportMethodInit -------------------------------------------------

'action' GenerateExportMethodInit (ID, DECL, DECL)

     'rule' GenerateExportMethodInit (ClassName, nil (_), _)

     'rule' GenerateExportMethodInit (ClassName, seq (_, Left, Right), 
				      ImplMethods)
	  GenerateExportMethodInit (ClassName, Left, ImplMethods)
	  GenerateExportMethodInit (ClassName, Right, ImplMethods)

     'rule' GenerateExportMethodInit (ClassName, 
				      methodspec (_, _, _, abstract, _,
						  FParams, Result), _)
	  RecomputeMethodInterface (ClassName, FParams, Result ->
				    NewFParams, NewResult)
	  Writeln (",")
	  Write ("  (")
	  GenerateBaseType (NewResult)
	  Write ("(*)( ")
--	  GenerateParameterTypeList (NewFParams) -- problem ATT-C-Compiler
                                                 -- on RM400/600 
	  Write (" )")
	  GenerateBaseTypeExtension (NewResult)
	  Write (")0")

     'rule' GenerateExportMethodInit (ClassName, 
				      methodspec (_, Name, _, _, inherited,
						  FParams, Result),
				      ImplMethods)
	  RecomputeMethodInterface (ClassName, FParams, Result ->
				    NewFParams, NewResult)
	  Writeln (",")
	  Write ("  (")
	  GenerateBaseType (NewResult)
	  Write ("(*)( ")
--	  GenerateParameterTypeList (NewFParams) -- problem ATT-C-Compiler
                                                 -- on RM400/600
	  Write (")")
	  GenerateBaseTypeExtension (NewResult)
	  Write (")(-1)")
	      
     'rule' GenerateExportMethodInit (ClassName, 
				      methodspec (_, Name, _, _, 
						  _, _, _ ),
				      ImplMethods)
	  Writeln (",")
	  Write ("  ")
	  GenerateQualifiedCooLName (ClassName)
	  GenerateCooLName (Name)

-- GenerateDELETEImpl -------------------------------------------------------

'action' GenerateDELETEImpl (ClassName : ID)

     'rule' GenerateDELETEImpl (ClassName)
	  Write ("void ")
	  GenerateQualifiedCooLName (ClassName)
	  Write ("C3IDELETE (")
	  GenerateClassName (ClassName)
	  Writeln (" C3ICURRENT)")
	  Writeln ("{")
	  Writeln ("C3ICURRENT->C3IMTABR->C3IFINALLY (C3ICURRENT);")
	  GenerateHiddenName ("DELETE")
	  Writeln (" ((C3IC3IMEM_BLOCK_DESCR *) C3ICURRENT);")
	  Writeln ("}")

-- GenerateNEWInit ----------------------------------------------------------

'action' GenerateNEWInit (ID)

     'rule' GenerateNEWInit (ClassName)
	  GetIdMeaning (ClassName -> type (TypeIndex))
	  TypeIndex'Type -> 
	     composite (classtype (_, GenParams, interface (Super, _, _, 
							    ExportMethods, _)))
	  Writeln ("") 
	  Write ("void ")
	  GenerateQualifiedCooLName (ClassName)
	  GenerateHiddenName ("NEW")
	  Writeln (" (void)")
	  Writeln ("{")
	  GenerateSUPERNEWInitCall (Super)
	  GenerateNEWInitImpl (ClassName, Super, ExportMethods)
	  GenerateMTabVarName (ClassName)
	  Write (".C3IFINALLY =")
	  GenerateQualifiedCooLName (ClassName)
	  Writeln ("C3IFINALLY;")
	  Writeln ("}")

-- GenerateSUPERNEWInitCall -------------------------------------------------

'action' GenerateSUPERNEWInitCall( SUPERTYPE )

    'rule' GenerateSUPERNEWInitCall( none )

    'rule' GenerateSUPERNEWInitCall( super( ClassName ) )
        Write( "if (!" )
	GenerateMTabVarName( ClassName )
        Writeln( ".C3IFINALLY)" )
	GenerateQualifiedCooLName( ClassName )
	GenerateHiddenName( "NEW" )
	Writeln( " ();" )

-- GenerateNEWInitImpl ------------------------------------------------------

'action' GenerateNEWInitImpl( ID, SUPERTYPE, DECL)

    'rule' GenerateNEWInitImpl( _, none, _)

    'rule' GenerateNEWInitImpl( _, _, nil( _ ))

    'rule' GenerateNEWInitImpl( ClassName, Super,
			        seq( _, Left, Right ))
        GenerateNEWInitImpl( ClassName, Super, Left)
        GenerateNEWInitImpl( ClassName, Super, Right)

    'rule' GenerateNEWInitImpl( ClassName, super( Super ),
			        methodspec( _, Name, _, _, inherited,
					    Params, Result ))
	 GenerateMTabVarName (ClassName)
        Write( "." )
        GenerateCooLName( Name )
        Write( " = (" )
        GenerateMethodCast(Params, Result )
	 GenerateMTabVarName (Super)
        Write( "." )
        GenerateCooLName( Name )
        Writeln( ");" )

    'rule' GenerateNEWInitImpl( ClassName, super( Super ),
			        methodspec( _, Name, _, _, redef,
					    Params, Result ))
	 GenerateMTabVarName (ClassName)
        Write( "." )
        GenerateCooLName( Name )
        Write( " = (" )
        GenerateMethodCast(Params, Result )
        GenerateQualifiedCooLName( ClassName )
        GenerateCooLName( Name )
        Writeln( ");" )

    'rule' GenerateNEWInitImpl( _, _, _)

-- GenerateNEWImpl ----------------------------------------------------------

'action' GenerateNEWImpl (ID)

     'rule' GenerateNEWImpl (ClassName)
	  GetIdMeaning (ClassName -> type (TypeIndex))
	  TypeIndex'Type -> 
	    composite (classtype (_, GenParams, 
				  interface( _, concrete, ObjParams, _, IV)))
	  Writeln ("")
	  GenerateClassName (ClassName)
	  Write (" ")
	  GenerateQualifiedCooLName (ClassName)
	  Write ("C3INEW (")
	  GenerateNEWParameterList (GenParams, ObjParams)
	  Writeln (")")
	  Writeln ("{" )
	  GenerateClassName (ClassName)
	  Writeln (" C3ICURRENT;")
 	  GenerateAllocObject (ClassName, GenParams, IV)
	  GenerateInitCall (ClassName, ObjParams)
	  Writeln ("return C3ICURRENT;")
	  Writeln ("}") 

    'rule' GenerateNEWImpl( _ )

-- GenerateInitCall ---------------------------------------------------------

'action' GenerateInitCall (ID, FPARAMLIST)

     'rule' GenerateInitCall (ClassName, ObjParams)
	  GenerateQualifiedCooLName (ClassName)
	  Write ("C3IINITIALLY (C3ICURRENT")
	  GenerateInitParams (ObjParams)
	  Writeln (");")
	      
-- GenerateInitParams ----------------------------------------------

'action' GenerateInitParams  (FPARAMLIST)

     'rule' GenerateInitParams (nil) :

     'rule' GenerateInitParams (fparamlist (fparam (_, Id, _, TypeI), Tail)) :
	  Write (", ")
	  GenerateCooLName (Id)
	  [|
	       IsFormalGenericTypeIndex (TypeI -> TypeId)
	       GenerateCooLName (TypeId)
	  |]
	  GenerateInitParams (Tail)

-- GenerateAllocObject ------------------------------------------------------

'action' GenerateAllocObject (ClassName : ID, GenParams : FPARAMLIST,
			      InstVars : DECL)

     'rule' GenerateAllocObject (ClassName, GenParams, InstVars)
	  -- create IV record
	  Write ("C3ICURRENT = (")
	  GenerateClassName (ClassName)
	  Write (") ")
	  GenerateHiddenName ("NEW")
	  Write (" (")
	  GenerateIVRecSize (ClassName, GenParams, InstVars)
	  Write (", &" )
	  GenerateMTabVarName (ClassName)
	  Writeln (");")
	  -- init generic TypeInfos
	  GenerateGenTypeInfoInit (GenParams)
	  -- init MTAB
	  Write ("if (!")
	  GenerateMTabVarName (ClassName)
	  Writeln (".C3IFINALLY)")
	  GenerateQualifiedCooLName (ClassName)
	  GenerateHiddenName ("NEW")
	  Writeln (" ();")

-- GenerateIVRecSize ----------------------------------------------------

'action' GenerateIVRecSize (ClassName : ID, GenParams : FPARAMLIST, 
			    InstVars : DECL)
     
     'rule' GenerateIVRecSize (_, nil, nil) :
	  Write ("0")
	  
     'rule' GenerateIVRecSize (ClassName, _, _) :
	  Write ("sizeof (struct ")
	  GenerateHiddenName ("IV")
	  GenerateQualifiedCooLName (ClassName)
	  Write( ")")
	  

-- GenerateGenTypeInfoInit -------------------------------------------------
		 
'action' GenerateGenTypeInfoInit (GenParams : FPARAMLIST)
     
     'rule' GenerateGenTypeInfoInit (fparamlist (GenParam, Tail))
	  (|
	       where (GenParam -> unconstrained (_, Id))
	  ||
	       where (GenParam -> constrained (_, Id, _))
	  |)
	  Write ("C3ICURRENT->C3IIVR->")
	  GenerateCooLName (Id)
	  Write (".C3IName")
	  Write (" = ")
	  GenerateCooLName (Id)
	  Writeln (";")
	  GenerateGenTypeInfoInit (Tail)
	  
     'rule' GenerateGenTypeInfoInit (nil) :
	  
-- GenerateMethodImpl -------------------------------------------------------

'action' GenerateMethodImpl (ID, DECL)

     'rule' GenerateMethodImpl (ClassId, seq( _, Left, Right))
	  GenerateMethodImpl (ClassId, Left)
	  GenerateMethodImpl (ClassId, Right)

     'rule' GenerateMethodImpl (_, nil (_))

     'rule' GenerateMethodImpl (ClassName, 
				methodimpl (Pos, Id, Flag, FParams, ResultI, 
					    Locals, block( _, EndPos, Body)))
	  RecomputeMethodInterface (ClassName, FParams, ResultI ->
				    NewFParams, NewResult)
	  Writeln ("")
	  GenerateBaseType (NewResult)
	  GenerateQualifiedCooLName (ClassName)
	  GenerateCooLName (Id)
	  Write (" (")
	  GenerateParameterList (NewFParams)
	  Write (")")
	  GenerateBaseTypeExtension (NewResult)
	  ResultI'Type -> Result
	  UnchangedResultType <- Result
	  Writeln ("")
	  Writeln ("{")
	  GenerateLocalVars (Locals)
	  GenerateBody (Body, Locals)
	  GenerateLineInfo (EndPos)
	  Writeln ("}")
     
     'rule' GenerateMethodImpl (ClassId, initially (Pos, FParams, Locals, 
						    block (_, EndPos, Body)))
	  VoidTypeIndex -> Result
	  RecomputeMethodInterface (ClassId, FParams, Result -> 
				    NewFParams, NewResult)
	  Writeln ("")
	  GenerateBaseType (NewResult)
	  GenerateQualifiedCooLName (ClassId)
	  Write ("C3IINITIALLY (")
--        CastStarts
	  GenerateParameterList (NewFParams)
--        CastEnds
	  Writeln (")")
	  Writeln ("{")
	  GenerateLocalVars (Locals)
	  GenerateSuperINITIALLY (ClassId, FParams) -- old FParams !!!
	  Writeln ("{") 
	  GenerateBody (Body, Locals)
	  Writeln ("}") 
	  GenerateLineInfo (EndPos)
	  Writeln ("}")
	  
     'rule' GenerateMethodImpl (ClassId, finally (Pos, Locals, 
						  block( _, EndPos, Body)))
	  VoidTypeIndex -> Result
	  RecomputeMethodInterface (ClassId, nil, Result -> 
				    NewFParams, NewResult)
	  Writeln ("")
	  GenerateBaseType (NewResult)
	  GenerateQualifiedCooLName (ClassId)
	  Write ("C3IFINALLY (")
	  GenerateParameterList (NewFParams)
	  Writeln (")")
	  Writeln ("{")
	  GenerateLocalVars (Locals)
	  GenerateBody (Body, Locals)
	  GenerateSuperFINALLY (ClassId)
	  GenerateLineInfo (EndPos)
	  Writeln ("}")

-- GenerateSuperINITIALLY ----------------------------------------------------

'action' GenerateSuperINITIALLY (ID, FPARAMLIST)

     'rule' GenerateSuperINITIALLY (ClassId, Params)
	  GetIdMeaning (ClassId -> type (TypeIndex))
	  TypeIndex'Type -> 
	    composite (classtype (_, _, interface (super (Super),
						   _, _, _, _ )))
	  GenerateQualifiedCooLName (Super)
	  Write ("C3IINITIALLY ((")
	  GenerateClassName (Super)
	  Write (") C3ICURRENT")
	  GenerateSuperInitParams (Super, Params)
	  Writeln (");")

     'rule' GenerateSuperINITIALLY (_, _)

-- GenerateSuperInitParams ---------------------------------------------------

'action' GenerateSuperInitParams (ID, FPARAMLIST)

     'rule' GenerateSuperInitParams (_, nil) :
	  
     'rule' GenerateSuperInitParams (Super, Params)
	  GetIdMeaning (Super -> type (TypeIndex))
	  TypeIndex'Type -> 
	     composite (classtype (_, _, interface (_, _, SuperParams, _, _)))
	  GenerateSuperParams (SuperParams, Params)
	  
-- GenerateSuperParams -------------------------------------------------------

'action' GenerateSuperParams (FPARAMLIST, FPARAMLIST)

     'rule' GenerateSuperParams (nil , _)

     'rule' GenerateSuperParams (fparamlist (_, List1), 
				 fparamlist (fparam (_, Id, _, Type),
					     List2)) :
	  Write (", ")
	  GenerateCooLName (Id)
	  [|
	       IsFormalGenericTypeIndex (Type -> TypeId)
	       GenerateCooLName (TypeId)
	  |]
	  GenerateSuperParams (List1, List2)

-- GenerateSuperFINALLY ------------------------------------------------------

'action' GenerateSuperFINALLY (ID)

     'rule' GenerateSuperFINALLY (ClassId)
	  GetIdMeaning (ClassId -> type (TypeIndex))
	  TypeIndex'Type -> 
	     composite (classtype (_, _, interface (super (Super),
						    _, _, _, _ )))
	  GenerateQualifiedCooLName (Super)
	  Write ("C3IFINALLY ((")
	  GenerateClassName (Super)
	  Writeln (") C3ICURRENT);")

     'rule' GenerateSuperFINALLY (_)

-- GenerateProcedureSpecification -------------------------------------------

'action' GenerateProcedureSpecification (DECL)

     'rule' GenerateProcedureSpecification 
               (Decl:procspec (_, ProcId, Export, CallConv, Params, Result))
	  MapProcedure (Decl)
	  TransformProcedureType (Params, Result -> NewParams, NewResultType)
	  GeneratePossibleStatic (ProcId)
	  GenerateBaseType (NewResultType)
	  GenerateCallingConvention (CallConv)
	  GenerateExportedName (Export, ProcId)
	  Write (" (")
	  GenerateParameterList (NewParams)
	  Write (")")
	  GenerateBaseTypeExtension (NewResultType)
	  Writeln (";")

-- GenerateProcedureImplementation ------------------------------------------

'action' GenerateProcedureImplementation (DECL)

     'rule' GenerateProcedureImplementation 
               (Decl:procimpl (Pos, ProcId, Params, ResultI, Locals, 
			       block(_, EndPos, Body))) :
	  MapProcedure (Decl)
	  Writeln ("") 
	  TransformProcedureType (Params, ResultI -> NewParams, NewResultType)
	  GeneratePossibleStatic (ProcId)
	  GenerateBaseType (NewResultType)
	  GetIdMeaning (ProcId -> proc (Export, CallConv, _, _))
	  GenerateCallingConvention (CallConv)
	  GenerateExportedName (Export, ProcId)
	  Write (" (")
	  GenerateParameterList (NewParams)
	  Write (")")
	  GenerateBaseTypeExtension (NewResultType)
	  ResultI'Type -> Result
	  UnchangedResultType <- Result
	  Writeln ("")
	  Writeln ("{")
	  GenerateLocalVars (Locals)
	  -- init RTS if necessary and Export = root
	  GenerateBody (Body, Locals)
	  -- finit RTS if necessary and Export = root
	  GenerateLineInfo (EndPos)
	  Writeln ("}")

-- GeneratePossibleStatic --------------------------------------------------

'action' GeneratePossibleStatic (ID)

     'rule' GeneratePossibleStatic (ProcId)
	  IsExportedProcedure (ProcId)

     'rule' GeneratePossibleStatic (ProcId)
	  Write ("static ")

-- GenerateForeignProcSpecification ----------------------------------------

'action' GenerateForeignProcSpecification (DECL)

     'rule' GenerateForeignProcSpecification 
               (Decl:foreignproc (Pos, ProcId, CallConv, Params, Result))
	  MapProcedure (Decl)
	  TransformProcedureType (Params, Result -> NewParams, NewResultType)
	  GenerateBaseType (NewResultType)
	  GenerateCallingConvention (CallConv)
	  GenerateCName (ProcId)
	  Write (" (")
	  GenerateParameterList (NewParams)
	  Write (")")
	  GenerateBaseTypeExtension (NewResultType)
	  Writeln (";")

-- GenerateCallingConvention -----------------------------------------------

'action' GenerateCallingConvention (CallConv : CALLCONV)
     
     'rule' GenerateCallingConvention (pascal) :
	  IsWindowsNT
	  Write ("__stdcall ")
     
     'rule' GenerateCallingConvention (_) :
	  
-- GenerateConstant ---------------------------------------------------------

'action' GenerateConstant( DECL )

    'rule' GenerateConstant( const( Pos, Ident, TypeI, Value ) )
        MapTypeIndex( TypeI, implementation -> ActualType )
        -- constants are mapping direcly by its value.

-- GenerateGlobalVarSpecification -------------------------------------------

'action' GenerateGlobalVarSpecification (DECL)

     'rule' GenerateGlobalVarSpecification (globalvar (_, Id, Export,
						       TypeI, _))
	  MapTypeIndex (TypeI, implementation -> ActualType)
	  Write ("extern ")
	  GenerateBaseType (ActualType)
	  GenerateExportedName (Export, Id)
	  GenerateBaseTypeExtension( ActualType )
	  Writeln( ";" )

-- GenerateGlobalVarImplementation -----------------------------------------

'action' GenerateGlobalVarImplementation (DECL)

     'rule' GenerateGlobalVarImplementation (globalvar (_, Id, Export,
							TypeI, Init))
	  MapTypeIndex (TypeI, implementation -> ActualType)
	  GenerateBaseType (ActualType)
	  GenerateExportedName (Export, Id)
	  GenerateBaseTypeExtension (ActualType)
	  GenerateGlobalVarInit (Init)
	  Writeln (";")

-- GenerateGlobalVarInit -----------------------------------------------------

'action' GenerateGlobalVarInit (EXPR)
	  
     'rule' GenerateGlobalVarInit (nil (_)) :
			    
     'rule' GenerateGlobalVarInit (stringliteral (_, Value)) :
	  Write (" = { ")
	  WriteString (Value)
	  Write (" }")

     'rule' GenerateGlobalVarInit (Expr) :
	  Write (" = ")
	  GenerateEnclosedExpr (Expr)
	  
-- GenerateForeignVarSpecification -------------------------------------------

'action' GenerateForeignVarSpecification (DECL)

     'rule' GenerateForeignVarSpecification (foreignvar (Pos, Id, TypeI)) :
	  GenerateGlobalVarSpecification (globalvar (Pos, Id, foreign, TypeI, 
						     nil (Pos)))

-- GenerateStaticGlobalVar --------------------------------------------------

'action' GenerateStaticGlobalVar (DECL)

     'rule' GenerateStaticGlobalVar (globalvar (_, Id, Export, TypeI, Init)) :
	  MapTypeIndex (TypeI, implementation -> ActualType)
	  Write ("static ")
	  GenerateBaseType (ActualType)
	  GenerateExportedName (Export, Id)
	  GenerateBaseTypeExtension (ActualType)
	  GenerateGlobalVarInit (Init)
	  Writeln (";")

-- GenerateExceptionSpecification --------------------------------------------

'action' GenerateExceptionSpecification (DECL)

     'rule' GenerateExceptionSpecification( exception( _, Exception, Params ) )
	  GenerateExceptionType (Exception, Params)
	  Write ("extern struct ")
	  GenerateQualifiedCooLName (Exception)
	  Write (" ")
	  GenerateQualifiedCooLName (Exception)
	  Writeln (";")

-- GenerateStaticException --------------------------------------------------

'action' GenerateStaticException (DECL)

     'rule' GenerateStaticException (exception (_, Exception, Params))
	  GenerateExceptionType (Exception, Params)
	  Write ("static ")
	  GenerateExceptionDeclInit (Exception)

-- GenerateExceptionSpecImpl ------------------------------------------------

'action' GenerateExceptionSpecImpl (DECL)

    'rule' GenerateExceptionSpecImpl (exception (_, Exception, Params))
	 MapParameterTypes (Params, implementation)
	 GenerateExceptionDeclInit (Exception)
	 
-- GenerateExceptionDeclInit ------------------------------------------------

'action' GenerateExceptionDeclInit (ID)
     
     'rule' GenerateExceptionDeclInit (Id) :
	  Write ("struct ")
	  GenerateQualifiedCooLName (Id)
	  Write (" ")
	  GenerateQualifiedCooLName (Id)
	  Write (" = { \"")
	  GenerateModuleName (Id)
	  Write ("::")
	  GenerateCName (Id)
	  Writeln ("\" };")

-- GenerateExceptionType ----------------------------------------------------
	 
'action' GenerateExceptionType (ID, FPARAMLIST)
     
     'rule' GenerateExceptionType (Id, Params) :
	  MapParameterTypes (Params, implementation)
	  Write ("struct ")
	  GenerateQualifiedCooLName (Id)
	  Writeln ("")
	  Writeln ("{")
	  Writeln ("char *C3IEXCEPTION;")
	  GenerateExceptionParams (Params)
	  Writeln ("};")
	  
-- GenerateExceptionParams ---------------------------------------------------

'action' GenerateExceptionParams (FPARAMLIST)

     'rule' GenerateExceptionParams (fparamlist (fparam (_, Id, _, TypeI),
						 List))
	  TransformTypeIndex (TypeI -> ActualType) 
	  GenerateBaseType (ActualType)
	  GenerateCooLName (Id)
	  GenerateBaseTypeExtension (ActualType)
	  Writeln (";") 
	  GenerateExceptionParams (List)

    'rule' GenerateExceptionParams (_)

-- GenerateLocalVars ----------------------------------------------------------
-- Initialization of local vars is done via GenerateBody
	 
'action' GenerateLocalVars (DECL)

     'rule' GenerateLocalVars (seq (_, Left, Right))
	  GenerateLocalVars (Left)
	  GenerateLocalVars (Right)

     'rule' GenerateLocalVars (localvar (_, LocalId, Type, Init))
	  TransformTypeIndex (Type -> LocalType)
	  GenerateBaseType (LocalType)
	  GenerateCooLName (LocalId)
	  [|
	       IsFormalGenericTypeIndex (Type -> TypeId)
	       GenerateCooLName (TypeId)
	  |]
	  GenerateBaseTypeExtension (LocalType)
	  Writeln (";")
			    
     'rule' GenerateLocalVars (nil (_))

-- TransformProcedureType ----------------------------------------------------

'action' TransformProcedureType (FPARAMLIST, TYPEINDEX -> FPARAMLIST, TYPE)

    'rule' TransformProcedureType (Params, ResultTypeI ->
				   NewParams, NewResultType)
	 FollowNameChainIndex (ResultTypeI -> composite (array( _, _ )))
	 ReturnId -> NewId
	 DefaultPos (-> NewPos)
	 let (fparamlist (fparam (NewPos, NewId, out, ResultTypeI), 
			  Params) -> NewParams)
	 BuildRefBaseType (ResultTypeI -> NewResultType)

     'rule' TransformProcedureType (Params, Result -> Params , ActualResult)
	  Result'Type -> ActualResult

-- GenerateParameterList ---------------------------------------------------

-- This predicate generates a parameter list. In case of the list
-- is empty a special rule is applied.

'action' GenerateParameterList( FPARAMLIST )

    'rule' GenerateParameterList( nil )
        Write( "void" )

    'rule' GenerateParameterList( ellipsis )

    'rule' GenerateParameterList( List )
--        CastStarts
        GenerateParameterList2( List )
--        CastEnds

-- GenerateParameterList2 ----------------------------------------------

'action' GenerateParameterList2( FPARAMLIST )

    'rule' GenerateParameterList2( fparamlist( Param, nil ) )
        GenerateParameter( Param )

    'rule' GenerateParameterList2( fparamlist( Param, List ) )
        GenerateParameter( Param )
        Write( ", " )
        GenerateParameterList2( List )

    'rule' GenerateParameterList2( ellipsis )
        Write( "..." )

    'rule' GenerateParameterList2( nil )

-- GenerateParameter --- --------------------------------------------------

-- This predicate generates a parameter. The mode of the parameter
-- is expanded and with the parameter type connected.

'action' GenerateParameter( FPARAM )

     'rule' GenerateParameter (fparam (_, ParamId, Mode, TypeI))
	  ExpandParameterMode (Mode, TypeI -> ParameterType)
	  GenerateBaseType (ParameterType)
	  GenerateCooLName (ParamId)
	  [|
	       IsFormalGenericTypeIndex (TypeI -> TypeId)
	       GenerateCooLName (TypeId)
	  |]
	  GenerateBaseTypeExtension (ParameterType)

-- GenerateGenParameterList ---------------------------------------------------

'action' GenerateGenParameterList (FPARAMLIST)

     'rule' GenerateGenParameterList (fparamlist (Param, nil))
	  GenerateGenParameter (Param)

     'rule' GenerateGenParameterList (fparamlist (Param, List))
	  GenerateGenParameter (Param)
	  Write (", ")
	  GenerateGenParameterList (List)

     'rule' GenerateGenParameterList (nil)

-- GenerateGenParameter ------------------------------------------------------

'action' GenerateGenParameter (FPARAM)

     'rule' GenerateGenParameter (FParam)
	  (|
	       where (FParam -> unconstrained (_, Id))
	  ||
	       where (FParam -> constrained( _, Id, _))
	  |)
	  GenerateHiddenName ("TYPENAME")
	  Write (" ")
	  GenerateCooLName (Id)

-- GenerateNEWParameterList --------------------------------------------------

'action' GenerateNEWParameterList (GenParams : FPARAMLIST, 
				   ObjParams : FPARAMLIST)

     'rule' GenerateNEWParameterList (nil, nil) :
	  Write ("void")
     
     'rule' GenerateNEWParameterList (nil, ObjParams) :
	  GenerateParameterList (ObjParams)
     
     'rule' GenerateNEWParameterList (GenParams, nil) :
	  GenerateGenParameterList (GenParams)
     
     'rule' GenerateNEWParameterList (GenParams, ObjParams) :
	  GenerateGenParameterList (GenParams)
	  Write (", ")
	  GenerateParameterList (ObjParams)
