#!/bin/sh
#
# # Copyright (C) 1993,1994 by the author(s).
# 
# This software is published in the hope that it will be useful, but
# WITHOUT ANY WARRANTY for any part of this software to work correctly
# or as described in the manuals. See the CooL Public License for details.
#
# Permission is granted to use, copy, modify, or distribute any part of
# this software but only under the conditions described in the CooL
# Public License. A copy of this license is supposed to have been given
# to you along with CooL in a file named LICENSE. Among other
# things, this copyright notice and the Public License must be
# preserved on all copies.

#
# $__Header$
#

base=$1

trap "if [ ! -f Makefile ]; then mv $savename Makefile; fi; rm -f Makefile.new; exit 1" 1 2 13 15

# test if echo command interprets -n option
xxx=`echo -n`

if [ -z "$xxx" ]
  then
    echolead=-n
    echotrail=
  else
    echolead=
    echotrail="""\c"""
fi

echo
echo "Configure the $__lastrelease$ build/installation procedure ..."

# base path (BASE)

if [ -z "$base" ] # if path is not given as argument
  then
    base=`pwd`
    # check if the current directory is the CooL distribution root directory
    if [ ! -f configure.sh ]
      then
        echo "Where did you place the CooL distribution (root directory) ?"
        echo $echolead "[Default: $base] > " $echotrail
        read input
        if [ -n "$input" ]
          then
            base=$input
        fi
    fi
fi

grep CooL $base/Makefile > /dev/null 2>&1
retval=$?

while [ $retval -ne 0 ]
  do
    echo "This seems not to be the right directory."
    echo "Where did you place the $__lastrelease$ distribution (root directory)?"
    echo $echolead "[Default: $base] > " $echotrail
    read input
    base=$input
    grep CooL $base/Makefile > /dev/null 2>&1
    retval=$?
  done

# Operating System type (HOSTSYSTEM)

hostsystem=`grep HOSTSYSTEM $base/Makefile | head -1 | \
	sed -e 's/HOSTSYSTEM//' -e 's/[= ]//g' -e 's/s_//'`
echo
echo "Please enter the operating system type. Supported platforms are:"
echo "    svr_4 -- (SysV R4, Sinix 5.41, Solaris 2)"
echo "    for others see the README file."
echo $echolead "[Default: $hostsystem] > " $echotrail
read input
if [ -n "$input" ]
  then
    hostsystem=s_$input
  else
    hostsystem=s_$hostsystem
fi

# machine architecture (HOSTTYPE)

hosttype=`grep HOSTTYPE $base/Makefile | head -1 | \
	sed -e 's/HOSTTYPE//' -e 's/[= ]//g' -e 's/t_//'`
echo
echo "Please enter the machine type. Supported platforms are:"
echo "    i386 -- (Intel 386, Intel 486)"
echo "    mips -- (Mips R3000)"
echo "    for others see the README file."
echo $echolead "[Default: $hosttype] > " $echotrail
read input
if [ -n "$input" ]
  then
    hosttype=t_$input
  else
    hosttype=t_$hosttype
fi

# object file format (OFILEFMT)

ofilefmt=`grep OFILEFMT $base/Makefile | head -1 | \
	sed -e 's/OFILEFMT//' -e 's/[= ]//g' -e 's/o_//'`
echo
echo "Please enter the object file format. Supported file formats are:"
echo "    coff -- (Coff)"
echo "    elf  -- "
echo "    for others see the README file."
echo $echolead "[Default: $ofilefmt] > " $echotrail
read input
if [ -n "$input" ]
  then
    ofilefmt=o_$input
  else
    ofilefmt=o_$ofilefmt
fi

# c-compiler (CCOMP)

ccomp=`grep CCOMP $base/Makefile | head -1 | \
	sed -e 's/CCOMP//' -e 's/[= ]//g' -e 's/c_//'`
echo
echo "Please enter the c compiler. Supported c compilers are:"
echo "    gnu -- (GNU CC)"
echo "    att -- (AT&T C Compiler)"
echo "    for others see the README file."
echo $echolead "[Default: $ccomp] > " $echotrail
read input
if [ -n "$input" ]
  then
    ccomp=c_$input
  else
    ccomp=c_$ccomp
fi

# Compiler-Generator tools and flags (LEX, YACC, LFLAGS, YFLAGS)

lex=`grep "LEX ="  $base/Makefile | head -1 | sed -e 's/LEX//' -e 's/[= ]//g' -e 's/=//'`
yacc=`grep "YACC ="  $base/Makefile | head -1 | sed -e 's/YACC//' -e 's/[= ]//g' -e 's/=//'`
makelflags=`grep MAKELFLAGS $base/Makefile | head -1 | sed -e 's/MAKELFLAGS//' -e 's/[ ]*=[ ]*//'`
makeyflags=`grep MAKEYFLAGS $base/Makefile | head -1 | sed -e 's/MAKEYFLAGS//' -e 's/[ ]*=[ ]*//'`

echo
echo "Please enter the lex executable."
echo $echolead "LEX     = [Default: $lex] " $echotrail
read input
if [ -n "$input" ]
then
   lex=$input
fi

echo
echo "Please enter the lex flags."
echo $echolead "LFLAGS  = [Default: $makelflags] " $echotrail
read input
if [ -n "$input" ]
then
   makelflags=$input
fi

echo
echo "Please enter the yacc executable."
echo $echolead "YACC    = [Default: $yacc] " $echotrail
read input
if [ -n "$input" ]
then
   yacc=$input
fi

echo
echo "Please enter the yacc flags."
echo $echolead "YFLAGS  = [Default: $makeyflags] " $echotrail
read input
if [ -n "$input" ]
then
   makeyflags=$input
fi

# Compiler tools and flags (CC, CPP, MAKECFLAGS, MAKELDFLAGS, SYSLIBS, RANLIB)

cc=`grep "^CC ="  $base/Makefile | head -1 | sed -e 's/CC//' -e 's/[= ]//g' -e 's/=//'`
cpp=`grep "CPP ="  $base/Makefile | head -1 | sed -e 's/CPP//' -e 's/[= ]//g' -e 's/=//'`
makecflags=`grep MAKECFLAGS $base/Makefile | head -1 | sed -e 's/MAKECFLAGS//' -e 's/[ ]*=[ ]*//'`
makeldflags=`grep MAKELDFLAGS $base/Makefile | head -1 | sed -e 's/MAKELDFLAGS//' -e 's/[ ]*=[ ]*//'`
syslibs=`grep SYSLIBS $base/Makefile | head -1 | sed -e 's/SYSLIBS//' -e 's/[ ]*=[ ]*//'`
ranlib=`grep RANLIB $base/Makefile | head -1 | sed -e 's/RANLIB//' -e 's/[ ]*=[ ]*//'`

case $hostsystem in
  s_aix)     makecflags="$makecflags -D_POSIX_SOURCE"
	     ;;
  s_hpux)    makecflags="$makecflags -Aa -D_HPUX_SOURCE"
	     ;;
esac

echo
echo "Please enter the cpp executable."
echo $echolead "CPP     = [Default: $cpp] " $echotrail
read input
if [ -n "$input" ]
then
   cpp=$input
fi

echo
echo "Please enter the cc executable."
echo $echolead "CC      = [Default: $cc] " $echotrail
read input
if [ -n "$input" ]
then
   cc=$input
fi

echo
echo "Please enter the cc flags."
echo $echolead "CFLAGS  = [Default: $makecflags] " $echotrail
read input
if [ -n "$input" ]
then
   makecflags=$input
fi

echo
echo "Please enter the ld flags."
echo $echolead "LDFLAGS = [Default: $makeldflags] " $echotrail
read input
if [ -n "$input" ]
then
   makeldflags=$input
fi

echo
echo "Please enter the system libraries."
echo $echolead "SYSLIBS  = [Default: $syslibs] " $echotrail	
read input
if [ -n "$input" ]
then
   syslibs=$input
fi

echo
echo "Please enter the ranlib executable (if not neccessary then take touch)."
echo $echolead "RANLIB  = [Default: $ranlib] " $echotrail
read input
if [ -n "$input" ]
then
   ranlib=$input
fi

# case $hostsystem in
#   s_aix)     syslibs="-lPW"
#	     ;;
#   s_hpux)    syslibs="-lPW"
# 	     ;;
#   s_irix)    syslibs="-lsun"
#	     ;;
#   s_svr_4)   syslibs="-lnsl -lgen"
# 	     ;;
#   *)	     syslibs=""
#	     ;;
# esac

# Determine subsystems to be included (SUBSYTEMS)

# subsystems=`grep SUBSYSTEMS $base/Makefile | head -1 | \
#	sed -e 's/SUBSYSTEMS//' -e 's/=//'`

# doemacslisp=`grep DOEMACSLISP $base/Makefile | head -1 | \
#	sed -e 's/DOEMACSLISP//' -e 's/[\= ]//g'`
# echo
# echo "Do you use 'GNU-emacs' on your machine ?  Do you want the"
# echo "CooL mode emacs lisp code to be compiled and installed too ?"
# echo $echolead "[Default: $doemacslisp] > " $echotrail
# read input

# if [ "$input" = "no" -o "$input" = "n" ]
#   then
#     doemacslisp=no
# fi
# if [ "$input" = "yes" -o "$input" = "y" ]
#   then
#     doemacslisp=yes
# fi
# if [ "$doemacslisp" = "yes" ]
#   then
#     subsystems="$subsystems ????"
# fi

# Installation base (INSTALLBASE)

installbase=`grep INSTALLBASE $base/Makefile | head -1 | \
	sed -e 's/INSTALLBASE//' -e 's/[\= ]//g'`

echo
echo "Where shall $__lastrelease$ be installed ?"
echo "Please specify the installation base directory."
echo $echolead "[Default: $installbase] > " $echotrail
read input
if [ -n "$input" ]
  then
    if [ "$input" = "." ]
      then
	input=$base
    fi
    installbase=$input
fi

# Installation paths (INSTALL*PATH)

installbinpath=`grep INSTALLBINPATH $base/Makefile | head -1 | \
	sed -e 's/INSTALLBINPATH//' -e 's/[\= ]//g' -e s,\$\(INSTALLBASE\),$installbase,`
installincpath=`grep INSTALLINCPATH $base/Makefile | head -1 | \
	sed -e 's/INSTALLINCPATH//' -e 's/[\= ]//g' -e s,\$\(INSTALLBASE\),$installbase,`
installlibpath=`grep INSTALLLIBPATH $base/Makefile | head -1 | \
	sed -e 's/INSTALLLIBPATH//' -e 's/[\= ]//g' -e s,\$\(INSTALLBASE\),$installbase,`
installemacslisppath=`grep INSTALLEMACSLISPPATH $base/Makefile | head -1 | \
	sed -e 's/INSTALLEMACSLISPPATH//' -e 's/[\= ]//g' -e s,\$\(INSTALLBASE\),$installbase,`
installemacsinfopath=`grep INSTALLEMACSINFOPATH $base/Makefile | head -1 | \
	sed -e 's/INSTALLEMACSINFOPATH//' -e 's/[\= ]//g' -e s,\$\(INSTALLBASE\),$installbase,`
installmanpath=`grep INSTALLMANPATH $base/Makefile | head -1 | \
	sed -e 's/INSTALLMANPATH//' -e 's/[\= ]//g' -e s,\$\(INSTALLBASE\),$installbase,`

echo
echo "Install"
if [ -d $installbinpath ]
  then
    echo "...executables     in $installbinpath"
  else
    echo "...executables     in $installbinpath (does not exist)"
    bindirmissing=true
fi
if [ -d $installincpath ]
  then
    echo "...header files    in $installincpath"
  else
    echo "...header files    in $installincpath (does not exist)"
    incdirmissing=true
fi
if [ -d $installlibpath ]
  then
    echo "...C-libraries     in $installlibpath"
  else
    echo "...C-libraries     in $installlibpath (does not exist)"
    libdirmissing=true
fi
if [ -d $installemacslisppath ]
  then
    echo "...emacs lisp code in $installemacslisppath"
  else
    echo "...emacs lisp code in $installemacslisppath (does not exist)"
    emacslispdirmissing=true
fi
if [ -d $installemacsinfopath ]
  then
    echo "...emacs info text in $installemacsinfopath"
  else
    echo "...emacs info text in $installemacsinfopath (does not exist)"
    emacsinfodirmissing=true
fi
if [ ! -d "$installmanpath/man1" ]
  then
    man1dirmissing=true
fi
if [ "$man1dirmissing" = "true" ] 
  then
    echo "...manuals         in $installmanpath/man1 (does not exist)"
  else
    echo "...manuals         in $installmanpath/man1"
fi
echo $echolead "Is this correct ? [Default: yes] > " $echotrail
read input
if [ "$input" = "no" -o "$input" = "n" ]
  then
    echo
    echo "Install executables in..."
    echo $echolead "[Default: $installbinpath] > " $echotrail
    read input
    if [ -n "$input" ]
      then
	installbinpath=$input
	specialbinpath=true
    fi
    echo
    echo "Install header files in..."
    echo $echolead "[Default: $installincpath] > " $echotrail
    read input
    if [ -n "$input" ]
      then
        installincpath=$input
	specialincpath=true
    fi
    echo
    echo "Install C-libraries in..."
    echo $echolead "[Default: $installlibpath] > " $echotrail
    read input
    if [ -n "$input" ]
      then
	installlibpath=$input
	speciallibpath=true
    fi
    echo
    echo "Install emacs lisp files in..."
    echo $echolead "[Default: $installemacslisppath] > " $echotrail
    read input
    if [ -n "$input" ]
      then
        installemacslisppath=$input
	specialemacslisppath=true
    fi
    echo
    echo "Install emacs info files in..."
    echo $echolead "[Default: $installemacsinfopath] > " $echotrail
    read input
    if [ -n "$input" ]
      then
        installemacsinfopath=$input
	specialemacsinfopath=true
    fi
    echo
    echo "Install manuals in... (You need man1 subdirectory there)"
    echo $echolead "[Default: $installmanpath] > " $echotrail
    read input
    if [ -n "$input" ]
      then
	installmanpath=$input
	specialmanpath=true
    fi
fi

# Create installation directories if necessary

echo
if [ "$bindirmissing" = "true" ] || [ "$specialbinpath" = "true" ] && [ ! -d $installbinpath ]
  then
    echo $echolead "'$installbinpath' does not exist. Create ? [Default: y] > " $echotrail
    read input
    if [ "$input" != "no" -a "$input" != "n" ]
      then
	mkdir -p $installbinpath
    fi
fi
if [ "$incdirmissing" = "true" ] || [ "$specialincpath" = "true" ] && [ ! -d $installincpath ]
  then
    echo $echolead "'$installincpath' does not exist. Create ? [Default: y] > " $echotrail
    read input
    if [ "$input" != "no" -a "$input" != "n" ]
      then
	mkdir -p $installincpath
    fi
fi
if [ "$libdirmissing" = "true" ] || [ "$speciallibpath" = "true" ] && [ ! -d $installlibpath ]
  then
    echo $echolead "'$installlibpath' does not exist. Create ? [Default: y] > " $echotrail
    read input
    if [ "$input" != "no" -a "$input" != "n" ]
      then
	mkdir -p $installlibpath
    fi
fi
if [ "$emacslispdirmissing" = "true" ] || [ "$specialemacslisppath" = "true" ] && [ ! -d $installemacslisppath ]
  then
    echo $echolead "'$installemacslisppath' does not exist. Create ? [Default: y] > " $echotrail
    read input
    if [ "$input" != "no" -a "$input" != "n" ]
      then
	mkdir -p $installemacslisppath
    fi
fi
if [ "$emacsinfodirmissing" = "true" ] || [ "$specialemacsinfopath" = "true" ] && [ ! -d $installemacsinfopath ]
  then
    echo $echolead "'$installemacsinfopath' does not exist. Create ? [Default: y] > " $echotrail
    read input
    if [ "$input" != "no" -a "$input" != "n" ]
      then
	mkdir -p $installemacsinfopath
    fi
fi
if [ "$man1dirmissing" = "true" ] || [ "$specialmanpath" = "true" ] && [ ! -d $installmanpath/man1 ]
  then
    echo $echolead "'$installmanpath/man1' does not exist. Create ? [Default: y] > " $echotrail
    read input
    if [ "$input" != "no" -a "$input" != "n" ]
      then
	mkdir -p $installmanpath/man1
    fi
fi

awk "{  if ((\$1 == \"BASE\" && \$2 == \"=\") || \$1 == \"BASE=\")
	  print \"BASE = $base\"
	else if ((\$1 == \"HOSTSYSTEM\" && \$2 == \"=\") || \$1 == \"HOSTSYSTEM=\")
	  print \"HOSTSYSTEM = $hostsystem\"
	else if ((\$1 == \"HOSTTYPE\" && \$2 == \"=\") || \$1 == \"HOSTTYPE=\")
	  print \"HOSTTYPE = $hosttype\"
	else if ((\$1 == \"OFILEFMT\" && \$2 == \"=\") || \$1 == \"OFILEFMT=\")
	  print \"OFILEFMT = $ofilefmt\"
	else if ((\$1 == \"CCOMP\" && \$2 == \"=\") || \$1 == \"CCOMP=\")
	  print \"CCOMP = $ccomp\"
	else if ((\$1 == \"LEX\" && \$2 == \"=\") || \$1 == \"LEX=\")
	  print \"LEX = $lex\"
	else if ((\$1 == \"MAKELFLAGS\" && \$2 == \"=\") || \$1 == \"MAKELFLAGS=\")
	  print \"MAKELFLAGS = $makelflags\"
	else if ((\$1 == \"YACC\" && \$2 == \"=\") || \$1 == \"YACC=\")
	  print \"YACC = $yacc\"
	else if ((\$1 == \"MAKEYFLAGS\" && \$2 == \"=\") || \$1 == \"MAKEYFLAGS=\")
	  print \"MAKEYFLAGS = $makeyflags\"
	else if ((\$1 == \"CPP\" && \$2 == \"=\") || \$1 == \"CPP=\")
	  print \"CPP = $cpp\"
	else if ((\$1 == \"CC\" && \$2 == \"=\") || \$1 == \"CC=\")
	  print \"CC = $cc\"
	else if ((\$1 == \"MAKECFLAGS\" && \$2 == \"=\") || \$1 == \"MAKECFLAGS=\")
	  print \"MAKECFLAGS = $makecflags\"
	else if ((\$1 == \"MAKELDFLAGS\" && \$2 == \"=\") || \$1 == \"MAKELDFLAGS=\")
	  print \"MAKELDFLAGS = $makeldflags\"
	else if ((\$1 == \"SYSLIBS\" && \$2 == \"=\") || \$1 == \"SYSLIBS=\")
	  print \"SYSLIBS = $syslibs\"
	else if ((\$1 == \"RANLIB\" && \$2 == \"=\") || \$1 == \"RANLIB=\")
	  print \"RANLIB = $ranlib\"
	else if ((\$1 == \"INSTALLBASE\" && \$2 == \"=\") || \$1 == \"INSTALLBASE=\")
	  print \"INSTALLBASE = $installbase\"
	else print }" Makefile > Makefile.new

if [ "$specialbinpath" = "true" ]
  then
    awk "{  if ((\$1 == \"INSTALLBINPATH\" && \$2 == \"=\") || \$1 == \"INSTALLBINPATH=\")
		print \"INSTALLBINPATH = $installbinpath\"
	    else print }" Makefile.new > Makefile.tmp
    mv Makefile.tmp Makefile.new
fi
if [ "$specialincpath" = "true" ]
  then
    awk "{  if ((\$1 == \"INSTALLINCPATH\" && \$2 == \"=\") || \$1 == \"INSTALLINCPATH=\")
		print \"INSTALLINCPATH = $installincpath\"
	    else print }" Makefile.new > Makefile.tmp
    mv Makefile.tmp Makefile.new
fi
if [ "$speciallibpath" = "true" ]
  then
    awk "{  if ((\$1 == \"INSTALLLIBPATH\" && \$2 == \"=\") || \$1 == \"INSTALLLIBPATH=\")
		print \"INSTALLLIBPATH = $installlibpath\"
	    else print }" Makefile.new > Makefile.tmp
    mv Makefile.tmp Makefile.new
fi
if [ "$specialemacslisppath" = "true" ]
  then
    awk "{  if ((\$1 == \"INSTALLEMACSLISPPATH\" && \$2 == \"=\") || \$1 == \"INSTALLEMACSLISPPATH=\")
		print \"INSTALLEMACSLISPPATH = $installemacslisppath\"
	    else print }" Makefile.new > Makefile.tmp
    mv Makefile.tmp Makefile.new
fi
if [ "$specialemacsinfopath" = "true" ]
  then
    awk "{  if ((\$1 == \"INSTALLEMACSINFOPATH\" && \$2 == \"=\") || \$1 == \"INSTALLEMACSINFOPATH=\")
		print \"INSTALLEMACSINFOPATH = $installemacsinfopath\"
	    else print }" Makefile.new > Makefile.tmp
    mv Makefile.tmp Makefile.new
fi
if [ "$specialmanpath" = "true" ]
  then
    awk "{  if ((\$1 == \"INSTALLMANPATH\" && \$2 == \"=\") || \$1 == \"INSTALLMANPATH=\")
		print \"INSTALLMANPATH = $installmanpath\"
	    else print }" Makefile.new > Makefile.tmp
    mv Makefile.tmp Makefile.new
fi

savename=Makefile.orig
echo
echo "Saving original Makefile to $savename."
mv Makefile $savename
mv Makefile.new Makefile

touch .configured
exit 0
