(*
-------------------------------------------------------------------------------
-- Name of the source		: timeProcs.t
-- Author(s)			: Jose Luis Albero
-- Date of creation		: 21 Apr 1993
-- Defined Objects		: 
-- Description of the contents	: Definition of auxiliar procedures used in time
--                                representation.
-- Document reference		: 
-- Copyright 1993, TAO S.A., Barcelona, Spain
-- This software was produced as part of the ESPRIT project ITHACA-IT.
-------------------------------------------------------------------------------
-- Modification log	:
-- Version	Date	Author	Description
-- ------------ ------- ------- -----------------------------------------------
-------------------------------------------------------------------------------
*)

SPECIFICATION timeProcs

(*
-------------------------------------------------------------------------------
--     PROCEDUREs defined in this file:

PROCEDURE IntervalToString (IN inInterv : Interval) : STRING;
  -- returns a string to display the interval.

PROCEDURE TimeIntervalToString (IN inTI : TimeInterval) : STRING;
  -- returns a string to display the time interval.

PROCEDURE MonthDayToString (IN inMD : MonthyDay) : STRING;
  -- returns a string to display the MonthDay object.

PROCEDURE StringToDate (IN inDateFmtNb : INT, -- date format
                        IN inStr : STRING) : Date;
 -- returns the a date object with the input date string.

PROCEDURE StringToTime (IN inTimeFmtNb : INT, -- time format
                        IN inStr : STRING) : Time;
  -- returns the a time object with the input time string.

PROCEDURE StringToTimeStamp (IN inDateFmtNb : INT, -- date format
                             IN inTimeFmtNb : INT, -- time format
                             IN inStr : STRING) : TimeStamp;
  -- returns the a TimeStamp object with the input date and time string.

PROCEDURE ChangeDefaultDate (IN inDateFmt : INT);
  -- changes the default date format used to display date objects.

PROCEDURE ChangeDefaultTime (IN inTimeFmt : INT);
  -- changes the default time format used to display time objects.

PROCEDURE ChangeLocaleTime (IN inLanguage : INT);
  -- changes the locale definitions. It is used to determine the lenguage
  -- used to display date and time.
-------------------------------------------------------------------------------
*)

IMPORT DateRepr FROM DateRepr;     --DateRepr object
IMPORT TimeRepr FROM TimeRepr;     --TimeRepr object
IMPORT TimeStampRepr FROM TimeStRepr; --TimeStampRep object
IMPORT Interval FROM Interval;     --Interval object
IMPORT TimeInterval FROM TimeInterval; --TimeInterval object
IMPORT Stream FROM Stream;
IMPORT MonthDay FROM MonthDay;
IMPORT Time FROM Time;
IMPORT Date FROM Date;
IMPORT TimeStamp FROM TimeSt;

-------------------------------------------------------------------------------
--Globals declaration
-------------------------------------------------------------------------------
  VAR gvCalendarTypeName     : STRING;
  VAR gvDateTypeName         : STRING;
  VAR gvDateReprTypeName     : STRING;
  VAR gvTimeStampTypeName    : STRING;
  VAR gvTimeStampRepTypeName : STRING;
  VAR gvIntervalTypeName     : STRING;
  VAR gvTimeIntervalTypeName : STRING;
  VAR gvMonthDayTypeName     : STRING;
  VAR gvTimeTypeName         : STRING;
  VAR gvTimeReprTypeName     : STRING;

-------------------------------------------------------------------------------
PROCEDURE IntervalToString (IN inInterv : Interval) : STRING;

PROCEDURE TimeIntervalToString (IN inTI : TimeInterval) : STRING;

PROCEDURE MonthDayToString (IN inMD : MonthDay) : STRING;

PROCEDURE StringToDate (IN inDateFmtNb : INT, -- date format
                        IN inStr : STRING) : Date;

PROCEDURE StringToTime (IN inTimeFmtNb : INT, -- time format
                        IN inStr : STRING) : Time;

PROCEDURE StringToTimeStamp (IN inDateFmtNb : INT, -- date format
                             IN inTimeFmtNb : INT, -- time format
                             IN inStr : STRING) : TimeStamp;

PROCEDURE ChangeDefaultDate (IN inDateFmt : INT);

PROCEDURE ChangeDefaultTime (IN inTimeFmt : INT);

PROCEDURE ChangeLocaleTime (IN inLanguage : INT);


-------------------------------------------------------------
--De/Serialization functions
-------------------------------------------------------------

PROCEDURE DeserializeDate (IN inStream : Stream) : Date;

PROCEDURE DeserializeDateRepr (IN inStream : Stream) : DateRepr;

PROCEDURE DeserializeTimeStamp (IN inStream : Stream) : TimeStamp;

PROCEDURE DeserializeTimeStampRepr (IN inStream : Stream) : TimeStampRepr;

PROCEDURE DeserializeInterval (IN inStream : Stream) : Interval;

PROCEDURE DeserializeTimeInterval (IN inStream : Stream) : TimeInterval;

PROCEDURE DeserializeMonthDay (IN inStream : Stream) : MonthDay;

PROCEDURE DeserializeTime (IN inStream : Stream) : Time;

PROCEDURE DeserializeTimeRepr (IN inStream : Stream) : TimeRepr;

PROCEDURE LoadTimeTypeStrings ();
 
END SPECIFICATION;
