(*
-------------------------------------------------------------------------------
-- Name of the source		: timeDefs.t
-- Author(s)			: Jose Luis Albero
-- Date of creation		: 21 Apr 1993
-- Defined Objects		: 
-- Description of the contents	: Type definitions for time representation
--                                2-04-1991 - Records ddmm_rec and ddmmyy_rec
--                                were added
--                                17-03-1993 -- New EXCEPTION added to the time
--                                representation model
-- Document reference		: 
-- Copyright 1993, TAO S.A., Barcelona, Spain
-- This software was produced as part of the ESPRIT project ITHACA-IT.
-------------------------------------------------------------------------------
-- Modification log	:
-- Version	Date	Author	Description
-- ----------- -------- ------- -----------------------------------------------
--             21/04/93 JLA     New exceptions have been added. Some time
--                              formats have been removed. CoLibri STRING type
--                              is used for the string management. Two tables
--                              with date formats and time formats for the date
--                              and time presentation (using strftime function)
--                              have been created.
-------------------------------------------------------------------------------
*)

SPECIFICATION timeDefs 

----------------------------------------------------------------------
--           TIME REPRESENTATION
-- Date Formats:
--   SHORT: Sun  12 Nov 90
--   LONG: fixed length long date,time or date and time
--   FREE: Sunday ,12th of November 1990
--   NUMSHRT: 11/12/90
--   NUMLONG: 11/12/1990
--   ISO: 19901211
--   ISOS1: 1990-12-11
--   ISOS2: 1990 12 11
--   ISOU: 19901212Z
--   ISOSU: 1990-12-11Z
--   SCALHEAD: 12/90(For Calendar heading)
--   LCALHEAD: December 1990(For Calendar heading)
--   DEFAULT: station default or user default(NUMSHRT)

-- Time Formats:
--     universaltime ::= localtime  OR UNIVERSALTIMEINDICATOR
--     UNIVERSALTIMEINDICATOR ::= "Z" | "z"
--     DECIMAL ::= "'" OR "."
--     example time : 14 hours 12 minutes 36 seconds
--   ISO1: h= hour     - 14
--   ISO2: hs= hour     - 14
--   ISO5: h&m= hour minute     - 1412
--   ISO6: h&ms= hour SEPARATOR minute     - 14:12
--   ISO9: h&m&s= hour minute second     - 141236
--   ISO10: h&m&ss= hour SEPARATOR minute SEPARATOR second     - 14:12:36
--                    - 14:12:36.0
--   DEFAULT: ISO10

-- 141236,0Z	141236,0z
-- 14Z		14z
----------------------------------------------------------------------

----------------------------------------------------------------------
-- Constants to enumerate different languages
----------------------------------------------------------------------

CONST LG_FRENCH : INT = 1;
CONST LG_ENGLISH : INT = 2;
CONST LG_AMERICAN : INT = 3;

----------------------------------------------------------------------
-- Constants to enumerate date formats
----------------------------------------------------------------------

CONST FT_SHORTNAMES : INT = 1;
CONST FT_LONGNAMES : INT = 2;
CONST FT_FREE : INT = 3;
CONST FT_NUMSHRT : INT = 4;
CONST FT_NUMSHRT_AMER : INT = 5;
CONST FT_NUMLONG : INT = 6;
CONST FT_NUMLONG_AMER : INT = 7;
CONST FT_ISO : INT = 8;
CONST FT_ISOS1 : INT = 9;
CONST FT_ISOS2 : INT = 10;
CONST FT_ISOU : INT = 11;
CONST FT_ISOSU : INT = 12;
CONST FT_SCALHEAD : INT = 13;
CONST FT_LCALHEAD : INT = 14;

----------------------------------------------------------------------
-- Constants to enumerate time formats
----------------------------------------------------------------------

CONST FT_ISO1 : INT = 1;
CONST FT_ISO2 : INT = 2;
CONST FT_ISO5 : INT = 3;
CONST FT_ISO6 : INT = 4;
CONST FT_ISO9 : INT = 5;
CONST FT_ISO10 : INT = 6;

---------------------------------------------------------------------
-- Error codes that are raised by the Time and Time-related objects
---------------------------------------------------------------------

EXCEPTION InvalidEnumValue;
EXCEPTION NegativeTimeInterval;
EXCEPTION InvalidMonthDay;
EXCEPTION NotInstanciableType;
EXCEPTION NilObject;
EXCEPTION NotComparableDurations;
EXCEPTION NotNaturalDuration;
EXCEPTION NotWorkingDuration;
EXCEPTION NotEqualCalendars;
EXCEPTION MaxArraySizeExceded;
EXCEPTION NilInterval;
EXCEPTION NilCalendar;
EXCEPTION InvalidDateFormat;
EXCEPTION InvalidTimeFormat;

----------------------------------------------------------------------
-- Global variables to determine the default language to display all
-- messages and the default date and time display formats
----------------------------------------------------------------------

VAR gvDefaultLanguage : INT;
VAR gvDefaultDate : INT;
VAR gvDefaultTime : INT;

----------------------------------------------------------------------
-- Global arrays with all date and time formats definitions used by
-- strftime function. There are also associated other arrays to
-- display each format
----------------------------------------------------------------------

VAR gvDateFormats : ARRAY [16] OF STRING;
VAR gvTimeFormats : ARRAY [20] OF STRING;
VAR gvDateFmtsInf : ARRAY [16] OF STRING;
VAR gvTimeFmtsInf : ARRAY [20] OF STRING;

----------------------------------------------------------------------
-- Procedures to initialize the former arrays
----------------------------------------------------------------------

PROCEDURE initDateFormats ();


PROCEDURE initTimeFormats ();


END SPECIFICATION;
