/* HEADER */
/* @(#) bcd.h 4.1.1.2 */
/* @(#)Description: C-Programme und Include-Dateien */
/* @(#)Author: xsde */
/* @(#)Location: PB01 */
/* @(#)Type: cprog */
/* @(#)Created with X/SDE-REL:  */
/* @(#)Date, time modify: 93/03/19, 11:03:07 */
/* @(#)Date, time return: 92/08/25, 08:13:20 */
/* Copyright: @(#) X/SDE-BCD V3.1A90 19930319 */
/* Copyright: @(#) Siemens Nixdorf Informationssysteme AG, 1993 */
/* END HEADER */
/****************************************************************************/
/**                                                                        **/
/**     BCD-Arithmetic for X/SDE     copyrigth (C) by SIEMENS/NIXDORF      **/
/**                                                                        **/
/****************************************************************************/
/**                                                                        **/
/**     File name: bcd.h                                                   **/
/**                                                                        **/
/**     Date     : 05.04.1991                                              **/
/**                                                                        **/
/**     Release  : 1.0.0                                                   **/
/**                                                                        **/
/****************************************************************************/


#ifndef BCD_H
#define BCD_H
			/**********************************/
			/* Error and Warning Status codes */
			/**********************************/
#define B_OK                        0
#define B_OVERFLOW_ERROR           -1
#define B_UNDERFLOW_ERROR          -2
#define B_FIRST_OPERAND_ERROR      -3
#define B_ZERO_DIVIDE_ERROR        -4
#define B_LEADING_DIGITS_ERROR     -5

#define B_TRAILING_DIGITS_WARNING   1


			/***********************************/
			/* Variable/type/macro definitions */
			/***********************************/

extern int b_status;           /* global status variable, for error returns */
			       /*  0: Operation succesfull                  */
			       /* >0: Warning, result valid                 */
			       /* <0: Error, result unvalid                 */

#define B_TRUE 1
#define B_FALSE 0

#define B_DIGITS 18

#define NWORD 5                /* number of words needed    */
#define NBYTE 10               /* number of bytes needed    */


			/****************************/
			/* BCD Structure definition */
			/****************************/
union bcd {
	   struct word_def {
		   char sign;
#ifdef m_i386
		   signed char chart;
#else
		   char chart;
#endif
		   unsigned short word[NWORD];
		   } mant;

	   struct b_byte_def {
		   char sign;
#ifdef m_i386
		   signed char chart;
#else
		   char chart;
#endif
		   unsigned char dig[NBYTE];
		   } b_byte;
    };

typedef union bcd BCD ;


		      /******************************************/
		      /* external declarations of all functions */
		      /******************************************/
BCD   *b_ldfloat();
BCD   *b_lddouble();
BCD   *b_ldshort();
BCD   *b_ldint();
BCD   *b_ldlong();
BCD   *b_ldstring();
BCD   *b_ldddb4();

BCD    *b_ld_zero();
BCD    *b_ld_one();
BCD    *b_ld_neg_one();

float  b_stfloat();
double b_stdouble();
short  b_stshort();
int    b_stint();
long   b_stlong();
char  *b_ststring();
char  *b_ststring_long();
unsigned char *b_stddb4();

BCD   *b_add();
BCD   *b_sub();
BCD   *b_mul();
BCD   *b_div();
BCD   *b_idiv();
BCD   *b_mod();
BCD   *b_inc();
BCD   *b_dec();
BCD   *b_shift();
BCD   *b_max();
BCD   *b_min();
BCD   *b_abs();

int    b_lt();
int    b_le();
int    b_eq();
int    b_ne();
int    b_gt();
int    b_ge();
int    b_cmp();

int    b_isint();
int    b_isfract();
int    b_isnatural();
int    b_iszero();
int    b_iseven();
int    b_isodd();

int    b_sgn();
BCD   *b_stpos();
BCD   *b_stneg();
BCD   *b_inv();
BCD   *b_int();
BCD   *b_fract();

BCD   *b_floor();
BCD   *b_ceil();
BCD   *b_round();
BCD   *b_trunc();

#endif   /* BCD_H : to handle multiple includes  */
