/* HEADER */
/* @(#) bcd_cuti.c 4.1.1.2 */
/* @(#)Description: C-Programme und Include-Dateien */
/* @(#)Author: xsde */
/* @(#)Location: PB01 */
/* @(#)Type: cprog */
/* @(#)Created with X/SDE-REL:  */
/* @(#)Date, time modify: 93/03/19, 11:03:12 */
/* @(#)Date, time return: 92/08/25, 08:13:49 */
/* Copyright: @(#) X/SDE-BCD V3.1A90 19930319 */
/* Copyright: @(#) Siemens Nixdorf Informationssysteme AG, 1993 */
/* END HEADER */
/****************************************************************************/
/**                                                                        **/
/**     BCD-Arithmetic for X/SDE     copyright (C) by SIEMENS/NIXDORF      **/
/**                                                                        **/
/****************************************************************************/
/**                                                                        **/
/**     File name: bcd_cuti.c    (conversion and utilities)                **/
/**                                                                        **/
/**     Date     : 05.04.1991                                              **/
/**                                                                        **/
/**     Release  : 1.0.0                                                   **/
/**                                                                        **/
/**                                                                        **/
/****************************************************************************/
/****************************************************************************/
/**                                                                        **/
/**     Changes: include <stdio.h> eingefuegt  (noetig bei sparc )         **/
/**                                                                        **/
/**                                                                        **/
/****************************************************************************/


#include "bcd_def.h"
#include <stdio.h>
#include <limits.h>
#include <assert.h>


void b_init();

static BCD b_zero,b_one,b_infi,b_l_min, b_l_max,
	   b_l_minw, b_s_min, b_s_max,
	   b_s_minw, b_i_min, b_i_max,
	   b_i_minw, b_n_one ;

static int is_init_done = B_FALSE;          /* flag initialization is done  */

static UCHAR ddb4_buffer[NBYTE];


/***************************************************************************/
/*                                                                         */
/*      b_ld_zero;  set BCD-variable to zero                               */
/*                                                                         */
/*      input:  *px  =   b_ld_zero(px)                                     */
/*                                                                         */
/*      output: (*px)                                                      */
/*                                                                         */
/***************************************************************************/

BCD *b_ld_zero(px)

register BCD *px;
{
   if (b_status < 0)                /* Error, can't continue */
   {
      return 0;
   }
   b_init();
   *px = b_zero;
   return (px);
}


/***************************************************************************/
/*                                                                         */
/*      b_ld_one ;  set BCD-variable to one                                */
/*                                                                         */
/*      input:  *px  =   b_ld_one (px)                                     */
/*                                                                         */
/*      output: (*px)                                                      */
/*                                                                         */
/***************************************************************************/

BCD *b_ld_one(px)

register BCD *px;
{
   if (b_status < 0)                /* Error, can't continue */
   {
      return 0;
   }
   b_init();
   b_status = B_OK;
   *px = b_one;
   return (px);
}


/***************************************************************************/
/*                                                                         */
/*      b_ld_neg_one ;  set BCD-variable to negativ one                    */
/*                                                                         */
/*      input:  *px  =   b_ld_neg_one (px)                                 */
/*                                                                         */
/*      output: (*px)                                                      */
/*                                                                         */
/***************************************************************************/

BCD *b_ld_neg_one(px)

register BCD *px;
{
   if (b_status < 0)                /* Error, can't continue */
   {
      return 0;
   }
   b_init();
   b_status = B_OK;
   *px = b_n_one;
   return (px);
}



/***************************************************************************/
/*                                                                         */
/*   b_stfloat  convert bcd to c-type float                                */
/*                                                                         */
/*      input:                                                             */
/*              BCD *b_op;                                                 */
/*              b_stfloat(b_op)                                            */
/*                                                                         */
/*      returns:                                                           */
/*              b_op in c-type float                                       */
/*                                                                         */
/***************************************************************************/
float b_stfloat(b_op)

BCD *b_op;
{
   int i,j ;
   double precexp,d;

   if (b_status < 0) /* Error, can't continue */
   {
      return 0;
   }
   b_init();

   d = 0.0 ;
   j = (*b_op).mant.chart ;

   for (precexp = 10.,i=1-(*b_op).mant.chart;i-- >1;precexp *= 10.) ;

   for (i=0;i < HPREC  ;i++)
   {
      if (j>0)                /* integer part    */
      {
	 d = d * 10. + GETDIG(*b_op,i);
	 j--;
      }
      else                    /* fractional part */
      {
	 d += GETDIG(*b_op,i)/precexp ;
	 precexp *= 10. ;
      }
   }
				   /* correct exponent */
   for (;j-- >0;d *= 10.) ;

   if (GETSIGN(*b_op) == NEGATIV)
   {
      d = (-d) ;
   }

   return(d);
}

/***************************************************************************/
/*                                                                         */
/*   b_ldfloat   convert binary floating point c-type float to BCD         */
/*                                                                         */
/*      input:                                                             */
/*              BCD *b_rs;                                                 */
/*              float  f_op                                                */
/*              *b_rs = b_ldfloat(b_rs,f_op);                              */
/*                                                                         */
/*      output:                                                            */
/*              *b_rs = f_op in BCD                                        */
/*                                                                         */
/*      returns:                                                           */
/*              B_OVERFLOW_ERROR                                           */
/*                                                                         */
/***************************************************************************/
BCD *b_ldfloat(b_rs,f_op)

BCD *b_rs;
float f_op;
{
   extern char *ecvt() ;
   char *ps ;
   int *sign,*chart,i,c ;

   if (b_status < 0) /* Error, can't continue */
   {
      return 0;
   }
   b_init();

   sign = &i ;
   chart = &c ;
   ps = ecvt( f_op,HPREC,chart,sign) ; /* ps = mant , chart = exponent */

   if (c < MIN_CHART)              /* Underflow */
   {
      *b_rs = b_zero;
   }
   else if ( c > MAX_CHART)        /* Overflow */
   {
      *b_rs = b_infi;
      (*b_rs).mant.sign = i ? NEGATIV : POSITIV;
      b_status = B_OVERFLOW_ERROR ;
   }
   else                            /* Throughflow */
   {
      *b_rs = b_zero;
      (*b_rs).mant.sign = i ? NEGATIV : POSITIV ;
      (*b_rs).mant.chart = c ;

      for (i = 0;i < HPREC;i++)
      {
	 PUTDIG((UCHAR)(*(ps++)-'0'),(*b_rs),i) ;
      }
   }

   return (b_rs);
}

/***************************************************************************/
/*                                                                         */
/*   b_stdouble convert bcd to binary floating point (double)              */
/*                                                                         */
/*      input:                                                             */
/*              BCD *b_op;                                                 */
/*              b_stdouble(b_op)                                           */
/*                                                                         */
/*      returns:                                                           */
/*              b_op in c-type double                                      */
/*                                                                         */
/***************************************************************************/
double b_stdouble(b_op)

BCD *b_op;
{
   int i,j ;
   double precexp,d;

   if (b_status < 0) /* Error, can't continue */
   {
      return 0;
   }
   b_init();

   d = 0.0 ;
   j = (*b_op).mant.chart ;

   for (precexp = 10.,i=1-(*b_op).mant.chart;i-- >1;precexp *= 10.) ;

   for (i=0;i < PREC  ;i++)
   {
      if (j>0)                /* integer part    */
      {
	 d = d * 10. + GETDIG(*b_op,i);
	 j--;
      }
      else                    /* fractional part */
      {
	 d += GETDIG(*b_op,i)/precexp ;
	 precexp *= 10. ;
      }
   }
				   /* correct exponent */
   for (;j-- >0;d *= 10.) ;

   if (GETSIGN(*b_op) == NEGATIV)
   {
      d = (-d) ;
   }

   return(d);
}

/***************************************************************************/
/*                                                                         */
/*   b_lddouble  convert binary floating point double to BCD               */
/*                                                                         */
/*      input:                                                             */
/*              BCD *b_rs;                                                 */
/*              double d_op;                                               */
/*              *b_rs = b_lddouble(b_rs,d_op);                             */
/*                                                                         */
/*      output:                                                            */
/*              *b_rs = d_op in BCD                                        */
/*                                                                         */
/*      returns:                                                           */
/*              B_OVERFLOW_ERROR                                           */
/*                                                                         */
/***************************************************************************/
BCD *b_lddouble(b_rs,d_op)

BCD *b_rs;
double d_op;
{
   extern char *ecvt() ;
   char *ps ;
   int *sign,*chart,i,c ;

   if (b_status < 0) /* Error, can't continue */
   {
      return 0;
   }
   b_init();

   sign = &i ;
   chart = &c ;
   ps = ecvt( d_op,PREC,chart,sign) ; /* ps = mant , chart = exponent */

   if (c < MIN_CHART)              /* Underflow */
   {
      *b_rs = b_zero;
   }
   else if ( c > MAX_CHART)        /* Overflow */
   {
      *b_rs = b_infi;
      (*b_rs).mant.sign = i ? NEGATIV : POSITIV;
      b_status = B_OVERFLOW_ERROR ;
   }
   else                            /* Throughflow */
   {
      *b_rs = b_zero;
      (*b_rs).mant.sign = i ? NEGATIV : POSITIV ;
      (*b_rs).mant.chart = c ;

      for (i = 0;i < PREC;i++)
      {
	 PUTDIG((UCHAR)(*(ps++)-'0'),(*b_rs),i) ;
      }
   }

   return (b_rs);
}

/***************************************************************************/
/*                                                                         */
/*  b_stshort convert bcd to integer short (-32768 <= x <= 32767)          */
/*                                                                         */
/*      input:                                                             */
/*              BCD *b_op;                                                 */
/*              b_stshort(b_op);                                           */
/*                                                                         */
/*      returns:                                                           */
/*              b_op in short                                              */
/*                                                                         */
/***************************************************************************/
short b_stshort(b_op)

BCD *b_op;
{
   int i,j ;
   short help ;
   BCD b_f,b_i;

   if (b_status < 0) /* Error, can't continue */
   {
      return 0;
   }
   b_init();

   if ((int)(*b_op).mant.chart <= FRACT_CHART)
   {
      if (b_cmp(&b_zero,b_op) != 0)  /* If this is zero, no warning */
      {
	 b_status = B_TRAILING_DIGITS_WARNING ;
      }

      return(0);                 /* integer part = 0 */
   }

   if ((b_cmp(b_op,&b_s_min) <= 0) ||  /* Too big to represent? */
	b_cmp(b_op,&b_s_max) > 0)
   {

      /* Check for the special case of SHRT_MIN */
      if ((b_cmp(b_op,&b_s_min) >= 0) &&       /* Special case of */
	  (b_cmp(b_op,&b_s_min) <= 0))    /*   -32768 ?      */
      {
	 return (-SHRT_MAX-1) ;
      }
      else
      {
	 b_status = B_OVERFLOW_ERROR ;
      }
   }
   else
   {
      /* Check for trailing digits lost (case of non-integer) */
      b_f = *b_op ;

      dec_brk(&b_f,&b_i);
      if (b_cmp(&b_f,&b_zero) != 0)  /* fraction part */
      {
	 b_status = B_TRAILING_DIGITS_WARNING ;
      }
   }

   j = (*b_op).mant.chart ;
   for (help = GETDIG((*b_op),0),i = 1;i < j;i++)
   {
      help = help * 10 + GETDIG((*b_op),i);
   }

   help = (*b_op).mant.sign == POSITIV?help:(-help);

   return(help);
}

/***************************************************************************/
/*                                                                         */
/*      b_ldshort convert short to BCD                                     */
/*                                                                         */
/*      input:                                                             */
/*              BCD *b_rs ;                                                */
/*              short s_op;                                                */
/*              *b_rs = b_ldlong(b_rs,s_op);                               */
/*                                                                         */
/*      output:                                                            */
/*              *b_rs = s_op in short                                      */
/*                                                                         */
/***************************************************************************/
BCD *b_ldshort(b_rs, s_op)

BCD *b_rs;
short s_op;
{
   if (b_status < 0)                            /* Error, can't continue */
   {
      return 0;
   }
   b_init();

   *b_rs = b_zero;
   if ( !s_op )                                 /* Check for zero case      */
   {
      return (b_rs);
   }

   if ( s_op < 0)
   {
      if (s_op == (-SHRT_MAX-1))                 /* Check for min_int case   */
      {
	 *b_rs = b_i_minw ;
	 return (b_rs);
      }
      (*b_rs).mant.sign = NEGATIV;                      /* set sign to '-'  */
      s_op = (-s_op);
   }
   else
   {
      (*b_rs).mant.sign = POSITIV;                      /* set sign to '+'  */
   }
   (*b_rs).mant.chart = i2mant((int)s_op, b_rs, 0);
   return(b_rs);
}



/***************************************************************************/
/*                                                                         */
/*  b_stint   convert bcd to c-type integer                                */
/*                                                                         */
/*      input:                                                             */
/*              BCD *b_op;                                                 */
/*              b_stint(b_op);                                             */
/*                                                                         */
/*      returns:                                                           */
/*              b_op in int                                                */
/*                                                                         */
/***************************************************************************/
int b_stint(b_op)

BCD *b_op;
{
   int i,j ;
   int help ;
   BCD b_f,b_i;

   if (b_status < 0) /* Error, can't continue */
   {
      return 0;
   }
   b_init();

   if ((int)(*b_op).mant.chart <= FRACT_CHART)
   {
      if (b_cmp(&b_zero,b_op) != 0)  /* If this is zero, no warning */
      {
	 b_status = B_TRAILING_DIGITS_WARNING ;
      }

      return(0);                 /* integer part = 0 */
   }

   if ((b_cmp(b_op,&b_i_min) <= 0) ||  /* Too big to represent? */
	b_cmp(b_op,&b_i_max) > 0)
   {

      /* Check for the special case of INT_MIN */
      if ((b_cmp(b_op,&b_i_min) >= 0) &&       /* Special case of */
	  (b_cmp(b_op,&b_i_minw) <= 0))    /*   -INT_MIN ?     */
      {
	 return (-INT_MAX-1) ;
      }
      else
      {
	 b_status = B_OVERFLOW_ERROR ;
      }
   }
   else
   {
      /* Check for trailing digits lost (case of non-integer) */
      b_f = *b_op ;

      dec_brk(&b_f,&b_i);
      if (b_cmp(&b_f,&b_zero) != 0)  /* fraction part */
      {
	 b_status = B_TRAILING_DIGITS_WARNING ;
      }
   }

   j = (*b_op).mant.chart ;
   for (help = GETDIG((*b_op),0),i = 1;i < j;i++)
   {
      help = help * 10 + GETDIG((*b_op),i);
   }

   help = (*b_op).mant.sign == POSITIV?help:(-help);

   return(help);
}

/***************************************************************************/
/*                                                                         */
/*      b_ldint convert c-type int to BCD                                  */
/*                                                                         */
/*      input:                                                             */
/*              BCD *b_rs ;                                                */
/*              int  i_op ;                                                */
/*              *b_rs = b_ldint(b_rs,i_op);                                */
/*                                                                         */
/*      output:                                                            */
/*              *b_rs = i_op as integer                                    */
/*                                                                         */
/***************************************************************************/
BCD *b_ldint(b_rs, i_op)

BCD *b_rs;
int i_op;
{
   if (b_status < 0)                            /* Error, can't continue */
   {
      return 0;
   }
   b_init();

   *b_rs = b_zero;
   if ( !i_op )                                 /* Check for zero case      */
   {
      return (b_rs);
   }

   if ( i_op < 0)
   {
      if (i_op == (-INT_MAX-1))                 /* Check for min_int case   */
      {
	 *b_rs = b_i_minw ;
	 return (b_rs);
      }
      (*b_rs).mant.sign = NEGATIV;                      /* set sign to '-'  */
      i_op = (-i_op);
   }
   else
   {
      (*b_rs).mant.sign = POSITIV;                      /* set sign to '+'  */
   }
   (*b_rs).mant.chart = i2mant(i_op, b_rs, 0);
   return(b_rs);
}


/***************************************************************************/
/*                                                                         */
/*  b_stlong  convert bcd to integer long                                  */
/*                                                                         */
/*      input:                                                             */
/*              BCD *b_op;                                                 */
/*              b_stlong(b_op);                                            */
/*                                                                         */
/*      returns:                                                           */
/*              b_op in long                                               */
/*                                                                         */
/***************************************************************************/
long b_stlong(b_op)

BCD *b_op;
{
   int i,j ;
   long help ;
   BCD b_f,b_i;

   if (b_status < 0) /* Error, can't continue */
   {
      return 0;
   }
   b_init();

   if ((int)(*b_op).mant.chart <= FRACT_CHART)
   {
      if (b_cmp(&b_zero,b_op) != 0)  /* If this is zero, no warning */
      {
	 b_status = B_TRAILING_DIGITS_WARNING ;
      }

      return(0);                 /* integer part = 0 */
   }

   if ((b_cmp(b_op,&b_l_min) <= 0) ||  /* Too big to represent? */
	b_cmp(b_op,&b_l_max) > 0)
   {

      /* Check for the special case of LONG_MIN  */
      if ((b_cmp(b_op,&b_l_min) >= 0) &&       /* Special case of */
	  (b_cmp(b_op,&b_l_minw) <= 0))    /*   -2147483648 ? */
      {
	 return (-LONG_MAX-1) ;
      }
      else
      {
	 b_status = B_OVERFLOW_ERROR ;
      }
   }
   else
   {
      /* Check for trailing digits lost (case of non-integer) */
      b_f = *b_op ;

      dec_brk(&b_f,&b_i);
      if (b_cmp(&b_f,&b_zero) != 0)  /* fraction part */
      {
	 b_status = B_TRAILING_DIGITS_WARNING ;
      }
   }

   j = (*b_op).mant.chart ;
   for (help = GETDIG((*b_op),0),i = 1;i < j;i++)
   {
      help = help * 10 + GETDIG((*b_op),i);
   }

   help = (*b_op).mant.sign == POSITIV?help:(-help);

   return(help);
}

/***************************************************************************/
/*                                                                         */
/*      b_ldlong convert long to BCD                                       */
/*                                                                         */
/*      input:                                                             */
/*              BCD *b_rs ;                                                */
/*              long l_op ;                                                */
/*              *b_rs = b_ldlong(b_rs,l_op);                               */
/*                                                                         */
/*      output:                                                            */
/*              *b_rs = l_op in long                                       */
/*                                                                         */
/***************************************************************************/
BCD *b_ldlong(b_rs, l_op)

BCD *b_rs;
long l_op;
{
   if (b_status < 0)                            /* Error, can't continue */
   {
      return 0;
   }
   b_init();

   *b_rs = b_zero;
   if ( !l_op )                                 /* Check for zero case      */
   {
      return (b_rs);
   }

   if ( l_op < 0)
   {
      if (l_op == (-LONG_MAX-1))                /* check for min_int case   */
      {
	 *b_rs = b_i_minw ;
	 return (b_rs);
      }
      (*b_rs).mant.sign = NEGATIV;                      /* set sign to '-'  */
      l_op = (-l_op);
   }
   else
   {
      (*b_rs).mant.sign = POSITIV;                      /* set sign to '+'  */
   }
   (*b_rs).mant.chart = l2mant(l_op, b_rs, 0);
   return(b_rs);
}



/***************************************************************************/
/*                                                                         */
/*      b_ldstring - convert ASCII to BCD                                  */
/*                                                                         */
/*      input:                                                             */
/*              BCD *b_rs;                                                 */
/*              char *s_op;                                                */
/*              *b_rs = b_ldstring(b_rs,s_op);                             */
/*                                                                         */
/*      output:                                                            */
/*              b_rs = bcd(s_op);                                          */
/*                                                                         */
/*      returns:                                                           */
/*              B_FIRST_OPERAND_ERROR                                      */
/*              B_OVERFLOW_ERROR                                           */
/*              B_UNDERFLOW_ERROR                                          */
/*                                                                         */
/***************************************************************************/
BCD *b_ldstring(b_rs,s_op)

BCD *b_rs ;
char *s_op;
{
   /* Local macro definitions */
#define ACIB(x)       { (x) = (UCHAR)*(++s_op);}

   short nrziff,nkomm;
   short nrdig,vorze;
   short zeroflag;
   short zerocount;
   short fullcount;
   int expo ;
   UCHAR ziff;
   UCHAR decpunkt = '.';
   char *cpt;

   if (b_status < 0) /* Error, can't continue */
   {
      return 0;
   }
   b_init();

   nrdig = 0;
   *b_rs = b_zero;

   while( (UCHAR)(*s_op) == (UCHAR)' ')  /* Blanks ueberlesen */
   {
      ++s_op;
   }

   if(((UCHAR)(*s_op) == (UCHAR)'-') ||
      ((UCHAR)(*s_op) == (UCHAR)'+'))
   {
      /* plus + minus uebergehen */
      if ((UCHAR)(*s_op++) == (UCHAR)'-')
      {
	 (*b_rs).mant.sign = NEGATIV ;
      }

      while( (UCHAR)(*s_op) == (UCHAR)' ') /* Blanks ueberlesen */
      {
	 ++s_op;
      }
   }

   /**** check for case of .000000000... ****/
   if ((UCHAR)(*s_op) == decpunkt)
   {
       /* Could be a zero */
       zeroflag = B_TRUE;

       /* Loop through input string, eliminate possibility of a .000... */
       cpt = s_op + 1;

       while ((*cpt) != 0)
       {
	  if ((UCHAR)(*cpt) != (UCHAR)'0')
	  {
	     zeroflag = B_FALSE; /* Non zero character is present */
	  }
	  cpt++;
       }
   }
   else
   {
       /* probably not zero */
       zeroflag = B_FALSE;
   }

   /**** ignore leading zeroes ****/
   ziff= *s_op ;
   while (ziff == (UCHAR)'0')
   {
      ACIB(ziff) ;
      nrdig = 1 ;
   }

   /**** Integer part ****/
   for(nrziff=0; ziff >= (UCHAR)'0' && ziff <= (UCHAR)'9' ;)
   {
      if (nrziff < (NBCD-2))  /* if more than 18 digits : ignore */
      {
	 PUTDIG((ziff-((UCHAR)'0')),*b_rs,nrziff) ;
      }
      else
      {
	 if (ziff != (UCHAR)'0') /* Set only if non-zero trails */
	 {
	    b_status = B_TRAILING_DIGITS_WARNING ; /* Set only if not zero */
	 }
      }

      nrziff++;
      if (ziff != (UCHAR)'0')
      {
	 nkomm = nrziff ;
      }
      ACIB(ziff) ;
   }
   (*b_rs).mant.chart = nrziff;

   /**** Fractional part ****/
   if (ziff == decpunkt)
   {
      ACIB(ziff) ;
      if (nrziff == 0)  /* correct chart for leading zeroes */
      {
	 while (ziff == (UCHAR)'0')
	 {
	    (*b_rs).mant.chart--;
	    ACIB(ziff) ;
	 }
      }

      for(;ziff >= (UCHAR)'0' && ziff <= (UCHAR)'9' ;)
      {
	 if (nrziff < (NBCD-2))       /* if more than 18 digits : ignore */
	 {
	    PUTDIG((ziff-((UCHAR)'0')),*b_rs,nrziff) ;
	 }
	 else
	 {
	    if (ziff != (UCHAR)'0') /* Set only if non-zero trails */
	    {
	       b_status = B_TRAILING_DIGITS_WARNING ;
	    }
	 }

	 nrziff++;
	 if (ziff != (UCHAR)'0')
	 {
	    nkomm = nrziff ;
	 }
	 ACIB(ziff) ;
      }
   }

   if (nrziff == 0)
   {
      (*b_rs).mant.sign = POSITIV ;
      if (nrdig == 0)
      {
	 if (zeroflag == B_FALSE) /* Set error only if not .0 at begin */
	 {
	    b_status = B_FIRST_OPERAND_ERROR;
	 }

	 *b_rs = b_zero ;
	 return(b_rs) ;  /* no digits in mantissa */
      }
   }

   /**** Exponent ****/
   if (ziff == (UCHAR)'e' || ziff == (UCHAR)'E')
   {
      ACIB(ziff) ;
      vorze = 1 ;

      if( ziff == (UCHAR)'-' || ziff == (UCHAR)'+')
      {
	 /* plus + minus uebergehen */
	 if (ziff == (UCHAR)'-')
	 {
	    vorze = -1 ;
	 }
	 ACIB(ziff) ;
      }

      for(expo = 0;ziff >= (UCHAR)'0' && ziff <= (UCHAR)'9' ;)
      {
	 expo = expo*10 +(ziff -(UCHAR)'0');  /* Ziffer fuer Exponent */

	 if (vorze*expo+(*b_rs).mant.chart > MAX_CHART)      /* overflow */
	 {
	    (*b_rs) = b_zero ;
	    b_status = B_OVERFLOW_ERROR ;
	    return(b_rs);
	 }
	 else if (vorze*expo+(*b_rs).mant.chart < MIN_CHART) /* underflow */
	 {
	    (*b_rs) = b_zero ;
	    b_status = B_UNDERFLOW_ERROR ;
	    return(b_rs);
	 }

	 ACIB(ziff) ;
      }

      if(!expo && s_op[-1] != '0')      /* NUR e oder E ohne Zahl ?  */
      {
	 --s_op;
      }

      (*b_rs).mant.chart = vorze*expo+(*b_rs).mant.chart ;
   }

   if (ziff != 0) /* Non-null character */
   {
      /* Skip past trailing spaces, if any */
      while( (UCHAR)(*s_op) == (UCHAR)' ')
      {
	 ++s_op;
      }

      if ( (*s_op) != 0)
      {
	 /* Error only if non-null character on end of string */
	 b_status = B_FIRST_OPERAND_ERROR;
	 *b_rs = b_zero ;
	 return(b_rs) ;  /* invalid character follows mantissa */
      }
   }

   if (nrziff == 0)
   {
      (*b_rs).mant.chart = 0 ;
      nrziff++ ;
      nkomm = 0 ;
   }

   if((nkomm -= (*b_rs).mant.chart) < 0)
   {
      nkomm = 0 ;
   }

   /* Check for underflow/overflow and return */
   if ((*b_rs).mant.chart > MAX_CHART)      /* overflow */
   {
      (*b_rs) = b_zero ;
      b_status = B_OVERFLOW_ERROR ;
   }
   else if ((*b_rs).mant.chart < MIN_CHART) /* underflow */
   {
      (*b_rs) = b_zero ;
      b_status = B_UNDERFLOW_ERROR ;
   }

   return(b_rs);
}



/***************************************************************************/
/*                                                                         */
/*      b_ststring_long,  convert bcd to ASCII whitout exponent            */
/*                                                                         */
/*      input:                                                             */
/*              char *s_rs;                                                */
/*              BCD *b_op1;                                                */
/*                                                                         */
/*      output:                                                            */
/*              string = ascii(bcd);                                       */
/*                                                                         */
/***************************************************************************/
char *b_ststring_long(s_rs, b_op1)

char *s_rs;
BCD *b_op1;
{
   BCD b;
   int vorkomma, nachkomma, nullen;
   char *pt ;
   int curr_dig, dig_count ;

   if (b_status < 0)                               /* Error, can't continue */
   {
      return 0;
   }
   b_init();

   b = *b_op1;
   pt = s_rs;

   if (b.mant.chart > MAX_CHART)                      /* check for overflow */
   {
      b_status = B_OVERFLOW_ERROR ;
   }
   else if (ZERO(b))                                  /* check for zero     */
   {
      *pt++ = (UCHAR)'0';
   }
   else
   {
      dig_count = 17;
      while ( dig_count > 0 && (GETDIG(b, dig_count)) == 0 )
      {
	 dig_count--;                        /* Count the no of digits in b */
      }
      dig_count++;
      vorkomma = b.mant.chart;

      if (GETSIGN(b) == NEGATIV)
      {
	 *pt++ = (UCHAR)'-';                             /* set sign        */
      }

      if ( (int)b.mant.chart > FRACT_CHART )             /* number >= 1 ??? */
      {
	 if ( dig_count < vorkomma )                     /* yes !!!!!!!     */
	 {
	    nullen = vorkomma - dig_count;
	    vorkomma = dig_count;
	    nachkomma = 0;
	 }
	 else
	 {
	    nachkomma = dig_count - vorkomma;
	    nullen = 0;
	 }
					  /* Fill in the vorkomma positions */
	 for (curr_dig = 0; vorkomma > 0; vorkomma--)
	 {
	    *pt++ = (UCHAR)'0' + GETDIG(b, curr_dig) ;
	    curr_dig++;
	 }
	 if ( nachkomma )
	 {
	    *pt++ = '.';                           /* Fill in decimal point */
	    for (; nachkomma > 0; nachkomma--)
	    {
	       *pt++ = (UCHAR)'0' + GETDIG(b, curr_dig);
	       curr_dig++;
	    }
	 }
	 else
	 {
	    for (; nullen > 0; nullen--)
	    {
	       *pt++ = (UCHAR)'0';
	    }
	 }
      }
      else                                         /* number is < 1  !!!!   */
      {
	 *pt++ = '0';                              /* set 0.xxxx            */
	 *pt++ = '.';                              /* Fill in decimal point */
	 for (; vorkomma < 0; vorkomma++)
	 {
	    *pt++ = (UCHAR)'0';
	 }
	 for (curr_dig = 0; dig_count > 0; dig_count--)
	 {
	    *pt++ = (UCHAR)'0' + GETDIG(b, curr_dig) ;
	    curr_dig++;
	 }
      }
   }
   *pt = '\0';
   return(s_rs);
}



/***************************************************************************/
/*                                                                         */
/*      b_ststring    Convert bcd to ASCII                                 */
/*                                                                         */
/*      input:                                                             */
/*              char *s_rs;                                                */
/*              BCD *b_op1;                                                */
/*                                                                         */
/*      output:                                                            */
/*              string = ascii(bcd);                                       */
/*                                                                         */
/***************************************************************************/

char *b_ststring(s_rs, b_op1)

char *s_rs;
BCD *b_op1;
{
   BCD b;
   int i ;
   short expo, vorkoma;
   char *pt;
   short current_dig, dig_count;
   short nrziff;
   int digit_was_not_set;

   if (b_status < 0)                               /* Error, can't continue */
   {
      return 0;
   }
   b_init();

   b = *b_op1;

   pt = s_rs;

   if (GETSIGN(b) == NEGATIV)
   {
      *pt++ = '-';
   }

   if (b.mant.chart > MAX_CHART)
   {
      b_status = B_OVERFLOW_ERROR ;
   }
   else if (ZERO(b))
   {
      *pt++ = '0';
   }
   else
   {
		    /* Obvious case of number has to be written in E-Format */
      if ((int)b.mant.chart < -18 || b.mant.chart > 18)
      {
	 vorkoma = 1 ;
	 expo = b.mant.chart - 1 ;
      }
      else
      {
		    /* For values with negativ characteristics, check again */
	 if ((int)b.mant.chart < -1)
	 {
					   /* Count the trailing zeros in b */
	    current_dig = GETDIG(b,17);                 /* nm004 */
	    dig_count = 0 ;
	    while (current_dig == 0 && dig_count <= 18)
	    {
	       current_dig = GETDIG(b,17-dig_count);    /* nm004 */
	       dig_count++ ;
	    }

		     /* If we need less than 18 leading digits to represent */
		     /* the value, go for it, otherwise use E-Format        */
	    if (( (18-dig_count) - b.mant.chart) < 18)
	    {
	       vorkoma = b.mant.chart ;                 /* Normal format */
	       expo = 0 ;
	    }
	    else
	    {
	       vorkoma = 1 ;                            /* E-Format */
	       expo = b.mant.chart - 1 ;
	    }
	 }
	 else
	 {
				  /* Positiv exponent, but not too positive */
	    vorkoma = b.mant.chart;
	    expo = 0 ;
	 }
      }

					  /* Fill in the vorkomma positions */
      digit_was_not_set = 1;
      for (nrziff=0;vorkoma>0;vorkoma--)
      {
	 *pt++ = (UCHAR)'0'+GETDIG(b,nrziff) ;
	 nrziff++ ;
	 digit_was_not_set = 0;
      }

						  /* ignore trailing zeroes */
      for (i=NBCD-1;i>=nrziff && GETDIG(b,i)== 0;i--) ;

			       /* from nrziff to i must be copied to output */
      if (i>=nrziff)
      {
			    /* If no digits before comma, fill in 0 so that */
			    /*     0.1234 is generated instead of .1234     */
	 if (b.mant.chart <= 0 && digit_was_not_set)
	 {
	     *pt++ = '0';
	 }
	 *pt++ = '.';                              /* Fill in decimal point */

					     /* Fill in the nachkomma nulls */
	 for (;vorkoma;vorkoma++)
	 {
	    *pt++ = (UCHAR)'0';
	 }

	 for (;nrziff<=i;nrziff++)
	 {
	    *pt++ = (UCHAR)'0' + GETDIG(b,nrziff) ;
	 }
      }

      if (expo)
      {
	 *pt++ = (UCHAR)'E';
	 if (expo >0)
	 {
	    *pt++ = (UCHAR)'+';
	 }
	 else
	 {
	    *pt++ = (UCHAR)'-';
	    expo = expo < -99 ? 99 : - expo ;
	 }
	 *pt++ = expo / 10 + (UCHAR)'0';
	 *pt++ = expo % 10 + (UCHAR)'0';
      }
   }

   *pt = '\0';
   return(s_rs);
}



/****************************************************************************/
/*                                                                          */
/*      b_ldddb4; converts a DDB/4 number value into BCD value              */
/*                                                                          */
/*      input:   address of BCD variable                                    */
/*               address of DDB/4 number value                              */
/*               number of significants digits                              */
/*                                                                          */
/*      Output:  nothing                                                    */
/*                                                                          */
/****************************************************************************/

BCD  *b_ldddb4(b_r, c_op, no_of_digits)
BCD  *b_r;                           /*  pointer to dedicated host variable */
UCHAR *c_op;                         /*  start position in transfer buffer  */
int  no_of_digits;                   /*  number of significant digits       */
{
   UCHAR  *mantptr;
   int     length;
   int     expo;
   int     i;
   int    cpylen;

   if (b_status < 0)                /* Error, can't continue */
   {
      return 0;
   }

   expo    = (UCHAR)*c_op;

   *b_r = b_zero;

   if (expo != (UCHAR)B_D4_NULL_EXP)
   {
      length   = (no_of_digits+1) / 2;                /* number of bytes    */
      if (expo < (UCHAR)B_D4_NULL_EXP)                /* result negativ ??? */
      {
	 cpylen = length < NBYTE ? length + 1 : NBYTE;
	 (void)memcpy(ddb4_buffer, c_op, cpylen);
	 c_op = ddb4_buffer;

	 if (b_complement((c_op), length))            /* convert mantissa */
	 {
	    return(b_r);                    /* return when error is occured */
	 }
	 b_r->b_byte.sign = NEGATIV;
					   /* convert exponent to BCD form  */
	 if (expo > 64 )                   /* negative exponent ???         */
	 {
	    b_r->b_byte.chart = (UCHAR) (256 - (expo & 0x3f));
	 }
	 else
	 {
	     b_r->b_byte.chart = (UCHAR) (64 - expo);
	 }
      }
      else
      {
	 b_r->b_byte.sign = POSITIV;
	 if ( expo < B_D4_POS_EXP )
	 {
	    b_r->b_byte.chart = (UCHAR)(expo & 0x3f | 0xc0);
	 }
	 else
	 {
	    b_r->b_byte.chart = (UCHAR)(expo & 0x3f);
	 }
      }
      mantptr = &b_r->b_byte.dig[0];

      c_op++;
      for (i = 0; (i+1) < length; i += 2 )      /* write significant digits */
      {
	  *(mantptr+i+HIGHBYTE) = *c_op++;
	  *(mantptr+i+LOWBYTE)  = *c_op++;
      }
      if ( i < length )
      {
	  *(mantptr+i+HIGHBYTE) = *c_op++;
      }
      if ( no_of_digits % 2 )
      {
	  *(mantptr+i+HIGHBYTE) = *(mantptr+i+HIGHBYTE) & 0xf0;
      }
   }
   return(b_r);
}


/****************************************************************************/
/*                                                                          */
/*      b_stddb4; convert BCD-value into DDB/4 format                       */
/*                                                                          */
/*      Input:   destination address                                        */
/*               source address                                             */
/*               number of digits of destination value (DDB/4 format)       */
/*                                                                          */
/*      Output:  address of destination value                               */
/*                                                                          */
/****************************************************************************/

UCHAR *b_stddb4(c_r, b_op, no_of_digits)
UCHAR *c_r;
BCD  *b_op;
int   no_of_digits;
{
   UCHAR  *mantptr;
   unsigned char   *apos;
   int     expo;
   int     sign;
   int     length;
   int     i;

   if (b_status < 0)                /* Error, can't continue */
   {
      return 0;
   }
			  /* transfer a BCD number to DDB/4 number variable */
   apos = c_r+1;
   sign = (UCHAR)b_op->b_byte.sign;
   expo = (UCHAR)b_op->b_byte.chart;
   length = (no_of_digits+1) / 2;

   mantptr = &b_op->b_byte.dig[0];

   for (i = 0; (i+1) < length; i += 2)        /* with byte swapping       */
   {
       *apos++ = *(mantptr+i+HIGHBYTE);
       *apos++ = *(mantptr+i+LOWBYTE);
   }
   if ( i < length )
   {
       *apos++ = *(mantptr+i+HIGHBYTE);
   }

   if ( no_of_digits % 2 )
   {
       --apos;
       *apos = *apos & 0xf0;
   }

   if (sign)                                  /* sign mantissa minus ??? */
   {
      if ( b_complement(c_r, length) )
      {
	 return(c_r);
      }
      *c_r = (UCHAR)(B_D4_NULL_EXP - ((expo & 0x7f)^0x40));
   }
   else
   {
      if (*(c_r+1) != (UCHAR)0)
      {
	      *c_r = (UCHAR)(B_D4_NULL_EXP + ((expo & 0x7f)^0x40));
      }
      else
      {
	      *c_r = (UCHAR)B_D4_NULL_EXP;
      }
   }
   return(c_r);
}



/****************************************************************************/
/**                                                                        **/
/**     BCD-Arithmetic for X/SDE     copyright (C) by SIEMENS/NIXDORF      **/
/**                                                                        **/
/****************************************************************************/
/**                                                                        **/
/**     u t i l i t i e s                                                  **/
/**                                                                        **/
/****************************************************************************/


/***************************************************************************/
/*                I N T E R N A L       F U N C T I O N S                  */
/***************************************************************************/



/***************************************************************************/
/*                                                                         */
/*   addmant add the mantissas of two internal formatted numbers           */
/*           (*px) = (*px) + (*py)                                         */
/*                                                                         */
/***************************************************************************/
addmant(px,py)

BCD *px,*py;
{
   BCD c ;
   short ovfl ;

   (*px).b_byte.DIG9 = 0x00;
   (*py).b_byte.DIG9 = 0x00;

   /* Signs are equal, add the mantissas */
   if ((*px).mant.sign == (*py).mant.sign)
   {
      ovfl = add(px,py);
      if (ovfl)
      {
	 shift_right(px) ;
	 (*px).b_byte.DIG0 += 16 ;
	 (*px).mant.chart++ ;
      }
   }
   else  /* Ungleich signs */
   {
      if (comp_d(px,py) >= 0)
      {
	 /* Mantissa px is greater px = px - py */
	 sub(px,py);
      }
      else
      {
	 /* Mantissa py is greater px = py - px */
	 (*px).mant.sign = (*py).mant.sign ;
	 c = *px ;
	 *px = *py ;
	 sub(px,&c);
      }
   }
}

/***************************************************************************/
/*                                                                         */
/*      add(px,py)  -   add the mantissas of two numbers in internal format*/
/*                      px = px + py                                       */
/*                                                                         */
/***************************************************************************/
add(px,py)

BCD *px,*py;
{
   register long r1,r2,r3,carry;
   register int i;
   long z1, z2, z3;

   carry = 0;
   for (i=4;i>=0;i--)
   {
      r1 = (*px).mant.word[i] ;
      r2 = (*py).mant.word[i] ;

      if (r1 == 0 && r2 == 0)
      {
	 (*px).mant.word[i] = carry ;
	 carry = 0 ;
      }
      else
      {
	 z1 = r1+r2+carry;
	 z2 = ((z1+0x66666666)^r1^r2^carry)&0x11111111;
	 z3 = z2 + z2;
	 z3 = z3 + z2;
	 z3 = z3 + z3;
	 r3 = z1 + (z3>>4);

	 if (r3 < 0x10000)
	 {
	    carry = 0 ;
	 }
	 else
	 {
	    r3 = r3 & 0xFFFF ;
	    carry = 1 ;
	 }

	 (*px).mant.word[i] = r3 ;
      }
   }
   return carry ;
}

/***************************************************************************/
/*                                                                         */
/*   sub  subtracts two mantissas                                          */
/*        px must be greater or equal py                                   */
/*        px = px - py                                                     */
/*                                                                         */
/***************************************************************************/
sub(px,py)

BCD *px,*py;
{
   register long r1,r2,r3,borrow;
   long z1, z2, z3;
   register int i;

   borrow = 0;
   for (i=4;i>=0;i--)
   {
      r1 = (*px).mant.word[i] ;
      r2 = (*py).mant.word[i] ;

      if (r1 == 0 && r2 == 0 && borrow == 0)
      {
	 (*px).mant.word[i] = 0 ;
      }
      else
      {
	 z1 = r1-r2-borrow;
	 z2 = (z1^r1^r2^borrow)&0x11111111;
	 z3 = z2 + z2;
	 z3 = z3 + z2;
	 z3 = z3 + z3;
	 r3 = z1 - (z3>>4);

	 if (r3 >= 0x0)
	 {
	    borrow = 0 ;
	 }
	 else
	 {
	    r3 = r3 & 0xFFFF;
	    borrow = 1 ;
	 }

	 (*px).mant.word[i] = r3 ;
      }
   }
}

/***************************************************************************/
/*                                                                         */
/* norm         normalize a internal formatted number px                   */
/*                                                                         */
/***************************************************************************/
norm(px)

BCD *px ;
{
   if ((*px).mant.word[0] || (*px).mant.word[1] || (*px).mant.word[2] ||
       (*px).mant.word[3] || (*px).mant.word[4])

   while (! NORMALIZED(*px))
   {
      shift_left(px) ;
      (*px).mant.chart-- ;
   }
   else
   {
      (*px).mant.sign = POSITIV ;
      (*px).mant.chart = 0 ;
   }
}

/***************************************************************************/
/*                                                                         */
/* comp_d(px,py)compare the mantissas from two internal formatted numbers  */
/*              return(>0)  -- >  px > py                                  */
/*              return(=0)  -- >  px = py                                  */
/*              return(<0)  -- >  px < py                                  */
/*                                                                         */
/***************************************************************************/
comp_d(px,py)

BCD *px,*py ;
{
   if ((*px).mant.word[0] != (*py).mant.word[0])
   {
      return(((*px).mant.word[0] > (*py).mant.word[0])?1:-1);
   }
   if ((*px).mant.word[1] != (*py).mant.word[1])
   {
      return(((*px).mant.word[1] > (*py).mant.word[1])?1:-1);
   }
   if ((*px).mant.word[2] != (*py).mant.word[2])
   {
      return(((*px).mant.word[2] > (*py).mant.word[2])?1:-1);
   }
   if ((*px).mant.word[3] != (*py).mant.word[3])
   {
      return(((*px).mant.word[3] > (*py).mant.word[3])?1:-1);
   }
   if ((*px).mant.word[4] != (*py).mant.word[4])
   {
      return(((*px).mant.word[4] > (*py).mant.word[4])?1:-1);
   }
   return(0) ;
}


/*        alte Version ist bei Gleichheit 25% langsamer
   int i ;
   for (i=0;i<NWORD;i++)
   {
      if ((*px).mant.word[i] != (*py).mant.word[i])
      {
	 return(((*px).mant.word[i] > (*py).mant.word[i])?1:-1);
      }
   }
*/


/***************************************************************************/
/*                                                                         */
/* shift_right    shift mantissa right by 1 digit                          */
/*                                                                         */
/***************************************************************************/
shift_right(px)

register BCD *px ;
{
   (*px).mant.word[4] >>= 4 ;
   (*px).mant.word[4] += (*px).mant.word[3] << 12 ;
   (*px).mant.word[3] >>= 4 ;
   (*px).mant.word[3] += (*px).mant.word[2] << 12 ;
   (*px).mant.word[2] >>= 4 ;
   (*px).mant.word[2] += (*px).mant.word[1] << 12 ;
   (*px).mant.word[1] >>= 4 ;
   (*px).mant.word[1] += (*px).mant.word[0] << 12 ;
   (*px).mant.word[0] >>= 4 ;
}

/***************************************************************************/
/*                                                                         */
/* shift_left     shift mantissa left by 1 digit                           */
/*                                                                         */
/***************************************************************************/
shift_left(px)

register BCD *px ;
{
   (*px).mant.word[0] <<= 4 ;
   (*px).mant.word[0] += (*px).mant.word[1] >> 12 ;
   (*px).mant.word[1] <<= 4 ;
   (*px).mant.word[1] += (*px).mant.word[2] >> 12 ;
   (*px).mant.word[2] <<= 4 ;
   (*px).mant.word[2] += (*px).mant.word[3] >> 12 ;
   (*px).mant.word[3] <<= 4 ;
   (*px).mant.word[3] += (*px).mant.word[4] >> 12 ;
   (*px).mant.word[4] <<= 4 ;
}

/***************************************************************************/
/*                                                                         */
/* shift        shift mantissa right by n digits                           */
/*                                                                         */
/***************************************************************************/
shift(px,n)
register BCD *px ;
register short n ;
{
   if (n & 1)   /* Shift nibble (half byte) */
   {
#ifdef m_i386
	 /* For Byte swap, use short pointers */
	 register unsigned short *p0, *p1, i;

	 if (n > 0) /* Shift right */
	 {
	    p1 = (unsigned short *) &px->mant.word[4];
	    p0 = p1 - 1;

	    for (i=4; i; i--)
	    {
	       *p1 >>= 4 ;
	       ((UCHAR *)p1)[HIGHBYTE] |= (*p0 & 0x000F) << 4;  /*nm003*/
	       p1--; p0--;                                      /*nm003*/
	    }
	    *p1 >>= 4 ;
	    n--;
	 }
	 else /* Shift left */
	 {
	    p0 = (unsigned short *) &px->mant.word[0];
	    p1 = p0 + 1 ;

	    for (i=4; i; i--)
	    {
	       *p0 <<= 4;
	       *p0 |= ((UCHAR *)p1)[HIGHBYTE] >> 4;             /*nm003*/
	       p0++ ; p1++;                                     /*nm003*/
	    }
	    *p0 <<= 4 ;
	    n++;
	 }
#else /* m_mips */
	 /* Perform shift using longward access */

	 register unsigned long  *p2, *p4;
	 register unsigned short *p0;

	 p0 = (unsigned short *) &px->mant.word[0];
	 p2 = (unsigned long *) &px->mant.word[1];
	 p4 = p2 + 1 ;

	 if (n > 0) /* Shift right */
	 {
	    *p4 >>= 4;
	    *(UCHAR *)p4  |= (*p2 & 0x0000000F) << 4;
	    *p2 >>= 4;
	    *(UCHAR *)p2  |= (*p0 & 0X000F) << 4;
	    *p0 >>= 4;
	    n--;
	 }
	 else /* Shift left */
	 {
	    *p0 <<= 4;
	    *p0  |= (*((UCHAR *) p2) >> 4) ;
	    *p2 <<= 4;
	    *p2  |= (*((UCHAR *) p4) >> 4) ;
	    *p4 <<= 4 ;
	    n++;
	 }
#endif
   }

   if (n == 0)
   {
      return;
   }

   n >>= 1;
   if (n & 1)  /* Shift word */
   {
      register int i;
      register UCHAR  *ptr1, *ptr2;

      if (n > 0) /* Shift right */
      {
	 ptr2 = &px->b_byte.dig[8];

	 for (i = 5; i; i--)
	 {
	    *(ptr2+LOWBYTE) = *(ptr2+HIGHBYTE) ;
	    *(ptr2+HIGHBYTE) = *(ptr2-2+LOWBYTE) ;
	    ptr2 = ptr2 - 2 ;
	 }

	 *(ptr2+2+HIGHBYTE) = 0;
	 n--;

      }
      else /* Shift left */
      {
	 ptr1 = &px->b_byte.dig[0];

	 for ( i = 5;  i;  i-- )
	 {
	    *(ptr1+HIGHBYTE) = *(ptr1+LOWBYTE) ;
	    *(ptr1+LOWBYTE) = *(ptr1+2+HIGHBYTE) ;
	    ptr1 = ptr1 + 2 ;
	 }

	 *(ptr1-2+LOWBYTE) = 0;
	 n++;
      }
   }

   if (n == 0)
   {
      return;
   }

   n >>= 1;

   /* Shift remaining words */
   {
      register unsigned short *ptr;

      ptr = (unsigned short *) px->mant.word;

      while (  n > 0  )
      {
	 ptr[4] = ptr[3];
	 ptr[3] = ptr[2];
	 ptr[2] = ptr[1];
	 ptr[1] = ptr[0];
	 ptr[0] = 0;

	 n--;
      }

      while (  n < 0  )
      {
	 ptr[0] = ptr[1];
	 ptr[1] = ptr[2];
	 ptr[2] = ptr[3];
	 ptr[3] = ptr[4];
	 ptr[4] = 0;

	 n++;
      }
   }
}

/***************************************************************************/
/*                                                                         */
/*     dec_brk Break dec number in b_op1 into integer and fractional part  */
/*                                                                         */
/*             return - b_op1 = Fractional part (normalized)               */
/*                      b_op2 = Integer    part (normalized)               */
/*                                                                         */
/***************************************************************************/
dec_brk(b_op1,b_op2)

BCD *b_op1,*b_op2;
{
   int i,j ;

   if ((int)(*b_op1).mant.chart <= 0)    /* Operand has NO integer part */
   {
      (*b_op2) = b_zero;
   }
   else                                 /* Operand has integer part */
   {
      (*b_op2) = (*b_op1);
      if ((*b_op1).mant.chart >= NBCD)   /* Operand has no fractional part */
      {
	 (*b_op1) = b_zero;
      }                                 /* Split operand */
      else
      {
	 for (i=0,j=(*b_op1).mant.chart;j<NBCD;i++,j++)
	 {
	    PUTDIG((UCHAR)GETDIG(*b_op1,j),*b_op1,i) ;
	    PUTDIG(0,*b_op2,j) ;
	 }
	 for (;i<NBCD;i++)
	 {
	    PUTDIG(0,*b_op1,i) ;
	 }
	 (*b_op1).mant.chart = 0 ;

	 if (!NORMALIZED(*b_op1))
	 {
	     norm(b_op1) ;
	 }
      }
   }
}


/***************************************************************************/
/*                                                                         */
/*      i2mant  converts a int value to mantissa                           */
/*                                                                         */
/***************************************************************************/

int i2mant(value, b_rs, index)
int value;
BCD * b_rs;
int index;
{
   int tmp;
   tmp = (value % 10);
   if ( value /= 10 )
   {
      index = i2mant(value, b_rs, index);
   }
   BAPUTDIG(tmp, (GETADR(*b_rs, index)), index);
   return(++index);
}



/***************************************************************************/
/*                                                                         */
/*      l2mant  converts a long value to mantissa                          */
/*                                                                         */
/***************************************************************************/

int l2mant(value, b_rs, index)
long value;
BCD * b_rs;
int index;
{
   int tmp;
   tmp = (value % 10l);
   if ( value /= 10l )
   {
      index = l2mant(value, b_rs, index);
   }
   BAPUTDIG(tmp, (GETADR(*b_rs, index)), index);
   return(++index);
}


/****************************************************************************/
/*                                                                          */
/*      convert negative DDB/4 number to ten's complement                   */
/*                                                                          */
/*      input : buffer address of DDB/4 number                              */
/*              length of DDB/4 number                                      */
/*                                                                          */
/*      output: error code (no significant mantissa)                        */
/*                                                                          */
/****************************************************************************/

int b_complement(buffer, len)
UCHAR *buffer;
int     len;
{
   UCHAR   *pos, *epos;
   int     digit;

   *buffer = (193 - (UCHAR) *buffer);
   pos = buffer+1;
   buffer += len;
					   /* search for significant digits */
   while ((*(buffer) == 0) && buffer >= pos)
   {
      buffer--;
   }
   assert ( buffer >= pos);      /* no significant digits of mantissa ????  */

   epos  = buffer;
   digit = (UCHAR)*epos;
   if ((digit & 15) == 0)           /* complement over the last digit(s) */
   {
	   digit -= 7;
   }
   else
   {
	   digit -= 1;
   }
   *epos = digit;
   while (pos <= epos)             /* complement over all other digit(s) */
   {
      *pos = ((UCHAR)153) - *pos;
      pos++;
   }
   return(B_OK);
}


/***************************************************************************/
/***************************************************************************/


/***************************************************************************/
/*                                                                         */
/*      b_init        Initialize the bcd constants zero, one, and          */
/*                      infinity,etc., also in bcd_ari_cmp.c               */
/*                                                                         */
/*                      Requires no input parameters                       */
/*                                                                         */
/***************************************************************************/
void b_init()
{

   if ( is_init_done == B_FALSE )
   {
					       /*********** bcd 0 ***********/
      b_zero.mant.chart = 0x00;
      b_zero.mant.sign  = POSITIV;
      b_zero.mant.word[0] = 0x0000;
      b_zero.mant.word[1] = 0x0000;
      b_zero.mant.word[2] = 0x0000;
      b_zero.mant.word[3] = 0x0000;
      b_zero.mant.word[4] = 0x0000;

					       /*********** bcd 1 ***********/
      b_one.mant.chart = 0x01;
      b_one.mant.sign  = POSITIV;
      b_one.mant.word[0] = 0x1000;
      b_one.mant.word[1] = 0x0000;
      b_one.mant.word[2] = 0x0000;
      b_one.mant.word[3] = 0x0000;
      b_one.mant.word[4] = 0x0000;

						/********** bcd -1 **********/
      b_n_one.mant.chart = 0x01;
      b_n_one.mant.sign  = NEGATIV;
      b_n_one.mant.word[0] = 0x1000;
      b_n_one.mant.word[1] = 0x0000;
      b_n_one.mant.word[2] = 0x0000;
      b_n_one.mant.word[3] = 0x0000;
      b_n_one.mant.word[4] = 0x0000;

	      /* This code assumes that int long is always 32 bits and that */
	      /* int short is always 16 bits. The only C type which varies  */
	      /* accross systems is int, which is either 32 bits or 16 bits */
	      /* The int limits are conditionally set based on this info.   */

					     /****** bcd -2147483648   ******/
      b_l_minw.mant.chart = 0xA;
      b_l_minw.mant.sign  = NEGATIV;
      b_l_minw.mant.word[0] = 0x2147;
      b_l_minw.mant.word[1] = 0x4836;
      b_l_minw.mant.word[2] = 0x4800;
      b_l_minw.mant.word[3] = 0x0000;
      b_l_minw.mant.word[4] = 0x0000;

					     /**** bcd -2147483648.99999 ****/
      b_l_min.mant.chart = 0xA;
      b_l_min.mant.sign  = NEGATIV;
      b_l_min.mant.word[0] = 0x2147;
      b_l_min.mant.word[1] = 0x4836;
      b_l_min.mant.word[2] = 0x4899;
      b_l_min.mant.word[3] = 0x9999;
      b_l_min.mant.word[4] = 0x9900;

					    /***** bcd 2147483647.99999 *****/
      b_l_max.mant.chart = 0xA;
      b_l_max.mant.sign  = 0x00;
      b_l_max.mant.word[0] = 0x2147;
      b_l_max.mant.word[1] = 0x4836;
      b_l_max.mant.word[2] = 0x4799;
      b_l_max.mant.word[3] = 0x9999;
      b_l_max.mant.word[4] = 0x9900;

					     /**** bcd -32768.9999999999 ****/
      b_s_min.mant.chart = 0x5;
      b_s_min.mant.sign  = NEGATIV;
      b_s_min.mant.word[0] = 0x3276;
      b_s_min.mant.word[1] = 0x8999;
      b_s_min.mant.word[2] = 0x9999;
      b_s_min.mant.word[3] = 0x9999;
      b_s_min.mant.word[4] = 0x9900;

					  /*********** bcd -32768 ***********/
      b_s_minw.mant.chart = 0x5;
      b_s_minw.mant.sign  = NEGATIV;
      b_s_minw.mant.word[0] = 0x3276;
      b_s_minw.mant.word[1] = 0x8000;
      b_s_minw.mant.word[2] = 0x0000;
      b_s_minw.mant.word[3] = 0x0000;
      b_s_minw.mant.word[4] = 0x0000;

					    /***** bcd 32767.9999999999 *****/
      b_s_max.mant.chart = 0x5;
      b_s_max.mant.sign  = POSITIV;
      b_s_max.mant.word[0] = 0x3276;
      b_s_max.mant.word[1] = 0x7999;
      b_s_max.mant.word[2] = 0x9999;
      b_s_max.mant.word[3] = 0x9999;
      b_s_max.mant.word[4] = 0x9900;

      if (INT_MAX == LONG_MAX)
      {
	 b_i_min = b_l_min ;
	 b_i_max = b_l_max ;
	 b_i_minw = b_l_minw ;
      }
      else                                      /* if (INT_MAX == SHRT_MAX) */
      {
	 b_i_min = b_s_min ;
	 b_i_max = b_s_max ;
	 b_i_minw = b_s_minw ;
      }

						/** bcd 9.9999999999999E62 **/
      b_infi.mant.chart = 0x3F;
      b_infi.mant.sign  = POSITIV;
      b_infi.mant.word[0] = 0x9999;
      b_infi.mant.word[1] = 0x9999;
      b_infi.mant.word[2] = 0x9999;
      b_infi.mant.word[3] = 0x9999;
      b_infi.mant.word[4] = 0x9900;

      b_ac_init();                       /* initialization of bcd_ari_cmp.c */

      is_init_done = B_TRUE;                      /* initialization is done */
   }
}

/***************************************************************************/
/*                    D E B U G       R O U T I N E S                      */
/***************************************************************************/

/* Show value of BCD type variable */
dump(px)

BCD *px ;
{
   int i;

   (void)printf("mant: ");
   for (i=0;i<=4;i++)
   {
      (void)printf("%x ",(*px).mant.word[i]);
   }

   (void)printf("  sign: %d   exp: %d\n",
	 (int)(*px).mant.sign,(int)(*px).mant.chart);

}

/* Show proporties of a BCD type variable */
whatis(bop)

BCD *bop;
{
   int i;

   dump(bop);

   if (b_isint(bop) == B_TRUE)
   {
      (void)printf("is int\n");
   }
   else
   {
      (void)printf("is not int\n");
   }

   if (b_isfract(bop) == B_TRUE)
   {
      (void)printf("is fract\n");
   }
   else
   {
      (void)printf("is not fract\n");
   }

   if (b_isnatural(bop) == B_TRUE)
   {
      (void)printf("is natural\n");
   }
   else
   {
      (void)printf("is not natural\n");
   }

   if (b_isodd(bop) == B_TRUE)
   {
      (void)printf("is odd\n");
   }
   else
   {
      (void)printf("is not odd\n");
   }

   if (b_iseven(bop) == B_TRUE)
   {
      (void)printf("is even\n");
   }
   else
   {
      (void)printf("is not even\n");
   }

   i = b_sgn(bop);

   if (i == -1)
   {
      (void)printf("is < 0\n");
   }

   if (i ==  0)
   {
      (void)printf("is = 0\n");
   }

   if (i ==  1)
   {
      (void)printf("is > 0\n");
   }

   (void)printf("\n");
}
