(*
-------------------------------------------------------------------------------
-- Name of the source		: WDuration.t
-- Author(s)			: Jose Luis Albero
-- Date of creation		: 13 May 1993
-- Defined Objects		: WDuration
-- Description of the contents	: Working duration object, subtype of 
--                                Duration object. It adds one state:
--                                calendar, in which WDuration is based.
-- Document reference		: 
-- Copyright 1993, TAO S.A., Barcelona, Spain
-- This software was produced as part of the ESPRIT project ITHACA-IT.
-------------------------------------------------------------------------------
-- Modification log	:
-- Version	Date	Author	Description
-- ------------ ------- ------- -----------------------------------------------
-------------------------------------------------------------------------------
*)

SPECIFICATION WDuration 

IMPORT Duration FROM Duration;
IMPORT Calendar FROM Calendar;

TYPE WDuration = Duration OBJECT (IN inYears : INT, IN inMonths : INT,
                                  IN inDays : INT, IN inCalendar : Calendar)

PUBLIC
  METHOD GetCalendar () : Calendar;
    -- Gets the calendar that the current WDuration is based in.
  METHOD SetWDuration (IN inYears : INT, IN inMonths : INT,
                       IN inDays : INT, IN inCalendar : Calendar);
    -- Sets the calendar of the current WDuration.

PROTECTED
STATE -- WDuration
  calendar : Calendar;

END OBJECT; -- WDuration


END SPECIFICATION;
