(*
-------------------------------------------------------------------------------
-- Name of the source		: TimeStampRep.t
-- Author(s)			: SNI
-- Date of creation		: 10 Feb 1992
-- Defined Objects		: TimeStampRepr
-- Description of the contents	: 
-- Document reference		: 
-- Copyright 1993, TAO S.A., Barcelona, Spain
-- This software was produced as part of the ESPRIT project ITHACA-IT.
-------------------------------------------------------------------------------
-- Modification log	:
-- Version	Date	Author	Description
-- ------------ ------- ------- -----------------------------------------------
-------------------------------------------------------------------------------
*)

SPECIFICATION TimeStRepr 

IMPORT TimeStamp FROM TimeSt; --TimeStamp object
IMPORT Time FROM Time;

TYPE TimeStampRepr = TimeStamp OBJECT (IN inYear : INT, IN inMonth : INT,
                                       IN inDay : INT, IN inStamp : Time,
                                       IN inFormat : STRING)

PUBLIC
  METHOD GetFormat : STRING;
    -- Returns the actual format string of this date. The format is  
    -- like the format of the strftime () C-Lib call. 
  METHOD SetFormat (IN inFormat : STRING);
    -- Set the format of this date
  METHOD Present : STRING;
    -- Returns this date formatted with its representation.

PROTECTED
STATE -- TimeStampRepr
  format : STRING;

END OBJECT; -- TimeStampRepr

END SPECIFICATION;
