(*
-------------------------------------------------------------------------------
-- Name of the source		: TimeInterval.t
-- Author(s)			: Jose Luis Albero
-- Time of creation		: 18 May 1993
-- Defined Objects		: TimeInterval
-- Description of the contents	: 
-- Document reference		: 
-- Copyright 1993, TAO S.A., Barcelona, Spain
-- This software was produced as part of the ESPRIT project ITHACA-IT.
-------------------------------------------------------------------------------
-- Modification log	:
-- Version	Time	Author	Description
-- ----------- -------- ------- -----------------------------------------------
-------------------------------------------------------------------------------
*)

SPECIFICATION TimeInterval 

IMPORT Time FROM Time;     --Time object
IMPORT NDuration FROM NDuration;
IMPORT Stream FROM Stream;

TYPE TimeInterval = OBJECT (IN inStart : Time, IN inEnd : Time) 

PUBLIC
  METHOD Copy () : TimeInterval;
    -- Returns a copy of the current TimeInterval.
  METHOD GetStart () : Time;
  METHOD GetEnd () : Time;
    -- Return the specific information of the current TimeInterval.
  METHOD GetLength () : NDuration;
    -- Returns the duration in natural days of the current TimeInterval.
  METHOD SetStart (IN inStart : Time);
  METHOD SetEnd (IN inEnd : Time);
  METHOD SetTimeInterval (IN inStart : Time, IN inEnd : Time);
    -- Set the values of the current TimeInterval.
  METHOD Add (IN inExtent : NDuration);
  METHOD Subtract (IN inExtent : NDuration);
    -- Add or subtract inExtent to or from both dates of the current
    -- TimeInterval.
  METHOD AddToStart (IN inExtent : NDuration);
  METHOD AddToEnd (IN inExtent : NDuration);
  METHOD SubtractFromStart (IN inExtent : NDuration);
  METHOD SubtractFromEnd (IN inExtent : NDuration);
    -- Add or subtract an extent to or from one date of the current
    -- TimeInterval.
  METHOD Unite (IN inOperand : TimeInterval);
  METHOD Intersect (IN inOperand : TimeInterval);
    -- Unite or intersect the current TimeInterval with inOperand.
  METHOD IsPassed () : BOOL;
  METHOD IsInFuture () : BOOL;
  METHOD IsActual () : BOOL;
    -- Test the current TimeInterval against the actual time.
  METHOD IsEqual (IN inOperand : TimeInterval) : BOOL;
  METHOD IsShorter (IN inOperand : TimeInterval) : BOOL;
  METHOD IsLonger (IN inOperand : TimeInterval) : BOOL;
    -- Compare the length of the current interval with the length
    -- of inOperand.
  METHOD IsOverlapping (IN inOperand : TimeInterval) : BOOL;
    -- Tests whether the current interval is overlapping with inOperand.
  METHOD Contains (IN inOperand : TimeInterval) : BOOL;
    -- Tests whether the current interval contains inOperand. 
  METHOD IsStartInSameHour (IN inOperand : TimeInterval) : BOOL;
  METHOD IsStartInSameMinute (IN inOperand : TimeInterval) : BOOL;
  METHOD IsStartInSameSecond (IN inOperand : TimeInterval) : BOOL;
  METHOD IsEndInSameHour (IN inOperand : TimeInterval) : BOOL;
  METHOD IsEndInSameMinute (IN inOperand : TimeInterval) : BOOL;
  METHOD IsEndInSameSecond (IN inOperand : TimeInterval) : BOOL;
    -- Test whether the start or end of the current interval and the start or
    -- end of inOperand are laying in the same period.
  METHOD IsEarlier (IN inOperand : Time) : BOOL;
  METHOD ContainsTime (IN inOperand : Time) : BOOL;
  METHOD IsLater (IN inOperand : Time) : BOOL;
    -- Test whether inOperand is earlier, in or later than the current
    -- interval. 
  METHOD Serialize (INOUT ioStream : Stream);
    -- TimeInterval state value is stored into ioStream.
  METHOD Deserialize (IN inStream : Stream);
    -- TimeInterval state value is loaded from inStream.
  METHOD GetType () : STRING ;
    -- Returns a String containing type name. To be redefined by each subtype.

PROTECTED
STATE -- TimeInterval
  start : Time;
  end : Time;

END OBJECT; -- TimeInterval

END SPECIFICATION;
