-- ***************************************************************
-- CoLibri
-- ---------------------------------------------------------------
--
-- TextFile.cs -- 
-- 
--   Copyright (C) sietec Systemtechnik GmbH & Co OHG 1994
--   All rights reserved
-- 
-- Author          : Kalle Koester
-- 
-- PURPOSE 
--      |>Description of modules purpose<|
--
-- REFER
--      |>Documents with client documentation<|
--
-- ---------------------------------------------------------------
--
-- Created On      : Wed Jan 12 14:57:15 1994
-- Last Modified By: Karl-Heinz Koester
-- Last Modified On: Wed Mar  9 10:13:08 1994
-- Update Count    : 22
-- 
-- ***************************************************************

SPECIFICATION TextFile

IMPORT BCD FROM Bcd;
IMPORT ExternFile, FILEPOS FROM ExternFile;

(*CONST*) VAR std_in  : TextFile;
(*CONST*) VAR std_out : TextFile;
(*CONST*) VAR std_err : TextFile;

TYPE TextFile = ExternFile
OBJECT 
  (IN name : STRING)
  
PUBLIC
  
  -- INITIALLY 
  
  -- FINALLY 
  
-- -----------------------------------------------------------------
-- Layout Methods
-- -----------------------------------------------------------------
    
  METHOD WriteNewline ();
    -- erzeugt einen Zeilenwechsel in der Datei
    
  METHOD SkipNewline ();
    -- skipped ein direkt folgendes Newline
    
-- -----------------------------------------------------------------
-- ??
-- -----------------------------------------------------------------
  
  METHOD IsEndOfFile () : BOOL;
    
-- -----------------------------------------------------------------
-- Acsess Methods
-- -----------------------------------------------------------------
  
  METHOD WriteLine (IN line : STRING);
  METHOD ReadLine () : STRING;
    
  METHOD WriteChar (IN value : CHAR);
  METHOD ReadChar () : CHAR;
    
  METHOD WriteString (IN value : STRING);
  METHOD ReadString () : STRING;
      
  METHOD WriteInt (IN value : INT);
  METHOD ReadInt () : INT;
    
  METHOD WriteDouble (IN value : DOUBLE);
  METHOD ReadDouble () : DOUBLE;
    
  METHOD WriteBcd (IN value : BCD);
  METHOD ReadBcd () : BCD;
    
PROTECTED
  
STATE
  
  EndOfFile : BOOL;
  undef     : BOOL;
  next_char : CHAR;
  
END OBJECT;

-- CoLibri internal ----------------------------------------------

PROCEDURE Prelude ();
		   
-- ***************************************************************
CONST spec_vid : STRING = 
   "@(#) $__Header$" ;

END SPECIFICATION (* TextFile *);
