-- ***************************************************************
-- CoLibri
-- ---------------------------------------------------------------
--
-- String.cs -- Functions for Type STRING
-- 
--   Copyright (C) sietec Systemtechnik GmbH & Co OHG 1994
--   All rights reserved
-- 
-- Author          : Alessandro Graffigna
-- 
-- PURPOSE 
--      |>Description of modules purpose<|
--
-- REFER
--      |>Documents with client documentation<|
--
-- ---------------------------------------------------------------
--
-- Created On      : Wed Jan 12 14:57:15 1994
-- Last Modified By: Karl-Heinz Koester
-- Last Modified On: Wed Jan 12 15:07:39 1994
-- Update Count    : 6
-- 
-- ***************************************************************

SPECIFICATION String

-------------------------------------------------------------------------
-- Length of strings.
-------------------------------------------------------------------------

PROCEDURE GetLength (IN string : STRING) : INT ;
  
-------------------------------------------------------------------------
-- Insertion and Appending within strings.
-------------------------------------------------------------------------

PROCEDURE InsertString
  (IN string                : STRING,
   IN position              : INT,
   IN string_to_be_inserted : STRING) 
  : STRING ;

PROCEDURE InsertChar
  (IN string              : STRING,
   IN position            : INT,
   IN char_to_be_inserted : CHAR) 
  : STRING ;

PROCEDURE AppendPattern
  (IN string     : STRING,
   IN new_length : INT,
   IN pattern    : CHAR)
  : STRING ;
  
-------------------------------------------------------------------------
-- Removement of strings.
-------------------------------------------------------------------------

PROCEDURE RemoveSubString
  (IN string   : STRING,
   IN position : INT,
   IN length   : INT)
  : STRING ;

PROCEDURE RemoveChar
  (IN string   : STRING,
   IN position : INT)
  : STRING;
  
PROCEDURE RemoveAllPattern
  (IN string  : STRING,
   IN pattern : CHAR)
  : STRING;

-------------------------------------------------------------------------
-- Conversions of strings.
-------------------------------------------------------------------------

PROCEDURE ToUpper (IN string : STRING) : STRING;
PROCEDURE ToLower (IN string : STRING) : STRING;

PROCEDURE CutLeadingBlanks (IN string : STRING) : STRING;
PROCEDURE CutTrailingBlanks (IN string : STRING) : STRING;

-------------------------------------------------------------------------
-- Searching within strings.
-------------------------------------------------------------------------

PROCEDURE GetPosOfSubString
  (IN string         : STRING,
   IN sub_string     : STRING,
   IN after_position : INT)
  : INT;

PROCEDURE GetPosOfChar
  (IN string         : STRING,
   IN pattern        : CHAR,
   IN after_position : INT)
  : INT;

PROCEDURE FirstDifference
  (IN first_string  : STRING,
   IN second_string : STRING)
  : INT;

EXCEPTION PositionIsOutOfRange;
EXCEPTION SubStringIsOutOfRange;

-- ***************************************************************
CONST spec_vid : STRING = 
   "@(#) $__Header$" ;

END SPECIFICATION (* String *);
