(*
-------------------------------------------------------------------------------
-- Name of the source		: Stream.t
-- Author(s)			: Jose Luis Albero
-- Date of creation		: 8/7/93
-- Defined Objects		: Stream 
-- Description of the contents	: Generic object representing a data stream   
-- Document reference		: 
-- Copyright 1993, TAO S.A., Barcelona, Spain
-- This software was produced as part of the ESPRIT project ITHACA-IT.
-------------------------------------------------------------------------------
-- Modification log	:
-- Version	Date	Author	Description
-- ---------- --------- ------- -----------------------------------------------
-------------------------------------------------------------------------------
*)

SPECIFICATION Stream 

EXCEPTION InvalidOpenMode;
EXCEPTION InvalidOperation;

CONST STREAM_READ  : CHAR = 'r';
CONST STREAM_WRITE : CHAR = 'w';

CONST STREAM_START   : INT  = -1;
CONST STREAM_CURRENT : INT  =  0;
CONST STREAM_END     : INT  =  1;

TYPE Stream = OBJECT (IN inMode : CHAR)

--Generic non-instantiable object

PUBLIC
METHOD Read     (INOUT ioBuf : REF ARRAY OF CHAR, IN inBufLen: INT) : INT;
--Reads from Stream into ioBuf characters until 
--   end of Stream encountered,
--or inBufLen characters read.
--ioBuf is then null-terminated. inBufLen+1 must be allocated to ioBuf at least!
--Returns length of returned ioBuf string


METHOD ReadLine (INOUT ioBuf : REF ARRAY OF CHAR, IN inBufLen: INT) : INT;
--Reads from Stream into ioBuf characters until 
--   newline encountered,
--or end of Stream encountered,
--or inBufLen characters read.
--ioBuf is then null-terminated. inBufLen+1 must be allocated to ioBuf at least!
--Returns length of returned ioBuf string

METHOD Write    (IN  inBuf  : REF ARRAY OF CHAR);
--Write null-terminated input string into Stream

METHOD WriteLine(IN  inBuf  : REF ARRAY OF CHAR);
--Write null-terminated input string into Stream, then add newLine to stream

METHOD Seek(IN  inOffset : LONG INT, IN inFrom : INT) : LONG INT;
--Move pointer inOffset number of bytes.
--Pointer is moved from:
--  inFrom=SEEK_SET   from start of stream
--  inFrom=SEEK_CUR   from current position
--  inFrom=SEEK_END   from end of stream
--Method returns resulting pointer offset from start of stream

METHOD SeekLine(IN  inOffset : LONG INT, IN inFrom : INT) : LONG INT;
--Move pointer inOffset number of lines.
--Pointer is moved from:
--  inFrom=SEEK_SET   from start of stream
--  inFrom=SEEK_CUR   from current position
--  inFrom=SEEK_END   from end of stream
--Method returns resulting pointer offset from start of stream

METHOD isValidOperation (IN inOperation : CHAR) : BOOL ;
--Internal method. Invoked by subtypes.

METHOD Close ();
--Close stream. Destroys Stream object.

PROTECTED
STATE
stOpenMode : CHAR;

END OBJECT; -- Stream


END SPECIFICATION;
