-- ***************************************************************
-- CoLibri
-- ---------------------------------------------------------------
--
-- SortedList.cs -- 
-- 
--   Copyright (C) sietec Systemtechnik GmbH & Co OHG 1994
--   All rights reserved
-- 
-- Author          : Lutz Hilken
-- 
-- PURPOSE 
--      This object type realizes the frame for the 'semi-generic' 
--      foundation class SortedList. This class provides the
--      functionality of sorted lists.
--      The strings <ContainerFrame> and <EntryType1> are replaced by a 
--      special tool, which creates a real container type with the
--      features of this skeleton.
--
-- REFER
--      |>Documents with client documentation<|
--
-- ---------------------------------------------------------------
--
-- Created On      : Wed Jan 12 14:57:15 1994
-- Last Modified By: Karl-Heinz Koester
-- Last Modified On: Fri Feb 18 15:00:26 1994
-- Update Count    : 7
-- 
-- ***************************************************************

SPECIFICATION SortedList

IMPORT List FROM List;

TYPE SortedList [EntryType] = List
OBJECT
  (IN less : PROCEDURE (IN EntryType, IN EntryType) : BOOL)

-- -----------------------------------------------------------------
-- General
-- -----------------------------------------------------------------
-- An object of the type List contains a cursor on a list of
-- elements. The elemets are referred by the cursor, which referes
-- to one specific element. This element contains the concrete
-- object and the link mechanism, say the next and previous objects.
-- Contents of the List container is also the number of elements in
-- the list and the beginning and the end of that list. 
-- -----------------------------------------------------------------

PUBLIC
  
PROTECTED
  
STATE

  Less : PROCEDURE (IN EntryType, IN EntryType) : BOOL; 
   -- --------------------------------------------------------------
   -- A boolean predicate to keep this list sorted.
   -- --------------------------------------------------------------

END OBJECT;

-- ***************************************************************
CONST spec_vid : STRING = 
   "@(#) $__Header$" ;

END SPECIFICATION (* SortedList *);
